<div class="github-widget" data-repo="msub2/awesome-webxr"></div>
## Awesome WebXR [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="https://raw.githubusercontent.com/msub2/awesome-webxr/master/webxr-logo.svg?sanitize=true" align="right" width="100">](https://immersiveweb.dev/)

> A curated list of WebXR links and resources.

[WebXR](https://developer.mozilla.org/en-US/docs/Web/API/WebXR_Device_API) comprises a group of standards that allow browsers to access virtual and augmented reality devices, enabling developers to create immersive content that's easily accessible online without the need for installations or storefront curation.



## Standout Projects

*Impressive and notable WebXR projects.*

- [Hello WebXR](https://msub2.github.io/hello-webxr/) - Made to commemorate the release of the WebXR 1.0 API, showcases some of what's possible with WebXR.
  - This links to a mirror of the experience on my own fork, as it is no longer accessible at its original domain.
- [Moonrider](https://moonrider.xyz/) - A rhythm game built by Supermedium similar to Beat Saber.
- [Plockle](https://plockle.com/) - A spatial block puzzle game with over 40 levels.
- [Castle Builder](https://castle.needle.tools/) - A collaborative and cross-platform castle-building game utilizing a unique Unity-to-three.js pipeline.
- [Prehistoric Domain](https://www.prehistoricdomain.com/) - A Jurassic Park-esque experience in the browser, with multiple dinosaur exhibits available and more planned for the future.
- [Above Par-adowski WebXR Mini Golf](https://aboveparadowski.com/) - A WebXR minigolf game designed by Paradowski Creative, featuring 9 holes spread across a unique and varied environment.
- [Yolopia](https://www.yolopia.com/) - A rhythm game which combines flow, boxing and pose matching.
- [f60](https://heyvr.io/game/f60) - A cross-platform WebXR escape room series set within a Soviet prison.
- [The Escape Artist](https://esc.art/) - An award-winning escape room game by Paradowski Creative set inside the mind of an artist, with an overarching narrative about the creative process.

## Art

*Projects centered around artistic creations.*

- [Brushwork VR](https://brushworkvr.com/) - A VR app that simulates the process of painting with a virtual canvas, palette, color mixing, and more.
- [SoulPaint](https://hatsumi.netlify.app/) - A VR app that provides you with 3D drawing tools and a virtual body to illustrate lived experiences.
- [Obscura](https://obscura.world/) - Float around and explore a structure inspired by the architecture of Carlo Scarpa.
- [Silk Brush](https://www.silkbrush.app/) - A port of Tilt Brush to WebXR with plans for future extensions.
- [VARTISTE](https://vartiste.xyz/) - A VR app for 2D drawing and image editing, and 3D model texturing.

## Audio

*Projects centered around audio and audiovisual experiences.*

- [beats](https://beats.gatunes.com/) - A semi-collaborative app with various rooms where anyone can create or modify an existing musical loop.
- [Fathom VR](https://www.letsfathom.com/vr/play) - A WebXR version of the music discovery app Fathom, which lets you search for and explore clouds of related artists with spatialized audio.
- [TRACK](https://demos.littleworkshop.fr/track) - A linear ride through an immersive audiovisual experience developed by [Little Workshop](https://www.littleworkshop.fr/).

## Avatars

*Resources for creating and utilizing 3D avatars in immersive experiences.*

- [Exokit Avatars](https://github.com/exokitxr/avatars) - A web-based avatar system that can load humanoid avatars in multiple different model formats and features arm+leg IK, facial animation via visemes, and more. The original repo is no longer maintained, but there is a more up-to-date fork available [here](https://github.com/msub2/avatars).
- [ReadyPlayerMe](https://readyplayer.me/) - Lets you quickly and easily create a 3D avatar online that you can download in glTF format.
- [VRoid](https://vroid.com/en) - Lets you create anime-styled 3D avatars that export to the highly-compatible .vrm format.

## Communities

*Where WebXR developers gather, ask questions, share projects, etc.*

### Discord

- [Metaverse Makers Discord](https://discord.gg/UgZDFZW) - Official server for M3, the Metaverse Makers Mastermind group.
- [WebXR Discord](https://discord.gg/Jt5tfaM) - Official Discord server for all things WebXR, with over 1000 members.
- [WebXR Francophone Discord](https://discord.gg/JGsaYQJeuM) - French-speaking Discord server for WebXR.
- [Wonderland Engine Discord](https://discord.gg/FE8QnDP) - Wonderland Engine Discord server.
- [XR Foundation Discord](https://discord.gg/Tb4MT4TTjH) - Official server for XR Foundation, responsible for XREngine and various other metaverse-related projects.
- [Zesty Market Discord](https://discord.gg/7d7agTbmKf) - Official server for Zesty Market.

### Facebook

- [Immersive Web](https://www.facebook.com/groups/immersiveweb/) - Oldest WebXR-related group, originally made for WebVR.
- [WebXR](https://www.facebook.com/groups/arvrweb/) - Slightly newer WebXR-centric group.
- [WebXR Korea](https://www.facebook.com/groups/webxrko/) - Korean WebXR group created by Belivvr.
- [WebXR Paris](https://www.facebook.com/groups/548527285323630/) - Companion to the WebXR Paris group on [Meetup](https://www.meetup.com/WebXR-Paris/).

### Forums

- [Babylon.js Forum](https://forum.babylonjs.com/) - Official Babylon.js forum.
- [three.js Forum](https://discourse.threejs.org/) - Official three.js forum.
- [PlayCanvas Forum](https://forum.playcanvas.com/) - Official PlayCanvas forum.
- [WebXR Community Forum](https://www.webxr.community/) - Official forum for all things WebXR. Sister community to the WebXR Discord.

### LinkedIn

- [WebXR](https://www.linkedin.com/groups/9019254/) - WebXR LinkedIn Group

### Reddit

- [r/WebVR](https://www.reddit.com/r/WebVR/) - Initially the main subreddit for WebVR discussion, now features general WebXR content along with [r/WebXR](https://www.reddit.com/r/WebXR/).
- [r/WonderlandEngine](https://www.reddit.com/r/WonderlandEngine/) - Wonderland Engine subreddit.

## Companies and Cooperatives

*Companies and cooperatives centered around/doing work in WebXR.*

- [Active Theory](https://activetheory.net/) - Developed the Dreamwave platform.
- [Aircards](https://www.aircards.co/) - WebAR advertising/marketing agency.
- [Hatsumi](https://www.hatsumivr.com/) - A design studio developing experiences at the intersection of healthcare and art.
- [Immers Space](https://web.immers.space/) - A Distributed Cooperative Organization (DisCO) focused on enabling open and federated immersive web content.
- [Laguna Labs](https://lagunalabs.io/) - Immersive web tech agency.
- [MetaVRse](https://metavrse.com/) - Enterprise-focused metaverse creation company. Parent company of MetaVRse Engine, MetaVRse Studio, and MetaVRse Properties such as TheMall.
- [Playko Software](https://www.playko.com/) - VR/AR/WebXR agency and WebXR game development studio.
- [REM5](https://www.rem5forgood.com/) - Digital immersive experience design studio specializing in education and social equity initiatives.
- [Sketchfab](https://sketchfab.com/) - 3D model marketplace that offers a VR previewer.
- [Vhite Rabbit](https://vhiterabbit.com/) - Parent company behind Construct Arcade.



- [Extended Collection](https://extendedcollection.com/) - A curated library of links to the Immersive Web maintained by [vrhermit](https://vrhermit.com/).
- [heyVR](https://heyvr.io/) - A curated platform for publishing WebXR games.
- [PICO Browser Start Page](https://browser-us.picovr.com/) - The default start page for PICO Browser.
- [Wolvic Start Page](https://wolvic.com/en/start/) - The default start page for the Wolvic browser.

## Development


### Engines

- [iR Engine](https://github.com/ir-engine/ir-engine) - A full stack MMO engine built on three.js and bitECS with support for WebXR.

- [Godot](https://godotengine.org/) - A cross-platform, open-source engine with WebXR support as of version 3.2.4.
  - [Official Documentation](https://docs.godotengine.org/en/stable/classes/class_webxrinterface.html)

- [MetaVRse Engine](https://metavrse.com/engine) - Web-based tool designed to make XR and 3D content creation. No-code/low-code template system, automatic embedding for business and education.
  - [Official Documentation](https://metavrse.com/api/index.html)

- [Needle](https://needle.tools/) - An engine and exporter for Blender and Unity.
  - [Official Documentation](https://engine.needle.tools/docs/)

- [nunuStudio](https://www.nunustudio.org/) - A multiplatform, open-source engine built on three.js that can be used natively or in the browser.
  - [Official Documentation](https://www.nunustudio.org/docs/)
 
- [Onirix Studio](https://www.onirix.com/) - A no-code editor for creating Web AR experiences in the browser. It emulates features of the WebXR if target device / browser is not compatible.

- [PlayCanvas](https://playcanvas.com/) - A browser-based WebGL engine with support for WebXR content, mobile browsers, collaborative editing, and more.
  - [Official Documentation](https://developer.playcanvas.com/en/)

- [Rogue Engine](https://rogueengine.io/) - An HTML5 Game Engine based on Three.js and TypeScript.
  - [Official Documentation](https://rogueengine.io/docs/manual/getting-started/installation/) 
  
- [Unity](https://unity.com/) - A highly popular game engine with community packages that enable content to be exported for WebXR.
  - [WebXR Export](https://github.com/De-Panther/unity-webxr-export) - Exporter by [De-Panther](https://github.com/De-Panther/)
  - [SimpleWebXR](https://github.com/Rufus31415/Simple-WebXR-Unity) - Exporter by [Rufus31415](https://github.com/Rufus31415)

- [Wonderland Engine](https://wonderlandengine.com/) - A development platform designed specifically for building WebXR applications.
  - [Official Documentation](https://wonderlandengine.com/documentation/)

### Frameworks and Libraries

- [A-Frame](https://aframe.io/) - Lets you create VR experiences using declarative HTML and custom JavaScript components built on top of three.js.
  - [Official Documentation](https://aframe.io/docs/)

- [Babylon.js](https://www.babylonjs.com/) - A powerful and feature-rich rendering engine packaged into a JavaScript framework.
  - [Official Documentation](https://doc.babylonjs.com/)

- [JanusWeb](https://github.com/jbaicoianu/janusweb) - An in-browser implementation of JanusVR that lets you build social VR experiences.

- [JSAR-DOM](https://github.com/M-CreativeLab/jsar-dom) A TypeScript re-implementation of WHATWG DOM, CSSOM and WebXR for XR applications built on top of Babylon.js.

- [p5.xr](https://p5xr.org/) - An add-on for the library p5.js that allows you to create immersive p5 sketches.

- [react-three-fiber](https://github.com/pmndrs/react-three-fiber) - A React renderer for three.js. Additional WebXR-specific hooks and components are available in [React XR](https://github.com/pmndrs/react-xr) as well.

- [three.js](https://threejs.org/) - A JavaScript library for rendering 3D content with WebGL that powers many existing WebXR experiences and tools.
  - [Official Documentation](https://threejs.org/docs/index.html#manual/en/introduction/Creating-a-scene)

- [Threlte](https://threlte.xyz/) - A Svelte renderer and component library for three.js. WebXR-specific hooks and components are available in the [`@threlte/xr` package](https://threlte.xyz/docs/reference/xr/getting-started).

- [X3DOM](https://x3dom.org) - A framework for integrating and manipulating X3D scenes as HTML5/DOM elements.
  - [Official Documentation](https://doc.x3dom.org/)

### Other

- [Verge3D](https://www.soft8soft.com/verge3d/) - A toolkit that allows 3D artists to export their scenes and create immersive web experiences with ease.
  - [Official Documentation](https://www.soft8soft.com/support-documentation/)
- [XR Fragments](https://xrfragment.org) - A tiny specification for controlling any 3D model using URLs, based on existing metadata. Promoting hyperlinked WebXR storytelling using all 3D editors and viewers.

## Learning Resources


- [Learn A-Frame (VR)](https://www.codecademy.com/learn/learn-a-frame) - A roughly 6-hour Codecademy course written in partnership with A-Frame.
- [babylon.js Guided Learning](https://doc.babylonjs.com/guidedLearning) - Detailed text and video tutorials that complement the other instructional pages in the documentation.

## Monetization


- [Zesty Market](https://www.zesty.market) - A marketplace for rentable banner spaces in XR. Offers integrations with most major WebXR creation tools.

## Social Spaces

*Projects focused on creating social spaces for users to gather and/or collaborate in.*

- [Dreamwave](https://dreamwave.tech/) - A web-based platform for hosting scalable virtual events. Powered the virtual music festival Secret Sky 2021.
- [Emerald City](https://hubculture.city/) - A virtual event space developed by Hub Culture.
- [FRAME](https://framevr.io/) - A platform focused on enabling easy 3D collaborations in a virtual space.
- [Hubs](https://hubsfoundation.org/) - A community-owned platform for enabling users to gather and collaborate virtually, initially created by Mozilla.

## Web3XR

*Projects at the intersection of WebXR and crypto/blockchain technologies.*

### Galleries

- [3XR](https://www.3xr.space/) - A project by [microchipgnu](https://github.com/microchipgnu) that has integrated with Mintbase to create virtual galleries for NFT artwork on NEAR.
- [glry.xyz](https://glry.xyz/) - A site that hosts virtual galleries for NFT art on the Tezos blockchain.
- [oncyber](https://oncyber.io/) - Offers both free and collectible gallery spaces to display NFTs across multiple different chains.

### Realms

- [Voxels](https://www.voxels.com/) - A virtual world powered by Ethereum where players can buy land, build stores, display art, and more.
- [Hyperfy](https://hyperfy.io/) - A platform hosting up to 10,000 customizable, cross-platform, and immersive virtual worlds. Built on three.js, powered by Ethereum.
- [Ozone Metaverse](https://ozonemetaverse.io/) - A spatial computing cloud platform offering world creation tools with Web3 integrations and monetization.
- [Somnium Space Web](https://somniumspace.com/parcel/) - A web viewer that allows you to explore parcels from [Somnium Space](https://www.somniumspace.com/) in your browser, with VR support on the Oculus Quest browser.
- [vrland](https://vrland.io/) - A platform for gathering and virtual showcases that supports displaying of NFTs.

## YouTube

*YouTube channels with a heavy focus on WebXR.*

- [M3](https://www.youtube.com/channel/UCSNCMWhEojiVjUySdI7J_wg) - Official M3 channel.
- [Sorskoot](https://youtube.com/sorskoot) - Tutorials and other WebXR related content.
- [WebXR](https://www.youtube.com/c/WebXR) - Official WebXR channel.
- [WebXR Summit Series](https://www.youtube.com/channel/UCM5HgDdpKgMejq5HX9EoGHg) - Contains clips, VODs, and other videos from the WebXR Summit Series.
- [Wonderland Engine](https://www.youtube.com/channel/UCgaPCwqmAmre7mW0J7K8IkA) - Official Wonderland Engine channel.
