<div class="github-widget" data-repo="qazbnm456/awesome-web-security"></div>
## Awesome Web Security [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[<img src="https://upload.wikimedia.org/wikipedia/commons/6/61/HTML5_logo_and_wordmark.svg" align="right" width="70">](https://www.w3.org/TR/html5/)

&gt; 网络安全材料和资源的精选列表.

不用说，大多数网站都存在各种类型的错误，这些错误最终可能会导致漏洞. 为什么这种情况会经常发生？ 可能涉及许多因素，包括配置错误、工程师安全技能不足等.为了解决这个问题，这里列出了用于学习尖端渗透技术的网络安全材料和资源的精选列表，我强烈建议您阅读这篇文章“[So you want to be a web security researcher?](https://portswigger.net/blog/so-you-want-to-be-a-web-security-researcher)“ 第一的.

*请阅读 [contribution guidelines](https://github.com/qazbnm456/awesome-web-security/blob/master/CONTRIBUTING.md) 在贡献之前.*

---

<p align="center">想加强你的渗透技巧吗？<br> 我建议玩一些<a href="https://github.com/apsdehal/awesome-ctf" target="_blank">awesome-ctf</a> .</p>

---

如果您喜欢这个很棒的列表并愿意支持它，请查看我 [Patreon](https://www.patreon.com/boik) 页 ：）<br> 另外，别忘了查看我 [repos](https://github.com/qazbnm456) 或者对我说 *hi* [Twitter](https://twitter.com/qazbnm456)!



## Digests

- [Hacker101](https://www.hacker101.com/) - 撰写者 [hackerone](https://www.hackerone.com/start-hacking).
- [The Daily Swig - Web security digest](https://portswigger.net/daily-swig) - 撰写者 [PortSwigger](https://portswigger.net/).
- [Web Application Security Zone by Netsparker](https://www.netsparker.com/blog/web-security/) - 撰写者 [Netsparker](https://www.netsparker.com/).
- [Infosec Newbie](https://www.sneakymonkey.net/2017/04/23/infosec-newbie/) - 撰写者 [Mark Robinson](https://www.sneakymonkey.net/).
- [The Magic of Learning](https://bitvijays.github.io/) - 撰写者 [@bitvijays](https://bitvijays.github.io/aboutme.html).
- [CTF Field Guide](https://trailofbits.github.io/ctf/) - 撰写者 [Trail of Bits](https://www.trailofbits.com/).
- [PayloadsAllTheThings](https://github.com/swisskyrepo/PayloadsAllTheThings/) - 撰写者 [@swisskyrepo](https://github.com/swisskyrepo).
- [tl;dr sec](https://tldrsec.com/) - 顶级安全工具、博客文章和安全研究的每周摘要.

## Forums

- [Phrack Magazine](http://www.phrack.org/) - 由黑客编写并为黑客编写的电子杂志.
- [The Hacker News](https://thehackernews.com/) - 认真对待安全.
- [Security Weekly](https://securityweekly.com/) - 安全播客网络.
- [The Register](http://www.theregister.co.uk/) - 咬住养活 IT 的手.
- [Dark Reading](https://www.darkreading.com/Default.asp) - 连接信息安全社区.
- [HackDig](http://en.hackdig.com/) - 为黑客挖掘高质量的网络安全文章.

<a name="intro"></a>
## Introduction

<a name="xss"></a>
### XSS - Cross-Site Scripting

- [Cross-Site Scripting – Application Security – Google](https://www.google.com/intl/sw/about/appsecurity/learning/xss/) - 撰写者 [Google](https://www.google.com/).
- [H5SC](https://github.com/cure53/H5SC) - 撰写者 [@cure53](https://github.com/cure53).
- [AwesomeXSS](https://github.com/s0md3v/AwesomeXSS) - 撰写者 [@s0md3v](https://github.com/s0md3v).
- [XSS.png](https://github.com/LucaBongiorni/XSS.png) - 由@jackmasa 撰写.
- [C.XSS Guide](https://excess-xss.com/) - 撰写者 [@JakobKallin](https://github.com/JakobKallin) 和 [Irene Lobo Valbuena](https://www.linkedin.com/in/irenelobovalbuena/).
- [THE BIG BAD WOLF - XSS AND MAINTAINING ACCESS](http://www.paulosyibelo.com/2018/06/the-big-bad-wolf-xss-and-maintaining.html) - 撰写者 [Paulos Yibelo](http://www.paulosyibelo.com/).
- [payloadbox/xss-payload-list](https://github.com/payloadbox/xss-payload-list) - 撰写者 [@payloadbox](https://github.com/payloadbox).
- [PayloadsAllTheThings - XSS Injection](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/XSS%20Injection) - 撰写者 [@swisskyrepo](https://github.com/swisskyrepo).

<a name="prototype-pollution"></a>
### Prototype Pollution

- [Prototype pollution attack in NodeJS application](https://github.com/HoLyVieR/prototype-pollution-nsec18/blob/master/paper/JavaScript_prototype_pollution_attack_in_NodeJS.pdf) - 撰写者 [@HoLyVieR](https://github.com/HoLyVieR).
- [Exploiting prototype pollution – RCE in Kibana (CVE-2019-7609)](https://research.securitum.com/prototype-pollution-rce-kibana-cve-2019-7609/) - 撰写者 [@securitymb](https://twitter.com/securitymb).
- [Real-world JS - 1](https://blog.p6.is/Real-World-JS-1/) - 撰写者 [@po6ix](https://twitter.com/po6ix).

<a name="csv-injection"></a>
### CSV Injection

- [CSV Injection -> Meterpreter on Pornhub](https://news.webamooz.com/wp-content/uploads/bot/offsecmag/147.pdf) - 撰写者 [Andy](https://blog.zsec.uk/).
- [The Absurdly Underestimated Dangers of CSV Injection](http://georgemauer.net/2017/10/07/csv-injection.html) - 撰写者 [George Mauer](http://georgemauer.net/).
- [PayloadsAllTheThings - CSV Injection](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/CSV%20Injection) - 撰写者 [@swisskyrepo](https://github.com/swisskyrepo).

<a name="sql-injection"></a>
### SQL Injection

- [SQL Injection Cheat Sheet](https://www.netsparker.com/blog/web-security/sql-injection-cheat-sheet/) - 撰写者 [@netsparker](https://twitter.com/netsparker).
- [SQL Injection Wiki](https://sqlwiki.netspi.com/) - 撰写者 [NETSPI](https://www.netspi.com/).
- [SQL Injection Pocket Reference](https://websec.ca/kb/sql_injection) - 撰写者 [@LightOS](https://twitter.com/LightOS).
- [payloadbox/sql-injection-payload-list](https://github.com/payloadbox/sql-injection-payload-list) - 撰写者 [@payloadbox](https://github.com/payloadbox).
- [PayloadsAllTheThings - SQL Injection](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/SQL%20Injection) - 撰写者 [@swisskyrepo](https://github.com/swisskyrepo).

<a name="command-injection"></a>
### Command Injection

- [Potential command injection in resolv.rb](https://github.com/ruby/ruby/pull/1777) - 撰写者 [@drigg3r](https://github.com/drigg3r).
- [payloadbox/command-injection-payload-list](https://github.com/payloadbox/command-injection-payload-list) - 撰写者 [@payloadbox](https://github.com/payloadbox).
- [PayloadsAllTheThings - Command Injection](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/Command%20Injection) - 撰写者 [@swisskyrepo](https://github.com/swisskyrepo).

<a name="orm-injection"></a>
### ORM Injection

- [HQL for pentesters](http://blog.h3xstream.com/2014/02/hql-for-pentesters.html) - 撰写者 [@h3xstream](https://twitter.com/h3xstream/).
- [HQL : Hyperinsane Query Language (or how to access the whole SQL API within a HQL injection ?)](https://www.synacktiv.com/ressources/hql2sql_sstic_2015_en.pdf) - 撰写者 [@_m0bius](https://twitter.com/_m0bius).
- [ORM2Pwn: Exploiting injections in Hibernate ORM](https://www.slideshare.net/0ang3el/orm2pwn-exploiting-injections-in-hibernate-orm) - 撰写者 [Mikhail Egorov](https://0ang3el.blogspot.tw/).
- [ORM Injection](https://www.slideshare.net/simone.onofri/orm-injection) - 撰写者 [Simone Onofri](https://onofri.org/).

<a name="ftp-injection"></a>
### FTP Injection

- [Advisory: Java/Python FTP Injections Allow for Firewall Bypass](http://blog.blindspotsecurity.com/2017/02/advisory-javapython-ftp-injections.html) - 撰写者 [Timothy Morgan](https://plus.google.com/105917618099766831589).
- [SMTP over XXE − how to send emails using Java's XML parser](https://shiftordie.de/blog/2017/02/18/smtp-over-xxe/) - 撰写者 [Alexander Klink](https://shiftordie.de/).

<a name="xxe"></a>
### XXE - XML eXternal Entity

- [XXE](https://phonexicum.github.io/infosec/xxe.html) - 撰写者 [@phonexicum](https://twitter.com/phonexicum).
- [XML external entity (XXE) injection](https://portswigger.net/web-security/xxe) - 撰写者 [portswigger](https://portswigger.net/).
- [XML Schema, DTD, and Entity Attacks](https://www.vsecurity.com/download/publications/XMLDTDEntityAttacks.pdf) - 撰写者 [Timothy D. Morgan](https://twitter.com/ecbftw) 和奥马尔·易卜拉欣.
- [payloadbox/xxe-injection-payload-list](https://github.com/payloadbox/xxe-injection-payload-list) - 撰写者 [@payloadbox](https://github.com/payloadbox)
- [PayloadsAllTheThings - XXE Injection](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/XXE%20Injection) - 由各种贡献者撰写.

<a name="csrf"></a>
### CSRF - Cross-Site Request Forgery

- [Wiping Out CSRF](https://medium.com/@jrozner/wiping-out-csrf-ded97ae7e83f) - 撰写者 [@jrozner](https://medium.com/@jrozner).
- [PayloadsAllTheThings - CSRF Injection](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/CSRF%20Injection) - 撰写者 [@swisskyrepo](https://github.com/swisskyrepo).

<a name="clickjacking"></a>
### Clickjacking

- [Clickjacking](https://www.imperva.com/learn/application-security/clickjacking/) - 撰写者 [Imperva](https://www.imperva.com/).
- [X-Frame-Options: All about Clickjacking?](https://github.com/cure53/Publications/blob/master/xfo-clickjacking.pdf?raw=true) - 撰写者 [Mario Heiderich](http://www.slideshare.net/x00mario).

<a name="ssrf"></a>
### SSRF - Server-Side Request Forgery

- [SSRF bible. Cheatsheet](https://docs.google.com/document/d/1v1TkWZtrhzRLy0bYXBcdLUedXGb9njTNIJXa3u9akHM/edit) - 撰写者 [Wallarm](https://wallarm.com/).
- [PayloadsAllTheThings - Server-Side Request Forgery](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/Server%20Side%20Request%20Forgery) - 撰写者 [@swisskyrepo](https://github.com/swisskyrepo).

<a name="web-cache-poisoning"></a>
### Web Cache Poisoning

- [Practical Web Cache Poisoning](https://portswigger.net/blog/practical-web-cache-poisoning) - 撰写者 [@albinowax](https://twitter.com/albinowax).
- [PayloadsAllTheThings - Web Cache Deception](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/Web%20Cache%20Deception) - 撰写者 [@swisskyrepo](https://github.com/swisskyrepo).

<a name="relative-path-overwrite"></a>
### Relative Path Overwrite

- [Large-scale analysis of style injection by relative path overwrite](https://blog.acolyer.org/2018/05/28/large-scale-analysis-of-style-injection-by-relative-path-overwrite/) - 撰写者 [The Morning Paper](https://blog.acolyer.org/).
- [MBSD Technical Whitepaper - A few RPO exploitation techniques](https://www.mbsd.jp/Whitepaper/rpo.pdf) - 撰写者 [Mitsui Bussan Secure Directions, Inc.](https://www.mbsd.jp/).

<a name="open-redirect"></a>
### Open Redirect

- [Open Redirect Vulnerability](https://s0cket7.com/open-redirect-vulnerability/) - 撰写者 [s0cket7](https://s0cket7.com/).
- [payloadbox/open-redirect-payload-list](https://github.com/payloadbox/open-redirect-payload-list) - 撰写者 [@payloadbox](https://github.com/payloadbox).
- [PayloadsAllTheThings - Open Redirect](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/Open%20Redirect) - 撰写者 [@swisskyrepo](https://github.com/swisskyrepo).

<a name="saml"></a>
### Security Assertion Markup Language (SAML)

- [How to Hunt Bugs in SAML; a Methodology - Part I](https://epi052.gitlab.io/notes-to-self/blog/2019-03-07-how-to-test-saml-a-methodology/) - 撰写者 [epi](https://epi052.gitlab.io/notes-to-self/).
- [How to Hunt Bugs in SAML; a Methodology - Part II](https://epi052.gitlab.io/notes-to-self/blog/2019-03-13-how-to-test-saml-a-methodology-part-two/) - 撰写者 [epi](https://epi052.gitlab.io/notes-to-self/).
- [How to Hunt Bugs in SAML; a Methodology - Part III](https://epi052.gitlab.io/notes-to-self/blog/2019-03-16-how-to-test-saml-a-methodology-part-three/) - 撰写者 [epi](https://epi052.gitlab.io/notes-to-self/).
- [PayloadsAllTheThings - SAML Injection](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/SAML%20Injection) - 撰写者 [@swisskyrepo](https://github.com/swisskyrepo).

<a name="upload"></a>
### Upload

- [File Upload Restrictions Bypass](https://www.exploit-db.com/docs/english/45074-file-upload-restrictions-bypass.pdf) - 撰写者 [Haboob Team](https://www.exploit-db.com/author/?a=9381).
- [PayloadsAllTheThings - Upload Insecure Files](https://github.com/swisskyrepo/PayloadsAllTheThings/tree/master/Upload%20Insecure%20Files) - 撰写者 [@swisskyrepo](https://github.com/swisskyrepo).

<a name="rails"></a>
### Rails

- [Rails Security - First part](https://hackmd.io/s/SkuTVw5O-) - 撰写者 [@qazbnm456](https://github.com/qazbnm456).
- [Zen Rails Security Checklist](https://github.com/brunofacca/zen-rails-security-checklist) - 撰写者 [@brunofacca](https://github.com/brunofacca).
- [Rails SQL Injection](https://rails-sqli.org) - 撰写者 [@presidentbeef](https://github.com/presidentbeef).
- [Official Rails Security Guide](http://guides.rubyonrails.org/security.html) - 撰写者 [Rails team](https://rubyonrails.org/).

<a name="angularjs"></a>
### AngularJS

- [XSS without HTML: Client-Side Template Injection with AngularJS](http://blog.portswigger.net/2016/01/xss-without-html-client-side-template.html) - 撰写者 [Gareth Heyes](https://www.blogger.com/profile/10856178524811553475).
- [DOM based Angular sandbox escapes](http://blog.portswigger.net/2017/05/dom-based-angularjs-sandbox-escapes.html) - 撰写者 [@garethheyes](https://twitter.com/garethheyes)

<a name="reactjs"></a>
### ReactJS

- [XSS via a spoofed React element](http://danlec.com/blog/xss-via-a-spoofed-react-element) - 撰写者 [Daniel LeCheminant](http://danlec.com/).

<a name="ssl-tls"></a>
### SSL/TLS

- [SSL & TLS Penetration Testing](https://www.aptive.co.uk/blog/tls-ssl-security-testing/) - 撰写者 [APTIVE](https://www.aptive.co.uk/).
- [Practical introduction to SSL/TLS](https://github.com/Hakky54/mutual-tls-ssl) - 撰写者 [@Hakky54](https://github.com/Hakky54).

<a name="webmail"></a>
### Webmail

- [Why mail() is dangerous in PHP](https://blog.ripstech.com/2017/why-mail-is-dangerous-in-php/) - 撰写者 [Robin Peraglie](https://www.ripstech.com/).

<a name="nfs"></a>
### NFS

- [NFS | PENETRATION TESTING ACADEMY](https://pentestacademy.wordpress.com/2017/09/20/nfs/?t=1&cn=ZmxleGlibGVfcmVjc18y&refsrc=email&iid=b34422ce15164e99a193fea0ccc7a02f&uid=1959680352&nid=244+289476616) - 撰写者 [PENETRATION ACADEMY](https://pentestacademy.wordpress.com/).

<a name="aws"></a>
### AWS

- [PENETRATION TESTING AWS STORAGE: KICKING THE S3 BUCKET](https://rhinosecuritylabs.com/penetration-testing/penetration-testing-aws-storage/) - 德怀特·霍恩斯坦 (Dwight Hohnstein) 从 [Rhino Security Labs](https://rhinosecuritylabs.com/).
- [AWS PENETRATION TESTING PART 1. S3 BUCKETS](https://www.virtuesecurity.com/aws-penetration-testing-part-1-s3-buckets/) - 撰写者 [VirtueSecurity](https://www.virtuesecurity.com/).
- [AWS PENETRATION TESTING PART 2. S3, IAM, EC2](https://www.virtuesecurity.com/aws-penetration-testing-part-2-s3-iam-ec2/) - 撰写者 [VirtueSecurity](https://www.virtuesecurity.com/).
- [Misadventures in AWS](https://labs.f-secure.com/blog/misadventures-in-aws) - 克里斯蒂安·德姆科 (Christian Demko) 撰写

<a name="azure"></a>
### Azure

- [Common Azure Security Vulnerabilities and Misconfigurations](https://rhinosecuritylabs.com/cloud-security/common-azure-security-vulnerabilities/) - 撰写者 [@rhinobenjamin](https://twitter.com/rhinobenjamin).
- [Cloud Security Risks (Part 1): Azure CSV Injection Vulnerability](https://rhinosecuritylabs.com/azure/cloud-security-risks-part-1-azure-csv-injection-vulnerability/) - 撰写者 [@spengietz](https://twitter.com/spengietz).

<a name="fingerprint"></a>
### Fingerprint

<a name="sub-domain-enumeration"></a>
### Sub Domain Enumeration

- [A penetration tester’s guide to sub-domain enumeration](https://blog.appsecco.com/a-penetration-testers-guide-to-sub-domain-enumeration-7d842d5570f6) - 撰写者 [Bharath](https://blog.appsecco.com/@yamakira_).
- [The Art of Subdomain Enumeration](https://blog.sweepatic.com/art-of-subdomain-enumeration/) - 撰写者 [Patrik Hudak](https://blog.sweepatic.com/author/patrik/).

<a name="crypto"></a>
### Crypto

- [Applied Crypto Hardening](https://bettercrypto.org/) - 撰写者 [The bettercrypto.org Team](https://bettercrypto.org/).
- [What is a Side-Channel Attack ?](https://www.csoonline.com/article/3388647/what-is-a-side-channel-attack-how-these-end-runs-around-encryption-put-everyone-at-risk.html) - 撰写者 [J.M Porup](https://www.csoonline.com/author/J.M.-Porup/).

<a name="web-shell"></a>
### Web Shell

- [Hunting for Web Shells](https://www.tenable.com/blog/hunting-for-web-shells) - 撰写者 [Jacob Baines](https://www.tenable.com/profile/jacob-baines).
- [Hacking with JSP Shells](https://blog.netspi.com/hacking-with-jsp-shells/) - 撰写者 [@_nullbind](https://twitter.com/_nullbind).

<a name="osint"></a>
### OSINT

- [Hacking Cryptocurrency Miners with OSINT Techniques](https://medium.com/@s3yfullah/hacking-cryptocurrency-miners-with-osint-techniques-677bbb3e0157) - 撰写者 [@s3yfullah](https://medium.com/@s3yfullah).
- [OSINT x UCCU Workshop on Open Source Intelligence](https://www.slideshare.net/miaoski/osint-x-uccu-workshop-on-open-source-intelligence) - 撰写者 [Philippe Lin](https://www.slideshare.net/miaoski).
- [102 Deep Dive in the Dark Web OSINT Style Kirby Plessas](https://www.youtube.com/watch?v=fzd3zkAI_o4) - 提出者 [@kirbstr](https://twitter.com/kirbstr).
- [The most complete guide to finding anyone’s email](https://www.blurbiz.io/blog/the-most-complete-guide-to-finding-anyones-email) - 撰写者 [Timur Daudpota](https://www.blurbiz.io/).

<a name="dns-rebinding"></a>
### DNS Rebinding

- [Attacking Private Networks from the Internet with DNS Rebinding](https://medium.com/@brannondorsey/attacking-private-networks-from-the-internet-with-dns-rebinding-ea7098a2d325) - 撰写者 [@brannondorsey](https://medium.com/@brannondorsey)
- [Hacking home routers from the Internet](https://medium.com/@radekk/hackers-can-get-access-to-your-home-router-1ddadd12a7a7) - 撰写者 [@radekk](https://medium.com/@radekk)

<a name="deserialization"></a>
### Deserialization

- [What Do WebLogic, WebSphere, JBoss, Jenkins, OpenNMS, and Your Application Have in Common? This Vulnerability.](https://foxglovesecurity.com/2015/11/06/what-do-weblogic-websphere-jboss-jenkins-opennms-and-your-application-have-in-common-this-vulnerability/) - 撰写者 [@breenmachine](https://twitter.com/breenmachine).
- [Attacking .NET deserialization](https://www.youtube.com/watch?v=eDfGpu3iE4Q) - 撰写者 [@pwntester](https://twitter.com/pwntester).
- [.NET Roulette: Exploiting Insecure Deserialization in Telerik UI](https://www.youtube.com/watch?v=--6PiuvBGAU) - 撰写者 [@noperator](https://twitter.com/noperator).
- [How to exploit the DotNetNuke Cookie Deserialization](https://pentest-tools.com/blog/exploit-dotnetnuke-cookie-deserialization/) - 撰写者 [CRISTIAN CORNEA](https://pentest-tools.com/blog/author/pentest-cristian/).
- [HOW TO EXPLOIT LIFERAY CVE-2020-7961 : QUICK JOURNEY TO POC](https://www.synacktiv.com/en/publications/how-to-exploit-liferay-cve-2020-7961-quick-journey-to-poc.html) - 撰写者 [@synacktiv](https://twitter.com/synacktiv).

<a name="oauth"></a>
### OAuth

- [Introduction to OAuth 2.0 and OpenID Connect](https://pragmaticwebsecurity.com/courses/introduction-oauth-oidc.html) - 撰写者 [@PhilippeDeRyck](https://twitter.com/PhilippeDeRyck).
- [What is going on with OAuth 2.0? And why you should not use it for authentication.](https://medium.com/securing/what-is-going-on-with-oauth-2-0-and-why-you-should-not-use-it-for-authentication-5f47597b2611) - 撰写者 [@damianrusinek](https://medium.com/@damianrusinek).

<a name="jwt"></a>
### JWT

- [Hardcoded secrets, unverified tokens, and other common JWT mistakes](https://r2c.dev/blog/2020/hardcoded-secrets-unverified-tokens-and-other-common-jwt-mistakes/) - 撰写者 [@ermil0v](https://twitter.com/ermil0v).

## Evasions

<a name="evasions-xxe"></a>
### XXE

- [Bypass Fix of OOB XXE Using Different encoding](https://twitter.com/SpiderSec/status/1191375472690528256) - 撰写者 [@SpiderSec](https://twitter.com/SpiderSec).

<a name="evasions-csp"></a>
### CSP

- [Any protection against dynamic module import?](https://github.com/w3c/webappsec-csp/issues/243) - 撰写者 [@shhnjk](https://twitter.com/@shhnjk).
- [CSP: bypassing form-action with reflected XSS](https://labs.detectify.com/2016/04/04/csp-bypassing-form-action-with-reflected-xss/) - 撰写者 [Detectify Labs](https://labs.detectify.com/).
- [TWITTER XSS + CSP BYPASS](http://www.paulosyibelo.com/2017/05/twitter-xss-csp-bypass.html) - 撰写者 [Paulos Yibelo](http://www.paulosyibelo.com/).
- [Neatly bypassing CSP](https://lab.wallarm.com/how-to-trick-csp-in-letting-you-run-whatever-you-want-73cb5ff428aa) - 撰写者 [Wallarm](https://wallarm.com/).
- [Evading CSP with DOM-based dangling markup](https://portswigger.net/blog/evading-csp-with-dom-based-dangling-markup) - 撰写者 [portswigger](https://portswigger.net/).
- [GitHub's CSP journey](https://githubengineering.com/githubs-csp-journey/) - 撰写者 [@ptoomey3](https://github.com/ptoomey3).
- [GitHub's post-CSP journey](https://githubengineering.com/githubs-post-csp-journey/) - 撰写者 [@ptoomey3](https://github.com/ptoomey3).

<a name="evasions-waf"></a>
### WAF

- [Web Application Firewall (WAF) Evasion Techniques](https://medium.com/secjuice/waf-evasion-techniques-718026d693d8) - 撰写者 [@secjuice](https://twitter.com/secjuice).
- [Web Application Firewall (WAF) Evasion Techniques #2](https://medium.com/secjuice/web-application-firewall-waf-evasion-techniques-2-125995f3e7b0) - 撰写者 [@secjuice](https://twitter.com/secjuice).
- [Airbnb – When Bypassing JSON Encoding, XSS Filter, WAF, CSP, and Auditor turns into Eight Vulnerabilities](https://buer.haus/2017/03/08/airbnb-when-bypassing-json-encoding-xss-filter-waf-csp-and-auditor-turns-into-eight-vulnerabilities/) - 撰写者 [@Brett Buerhaus](https://twitter.com/bbuerhaus).
- [How to bypass libinjection in many WAF/NGWAF](https://medium.com/@d0znpp/how-to-bypass-libinjection-in-many-waf-ngwaf-1e2513453c0f) - 撰写者 [@d0znpp](https://medium.com/@d0znpp).

<a name="evasions-jsmvc"></a>
### JSMVC

- [JavaScript MVC and Templating Frameworks](http://www.slideshare.net/x00mario/jsmvcomfg-to-sternly-look-at-javascript-mvc-and-templating-frameworks) - 撰写者 [Mario Heiderich](http://www.slideshare.net/x00mario).

<a name="evasions-authentication"></a>
### Authentication

- [Trend Micro Threat Discovery Appliance - Session Generation Authentication Bypass (CVE-2016-8584)](http://blog.malerisch.net/2017/04/trend-micro-threat-discovery-appliance-session-generation-authentication-bypass-cve-2016-8584.html) - 撰写者 [@malerisch](https://twitter.com/malerisch) 和 [@steventseeley](https://twitter.com/steventseeley).

## Tricks

<a name="tricks-csrf"></a>
### CSRF

- [Neat tricks to bypass CSRF-protection](https://zhuanlan.zhihu.com/p/32716181) - 撰写者 [Twosecurity](https://twosecurity.io/).
- [Exploiting CSRF on JSON endpoints with Flash and redirects](https://blog.appsecco.com/exploiting-csrf-on-json-endpoints-with-flash-and-redirects-681d4ad6b31b) - 撰写者 [@riyazwalikar](https://blog.appsecco.com/@riyazwalikar).
- [Stealing CSRF tokens with CSS injection (without iFrames)](https://github.com/dxa4481/cssInjection) - 撰写者 [@dxa4481](https://github.com/dxa4481).
- [Cracking Java’s RNG for CSRF - Javax Faces and Why CSRF Token Randomness Matters](https://blog.securityevaluators.com/cracking-javas-rng-for-csrf-ea9cacd231d2) - 撰写者 [@rramgattie](https://blog.securityevaluators.com/@rramgattie).
- [If HttpOnly You Could Still CSRF… Of CORS you can!](https://medium.com/@_graphx/if-httponly-you-could-still-csrf-of-cors-you-can-5d7ee2c7443) - 撰写者 [@GraphX](https://twitter.com/GraphX).

<a name="tricks-clickjacking"></a>
### Clickjacking

- [Clickjackings in Google worth 14981.7$](https://medium.com/@raushanraj_65039/google-clickjacking-6a04132b918a) - 撰写者 [@raushanraj_65039](https://medium.com/@raushanraj_65039).

<a name="tricks-rce"></a>
### Remote Code Execution

- [CVE-2019-1306: ARE YOU MY INDEX?](https://www.thezdi.com/blog/2019/10/23/cve-2019-1306-are-you-my-index) - 撰写者 [@yu5k3](https://twitter.com/yu5k3).
- [WebLogic RCE (CVE-2019-2725) Debug Diary](https://paper.seebug.org/910/) - 由 Badcode@Knownsec 404 团队撰写.
- [What Do WebLogic, WebSphere, JBoss, Jenkins, OpenNMS, and Your Application Have in Common? This Vulnerability.](https://foxglovesecurity.com/2015/11/06/what-do-weblogic-websphere-jboss-jenkins-opennms-and-your-application-have-in-common-this-vulnerability/) - 撰写者 [@breenmachine](https://twitter.com/@breenmachine).
- [Exploiting Node.js deserialization bug for Remote Code Execution](https://opsecx.com/index.php/2017/02/08/exploiting-node-js-deserialization-bug-for-remote-code-execution/) - 撰写者 [OpSecX](https://opsecx.com/index.php/author/ajinabraham/).
- [DRUPAL 7.X SERVICES MODULE UNSERIALIZE() TO RCE](https://www.ambionics.io/blog/drupal-services-module-rce) - 撰写者 [Ambionics Security](https://www.ambionics.io/).
- [How we exploited a remote code execution vulnerability in math.js](https://capacitorset.github.io/mathjs/) - 撰写者 [@capacitorset](https://github.com/capacitorset).
- [GitHub Enterprise Remote Code Execution](http://exablue.de/blog/2017-03-15-github-enterprise-remote-code-execution.html) - 撰写者 [@iblue](https://github.com/iblue).
- [Evil Teacher: Code Injection in Moodle](https://blog.ripstech.com/2018/moodle-remote-code-execution/) - 撰写者 [RIPS Technologies](https://www.ripstech.com/).
- [How I Chained 4 vulnerabilities on GitHub Enterprise, From SSRF Execution Chain to RCE!](http://blog.orange.tw/2017/07/how-i-chained-4-vulnerabilities-on.html) - 撰写者 [Orange](http://blog.orange.tw/).
- [$36k Google App Engine RCE](https://sites.google.com/site/testsitehacking/-36k-google-app-engine-rce) - 撰写者 [Ezequiel Pereira](https://sites.google.com/site/testsitehacking/).
- [Poor RichFaces](https://codewhitesec.blogspot.com/2018/05/poor-richfaces.html) - 撰写者 [CODE WHITE](https://www.code-white.com/).
- [Remote Code Execution on a Facebook server](https://blog.scrt.ch/2018/08/24/remote-code-execution-on-a-facebook-server/) - 撰写者 [@blaklis_](https://twitter.com/blaklis_).

<a name="tricks-xss"></a>
### XSS

- [Exploiting XSS with 20 characters limitation](https://jlajara.gitlab.io/posts/2019/11/30/XSS_20_characters.html) - 撰写者 [Jorge Lajara](https://jlajara.gitlab.io/).
- [Upgrade self XSS to Exploitable XSS an 3 Ways Technic](https://www.hahwul.com/2019/11/upgrade-self-xss-to-exploitable-xss.html) - 撰写者 [HAHWUL](https://www.hahwul.com/).
- [XSS without parentheses and semi-colons](https://portswigger.net/blog/xss-without-parentheses-and-semi-colons) - 撰写者 [@garethheyes](https://twitter.com/garethheyes).
- [XSS-Auditor — the protector of unprotected and the deceiver of protected.](https://medium.com/bugbountywriteup/xss-auditor-the-protector-of-unprotected-f900a5e15b7b) - 撰写者 [@terjanq](https://medium.com/@terjanq).
- [Query parameter reordering causes redirect page to render unsafe URL](https://hackerone.com/reports/293689) - 撰写者 [kenziy](https://hackerone.com/kenziy).
- [ECMAScript 6 from an Attacker's Perspective - Breaking Frameworks, Sandboxes, and everything else](http://www.slideshare.net/x00mario/es6-en) - 撰写者 [Mario Heiderich](http://www.slideshare.net/x00mario).
- [How I found a $5,000 Google Maps XSS (by fiddling with Protobuf)](https://medium.com/@marin_m/how-i-found-a-5-000-google-maps-xss-by-fiddling-with-protobuf-963ee0d9caff#.u50nrzhas) - 撰写者 [@marin_m](https://medium.com/@marin_m).
- [DON'T TRUST THE DOM: BYPASSING XSS MITIGATIONS VIA SCRIPT GADGETS](https://www.blackhat.com/docs/us-17/thursday/us-17-Lekies-Dont-Trust-The-DOM-Bypassing-XSS-Mitigations-Via-Script-Gadgets.pdf) - 撰写者 [Sebastian Lekies](https://twitter.com/slekies), [Krzysztof Kotowicz](https://twitter.com/kkotowicz)， 和 [Eduardo Vela](https://twitter.com/sirdarckcat).
- [Uber XSS via Cookie](http://zhchbin.github.io/2017/08/30/Uber-XSS-via-Cookie/) - 撰写者 [zhchbin](http://zhchbin.github.io/).
- [DOM XSS – auth.uber.com](http://stamone-bug-bounty.blogspot.tw/2017/10/dom-xss-auth14.html) - 撰写者 [StamOne_](http://stamone-bug-bounty.blogspot.tw/).
- [Stored XSS on Facebook](https://opnsec.com/2018/03/stored-xss-on-facebook/) - 撰写者 [Enguerran Gillier](https://opnsec.com/).
- [XSS in Google Colaboratory + CSP bypass](https://blog.bentkowski.info/2018/06/xss-in-google-colaboratory-csp-bypass.html) - 撰写者 [Michał Bentkowski](https://blog.bentkowski.info/).
- [Another XSS in Google Colaboratory](https://blog.bentkowski.info/2018/09/another-xss-in-google-colaboratory.html) - 撰写者 [Michał Bentkowski](https://blog.bentkowski.info/).
- [</script> is filtered ?](https://twitter.com/strukt93/status/931586377665331200) - 撰写者 [@strukt93](https://twitter.com/strukt93).
- [$20000 Facebook DOM XSS](https://vinothkumar.me/20000-facebook-dom-xss/) - 撰写者 [@vinodsparrow](https://twitter.com/vinodsparrow).

<a name="tricks-sql-injection"></a>
### SQL Injection

- [MySQL Error Based SQL Injection Using EXP](https://www.exploit-db.com/docs/english/37953-mysql-error-based-sql-injection-using-exp.pdf) - 撰写者 [@osandamalith](https://twitter.com/osandamalith).
- [SQL injection in an UPDATE query - a bug bounty story!](http://zombiehelp54.blogspot.jp/2017/02/sql-injection-in-update-query-bug.html) - 撰写者 [Zombiehelp54](http://zombiehelp54.blogspot.jp/).
- [GitHub Enterprise SQL Injection](http://blog.orange.tw/2017/01/bug-bounty-github-enterprise-sql-injection.html) - 撰写者 [Orange](http://blog.orange.tw/).
- [Making a Blind SQL Injection a little less blind](https://medium.com/@tomnomnom/making-a-blind-sql-injection-a-little-less-blind-428dcb614ba8) - 撰写者 [TomNomNom](https://twitter.com/TomNomNom).
- [Red Team Tales 0x01: From MSSQL to RCE](https://www.tarlogic.com/en/blog/red-team-tales-0x01/) - 撰写者 [Tarlogic](https://www.tarlogic.com/en/cybersecurity-blog/).
- [SQL INJECTION AND POSTGRES - AN ADVENTURE TO EVENTUAL RCE](https://pulsesecurity.co.nz/articles/postgres-sqli) - 撰写者 [@denandz](https://github.com/denandz).

<a name="tricks-nosql-injection"></a>
### NoSQL Injection

- [GraphQL NoSQL Injection Through JSON Types](http://www.petecorey.com/blog/2017/06/12/graphql-nosql-injection-through-json-types/) - 撰写者 [Pete](http://www.petecorey.com/work/).

<a name="tricks-ftp-injection"></a>
### FTP Injection

- [XML Out-Of-Band Data Retrieval](https://media.blackhat.com/eu-13/briefings/Osipov/bh-eu-13-XML-data-osipov-slides.pdf) - 撰写者 [@a66at](https://twitter.com/a66at) 和阿列克谢·奥西波夫.
- [XXE OOB exploitation at Java 1.7+](http://lab.onsec.ru/2014/06/xxe-oob-exploitation-at-java-17.html) - 撰写者 [Ivan Novikov](http://lab.onsec.ru/).

<a name="tricks-xxe"></a>
### XXE

- [Evil XML with two encodings](https://mohemiv.com/all/evil-xml/) - 撰写者 [Arseniy Sharoglazov](https://mohemiv.com/).
- [XXE in WeChat Pay Sdk ( WeChat leave a backdoor on merchant websites)](http://seclists.org/fulldisclosure/2018/Jul/3) - 撰写者 [Rose Jackcode](https://twitter.com/codeshtool).
- [XML Out-Of-Band Data Retrieval](https://media.blackhat.com/eu-13/briefings/Osipov/bh-eu-13-XML-data-osipov-slides.pdf) - 由 Timur Yunusov 和 Alexey Osipov 撰写.
- [XXE OOB exploitation at Java 1.7+ (2014)](http://lab.onsec.ru/2014/06/xxe-oob-exploitation-at-java-17.html): Exfiltration using FTP protocol - 作者： [Ivan Novikov](https://twitter.com/d0znpp/).
- [XXE OOB extracting via HTTP+FTP using single opened port](https://skavans.ru/en/2017/12/02/xxe-oob-extracting-via-httpftp-using-single-opened-port/) - 撰写者 [skavans](https://skavans.ru/).
- [What You Didn't Know About XML External Entities Attacks](https://2013.appsecusa.org/2013/wp-content/uploads/2013/12/WhatYouDidntKnowAboutXXEAttacks.pdf) - 撰写者 [Timothy D. Morgan](https://twitter.com/ecbftw).
- [Pre-authentication XXE vulnerability in the Services Drupal module](https://www.synacktiv.com/ressources/synacktiv_drupal_xxe_services.pdf) - 撰写者 [Renaud Dubourguais](https://twitter.com/_m0bius).
- [Forcing XXE Reflection through Server Error Messages](https://blog.netspi.com/forcing-xxe-reflection-server-error-messages/) - 撰写者 [Antti Rantasaari](https://blog.netspi.com/author/antti-rantasaari/).
- [Exploiting XXE with local DTD files](https://mohemiv.com/all/exploiting-xxe-with-local-dtd-files/) - 撰写者 [Arseniy Sharoglazov](https://twitter.com/_mohemiv).
- [Automating local DTD discovery for XXE exploitation](https://www.gosecure.net/blog/2019/07/16/automating-local-dtd-discovery-for-xxe-exploitation) - 撰写者 [Philippe Arteau](https://twitter.com/h3xstream).

<a name="tricks-ssrf"></a>
### SSRF

- [AWS takeover through SSRF in JavaScript](http://10degres.net/aws-takeover-through-ssrf-in-javascript/) - 撰写者 [Gwen](http://10degres.net/).
- [SSRF in Exchange leads to ROOT access in all instances](https://hackerone.com/reports/341876) - 撰写者 [@0xacb](https://twitter.com/0xacb).
- [SSRF to ROOT Access](https://hackerone.com/reports/341876) - SSRF 的 25,000 美元赏金导致在所有情况下获得 ROOT 访问权限 [0xacb](https://hackerone.com/0xacb).
- [PHP SSRF Techniques](https://medium.com/secjuice/php-ssrf-techniques-9d422cb28d51) - 撰写者 [@themiddleblue](https://medium.com/@themiddleblue).
- [SSRF in https://imgur.com/vidgif/url](https://hackerone.com/reports/115748) - 撰写者 [aesteral](https://hackerone.com/aesteral).
- [All you need to know about SSRF and how may we write tools to do auto-detect](https://www.auxy.xyz/web%20security/2017/07/06/all-ssrf-knowledge.html) - 撰写者 [@Auxy233](https://twitter.com/Auxy233).
- [A New Era of SSRF - Exploiting URL Parser in Trending Programming Languages!](https://www.blackhat.com/docs/us-17/thursday/us-17-Tsai-A-New-Era-Of-SSRF-Exploiting-URL-Parser-In-Trending-Programming-Languages.pdf) - 撰写者 [Orange](http://blog.orange.tw/).
- [SSRF Tips](http://blog.safebuff.com/2016/07/03/SSRF-Tips/) - 撰写者 [xl7dev](http://blog.safebuff.com/).
- [Into the Borg – SSRF inside Google production network](https://opnsec.com/2018/07/into-the-borg-ssrf-inside-google-production-network/) - 撰写者 [opnsec](https://opnsec.com/).
- [Piercing the Veil: Server Side Request Forgery to NIPRNet access](https://medium.com/bugbountywriteup/piercing-the-veil-server-side-request-forgery-to-niprnet-access-c358fd5e249a) - 撰写者 [Alyssa Herrera](https://medium.com/@alyssa.o.herrera).

<a name="tricks-web-cache-poisoning"></a>
### Web Cache Poisoning

- [Bypassing Web Cache Poisoning Countermeasures](https://portswigger.net/blog/bypassing-web-cache-poisoning-countermeasures) - 撰写者 [@albinowax](https://twitter.com/albinowax).
- [Cache poisoning and other dirty tricks](https://lab.wallarm.com/cache-poisoning-and-other-dirty-tricks-120468f1053f) - 撰写者 [Wallarm](https://wallarm.com/).

<a name="tricks-header-injection"></a>
### Header Injection

- [Java/Python FTP Injections Allow for Firewall Bypass](http://blog.blindspotsecurity.com/2017/02/advisory-javapython-ftp-injections.html) - 撰写者 [Timothy Morgan](https://plus.google.com/105917618099766831589).

<a name="tricks-url"></a>
### URL

- [Some Problems Of URLs](https://noncombatant.org/2017/11/07/problems-of-urls/) - 撰写者 [Chris Palmer](https://noncombatant.org/about/).
- [Phishing with Unicode Domains](https://www.xudongz.com/blog/2017/idn-phishing/) - 撰写者 [Xudong Zheng](https://www.xudongz.com/).
- [Unicode Domains are bad and you should feel bad for supporting them](https://www.vgrsec.com/post20170219.html) - 撰写者 [VRGSEC](https://www.vgrsec.com/).
- [[dev.twitter.com] XSS](http://blog.blackfan.ru/2017/09/devtwittercom-xss.html) - 作者 [Sergey Bobrov](http://blog.blackfan.ru/).

<a name="tricks-deserialization"></a>
### Deserialization

- [ASP.NET resource files (.RESX) and deserialisation issues](https://www.nccgroup.trust/uk/about-us/newsroom-and-events/blogs/2018/august/aspnet-resource-files-resx-and-deserialisation-issues/) - 撰写者 [@irsdl](https://twitter.com/irsdl).

<a name="tricks-oauth"></a>
### OAuth

- [Facebook OAuth Framework Vulnerability](https://www.amolbaikar.com/facebook-oauth-framework-vulnerability/) - 撰写者 [@AmolBaikar](https://twitter.com/AmolBaikar).

<a name="tricks-others"></a>
### Others

- [How I hacked Google’s bug tracking system itself for $15,600 in bounties](https://medium.com/free-code-camp/messing-with-the-google-buganizer-system-for-15-600-in-bounties-58f86cc9f9a5) - 撰写者 [@alex.birsan](https://medium.com/@alex.birsan).
- [Some Tricks From My Secret Group](https://www.leavesongs.com/SHARE/some-tricks-from-my-secret-group.html) - 撰写者 [phithon](https://www.leavesongs.com/).
- [Inducing DNS Leaks in Onion Web Services](https://github.com/epidemics-scepticism/writing/blob/master/onion-dns-leaks.md) - 撰写者 [@epidemics-scepticism](https://github.com/epidemics-scepticism).
- [Stored XSS, and SSRF in Google using the Dataset Publishing Language](https://s1gnalcha0s.github.io/dspl/2018/03/07/Stored-XSS-and-SSRF-Google.html) - 撰写者 [@signalchaos](https://twitter.com/signalchaos).

## Browser Exploitation

### Frontend (like SOP bypass, URL spoofing, and something like that)

- [The world of Site Isolation and compromised renderer](https://speakerdeck.com/shhnjk/the-world-of-site-isolation-and-compromised-renderer) - 撰写者 [@shhnjk](https://twitter.com/shhnjk).
- [The Cookie Monster in Your Browsers](https://speakerdeck.com/filedescriptor/the-cookie-monster-in-your-browsers) - 撰写者 [@filedescriptor](https://twitter.com/filedescriptor).
- [Bypassing Mobile Browser Security For Fun And Profit](https://www.blackhat.com/docs/asia-16/materials/asia-16-Baloch-Bypassing-Browser-Security-Policies-For-Fun-And-Profit-wp.pdf) - 撰写者 [@rafaybaloch](https://twitter.com/@rafaybaloch).
- [The inception bar: a new phishing method](https://jameshfisher.com/2019/04/27/the-inception-bar-a-new-phishing-method/) - 撰写者 [jameshfisher](https://jameshfisher.com/).
- [JSON hijacking for the modern web](http://blog.portswigger.net/2016/11/json-hijacking-for-modern-web.html) - 撰写者 [portswigger](https://portswigger.net/).
- [IE11 Information disclosure - local file detection](https://www.facebook.com/ExploitWareLabs/photos/a.361854183878462.84544.338832389513975/1378579648872572/?type=3&theater) - 由詹姆斯·李撰写.
- [SOP bypass / UXSS – Stealing Credentials Pretty Fast (Edge)](https://www.brokenbrowser.com/sop-bypass-uxss-stealing-credentials-pretty-fast/) - 撰写者 [Manuel](https://twitter.com/magicmac2000).
- [Особенности Safari в client-side атаках](https://bo0om.ru/safari-client-side) - 撰写者 [Bo0oM](https://bo0om.ru/author/admin).
- [How do we Stop Spilling the Beans Across Origins?](https://docs.google.com/document/d/1cbL-X0kV_tQ5rL8XJ3lXkV-j0pt_CfTu5ZSzYrncPDc/) - 撰写者 [aaj at google.com](https://github.com/qazbnm456/awesome-web-security/blob/master/aaj@google.com) 和 [mkwst at google.com](https://github.com/qazbnm456/awesome-web-security/blob/master/mkwst@google.com).
- [Setting arbitrary request headers in Chromium via CRLF injection](https://blog.bentkowski.info/2018/06/setting-arbitrary-request-headers-in.html) - 撰写者 [Michał Bentkowski](https://blog.bentkowski.info/).
- [I’m harvesting credit card numbers and passwords from your site. Here’s how.](https://hackernoon.com/im-harvesting-credit-card-numbers-and-passwords-from-your-site-here-s-how-9a8cb347c5b5) - 撰写者 [David Gilbertson](https://hackernoon.com/@david.gilbertson).
- [Sending arbitrary IPC messages via overriding Function.prototype.apply](https://hackerone.com/reports/188086) - 撰写者 [@kinugawamasato](https://twitter.com/kinugawamasato).
- [Take Advantage of Out-of-Scope Domains in Bug Bounty Programs](https://ahussam.me/Take-Advantage-of-Out-of-Scope-Domains-in-Bug-Bounty/) - 撰写者 [@Abdulahhusam](https://twitter.com/Abdulahhusam).

### Backend (core of Browser implementation, and often refers to C or C++ part)

- [Breaking UC Browser](https://habr.com/en/company/drweb/blog/452076/) - 撰写者 [Доктор Веб](https://www.drweb.ru/).
- [Attacking JavaScript Engines - A case study of JavaScriptCore and CVE-2016-4622](http://www.phrack.org/papers/attacking_javascript_engines.html) - 撰写者 [https://github.com/qazbnm456/awesome-web-security/blob/master/phrack@saelo.net](https://github.com/qazbnm456/awesome-web-security/blob/master/phrack@saelo.net).
- [Three roads lead to Rome](http://blogs.360.cn/360safe/2016/11/29/three-roads-lead-to-rome-2/) - 撰写者 [@holynop](https://twitter.com/holynop).
- [Exploiting a V8 OOB write.](https://halbecaf.com/2017/05/24/exploiting-a-v8-oob-write/) - 撰写者 [@halbecaf](https://twitter.com/halbecaf).
- [SSD Advisory – Chrome Turbofan Remote Code Execution](https://blogs.securiteam.com/index.php/archives/3379) - 撰写者 [SecuriTeam Secure Disclosure (SSD)](https://blogs.securiteam.com/).
- [Look Mom, I don't use Shellcode - Browser Exploitation Case Study for Internet Explorer 11](https://labs.bluefrostsecurity.de/files/Look_Mom_I_Dont_Use_Shellcode-WP.pdf) - 撰写者 [@moritzj](http://twitter.com/moritzj).
- [PUSHING WEBKIT'S BUTTONS WITH A MOBILE PWN2OWN EXPLOIT](https://www.zerodayinitiative.com/blog/2018/2/12/pushing-webkits-buttons-with-a-mobile-pwn2own-exploit) - 撰写者 [@wanderingglitch](https://twitter.com/wanderingglitch).
- [A Methodical Approach to Browser Exploitation](https://blog.ret2.io/2018/06/05/pwn2own-2018-exploit-development/) - 撰写者 [RET2 SYSTEMS, INC](https://blog.ret2.io/).
- [CVE-2017-2446 or JSC::JSGlobalObject::isHavingABadTime.](https://doar-e.github.io/blog/2018/07/14/cve-2017-2446-or-jscjsglobalobjectishavingabadtime/) - 撰写者 [Diary of a reverse-engineer](https://doar-e.github.io/).
- [CLEANLY ESCAPING THE CHROME SANDBOX](https://theori.io/research/escaping-chrome-sandbox) - 撰写者 [@tjbecker_](https://twitter.com/tjbecker_).
- [A Methodical Approach to Browser Exploitation](https://blog.ret2.io/2018/06/05/pwn2own-2018-exploit-development/) - 撰写者 [@PatrickBiernat](https://twitter.com/PatrickBiernat), [@gaasedelen](https://twitter.com/gaasedelen) 和 [@itszn13](https://twitter.com/itszn13).

## PoCs

<a name="pocs-database"></a>
### Database

- [js-vuln-db](https://github.com/tunz/js-vuln-db) - 通过 PoC 收集 JavaScript 引擎 CVE [@tunz](https://github.com/tunz).
- [awesome-cve-poc](https://github.com/qazbnm456/awesome-cve-poc) - 精选的 CVE PoC 列表 [@qazbnm456](https://github.com/qazbnm456).
- [Some-PoC-oR-ExP](https://github.com/coffeehb/Some-PoC-oR-ExP) - 各种漏洞poc、Exp的收集或编写 by [@coffeehb](https://github.com/coffeehb).
- [uxss-db](https://github.com/Metnew/uxss-db) - 通过 PoC 收集 UXSS CVE [@Metnew](https://github.com/Metnew).
- [SPLOITUS](https://sploitus.com/) - 利用和工具搜索引擎 [@i_bo0om](https://twitter.com/i_bo0om).
- [Exploit Database](https://www.exploit-db.com/) - 漏洞利用、Shellcode 和安全文件的最终存档 [Offensive Security](https://www.offensive-security.com/).

## Cheetsheets

- [XSS Cheat Sheet - 2018 Edition](https://leanpub.com/xss) - 撰写者 [@brutelogic](https://twitter.com/brutelogic).
- [Capture the Flag CheatSheet](https://github.com/uppusaikiran/awesome-ctf-cheatsheet) - 撰写者 [@uppusaikiran](https://github.com/uppusaikiran).

## Tools

<a name="tools-auditing"></a>
### Auditing

- [prowler](https://github.com/Alfresco/prowler) - 用于 AWS 安全评估、审计和强化的工具 [@Alfresco](https://github.com/Alfresco).
- [slurp](https://github.com/hehnope/slurp) - 通过以下方式评估 S3 存储桶的安全性 [@hehnope](https://github.com/hehnope).
- [A2SV](https://github.com/hahwul/a2sv) - 自动扫描到 SSL 漏洞 [@hahwul](https://github.com/hahwul).

<a name="tools-command-injection"></a>
### Command Injection

- [commix](https://github.com/commixproject/commix) - 自动化的多合一操作系统命令注入和利用工具 [@commixproject](https://github.com/commixproject).

<a name="tools-reconnaissance"></a>
### Reconnaissance

<a name="tools-osint"></a>
#### OSINT - Open-Source Intelligence

- [Shodan](https://www.shodan.io/) - Shodan 是世界上第一个用于互联网连接设备的搜索引擎 [@shodanhq](https://twitter.com/shodanhq).
- [Censys](https://censys.io/) - Censys 是一个搜索引擎，它允许计算机科学家通过以下方式询问有关组成互联网的设备和网络的问题 [University of Michigan](https://umich.edu/).
- [urlscan.io](https://urlscan.io/) - 分析网站及其请求的资源的服务 [@heipei](https://twitter.com/heipei).
- [ZoomEye](https://www.zoomeye.org/) - 网络空间搜索引擎 [@zoomeye_team](https://twitter.com/zoomeye_team).
- [FOFA](https://fofa.so/?locale=en) - 网络空间搜索引擎 [BAIMAOHUI](http://baimaohui.net/).
- [NSFOCUS](https://nti.nsfocus.com/) - NSFOCUS GLOBAL 的威胁情报门户.
- [Photon](https://github.com/s0md3v/Photon) - 为 OSINT 设计的令人难以置信的快速爬虫 [@s0md3v](https://github.com/s0md3v).
- [FOCA](https://github.com/ElevenPaths/FOCA) - FOCA（Fingerprinting Organizations with Collected Archives）是一种主要用于在其扫描的文档中查找元数据和隐藏信息的工具 [ElevenPaths](https://www.elevenpaths.com/index.html).
- [SpiderFoot](http://www.spiderfoot.net/) - 开源足迹和情报收集工具 [@binarypool](https://twitter.com/binarypool).
- [xray](https://github.com/evilsocket/xray) - XRay 是一种用于从公共网络收集侦察、制图和 OSINT 的工具 [@evilsocket](https://github.com/evilsocket).
- [gitrob](https://github.com/michenriksen/Gitrob) - GitHub 组织的侦察工具 [@michenriksen](https://github.com/michenriksen).
- [GSIL](https://github.com/FeeiCN/GSIL) - Github Sensitive Information Leakage（Github敏感信息泄露）by [@FeeiCN](https://github.com/FeeiCN).
- [raven](https://github.com/0x09AL/raven) - raven 是一个 Linkedin 信息收集工具，渗透测试人员可以使用它来收集有关使用 Linkedin 的组织员工的信息 [@0x09AL](https://github.com/0x09AL).
- [ReconDog](https://github.com/s0md3v/ReconDog) - 侦察瑞士军刀 [@s0md3v](https://github.com/s0md3v).
- [Databases - start.me](https://start.me/p/QRENnO/databases) - 可用于 OSINT 研究的各种数据库 [@technisette](https://twitter.com/technisette).
- [peoplefindThor](https://peoplefindthor.dk/) - 通过以下方式在 Facebook 上找到人的简单方法 [postkassen](https://github.com/qazbnm456/awesome-web-security/blob/master/mailto:postkassen@oejvind.dk?subject=peoplefindthor.dk comments).
- [tinfoleak](https://github.com/vaguileradiaz/tinfoleak) - 最完整的 Twitter 情报分析开源工具 [@vaguileradiaz](https://github.com/vaguileradiaz).
- [Raccoon](https://github.com/evyatarmeged/Raccoon) - 用于侦察和漏洞扫描的高性能攻击性安全工具 [@evyatarmeged](https://github.com/evyatarmeged).
- [Social Mapper](https://github.com/SpiderLabs/social_mapper) - Jacob Wilkin（Greenwolf）的社交媒体枚举和关联工具 [@SpiderLabs](https://github.com/SpiderLabs).
- [espi0n/Dockerfiles](https://github.com/espi0n/Dockerfiles) - 用于各种 OSINT 工具的 Dockerfiles [@espi0n](https://github.com/espi0n).

<a name="tools-sub-domain-enumeration"></a>
#### Sub Domain Enumeration

- [Sublist3r](https://github.com/aboul3la/Sublist3r) - Sublist3r 是一款用于渗透测试人员的多线程子域枚举工具 [@aboul3la](https://github.com/aboul3la).
- [EyeWitness](https://github.com/ChrisTruncer/EyeWitness) - EyeWitness 旨在获取网站的屏幕截图，提供一些服务器标头信息，并在可能的情况下识别默认凭据 [@ChrisTruncer](https://github.com/ChrisTruncer).
- [subDomainsBrute](https://github.com/lijiejie/subDomainsBrute) - 一个简单快速的子域暴力破解工具，由 [@lijiejie](https://github.com/lijiejie).
- [AQUATONE](https://github.com/michenriksen/aquatone) - 域天桥工具 [@michenriksen](https://github.com/michenriksen).
- [domain_analyzer](https://github.com/eldraco/domain_analyzer) - 通过查找所有可能的信息来分析任何域的安全性 [@eldraco](https://github.com/eldraco).
- [VirusTotal domain information](https://www.virustotal.com/en/documentation/searching/#getting-domain-information) - 通过搜索域信息 [VirusTotal](https://www.virustotal.com/).
- [Certificate Transparency](https://github.com/google/certificate-transparency) - Google 的证书透明度项目修复了 SSL 证书系统中的几个结构性缺陷 [@google](https://github.com/google).
- [Certificate Search](https://crt.sh/) - 输入身份（域名、组织名称等）、证书指纹（SHA-1 或 SHA-256）或 crt.sh ID 以通过以下方式搜索证书 [@crtsh](https://github.com/crtsh).
- [GSDF](https://github.com/We5ter/GSDF) - 名为 GoogleSSLdomainFinder 的域搜索器 [@We5ter](https://github.com/We5ter).

<a name="tools-code-generating"></a>
### Code Generating

- [VWGen](https://github.com/qazbnm456/VWGen) - 易受攻击的 Web 应用程序生成器 [@qazbnm456](https://github.com/qazbnm456).

<a name="tools-fuzzing"></a>
### Fuzzing

- [wfuzz](https://github.com/xmendez/wfuzz) - Web 应用程序 bruteforcer [@xmendez](https://github.com/xmendez).
- [charsetinspect](https://github.com/hack-all-the-things/charsetinspect) - 检查多字节字符集以查找具有特定用户定义属性的字符的脚本 [@hack-all-the-things](https://github.com/hack-all-the-things).
- [IPObfuscator](https://github.com/OsandaMalith/IPObfuscator) - 通过以下方式将 IP 转换为 DWORD IP 的简单工具 [@OsandaMalith](https://github.com/OsandaMalith).
- [domato](https://github.com/google/domato) - DOM模糊器 [@google](https://github.com/google).
- [FuzzDB](https://github.com/fuzzdb-project/fuzzdb) - 用于黑盒应用程序故障注入和资源发现的攻击模式和原语字典.
- [dirhunt](https://github.com/Nekmo/dirhunt) - 为搜索和分析网站目录结构而优化的网络爬虫 [@nekmo](https://github.com/Nekmo).
- [ssltest](https://www.ssllabs.com/ssltest/)  - 对公共互联网上任何 SSL Web 服务器的配置进行深入分析的在线服务. 由...提供 [Qualys SSL Labs](https://www.ssllabs.com).
- [fuzz.txt](https://github.com/Bo0oM/fuzz.txt) - 潜在的危险文件 [@Bo0oM](https://github.com/Bo0oM).

<a name="tools-scanning"></a>
### Scanning

- [wpscan](https://github.com/wpscanteam/wpscan) - WPScan 是一个黑盒 WordPress 漏洞扫描器，由 [@wpscanteam](https://github.com/wpscanteam).
- [JoomlaScan](https://github.com/drego85/JoomlaScan) - 用于查找安装在 Joomla CMS 中的组件的免费软件，由 Joomscan 的灰烬构建而成 [@drego85](https://github.com/drego85).
- [WAScan](https://github.com/m4ll0k/WAScan) - 是一种使用“黑盒”方法的开源 Web 应用程序安全扫描程序，由 [@m4ll0k](https://github.com/m4ll0k).
- [Nuclei](https://github.com/projectdiscovery/nuclei) - Nuclei 是一种基于模板的可配置目标扫描的快速工具，提供巨大的可扩展性和易用性 [@projectdiscovery](https://github.com/projectdiscovery).

<a name="tools-penetration-testing"></a>
### Penetration Testing

- [Burp Suite](https://portswigger.net/burp/) - Burp Suite 是一个集成平台，用于通过以下方式对 Web 应用程序进行安全测试 [portswigger](https://portswigger.net/).
- [TIDoS-Framework](https://github.com/theInfectedDrake/TIDoS-Framework) - 一个全面的 Web 应用程序审计框架，涵盖从侦察和 OSINT 到漏洞分析的所有内容 [@_tID](https://github.com/theInfectedDrake).
- [Astra](https://github.com/flipkart-incubator/astra) - REST API 的自动化安全测试 [@flipkart-incubator](https://github.com/flipkart-incubator).
- [aws_pwn](https://github.com/dagrz/aws_pwn) - AWS 渗透测试垃圾合集 [@dagrz](https://github.com/dagrz).
- [grayhatwarfare](https://buckets.grayhatwarfare.com/) - 公共桶 [grayhatwarfare](http://www.grayhatwarfare.com/).

<a name="tools-offensive"></a>
### Offensive

<a name="tools-xss"></a>
#### XSS - Cross-Site Scripting

- [beef](https://github.com/beefproject/beef) - 浏览器开发框架项目 [beefproject](https://beefproject.com).
- [JShell](https://github.com/s0md3v/JShell) - 通过 XSS 获得一个 JavaScript shell [@s0md3v](https://github.com/s0md3v).
- [XSStrike](https://github.com/s0md3v/XSStrike)  - XSStrike 是一个可以对 XSS 参数进行模糊测试和暴力破解的程序. 它还可以通过以下方式检测和绕过 WAF [@s0md3v](https://github.com/s0md3v).
- [xssor2](https://github.com/evilcos/xssor2) - XSS&#39;OR - 用 Ja​​vaScript 破解 [@evilcos](https://github.com/evilcos).
- [csp evaluator](https://csper.io/evaluator) - 评估内容安全策略的工具 [Csper](http://csper.io).

<a name="tools-sql-injection"></a>
#### SQL Injection

- [sqlmap](https://github.com/sqlmapproject/sqlmap) - 自动 SQL 注入和数据库接管工具.

<a name="tools-template-injection"></a>
#### Template Injection

- [tplmap](https://github.com/epinna/tplmap) - 代码和服务器端模板注入检测和开发工具 [@epinna](https://github.com/epinna).

<a name="tools-xxe"></a>
#### XXE

- [dtd-finder](https://github.com/GoSecure/dtd-finder) - 列出 DTD 并使用这些本地 DTD 生成 XXE 有效载荷 [@GoSecure](https://github.com/GoSecure).

<a name="tools-csrf"></a>
#### Cross Site Request Forgery

- [XSRFProbe](https://github.com/0xInfection/XSRFProbe) - Prime CSRF 审计和开发工具包，作者： [@0xInfection](https://github.com/0xinfection).

<a name="tools-ssrf"></a>
#### Server-Side Request Forgery

- [Open redirect/SSRF payload generator](https://tools.intigriti.io/redirector/) - 打开重定向/SSRF 负载生成器 [intigriti](https://www.intigriti.com/).

<a name="tools-leaking"></a>
### Leaking

- [HTTPLeaks](https://github.com/cure53/HTTPLeaks) - 网站可以通过所有可能的方式泄露 HTTP 请求 [@cure53](https://github.com/cure53).
- [dvcs-ripper](https://github.com/kost/dvcs-ripper) - Rip web 可访问（分布式）版本控制系统：SVN/GIT/HG... by [@kost](https://github.com/kost).
- [DVCS-Pillage](https://github.com/evilpacket/DVCS-Pillage) - 掠夺可通过网络访问的 GIT、HG 和 BZR 存储库 [@evilpacket](https://github.com/evilpacket).
- [GitMiner](https://github.com/UnkL4b/GitMiner) - 用于 Github 上内容的高级挖掘工具 [@UnkL4b](https://github.com/UnkL4b).
- [gitleaks](https://github.com/zricethezav/gitleaks) - 通过以下方式搜索秘密和密钥的完整回购历史 [@zricethezav](https://github.com/zricethezav).
- [CSS-Keylogging](https://github.com/maxchehab/CSS-Keylogging) - 利用 CSS 的键盘记录功能的 Chrome 扩展和 Express 服务器 [@maxchehab](https://github.com/maxchehab).
- [pwngitmanager](https://github.com/allyshka/pwngitmanager) - 渗透测试人员的 Git 管理器 [@allyshka](https://github.com/allyshka).
- [snallygaster](https://github.com/hannob/snallygaster) - 用于扫描 HTTP 服务器上的秘密文件的工具 [@hannob](https://github.com/hannob).
- [LinkFinder](https://github.com/GerbenJavado/LinkFinder) - 在 JavaScript 文件中查找端点的 Python 脚本 [@GerbenJavado](https://github.com/GerbenJavado).

<a name="tools-detecting"></a>
### Detecting

- [sqlchop](https://sqlchop.chaitin.cn/) - SQL注入检测引擎 [chaitin](http://chaitin.com).
- [xsschop](https://xsschop.chaitin.cn/) - XSS检测引擎 [chaitin](http://chaitin.com).
- [retire.js](https://github.com/RetireJS/retire.js) - 检测使用具有已知漏洞的 JavaScript 库的扫描器 [@RetireJS](https://github.com/RetireJS).
- [malware-jail](https://github.com/HynekPetrak/malware-jail) - 用于半自动 Javascript 恶意软件分析、去混淆和有效载荷提取的沙箱 [@HynekPetrak](https://github.com/HynekPetrak).
- [repo-supervisor](https://github.com/auth0/repo-supervisor) - 扫描您的代码是否存在安全配置错误，搜索密码和秘密.
- [bXSS](https://github.com/LewisArdern/bXSS) - bXSS 是一个简单的盲 XSS 应用程序，改编自 [cure53.de/m](https://cure53.de/m) 经过 [@LewisArdern](https://github.com/LewisArdern).
- [OpenRASP](https://github.com/baidu/openrasp)  - 由百度公司积极维护的开源 RASP 解决方案.使用上下文感知检测算法，该项目几乎没有误报. 在服务器负载较重的情况下，性能下降不到 3%.
- [GuardRails](https://github.com/apps/guardrails) - 在 Pull Requests 中提供安全反馈的 GitHub 应用程序.

<a name="tools-preventing"></a>
### Preventing

- [DOMPurify](https://github.com/cure53/DOMPurify) - 用于 HTML、MathML 和 SVG 的仅 DOM、超快、超级容忍的 XSS 消毒器 [Cure53](https://cure53.de/).
- [js-xss](https://github.com/leizongmin/js-xss) - 使用白名单指定的配置清理不受信任的 HTML（以防止 XSS） [@leizongmin](https://github.com/leizongmin).
- [Acra](https://github.com/cossacklabs/acra) - SQL 数据库的客户端加密引擎，具有强大的选择性加密、SQL 注入防护和入侵检测功能 [@cossacklabs](https://www.cossacklabs.com/).
- [Csper](https://csper.io) - 一组用于构建/评估/监控内容安全策略的工具，以防止/检测跨站点脚本 [Csper](https://csper.io).

<a name="tools-proxy"></a>
### Proxy

- [Charles](https://www.charlesproxy.com/) - HTTP 代理/HTTP 监视器/反向代理，使开发人员能够查看他们的机器和 Internet 之间的所有 HTTP 和 SSL/HTTPS 流量.
- [mitmproxy](https://github.com/mitmproxy/mitmproxy) - 为渗透测试人员和软件开发人员提供交互式 TLS 拦截 HTTP 代理 [@mitmproxy](https://github.com/mitmproxy).

<a name="tools-webshell"></a>
### Webshell

- [nano](https://github.com/s0md3v/nano) - 代码家族通过 PHP shell [@s0md3v](https://github.com/s0md3v).
- [webshell](https://github.com/tennc/webshell) - 这是一个webshel​​l开源项目 [@tennc](https://github.com/tennc).
- [Weevely](https://github.com/epinna/weevely3) - 武器化的网络外壳 [@epinna](https://github.com/epinna).
- [Webshell-Sniper](https://github.com/WangYihang/Webshell-Sniper) - 通过终端管理您的网站 [@WangYihang](https://github.com/WangYihang).
- [Reverse-Shell-Manager](https://github.com/WangYihang/Reverse-Shell-Manager) - 通过终端反向 Shell 管理器[@WangYihang](https://github.com/WangYihang).
- [reverse-shell](https://github.com/lukechilds/reverse-shell) - 反向 Shell 即服务 [@lukechilds](https://github.com/lukechilds).
- [PhpSploit](https://github.com/nil0x42/phpsploit) - 功能齐全的 C2 框架，通过邪恶的 PHP oneliner 默默地存在于网络服务器上 [@nil0x42](https://github.com/nil0x42).

<a name="tools-disassembler"></a>
### Disassembler

- [plasma](https://github.com/plasma-disassembler/plasma) - Plasma 是一个用于 x86/ARM/MIPS 的交互式反汇编程序 [@plasma-disassembler](https://github.com/plasma-disassembler).
- [radare2](https://github.com/radare/radare2) - 类 Unix 逆向工程框架和命令行工具 [@radare](https://github.com/radare).
- [Iaitō](https://github.com/hteso/iaito) - 用于 radare2 逆向工程框架的 Qt 和 C++ GUI [@hteso](https://github.com/hteso).

<a name="tools-decompiler"></a>
### Decompiler

- [CFR](http://www.benf.org/other/cfr/) - 另一个java反编译器 [@LeeAtBenf](https://twitter.com/LeeAtBenf).

<a name="tools-dns-rebinding"></a>
### DNS Rebinding

- [DNS Rebind Toolkit](https://github.com/brannondorsey/dns-rebind-toolkit) - DNS Rebind Toolkit 是一个前端 JavaScript 框架，用于开发针对局域网 (LAN) 上易受攻击的主机和服务的 DNS 重新绑定攻击 [@brannondorsey](https://github.com/brannondorsey)
- [dref](https://github.com/mwrlabs/dref)  - DNS 重新绑定利用框架.  Dref 通过以下方式完成 DNS 重新绑定的繁重工作 [@mwrlabs](https://github.com/mwrlabs)
- [Singularity of Origin](https://github.com/nccgroup/singularity) - 它包括必要的组件，用于将攻击服务器 DNS 名称的 IP 地址重新绑定到目标机器的 IP 地址，并提供攻击有效载荷以利用目标机器上的易受攻击的软件 [@nccgroup](https://github.com/nccgroup)
- [Whonow DNS Server](https://github.com/brannondorsey/whonow) - 用于执行 DNS 重新绑定攻击的恶意 DNS 服务器 [@brannondorsey](https://github.com/brannondorsey)

<a name="tools-others"></a>
### Others

- [Dnslogger](https://wiki.skullsecurity.org/index.php?title=Dnslogger) - DNS 记录器 [@iagox86](https://github.com/iagox86).
- [CyberChef](https://github.com/gchq/CyberChef) - The Cyber Swiss Army Knife - a web app for encryption, encoding, compression and data analysis - by [@GCHQ](https://github.com/gchq).
- [ntlm_challenger](https://github.com/b17zr/ntlm_challenger) - 通过 HTTP 质询消息解析 NTLM [@b17zr](https://github.com/b17zr).
- [cefdebug](https://github.com/taviso/cefdebug) - 通过以下方式连接到 CEF 调试器的最少代码 [@taviso](https://github.com/taviso).
- [ctftool](https://github.com/taviso/ctftool) - 交互式 CTF 探索工具 [@taviso](https://github.com/taviso).

## Social Engineering Database

- [haveibeenpwned](https://haveibeenpwned.com/) - 检查您的帐户是否因数据泄露而受到损害 [Troy Hunt](https://www.troyhunt.com/).

## Blogs

- [Orange](http://blog.orange.tw/) - 台湾天才网络渗透者.
- [leavesongs](https://www.leavesongs.com/) - 中国天才网络渗透者.
- [James Kettle](http://albinowax.skeletonscribe.net/) - 研究主管 [PortSwigger Web Security](https://portswigger.net/).
- [Broken Browser](https://www.brokenbrowser.com/) - 浏览器漏洞的乐趣.
- [Scrutiny](https://datarift.blogspot.tw/) - 通过 Web 浏览器实现互联网安全，作者 Dhiraj Mishra.
- [BRETT BUERHAUS](https://buer.haus/) - 漏洞披露和应用程序安全漫谈.
- [n0tr00t](https://www.n0tr00t.com/) - ~# n0tr00t Security Team.
- [OpnSec](https://opnsec.com/) - 开放的心态安全！
- [RIPS Technologies](https://blog.ripstech.com/tags/security/) - 对 PHP 漏洞的评论.
- [0Day Labs](http://blog.0daylabs.com/) - 很棒的错误赏金和挑战文章.
- [Blog of Osanda](https://osandamalith.com/) - 安全研究和逆向工程.

## Twitter Users

- [@HackwithGitHub](https://twitter.com/HackwithGithub) - 为黑客和渗透测试者展示开源黑客工具的倡议
- [@filedescriptor](https://twitter.com/filedescriptor) - 活跃的渗透者经常发推文和写有用的文章
- [@cure53berlin](https://twitter.com/cure53berlin) - [Cure53](https://cure53.de/) 是一家德国网络安全公司.
- [@XssPayloads](https://twitter.com/XssPayloads) - JavaScript 意外用法的仙境，等等.
- [@kinugawamasato](https://twitter.com/kinugawamasato) - 日本网络渗透器.
- [@h3xstream](https://twitter.com/h3xstream/) - 安全研究员，对网络安全、加密、渗透测试、静态分析感兴趣，但最重要的是，samy 是我的英雄.
- [@garethheyes](https://twitter.com/garethheyes) - 英语网络渗透者.
- [@hasegawayosuke](https://twitter.com/hasegawayosuke) - 日本 javascript 安全研究员.
- [@shhnjk](https://twitter.com/shhnjk) - 网络和浏览器安全研究员.

## Practices

<a name="practices-application"></a>
### Application

- [OWASP Juice Shop](https://github.com/bkimminich/juice-shop) - 可能是最现代和最复杂的不安全网络应用程序 - 作者 [@bkimminich](https://github.com/bkimminich) 和 [@owasp_juiceshop](https://twitter.com/owasp_juiceshop) 团队.
- [BadLibrary](https://github.com/SecureSkyTechnology/BadLibrary) - 用于训练的易受攻击的 Web 应用程序 - 作者 [@SecureSkyTechnology](https://github.com/SecureSkyTechnology).
- [Hackxor](http://hackxor.net/) - 逼真的网络应用黑客游戏 - 作者 [@albinowax](https://twitter.com/albinowax).
- [SELinux Game](http://selinuxgame.org/)  - 边做边学 SELinux. 解决难题，展示技能 - 作者 [@selinuxgame](https://twitter.com/selinuxgame).
- [Portswigger Web Security Academy](https://portswigger.net/web-security) - 免费培训和实验室 - 作者 [PortSwigger](https://portswigger.net/).

<a name="practices-aws"></a>
### AWS

- [FLAWS](http://flaws.cloud/) - 亚马逊 AWS CTF 挑战赛 - 作者 [@0xdabbad00](https://twitter.com/0xdabbad00).
- [CloudGoat](https://github.com/RhinoSecurityLabs/cloudgoat) - Rhino 安全实验室的“设计易受攻击”AWS 基础设施设置工具 - 作者 [@RhinoSecurityLabs](https://github.com/RhinoSecurityLabs).

<a name="practices-xss"></a>
### XSS

- [XSS game](https://xss-game.appspot.com/) - 谷歌 XSS 挑战 - 由谷歌撰写.
- [prompt(1) to win](http://prompt.ml/) - 2014 年夏季举行的复杂 16 级 XSS 挑战赛（+4 个隐藏级别） - 作者 [@cure53](https://github.com/cure53).
- [alert(1) to win](https://alf.nu/alert1) - 一系列 XSS 挑战 - 作者 [@steike](https://twitter.com/steike).
- [XSS Challenges](http://xss-quiz.int21h.jp/) - XSS 挑战系列 - 由 yamagata21 撰写.

<a name="practices-modsecurity"></a>
### ModSecurity / OWASP ModSecurity Core Rule Set

- [ModSecurity / OWASP ModSecurity Core Rule Set](https://www.netnea.com/cms/apache-tutorials/) - 安装、配置和调整 ModSecurity 和核心规则集的系列教程 - 作者 [@ChrFolini](https://twitter.com/ChrFolini).

## Community

- [Reddit](https://www.reddit.com/r/websecurity/)
- [Stack Overflow](http://stackoverflow.com/questions/tagged/security)

## Miscellaneous

- [awesome-bug-bounty](https://github.com/djadmin/awesome-bug-bounty) - 可用漏洞赏金和披露计划的综合精选列表以及作者的评论 [@djadmin](https://github.com/djadmin).
- [bug-bounty-reference](https://github.com/ngalongc/bug-bounty-reference) - 按错误性质分类的错误赏金列表 [@ngalongc](https://github.com/ngalongc).
- [Google VRP and Unicorns](https://sites.google.com/site/bughunteruniversity/behind-the-scenes/presentations/google-vrp-and-unicorns) - 撰写者 [Daniel Stelter-Gliese](https://www.linkedin.com/in/daniel-stelter-gliese-170a70a2/).
- [Brute Forcing Your Facebook Email and Phone Number](http://pwndizzle.blogspot.jp/2014/02/brute-forcing-your-facebook-email-and.html) - 撰写者 [PwnDizzle](http://pwndizzle.blogspot.jp/).
- [Pentest + Exploit dev Cheatsheet wallpaper](http://i.imgur.com/Mr9pvq9.jpg) - 渗透测试和利用开发备忘单.
- [The Definitive Security Data Science and Machine Learning Guide](http://www.covert.io/the-definitive-security-datascience-and-machinelearning-guide/) - 由 JASON TROS 撰写.
- [EQGRP](https://github.com/x0rz/EQGRP) - 解密的 eqgrp-auction-file.tar.xz 内容 [@x0rz](https://github.com/x0rz).
- [notes](https://github.com/ChALkeR/notes) - 一些公共笔记 [@ChALkeR](https://github.com/ChALkeR).
- [A glimpse into GitHub's Bug Bounty workflow](https://githubengineering.com/githubs-bug-bounty-workflow/) - 撰写者 [@gregose](https://github.com/gregose).
- [Cybersecurity Campaign Playbook](https://www.belfercenter.org/CyberPlaybook) - 撰写者 [Belfer Center for Science and International Affairs](https://www.belfercenter.org/).
- [Infosec_Reference](https://github.com/rmusser01/Infosec_Reference) - 不吸的信息安全参考 [@rmusser01](https://github.com/rmusser01).
- [Internet of Things Scanner](http://iotscanner.bullguard.com/) - 检查您家中的互联网连接设备是否在 Shodan 上公开 [BullGuard](https://www.bullguard.com/).
- [The Bug Hunters Methodology v2.1](https://docs.google.com/presentation/d/1VpRT8dFyTaFpQa9jhehtmGaC7TqQniMSYbUdlHN6VrY/edit?usp=sharing) - 撰写者 [@jhaddix](https://twitter.com/jhaddix).
- [$7.5k Google services mix-up](https://sites.google.com/site/testsitehacking/-7-5k-Google-services-mix-up) - 撰写者 [Ezequiel Pereira](https://sites.google.com/site/testsitehacking/).
- [How I exploited ACME TLS-SNI-01 issuing Let's Encrypt SSL-certs for any domain using shared hosting](https://labs.detectify.com/2018/01/12/how-i-exploited-acme-tls-sni-01-issuing-lets-encrypt-ssl-certs-for-any-domain-using-shared-hosting/) - 撰写者 [@fransrosen](https://twitter.com/fransrosen).
- [TL:DR: VPN leaks users’ IPs via WebRTC. I’ve tested seventy VPN providers and 16 of them leaks users’ IPs via WebRTC (23%)](https://voidsec.com/vpn-leak/) - 撰写者 [voidsec](https://voidsec.com/).
- [Escape and Evasion Egressing Restricted Networks](https://www.optiv.com/blog/escape-and-evasion-egressing-restricted-networks) - 撰写者 [Chris Patten, Tom Steele](https://github.com/qazbnm456/awesome-web-security/blob/master/info@optiv.com).
- [Be careful what you copy: Invisibly inserting usernames into text with Zero-Width Characters](https://medium.com/@umpox/be-careful-what-you-copy-invisibly-inserting-usernames-into-text-with-zero-width-characters-18b4e6f17b66) - 撰写者 [@umpox](https://medium.com/@umpox).
- [Domato Fuzzer's Generation Engine Internals](https://www.sigpwn.io/blog/2018/4/14/domato-fuzzers-generation-engine-internals) - 撰写者 [sigpwn](https://www.sigpwn.io/).
- [CSS Is So Overpowered It Can Deanonymize Facebook Users](https://www.evonide.com/side-channel-attacking-browsers-through-css3-features/) - 撰写者 [Ruslan Habalov](https://www.evonide.com/).
- [Introduction to Web Application Security](https://www.slideshare.net/nragupathy/introduction-to-web-application-security-blackhoodie-us-2018) - 撰写者 [@itsC0rg1](https://twitter.com/itsC0rg1), [@jmkeads](https://twitter.com/jmkeads) 和 [@matir](https://twitter.com/matir).
- [Finding The Real Origin IPs Hiding Behind CloudFlare or TOR](https://www.secjuice.com/finding-real-ips-of-origin-servers-behind-cloudflare-or-tor/) - 撰写者 [Paul Dannewitz](https://www.secjuice.com/author/paul-dannewitz/).
- [Why Facebook's api starts with a for loop](https://dev.to/antogarand/why-facebooks-api-starts-with-a-for-loop-1eob) - 撰写者 [@AntoGarand](https://twitter.com/AntoGarand).
- [How I could have stolen your photos from Google - my first 3 bug bounty writeups](https://blog.avatao.com/How-I-could-steal-your-photos-from-Google/) - 撰写者 [@gergoturcsanyi](https://twitter.com/gergoturcsanyi).
- [An example why NAT is NOT security](https://0day.work/an-example-why-nat-is-not-security/) - 撰写者 [@0daywork](https://twitter.com/@0daywork).
- [WEB APPLICATION PENETRATION TESTING NOTES](https://techvomit.net/web-application-penetration-testing-notes/) - 撰写者 [Jayson](https://techvomit.net/).
- [Hacking with a Heads Up Display](https://segment.com/blog/hacking-with-a-heads-up-display/) - 撰写者 [David Scrobonia](https://segment.com/blog/authors/david-scrobonia/).
- [Alexa Top 1 Million Security - Hacking the Big Ones](https://slashcrypto.org/data/itsecx2018.pdf) - 撰写者 [@slashcrypto](https://twitter.com/slashcrypto).
- [The bug bounty program that changed my life](http://10degres.net/the-bug-bounty-program-that-changed-my-life/) - 撰写者 [Gwen](http://10degres.net/).
- [List of bug bounty writeups](https://pentester.land/list-of-bug-bounty-writeups.html) - 撰写者 [Mariem](https://pentester.land/).
- [Implications of Loading .NET Assemblies](https://threatvector.cylance.com/en_us/home/implications-of-loading-net-assemblies.html) - 撰写者 [Brian Wallace](https://threatvector.cylance.com/en_us/contributors/brian-wallace.html).
- [WCTF2019: Gyotaku The Flag](https://westerns.tokyo/wctf2019-gtf/wctf2019-gtf-slides.pdf) - 撰写者 [@t0nk42](https://twitter.com/t0nk42).
- [How we abused Slack's TURN servers to gain access to internal services](https://www.rtcsec.com/2020/04/01-slack-webrtc-turn-compromise/) - 撰写者 [@sandrogauci](https://twitter.com/sandrogauci).
- [DOS File Path Magic Tricks](https://medium.com/walmartlabs/dos-file-path-magic-tricks-5eda7a7a85fa) - 撰写者 [@clr2of8](https://medium.com/@clr2of8).
- [How I got my first big bounty payout with Tesla](https://medium.com/heck-the-packet/how-i-got-my-first-big-bounty-payout-with-tesla-8d28b520162d) - 撰写者 [@cj.fairhead](https://medium.com/@cj.fairhead).

## Code of Conduct

请注意，该项目随 [Contributor Code of Conduct](https://github.com/qazbnm456/awesome-web-security/blob/master/code-of-conduct.md) . 参与此项目即表示您同意遵守其条款.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [@qazbnm456](https://qazbnm456.github.io/) 已放弃该作品的所有版权和相关或邻接权.
