<div class="github-widget" data-repo="sergey-pimenov/awesome-web-animation"></div>
## Awesome Web Animation [![Awesome](https://awesome.re/badge.svg)](https://github.com/sindresorhus/awesome)

<a href="https://awesome-web-animation.netlify.com">
  <img src="https://raw.githubusercontent.com/sergey-pimenov/awesome-web-animation/master/readme_assets/header.png">
</a>

此列表包含用于创建网络动画的最有用的工具和数据.
* 任何有助于在浏览器中制作任何动画的库 - Canvas、SVG、文本、滚动等.
* 有关浏览器动画的书籍.
* 可以导出到浏览器的动画 GUI 工具.


## SVG

- [Snap.svg](https://github.com/adobe-webplatform/Snap.svg) - 用于现代 SVG 图形的 JavaScript 库.
- [Svg.js](https://github.com/svgdotjs/svg.js) - 用于操作和动画 SVG 的轻量级库.
- [Vivus](https://github.com/maxwellito/vivus) - 在 SVG 上制作绘图动画的库.
- [Walkway](https://github.com/ConnorAtherton/walkway) - 一种为 SVG 元素制作动画的简单方法.
- [Raphael](https://github.com/DmitryBaranovskiy/raphael) - JavaScript 矢量库.
- [Bonsai](https://github.com/uxebu/bonsai) - BonsaiJS 是一个图形库和渲染器.

## Common

- [GSAP](https://github.com/greensock/GSAP) - JavaScript 动画库.
- [TweenJS](https://github.com/CreateJS/TweenJS)  - 一个简单但功能强大的 JavaScript 补间/动画库.  CreateJS 库套件的一部分.
- [Anime.js](https://github.com/juliangarnier/anime) - JavaScript 动画引擎.
- [Mojs](https://github.com/mojs/mojs) - 用于网络的动态图形工具带.
- [Animo.js](https://github.com/ThrivingKings/animo.js) - 一个强大的管理 CSS 动画的小工具.
- [Move.js](https://github.com/visionmedia/move.js) - CSS3 支持的 JavaScript 动画框架.
- [Velocity](https://github.com/julianshapiro/velocity) - 加速的 JavaScript 动画.
- [Animateplus](https://github.com/bendc/animateplus) - 现代网络的 A+ 动画模块.
- [Animatic](https://github.com/lvivski/animatic) - CSS 动画引擎.
- [Just Animate](https://github.com/just-animate/just-animate) - 让动画变得简单.
- [Haiku Core](https://github.com/HaikuTeam/core)  - 用于 Web 的交互式 UI 动画引擎.  Haiku Animator 的核心渲染器.
- [Between.js](https://github.com/sasha240100/between.js) - 轻量级 JavaScript (ES6) 补间引擎.
- [Progressbar.js](https://github.com/kimmobrunfeldt/progressbar.js) - 响应灵敏的进度条.
- [Bezier easing](https://github.com/gre/bezier-easing) - 用于 JavaScript 动画缓动的 Cubic-bezier 实现.
- [Glsl easings](https://github.com/glslify/glsl-easings) - GLSL 中的缓动函数.
- [ES6-tween](https://github.com/tweenjs/es6-tween) - ES6 版本的 tween.js.
- [Weeee.js](https://github.com/sfi0zy/weeee) - 微型 Javascript 补间引擎.

## CSS

- [Animate.css](https://github.com/daneden/animate.css)  - 跨浏览器的 CSS 动画库. 就像一件容易的事一样容易使用.
- [Motion-ui](https://github.com/foundation/motion-ui) - 用于创建 CSS 过渡和动画的强大 Sass 库.
- [Magic](https://github.com/miniMAC/magic) - 具有特殊效果的 CSS3 动画.
- [Css-loaders](https://github.com/lukehaas/css-loaders) - 一组使用 CSS 动画的加载微调器.
- [SpinKit](https://github.com/tobiasahlin/SpinKit) - 一组使用 CSS 动画的加载指示器.
- [Bounce.js](https://github.com/tictail/bounce.js) - 立即创建漂亮的 CSS3 动画.

## Canvas

- [EaselJS](https://github.com/CreateJS/EaselJS) - EaselJS 是一个用于在 HTML5 中构建高性能交互式 2D 内容的库.
- [Fabric.js](https://github.com/fabricjs/fabric.js) - 具有动画支持的 JavaScript 画布库.
- [Paper.js](https://github.com/paperjs/paper.js) - 矢量图形脚本的瑞士军刀 – Scriptographer 使用 HTML5 Canvas 移植到 JavaScript 和浏览器.
- [Konva](https://github.com/konvajs/konva) - Konva.js 是一个 HTML5 Canvas JavaScript 框架，它通过为桌面和移动应用程序启用画布交互性来扩展 2d 上下文.
- [Two.js](https://github.com/jonobr1/two.js) - 具有动画支持的 web 渲染器不可知二维绘图 api.
- [Ocanvas](https://github.com/koggdal/ocanvas) - JavaScript library for object-based canvas drawing.
- [Curtainsjs](https://github.com/martinlaxenaire/curtainsjs) - 将 HTML DOM 元素转换为交互式纹理平面的轻量级香草 WebGL JavaScript 库.
- [Hover-effect](https://github.com/robin-dela/hover-effect) - 用于在悬停时绘制和动画图像的 JavaScript 库.
- [Pts.js](https://github.com/williamngan/pts) - Pts 是一个用于可视化和创意编码的 typescript/javascript 库.
- [tsParticles](https://github.com/matteobruni/tsparticles/) - tsParticles 是一个轻量级的 typescript/javascript 库，用于轻松创建粒子动画.

## Animate on scroll

- [AOS](https://github.com/michalsnik/aos) - 动画滚动库.
- [Laxxx](https://github.com/alexfoxy/laxxx) - 简单轻量（3kb 缩小和压缩）vanilla JavaScript 插件，当你滚动时创建流畅漂亮的动画！
- [Wow](https://github.com/matthieua/WOW) - 向下滚动页面时显示 CSS 动画.
- [Scrollreveal](https://github.com/scrollreveal/scrollreveal) - 动画元素滚动到视图中.
- [ScrollMagic](https://github.com/janpaepke/ScrollMagic) - 用于神奇滚动交互的 JavaScript 库.
- [Motus](https://github.com/alexcambose/motus) - 滚动时模仿 CSS 关键帧的动画库.
- [Sal](https://github.com/mciastek/sal) - 以性能为中心的轻量级滚动动画库.

## Text

- [Malarkey](https://github.com/yuanqing/malarkey) - 在 vanilla JavaScript 中模拟打字机效果.
- [Typed.js](https://github.com/mattboldt/typed.js) - 一个 JavaScript 打字动画库.
- [Shuffle-text](https://github.com/ics-ikeda/shuffle-text) - Shuffle-text 是 JavaScript 文本效果库，例如 Flash 的酷遗产.
- [Typebot](https://github.com/akzhy/typebot) - 用于打字动画的 JavaScript 库.
- [Blotter](https://github.com/bradley/Blotter) - 用于在网络上绘制非常规文本效果的 JavaScript API.

## React

- [Motion](https://github.com/framer/motion) - 用于 React 的开源、生产就绪动画和手势库.
- [SVGR](https://github.com/gregberge/svgr) - 将 SVG 转换为 React 组件.
- [React tsParticles](https://github.com/matteobruni/tsparticles/blob/master/components/react/README.md) - *tsParticles* 的 ReactJS 包装器
- [React spring](https://www.react-spring.io/)  - 支持插值的 React 开源、基于 spring-physics 的动画库. 快速和容易使用.

## GUI tools

- [Svgartista](https://svgartista.net/)  - SVG Artista 是一种工具，可帮助您使用纯 CSS 代码为 SVG 图像中的描边和填充属性设置动画. 它应该可以很好地处理路径、直线、多段线、矩形、圆形、椭圆和多边形元素. 但是它不能为 SVG 渐变设置动画，所以请记住这一点.
- [Mantra](https://jeremyckahn.github.io/mantra/)  - Mantra 是一款用于网络动画的时间线编辑工具. 它的灵感来自 Adob​​e Flash 和 After Effects 等工具.
- [Animista](https://animista.net/) - Animista 是一个你可以玩一组预制 css 动画的地方，调整它们并只获得你实际使用的那些.
- [Cssanimate](http://cssanimate.com/)  - 欢迎来到 CssAnimate.com，该工具可在您的浏览器中轻松快速地创建 CSS3 关键帧动画，无需使用任何桌面软件. 如果您想在您的网站上渲染复杂且一致的 CSS3 动画，这个工具就是为您量身打造的！ 您无需任何编码即可创建复杂的 CSS3 关键帧动画，并准备好在您的网站上使用的 CSS 样式.
- [Ceaser](https://matthewlein.com/tools/ceaser)  - 现在我们可以在所有现代浏览器中使用 CSS 转换，让我们把它们变得漂亮. 我喜欢 Flash 和 jQuery 的经典 Penner 方程式，所以我包括了其中的大部分. 如果你和我一样*，你可能会想到默认的缓动选项：“缓入、缓出等”. 神秘的 cubic-bezier 具有很大的潜力，但使用起来很麻烦. 到目前为止. 此外，触摸设备友好！
- [Cubic Bezier](https://cubic-bezier.com/)  - 一个创建贝塞尔曲线的好工具. 您可以将曲线导入库或从库导出曲线，以便与他人共享.
- [Keyframer](http://alexberg.in/keyframer/) - 帮助可视化动画组件和输出所需代码的工具.
- [CSS Animation Kit](http://angrytools.com/css/animation/)  - 从顶部面板中选择任何预定义的示例. 下面的示例有一个@keyframes 的时间轴. 时间轴有 101 个关键帧（0% 到 100%），方向从左到右. 突出显示的关键帧表示某些样式已分配给该点. 您可以在选定的点添加新样式.

## Books

### [SVG animation](https://www.amazon.com/SVG-Animations-Implementations-Responsive-Animation/dp/1491939702)

<img src="https://raw.githubusercontent.com/sergey-pimenov/awesome-web-animation/master/data/covers/92ZiDgAAQBAJ.jpg" width="200"/>

&nbsp;

 SVG 非常强大，它减少了 HTTP 请求并且在任何显示上都清晰. 当您探索响应式动画和性能提升的功能时，它会变得越来越有趣. 当您制作 SVG 动画时，您必须了解正常的图像特征，例如构图、颜色、实现和优化. 但是当你制作动画时，它会以指数方式增加每个因素的复杂性.

### [Creating Web Animations: Bringing Your UIs to Life](https://www.amazon.com/Creating-Web-Animations-Bringing-Your/dp/1491957514/)

<img src="https://raw.githubusercontent.com/sergey-pimenov/awesome-web-animation/master/data/covers/NK9rDgAAQBAJ.jpg" width="200"/>

&nbsp;

由于更快的浏览器、更好的网络标准支持和更强大的设备，网络现在定义了有趣、实用、流畅和令人难忘的下一代用户界面. 钥匙？ 动画片. 但是学习如何创建动画很困难，现有的学习材料并没有解释动画试图解决的 UI 问题的背景. 这就是本书的用武之地.

### [Transitions and Animations in CSS: Adding Motion with CSS](https://www.amazon.com/Transitions-Animations-CSS-Adding-Motion/dp/149192988X/)

<img src="https://raw.githubusercontent.com/sergey-pimenov/awesome-web-animation/master/data/covers/bx2OrgEACAAJ.png" width="200"/>

通过独立使用 CSS 过渡和动画，为您的 Web 应用程序增添活力和深度，并改善用户体验. 通过这本简明的指南，您将了解如何使页面元素移动或改变外观，无论您是想要逼真的弹球、逐渐展开下拉菜单，还是只是在用户将鼠标悬停在某个元素上时引起人们的注意.

### [Designing Interface Animation: Meaningful Motion for User Experience](https://www.amazon.com/Designing-Interface-Animation-Meaningful-Experience/dp/1933820322/)

<img src="https://raw.githubusercontent.com/sergey-pimenov/awesome-web-animation/master/data/covers/Ano3DwAAQBAJ.jpg" width="200"/>

有效的界面动画巧妙地结合了形式和功能，以改善反馈、帮助定位、引导注意力、显示因果关系并表达您的品牌个性.  Designing Interface Animation 向您展示了如何创建既能平衡目的和风格又能无缝融入用户体验的网络动画. 本书是面向网页设计师、UX 专业人员和前端开发人员的动效设计理论和实践速成课程.

### [Web Animation using JavaScript: Develop & Design](https://www.amazon.com/Web-Animation-using-JavaScript-Develop/dp/0134096665)

<img src="https://raw.githubusercontent.com/sergey-pimenov/awesome-web-animation/master/data/covers/4Wo0BwAAQBAJ.jpg" width="200"/>

自闪烁横幅广告和滚动新闻行情的时代以来，我们已经取得了长足的进步. 如今，iOS 和 Android 令人惊叹的动态设计极大地改善了用户体验，而不是降低了用户体验. 当今最好的网站和应用程序利用动画来改善界面的感觉和直观性. 没有动画的网站开始让人觉得过时了. 本书为您提供了一个技术基础，让您能够以视觉上令人惊叹且可通过编程维护的方式实现动画.

### [CSS Animations and Transitions for the Modern Web](https://www.amazon.com/gp/product/0133980502/)

<img src="https://raw.githubusercontent.com/sergey-pimenov/awesome-web-animation/master/data/covers/848sBQAAQBAJ.png" width="200"/>

现代网站使用各种动画效果，不仅可以提高可用性，还可以让用户感到愉悦和惊喜. 其中一些效果需要复杂的脚本编写或编程技能，但许多都在已经熟悉 CSS 和 HTML 的设计人员的掌握范围内.  CSS Animations and Transitions for the Modern Web 向设计人员展示了如何使用 CSS3 样式定义随时间向网页添加移动.

### [Animation in HTML, CSS, and JavaScript](https://www.amazon.com/Animation-HTML-JavaScript-Kirupa-Chinnathambi/dp/1502548704)

<img src="https://raw.githubusercontent.com/sergey-pimenov/awesome-web-animation/master/data/covers/47ffoQEACAAJ.png" width="200"/>

本书将帮助您使用 HTML、CSS 和 JavaScript 创建实用/可用/非常酷的动画. 每一章都充满了清晰解释的概念、精美的插图、色彩缤纷的代码片段和令人生畏的单行代码，保证让你的朋友嘲笑一切. 您将从学习如何在 CSS 中创建动画和过渡开始. 最后，您将学习如何通过操纵 DOM 元素以及在画布上推动像素来使用 JavaScript 创建动画.

### [Foundation HTML5 Animation with JavaScript](https://www.amazon.com/Foundation-HTML5-Animation-JavaScript-Lamberta/dp/1430236655/)

<img src="https://raw.githubusercontent.com/sergey-pimenov/awesome-web-animation/master/data/covers/RmphScK8u-gC.jpg" width="200"/>

 Foundation HTML5 Animation with JavaScript 涵盖了使用 HTML5 画布创建动态脚本动画所需了解的所有内容. 它提供了您需要的所有相关数学信息，然后再继续学习加速度、速度、缓动、弹簧、碰撞检测、动量守恒、3D 以及正向和反向运动学等物理概念.  Foundation HTML5 Animation with JavaScript 是所有使用 HTML5 或从 Flash 转换过来的 Web 开发人员的绝佳资源，以创建符合标准的游戏、应用程序和动画，这些游戏、应用程序和动画将适用于所有现代浏览器和大多数移动设备，包括 iPhone、iPad 和安卓设备.

## Videos

- [Yuri Artyukh youtube channel](https://www.youtube.com/user/flintyara) - 这个人为此使用各种技术创建了令人惊叹的网络动画，并以 Steam 格式全部记录下来.

<h3 align="center">✨<a href="https://awesome-web-animation.netlify.com">另请参阅此列表的网页版本</a>✨</h3>

<p align="center">
  <a align="center" href="https://awesome-web-animation.netlify.com">
    <img src="https://api.netlify.com/api/v1/badges/692bdbac-34dc-4783-8a4e-e4a586fee7b6/deploy-status" alt="Netlify deploy status">
  </a>
</p>
