<div class="github-widget" data-repo="msmolyakov/awesome-waves"></div>
<p align="center"><a href="https://wavesprotocol.org/"><img src="https://raw.githubusercontent.com/msmolyakov/awesome-waves/master/logo.svg?sanitize=true" width="50%"/></a></p>

## Awesome Waves [![Awesome](https://awesome.re/badge-flat.svg)](https://awesome.re)

Waves 是用于 Web 3.0 应用程序和去中心化解决方案的开源区块链平台和开发工具集.
    
此列表是在 Waves 区块链上创建去中心化应用程序的有用资源的集合.



## Official

- [Official website](https://wavesprotocol.org/)
- [Blog on Medium](https://medium.com/wavesprotocol)
- [Waves on GitHub](https://github.com/wavesplatform/)
- [Documentation](https://docs.wavesprotocol.org/)

## Learn

- [Ride introduction](https://github.com/wavesplatform/ride-introduction) - Ride 的最短和最简单的解释.\
提供其他语言版本： [French](https://medium.com/@crashartifacts/introduction-%C3%A0-ride-ad6c413f98ee).
- [Mastering Web3 with Waves](https://stepik.org/course/54415) - Stepik 上的 dApps 编程在线课程.\
提供其他语言版本： [Deutsch](https://stepik.org/course/56101), [Dutch](https://github.com/msmolyakov/awesome-waves/blob/master/stepik.org/course/56120), [French](https://github.com/msmolyakov/awesome-waves/blob/master/stepik.org/course/55963), [Greek](https://stepik.org/course/56168), [Hindi](https://stepik.org/course/56024), [Japanese](https://github.com/msmolyakov/awesome-waves/blob/master/stepik.org/course/56157), [Portuguese](https://stepik.org/course/56162), [Russian](https://stepik.org/course/56401), [Spanish](https://stepik.org/course/56010), [Turkish](https://stepik.org/course/56131).
- [Mastering Web3 with Waves (on Medium)](https://medium.com/mastering-web3-with-waves) - Stepik 课程的所有材料都作为 Medium 上的文章.\
提供其他语言版本： [Deutcsh](https://medium.com/web3withwavesde), [Dutch](https://medium.com/leer-web3-0-met-waves), [French](https://medium.com/ma%C3%AEtriser-le-web-3-0-avec-waves), [Hindi](https://link.medium.com/D6jo2gBtw5), [Portuguese](https://medium.com/dominando-web-3-0-com-waves), [Spanish](https://medium.com/dominando-web3-0-con-waves).
- [Ride Cheat Sheet PNG](https://www.signature-chain.com/web3-pdf/cheat-sheet.png) - 重要骑行关键点的快速概览.\
以其他格式提供： [PDF](https://www.signature-chain.com/web3-pdf/cheat-sheet.pdf) - [PSD](https://www.signature-chain.com/web3-pdf/cheat-sheet.psd) ([Font](https://fonts.google.com/specimen/Open+Sans)).\
提供其他语言版本： [PNG French](https://www.signature-chain.com/web3-pdf/cheat-sheet_FR.png) - [PDF French](https://www.signature-chain.com/web3-pdf/cheat-sheet_FR.pdf).

## Articles

- [How to Build, Deploy and Test a Waves Ride dApp](https://medium.com/wavesprotocol/how-to-build-deploy-and-test-a-waves-ride-dapp-785311f58c2)  - 如何编写简单的去中心化应用程序 (dApp) 并在 Waves 节点上运行它.  ([ru](https://habr.com/ru/company/waves/blog/459773/))
- [How to: Waves dApps — DAO. Example using Ride-language for smart contracts](https://medium.com/@alexpupyshev/how-to-waves-dapps-dao-example-using-ride-language-for-smart-contracts-3b0ca55e48a8)  - 如何创建用于项目投票和集体投资的简单 DAO dApp.  ([ru](https://habr.com/ru/post/447808/))
- [How to: Waves dApps — Prediction Markets example with Ride-language. Part 1](https://medium.com/@alexpupyshev/how-to-waves-dapps-prediction-markets-example-with-ride-language-part-1-27b642f2fd0d) - 如何创建简单的预测市场 dApp（如 Augur 或 Gnosis）以创建新市场、交易股票并在预测成真时获胜.
- [Simple voting on the Waves blockchain](https://docs.wavesprotocol.org/en/smart-contracts/simple-voting-on-the-waves-blockchain.html)  - HOA（房主协会）负责人询问大楼的租户：“亲爱的居民，您是否同意在您大楼的院子里建造儿童游乐场？”. 目标：在 Waves 区块链上实现租户之间的投票.
- [How to use Waves Signer](https://medium.com/@izhur27/getting-started-with-waves-signer-893017c9b7ae) - 如何在您的网站上授权和签署交易.
- [Understanding Waves Signer — Nuxt.js integration step-by-step](https://medium.com/auctionlance/understanding-waves-signer-nuxt-js-integration-step-by-step-fe33e19c2eb8) - 如何创建演示应用程序以使用 Waves Signer 和 Nuxt.js 进行身份验证以进行 SSR（服务器端渲染）.
- [Certificado, Part 1. How to build your first blockchain-based app in 15 minutes](https://medium.com/wavesprotocol/how-to-build-your-first-blockchain-based-app-in-15-minutes-83de36826143) - 关于如何创建基于区块链的证书存储的教程（[ru](https://vk.com/@wavesplatform-kak-sozdat-pervoe-prilozhenie-na-blokcheine-za-15-minut)).
- [Certificado, Part 2. What are Smart Contracts and how to use them in your app](https://medium.com/wavesprotocol/what-are-smart-contracts-and-how-to-use-them-in-your-app-a1c0d62d1a5) - 关于如何创建基于区块链的证书存储的教程（[ru](https://vk.com/@wavesplatform-chto-takoe-smart-kontrakty-i-kak-ih-ispolzovat-v-prilozhenii)).
- [How to: offer a free trial for your dApp](https://medium.com/wavesprotocol/make-your-dapp-free-for-a-user-d560b38ec598) - 降低 dApp 用户门槛的详细指南（[ru](https://vk.com/@wavesplatform-how-to-besplatnye-dlya-polzovatelya-decentralizovannye-prilo)).
- [Blockchain Trigger: a tool for automatic smart contract invocation](https://medium.com/wavesprotocol/blockchain-trigger-a-tool-for-automatic-smart-contract-invocation-1cb2748c53be)  - 调用智能合约，用户遇到一些问题，这阻碍了区块链的大规模采用. 一种称为 Blockchain Trigger 的工具可以帮助解决这些问题（[ru](https://vk.com/@wavesprotocol-instrument-dlya-dlya-avtomaticheskogo-vyzova-smart-kontrakto)).
- [How to avoid common mistakes in dApp development](https://medium.com/wavesprotocol/how-to-avoid-common-mistakes-in-dapp-development-61015e700459) - 在为 Web 3.0 开发 dApp 时，我们如何避免最常见的错误（[ru](https://vk.com/@wavesprotocol-kak-izbezhat-oshibok-pri-razrabotke-dapp)).
- [How to write decentralized oracles in Ride](https://medium.com/wavesprotocol/how-to-write-decentralized-oracles-in-ride-f2c096812b18)  - 我们如何解决向区块链提供真实世界数据的问题？ 介绍 Oraculus——一个用于创建去中心化预言机的智能合约（[ru](https://vk.com/@wavesprotocol-kak-napisat-decentralizovannyi-orakul-na-ride)).
- [Billy — motivation bot for Slack and Microsoft Teams](https://medium.com/@ikardanov/billy-motivation-and-recognition-bot-for-slack-and-microsoft-teams-d05167e4a7f9) - 基于 Waves 区块链的工具，以非财务方式奖励团队成员（[ru](https://vc.ru/tribuna/128472-billy-bot-dlya-motivacii-personala)).
- [How to build a dApp for team motivation](https://medium.com/wavesprotocol/how-to-build-a-dapp-for-team-motivation-8943504e3feb) - Billy 是一个机器人形式的 DApp，它允许一个激励和奖励系统，旨在通过业务交流平台 Slack 来激励员工（[ru](https://vk.com/@wavesprotocol-kak-sozdat-dapp-dlya-motivacii-sotrudnikov)).
- [How to add crypto payments to your online store?](https://medium.com/wavesprotocol/how-to-add-crypto-payments-to-your-online-store-b528b739cdfb) - 如何借助 Waves 生态系统中开发的 Pay Crypto Widget 将加密支付选项添加到您的在线商店.

## Products

### Wallet

- [Waves.Exchange Wallet](https://waves.exchange/) - Waves.Exchange 的 Web 和桌面客户端使您能够加入生态系统并享受全方位的数字资产管理功能.
- [Waves Keeper](https://wavesprotocol.org/protocol/keeper) - 官方浏览器扩展允许管理私钥并与支持 Waves 的网络服务和 dApp 安全无缝地交互.
- [iOS wallet](https://itunes.apple.com/us/app/waves-wallet/id1233158971) - Waves.Exchange 的 iPhone 钱包.
- [Android wallet](https://play.google.com/store/apps/details?id=com.wavesplatform.wallet) - Waves.Exchange 的 Android 设备钱包.
- [WavesFX](https://github.com/wavesfx/wavesfx) - 适用于 Windows、macOS 和 Linux 的社区驱动原生桌面钱包，为用户提供多网络和多地址功能.

### Explorer

- [Waves Explorer](https://wavesexplorer.com) - 官方 Waves Explorer.
- [Dev PyWaves](http://dev.pywaves.org) - PyWaves 的区块链浏览器.
- [w8io](https://w8io.ru/) - 区块链浏览器 [deemru](https://github.com/deemru).

### Other

- [WavesLabs](https://waveslabs.com/) - 一项支持有才华的开发人员和有前途的初创公司的计划，这些初创公司专注于构建将构成 Web 3.0 支柱的去中心化技术.
- [Node](https://github.com/wavesplatform/Waves) - GitHub 上的 Waves 节点存储库.
- [GRPC Server](https://grpc.wavesnodes.com:6870) - 主网的公共 GRPC 接口.
- [Go Node](https://github.com/wavesplatform/gowaves) - 用于 Waves 区块链的 Go 库和工具，Node 的替代实现（正在进行中）.
- [Waves Data Service](https://api.wavesplatform.com/v0/docs/#/)  - 官方数据服务. 从 Waves 区块链获取数据的简单方便的方法.
- [Waves Oracles](https://oracles.wavesexplorer.com/) - 神谕目录.
- [Token Rating](https://tokenrating.wavesexplorer.com) - 提供一种方法来评估和汇总整个 Waves 社区对在 Waves 平台上发行的代币（项目）的意见.
- [WavesCap](https://wavescap.com/) - Waves 资产的 CoinMarketCap.
- [ItemMarket](https://item.market/)  - 去中心化平台，每个人都可以在其中以代币形式代币化、出售和购买某人的游戏内物品.  ([read more](https://medium.com/wavesprotocol/item-market-is-launched-cabefe915c04))

## Playground

### Testnet

Testnet 是一个稳定的网络，并从主网完全复制了配置和节点版本，但允许获得免费的 Waves 代币来测试你需要的东西.

- [Explorer](https://wavesexplorer.com/testnet)  - 官方测试网浏览器. 它有一个 [faucet](https://wavesexplorer.com/testnet/faucet) 获得一些免费的 Waves 代币.
- [Node API](https://nodes-testnet.wavesnodes.com/) - 测试网节点的 API.
- [Data Service](https://api-test.wavesplatform.com/v0/docs/) - 测试网的官方数据服务.

### Stagenet

 Stagenet 是一个不稳定的网络，用于在将 Waves 官方产品发布到主网和测试网之前对其进行测试. 但您也可以赚取免费的 Waves 代币来测试您需要的东西. 例如，您的服务或 DApp 与即将发布的版本的兼容性.

- [Explorer](https://wavesexplorer.com/stagenet)  - 官方探险家. 它有一个 [faucet](https://wavesexplorer.com/stagenet/faucet) 获得一些免费的 Waves 代币.
- [Node API](https://nodes-stagenet.wavesnodes.com/) - Waves 节点的 Swagger REST API.
- [IDE](https://stagenet.waves-ide.com) - 用于在 Stagenet 上创建 Ride 智能合约的在线 IDE.

### Docker images

- [WavesNode](https://hub.docker.com/r/wavesplatform/wavesnode)  - Waves 平台节点的 Docker 镜像. 支持任何官方或自定义网络.
- [K8s by loxal](https://hub.docker.com/r/loxal/waves-node) - 构建容器是为了在 Kubernetes 集群中作为即发即弃的“StatefulSet”运行.
- [waves-private-node](https://hub.docker.com/r/wavesplatform/waves-private-node)  - 私有本地 Waves 节点. 运行您自己的隔离节点以开发智能合约和任何实验的最简单方法.
- [explorer](https://hub.docker.com/r/wavesplatform/explorer) - 用于您的节点的 Waves Explorer.

## Frameworks and tools

### The Ride programming language

- [Waves IDE](https://waves-ide.com/) - 用于在 Ride 上创建智能合约的在线 IDE.
- [ride-examples](https://github.com/wavesplatform/ride-examples) - 使用 Ride 的帐户和资产脚本示例.
- [waves-ride](https://marketplace.visualstudio.com/items?itemName=wavesplatform.waves-ride) - 支持 Ride 的 Visual Studio Code 扩展.
- [vim-ride](https://github.com/rosmanov/vim-ride) - 用于 Ride 语法突出显示的 Vim 插件.
- [surfboard](https://github.com/wavesplatform/Surfboard) - 使用 Ride 语言和测试的 CLI.
- [Paddle](https://github.com/msmolyakov/paddle) - 为您的 dApp 和其他智能合约编写测试的 Java 库.

### Client libraries
#### C/C++
- [waves-c](https://github.com/wavesplatform/waves-c) - 用于 Waves 的 C 库.
- [wavespp](https://github.com/wavesplatform/wavespp) - C++ 包装器 [waves-c](https://github.com/wavesplatform/waves-c) 图书馆.
- [nanos-app-waves](https://github.com/wavesplatform/nanos-app-waves) - Ledger Nano S 的 Waves 钱包应用程序.
#### C#
- [WavesCS](https://github.com/wavesplatform/WavesCS) - C# library to interact with the Waves blockchain.
#### Java/Kotlin
- [WavesSDK-android](https://github.com/wavesplatform/WavesSDK-android) - Kotlin SDK for Mobile Apps on Android.
- [WavesJ](https://github.com/wavesplatform/WavesJ) - 与 Waves 区块链和 DEX 交互的 Java 库.
- [waves-crypto-java](https://github.com/msmolyakov/waves-crypto-java) - 用于处理 Waves 区块链中使用的加密原语的库.
#### JavaScript/TypeScript
- [Waves Signer](https://github.com/wavesplatform/signer) - 从您的网络应用程序与 Waves 区块链交互的库（[example provider](https://github.com/waves-exchange/provider-web)).
- [vue-waves-signer](https://github.com/opensolutionsweb3/vue-waves-signer) - Vue.js 的 Waves Signer 实现.
- [pay-crypto-widget](https://github.com/vlzhr/pay-crypto-widget) - 用于在您的网站上接受加密支付的 JS 小部件.
- [crypto-donate](https://github.com/vlzhr/crypto-donate) - 允许向内容作者捐赠 Waves 令牌的 HTML 小部件.
- [waves-transactions](https://github.com/wavesplatform/waves-transactions) - 用于构建和签署交易的 JS 库.
- [ts-lib-crypto](https://github.com/wavesplatform/ts-lib-crypto) - Typescript 实现，例如 Waves 协议中使用的签名验证和协议条目.
#### Go
- [go-lib-crypto](https://github.com/wavesplatform/go-lib-crypto) - 用于 Waves 的统一加密原语的 GoLang 实现.
#### PHP
- [WavesKit](https://github.com/deemru/WavesKit) - 用于 PHP 语言的一体化 Waves 平台开发工具包.
#### Python
- [PyWaves](https://github.com/PyWaves/PyWaves) - Waves 区块链平台的面向对象库.
- [ERC20 Gateway Framework](https://github.com/PyWaves/Waves-ERC20-Gateway) - 允许在任何 ERC-20 令牌和 Waves 区块链之间轻松建立网关（[example](https://github.com/iammortimer/TN-WAVES-Gateway)).
- [Waves-Gateway-Framework](https://github.com/jansenmarc/WavesGatewayFramework) - 将其他加密货币连接到 Waves 区块链的框架（[LTC example](https://github.com/jansenmarc/WavesGatewayLTCExample)).
#### Rust
- [WavesRS](https://github.com/petermz/WavesRs) - Waves 区块链的 Rust 接口.
- [waves-lib-rust](https://github.com/waves-rust/waves-lib-rust) - 与 Waves 区块链一起工作的库.
#### Swift
- [WavesSDK-iOS](https://github.com/wavesplatform/WavesSDK-iOS) - 适用于 iOS 上移动应用程序的 SDK.

### Blockchain utils
- [chaincmp](https://github.com/wavesplatform/gowaves/blob/master/cmd/chaincmp) - 用于比较不同节点上的区块链的实用程序.
- [Node Tools extension](https://github.com/msmolyakov/waves-node-tools-extension) - Waves 节点扩展允许矿工为其出租人自动支付并接收有关挖矿进度的通知.
- [Nodes on map](http://waves-nodes-map.ikardanov.com/) - 世界地图上 Waves 主网的所有节点.

### Other tools
- [sh-Ride-brush](https://github.com/msmolyakov/sh-Ride-brush) - Ride 语言的 SyntaxHighlighter 画笔.
- [Ride for Pygments](https://github.com/pygments/pygments/blob/master/pygments/lexers/ride.py) - 这 [Pygments](https://github.com/pygments/pygments) 荧光笔正式支持开箱即用的 Ride.

## Built on Waves

### Catalogs

- [Waves on DappRadar](https://dappradar.com/rankings/protocol/waves) - 在 DappRadar 上发布的 Waves dApp.
- [dAppOcean](https://www.dappocean.io/) - 基于 Waves 区块链的去中心化应用程序生态系统.

### Games
- [NyanCat: The Crypto Race](https://nyancat.io/) - 建立您自己的 Nyan Cat 收藏，与其他玩家比赛并在每周排行榜上获得最高 2000 美元的奖励！
- [Shadow Era](http://www.shadowera.com/) - Shadow Era 是一款免费的在线收藏集换式纸牌游戏，适用于 iOS、Android、PC 和 Mac.
- [Coin Flip](https://www.coin-flip.io/) - 选择硬币面，下注，看看您是否幸运.
- [Dice Roller](https://www.dice-roller.io/) - 选择骰子面，下注，看看您是否幸运.
- [Ride On Waves](https://www.waves-rider.io/)  - 您可以选择要下注的波数. 这是一个浮动赌注从 0.5 到 6 WAVES 的游戏.

### Projects

- [Neutrino](https://github.com/ventuary-lab/neutrino-contract) - 由 WAVES 令牌抵押的算法价格稳定的加密货币协议.
- [Billy](https://iambilly.app)  - 团队的激励工具.  Billy 提供了一种产品来营造合作氛围，让公司专注于核心价值观，并通过创建团队经济来激励分享.
- [Ventuary-DAO](https://alpha.ventuary.space/) - 专门用于过滤 dApp 想法和刺激 Waves 社区参与 Web 3.0 采用的沙盒.
- [Tokenomica](https://tokenomica.com/)  - 安全令牌发行平台. 轻松自信地创建和交易数字资产.
- [LIGA](https://ligatokens.io/) - 一个带有代币化体育赛事的平台，使您能够处理实时汇率并与他人交易您的个人预测.
- [WaveFlow](https://waveflow.xyz/)  - 允许您创建新的或使用现有的交换器，为某些交易对提供恒定的供应和需求. 算法定价用于确保供需的一致性——代币越受欢迎，其价格设定得越高. 每个交换器都是一个用 Ride ([example of trading bot](https://github.com/vlzhr/waveflow-trading-bot)).
- [Lombardini](https://lombardini.io/) - 立即为 WAVES 借用 WBTC.
- [Blockchain Cars](http://blockchaincars.io/) - 运输即服务.
- [WavesAffi](https://github.com/bettexproject/WavesAffi) - Waves 区块链上的去中心化联盟计划.
- [One Million Pixel Waves](https://www.onemillionpixelwaves.com/) - 智能合约支持的网站完全运行在 Waves 区块链上，任何人都可以拥有一块区块链并通过图像和链接使其永生.
- [Signature Chain](https://www.signature-chain.com/) - Signature Chain 的主要目标是开发一个允许文件和文档认证的平台.
- [Auctionlance Platform](https://beta.auctionlance.com) - 自由职业者市场，客户可以在其中使用 Waves、Waves 代币和其他加密货币雇佣和支付自由职业者.


## Community

### International

- [Waves Dev Jedi. Ride for dApps](https://t.me/waves_ride_dapps_dev) - dApps 开发者的电报聊天.
- [Discord](https://discordapp.com/invite/cnFmDyA) - 官方不和谐.
- [Waves Community Portal](https://wavescommunity.com/) - 官方门户网站提供了构成 Waves 生态系统的一些工具和项目.
- [Waves Community Forum](https://forum.wavesplatform.com/) - 官方论坛.
- [Stack Overflow](https://stackoverflow.com/questions/tagged/wavesplatform)  - 提出技术问题的最佳场所. 使用标签“wavesplatform”和“ride”.

### Africa

- [Telegram](https://t.me/wavesafrica) - 充满热情的开发人员和 web 3.0 爱好者组成的整个非洲社区.

### Dutch

- [Telegram](https://t.me/wavesdappsnl) - 开发者 dApp 的电报聊天.

### French

- [Telegram](https://t.me/wavesdappsFR) - dApps 开发者的电报聊天.
- [Dev France on Youtube](https://www.youtube.com/channel/UC2DS9ktTKWGW3NHHV2Ja3_A) - 一个专门学习在 Blockchain Waves 上开发去中心化应用程序 (dApp) 的渠道.
- [Dev France on Facebook](https://www.facebook.com/wavesfr)
- [Dev France on Twitter](https://twitter.com/WavesDevFr)

### Greek

- [Telegram](https://t.me/wavesdappsgr) - dApp 开发人员的电报社区.

### Hindi

- [Telegram](https://t.me/wavesdappsid) 软件开发人员的电报聊天.

### Japanese

- [Telegram](https://t.me/wavesjapandevs) - DApps 开发人员的电报聊天.

### Philippine

- [Telegram](https://t.me/wavesDevPh) - Telegram Waves 菲律宾开发商.

### Portuguese

- [Telegram - WavesBrasil](https://t.me/WavesBrasil) - Waves 社区的电报聊天.
- [Telegram - Waves Dev Jedi 🇧🇷 🇵🇹](https://t.me/joinchat/DtIEA0mI2HvmVbyBBodOew) - dApps 开发者的电报聊天.
- [Telegram - Waves Portugal](https://t.me/WavesPortugal) - Waves 葡萄牙语社区聊天.

### Russian

- [Telegram](https://t.me/tradisys_russia) - dApps 开发者的电报聊天.

### Spanish

- [Telegram](https://t.me/wavesdappsES) - dApp 开发人员的电报聊天.

### Turkish

- [Telegram](https://t.me/wavesdappstu) - 软件开发人员的电报聊天.

## Contribute

欢迎投稿！

如果您发现了一些很棒的东西或想要修复某些东西，请随时发送 Pull Request. 阅读 [contribution guidelines](https://github.com/msmolyakov/awesome-waves/blob/master/CONTRIBUTING.md) 第一的.

我会很高兴你的建议！
