<div class="github-widget" data-repo="yenchenlin/awesome-watchos"></div>
<img src="https://raw.githubusercontent.com/yenchenlin1994/awesome-watchos/master/resources/title.png" width="500">
=========================

## Deprecated! This list will no longer be updated due to my focus shift.

=========================
[![Build Status](https://travis-ci.org/yenchenlin1994/awesome-watchos.svg?branch=master)](https://travis-ci.org/yenchenlin1994/awesome-watchos)

很棒的 watchOS 框架、库、示例应用程序的精选列表.


## Getting Started
 * [Apple Watch Programming Guide](https://developer.apple.com/library/ios/documentation/General/Conceptual/WatchKitProgrammingGuide/index.html) - Apple 官方 Apple Watch 编程指南.

## Libraries And Frameworks

### Connectivity
 * [MMWormhole](https://github.com/mutualmobile/MMWormhole) - 用于合成、处理和分析声音的强大工具包.

  <space><space><img src="https://raw.githubusercontent.com/mutualmobile/MMWormhole/master/MMWormhole.gif" width="500") alt="Example App"/>

### UI
 * [IGInterfaceDataTable](https://github.com/Instagram/IGInterfaceDataTable) - WKInterfaceTable 上的一个类别，可以更轻松地配置具有多维数据的表格.

  <space><space><img src="https://raw.githubusercontent.com/Instagram/IGInterfaceDataTable/master/images/example.jpg" width="500") alt="Example App"/>

 * [JBWatchActivityIndicator](https://github.com/mikeswanson/JBWatchActivityIndicator) - 为 Apple Watch 生成活动指示器图像的简单方法.

  <space><space><img src="https://camo.githubusercontent.com/3bc9d761836a40e088f45285ac52dd5fef89df1b/687474703a2f2f7777772e6d696b657377616e736f6e2e636f6d2f66696c65732f4a4257617463684163746976697479496e64696361746f722f4a4257617463684163746976697479496e64696361746f722e676966" width="300") alt="Example App"/>
### Charts
 * [YOChartImageKit](https://github.com/yasuoza/YOChartImageKit) - watchOS 的图表图像框架.

  <space><space><img src="https://raw.githubusercontent.com/yasuoza/YOChartImageKit/assets/images/watchos/all.png") alt="Example App" width="760"/>

 * [NKWatchChart](https://github.com/NilStack/NKWatchChart) - 基于 PNChart 和 ios-charts 的 Apple Watch 图表库.

  <space><space><img src="https://db.tt/UAWEZ1AF") alt="Example App" width="250"/>

## Design

### Design Guidelines
 * [Designing for Apple Watch](https://developer.apple.com/videos/wwdc/2015/?id=802) - Apple 的 WWDC 2015 官方会议关于如何为 Apple Watch 设计.
 * [ Watch Human Interface Guidelines](https://developer.apple.com/watch/human-interface-guidelines/) - Apple 的官方人机界面指南.
 * [11 Tips For Designing Apps for Apple Watch](https://medium.com/design-idea/11-tips-for-designing-apps-for-apple-watch-4b6cc2cb11d3) - 一些快速提示，可帮助您构建更好的手表应用程序.
 * [Icons for Apple Watch – The Definitive Guide](http://blog.iconfinder.com/icons-apple-watch-definitive-guide/) - 帮助您创建自己的手表应用程序图标的指南.

### Design Resources
 * [ Watch Design Resources](https://developer.apple.com/watch/human-interface-guidelines/resources/) - Apple 提供的官方设计资源，包括 Apple Watch 边框、指南、模板、字体.
 * [Chart of Apple Watch Complication Types and Layouts](http://i.imgur.com/4Thz881.jpg) - 所有可能的并发症组合的有用图表.

## Tools

### Prototyping
 * [thinkapps for watch](http://thinkapps.com/watch-apps) - 一个网站可帮助您在短短 10 分钟内创建免费的 Apple Watch App 原型.

### Images Generator
 * [RadialChartImageGenerator](https://github.com/hmaidasani/RadialChartImageGenerator) - 用于 Apple Watch 的径向条形图生成器.
 * [KFWatchKitAnimations](https://github.com/kiavashfaisali/KFWatchKitAnimations) - 一个图像生成器，通过从 iOS 模拟器录制动画，为  Watch 创建精美的 60 FPS 动画.

## Sample Apps
 * [Lister](https://developer.apple.com/library/ios/samplecode/Lister/Introduction/Intro.html) - 官方示例应用程序演示了 Apple Watch 集成.

   <space><space><img src="https://raw.githubusercontent.com/yenchenlin1994/awesome-watchos/master/resources/lister.png") alt="Example App" width="260"/>

 * [WatchKit Catalog](https://developer.apple.com/library/ios/samplecode/WKInterfaceCatalog/Introduction/Intro.html) - 官方示例应用程序演示了如何使用 WatchKit 框架中可用的 UI 元素.
 * [Cherry](https://github.com/kenshin03/Cherry) - 专为  Watch 设计的迷你番茄钟应用程序.

   <space><space><img src="https://raw.githubusercontent.com/kenshin03/Cherry/master/cherry-screencaps.gif") alt="Example App" width="250"/>

 * [Bitcoin Tracker](http://www.raywenderlich.com/89562/watchkit-tutorial-with-swift-getting-started) - 比特币价格跟踪应用程序.

    <space><space><img src="http://cdn5.raywenderlich.com/wp-content/uploads/2014/11/watch-final.png") alt="Example App" width="250"/>

 * [WWDC](https://github.com/sugarso/WWDC) - 一个开源的 WWDC 热门派对应用程序.

   <space><space><img src="https://raw.githubusercontent.com/sugarso/WWDC/master/Assets/watch1.png") alt="Example App" width="230"/>

 * [SwiftHN](https://github.com/Dimillian/SwiftHN) - 用 Swift 编写的 Hacker News 阅读器.
 * [BaiduFM-Swift](https://github.com/belm/BaiduFM-Swift) - BaiduFM 的 Apple Watch 应用程序.

    <space><space><img src="https://raw.githubusercontent.com/belm/BaiduFM-Swift/master/ScreenShot/BaiduFM-Swift_AppleWatch_00.png") alt="Example App" width="250"/>

 * [done-swift](https://github.com/FancyPixel/done-swift) - 一个示例应用程序，用于演示 WatchKit 应用程序与其使用 Realm 的主应用程序之间的数据共享.

    <space><space><img src="https://raw.githubusercontent.com/FancyPixel/done-swift/master/assets/screenshot.gif") alt="Example App" width="400"/>

 * [HighstreetWatchApp](https://github.com/GetHighstreet/HighstreetWatchApp)  - watchKit 应用程序建立在<http://highstreetapp.com>平台.

    <space><space><img src="https://raw.githubusercontent.com/GetHighstreet/HighstreetWatchApp/master/Documentation/Assets/walkthrough.gif") alt="Example App" width="350"/>

 * [OnTime](https://github.com/D-32/OnTime) - 用于访问 SBB 时间表的 Apple Watch 应用程序.

    <space><space><img src="https://camo.githubusercontent.com/3d2f8f30ae9ce705cc5467d3736baac2253c6dc2/687474703a2f2f34362e3130352e32362e312f75706c6f6164732f7362626170706c65322e6a7067") alt="Example App" width="500"/>

 * [WatchNotes](https://github.com/azamsharp/WatchNotes) - 一款 Apple Watch 应用程序，可在您的手腕上显示笔记.

    <space><space><img src="https://camo.githubusercontent.com/689a09260a6427ede9580b298c141320132796df/68747470733a2f2f646c2e64726f70626f7875736572636f6e74656e742e636f6d2f752f32303131363433342f57617463684e6f7465732e676966") alt="Example App" width="500"/>

 * [WatchPics](https://github.com/D-32/WatchPics) - 适用于 Apple Watch 的 Instagram.

    <space><space><img src="https://camo.githubusercontent.com/544c66f439b1328155ca4463c2fa73e514f80800/687474703a2f2f34362e3130352e32362e312f75706c6f6164732f7761746368706963732e6a7067") alt="Example App" width="500"/>

 * [WatchKit-Apps](https://github.com/kostiakoval/WatchKit-Apps) - WatchKit 的教程应用程序.
 * [watchOS-2-Sampler](https://github.com/shu223/watchOS-2-Sampler) - watchOS 2 新功能的代码示例.

 * [soon](https://github.com/sandofsky/soon) - 倒计时应用程序.

    <space><space><img src="https://raw.githubusercontent.com/sandofsky/soon/master/screenshot.png") alt="Example App" width="230"/>

## Books
 * [watchOS 2 by Tutorials](http://www.raywenderlich.com/store/watchos-2-by-tutorials)

    <space><space><img src="http://cdn5.raywenderlich.com/wp-content/themes/raywenderlich/images/store-2015/w2t_PDF_640.png") alt="Example App" width="320"/>

 * [Apple Watch for Developers: Advice & Techniques from Five Top Professionals](http://www.amazon.com/gp/product/1484213394/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=1484213394&linkCode=as2&tag=feedingtheneu-20&linkId=PDZBCYAGPZXWHDQU)

    <space><space><img src="http://ecx.images-amazon.com/images/I/41Opqcd7F1L._SX331_BO1_204_203_200_.jpg") alt="Example App" width="280"/>

## Tutorials

### WatchKit Introduction
 * [WatchKit Tutorial with Swift Part 1: Getting Started](http://www.raywenderlich.com/89562/watchkit-tutorial-with-swift-getting-started)
 * [WatchKit Tutorial with Swift Part 2: Tables and Network Requests](http://www.raywenderlich.com/96589/watchkit-tutorial-swift-tables-network-requests)
 * [WatchKit Tutorial with Swift Part 3: More Tables, Glances and Handoff](http://www.raywenderlich.com/96741/watchkit-tutorial-with-swift-tables-glances-and-handoff)

### WatchOS 2 New Features
##### Hardware
 * [WatchKit 2 Hardware Bits: Using the Digital Crown](https://www.bignerdranch.com/blog/watchkit-2-hardware-bits-using-the-digital-crown/?utm_campaign=WatchKit%2BResources&utm_medium=web)
 * [WatchKit 2 Hardware Bits: The Taptic Engine](https://www.bignerdranch.com/blog/watchkit-2-hardware-bits-the-taptic-engine/?utm_campaign=WatchKit%2BResources&utm_medium=web)
 * [WatchKit 2 Hardware Bits: The Accelerometer](https://www.bignerdranch.com/blog/watchkit-2-hardware-bits-the-accelerometer/?utm_campaign=WatchKit%2BResources&utm_medium=web)

##### Animations
 * [The Power of Animations](http://code.tutsplus.com/tutorials/watchos-2-the-power-of-animations--cms-24302?utm_campaign=This%2BWeek%2Bin%2BSwift&utm_medium=email&utm_source=This_Week_in_Swift_47) - 教程演示了如何通过更改布局属性为用户界面设置动画.

##### ClockKit
 * [Writing a WatchKit Complication in watchOS 2](http://www.sneakycrab.com/blog/2015/6/10/writing-your-own-watchkit-complications?utm_campaign=WatchKit%2BResources&utm_medium=web) - 关于如何向您的手表应用程序添加自定义复杂功能的教程.

##### Connectivity
 * [How to communicate between devices using Watch Connectivity](http://www.kristinathai.com/watchos-2-tutorial-using-sendmessage-for-instantaneous-data-transfer-watch-connectivity-1/?utm_campaign=WatchKit%2BResources) - 关于如何使用 Watch Connectivity 框架在设备之间进行通信的教程.

## Twitters
* [WatchKit Resources](https://twitter.com/WatchKitSources)

## Other Awesome Lists
其他非常棒的列表可以在
 * [awesome-awesomeness](https://github.com/bayandin/awesome-awesomeness) 列表.
 * [Open Source apps](https://github.com/dkhamsing/open-source-ios-apps) 开源 iOS 应用列表
 * 真快
   * [@matteocrippa](https://github.com/matteocrippa/awesome-swift) - 令人敬畏的 swift 资源的协作列表.
   * [@Wolg](https://github.com/Wolg/awesome-swift) - 精选的 Swift 框架、库和软件列表.
 * [awesome watchkit apps](https://github.com/sanketfirodiya/sample-watchkit-apps) 示例 watchkit 应用程序和教程的精选列表.
 * [iOS Learning Resources](https://github.com/sanketfirodiya/iOS-learning-resources) 全面收集高质量、经常更新和维护良好的 iOS 教程网站.
 * [awesome-ios-animation](https://github.com/sxyx2008/awesome-ios-animation) - 精选的 iOS 动画列表，包括 Objective-C 和 Swift 库.
 * [awesome-ios-chart](https://github.com/sxyx2008/awesome-ios-chart) - 精选的 iOS 图表库列表，包括 Objective-C 和 Swift.
 * [awesome-gists](https://github.com/vsouza/awesome-gists#ios) - 惊人的要点列表（iOS 部分）.
 * [awesome-ios-ui](https://github.com/cjwirth/awesome-ios-ui) - 很棒的 iOS UI/UX 库的精选列表.
 * [iOS App Development on Medium](https://medium.com/ios-os-x-development) - 关于为 iOS、Apple Watch 和 iPad/iPhone 构建应用程序的故事和技术提示

## Contributing
欢迎投稿！ 阅读 [contribution guidelines](https://github.com/yenchenlin/awesome-watchos/blob/master/contributing.md) 第一的.

欢迎贡献&amp;非常感谢！

## License

[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [YenChen Lin](https://github.com/yenchenlin1994) 已放弃该作品的所有版权和相关或邻接权.
