<div class="github-widget" data-repo="sdassow/awesome-veganism"></div>
## Awesome Veganism [![Awesome](https://awesome.re/badge.svg)](https://github.com/sindresorhus/awesome)

> A curated list of awesome resources, pointers, and tips to make veganism easy and accessible to everyone.

[Veganism](https://en.wikipedia.org/wiki/Veganism) is a plant-based lifestyle, avoiding animal products as much as possible.
This list is an attempt to create a community driven approach to guarantee no-nonsense content, 100% aligned with the vegan lifestyle, in order to minimise the effort needed for an awesome experience.



## Books

- [Happily Ever Esther](https://www.grandcentralpublishing.com/titles/steve-jenkins/happily-ever-esther/9781538728123/) - Wonderful true life tale, with a lot of love and compassion, and it's hilarious.
- [That's Not My Momma's Milk!](https://veganpublishers.com/multimedia-archive/thats-not-my-mommas-milk/) - Really simple book, really easy to grasp and makes anyone of any age think, by exploring the animal kingdom and where baby animals get their milk from.

## Shoes

- [Adidas](https://www.adidas.com/us/vegan-shoes) - Various models of vegan shoes.
- [Etnies](https://www.etnies.com/us/collections/vegan/) - Light and very comfortable shoes.
- [Vegano Shoes](https://www.veganoshoes.com.br/) - Boots, shoes and sneakers reference in Brazil.

## Bakeries

*This category is strictly limited to fully vegan / 100% plant-based bakeries.*

- Amsterdam, Netherlands
  - [Vegan Sugar Mama's](https://vegansugarmamas.nl/) - Delicious vegan treats in various colors, and even cookies with a personalised picture.

- Berlin, Germany
  - [Brammibal's Donuts](https://www.brammibalsdonuts.com/) - The most tasty high quality vegan donuts in Berlin.

- Midvale, UT, USA
  - [Sweet Hazel & Co](https://sweethazelandco.com/) - Tasty candy bars, food and more. LGBTQ+ friendly!

- Monster, Netherlands
  - [My Cakes](https://macarononline-nl.mijndomeinwebwinkel.nl/) - Amazing selection of cakes, macarons, dutch specialties, and more.

- Portland, OR, USA
  - [Shoofly bakery](https://www.shooflyveganbakery.com/) - Vegan items delivered.

- Salt Lake City, UT, USA
    - [Yumz Vegan Bakery & Cafe](https://www.toasttab.com/yumz-llc-3490-s-state-st/v3/) - Mexican vegan bakery with excellent food options.

- Zaandijk, Netherlands
  - [Vegan bakery](https://www.veganbakery.nl/) - Dutch vegan bakery with a big selection of vegan cakes, muffins, and other awesomeness.


## Restaurants

*This category is strictly limited to fully vegan / 100% plant-based restaurants.*

- Amsterdam, Netherlands
  - [Koffie Ende Koeck](https://koffieendekoeck.nl/) - Small vegan cafe, with nice brunch, and awesome vegan high tea.
  - [Loving Hut](https://www.facebook.com/lovinghutamsterdam) - Cozy and family friendly with Asian kitchen and some dutch classics.
  - [Mooshka](https://www.mooshka.nl/) - Stylish place with nice atmosphere, and a great variety of tasty dishes and drinks.
  - [TerraZen Centre](http://terrazencentre.com/) - Chill vibe and mouth-watering dishes with Caribbean and Japanese influence, really close to central station.
  - [Trevi's Plant Based Italian Food](https://www.trevisamsterdam.nl/) - Cozy Italian, lovely vibe, amazing and authentic food, feels and tastes like in Italy.
  - [Vegan Junk Food Bar](https://www.veganjunkfoodbar.com/) - High quality burgers, fancy hotdogs, Dutch specialties like Bitterballen, cocktails, and more.
  - [Yemayá's Vegan Corner](https://yemaya.estate/) - Super tasty food driven by sustainable local community efforts.

- Ashland, OR, USA
  - [NW Raw](https://nwraw.com/) - Juices and snacks, vegan ice cream.

- Berkeley, CA, USA
  - [The Butcher's Son](https://www.thebutchersveganson.com/) - Comfort food spilling off of your plate. Grab a main, a couple of sides and a plenty of napkins.

- Bonn, Germany
  - [Kaiserhüttn](https://kaiserhuettn.com/) - Eat like in Austria.

- Duisburg, Germany
  - [Falafel 1001](https://www.falafel1001-duisburg.de/) - Amazing arabic dishes, delicious ingredients and spices, big portions, and very good prices.
  - [Krümelküche](http://www.kruemelkueche.de/) - Cosy place with a nice selection of main dishes, burgers, cakes, and good drinks.

- Eindhoven, Netherlands
  - [Bar Bistro Calypso](https://www.bistrocalypso.nl/) - Cosiest livingroom in town, with tasty no-nonsense dishes and good drinks.
  - [Bij Albrecht](https://www.bijalbrecht.nl/) - Vegan and organic food experience with seasonal produce.
  - [Jungle Café & Catering](https://www.junglecafecatering.nl) - Vegan coffeebar & lunchroom for young and old. Also offers catering & take away.
  - [Vegan Heroes](https://veganheroes.nl/) - Great vegan fast food, smoothie bowls, snacks, and desserts.

- Essen, Germany
  - [Peace Food](https://www.facebook.com/peacefoodessen) - Relaxed atmosphere, big selection of really good vietnamese dishes, and offering refreshing home-made drinks.

- Hilversum, Netherlands
  - [Mr. Vegan Foodbar](https://www.mrveganfoodbar.nl/) - Amazing selection of delicious soups, bowls, curries, quality junk food, and tasty snacks.

- Köln, Germany
  - [Sattgrün](https://www.sattgruen.com/) - Buffet with great varieity and quality.

- London, UK
  - [Eat By Cloe](https://eatbychloe.com/) - For the mandatory fish and chips this place is definitely worth visiting.

- New York, USA
  - [Berben & Wolff's](https://berbenandwolffs.com/) - Easygoing counter-serve deli with a cheerful vibe specializing in vegan light fare & desserts. Locations in Albany and Troy, New York.

- Oakland, USA
  - [Millennium Restaurant](https://www.millenniumrestaurant.com/) - Far cry from your ordinary vegan spot in that it takes a hands on, from scratch approach to food which assures a fresh, local, organic and homemade product every time.

- Salt Lake City, UT, USA
  - [Mark of the Beastro](https://markofthebeastro.com/) - Excellent vegan food and dining.

- Utrecht, Netherlands
  - [Oproer](https://www.oproerbrouwerij.nl/) - Local brewery with tasty beers and vegan street food.

## Shops

- [VEGA-LIFE](https://www.vega-life.nl/) - Shoes, fashion, lifestlye products, 20+ years around.
- [Vegan Mission](https://www.veganmission.nl/) - Online store for Belgium and the Netherlands.
- [veggie4u](https://webshop.veggie4u.nl/) - Dutch webshop with big selection of food.
- [veganized](https://www.veganized.es/gb/) - Spanish (Malaga) store with mens, womens and children clothes.

## Brands

*This category is stricly limited to fully vegan / 100% plant-based brands.*

- [AlPro](https://www.alpro.com/nl/) - Big variety of plant-based products.
- [Bedda](https://bedda-world.com/) - Whole selection of nice non-milk cheese slices and blocks, shreds to melt, as well as sauces, and cream cheese.
- [Beyond Meat](https://www.beyondmeat.com/) - Very convincing burgers, sausages, meatballs, and more, all based on plants.
- [Dandies](https://dandies.com/) - Delicious, soft, melting, and all natural marshmallows with vanilla, pumpkin, or peppermint taste.
- [Daiya](https://daiyafoods.com/) - Amazing cheesecakes, frozen pizzas, various cheesy products, and more desserts.
- [Eat Real](https://www.eatreal.co.uk/) - Snacking galore with chips, sticks, and puffs; offering tastes like sour cream & chives, paprika, chilli cheese, mediterranean, and others.
- [Happy Cashew](https://happy-cheeze.com/) - Creamy, delicious cashew based milk product alternatives, with a big variety of brie style cheeses and more.
- [Nurishh](https://nurishhplantbased.com/) - Great selection of different cheeses with various tastes.
- [Oatly](https://www.oatly.com/int/) - Amazing range of oat based products from Sweden.
- [Peas of Heaven](https://peasofheaven.com/) - Wide range of tasty products based on peas, from cocktail sausages, over bratwurst, to slices.
- [Petit Veganne](https://petit-veganne.com/) - Amazing French artisanal cheese, soft and creamy brie with different flavours.
- [Provamel](https://www.provamel.com/) - Delicious organic and biological plant-based yogurts, milky drinks, and soy desserts.
- [Tofuture](https://www.tofuture.com/) - Awesome tofu press, super easy and reliable to use, and can be placed in the fridge.
- [Tofurky](https://tofurky.com/) - Delicious sausages, deli slices, burgers, roasts, and other plant-based protein products.
- [Valsoia](https://www.valsoia.it/) - Absolutely amazing Italian ice cream, ice cones, hazelnut spread, and other food products.
- [Vantastic Foods](https://www.vantastic-foods.com/) - Massive selection of plant-based products, including their own brand with different types of delicious sausages, slices, and more.
- [Vega](https://myvega.com/) - Big selection of plant-based protein powders, power bars, vitamins, and supplements for bodybuilders and fitness people.
- [Vegafit](https://vegafit.com/) - Broad and tasty selection of plant-based meat products.
- [Vego](http://www.vego-chocolate.com/) - Super delicious chocolate bars with hazel nuts, as well as crunchy chocolate spread, and white almond chocolate.
- [Vegusto](https://www.vegusto.ch/) - Unbelievable good swiss vegan cheese (No-Muh), plant-based meats, as well as vegan animal food.
- [Violife](https://violifefoods.com/) - Really good plant-based cheese products that actually melt as well.

## Websites

- [/r/Vegan](https://www.reddit.com/r/vegan/) - Largest vegan community on the internet.
- [Gewoon Vegan](https://gewoonvegan.nl/) - Really useful website showing a lot of regular vegan products that can be found in Dutch supermarkets.
- [Nederlandse Vereniging voor Veganisme](https://www.veganisme.org/) - Dutch association for veganism, running a magazine, giving yearly vegan awards, supporting the community, and various other projects.
- [Vegan Wiki](https://veganwiki.nl/) - Wiki from the Dutch association for veganism with a huge collection of products available in the Netherlands.

## Contributing

Everyone is welcome to contribute to this list - read the [contribution guidelines](https://github.com/sdassow/awesome-veganism/blob/master/CONTRIBUTING.md) and the [code of conduct](https://github.com/sdassow/awesome-veganism/blob/master/CODE_OF_CONDUCT.md) to find out how.
