<div class="github-widget" data-repo="vapor-community/awesome-vapor"></div>
## Awesome Vapor [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-logo.png" align="right" width="150">](https://vapor.codes)

[Vapor](https://vapor.codes) 是目前最流行的服务器端 Swift 框架之一. 如果您曾经开发过 iOS 应用程序，它允许您采用您已经知道的语言并以全新的方式使用它，以开发快速、可扩展且可靠的后端系统，这些系统可以轻松地与广泛的第三方服务集成. 这是一个精选列表：

- 可轻松与 Vapor 集成并遵循 Vapor 提供简单、干净但功能强大的 API 的理念的现代库；
- 精心编写的教程、书籍、视频和教育材料；
- 使您的开发过程更简单、更愉快的工具；
- 和更多！



## How to use

只需按<kbd>Command</kbd> + <kbd>F</kbd>即可搜索关键字. 如果您只对与以下内容相关的条目感兴趣 [Vapor 3](https://github.com/Cellane/awesome-vapor/blob/filtered/vapor-3.md) 或只到 [Vapor 4](https://github.com/Cellane/awesome-vapor/blob/filtered/vapor-4.md) ，您可以通过访问这句话中的链接来使用“已过滤”分支上可用的自动生成的过滤列表. 您还可以在 `legacy` 文件夹中找到旧版存档内容.

## Libraries

- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [API Error Middleware](https://github.com/skelpo/APIErrorMiddleware) – 用于将抛出的错误转换为 JSON 响应的 Vapor 中间件.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [APNS](https://github.com/vapor-community/apns) – 适用于 iOS 的 Vapor APNS.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Bugsnag](https://github.com/nodes-vapor/bugsnag) – 使用 Bugsnag 报告错误.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [CouchDB Client](https://github.com/makoni/couchdb-vapor) – Vapor 的简单 CouchDB 客户端.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [CrudRouter](https://github.com/twof/VaporCRUDRouter) – 为任何 Fluent 模型自动生成 RESTful CRUD 路由器.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [CSRF](https://github.com/vapor-community/CSRF) – 一个为 Vapor 添加保护以防止 CSRF 攻击的包.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [CSV Framework](https://github.com/skelpo/CSV) – 读取和写入 CSV 文件的简单框架.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Ferno](https://github.com/vapor-community/ferno) – Vapor Firebase 实时数据库提供商.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Flash](https://github.com/nodes-vapor/flash) – 视图之间的 Flash 消息.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [FluentQuery](https://github.com/MihaelIsaev/FluentQuery) – 构建复杂的原始 SQL 查询，同时仍然使用 Swift 键路径.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Gatekeeper](https://github.com/nodes-vapor/gatekeeper) – Vapor 的速率限制中间件.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Google Cloud Provider](https://github.com/vapor-community/google-cloud-provider) – 与您的 Vapor 项目中的 Google Cloud Platform API 交互.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Guardian](https://github.com/Jinxiansen/Guardian) – 现代限速中间件.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Imperial](https://github.com/vapor-community/Imperial) – 与 OAuth 提供商的联合身份验证.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [JWT Keychain](https://github.com/nodes-vapor/jwt-keychain) – 使用 JWT for Vapor 轻松构建钥匙串.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [JWT Middleware](https://github.com/skelpo/JWTMiddleware) – 在 Vapor 中验证和授权请求的中间件.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Leaf Error Middleware](https://github.com/brokenhandsio/leaf-error-middleware) – 为您的 Vapor 应用程序提供自定义 404 和服务器错误页面.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Leaf Markdown](https://github.com/vapor-community/leaf-markdown) – Vapor 的 Markdown 渲染器.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Lingo Vapor](https://github.com/vapor-community/Lingo-Vapor) – Lingo 的 Vapor 供应商 – Swift 本地化库.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Local Storage](https://github.com/gperdomor/local-storage) – 使用本地文件系统的存储驱动程序.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [MailCore](https://github.com/LiveUI/MailCore) – 通过 SMTP、MailGun 和 SendGrid 发送电子邮件.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Meow](https://github.com/OpenKitten/Meow) – 用于 MongoDB 的替代可编码 ORM.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [MongoKitten](https://github.com/OpenKitten/MongoKitten) – Swift 中的 MongoDB 驱动程序.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Pagination](https://github.com/vapor-community/pagination) – 简单的 Vapor 3 分页.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Paginator](https://github.com/nodes-vapor/paginator) – 查询 Vapor 和 Fluent 的分页.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [S3](https://github.com/LiveUI/S3) – 用于访问支持最常用操作的 Amazon S3 服务（和兼容）的库.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [S3 Storage](https://github.com/anthonycastelli/s3-storage) – 用于简单访问 Amazon S3 服务的库.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Sanitize](https://github.com/gperdomor/sanitize) – 从 Vapor JSON 请求中提取强大的模型.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [SendGrid Provider](https://github.com/vapor-community/sendgrid-provider) – SendGrid 支持的 Vapor 邮件后端.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [SimpleFileLogger](https://github.com/hallee/vapor-simple-file-logger) – 用于 Vapor 的简单文件日志记录提供程序.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Slugify](https://github.com/nodes-vapor/slugify) – 使您的琴弦变得迟钝的便利.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Storage](https://github.com/nodes-vapor/storage) – 简化多重存储和 CDN 服务的使用.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Stripe Provider](https://github.com/vapor-community/stripe-provider) – Vapor 的条纹提供者.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Submissions](https://github.com/nodes-vapor/submissions) – 方便创建表单和验证（表单）提交.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Sugar](https://github.com/nodes-vapor/sugar) – 一包用于 Vapor 的糖.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [SwifQL](https://github.com/MihaelIsaev/SwifQL) – 使用纯 Swift 轻松构建灵活且类型安全的 SQL.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [SwiftyBeaver Provider](https://github.com/vapor-community/swiftybeaver-provider) – 用于服务器端 Swift Web 框架 Vapor 的 SwiftyBeaver Logging Provider.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Telesign Provider](https://github.com/vapor-community/telesign-provider) – Vapor 的 Telesign 提供商.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Vapor Mailgun Service](https://github.com/vapor-community/VaporMailgunService) – 与 Vapor 一起使用以发送电子邮件的服务.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Vapor reCAPTCHA](https://github.com/gotranseo/vapor-recaptcha) – 使用 Vapor 验证 Google reCAPTCHA.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Vapor Request Storage](https://github.com/skelpo/vapor-request-storage) – 替代 Vapor 1 和 2 中可用的 `request.storage`.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Vapor Security Headers](https://github.com/brokenhandsio/VaporSecurityHeaders) – 强化 Vapor 的安全标头.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Vapor Test Tools](https://github.com/LiveUI/VaporTestTools) – 旨在让您在 Vapor 3 中轻松测试端点的助手.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [VaporExt](https://github.com/vapor-community/vapor-ext) – 一系列适用于各种 Vapor 数据类型和类的 Swift 扩展.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [WKHTMLTOPDF](https://github.com/MihaelIsaev/wkhtmltopdf) – 通过 `wkhtmltopdf` CLI 工具从 Leaf 模板或网页构建 PDF 文件.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [XMLCoding](https://github.com/LiveUI/XMLCoding) – XML 编码器和解码器.

## Tools

- [Ether](https://github.com/Ether-CLI/Ether) – Swift 包管理器的命令行界面.
- [Heroku buildpack: curl with HTTP/2 support](https://github.com/vzsg/heroku-buildpack-curl-http2)
- [Ice](https://github.com/jakeheis/Ice)  – 对开发人员友好的 Swift 包管理器； 与 Swift 包管理器 100% 兼容.
- [Sourcery](https://github.com/krzysztofzablocki/Sourcery) – Swift 的元编程，停止编写样板代码.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Sublimate](https://github.com/gabrielepalma/sublimate) – 基于 Sourcery 的同步和身份验证快速原型制作.
- [Swifter](https://github.com/LiveUI/Swifter) – 一个 macOS 工具，可帮助您管理 Xcode 项目并让您快速访问 DerivedData 文件夹清理和管理.

## Services

- [Vapor Cloud](https://vapor.cloud)
- [Vapor Red](https://vapor.red)

## Education

### Articles

- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Deep Dive into Setup and Deployment for Heroku and Ubuntu](https://learningswift.brightdigit.com/vapor-heroku-ubuntu-setup-deploy/)
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [How to test controllers by mocking dependencies in Vapor 3 and Swift](https://mikemikina.com/blog/how-to-test-controllers-by-mocking-dependencies-in-vapor-3-and-swift/)
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Vapor 3 Tutorials](https://mihaelamj.github.io/Vapor%20%203%20Tutorial/) - 小教程的大集合.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Transforming from Vapor 2 to Vapor 3](https://www.skelpo.com/blog/vapor2-to-vapor3/) – 通过真实世界的项目从 Vapor 2 过渡到 Vapor 3.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Tutorials for Beginner to Advanced](https://medium.com/@martinlasek) – 初级到高级的书面教程.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Using the dependency injection framework for testing in Vapor 3 and Swift](https://mikemikina.com/blog/using-the-dependency-injection-framework-for-testing-in-vapor-3-and-swift/) – 如何使用依赖注入框架来帮助您管理依赖关系并在测试中模拟它们.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Watermarking photos with ImageMagick, Vapor 3 and Swift on macOS and Linux](https://mikemikina.com/blog/watermarking-photos-with-imagemagick-vapor-3-and-swift-on-macos-and-linux/) – 关于如何在 Swift 中使用 ImageMagick 库的教程.
- ![v4](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-4.png) [What’s new in Vapor 4?](https://theswiftdev.com/2019/08/26/whats-new-in-vapor-4/)

### Books

- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Server Side Swift with Vapor](https://store.raywenderlich.com/products/server-side-swift-with-vapor)
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Server-Side Swift (Vapor Edition)](https://www.hackingwithswift.com/store/server-side-swift)

### Newsletters

- [VaporNation](http://vapornation.news) – 包含所有 Vapor 内容的每周 Vapor 时事通讯.

### Videos

- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Server Side Swift with Vapor](https://www.raywenderlich.com/4493-server-side-swift-with-vapor/lessons/1)
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [Vapor - Beginner to Advanced](https://www.youtube.com/channel/UCoLEXFUHIKXunm9QJjsAftw/videos)

## Open-source Projects

- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [SteamPress](https://github.com/brokenhandsio/SteamPress) – 一个用 Swift 编写的博客引擎和平台，用于 Vapor 框架.
- ![v3](https://raw.githubusercontent.com/vapor-community/awesome-vapor/master/img/vapor-3.png) [User Manager Service](https://github.com/skelpo/UserManager) – 一个小而有用的用户管理器，用于生产应用程序设置.

## License

[![CC0](https://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内，_Milan Vit_ 已放弃该作品的所有版权和相关或邻接权.
