<div class="github-widget" data-repo="MartinZikmund/awesome-uno-platform"></div>
<div align="center">
	<div>
		<img width="160" src="https://raw.githubusercontent.com/MartinZikmund/awesome-uno-platform/master/media/logo.png" alt="Uno Platform">
	</div>
	<br>
</div>

<div align="center">

## Awesome Uno Platform


[![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

</div>

[Uno Platform](https://platform.uno/) is an open-source UI Platform for building single-codebase .NET applications for Windows, iOS, Android, WebAssembly, macOS, and Linux. 

This is a list of **awesome resources** for users of Uno Platform. **If you find the list helpful, please make sure to ⭐ star it!**



## General

- [Uno Platform website](https://platform.uno/platforms)
- [Uno Platform documentation](https://docs.platform.uno/)

## Repositories

- [Uno Platform](https://github.com/unoplatform/uno) - Main repository of Uno Platform, including the full API surface of UWP/WinUI, the best place to submit issues and contribute.
- [Uno Themes](https://github.com/unoplatform/Uno.Themes) - Material and Cupertino theme library for Uno Platform apps. In addition, includes advanced controls based on Android/iOS developer guidelines.
- [Uno Toolkit](https://github.com/unoplatform/uno.toolkit.ui) - Multiplatform-first UI component library to speed up application development. Also provides Material and Cupertino styles for the included components.
- [Uno Gallery](https://github.com/unoplatform/Uno.Gallery) - Controls and API gallery app. Includes live examples of most built-in controls and features along with easy to use code snippets.
- [Uno Samples](https://github.com/unoplatform/Uno.Samples) - A growing collection of code samples and snippets.
- [Uno Core](https://github.com/unoplatform/Uno.Core) - Provides a set of reusable utilities and helpers. Used by the main Uno Platform repository.
- [Uno UI Test](https://github.com/unoplatform/Uno.UITest) - Cross-platform UI testing library for Android, iOS and WebAssembly.

## Tools
- [Uno Platform extension for Visual Studio 2022](https://marketplace.visualstudio.com/items?itemName=unoplatform.uno-platform-addin-2022) - Adds Uno Platform project templates and hot reload functionality to Visual Studio 2022.
- [Uno Platform extension for Visual Studio Code](https://marketplace.visualstudio.com/items?itemName=unoplatform.vscode) - Adds a range of productivity boosters to Visual Studio Code, including XAML IntelliSense, Hot Reload, and mobile target debugging support.
- [Uno Extensions](https://github.com/unoplatform/uno.extensions) - A series of NuGet packages for commonly used functions associated with building multi-platform applications using Uno Platform.
- [Uno Platform for Figma Plugin](https://www.figma.com/community/plugin/1045528009520465828/Uno-Platform-(Figma-to-XAML)) - Figma Plugin to generate responsive XAML from High-fidelity designs.
- [Uno Material Toolkit](https://www.figma.com/community/file/1110792522046146058/Uno-Platform-Material-Toolkit) - Figma File to use with Uno Figma Plugin.

## Libraries

### Toolkits
- [Windows Community Toolkit for Uno](https://github.com/unoplatform/Uno.WindowsCommunityToolkit) - Uno Platform fork of Microsoft Community Toolkit.
- [Telerik UI for Uno](https://github.com/unoplatform/Uno.Telerik.UI-For-UWP) - Fork of Telerik UI for UWP to support Uno Platform.

### MVVM
- [MVx.Observable](https://www.nuget.org/packages/MVx.Observable/) - A (mostly) unopinionated, light-weight alternative to ReactiveUI provided as a library _not a framework_.
- [Prism](https://prismlibrary.com/) - Framewrok for building loosely coupled, modular, maintainable, and testable XAML applications.
- [Microsoft MVVM Toolkit](https://docs.microsoft.com/en-us/windows/communitytoolkit/mvvm/introduction) - Modern, fast, and modular MVVM library.

### Compatibility
- [SignalR](https://docs.microsoft.com/en-us/aspnet/signalr/overview/getting-started/introduction-to-signalr) - [Cross-Platform Real-Time Communication with Uno & SignalR](https://ian.bebbs.co.uk/posts/UnoChat) - Integration example for the SignalR framework.
- [Elmish.Uno](https://github.com/xperiandri/Elmish.Uno) - Half-Elmish framework for apps written in F#.

## Blogs
- [Official Uno Platform blog](https://platform.uno/blog/) - Lists latest release notes, tutorials, and articles by Uno Platform maintainers as well as external contributors.
- [Jerome Laban's blog](https://jaylee.org/) - Blog of the CTO of Uno Platform.
- [Martin Zikmund blog](https://blog.mzikmund.com/category/development/uno-platform/) - Uno Platform blog posts by Martin Zikmund.
- [Nick's .NET Travels](https://nicksnettravels.builttoroam.com/tag/uno/) - Uno Platform blog posts by Nick Randolph.
- [IObservable\<Opinion\>](https://ian.bebbs.co.uk/tags/uno-platform) - Uno Platform blog posts by Ian Bebbington.

## Live apps

- [Uno Playground](https://playground.platform.uno) - App which allows you to experiment with Uno Platform C# and XAML right from the browser.
- [Windows Calculator](https://calculator.platform.uno/) - WebAssembly port of the Windows 10 Calculator app.
- [NuGet.info](https://nuget.info/) - Modernized version of NuGet Package Explorer application.
- [Toolkit Labs](https://toolkitlabs.dev/) - A place where new components for the Windows Community Toolkit are developed.

## Open-source apps
- [UADO](https://github.com/unoplatform/uado) - Azure DevOps backlog viewer.
- [Uno Playground](https://github.com/unoplatform/Uno.Playground) - Uno Playground app with UI samples.
- [Uno Calculator](https://github.com/unoplatform/calculator) - Port of the Windows 10 Calculator.
- [NuGet Package Explorer](https://github.com/NuGetPackageExplorer/NuGetPackageExplorer/tree/main/Uno) - Source code of the Uno Platform version of NuGet Package Explorer.
- [Ch9](https://github.com/unoplatform/Uno.Ch9) - Channel 9 browser app.
- [COduo](https://github.com/ibebbs/CODuo) - Visualizing the environmental impact of current and forecast energy generation in the UK. Designed for use on both single and dual-screen devices.

## Live coding

- [Jerome Laban's Twitch](https://www.twitch.tv/jeromelaban) - Weekly Uno Platform live coding sessions (Tuesdays).
- [Martin Zikmund's Twitch](https://www.twitch.tv/martinzikmund) - Mostly Uno Platform-themed live coding sessions.

## Talks

- [Introduction to open source Uno Platform](https://youtu.be/vRzTr8XYau0) - Introductory talk by Jérôme Laban about Uno Platform and what it offers.
- [Uno Platform - Your Apps Everywhere](https://youtu.be/dX69x-D6COI) - Overview of the Uno Platform ecosystem by Martin Zikmund at NDC Porto 2022.
- [Building Multi-Platform Applications with the Uno Platform](https://youtu.be/0zvzfCGO0gI) - Introduction to creating apps for multiple platforms and form factors, all while reusing your existing XAML and C# skill by Nick Randolph.
- [[RU] Разработка кросс-платформенных приложений с Uno Platform и Elmish-подходом на F#](https://www.youtube.com/watch?v=ApNGATu9RSo) - Introduction to Uno, Blend and Elmish.

## Videos

- [Uno Platform's YouTube](https://www.youtube.com/@unoplatform) - Official YouTube channel of Uno Platform, includes new release highlights, live sessions, and tutorials.
- [Uno Tech Bites](https://www.youtube.com/playlist?list=PLl_OlDcUya9rP_fDcFrHWV3DuP7KhQKRA) - Uno Platform development learnings in bite-sized lessons.
- [Martin Zikmund's YouTube](https://www.youtube.com/@mzikmund) - Various Uno Platform-related videos and tutorials.

## Books

- [Getting Started with the Uno Platform and WinUI 3 (2022/09)](https://link.springer.com/book/10.1007/978-1-4842-8248-9) - Hands-on building of cross-platform desktop, mobile, and web applications that can run anywhere.  By Skye Hoefling.
- [Creating Cross-Platform C# Applications with Uno Platform (2021/08)](https://www.packtpub.com/product/creating-cross-platform-c-applications-with-uno-platform/9781801078498) - Build apps with C# and XAML that run on Windows, macOS, iOS, Android, and WebAssembly.  By Matt Lacey and Marcel Alexander Wagner.

## Contributing

Your contributions welcome! Please read the [contribution guidelines](https://github.com/MartinZikmund/awesome-uno-platform/blob/master/contributing.md) before creating a pull request.
