<div class="github-widget" data-repo="polycarbohydrate/awesome-tor"></div>
[![Awesome](https://awesome.re/badge.svg)](https://awesome.re)
## [![awesome-tor-logo](https://github.com/Polycarbohydrate/awesome-tor/assets/169401794/d8c7415e-1874-49f5-a1c6-04b3a8aa689f)](https://www.torproject.org)
> Awesome Tor is a curated list of resources, tools, and applications related to the Tor network.

> [!NOTE]
> This product is produced independently from the Tor® anonymity software and carries no guarantee from The Tor Project about quality, suitability or anything else.

Tor is a free overlay network for enabling anonymous communication. Built on free and open-source software and more than seven thousand volunteer-operated relays worldwide, users can have their Internet traffic routed via a random path through the network.

Before you read, if you want to host a Snowflake bridge in your browser to help users in censored regions bypass censorship, [click here](https://polycarbohydrate.github.io/awesome-tor/selfhost-snowflake). Thank you.
## Official Manual
- [About Tor Browser](https://tb-manual.torproject.org/about/) - Learn what Tor Browser can do to protect your privacy and anonymity.
- [Anti-fingerprinting](https://tb-manual.torproject.org/anti-fingerprinting/) - How Tor Browser mitigates browser fingerprinting.
- [Bridges](https://tb-manual.torproject.org/bridges/) - Most Pluggable Transports, such as obfs4, rely on the use of "bridge" relays.
- [Circumvention](https://tb-manual.torproject.org/circumvention/) - What to do if the Tor network is blocked.
- [Downloading](https://tb-manual.torproject.org/downloading/) - How to download Tor Browser.
- [Installation](https://tb-manual.torproject.org/installation/) - Installing Tor Browser.
- [Known Issues](https://tb-manual.torproject.org/known-issues/) - Issues with Tor.
- [Make Tor Browser Portable](https://tb-manual.torproject.org/make-tor-portable/) - How to install Tor Browser onto removable media.
- [Managing Identities](https://tb-manual.torproject.org/managing-identities/) - Learn how to control personally identifying information in Tor Browser.
- [Mobile Tor](https://tb-manual.torproject.org/mobile-tor/) - Learn about Tor for mobile devices.
- [Onion Services](https://tb-manual.torproject.org/onion-services/) - Services that are only accessible using Tor.
- [Plugins, add-ons, and JavaScript](https://tb-manual.torproject.org/plugins/) - How Tor Browser handles add-ons, plugins, and JavaScript.
- [Running Tor Browser](https://tb-manual.torproject.org/running-tor-browser/) - Learn how to use Tor Browser for the first time.
- [Secure Connections](https://tb-manual.torproject.org/secure-connections/) - Learn how to protect your data using Tor Browser and HTTPS.
- [Security Settings](https://tb-manual.torproject.org/security-settings/) - Configuring Tor Browser for security and usability.
- [Support](https://tb-manual.torproject.org/support/) - How to get help, report a bug, or give feedback.
- [Troubleshooting](https://tb-manual.torproject.org/troubleshooting/) - What to do if Tor Browser doesn't work properly.
- [Updating](https://tb-manual.torproject.org/updating/) - How to update Tor Browser.
- [Uninstalling](https://tb-manual.torproject.org/uninstalling/) - How to remove Tor Browser from your system.
## Applications
### Tails
*A portable, Debian-based OS that runs from the RAM, leaving no trace. Uses Tor Browser as the primary browser.*
- [Contribute](https://tails.net/contribute/index.en.html)
- [Documentation](https://tails.net/doc/index.en.html)
- [Download](https://tails.net/install/index.en.html)
- [Homepage](https://tails.net/)
- [How it works](https://tails.net/about/index.en.html)
- [News](https://tails.net/news/index.en.html)
- [Support](https://tails.net/support/index.en.html)
### Tor / Tor Browser
*Open-source web browser that enables anonymous communication by directing internet traffic through a free, worldwide, volunteer, overlay network to conceal location and usage from anyone conducting network surveillance or traffic analysis.*
- [About](https://www.torproject.org/about/history/)
- [Commmunity](https://community.torproject.org/)
- [Donate](https://donate.torproject.org/)
- [Download](https://www.torproject.org/download/)
- [Support](https://support.torproject.org/)
- [News](https://blog.torproject.org/)
- Core Tor / Little-t-tor
  - [Installation / Verify source code](https://support.torproject.org/little-t-tor/)
  - [Forum / Support](https://forum.torproject.org/c/support/core-tor/18)
### Other applications
- [ansible-relayor](https://github.com/nusenu/ansible-relayor) - This is an ansible role for tor relay operators.
- [bine](https://github.com/cretz/bine) - Go library for accessing and embedding Tor clients and servers.
- [Briar](https://briarproject.org/) - Peer-to-peer messaging that bypasses centralized servers. Connect via Bluetooth, Wi-Fi, or Tor.
- [Bulk Tor Exit Exporter](https://check.torproject.org/api/bulk) - Identify Tor exit nodes by showing exit node IPv4 and fingerprint information.
- [Chutney](https://gitlab.torproject.org/tpo/core/chutney/) - Configures a Tor network, launches and monitors it, and then runs tests on it.
- [dnscrypt-proxy](https://github.com/DNSCrypt/dnscrypt-proxy) - A flexible DNS proxy, with support for encrypted DNS protocols.
- [dos-over-tor](https://github.com/skizap/dos-over-tor) - Proof of concept denial of service over Tor stress test tool. 
- [DocTor](https://gitlab.torproject.org/tpo/network-health/doctor/) - A notification service that monitors newly published descriptor information for issues.
- [eotk](https://github.com/alecmuffett/eotk) - Tool for deploying HTTP/Onion sites to provide official, onion-networking for popular websites.
- [exitmap](https://www.cs.kau.se/philwint/spoiled_onions/) - Scanner for Tor to detect bad exits (spoiled onions).
- [haskell-tor](https://github.com/GaloisInc/haskell-tor) - A Haskell implementation of the Tor protocol.
- [HTTPS Everywhere](https://www.eff.org/https-everywhere) - Only allows the browser to connect using HTTPS, built-in Tor.
- [kalitorify](https://github.com/brainfucksec/kalitorify) - Shell script to create a transparent proxy through Tor for Kali Linux OS.
- [Tor Metrics](https://metrics.torproject.org/) - Adjustable graphs to visualize the statistics of Tor.
- [multitor](https://github.com/trimstray/multitor) - Create multiple Tor instances with load balancing.
- [mini-tor](https://github.com/wbenny/mini-tor) - Smallest application size while accessing internet content and hidden service content.
- [node-Tor](https://github.com/Ayms/node-Tor) - JavaScript open-source implementation of the Tor protocol on the server side and browsers.
- [nyx](https://nyx.torproject.org/) - CLI interface which includes detailed real-time information about your relay.
- [offensive-tor-toolkit](https://github.com/atorrescogollo/offensive-tor-toolkit) - Bind/Reverse Shells, SOCKS, etc over Tor in Go.
- [onion-grater](https://github.com/Whonix/onion-grater) - Whitelisting filter for dangerous Tor control protocol commands.
- [Onionbalance](https://onionbalance.readthedocs.io/en/latest/) - A way to load balance onion services across multiple backend Tor instances.
- [Onionoo](https://metrics.torproject.org/onionoo.html) - A web-based protocol to learn about currently running Tor relays and bridges.
- [OnionScan](https://onionscan.org/) - Help operators of hidden services find and fix operational security issues with their services.
- [OnionShare](https://onionshare.org/) - Anonymously share files, host website, and chat using the Tor network.
- [OONI](https://ooni.org/) - Test the blocking of websites and apps. Measure the speed and performance of your network.
- [Orbot](https://guardianproject.info/apps/org.torproject.android/) - Tor on Android.
- [Orfox](https://guardianproject.info/apps/info.guardianproject.orfox/) - Modified Tor browser for Android. Requires Orbot.
- [php-torcontrol](https://github.com/dunglas/php-torcontrol) - TorControl is a PHP library to control a Tor server.
- [Relay Search](https://metrics.torproject.org/rs.html) - Easy way to search for information about relays.
- [Ricochet Refresh](https://www.ricochetrefresh.net/) - Ricochet Refresh is a peer-to-peer messenger app that uses Tor to connect clients.
- [rotating-proxy](https://github.com/mattes/rotating-proxy) - Rotating Tor proxy with Docker.
- [sbws](https://gitlab.torproject.org/tpo/network-health/sbws) - A Tor bandwidth scanner that generates bandwidth files to be used by Directory Authorities.
- [Stormy](https://github.com/glamrock/stormy) - Stormy is a wizard that helps people create Tor Onion Services with just a few clicks.
- [setup-tor](https://github.com/tor-actions/setup-tor) - Set up your GitHub Actions workflow with a specific version of Tor.
- [Stem](https://stem.torproject.org/) - Stem is a Python controller library for Tor.
- [Shadow](https://shadow.github.io/) - Shadow is a discrete-event network simulator that runs the real Tor software as a plug-in.
- [Tallow](https://github.com/basil00/TorWall) - A program that redirects all outbound traffic from a Windows machine via the Tor anonymity network.
- [tor_box](https://github.com/CMoncur/tor_box) - An all-inclusive Tor configuration for Raspberry Pi, that serves as a relay and personal Tor network.
- [Tor_Onion_Proxy](https://github.com/thaliproject/Tor_Onion_Proxy_Library) - Provides a .JAR and an .AAR file for embedding Tor into a Java or Android Program.
- [tor_ssh.sh](https://gitlab.com/grownetics/devops/blob/master/tor_ssh.sh) - Command that allows SSH access using Tor to any server.
- [tor-browser-selenium](https://github.com/webfp/tor-browser-selenium) - A Python library to automate Tor Browser with Selenium WebDriver.
- [tor-controller](https://github.com/kragniz/tor-controller) - Run Tor Onion Services on Kubernetes.
- [tor-hidden-service](https://hub.docker.com/r/goldy/tor-hidden-service) - Docker container made for Onion Services in v2 or v3.
- [tor-relay-bootstrap](https://github.com/coldhakca/tor-relay-bootstrap) - Script to bootstrap a Debian server to be a set-and-forget Tor relay.
- [Tor.framework](https://github.com/iCepa/Tor.framework) - Tor.framework is the easiest way to embed Tor in your iOS application.
- [tor.rb](https://github.com/dryruby/tor.rb) - This is a Ruby library for interacting with the Tor anonymity network.
- [Tor2web](https://github.com/tor2web/Tor2web) - HTTP proxy software that enables access to Tor Hidden Services through common web browsers.
- [TorBot](https://github.com/DedSecInside/TorBot) - Onion site crawler for data collection.
- [TorChat-Mac](https://github.com/javerous/TorChat-Mac) - macOS native TorChat client.
- [TorChat](https://github.com/prof7bit/TorChat) - Decentralized anonymous instant messenger on top of Tor Hidden Services.
- [TorCheck](https://check.torproject.org/) - Determines if a visitor is using Tor or not.
- [torDDoS](https://github.com/r3nt0n/torDDoS) - TorDDos is a Python tool to automatize DDoS attacks on a website from the Tor network.
- [toriptabkes2](https://github.com/ruped24/toriptables2) - An anonymizer that sets up iptables and Tor to route all traffic through the Tor network.
- [torps](https://github.com/torps/torps) - The Tor Path Simulator (TorPS) is a tool for efficiently simulating path selection in Tor.
- [Torsocks](https://gitlab.torproject.org/tpo/core/torsocks/) - Allows you to use most applications safely with Tor.
- [Tortilla](https://www.crowdstrike.com/resources/community-tools/tortilla-tool/) - Tool that securely, anonymously, and transparently routes all TCP/IP and DNS traffic through Tor.
- [tun2tor](https://github.com/iCepa/tun2tor) - Rust library that creates a utun (userspace tunnel) interface, and connects it to a stream-based proxy.
- [txtorcon](https://txtorcon.readthedocs.io/en/latest/) - An implementation of the control-spec for Tor using the Twisted networking library for Python.
- [Vanguards](https://github.com/mikeperry-tor/vanguards) - This addon protects against guard discovery and related traffic analysis attacks.
- [Whonix](https://www.whonix.org/) - OS designed for advanced security and privacy using the desktop-wide use of the Tor network.
- [ZeroNet](https://zeronet.io/) - Free and uncensorable websites, using Bitcoin cryptography, the BitTorrent network, and Tor support.
## Bridges
- [BridgeDB](https://pythonhosted.org/bridgedb/) - BridgeDB is a collection of backend servers used to distribute Tor Bridges.
- [Conjure](https://gitlab.torproject.org/tpo/anti-censorship/pluggable-transports/conjure) - Conjure is an anti-censorship tool in the refraction networking (a.k.a. decoy routing) lineage of circumvention systems.
- [Flash Proxies](https://crypto.stanford.edu/flashproxy/) - Outdated and deprecated bridge type. It is a miniature proxy that runs in a web browser.
- [fteproxy](https://fteproxy.org/) - Outdated and deprecated bridge type. Tor traffic resembles plain HTTP. The name stands for "Format-Transforming Encryption."
- [meek](https://support.torproject.org/glossary/meek/) - These pluggable transports make it look like you are browsing a major website instead of using Tor.
- [obsf2](https://gitlab.torproject.org/tpo/anti-censorship/pluggable-transports/trac/-/issues/10314) - Outdated and deprecated bridge type. Predecessor of obsf3.
- [obsf3](https://support.torproject.org/glossary/obfs3/) - Outdated and deprecated bridge type. Predecessor of obsf4.
- [obsf4](https://support.torproject.org/glossary/obfs4/) - A pluggable transport that makes Tor traffic look random and also prevents censors from finding bridges by Internet scanning.
- [ScrambleSuit](https://github.com/NullHypothesis/scramblesuit) - Outdated and deprecated bridge type. A pluggable transport protocol for obfsproxy. It is written in pure Python.
- [Snowflake](https://snowflake.torproject.org/) - Making your internet activity appear as though you're using the internet for a regular video or voice call.
- [Webtunnel](https://blog.torproject.org/introducing-webtunnel-evading-censorship-by-hiding-in-plain-sight/) - WebTunnel is a censorship-resistant pluggable transport designed to mimic encrypted web traffic (HTTPS) inspired by HTTPT.
## Bypass Censorship
- [Firefly](https://github.com/yinghuocho/firefly-proxy) - A proxy software to help circumvent the Great Firewall.
- [FWlite](https://github.com/v3aqb/fwlite) - An anti-censorship HTTP proxy with built-in shadowsocks support.
- [Google Fi Wireless](https://fi.google.com/) - Great phone solution that allows calls, text messaging, and use of cellular data that bypasses China's Great Firewall.
- [Lantern](https://github.com/getlantern/lantern) - Censorship circumvention tool available for free download on any operating system.
- [MTProxy](https://github.com/TelegramMessenger/MTProxy) - Allows users in censored areas to connect to Telegram.
- [NaïveProxy](https://github.com/klzgrad/naiveproxy) - NaïveProxy uses Chromium's network stack to camouflage traffic with strong censorship resistance and low detectability.
- [nodeunblocker](https://github.com/nfriedly/nodeunblocker.com) - Host your copy of nodeunblocker.com using Node.js to bypass censorship on the internet.
- [PrivadoVPN](https://privadovpn.com/) - VPN that is based in Switzerland and follows Swiss privacy laws. Bypasses even in China.
- [ProtonVPN](https://protonvpn.com/) - VPN that allows for circumvention of censorship even in China. Free plan bypasses along with multiple servers and protocols. No logs policy.
- [Private Bridges](https://bridges.torproject.org/) - Go to `I need an alternative way of getting bridges!` section. Follow the instructions.
- [Runet Censorship Bypass](https://github.com/anticensority/runet-censorship-bypass) - A browser extension for Chromium and Firefox that helps to bypass censorship in Russia.
- [StegoTorus](https://github.com/SRI-CSL/stegotorus) - A Camouflage Proxy for the Tor Anonymity System.
- [trojan](https://github.com/trojan-gfw/trojan) - An unidentifiable mechanism that helps you bypass GFW.
## Public reception, Impact, News, and Legislation
- [A close look at the Great Firewall of China](https://blog.torproject.org/closer-look-great-firewall-china/) - Some information about the censorship of Tor within China.
- [Analyzing China's Blocking of Unpublished Tor Bridges](https://www.usenix.org/conference/foci18/presentation/dunna) - Study on how China blocks unlisted Tor bridges and how to prevent this.
- [Anarcho-Tech NYC Wiki](https://github.com/AnarchoTechNYC/meta/wiki) - Wiki that explains how to stay private and anonymous online.
- [Anonymity Bibliography](https://www.freehaven.net/anonbib/) - Selected papers in anonymity from 1977 - 2020.
- [Dropping Docs on Darknet](https://www.youtube.com/watch?v=eQ2OZKitRwc) - DEF CON 22 - Adrian Crenshaw- Dropping Docs on Darknets: How People Got Caught.
- [How governments have tried to block Tor](https://www.youtube.com/watch?v=DX46Qv_b7F4) - How governments have tried to block Tor by 28c3.
- [How the Great Firewall of China is blocked in China](https://www.usenix.org/system/files/conference/foci12/foci12-final2.pdf) - Paper explaining how Tor is banned in China along with ways to circumvent it.
- [Learning more about the GFW's active probing system](https://blog.torproject.org/learning-more-about-gfws-active-probing-system/) - Page about the GFW's censorship system and how it works.
- [My Experience With the Great Firewall of China](http://blog.zorinaq.com/my-experience-with-the-great-firewall-of-china/) - Blog on CFW of China by an InfoSec professional during one of their visits.
- [Protocol Misidentification Made Easy with Format-Transforming Encryption](https://kpdyer.com/publications/ccs2013-fte.pdf) - How FTE worked.
- [Russia Passes Bill Banning Tor](https://www.themoscowtimes.com/2021/12/08/russia-blocks-tor-anonymity-service-a75760) - Article about Russia banning VPNs and Tor.
- [Scaling Tor hidden services](https://www.benthamsgaze.org/2015/11/17/scaling-tor-hidden-services/) - How to scale hidden services.
- [ScrambleSuit: A Polymorph Network Protocol to Circumvent Censorship](http://arxiv.org/pdf/1305.3199) - How ScrambleSuit worked.
- [Snowden Revelations](https://www.theguardian.com/world/interactive/2013/nov/01/snowden-nsa-files-surveillance-revelations-decoded) - The Snowden Revelations explained.
- [State of the Onion - 2023](https://blog.torproject.org/event/state-of-the-onion-2023/) - Tor Project's annual virtual event where we share updates from teams and the community, highlighting their work and the impact it has made across the globe during the year.
- [StegoTorus: A Camouflage Proxy for the Tor Anonymity System](https://www.freehaven.net/anonbib/cache/ccs2012-stegotorus.pdf) - A paper on how StegoTorus works.
- [Technical and Legal Overview of Tor](https://ccdcoe.org/uploads/2018/10/TOR_Anonymity_Network.pdf) - Overview of Tor is presented from the technical perspective and also several legal issues related to its use are analyzed.
- [Tor after the Snowden revelations](https://blog.torproject.org/tor-in-2023/) - About the Snowden revelations and what Tor will do in 2024. 
- [Tor Browser Afforded CDA Immunity for Dark Web Transactions](https://www.govinfo.gov/content/pkg/USCOURTS-utd-2_18-cv-00712/pdf/USCOURTS-utd-2_18-cv-00712-0.pdf) - Court document about the death of a minor through purchasing narcotics on Tor.
- [Tor Hidden Services and Deanonyminization](https://www.youtube.com/watch?v=HQXRURfrf8w) - Talk about how Tor and its services can be exploited to expose a user's information as well as how to prevent attacks.
- [Tor Overview](https://www.privacyguides.org/en/advanced/tor-overview/) - Overview of Tor by Privacyguides.
- [Understanding The Onion Router in 2024](https://www.privacyjournal.net/privacy/tor-network/) - Explains what Tor is; update for 2024.
- [What is Tor?](https://www.amnesty.org/en/latest/campaigns/2024/02/what-is-tor-and-how-does-it-advance-human-rights/) - Gives a very good explanation for Tor, Onion Services, and how it promotes human rights.
## State of the Onion
- [2024 - Ongoing](https://blog.torproject.org/event/2024-state-of-the-onion/) - State of the Onion report for the year 2024.
- [2023](https://blog.torproject.org/state-of-the-onion-2023/) - State of the Onion report for the year 2023.
- [2022](https://blog.torproject.org/state-of-the-onion-2022/) - State of the Onion report for the year 2022.
- [2021](https://blog.torproject.org/state-of-the-onion-2021/) - State of the Onion report for the year 2021.
- [2020](https://blog.torproject.org/state-of-the-onion-2020/) - State of the Onion report for the year 2020.
- [2019](https://www.youtube.com/watch?v=W0NR6M_08oM) - State of the Onion report for the year 2019.
## Whistleblowing
- [GlobaLeaks](https://www.globaleaks.org/) - GlobaLeaks is free, open-source software enabling anyone to easily set up and maintain a secure whistleblowing platform.
- [SecureDrop](https://github.com/freedomofpress/securedrop) - SecureDrop is an open-source whistleblower submission system that media organizations and NGOs can install to securely accept documents from anonymous sources.
- [WikiLeaks](https://wikileaks.org/) - WikiLeaks specializes in the analysis and publication of large datasets of censored or otherwise restricted official materials involving war, spying, and corruption.
