<div class="github-widget" data-repo="johnjago/awesome-theravada"></div>
## Awesome Theravada [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[<img src="https://upload.wikimedia.org/wikipedia/commons/d/df/Dharma_Wheel.svg" alt="Dharmachakra" align="right" width="170">](https://en.wikipedia.org/wiki/Theravada)

[Theravada](https://en.wikipedia.org/wiki/Theravada) 是佛教的一个分支，其教义源自巴利藏经，这是佛陀教义现存最古老的记录之一.



## Academic
- [Tipitaka](https://www.accesstoinsight.org/tipitaka/index.html) - 三藏或巴利经典是主要巴利语文本的集合，构成了上座部佛教的教义基础. 
- [Early Buddhist texts, translations, and parallels](https://suttacentral.net/)  - 三藏经； 被某某人翻译 [Bhante Sujato](https://en.wikipedia.org/wiki/Bhante_Sujato) 并附有相关翻译.
- [A Systematic Study of the Majjhima Nikaya](http://bodhimonastery.org/a-systematic-study-of-the-majjhima-nikaya.html) - 佛陀生平、伦理、禅修和智慧的讲座.
- [An Introduction to Buddhism](http://www.aimwell.org/buddhism.html) - 比丘比萨拉 (Bhikkhu Pesala) 用通俗易懂的语言概述了八正道和几种冥想技巧.
- [Universität Hamburg: Prof. Bhikkhu Analayo](https://www.buddhismuskunde.uni-hamburg.de/en/personen/analayo.html) - 多本有关上座部佛教主题的书籍和论文的作者.

## Articles

- [Allowing Things to Arise](http://buddhanet.net/4noble19.htm) - 如何处理摆脱消极心理状态的愿望.
- [Grasping and Clining](http://www.buddhanet.net/budasa7.htm) - 四种不同的执着以及如何消除这些执着的原因.
- [Letting Go](http://buddhanet.net/4noble14.htm) - 深入思考，用具体例子来解释.
- [ThoughtCo](https://www.thoughtco.com/buddhism-4133165) - 芭芭拉·奥布莱恩 (Barbara O&#39;Brien) 撰写的清晰而优美的佛教系列，其中多次引用了巴利文经典.

## Blogs

- [American Monk: Bhante Subhūti](http://americanmonk.org/) - 源自斯里兰卡和缅甸森林传统的僧人.
- [Bosque Theravada](https://www.bosquetheravada.org/) - 致力于巴利藏经、早期佛教和阿姜查传统的佛教网站.
- [Cattāri Brahmavihārā](https://cattaribrahmavihara.com/) - 纽约市三个孩子的父亲，每天坚持练习.
- [Dhamma Musings](https://sdhammika.blogspot.com/) - Shravasti Dhammika 的冥想和旅行.
- [Dhamma Reflections](https://dhammareflections.wordpress.com/) - 在家弟子修行早期佛教教义的见解.
- [In the Words of Buddha](https://inthewordsofbuddha.wordpress.com/) - 通过文本分析，让现代世界了解佛陀的真实教义.
- [Sujato’s Blog](https://sujato.wordpress.com/) - 在当代背景下对佛教及相关问题的看法.
- [Reflections: Ajahn Sucitto](https://sucitto.blogspot.com/) - 一位经验丰富的佛教僧人的个人博客.

## Books

- [How to Meditate](https://www.sirimangalo.org/text/how-to-meditate/) - 有关如何冥想的指南，有多种格式和语言版本.
- [Lessons in Practical Buddhism](https://www.sirimangalo.org/text/lessons-in-practical-buddhism/) - 帮助人们生活安宁幸福的实用教导.
- [The Collected Teachings of Ajahn Chah](https://forestsangha.org/teachings/books/the-collected-teachings-of-ajahn-chah-single-volume?language=English) - 单卷包含阿姜查的许多开示，以直接、简单而深刻的方式传达教义.
- [The Four Noble Truths](https://forestsangha.org/teachings/books/the-four-noble-truths?language=English) - 阿姜苏美多 (Ajahn Sumedho) 所著的小册子，介绍四圣谛和八正道.
- [A Handful of Leaves](http://www.ahandfulofleaves.org/) - 可能很难找到硬拷贝格式的书籍和论文.

## Dhamma Talks

### Audio

- [BuddhaNet](http://www.buddhanet.net/audio-talks.htm) - 不同传统的上师（包括世俗和出家）的演讲样本.
- [Buddhist Society of Western Australia](http://podcast.bswa.org/) - BSWA 按教师和类别组织的讲座.
- [dhamma.audio](https://dhamma.audio/) - 来自不同地方的教学图书馆，可按教师和馆藏分类.
- [dhammatalks.org](http://www.dhammatalks.org) - 萨尼萨罗比丘 (Thanissaro Bhikkhu) 的经典、音频讲座和书籍的英文翻译.
- [Tisarana](https://tisarana.ca/teachings-audio/) - 加拿大蒂萨拉纳佛教寺院的演讲录音.

## Forums

- [Discuss & Discover](https://discourse.suttacentral.net/) - SuttaCentral 早期佛教文本的论坛.
- [Dhamma Wheel](https://dhammawheel.com/) - 讨论有关上座部佛教的各种主题.
- [Dhammaloka Community](https://bswa.org/about-dhammaloka-community/) - 向澳大利亚 Dhammaloka 市中心的成员询问并向他们学习.

## Organizations

- [Forest Sangha](https://forestsangha.org/) - 阿姜查泰国森林传统的国际寺院所在地.
- [Sirimangalo International](https://www.sirimangalo.org/)  - 以音频、视频和印刷形式教授冥想和佛教. 它也是位于安大略省汉密尔顿的冥想中心.

## Pali

- [Pali Tutor](https://www.arrowriver.ca/pali/paliDrill1.html) - 练习词形变化、词形变化和词汇.
- [Pronunciation](http://www.bps.lk/pali_misc/palipron.html) - 巴利字母及其发音的单页指南.
- [Bhikkhu Bodhi's A Course in the Pali Language](http://bodhimonastery.org/a-course-in-the-pali-language.html)  - 旨在帮助您通过直接学习佛陀开示的选集来学习巴利语语法和词汇的基础知识. 它的目的是让你尽快阅读佛陀开示的原著.
- [Buddha Vacana](http://www.buddha-vacana.org/index.html) - 这个网站是专门为那些希望通过学习巴利语基础知识来更好地理解佛陀教义，但又没有太多时间的人而设计的.
- [Pali Suffixes](http://dhamma.ru/paali/tables/palisufi.htm) - 单词结尾的不同方式列表，来自 Kogen Mizuno 的巴利语词典.
- [Basic Pāli Noun Declension (PDF)](http://palitools.sourceforge.net/docs/BasicPaliNounDeclension.pdf) - 备忘单，其中包含名词可以采用的各种形式. 
- [Pali Verbal Endings (PDF)](http://palitools.sourceforge.net/docs/PaliVerbalEndings.pdf) - 备忘单，带有基于时态的语言结尾.
- [Morphological analyzer and generator for Pali (PDF)](https://arxiv.org/pdf/1510.01570.pdf) - 巴利文形态分析方向的第一步.
- [Chant Pali](http://chantpali.org/) - 念诵和学习最常见的巴利语短语的有用指南，逐行、逐音节分解.
- [Pratyeka](http://pali.pratyeka.org/) - 通过三本教科书全面学习巴利语.

## Places

### Monasteries

- [Abhayagiri](https://www.abhayagiri.org) - 加利福尼亚州红杉谷 - 个人和家庭有机会接触佛陀教义的环境.
- [Amaravati](http://www.amaravati.org/) - 英格兰赫特福德郡 - 森林传统僧侣和修女的修行场所.
- [Aruna Ratanagiri](https://ratanagiri.org.uk/) - 英格兰诺森伯兰 - 由方丈 Ajahn Munindo 领导的森林传统修道院.
- [Atammayatarama Buddhist Monastery](http://www.atamma.org/) - 华盛顿州伍丁维尔 - 上座部修道院，提供免费服务、书籍和冥想课程.
- [Bodhinyanarama](http://www.bodhinyanarama.net.nz/) - 新西兰惠灵顿 - 树木繁茂的山谷中的避难所，用作修道院住所和佛教活动的公共区域.
- [Buddha Bodhivana](http://buddhabodhivana.org/) - 澳大利亚维多利亚州东沃伯顿 - 小镇上的森林修道院.
- [Cittaviveka](http://www.cittaviveka.org/) - 英国汉普郡 - 主要是僧侣和修女的住所.
- [Dhamma Vihara](http://www.dhammavihara.org/) - 墨西哥韦拉克鲁斯 - 促进团体和个人冥想静修.
- [Dhammapala](http://dhammapala.ch/home-eng/) - 瑞士坎德施泰格 - 山中安静的修道院.
- [Mosteiro Suddhavāri](https://suddhavari.org/) - 巴西米纳斯吉拉斯州圣洛伦索 - 森林传统修道院，以阿姜·穆迪托 (Ajahn Mudito) 为常驻修道院.
- [Sitavana](https://birken.ca/) - 森林修道院，坎卢普斯，不列颠哥伦比亚省 - 森林传统修道院，阿赞索纳 (Ajahn Sona) 担任方丈.
- [Temple Forest Monastery](http://forestmonastery.org/) - 新罕布什尔州坦普尔 - 荒野、隐居和交通的平衡.
- [Wat Nong Pah Pong](http://watnongpahpong.org/indexe.php) - 泰国乌汶府 - 由尊贵的阿姜查 (Ajahn Chah) 建立的森林寺院.
- [Wat Pah Nanachat](http://www.watpahnanachat.org/) - 泰国乌汶府 - 讲英语的人可以在这里实践佛陀教导的简单生活方式.

### Temples

- [Wat San Fran](http://watsanfran.org/) - 加利福尼亚州旧金山 - 用于学习、庆祝佛教节日以及体验泰国文化的寺庙.

### Hermitages

- [Hillside Hermitage](http://www.hillsidehermitage.org/) - 斯里兰卡指关节山脉附近森林传统僧侣的小隐居处.
- [Pacific Hermitage](http://pacifichermitage.org/) - 华盛顿州白鲑鱼 - 小修道院，僧侣们可以在这里花时间学习和冥想.
- [The Forest Hermitage](http://foresthermitage.org.uk/) - 英国沃里克郡 - 佛教监狱牧师组织总部.

### Meditation Centers

- [Barre Center for Buddhist Studies](https://www.buddhistinquiry.org/) - 马萨诸塞州巴里 - 提供结合学习、讨论和冥想的住宿和在线课程.

## Russian Language

- [Dhamma.ru](https://dhamma.ru/) - 各种资源.
- [Theravada.ru](http://theravada.ru/) - 圣彼得堡社区对上座部佛教的介绍.

## Suttas

### Individual Suttas

- [Aputtaka Sutta: Heirless](https://www.accesstoinsight.org/tipitaka/sn/sn03/sn03.019.than.html) - 佛陀批评那些囤积财富而不享受或给予他人的人.
- [Dhammacakkappavattana Sutta: Setting the Wheel of Dhamma in Motion](http://www.accesstoinsight.org/tipitaka/sn/sn56/sn56.011.than.html) - 佛陀的第一次开示.
- [Samaññaphala Sutta: The Fruits of the Contemplative Life](http://www.accesstoinsight.org/tipitaka/dn/dn.02.0.than.html) - 全面描绘佛教修行之道，以生动的比喻说明修行的各个阶段.
- [Kasi Bharadvaja Sutta: To the Plowing Bharadvaja](http://www.accesstoinsight.org/tipitaka/sn/sn07/sn07.011.than.html) - 佛陀解释了他如何像农民一样犁地、播种和吃饭.
- [Nidhi Kanda: The Reserve Fund](http://www.accesstoinsight.org/tipitaka/kn/khp/khp.1-9.than.html#khp-8) - Reminder that a fund of virtue and restraint will always be safe, while a material fund can be lost.
- [Tuvataka Sutta: Quickly](http://www.accesstoinsight.org/tipitaka/kn/snp/snp.4.14.than.html) - 出家人应该怎样做，其中的部分也适用于在家人.

### Resources

- [Access to Insight](http://www.accesstoinsight.org/) - 翻译了超过一千部巴利文经典经.
- [Ancient Buddhist Texts](https://www.ancient-buddhist-texts.net/) - 原始文本、翻译和巴利语材料.
- [Apadāna (Legends of the Buddhist Saints)](http://apadanatranslation.org/) - 六百首自传体诗歌的完整翻译，这些诗歌被认为是早期佛教界成就斐然的佛陀和阿罗汉.
- [dhammadāna](http://dhammadana.org/) - 了解佛陀的法语、英语、意大利语、缅甸语和日语的原始教义.
- [Dhammapada](http://www.accesstoinsight.org/tipitaka/kn/dhp/dhp.intro.budd.html) - 总结佛陀教义基本原则的简短诗句.
- [Parallel Reading of the Dhammapada](http://myweb.ncku.edu.tw/~lsn46/tipitaka/sutta/khuddaka/dhammapada/dhp-contrast-reading/dhp-contrast-reading-en/) - 并排阅读并比较《法句经》的多个版本.
- [Sādhu!](https://www.dhamma.ru/sadhu/) - 物理位置和网站的世界目录.
- [SuttaCentral](https://suttacentral.net/) - 多种语言的早期佛教文本、翻译和对照.

## Videos

- [Buddhist Society of Western Australia](https://bswa.org/teachings/) - 包括阿姜·勃拉姆 (Ajahn Brahm) 在内的多位出家人的佛法开示.
- [SI Video Wiki](https://video.sirimangalo.org/) - Yuttadhammo Bhikkhu 的视频分类选择.

### Individual Videos

- [Ask A Monk: Divorce](https://www.youtube.com/watch?v=Uq4ibpX-nS0) - 关于离婚的讨论回到了佛教的基础.
- [Ask A Monk: Life Partners](https://www.youtube.com/watch?v=MHu46KZVchY) - 痛苦不是来自没有得到你想要的东西，而是来自想要本身.
- [Dana en Wat Pah Nanachat](https://www.youtube.com/watch?v=Y1bTUC7QUbI)  - 漫步Wat Pah Nanachat 的日常生活，重点关注布施这一主题及其在佛教生活中所扮演的角色.  （西班牙语，英文字幕）
- [The Mindful Way](https://viewtube.io/watch?v=eFy-a9VaVvE) - BBC 纪录片，讲述泰国森林传统佛教寺院的生活和功能.

### YouTube Channels

- [1983dukkha](https://www.youtube.com/user/1983dukkha/videos) - 著名佛教僧侣和尼姑的演讲录音.
- [Abhayagiri Buddhist Monastery](https://www.youtube.com/channel/UCFAuQ5fmYYVv5_Dim0EQpVA/videos) - Abhayagiri 的直播、讲座和活动.
- [Ajahn Sona](https://www.youtube.com/user/AjahnSona) - 比尔肯森林佛教寺院方丈讲解佛教基本概念.
- [AjahnBrahmRetreats](https://www.youtube.com/user/AjahnBrahmRetreats) - 与 Ajahn Brahm 在 Jhana Grove 禅修中心的禅修录音.
- [Bodhisaddha Forest Monastery](https://www.youtube.com/channel/UCCNZfA9m6Q8DZ7V192QMu1Q) - 森林修道院的生活.
- [BSV Dhamma Talks](https://www.youtube.com/user/BSVWeeklyDTEng) - 维多利亚佛教协会向社区传播佛陀的教义.
- [Buddhist Fellowship](https://www.youtube.com/user/buddhistfellowshipsg/videos) - 来自同名非宗派佛教组织的视频.
- [Buddhist Society of Western Australia](https://www.youtube.com/user/BuddhistSocietyWA/videos) - 达摩珞佛教中心的僧侣和尼姑的讲座.
- [Dhamma in English](https://www.youtube.com/channel/UCi_BnRZmNgECsJGS31F495g/videos)  - 与来自世界各地的非专业访客进行现场对话和问答.  （英语）
- [Dhamma Talks by Thanissaro Bhikkhu](https://www.youtube.com/channel/UC6FSq_ptJ-I6aTHT-XA_e0Q) - 塔尼萨罗比丘 (Thanissaro Bhikkhu) 的较长音频讲座.
- [Dhammanet](https://www.youtube.com/user/dhammanet/videos) - 受人尊敬的学者、佛教僧侣和哲学家的鼓舞人心和启发性的演讲.
- [Hillside Hermitage](https://www.youtube.com/channel/UCKejmWAt_kNpRMq5gQEGAqw/videos) - Ajahn Nyanamoli Thero 对佛法开示的简短问答.
- [London Buddhist Videos](https://www.youtube.com/channel/UCDtDoWqqaE_GMOBf33PtsOA/videos) - 来自伦敦佛教寺院的讲座、讲座和教育材料.
- [PhraSuchart Live](https://www.youtube.com/channel/UCHtDbJ3n3aURo0yjyD8kcNA/videos)  - 与来自世界各地的非专业访客进行现场对话和问答.  （泰语-ไทย）
- [Portland Friends of the Dhamma](https://www.youtube.com/channel/UCHLz6Y2gbO2njffgLsV6FrA) - 阿姜查泰国森林传统的佛教中心，接待来访僧侣的讲座.
- [Short Dhamma Talks by Thanissaro Bhikkhu](https://www.youtube.com/channel/UCQRkIum1cnPNI5QZ0XtIMWw) - 塔尼萨罗比丘 (Thanissaro Bhikkhu) 在慈光森林寺 (Metta Forest Monastery) 每日开示.
- [StudentofthePath](https://www.youtube.com/user/StudentofthePath/videos) - 美国出生的佛教僧侣的无家可归之旅.
- [The Noble Path](https://www.youtube.com/user/Dhammavat/videos) - 几部关于 1900 年代末佛教的纪录片.
- [urbanbuddhistmonk](https://www.youtube.com/user/westendbuddhistmedia) - 来自西区佛教寺庙和冥想中心的 Bhante Saranapala 的演讲.
- [Wat Marp Jan (วัดมาบจันทร์)](https://www.youtube.com/user/watmarpjan) - 在阿赞·阿南·阿基卡诺 (Ajahn Anan Akiñcano) 建立的泰国森林寺院举办的活动.
- [watsanfran](https://www.youtube.com/user/watsanfran/videos) - 泰语和英语的课程和每日布道.
- [Yuttadhammo Bhikkhu](https://www.youtube.com/user/yuttadhammo/videos) - 几乎每天都会直播有关冥想、佛教和僧侣生活的主题.

## License

[CC0 1.0](https://creativecommons.org/publicdomain/zero/1.0/)
