<div class="github-widget" data-repo="aaronhma/awesome-tensorflow-js"></div>
## Awesome TensorFlowJS [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

TensorFlow.js 是一个开源软件库，用于在 JavaScript 中开发机器学习模型，并使用机器学习
（训练和推理）直接在浏览器或 Node.js 中.

这个列表是最好的集合 [TensorFlow.js](https://www.tensorflow.org/js) 工具、资源、视频和闪亮的东西.

---






---

## Learn

### Documentation

- [Official Documentation](https://www.tensorflow.org/js/guide)
- [API Reference](https://js.tensorflow.org/api/latest/)


### Tutorials

- [TensorFlow.js gallery](https://github.com/tensorflow/tfjs/blob/master/GALLERY.md) - TensorFlow.js 项目、教程、视频等的集合.
- [Machine Learning Crash Course](https://developers.google.com/machine-learning/crash-course/) - Google 对机器学习的快节奏实用介绍.
- [Google Codelabs](https://codelabs.developers.google.com/) - Google Developers Codelabs 提供指导、教程、实践编码体验.
- [Beginning ML with TensorFlow.js](https://academy.infinite.red/p/beginning-machine-learning-with-tensorflow-js) - 网络开发人员进入 TF.js 的完整在线课程.
- [Effective TensorFlow.js](https://effectivemachinelearning.com/TensorFlow.js) - TensorFlow.js 教程和最佳实践.


### Models/Projects

- [Official tfjs models on TensorFlow.js repo](https://github.com/tensorflow/tfjs-models) - TensorFlow.js 的预训练模型.
- [Official tfjs models on TensorFlow.js website](https://www.tensorflow.org/js/models) - 探索可用于任何开箱即用项目的预训练 TensorFlow.js 模型.
- [@tensorflow-models on NPM](https://www.npmjs.com/search?q=%40tensorflow-models) - NPM 上 TensorFlow.js 的各种预训练模型.
- [Official tfjs examples repo](https://github.com/tensorflow/tfjs-examples) - 使用 TensorFlow.js 构建的示例！
- [Official tfjs demo website](https://www.tensorflow.org/js/demos) - 查看使用 TensorFlow.js 构建的示例和现场演示！


### Papers

- [TensorFlow.js: Machine Learning for the Web and Beyond](https://arxiv.org/abs/1901.05350) - 本文描述了 TensorFlow.js 的设计、API 和实现，并重点介绍了一些有影响力的用例.
- [JSDoop and TensorFlow.js: Volunteer Distributed Web Browser-Based Neural Network Training](https://arxiv.org/abs/1910.07402) - 实验结果表明，在分布式网络浏览器中训练神经网络是可行和准确的，具有很高的可扩展性，是一个值得研究的有趣领域.


### Videos

- [Official TensorFlow.js video series](https://www.youtube.com/playlist?reload=9&list=PLs6AluHXaQnjeI6jzDkpKXvbPj31i4GgF) - YouTube 内容侧重于 TensorFlow 生态系统更新.
- [TensorFlow.js: ML for the web and beyond](https://youtu.be/iH9CS-QYmZs) - 2020 年 TensorFlow 开发峰会.
- [Rock Paper Scissors!](https://www.youtube.com/watch?v=y4pfTQJaUJU) - 在您的机器上训练剪刀石头布，并使用您的网络摄像头观看结果！
- [Color Blind Tensors](https://www.youtube.com/watch?v=X55m9eS5UFU) - 操纵图像张量来感知色盲，实时编码.


### Books

- [Deep Learning with JavaScript](https://www.manning.com/books/deep-learning-with-javascript) - 学习使用 TensorFlow.js 构建直接在浏览器中运行的深度学习模型，掌握深度学习的所有基础知识并探索高级概念，例如重新训练现有模型以进行迁移学习和图像生成，作者：Shanqing Cai、Stanley Bileschi、Eric D . 尼尔森和弗朗索瓦·肖莱.

- [Hands-On Machine Learning with TensorFlow.js](https://www.amazon.com/Hands-Machine-Learning-TensorFlow-js-applications/dp/1838821732) - 使用 Kai Sasaki 编写的使用 TensorFlow.js 库构建与 Web 技术集成的 ML 应用程序的指南.

- [Learning Tensorflow.js: Powerful Machine Learning in JavaScript](https://amzn.to/3dR3vpY) - 在本指南中，作者 [Gant Laborde](https://github.com/gantman) 为包括数据科学家、工程师、Web 开发人员、学生和研究人员在内的广泛技术受众提供 TensorFlow.js 基础知识的端到端实践方法.

- [Practical TensorFlow.js](https://www.apress.com/gp/book/9781484262726) - Juan De Dios Santos Rivera 的 Web 应用程序开发中的深度学习.

- [Practical Machine Learning in JavaScript](https://www.apress.com/gp/book/9781484264171) - 查理·杰拉德 (Charlie Gerard) 为 Web 开发人员准备的 TensorFlow.js.


### Blog & Posts

- [Official TensorFlow.js blog](https://blog.tensorflow.org/search?label=TensorFlow.js&max-results=20) - 涵盖在 JavaScript 中构建模型并在浏览器或 Node.js 中使用它们.
- [Towards Data Science](https://towardsdatascience.com/search?q=tensorflow.js)



### Powered by TensorFlow.js

- [Handwritten Digit Classification](https://github.com/aaronhma/ngconf-2020) - 一个展示项目 [NgConf 2020](https://www.ng-conf.org/) 讨论**使用 TensorFlow.js 进入机器学习世界**.
- [NSFWJS - Indecent Content Checker](https://github.com/infinitered/nsfwjs) - 一个友好的库，用于检查图像以查看它们在客户端或服务器上是否是不雅内容！
- [Pose Animator](https://pose-animator-demo.firebaseapp.com/camera.html) - 一种通过动作捕捉使 SVG 角色在浏览器中栩栩如生的工具.
- [LipSync](https://lipsync.withyoutube.com/) - 一种基于网络的、有趣的、交互式的体验，可以与您最喜爱的歌曲进行口型同步.
- [BodyPix](https://storage.googleapis.com/tfjs-models/demos/body-pix/index.html) - 浏览器中的实时人物和身体部位分割.


## Tools

### Libraries

- [TensorFlow.js](https://github.com/tensorflow/tfjs) - 用于训练和部署 ML 模型的 WebGL 加速 JavaScript 库.
- [ml5.js](https://ml5js.org/) - 友好的网络机器学习.
- [face-api.js](https://github.com/justadudewhohacks/face-api.js) - 用于在浏览器中进行人脸检测和人脸识别的 JavaScript API，以及带有 tensorflow.js 的 Node.js.
- [handtrack.js](https://github.com/victordibia/handtrack.js/) - 用于直接在浏览器中制作实时手部检测（边界框）原型的库.
- [magenta.js](https://magenta.tensorflow.org/get-started/#magenta-js) - 在浏览器中使用机器智能生成音乐和艺术.
- [Danfo.js](https://danfo.jsdata.org/)  - 用于操作和处理结构化数据的高性能、直观且易于使用的数据结构.  （灵感来自熊猫）


### Tools/Utilities

- [Glitch](https://glitch.com/@TensorFlowJS) - 在浏览器中免费构建快速、全栈的网络应用程序（Tensorflow.js 模板）.
- [CodePen](https://codepen.io) - *bit.ly/codepen-tfjs* 构建、测试和发现前端代码（Tensorflow.js 模板）的最佳场所.
- [TensorFlow Playground](https://playground.tensorflow.org) - 在您的浏览器中修改神经网络！
- [AiJS](https://aijs.rocks/) - 一系列鼓舞人心的 AI 驱动的 JavaScript 应用程序.
- [Teachable Machine](https://teachablemachine.withgoogle.com/) - 训练计算机识别您自己的图像、声音和姿势！
- [TensorPlayground.com](https://www.tensorplayground.com/1.0.0/)  - 直接在浏览器中编写、修改和查看张量. 然后把代码分享给其他人.


## Community

### Online Community

- [Twitter](https://twitter.com/tensorflow)
- [Stack Overflow](https://stackoverflow.com/questions/tagged/tensorflow.js)
- [Reddit](https://www.reddit.com/r/TensorFlowJS)


### Social Media

- [#MadeWithTFJS](https://twitter.com/hashtag/MadeWithTFJS) - 查看社区的成果并分享您的作品！
- [Laurence Moroney](https://twitter.com/lmoroney) - 谷歌 AI 开发者关系负责人.
- [Nikhil Thorat](https://twitter.com/nsthorat) - TensorFlow.js 的联合负责人.
- [Daniel Smilkov](https://twitter.com/dsmilkov) - TensorFlow.js 的联合创始人.
- [Paige Bailey](https://twitter.com/DynamicWebPaige) - 建筑
适用于所有人和所有平台的 Google AI.
- [Aaron Ma](https://twitter.com/aaronhma) - 世界上最年轻的 TensorFlow 贡献者！
- [Sandeep Gupta](https://twitter.com/TheSandeepGupta) - TensorFlow 产品经理.
- [Jason Mayes](https://twitter.com/jason_mayes) - TensorFlow.js 的开发倡导者.
- [Gant Laborde](https://twitter.com/GantLaborde) - 网络和机器学习 GDE.

## Contributions

随时欢迎您的贡献！

如果您想为此列表做出贡献（请这样做），请向我发送拉取请求或与我联系 [@aaronhma on Twitter](https://twitter.com/aaronhma)
此外，如果您注意到由于以下任何原因，应弃用上述任何存储库：

- 存储库的所有者明确表示“此库未维护”.
- 长期未承诺（2~3 年）.

有关的更多信息 [guidelines](https://github.com/aaronhma/awesome-tensorflow-js/blob/master/CONTRIBUTING.md).

**注意：为了创建一个受到所有人欢迎的社区，所有贡献者都必须同意 [Code of Conduct](https://github.com/aaronhma/awesome-tensorflow-js/blob/master/CODE_OF_CONDUCT.md).**
