<div class="github-widget" data-repo="livewire/awesome-tall-stack"></div>
## Awesome TALL Stack [![Awesome](https://awesome.re/badge.svg)](https://awesome.re) ![Lint Awesome List](https://github.com/blade-ui-kit/awesome-tall-stack/workflows/Lint%20Awesome%20List/badge.svg)

&gt; 与 TALL 堆栈相关的精选列表.

The [TALL stack](https://tallstack.dev/) 是一个完整的堆栈开发解决方案，具有 Laravel 社区构建的一些库. 它提供的工具使您可以编写专注于后端的应用程序，而不必编写太多的 JavaScript，从而使您可以专注于较小的编程工具集.



## The TALL Stack

- [Tailwind CSS](https://tailwindcss.com) - ([Awesome List](https://github.com/aniftyco/awesome-tailwindcss)) - 用于快速构建自定义设计的实用程序优先 CSS 框架.
- [Alpine.js](https://github.com/alpinejs/alpine) - ([Awesome List](https://github.com/alpinejs/awesome-alpine)) - 用于在标记中编写 JavaScript 行为的坚固、最小的框架.
- [Livewire](https://laravel-livewire.com) - ([Awesome List](https://github.com/imliam/awesome-livewire)) - Laravel 的全栈框架，消除了构建动态 UI 的痛苦.
- [Laravel](https://laravel.com) - ([Awesome List](https://github.com/chiraggude/awesome-laravel)) - 一个具有表现力、优雅语法的 PHP Web 应用程序框架.

## Community Websites

- [talltips](https://talltips.novate.co.uk/) - 收集 TALL 堆栈中的技巧和想法.

## Libraries

- [Alptail](https://www.alptail.com) - 一组开源 UI 组件，使用 Tailwind CSS 和 Alpine.js.
- [Blade Icons](https://github.com/blade-ui-kit/blade-icons) - 在 Laravel Blade 视图中轻松使用 SVG 图标的包.
- [Blade Script](https://github.com/cbl/blade-script) - 一个包，可以轻松地将转译和缩小的脚本添加到您的 Blade 组件中.
- [Blade Style](https://github.com/cbl/blade-style) - 一个可以轻松缩小样式并在 Blade 组件中使用 sass、less 等的包.
- [Blade UI Kit](https://blade-ui-kit.com/) - 一组可在 Laravel Blade 视图中使用的无渲染组件.
- [Docdress](https://github.com/aw-studio/docdress) - 一个以类似 Laravel 的设计从 GitHub 存储库创建降价文档的包.
- [Filament](https://filamentadmin.com) - 优雅的 TALL 堆栈管理面板，适用于 Laravel 工匠.
- [Laravel Form Components](https://github.com/pascalbaljetmedia/laravel-form-components) - 一组 Blade 组件，可使用 Tailwind CSS 自定义表单和 Bootstrap 4 快速构建表单.
- [Laravel TALL Preset](https://github.com/laravel-frontend-presets/tall) - Laravel 的前端预设，用于使用 TALL 堆栈构建应用程序.
- [Laravel TALL Preset](https://github.com/use-preset/laravel-tall/) - 仅需一个命令即可安装 TALL 堆栈的预设.
- [Laravel TTALL Preset](https://github.com/pktharindu/ttall) - Turbolinks + TALL 堆栈的预设，捆绑了一些有用的包及其配置.
- [Laravel Views](https://github.com/Gustavinho/laravel-views) - Laravel 包使用 TALL 堆栈创建漂亮的公共视图，如数据表.
- [Livewire Datatables](https://github.com/mediconesystems/livewire-datatables) - 用于创建具有排序、过滤、搜索、导出等功能的表格的包.
- [Livewire PowerGrid](https://github.com/Power-Components/livewire-powergrid) - ⚡ PowerGrid ⚡ 创建现代、强大且易于定制的数据表.
- [MarkdownX](https://devdojo.com/markdownx) - 具有下拉菜单、图片上传、代码块等功能的高级 Markdown 编辑器.
- [Tailwind UI](https://tailwindui.com)  - 使用 Tailwind CSS 构建的漂亮 UI 组件. 提供 Alpine.js 集成.
- [TALL Forms](https://github.com/tanthammar/tall-forms) - 具有实时验证、文件上传、数组字段、刀片式表单输入组件等的动态响应式 Laravel Livewire 表单组件.
- [X Blade Components](https://github.com/masterix21/x-blade-components) - 即用型刀片组件.
- [WireUI](https://github.com/wireui/wireui)  - 一种添加由 alpine.js 和 tailwind 制作的刀片组件的简单、快速和优雅的方式，随时可用，享受轻松.  Livewire 组件和 Tall Stack 组件

## Learning

图例：✍️ 博文·演员表

- [A contact form with Livewire and Tailwind CSS](https://stefanbauer.me/articles/a-contact-form-with-laravel-livewire) - 了解如何使用 Livewire 和 Tailwind CSS 构建联系表单.
- [Blade Component Cookbook](https://laracasts.com/series/blade-component-cookbook) - 了解如何使用 Laravel、Tailwind CSS 和 Alpine.js 构建 Blade 组件.
- ✍️ [Building a realtime dashboard powered by Laravel, Livewire and Tailwind](https://freek.dev/1645-building-a-realtime-dashboard-powered-by-laravel-livewire-and-tailwind-2020-edition)
- ✍️ [Building complex forms with Laravel Livewire in Oh Dear](https://freek.dev/1609-building-complex-forms-with-laravel-livewire-in-oh-dear)
- ✍️ [Embracing The Tall Stack with Event Sourcing, an adventure into the unknown](https://www.juststeveking.uk/embracing-the-tall-stack-with-event-sourcing-an-adventure-into-the-unknown/)
- ✍️ [How to Build a Job Board With the TALL Stack + Demo](https://lightit.io/blog/how-to-do-a-job-board-with-the-tall-stack/)

## Examples

这些应用程序和网站是使用 TALL 堆栈构建的.

图例：开源·闭源

- [aw-studio.de](https://aw-studio.de/) - [repository](https://github.com/aw-studio/aw-studio.de) - 使用 Laravel 和 Tailwind CSS 构建.
- [devdojo.com](https://devdojo.com) - 开发者社区和工具
- [driesvints.com](https://driesvints.com) - [repository](https://github.com/driesvints/driesvints.com) - 使用 Laravel 和 Tailwind CSS 构建.
- [fullstackbelgium.be](https://fullstackbelgium.be) - [repository](https://github.com/fullstackbelgium/fullstackbelgium.be) - 使用 Laravel 和 Tailwind CSS 构建.
- [fullstackeurope.com](https://fullstackeurope.com) - [repository](https://github.com/fullstackeurope/fullstackeurope.com) - 使用 Laravel、Alpine.js 和 Tailwind CSS 构建.
- [novapackages.com](https://novapackages.com) - [repository](https://github.com/tightenco/novapackages) - 发现新的 Laravel Nova 包.
- [pingping.io](https://pingping.io?ref=awesome-tall-stack) - 网站正常运行时间和 SSL 监控.
