<div class="github-widget" data-repo="pehapkari/awesome-symfony-education"></div>
## Awesome Symfony Education [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[![Build Status](https://img.shields.io/travis/pehapkari/awesome-symfony-education/master.svg?style=flat-square)](https://travis-ci.org/pehapkari/awesome-symfony-education)

精选的令人惊叹的 Symfony **文章、系列和书籍**列表.

*对于捆绑选择，检查 [sitepoint-editors/awesome-symfony](https://github.com/sitepoint-editors/awesome-symfony).*


## Single Action Controller

- [DunglasActionBundle: Symfony controllers, redesigned](https://dunglas.fr/2016/01/dunglasactionbundle-symfony-controllers-redesigned/) [2016]
- [Symfony Hello World](https://beberlei.de/2014/04/24/symfony_hello_world.html) [2014]


## Tutorials and Video Courses

* [SymfonyCasts - Learn Symfony 4](https://symfonycasts.com/tracks/symfony)
    * 视频 + 文章. 简单明了，有例子.
* [Working with Symfony 2](https://code.tutsplus.com/series/working-with-symfony-2--cms-636)
   * 初学者短视频系列
* [Symfony 2 - under 5 minutes](https://www.youtube.com/playlist?list=PL3Wxyd2R8-gIuToQ1NmhVSLZfjrBMePNu)
   * 初学者短视频系列


## Series for begginers

* [Joyful Development with Symfony 3](https://symfonycasts.com/tracks/symfony3) [2016] 由 SymfonyCasts
* [Symfony po krůčkách na Zdroják.cz](https://www.zdrojak.cz/serialy/symfony-po-kruckach/) [2015/2016] [捷克语]
* [Symfony 4.1 Jobeet Tutorial](https://jobeet-tutorial.readthedocs.io/en/latest/) [2018]

## Dependency Injection

* [How to refactor to new Dependency Injection features in Symfony 3.3](https://www.tomasvotruba.cz/blog/2017/05/07/how-to-refactor-to-new-dependency-injection-features-in-symfony-3-3/) 托马斯·沃特鲁巴 [2017]


## EventDispatcher

* [Decouple your application with (Domain-)Events](https://www.youtube.com/watch?v=K9jub4JPpcc) 本杰明·埃伯雷 [2013]
* [Re-thinking Event Listeners](http://mmoreram.com/blog/2015/08/20/re-thinking-event-listeners/) [2015]
* [Journey to the Center of Symfony: HttpKernel Request-Response](https://symfonycasts.com/screencast/symfony-journey) 通过 SymfonyCasts [2015]


## Security

* [Symfony Security, Roles vs. Voters](https://stovepipe.systems/post/symfony-security-roles-vs-voters) [2015]
* [Do not use FOSUserBundle](https://jolicode.com/blog/do-not-use-fosuserbundle) [2015]
* [The new Voter Class](https://symfonycasts.com/screencast/new-in-symfony3/voter) [2016] 由 SymfonyCasts


## Forms

- [Don't Use Entities in Symfony Forms. Use Custom Data Objects Instead](https://blog.martinhujer.cz/symfony-forms-with-request-objects/) [2017]
- [Avoiding Entities in Forms](https://stovepipe.systems/post/avoiding-entities-in-forms) [2016]
- [Rethinking Form Development](https://stovepipe.systems/post/rethinking-form-development) [2016]


## Doctrine

* [How to use Repository with Doctrine as Service in Symfony](https://www.tomasvotruba.cz/blog/2017/10/16/how-to-use-repository-with-doctrine-as-service-in-symfony/) [2017]
* [Mastering Symfony2 Performance – Doctrine](http://labs.octivi.com/mastering-symfony2-performance-doctrine/) [2014]
* [Rich domain model with Symfony 2.5 and Doctrine 2.5](https://www.slideshare.net/_leopro_/rich-domain-model-with-symfony-25-and-doctrine-25) [2014]


## Translations

* [How Happyr work with Symfony translations](https://developer.happyr.com/how-happyr-work-with-symfony-translations) [2015]
* [Translation workflow with Symfony2](https://jolicode.com/blog/translation-workflow-with-symfony2) [2015]
* [How to organize your translations in Symfony](http://obtao.com/blog/2013/06/how-to-organize-your-translations-in-symfony/) [2013]


## Bundles

* [High Quality Symfony Bundles](https://www.slideshare.net/matthiasnoback/high-quality-symfony-bundles-tutorial-dutch-php-conference-2014) [2014]


## Decoupling

* [The Framework as an implementation](https://www.youtube.com/watch?v=0L_9NutiJlc) 作者：Marcello Duarte &amp; Konstantin Kudryashov [2013]， [Github repository](https://github.com/MarcelloDuarte/hexagonal-symfony)
* [Symfony2: How to create framework independent controllers](https://matthiasnoback.nl/2014/06/how-to-create-framework-independent-controllers/) [2014]


## Legacy

* [Bringing Symfony Components into Your Legacy Code](https://speakerdeck.com/hhamon/bringing-symfony-components-into-your-legacy-code) [2016]
* [Eating spaghetti with Symfony](https://speakerdeck.com/jakzal/eating-spaghetti-with-symfony) [2016]
* [Migrating your project to Symfony](https://stovepipe.systems/post/migrating-your-project-to-symfony) [2016]


## Performance

* [Mastering Symfony2 Performance – Internals](http://labs.octivi.com/mastering-symfony2-performance-internals/) [2014]
* [5 Ways to optimize Symfony Baseline Performance](https://tideways.com/profiler/blog/5-ways-to-optimize-symfony-baseline-performance) [2015]


## DDD

* [DDD with Symfony2: Folder Structure And Code First](https://williamdurand.fr/2013/08/07/ddd-with-symfony2-folder-structure-and-code-first/) [2013]


## General

* [Lessons Learned from My First Symfony Project](http://www.thisprogrammingthing.com/2016/lessons-from-my-first-symfony-project/) [2016]
* [Symfony best practices](https://blog.kevingomez.fr/2014/04/08/symfony-best-practices/) [2014]
* [Symfony tips and tricks](https://www.slideshare.net/javier.eguiluz/symfony-tips-and-tricks) [2014]
* [Some Symfony 2 practices](https://emanueleminotto.github.io/blog/some-symfony-2-practices)
* [Výhody a nevýhody Symfony v bodech](https://devel.cz/otazka/nette-vs-symfony#answer-17973) [2014] [捷克语] - by [@spicimedved](https://twitter.com/spicimedved)


## Books

* [Symfony Framework Deepdive - Console](https://leanpub.com/symfonyframeworkdeepdive-console) [2015]
    * Joshua Thijssen 的控制台组件详细指南
* [Symfony Framework Deepdive - Security](https://leanpub.com/symfonyframeworkdeepdive-security) [2015]
    * Joshua Thijssen 的安全组件详细指南
* [Symfony Certification - Unofficial self-study guide](https://leanpub.com/symfony-selfstudy) [2015]
    * 关于 Symfony 基础的基于 QA 的简短部分
* [A Year with Symfony](https://leanpub.com/a-year-with-symfony) [2014 年更新]
    * 初学者了解基本 Symfony 生命周期以及如何利用它来发挥自己优势的好书.


### License

[![CC0](https://licensebuttons.net/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Tomas Votruba](https://www.tomasvotruba.cz/) 已放弃该作品的所有版权和相关或邻接权.
