<div class="github-widget" data-repo="TheComputerM/awesome-svelte"></div>
<p align="center">
  <br>
  <img width="200" src="https://raw.githubusercontent.com/TheComputerM/awesome-svelte/master/./awesome-svelte.svg?sanitize=true" alt="awesome-svelte logo">
  <br>
  <br>
</p>

## Awesome Svelte [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

> ⚡ A curated list of awesome Svelte resources

[Svelte](https://svelte.dev/) is a new way to build web applications. It's a compiler that takes your declarative components and converts them into efficient JavaScript

Contributions welcome. Add links through pull requests or create an issue to start a discussion.



## Resources

### Official Resources

- [Official Guide](https://svelte.dev/tutorial)
- [API Reference](https://svelte.dev/docs)
- [GitHub Repo](https://github.com/sveltejs/svelte)
- [Changelog](https://github.com/sveltejs/svelte/blob/master/packages/svelte/CHANGELOG.md)

### Community

- [Twitter](https://twitter.com/sveltejs)
- [Discord](https://svelte.dev/chat)
- [Reddit](https://www.reddit.com/r/sveltejs/)
- [Japan Discord](https://discord.com/invite/YTXq3ZtBbx) - Svelte 日本.

### Conferences

- [Svelte Summit](https://sveltesummit.com/)

### Podcasts

- [Svelte Radio](https://www.svelteradio.com/)

### YouTube Channels

- [Svelte Society](https://www.youtube.com/channel/UCZSr5B0l07JXK2FIeWA0-jw)
- [Svelte Mastery](https://www.youtube.com/channel/UCg6SQd5jnWo5Y70rZD9SQFA)

### Tutorials

- [Getting Started with Svelte 5: A Guide for React Developers](https://www.edistys.dev/blog/getting-started-with-svelte-5-a-guide-for-react-developers) - Edistys
- [Svelte 5 Basics - Complete Svelte 5 Course for Beginners](https://www.youtube.com/watch?v=8DQailPy3q8) - Syntax (YouTube)

### Studies

_Studies and research on the Svelte framework._

- [SvelteScaling](https://svelte-scaling.acmion.com/) - Does Svelte Scale? _(pre-v5)_
- [Will it Scale?](https://github.com/halfnelson/svelte-it-will-scale) - Finding Svelte's inflection point. _(pre-v5)_

## Integrations

### Preprocessing

- [svelte-preprocess](https://github.com/sveltejs/svelte-preprocess) - A preprocessor for PostCSS, SCSS, Less, Stylus, Coffeescript, TypeScript, Pug and much more.
- [MDSveX](https://github.com/pngwn/MDsveX) - Preprocessor for MDX markdown.
- [svelte-switch-case](https://github.com/l-portet/svelte-switch-case) - Switch case syntax for Svelte.
- [svelte-preprocess-less](https://github.com/ls-age/svelte-preprocess-less) - Preprocessor for less.
- [modular-css](https://github.com/tivac/modular-css/tree/main/packages/svelte) - Preprocessor support for modular-css.
- [svelte-preprocess-sass](https://github.com/ls-age/svelte-preprocess-sass) - Preprocessor for sass.
- [svelte-preprocess-markdown](https://github.com/AlexxNB/svelte-preprocess-markdown) - Write Svelte components in markdown syntax.

### Mobile

_UI frameworks for mobile._

- [Svelte Native](https://svelte-native.technology/) - Svelte controlling native components via Nativescript.
- [Framework7](https://framework7.io/svelte/) - Full featured HTML framework for building iOS & Android apps.
- [Capacitor](https://capacitorjs.com/solution/svelte) - Build native mobile apps with web technology and Svelte.

## State Libraries

- [svelte-asyncable](https://github.com/sveltetools/svelte-asyncable) - The Svelte store contract with support for asynchronous values.
- [exome](https://github.com/Marcisbee/exome) - Simple proxy based state manager for deeply nested states.
- [tanstack-store](https://tanstack.com/store/latest/docs/framework/svelte/quick-start) - Framework agnostic type-safe store w/ reactive framework adapters.

## UI Libraries

- [shadcn-svelte](https://www.shadcn-svelte.com/) - Beautifully designed components that you can copy and paste into your apps.
- [SvelteUI](https://svelteui.dev/) - all inclusive Svelte library - Components, Actions, Utilities, Animations.
- [Flowbite Svelte](https://flowbite-svelte.com/) - Open-source Svelte UI components built with Tailwind CSS and Flowbite.
- [Skeleton](https://www.skeleton.dev/docs/get-started) - Skeleton uses Tailwind utility classes and design system to easily create theme-able user interfaces.
- [Sveltestrap](https://github.com/sveltestrap/sveltestrap) - Bootstrap 4 & 5 components.
- [carbon-components-svelte](https://github.com/IBM/carbon-components-svelte) - Svelte implementation of the IBM Carbon Design System.
- [Svelte Material UI](https://github.com/hperrin/svelte-material-ui) - Material UI Components.
- [Melt UI](https://github.com/melt-ui/melt-ui) - A collection of accessible, reusable, and composable headless component builders and utilities.
- [attractions](https://github.com/illright/attractions) - A pretty cool and modern UI kit. _(pre-v5)_
- [ionic-svelte](https://github.com/Tommertom/svelte-ionic-app) - Svelte integration with Ionic's UI for mobile app development, including many starters.
- [YeSvelte](https://www.yesvelte.com/) - YeSvelte is flexible Svelte UI component library built on top of Bootstrap css.
- [Svelte UX](https://github.com/techniq/svelte-ux) - Large collection of components, actions, stores, and utilities to build highly interactive applications
- [STDF](https://stdf.design) - Mobile web component library based on Svelte and Tailwind.
- [M3 Svelte](https://github.com/KTibow/m3-svelte) - Robust component library implementing Material Design 3
- [AgnosUI](https://amadeusitgroup.github.io/AgnosUI/latest/) - Highly configurable headless framework agnostic component library
- [daisyUI](https://daisyui.com/) - The most popular component library for Tailwind CSS - `daisyUI` adds component class names to Tailwind CSS so you can make beautiful websites faster than ever.
- [Smelte](https://github.com/matyunya/smelte) - UI framework with material components built with Tailwind CSS. _(pre-v5)_
- [SVAR Core for Svelte](https://github.com/svar-widgets/core) - A collection of 20+ Svelte UI components for building fast-performing, interactive and responsive web apps.
- [AgnosticUI](https://github.com/agnosticui/agnosticui) - Accessible Svelte Component Primitives (that also work with React, Vue 3, and Angular).

## UI Components

### Table

_Tables and data grids._

- [@vincjo/datatables](https://github.com/vincjo/datatables) - A toolkit for creating datatable components with Svelte.
- [svelte-table](https://github.com/dasDaniel/svelte-table) - A table implementation that allows sorting and filtering.
- [svelte-generic-crud-table](https://github.com/ivosdc/svelte-generic-crud-table) - Agnostic web-component for object-arrays with CRUD functionality. Sort and resize columns. Multiple tables per page.
- [svelte-generic-table-pager](https://github.com/ivosdc/svelte-generic-table-pager) - Svelte-generic-crud-table with paginator.
- [powertable](https://github.com/muonw/powertable) - PowerTable is a JavaScript component that turns JSON data into an interactive HTML table. This facilitates manual inspection, sorting, filtering, searching, and editing of the data.
- [svelte-pivottable](https://github.com/jjagielka/svelte-pivottable) - Svelte-based pivot table library with drag'n'drop functionality.

### Notification

_Toaster / snackbar - Notify the user with a modeless temporary little popup._

- [svelte-notifications](https://github.com/beyonk-adventures/svelte-notifications) - Toast notifications component that can be used in any JS application.
- [svelte-favicon-badge](https://github.com/kevmodrome/svelte-favicon-badge) - A custom component that adds a favicon and a badge that you can use to show for example number of unread messages, etc.
- [@zerodevx/svelte-toast](https://github.com/zerodevx/svelte-toast) - Simple elegant toast notifications.
- [svelte-french-toast](https://github.com/kbrgl/svelte-french-toast) - Buttery smooth toast notifications for Svelte, inspired by React Hot Toast. Lightweight, customizable, and beautiful by default.
- [svelte-sonner](https://github.com/wobsoriano/svelte-sonner) - An opinionated toast component for Svelte.

### Grid

- [svelte-grid-responsive](https://github.com/andrelmlins/svelte-grid-responsive) - Bootstrap-inspired responsive grid system.
- [svelte-flex](https://github.com/himynameisdave/svelte-flex) - A simple and reusable flexbox component for Svelte.

### Icons

- [unplugin-icons](https://github.com/unplugin/unplugin-icons) - Access thousands of icons as components on-demand universally.
- [svelte-fa](https://github.com/Cweili/svelte-fa) - Tiny FontAwesome 5 and 6 component.
- [svelte-awesome](https://github.com/RobBrazier/svelte-awesome) - Awesome SVG icon component, built with Font Awesome icons.
- [steeze-ui/icons](https://github.com/steeze-ui/icons) - Effortless Icon Packs & Components for Svelte, React, Vue and more.
- [svelte-icons](https://github.com/AnxiousDarkly/svelte-icons) - Icon components.
- [svelte-heroicons](https://github.com/krowten/svelte-heroicons) - Icons, crafted by the creators of Tailwind CSS.
- [svelte-icomoon](https://github.com/aykutkardas/svelte-icomoon) - It makes it very simple to use SVG icons in your Svelte projects.
- [svelte-unicons](https://github.com/devShamim/svelte-unicons) - Unicons svg icons for Svelte based on @iconscout/unicons.
- [lucide-svelte](https://github.com/lucide-icons/lucide) - Implementation of the lucide icon library for svelte applications.
- [svelte-icons-pack](https://github.com/leshak/svelte-icons-pack) - Based on <https://github.com/react-icons/react-icons>.
- [svesome](https://github.com/pouchlabs/svesome) - A fontawesome v6 icons wrapper for svelte its awesome.

### Calendar

_Display non-editable events in a calendar._

- [svelte-fullcalendar](https://github.com/YogliB/svelte-fullcalendar) - A component wrapper around FullCalendar.
- [svelte-calendar](https://github.com/6eDesign/svelte-calendar) - A lightweight datepicker with neat animations and a unique UX.
- [date-picker-svelte](https://github.com/probablykasper/date-picker-svelte) - A date and time picker for Svelte with clean UX.
- [@schedule-x/svelte](https://github.com/schedule-x/schedule-x) - A material design event calendar library.

### Maps

- [svelte-googlemaps](https://github.com/beyonk-adventures/svelte-googlemaps) - Google Maps component.
- [svelte-mapbox](https://github.com/beyonk-adventures/svelte-mapbox) - MapBox map and autocomplete components.
- [leaflet-svelte](https://github.com/anoram/leaflet-svelte) - Svelte wrapper for Leaflet.
- [esri-svelte](https://github.com/gavinr-maps/esri-svelte-example) - Web application that shows how to use the ArcGIS API for JavaScript with Svelte.
- [svelte-maplibre](https://github.com/dimfeld/svelte-maplibre) - Svelte bindings for the MapLibre mapping library.

### Charts

- [svelte-frappe-charts](https://github.com/himynameisdave/svelte-frappe-charts) - Svelte bindings for frappe-charts.
- [Layer Cake](https://github.com/mhkeller/layercake) - A framework for mostly-reusable graphics with svelte
- [LayerChart](https://github.com/techniq/layerchart) - Large collection of composable Svelte components to build a wide range of visualizations, built upon Layer Cake

### Miscellaneous

- [Svelte Tweakpane UI](https://kitschpatrol.com/svelte-tweakpane-ui) - UI elements from [Tweakpane](https://tweakpane.github.io/docs/) wrapped in a collection of idiomatic Svelte components.
- [svelte-tree-viewer](https://github.com/kpulkit29/svelte-tree-viewer) - A lightweight component to render tree views.
- [svelte-copyright](https://github.com/himynameisdave/svelte-copyright) - A Svelte component to format and display a copyright notice.
- [svelte-splitpanes](https://github.com/orefalo/svelte-splitpanes) - Full featured resizeable views panels.
- [mathjax-svelte](https://github.com/WoolDoughnut310/mathjax-svelte) - A Svelte component for MathJax.
- [svelte-stepper](https://github.com/efstajas/svelte-stepper) - A Svelte component for building animated step flows.
- [css-3d-progress](https://github.com/rofixro/css-3d-progress) - A 3D Progress Bar component
- [svelte-speedometer](https://github.com/palerdot/svelte-speedometer) - Svelte component for showing speedometer like gauge using d3.

## Scaffold

_Templates / boilerplate / starter kits / stack ensemble / Yeoman generator._

- [create-vite](https://github.com/vitejs/vite/tree/main/packages/create-vite#readme) - Generates scaffold for a vite + svelte app.
- [create-svelte](https://github.com/sveltejs/kit/tree/master/packages/create-svelte#readme) - A CLI for creating a new SvelteKit project.
- [saasstarter](https://github.com/CriticalMoments/CMSaasStarter) - A open source, fast, and free to host Svelte SaaS template.
- [svelte-pwa-template](https://github.com/tretapey/svelte-pwa) - A starter template for PWAs based in the official Template. _(pre-v5)_
- [vite-svelte-docker-template](https://github.com/bavragor/vite-svelte-docker-template) - Template for Svelte + Docker + Vite + Vitest.

## Utilities

### Animations

- [AutoAnimate](https://auto-animate.formkit.com/) - A zero-config, drop-in animation utility that adds smooth transitions to your Svelte app.
- [svelte-typewriter](https://github.com/henriquehbr/svelte-typewriter) - A simple and reusable typewriter effect for your Svelte applications.

### Drag & Drop

- [neodrag](https://github.com/PuruVJ/neodrag) - One Draggable to rule them all 💍.

### Forms

- [Superforms](https://superforms.rocks) - SvelteKit library for handling server and client validation, and client-side display of forms.
- [Formsnap](https://www.formsnap.dev/) - High level Svelte components for forms, built on top of Superforms and Zod.
- [felte](https://felte.dev/) - Extensible form library, with built-in Yup, Zod, Vest, and Superstruct validation.
- [vest](https://github.com/ealush/vest) - 🦺 Declarative form validation framework inspired by unit testing.
- [svelte-formly](https://github.com/arabdevelop/svelte-formly) - A good solution to generate and control a dynamic forms using core and custom rules with customize styles. _(pre-v5)_
- [svelte-form-builder](https://github.com/pragmatic-engineering/svelte-form-builder-community) - A No-code Drag n Drop Form Builder built for Svelte

#### Form Components

_Individual form components._

- [svelte-checkbox](https://github.com/HosseinShabani/svelte-checkbox) - A checkbox component (cool animation, customizable). _(pre-v5)_
- [svelte-toggle](https://github.com/beyonk-adventures/svelte-toggle) - Basic toggle component with styling. _(pre-v5)_

### HTTP Requests

- [sswr](https://github.com/ConsoleTVs/sswr) - Svelte stale while revalidate (SWR) data fetching strategy.
- [svelte-query](https://sveltequery.vercel.app/) - Fetch, cache and update data in your Svelte applications all without touching any "global state".

### Sound & Video

- [svelte-sound](https://github.com/Rajaniraiyn/svelte-sound) - Svelte Actions to play interaction sounds on target DOM events.

### WebGL

- [svelthree](https://github.com/vatro/svelthree) - Component library for declarative construction of reactive and reusable three.js scene graphs.
- [threlte](https://threlte.xyz) - Threlte is a renderer and component library for using Three.js in a declarative and state-driven way in Svelte apps.

### PWA

- [SvelteKit-Adapter-Versioned-Worker](https://github.com/hedgehog125/SvelteKit-Adapter-Versioned-Worker) - An easy-to-use service worker build plugin where you don't need to worry about cache durations.

### Portal

- [svelte-portal](https://github.com/romkor/svelte-portal) - Component for rendering outside the DOM of parent component.
- [svelte-teleport](https://github.com/nasso/svelte-teleport) - A component to teleport elements across the DOM.

### Fonts

- [svelte-web-fonts/google](https://github.com/svelte-web-fonts/google) - Tiny component for easily loading Fonts via the Google Fonts API including autocompletion.

### Internationalization

- [svelte-fluent](https://github.com/nubolab-ffwd/svelte-fluent) - Components for easy integration of [Fluent](https://projectfluent.org/) localization.
- [svelte-i18n](https://github.com/kaisermann/svelte-i18n) - Internationalization library for Svelte.
- [VoerkaI18n](https://zhangfisher.github.io/voerka-i18n/) - Internationalization solution for `Javascript/Typescript/Vue/React/Solidjs/SvelteJs/ReactNative`
- [sveltekit-i18n](https://github.com/jarda-svoboda/sveltekit-i18n) - For integrating [i18n](https://www.npmjs.com/package/i18n) style localization in SvelteKit.
- [@tolgee/svelte](https://github.com/tolgee/tolgee-js/tree/main/packages/svelte) - Web-based localization tool enabling users to translate directly in the Svelte app they develop.
- [@i18n-pro/svelte](https://github.com/i18n-pro/svelte) - Lightweight, simple, flexible, automatic translation internationalization tool for Svelte.
- [ParaglideJS](https://inlang.com/m/dxnzrydw/library-inlang-paraglideJsAdapterSvelteKit) - Tiny, typesafe i18n library with translated links out of the box.

## Routers

_For Single Page Applications (SPAs) and more._

- [svelte-router-spa](https://github.com/jorgegorka/svelte-router) - Router adds routing to your Single Page Applications (SPA). Includes localisation, guards and nested layouts.
- [svelte-routing](https://github.com/EmilTholin/svelte-routing) - A declarative Svelte routing library with SSR support.
- [tinro](https://github.com/AlexxNB/tinro) - A tiny, dependency free and highly declarative router.
- [svelte-spa-router](https://github.com/ItalyPaleAle/svelte-spa-router) - Optimized for Single Page Applications (SPA) with hash based routing and support for parameters.
- [svelte-client-router](https://github.com/arthurgermano/svelte-client-router) - Svelte Client Router is everything you need and think when routing SPA's.
- [@danielsharkov/svelte-router](https://github.com/DanielSharkov/svelte-router) - A simple & easy to use SPA router, developed with page transitions in mind.
- [@shaun/svelterouter](https://github.com/shaunlee/svelterouter) - Another vue-router inspired Svelte router.
- [Elegua](https://github.com/howesteve/elegua) - Small (< 180LoC), fast, easy, full featured SPA router
- [svelte5-router](https://github.com/mateothegreat/svelte5-router) - First Svelte 5 SPA router with nesting, hooks, and more.. Use components, snippets, or both!

## Frameworks

- [SvelteKit](https://svelte.dev/docs/kit/introduction) - The fastest way to build Svelte apps.
- [Routify](https://routify.dev/) - Routes for Svelte, automated by your file structure.
- [Elder.js](https://github.com/elderjs/elderjs) - Opinionated static site generator and web framework for Svelte built with SEO in mind. _(pre-v5)_
- [JungleJS](https://www.junglejs.org/) - The Jamstack framework for Svelte with GraphQL. _(pre-v5)_
- [svelte-document](https://github.com/mblouka/svelte-document) - Create documents (PDFs), resumes, or presentations entirely in Svelte.

## Dev Tools

### Lint

_Lint and format your code._

- [prettier-plugin-svelte](https://github.com/sveltejs/prettier-plugin-svelte) - Format your components using prettier.
- [svelte-check](https://www.npmjs.com/package/svelte-check) - Check your code.
- [eslint-plugin-svelte](https://github.com/sveltejs/eslint-plugin-svelte) - An ESLint plugin for Svelte using AST.

### Test

- [svelte-jester](https://github.com/mihar-22/svelte-jester) - A Jest transformer to compile your components before importing them into tests.
- [@testing-library/svelte](https://github.com/testing-library/svelte-testing-library) - Simple and complete Svelte DOM testing utilities that encourage good testing practices.
- [jest-transform-svelte](https://github.com/rspieker/jest-transform-svelte) - Jest Transformer for Svelte components.

### Editors

_Text editor plugins._

#### Visual Studio Code

- [Svelte for VS Code](https://marketplace.visualstudio.com/items?itemName=svelte.svelte-vscode) - Provides syntax highlighting and rich intellisense for your components.
- [Svelte 3 Snippets](https://marketplace.visualstudio.com/items?itemName=fivethree.vscode-svelte-snippets) - Svelte 3 Snippets for VS Code.

#### Sublime Text

- [Svelte](https://packagecontrol.io/packages/Svelte) - Syntax highlighting and support for Sublime Text.

#### Vim

- [vim-svelte-plugin](https://github.com/leafOfTree/vim-svelte-plugin) - Syntax highlighting and support for Vim.
- [coc-svelte](https://github.com/coc-extensions/coc-svelte) - Syntax highlighting and support for (Neo)Vim.

#### JetBrains

- [Svelte](https://plugins.jetbrains.com/plugin/12375-svelte) - Syntax highlighting and support for JetBrains.
