<div class="github-widget" data-repo="RichardLitt/awesome-styleguides"></div>
awesome-styleguides [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
===================

_：clipboard：一个styleguides_列表




## Contributing

 如果您使用过任何这些样式指针，请尽可能添加评论！  信息越多越好.  请看看 [contributing](https://github.com/RichardLitt/awesome-styleguides/blob/master/contributing.md)  文件.  谢谢！

## How to build a styleguide
* [A Maintainable Style Guide](http://ianfeather.co.uk/a-maintainable-style-guide/) - 孤独星球的Ian Feather，提倡风格指南驱动开发，这是非常时髦的.
* [Huge's Styleguide Tool](https://github.com/hugeinc/styleguide)   - 轻松创建和维护样式指南的工具.  看起来相当不错，有一些用例和GitHub上的重要跟随.
* [An In-Depth Overview Of Living Style Guide Tools](http://www.smashingmagazine.com/2015/04/an-in-depth-overview-of-living-style-guide-tools/) - 很好地了解那里的情况.


## Other Styleguide Lists
* [Brand Style Guides](https://saijogeorge.com/brand-style-guide-examples/)   - 一个漂亮的网站，列出了在哪里可以找到其他的风格.  由...维护 [@SaijoGeorge](https://twitter.com/SaijoGeorge).
* [Narkoz](https://github.com/narkoz/guides)
* [paulmillr](https://github.com/paulmillr/code-style-guides)
* [SalGnt](https://github.com/SalGnt/cscs)
* [Styleguides.io](https://github.com/maban/styleguides)
* [UI Styleguides](http://kevinwuhoo.github.io/ui-styleguides)

## Styleguides

## Generic
* [frontend-guidelines](https://github.com/bendc/frontend-guidelines)
* [isobar](https://isobar-idev.github.io/code-standards/)

## CSS
* [CSS Best Practices](https://github.com/sezgi/CSS-Best-Practices)
* [CSSWizardry](http://cssguidelin.es/)   - 这是最好的.  由一个为很多公司提供咨询的人制作，这个文档几乎设定了如何使用CSS的标准.  强烈建议.
* [GitHub](http://primercss.io)
* [Google](https://google.github.io/styleguide/htmlcssguide.xml)
* [Idiomatic-CSS](https://github.com/necolas/idiomatic-css)
* [rscss](https://github.com/rstacruz/rscss) -  CSS样式表结构的合理标准.
* [Smashing Magazine](http://www.smashingmagazine.com/2008/05/improving-code-readability-with-css-styleguides/)
* [Trello](https://gist.github.com/bobbygrace/9e961e8982f42eb91b80)
* [Wordpress.org](https://make.wordpress.org/core/handbook/best-practices/coding-standards/css/)

### Sass
* [CSS-Tricks](https://css-tricks.com/sass-style-guide/)
* [Sass Guidelines](http://sass-guidelin.es/)

## C++
* [Google](https://google.github.io/styleguide/cppguide.html)

## Shell Script
* [Google](https://google.github.io/styleguide/shell.xml)

## Git
* [agis-](https://github.com/agis-/git-style-guide)
* [Udacity](https://udacity.github.io/git-styleguide/) - 来自Udacity的Git Commit消息样式指南.

## HTML
* [Google](https://google.github.io/styleguide/htmlcssguide.xml)
* [THX](https://github.com/thx/html-code-guide) - 添加因为这是我见过的第一个有大量明星的中国风格指南.

## Java
* [Android](http://source.android.com/source/code-style.html)
* [Google](https://google.github.io/styleguide/javaguide.html)
* [Sun](http://javascript.crockford.com/javacodeconventions.pdf)

## JavaScript
* [Airbnb](https://github.com/airbnb/javascript)
* [bevacqua's JS sg](https://github.com/bevacqua/js)
* [feross/standard](https://github.com/feross/standard)
* [Google](https://google.github.io/styleguide/jsguide.html)
* [hapi](http://hapijs.com/styleguide)
* [Joyent](https://www.joyent.com/developers/node/design)
* [jscs](https://github.com/jscs-dev/node-jscs)
* [Khan](https://github.com/Khan/style-guides/blob/master/style/javascript.md)
* [Mozilla/pdf.js](https://github.com/mozilla/pdf.js/wiki/Style-Guide)
* [rsjs](https://github.com/rstacruz/rsjs) -  JavaScript结构的合理标准.

### AngularJS
* [gocardless](https://github.com/gocardless/angularjs-style-guide)
* [Google](https://google.github.io/styleguide/angularjs-google-style.html)
* [johnpapa's opinionated sg for  AngularJS](https://github.com/johnpapa/angular-styleguide)
* [mgechev's community best practices](https://github.com/mgechev/angularjs-style-guide)
* [srph's AngularJS structure sg](https://github.com/srph/angularjs-structure-styleguide)
* [Todd Motto's for AngularJS](https://github.com/toddmotto/angularjs-styleguide)
  * [jmcunningham's fork](https://github.com/jmcunningham/angularjs-styleguide)

### CoffeeScript
* [Polarmobile](https://github.com/polarmobile/coffeescript-style-guide)

### HTTP Design
* [http-api-design](https://github.com/interagent/http-api-design)
* [http-api-guide](https://github.com/bolasblack/http-api-guide) - 中国人

### JSON
* [Google](https://google.github.io/styleguide/jsoncstyleguide.xml)

### jQuery
* [Pragmatic jQuery](https://github.com/yuanyan/pragmatic-jquery)

### Modules
* [mattdesl](https://github.com/mattdesl/module-best-practices)

### npm
* [npm Style Guide](https://github.com/voorhoede/npm-style-guide#readme) - 由团队制定的最佳实践集合 [@deVoorhoede](https://twitter.com/devoorhoede).

### React
* [John Cobb](https://web-design-weekly.com/2015/01/29/opinionated-guide-react-js-best-practices-conventions/)
* [Khan](https://github.com/Khan/style-guides/blob/master/style/react.md)

### Riot
* [RiotJS Style Guide](https://github.com/voorhoede/riotjs-style-guide#readme) - 为团队提供意见的RiotJS风格指南 [@deVoorhoede](https://twitter.com/devoorhoede).

## Lisp
* [emacs-lips-style-guide](https://github.com/bbatsov/emacs-lisp-style-guide)

## Objective-C
* [Futurice iOS Good Practices](https://github.com/futurice/ios-good-practices) -  iOS入门指南和良好做法建议 [@futurice](https://github.com/futurice).
* [GitHub - Style guide & coding conventions for Swift projects](https://github.com/github/swift-style-guide) @github的Swift风格和约定指南.
* [GitHub Objective-C Style Guide](https://github.com/github/objective-c-style-guide) -  Objective-C项目的样式指南和编码约定.
* [Khan](https://github.com/Khan/objective-c-style-guide)
* [NY Times - Objective C Style Guide](https://github.com/NYTimes/objective-c-style-guide) - 纽约时报使用的Objective-C风格指南.
* [Objective-C Coding Convention and Best Practices](https://gist.github.com/soffes/812796) - 具有编码约定的要点.
* [raywenderlich Style Guide](https://github.com/raywenderlich/objective-c-style-guide) - 样式指南，概述了raywenderlich.com的编码约定.
* [Spotify Objective-C Coding Style](https://github.com/spotify/ios-style) -  Spotify使用的iOS开发指南.
* [Swift Style Guide by @raywenderlich](https://github.com/raywenderlich/swift-style-guide) -  raywenderlich.com的官方Swift风格指南.

## PHP
* [PSR-1: Basic Coding Standard](http://www.php-fig.org/psr/psr-1/)
* [PSR-2: Coding Style Guide](http://www.php-fig.org/psr/psr-2/)

## Python
* [Google](https://google.github.io/styleguide/pyguide.html)
* [PEP 8 Offical Style Guide for Python](https://pep8.org/)
* [PEP 257 - Docstring Conventions](http://legacy.python.org/dev/peps/pep-0257/)
* [The Hitchhiker's Guide to Python](http://docs.python-guide.org/en/latest/writing/style/)

## Ruby
* [Airbnb](https://github.com/airbnb/ruby)
* [bbatsov](https://github.com/bbatsov/ruby-style-guide)
* [GitHub](https://github.com/styleguide/ruby) - 基于bbatsov风格指南.

### Ruby on Rails
* [bbastov's Ruby on Rails 4 styleguide](https://github.com/bbatsov/rails-style-guide)

## Rust
* [aturon](https://aturon.github.io)

## Swift
* [Airbnb](https://github.com/airbnb/swift)
* [GitHub](https://github.com/github/swift-style-guide)
* [raywenderlich](https://github.com/raywenderlich/swift-style-guide)
* [SlideShareInc](https://github.com/SlideShareInc/swift-style-guide)

## Non-Code

* [BBC News Style Guide](https://www.bbc.co.uk/academy/en/collections/news-style-guide) - 所有BBC新闻输出指南涵盖拼写，标点符号和语法，以及准确性，公平性和公正性.
* [Bishop Fox Cybersecurity Style Guide](https://www.bishopfox.com/blog/2018/02/hello-world-introducing-the-bishop-fox-cybersecurity-style-guide/) - 从安全研究人员的恶意病毒到病毒模因.
* [BuzzFeed Style Guide](https://www.buzzfeed.com/emmyf/buzzfeed-style-guide) - 一套不断发展的互联网和社交媒体标准.
* [Guardian and Observer Style Guide](https://www.theguardian.com/info/series/guardian-and-observer-style-guide) - 记者编写，编辑和英语使用指南.
* [Wikipedia Manual of Style](https://en.wikipedia.org/wiki/Wikipedia%3aManual_of_Style) - 所有维基百科文章的样式手册.

## Historical

* [Xerox Publishing Standards](https://archive.org/details/xeroxpublishingstan00xero)   - 对商业世界的写作风格和设计的权威性参考.  由Xerox Corporation提供.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Richard Littauer](http://burntfen.com) 已放弃对此作品的所有版权及相关或相邻权利.
