<div class="github-widget" data-repo="lauthieb/awesome-storybook"></div>
## Awesome Storybook [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

[<img src="https://raw.githubusercontent.com/lauthieb/awesome-storybook/master/storybook-logo.svg?sanitize=true" align="right" width="80">](https://storybook.js.org)

> A curated list of awesome resources about Storybook's ecosystem :art:

[Storybook](https://storybook.js.org) is a frontend tool for building UI components faster and easier.

Contributions welcome. Add links through pull requests or create an issue to start a discussion.



## Official resources

- [Website](https://storybook.js.org)
- [Documentation](https://storybook.js.org/docs/basics/introduction/)
- [GitHub organization](https://github.com/storybookjs)
- [Use cases](https://storybook.js.org/use-cases/)
- [Team](https://storybook.js.org/team/)

## Community resources

- [Twitter](https://twitter.com/storybookjs)
- [Discord](https://discordapp.com/invite/UUt2PJb)
- [Medium](https://medium.com/storybookjs)
- [DEV.to](https://dev.to/t/storybook)
- [Brand's materials](https://github.com/storybookjs/brand) - Materials for your articles and talks about Storybook.
- [Design system](https://storybooks-official.netlify.com) - Storybook's website design system.
- [Storybook Deployer](https://github.com/storybookjs/storybook-deployer) - Package for deploying your storybook as a static site.
- [Documentation Primitives](https://github.com/DAN-AKL/storybook-documentation-primitives) - Custom DocBlocks for Storybook Docs.

## Tutorials

- [Learn Storybook](https://www.learnstorybook.com/) - A set of tutorials to learn Storybook.
- [Practical Guide to Storybook-Driven Development](https://dzone.com/articles/practical-guide-to-storybook-driven-development) - A tutorial on how to use the Storybook tool as a means of templating and driving forward your development efforts.
- [Adding Storybook Style Guide to a Create React App](https://www.youtube.com/watch?v=va-JzrmaiUM) - A tutorial on how to add Storybook in an application generated with Create React App.
- [Build your components with Storybook](https://www.youtube.com/watch?v=_jttw14T52o) - A tutorial on how to create your components and exposing them in a Storybook.
- [Storybook React with Full Dark Mode Integration](https://davidyeiser.com/tutorials/storybook-react-with-dark-mode) - A tutorial on how to integrate Storybook’s dark mode toggle with your React components.
- [Intro to Storybook with React [Tutorial & Example]](https://snipcart.com/blog/storybook-react-tutorial-example) - Learn how to build UI components in Storybook with React for better collaboration from design to implementation.

## Presentations

- [Storybook, le playground qu'il vous faut pour vos composants UI! (FR)](https://www.youtube.com/watch?v=zMpSwo03aKo)
- [React Storybook Tutorial with Examples - Getting Started with React Storybook](https://www.youtube.com/watch?v=E2c183LS4lA)
- [React Storybook: Design, Dev, Doc, Debug Components - React Conf 2017](https://www.youtube.com/watch?v=PF0Vi-iIyoo)
- [VueNYC - Learn Storybook](https://www.youtube.com/watch?v=XN398jfTwQI)

## Blog posts

- [How I manage to make my Storybook project the most efficient possible](https://dev.to/loicgoyet/how-i-manage-to-make-my-storybook-project-the-most-efficient-possible-2d8o) - A set of useful tips to help you manage a Storybook project.
- [Storybook 5.2](https://medium.com/storybookjs/storybook-5-2-794958b9b111) - World-class design systems infrastructure.
- [Storybook DocsPage](https://medium.com/storybookjs/storybook-docspage-e185bc3622bf) - Beautiful documentation, instantly.
- [Storybook Docs sneak peek](https://medium.com/storybookjs/storybook-docs-sneak-peak-5be78445094a) - Turning stories into living documentation.
- [Storybook 5.0](https://medium.com/storybookjs/storybook-5-0-db1d0f9c83b8) - A features' showcase about the biggest release to date.
- [Real-time accessibility testing with Storybook](https://medium.com/storybookjs/instant-accessibility-qa-linting-in-storybook-4a474b0f5347) - A comprehensive overview of the accessibility testing tools offered in Storybook.
- [Using Storybook with VueJS](https://auth0.com/blog/using-storybook-with-vuejs/) - Learn how to build a component library with Vue and Storybook to create modular and reusable components.
- [Setting up Storybook for Preact](https://www.iamdeveloper.com/posts/setting-up-storybook-for-preact-p5a/) - A handy guide allowing us to add storybook easily on a Preact project.
- [Setting up a Component Library with React and Storybook](https://auth0.com/blog/setting-up-a-component-library-with-react-and-storybook/) - Learn how to set up a component library with React and Storybook to create modular and reusable components that can be shared across projects.
- [Storybook - UI component development tool for React, Vue, and Angular (Article focusing on React)](https://dev.to/madhusudhansrinivas/storybook---ui-component-development-tool-for-react-vue-and-angular-article-focusing-on-react-29od) - A brief presentation of Storybook and how to setup on a React application.
- [Storybook vs Styleguidist](https://blog.hichroma.com/storybook-vs-styleguidist-2bd93d6dcc06) - A comparison of the top UI component explorers.
- [Five Reasons to Use Storybook Tests](https://spin.atomicobject.com/2017/11/20/storybook-tests-react/) - A complete walkthrough of different testing solutions for Storybook: Easy Cross-Browser Visual Checks, Interaction Testing and StoryShots for Snapshot Testing.

## Examples

- [Storybook Design System](https://storybooks-official.netlify.com)
- [Decathlon Design System (Vitamin)](https://decathlon.github.io/vitamin-web)
- [GitHub Design System](https://primer.github.io/storybook/)
- [Airbnb (react-dates)](https://airbnb.io/react-dates/)
- [Salesforce Design System](https://mashmatrix.github.io/react-lightning-design-system/)
- [Auth0 Design System](https://auth0-cosmos.now.sh/sandbox/)
- [AXA France Design System](https://axaguildev.github.io/react-toolkit/latest/storybook)
- [Shared React Components Boilerplate](https://github.com/shared-components/shared-react-components-example)
- [Apideck Components](https://www.apideck.design/)
- [Qui - Vue 2/3 Design system](https://github.com/Qvant-lab/qui-max)
- [Mística Design system](https://mistica-web.vercel.app/?path=/story/welcome-welcome--mistica)
- [Recharts](https://recharts.org/en-US/storybook)

## Addons

The official & community addons lists are available on the Storybook's [Addon Page](https://storybook.js.org/addons/).

## Contributing

Contributions welcome! Read the [contribution guidelines](https://github.com/lauthieb/awesome-storybook/blob/master/CONTRIBUTING.md) first.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Laurent Thiebault](https://lauthieb.github.io) has waived all copyright and related or neighboring rights to this work.
