<div class="github-widget" data-repo="shi-rudo/awesome-stock-trading"></div>
## Awesome Stock Trading [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

![Curated List of Awesome Stock Trading Resources](./src/assets/img/awesome-stock-trading-list-banner.png)

The curated list of resources for research and learning about stock trading and investing. It contains links to various resources and tools that can help anyone who wants to start or improve their stock trading skills. The project is open-source and welcomes [contributions](https://github.com/shi-rudo/awesome-stock-trading/blob/master/contributing.md) from anyone who wants to add or update the resources. The project aims to be a comprehensive and useful list for anyone interested in stock trading.


---

## Stock Research

- [Alpha Spread](https://alphaspread.com) - Provides data and tools for quantitative research and stock valuation.
- [Barchart](https://www.barchart.com) - Offers market data, analysis, and tools for commodity, stock, and forex traders.
- [Capitol Trade](https://www.capitoltrades.com) - Keeping Tabs on Politicians' Trades (US only).
- [Chartmill](https://chartmill.com) - ChartMill is a stock screening and analysis platform.
- [Danelfin](https://danelfin.com) - Provides AI-Powered Stock Research & Picking Tools.
- [Finbox](https://finbox.io/) - Offers tools for financial analysis, valuation, and screening of stocks.
- [Market Beat](https://www.marketbeat.com) - Provides stock research, ratings, and news for individual investors.
- [Market Screener](https://www.marketscreener.com) - Offers stock market quotes, news, analysis, and screening tools.
- [Morningstar](https://www.morningstar.com) - Provides investment research, ratings, and tools for stocks, mutual funds, and ETFs.
- [Seeking Alpha](https://seekingalpha.com) - Offers market news and analysis, portfolio management tools, and investment ideas from contributors.
- [Simply Wall St](https://simplywall.st/) - Simply Wall St. has a unique pictorial approach to quickly and effectively cut through the massive amounts of data to narrow to a select few candidates.
- [Strike.Market](https://strike.market) - Offers a platform for trading options and derivatives on cryptocurrency markets.
- [Tip Ranks](https://www.tipranks.com) - Provides ratings and analysis of stocks and financial experts based on their historical performance.
- [Wall Street Zen](https://www.wallstreetzen.com) - Offers tools for financial analysis, screening, and backtesting of investment strategies.
- [Wallmine](https://wallmine.com) - Provides stock analysis, screening, and news for individual investors.
- [Zacks](https://www.zacks.com) - Provides research, analysis, and ratings for stocks and funds based on quantitative models and fundamental data.

## Market Analysis
- [Companies Market Cap](https://www.companiesmarketcap.com) - Provides a list of companies and their market capitalizations, allowing users to easily track the valuations of various publicly traded companies. It also includes useful data such as industry classifications and stock exchange listings.
- [Fear & Greed Index](https://edition.cnn.com/markets/fear-and-greed) - Provides a market sentiment indicator for investors. It analyzes seven different indicators, including market volatility, investor sentiment, and safe-haven demand, to generate a score ranging from 0-100 that reflects whether the market is in a state of fear or greed.
- [Trading Terminal](https://www.tradingterminal.com) - Overview of the most important metrics for the US Market.
- [Tradytics](https://tradytics.com) - AI predictions, intraday market price action, biggest movers, sectors performance, and more.

## Stock Screener
- [Cnbc Stock Screener](https://www.cnbc.com/stock-screener/) - Stock screener for US stock market.
- [Finviz](https://finviz.com) - Free stock screener with financial visualizations.
- [Market Beat Stock Screener](https://www.marketbeat.com/stock-screener/) - US stock market screener that allows filtering stocks by market cap, sector, industry, and more.
- [Simply Wall St Stock Screener](https://simplywall.st/features/stock-screener) - Global stock screener that allows filtering stocks by market cap, sector, industry, and more.
- [Tip Ranks Stock Screener](https://www.tipranks.com/screener) - International stock market screener that allows filtering stocks by market cap, sector, industry, and more.
- [Trading Terminal Scanner](https://scanner.tradingterminal.com) - US market stock screener that allows filtering stocks by market cap, sector, industry, and more.
- [Wallmine Free Stock Screener](https://wallmine.com/screener) - Free stock screener that allows filtering stocks by market cap, sector, industry, and more.
- [Wallstreet Zen Stock Screener](https://www.wallstreetzen.com/stock-screener) - Free US stock market screener that allows filtering stocks by market cap, sector, industry, and more.
- [Zacks Stock Screener](https://www.zacks.com/stock-screener) - US stock market screener that allows filtering stocks by market cap, sector, industry, and more.

## Charting
- [TradingView](https://www.tradingview.com) - Platform that offers charting tools, trading ideas, and real-time market data for stocks, forex, cryptocurrencies, and other financial instruments.
- [StockCharts](https://stockcharts.com) - Technical analysis and charting website that provides advanced charting tools, custom indicators, and market analysis for stocks, funds, and indices.

## News
- [Barron's](https://www.barrons.com) - Financial magazine that provides news, analysis, and insights on the stock market, investing, and personal finance.
- [Benzinga](https://www.benzinga.com) - Financial news and data provider that delivers real-time market updates, stock analysis, and investment ideas.
- [Bloomberg](https://www.bloomberg.com) - Financial news and information company that covers business, markets, politics, and technology.
- [Investing](https://www.investing.com) - Online platform that offers financial news, real-time quotes, and analysis on stocks, currencies, commodities, and other investments.
- [MarketWatch](https://www.marketwatch.com) - Financial news website that provides business news, analysis, and stock market data.
- [The Motley Fool](https://www.fool.com) - Investment website that provides stock market analysis, investing ideas, and personal finance advice.
- [The Wall Street Journal](https://www.wsj.com) - A business-focused newspaper that covers global news, markets, and economics.
- [The Street](https://www.thestreet.com) - Financial news and investing website that offers stock market analysis, investment strategies, and personal finance advice.
- [Yahoo Finance](https://finance.yahoo.com) - Financial news and data website that provides real-time stock quotes, financial news, and investment analysis.

## Commentaries
- [J.P. Morgan - Market Updates](https://am.jpmorgan.com/us/en/asset-management/adv/insights/market-insights/market-updates/) - Weekly commentaries to get market insights from J.P. Morgan.

## Portfolio Tracker
- [Portfolio Visualizer](https://portfoliovisualizer.com) - Portfolio management and analysis tool that provides portfolio optimization, backtesting, and risk analysis.
- [Wealthica](https://www.wealthica.com) - Wealth management platform that provides portfolio management, financial planning, and investment research.

## Strategy Backtesting
- [Screening Tale](https://www.screeningtale.com) - Backtesting platform that allows users to test their trading strategies on historical data.
- [QuantConnect](https://www.quantconnect.com) - Algorithmic trading platform that provides backtesting, live trading, and research tools for stocks, forex, and cryptocurrencies.

## Stock Picks
- [Alpha Picks](https://seekingalpha.com/alpha-picks/) - Alpha Picks gives you two top stock picks each month, sifted from Seeking Alpha analysis of thousands of stocks.
- [Benzinga Pro](https://pro.benzinga.com) - Benzinga offers daily trade picks from professional day traders with on-demand support, as well as exclusive market-moving stories.
- [Best Stocks to Buy Now](https://www.investopedia.com/best-stocks-to-buy-now/) - Investopedia list of the best stocks to buy now.
- [EarningsBeats](https://www.earningsbeats.com) - EarningsBeats.com provides a research and educational platform for investors. Services are designed to help their members beat the S&P 500.
- [Investing Groups by Seeking Alpha](https://seekingalpha.com/groups) - Investing groups on Seeking Alpha that provide stock picks, analysis, and market insights.
- [The Motley Fool Stock Advisor](https://www.fool.com/services/) - Stock Advisor is a premium service that provides stock picks, analysis, and market insights.

## Stock Collections
- [Growth 250](https://marketsmith.investors.com/growth250/) - MarketSmith's Growth 250 is a curated list of high-potential stocks.
- [StockTwits Top 10](https://stocktwits.com/rankings/trending) - StockTwits' list of the top 10 trending stocks.

## Stock APIs
- [Alpha Vantage](https://www.alphavantage.co/) - Alpha Vantage offers free APIs for realtime and historical stock data, forex, and cryptocurrency data.
- [Eodhistoricaldata](https://eodhistoricaldata.com) - Eodhistoricaldata offers APIs for realtime and historical stock data, forex, and cryptocurrency data.
- [MarketStack](https://marketstack.com) - MarketStack offers APIs for realtime and historical stock data, forex, and cryptocurrency data.
- [Morningstar](https://developer.morningstar.com) - Provides data, research, and reports.
- [Nasdaq Data Link](https://data.nasdaq.com) - Nasdaq Data Link offers a premier source for financial, economic and alternative datasets.
- [Polygon](https://polygon.io/) - Polygon offers APIs for realtime and historical stock data, forex, and cryptocurrency data.
- [Refinitiv Eikon Data](https://www.refinitiv.com/en/products/eikon-trading-software/eikon-app-api-innovation/eikon-data-api) - The Eikon Data API allows applications to access data directly from Eikon or Refinitv Workspace.


## Knowledge
- [Investopedia](https://www.investopedia.com) - Investopedia.com is a website that provides educational content, news, analysis, and tools related to investing, finance, and business.
- [StockScreening101](https://www.stockscreening101.com) - StockScreening101 is a website that provides educational content, news, analysis, and tools related to investing, finance, and business.
- [Wallstreetmojo](https://www.wallstreetmojo.com) - Learn Investment Banking, Finance Modeling and Excel with more than 4800+ Articles, Self Study Guides, Resources and courses.

## Books

#### Value Investing and Fundamental Analysis

- [Berkshire Hathaway Letters to Shareholders](https://www.goodreads.com/book/show/22393486-berkshire-hathaway-letters-to-shareholders) - Warren Buffett, 2016 </br>
For nearly six decades, Warren Buffett has written an annual letter to his shareholders. The letters, written between 1965 and 2014, reveal the investor's thoughts on investment strategy, share buybacks, corporate culture and much more.

- [Common Stocks and Uncommon Profits](https://www.goodreads.com/book/show/25586616-common-stocks-and-uncommon-profits-and-other-writings-paperback-jan-0) - Philip A. Fisher, 1957 </br>
This book is considered a classic and is used as part of several investment courses, such as Stanford Graduate School of Business. In the book, Fisher explains his basic views and approach to his investment strategies.

- [Damodaran on Valuation: Security Analysis for Investment and Corporate Finance](https://www.goodreads.com/book/show/21841022-damodaran-on-valuation) - Aswath Damodaran, 1994 </br>
Damodaran explains aspect of valuation, from the basics of estimating cash flows and discount rates to the principles for using multiples.

- [Margin of Safety: Risk-Averse Value Investing Strategies for the Thoughtful Investor](https://www.goodreads.com/book/show/746936.Margin_of_Safety) - Seth Klarman, 1991 </br>
Margin of Safety explains the key fundamentals and practices of value investing. He outlines what value investing looks like and where investors might find attractive opportunities.

- [Security Analysis](https://en.wikipedia.org/wiki/Security_Analysis_(book)) - Benjamin Graham, 1934 </br> 
This book laid the intellectual foundation for what would later be called value investing. The first edition was published in 1934, shortly after the Wall Street crash and start of the Great Depression.

- [The Alchemy of Finance](https://www.goodreads.com/book/show/369708.The_Alchemy_of_Finance) - George Soros, 1987 </br>
This book offers insight into the decision-making process of one of the most successful wealth managers, George Soros.

- [The Dhandho Investor: The Low-Risk Value Method to High Returns](https://www.goodreads.com/book/show/500514.The_Dhandho_Investor) - Mohnish Pabrai, 2007 </br>
Written by Mohnish Pabrai, an investor of Indian origin, the book explains his value investing approach using the Dhandho capital allocation framework.

- [The Intelligent Investor](https://en.wikipedia.org/wiki/The_Intelligent_Investor) - Benjamin Graham, 1949 </br>
In this book, Grahame explains his investment principles and views regarding an investor's mindset. He shows how investors analyze the actual performance of companies and advises to disregard the changing moods of the market.

- [The Little Book of Value Investing](https://www.goodreads.com/book/show/75893.The_Little_Book_of_Value_Investing) - Christopher H. Browne, 2006 </br>
Brown explains the basic approaches of the value investing philosophy, but without making any big promises about market success. He provides guidance on the use of simple metrics such as the price-earnings ratio.

- [The Most Important Thing](https://www.goodreads.com/book/show/41211699-the-most-important-thing) - Howard Marks, 2011 </br>
In this book, Howard Marks summarizes investment insights from his client memos and explains his investment philosophy.

- [The Thoughtful Investor](https://www.goodreads.com/book/show/21949163-the-thoughtful-investor) - Basant Maheshwari, 2011 </br>
Maheshwari, a renowned Indian investor, explains in his book topics of financial analysis, the analysis of individual sectors and the behavioral aspect of investing.

- [The Warren Buffett Way](https://www.goodreads.com/book/show/209956.The_Warren_Buffett_Way) - Robert G. Hagstrom, 2007 </br>
The book describes the business and investment principles of value investing according to Warren Buffett.

- [Value Investing: From Graham to Buffett and Beyond](https://www.goodreads.com/book/show/293636.Value_Investing) - Bruce C. N. Greenwald, 2004 </br>
Greenwald explains the basic techniques of value investing and, in this context, illustrates their application using profiles of successful investors.

#### Quantitative Investing and Portfolio Management
- [Active Portfolio Management](https://www.goodreads.com/book/show/537529.Active_Portfolio_Management) - Richard C. Grinold, Ronald Kahn, 1994 </br>
In this book, Grinold and Kahn show how economics, econometrics, and operations research can be used to solve practical investment problems and identify profit opportunities.

- [Portfolio Selection: Efficient Diversification of Investments](https://www.goodreads.com/book/show/2825008-portfolio-selection) - Harry M. Markowitz, 1968 </br>
A comprehensive explanation of analysis and calculation methods to help investors find the best combinations of securities to match their requirements.

- [Quantitative Equity Portfolio Management](https://www.goodreads.com/book/show/264468.Quantitative_Equity_Portfolio_Management) - Ludwig B. Chincarini, Daehwan Kim, 2006 </br>
The authors address the construction and management of a portfolio using quantitative methods. Among other things, they offer explanations of factor models and the prediction of premiums and exposures.

#### General Stock Trading
- [Beating the Street](https://www.goodreads.com/book/show/891835.Beating_the_Street) - Peter Lynch, 1992 </br>
In the book, Lynch, a successful fund manager from 1977 to 1990, gives readers insight into his investment methods and tactics.

- [Charlie Munger: The Complete Investor](https://www.goodreads.com/book/show/34889127-charlie-munger) - Tren Griffin, 2015 </br>
Tren Griffin uses interviews, writings, and letters to explain the investment philosophy and thought processes of Charlie Munger, vice chairman of Berkshire Hathaway and longtime business partner of Warren Buffett.

- [Market Wizards: Interviews with Top Traders](https://www.goodreads.com/book/show/966769.Market_Wizards) - Jack D. Schwager, 1989 </br>
By interviewing successful investors such as Bruce Kovner, Richard Dennis, Paul Tudor Jones, Michel Steinhardt, Ed Seykota, Marty Schwartz, Tom Baldwin, and others, Schwager explores what separates the world's best traders from the vast majority of unsuccessful investors.

- [One Up On Wall Street](https://www.goodreads.com/book/show/762462.One_Up_On_Wall_Street) - Peter Lynch, 1989 </br>
Peter Lynch, who managed Fidelity Investment's successful Magellan Fund from 1977 to 1990, gives investors an insight into his investment methods. Using simple examples and some practices, he explains his process of stock selection.

- [Stocks for the Long Run](https://www.goodreads.com/book/show/965633.Stocks_for_the_Long_Run_) - Jeremy Siegel, 1994 </br>
The book by Siegel, a finance professor, addresses how to build a balanced portfolio and explains how investors can avoid typical mistakes.

- [The Battle for Investment Survival](https://www.goodreads.com/book/show/350675.The_Battle_for_Investment_Survival_) - Gerald M. Loeb, 1911 </br>
Now more than 100 years old, Gerald M. Loeb's work is considered a classic of financial literature. In his explanations, Loeb straightforwardly explains how investors should behave in rising and falling markets.

- [The Complete Turtle Trader](https://www.goodreads.com/book/show/33026972-the-complete-turtle-trader) - Michael W. Covel, 2007 </br>
The author tells the story of Richard Dennis, an extraordinarily successful stock market trader of the 1980s, and how he turned a group of beginners, under his guidance, into extraordinarily successful traders.

- [The Craft of Investing](https://www.goodreads.com/book/show/128947547-the-craft-of-investing-by-john-train) - John Train, 1994 </br>
In the book, Train outlines his key strategies and principles that have brought him success, addressing everything from the psychology of the market to practical portfolio management tips.

- [The Little Book of Trading](https://www.goodreads.com/book/show/16235023-the-little-book-of-trading) - Michael W. Covel, 2011 </br>
Michael W. Covel's book offers insights into the rules and philosophies used by successful traders. Drawing on the author's own trading experience and the wisdom of other traders, the book offers advice in a direct and easy-to-understand manner.

- [The Little Book that Still Beats the Market](https://www.goodreads.com/book/show/8247775-the-little-book-that-still-beats-the-market) - Joel Greenblatt, 2007 </br>
Joel Greenblatt explains how investors can outperform the popular market averages by systematically applying a formula. The book is kept simple and is aimed at beginners. 

- [The New Market Wizards](https://www.goodreads.com/book/show/27224350-new-market-wizards) - Jack D. Schwager, 1992 </br>
Jack Schwager interviews some of the most successful stock traders in the United States. Through these interviews, Schwager offers insight into the strategies, perspectives, and psychological insights of successful traders.

- [Think & Trade Like a Champion](https://www.goodreads.com/book/show/34943907-think-trade-like-a-champion) - Mark Minervini, 2017 </br>
In this book, Mark Minervini explains readers how to apply his methods step by step to enhance their trading performance and create the confidence they need to outperform.

#### Trend Following
- [Investing with Volume Analysis](https://www.goodreads.com/book/show/12664470-investing-with-volume-analysis) - Buff Dormeier, 2011 </br>
  Dormeier offers insights into using volume metrics to enhance stock trading strategies, providing a framework for interpreting price-volume relationships to predict market trends.

- [Learn to Trade Momentum Stocks](https://www.goodreads.com/book/show/25740068-learn-to-trade-momentum-stocks) - Matthew R. Kratter, 2015 </br>
This beginner-friendly book presents a trading strategy by Matthew R. Kratter. It is designed to give readers the knowledge and skills to make profitable trades in momentum stocks.

- [Stocks on the Move](https://www.goodreads.com/book/show/25819574-stocks-on-the-move) - Andreas Clenow, 2015 </br>
In this book, Clenow, a hedge fund manager, explores why most mutual funds consistently underperform and shows how anyone can outperform them. He emphasizes the power of momentum investing as one of the few consistent ways to beat the markets.

- [Trading the Trends](https://www.goodreads.com/book/show/20428445-trading-the-trends) - L. A. Little, 2011 </br>
The book covers various aspects, including identifying trends, using technical indicators, and managing risk. The content is written in an easy-to-understand style, providing readers with valuable insights into understanding and profiting from the stock market.

- [Trend Following](https://www.goodreads.com/book/show/34855405-trend-following) - Michael W. Covel, 2004 </br>
Michael W. Covel's book explains trend following without explicitly addressing specific strategies and provides insights on how to use trend following in market situations, whether bull or bear markets.

- [Trend Qualification and Trading](https://www.goodreads.com/book/show/18969247-trend-qualification-and-trading) - L. A. Little, 2011 </br>
Through a proven technical approach, the book explains how to gauge the likelihood of trend continuation and its potential for better trading results. Readers will gain understanding on timing entries, taking profits, and effectively exiting trades based on these trends.

- [Trend Trading Set-Ups](https://www.goodreads.com/book/show/19569996-trend-trading-set-ups) - L. A. Little, 2012 </br>
Building on the neoclassical concept, Little presents traders and investors with a robust methodology to discover promising trade setups and achieve precise timing for trade entry.

#### Price Action Trading
- [Price Action Breakdown](https://www.goodreads.com/book/show/29460388-price-action-breakdown) - Laurentiu Damir, 2016 </br>
This book provides a comprehensive guide to trading pure price action analysis. It covers concepts, ideas and trading methods based on pure price action and can be applied to various financial markets.

- [Price Action Trading Secrets](https://www.goodreads.com/book/show/55854507-price-action-trading-secrets) - Rayner Teo, 2020 </br>
Rayner Teo's book is intended as a guide to the use of price action trading. The book covers trading strategies, instruments and techniques and is written in a simple, step-by-step manner.

- [Pring on Price Patterns](https://www.goodreads.com/book/show/19138622-pring-on-price-patterns) - Martin J. Pring, 2009 </br>
Martin J. Pring's book provides a comprehensive examination of the most commonly used price patterns and offers insights into their effectiveness and logic. The book covers a range of patterns, including one- and two-bar patterns, outside bars, reversals, pennants, and more.

- [Stock Trading & Investing Using Volume Price Analysis](https://www.goodreads.com/book/show/38296614-stock-trading-investing-using-volume-price-analysis) - Anna Coulling, 2015 </br>
Anna Coulling provides an in-depth examination of volume price analysis in stock trading. In doing so, she examines the approaches of other successful price analysis practitioners and explains them with examples.

- [Trading Price Action Trends](https://www.goodreads.com/book/show/19169498-trading-price-action-trends) - Al Brooks, 2011 </br>
Al Brooks' book is intended as a practical guide to profiting from institutional trading trends.  The book breaks down Brooks' trading system into its essential components such as institutional piggybacking or trend trading.

#### Behavioral Finance and Psychological Aspect of Investing
- [Irrational Exuberance](https://www.goodreads.com/book/show/100132.Irrational_Exuberance) - Robert J. Shiller, 2000 </br>
Robert J. Shiller's book addresses the psychological and behavioral factors that influence financial markets. It explores the concept of speculative bubbles and irrational exuberance, in which exuberant investor behavior leads to overvaluation of assets.

- [The Little Book of Behavioral Investing: How not to be your own worst enemy](https://www.goodreads.com/book/show/6922765-the-little-book-of-behavioral-investing) - James Montier, 2010 </br>
Author James Montier looks at the psychological aspects of investing and examines common behavioral biases that can hinder investors' success in the marketplace.

- [The Wisdom of Crowds](https://www.goodreads.com/book/show/68143.The_Wisdom_of_Crowds) - James Surowiecki, 2004 </br>
James Surowiecki's book addresses the concept that large groups of people collectively have higher intelligence than individual experts. Surowiecki supports his argument with various case studies and anecdotes from different fields.


#### Risk and Uncertainty
- [Against the Gods](https://www.goodreads.com/book/show/128429.Against_the_Gods) - Peter L. Bernstein, 1996 </br>
Bernstein takes the reader on a journey through time, showing how societies throughout history have dealt with uncertainty and developed methods for measuring and managing risk. The author shows the profound impact of risk and probability on human decision making and the development of modern finance.

- [Fooled by Randomness](https://en.wikipedia.org/wiki/Fooled_by_Randomness) - Nassim Nicholas Taleb, 2001 </br>
Part of Taleb's multi-volume philosophical essay on uncertainty, this book examines various misconceptions of chance, including survival bias and skewed distributions, and illuminates how people tend to seek explanations even when there are none.

- [The 5 Mistakes Every Investor Makes and How to Avoid Them](https://www.goodreads.com/book/show/20914691-the-5-mistakes-every-investor-makes-and-how-to-avoid-them) - Peter Mallouk, 2014 </br>
Mallouk's work discusses the most common mistakes investors make and how to avoid them. Among the most important lessons are the pitfalls of market timing and active trading, which are suboptimal compared to passive strategies.

- [The Black Swan](https://en.wikipedia.org/wiki/The_Black_Swan:_The_Impact_of_the_Highly_Improbable) - Nassim Nicholas Taleb, 2007 </br>
Taleb explores the concept of so-called black swans. These are rare and unpredictable events that have massive consequences and are often rationalized retroactively.

#### Contemporary History
- [Dot.con: How America Lost Its Mind and Money in the Internet Era](https://www.goodreads.com/book/show/1308591.Dot_con) - John Cassidy, 2002 </br>
Cassidy chronicles the rise and fall of the dot-com bubble with insight and flair. He introduces the key players and events that shaped the Internet era, from visionary entrepreneurs to ruthless investors.


## Most Important Stock Exchanges

- 🇺🇸 [New York Stock Exchange (NYSE)](https://www.nyse.com) - Largest stock exchange in the world by market capitalization, with over 2,800 listed companies.
- 🇺🇸 [NASDAQ](https://www.nasdaq.com) - Second largest stock exchange in the world by market capitalization, known for listing technology companies and having a high trading volume.
- 🇯🇵 [Tokyo Stock Exchange (TSE)](https://www.jpx.co.jp/english/) - Third largest stock exchange in the world by market capitalization, and the largest in Asia.
- 🇨🇳 [Shanghai Stock Exchange (SSE)](https://www.sse.com.cn/) - Fourth largest stock exchange in the world by market capitalization, and the largest in mainland China.
- 🇭🇰 [Hong Kong Stock Exchange (HKEX)](https://www.hkex.com.hk/) - One of the largest stock exchanges in Asia, known for attracting international investors due to its strategic location and listing rules.
- 🇬🇧 [London Stock Exchange (LSE)](https://www.londonstockexchange.com) - One of the oldest and most important stock exchanges in the world, with over 3,000 listed companies.
- 🇪🇺 [Euronext](https://www.euronext.com/en) - A pan-European stock exchange operating in several countries, including France, the Netherlands, Belgium, Portugal, and Ireland.
- 🇩🇪 [Frankfurt Stock Exchange (XETRA)](https://www.deutsche-boerse.com) - The largest stock exchange in Germany owned and operated by Deutsche Börse. 
