<div class="github-widget" data-repo="airscripts/awesome-steam-deck"></div>
## Awesome Steam Deck [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)
<h3 align="center">
  <a href="https://ghio.airscript.it/awesome-steam-deck/" target="_blank" rel="noopener noreferrer">
    <img src="https://raw.githubusercontent.com/airscripts/awesome-steam-deck/main/assets/images/steam-deck-logo.svg" width="64" alt="Logo"/><br/>
  </a>
</h3>

> A curated list of awesome Steam Deck software, resources and more.  

[Steam Deck](https://en.wikipedia.org/wiki/Steam_Deck) is a handheld gaming computer made by Valve.

Contributions and suggestions about how to improve this project are welcome!  
Please follow [our contribution guidelines](https://github.com/airscripts/awesome-steam-deck/blob/main/CONTRIBUTING.md).

If you want to support my work you can do it following me, leaving a star, sharing my projects or also donating at the links below.  
Choose what you find more suitable for you:  

<a href="https://sponsor.airscript.it" target="_blank" rel="noopener noreferrer">
  <img src="https://raw.githubusercontent.com/airscripts/assets/main/images/github-sponsors.svg" alt="GitHub Sponsors" width="30px" />
</a>&nbsp;
<a href="https://kofi.airscript.it" target="_blank" rel="noopener noreferrer">
  <img src="https://raw.githubusercontent.com/airscripts/assets/main/images/kofi.svg" alt="Kofi" width="30px" />
</a>


## Guide
- [SSD Replacement](https://www.ifixit.com/Guide/Steam+Deck+SSD+Replacement/148989) - How to replace your SSD.
- [Install EmuDeck](https://www.emudeck.com/#how_to_install) - How to install EmuDeck.
- [Install Windows](https://www.howtogeek.com/877293/how-to-install-windows-on-your-steam-deck/) - How to install Windows.
- [Install Windows On microSD](https://wagnerstechtalk.com/sd-windows/) - How to install Windows on microSD.
- [Install ProtonGE](https://steamdeckhq.com/tips-and-guides/the-proton-ge-steam-deck-guide/) - How to install ProtonGE.
- [Install Chiaki](https://pimylifeup.com/steam-deck-ps5-remote-play/) - How to setup Chiaki.
- [Use Xbox Cloud Gaming](https://support.microsoft.com/en-us/topic/xbox-cloud-gaming-in-microsoft-edge-with-steam-deck-43dd011b-0ce8-4810-8302-965be6d53296) - How to use Xbox Cloud Gaming.
- [Install NonSteamLaunchers](https://steamdeckhq.com/tips-and-guides/install-3rd-party-launchers-on-steam-deck/) - How to install NonSteamLaunchers.
- [Activate SFTP](https://www.youtube.com/watch?v=Cb1U0_KbtLQ) - How to transfer files from PC to Steam Deck with SFTP.
- [Install ProtonDB Badges Plugin](https://steamdecklife.com/2022/10/18/protondb-badges-steam-deck-plugin/) - How to install ProtonDB Badges Plugin which gives you games compatibility rating from the ProtonDB website.

## Hardware
- [Sabrent Rocket 2230 SSD](https://www.amazon.com/SABRENT-Rocket-2230-Performance-SB-2130-1TB/dp/B0BQG6JCRP/) - Suggested SSD made by Sabrent.
- [SanDisk Extreme microSD](https://www.amazon.com/SanDisk-Extreme-microSDXC-Memory-Adapter/dp/B09X7MPX8L/) - Suggested microSD made by SanDisk.
- [Steam Deck Refurbished](https://store.steampowered.com/sale/steamdeckrefurbished) - Certified Refurbished Steam Deck.

## Accessory
- [Spigen Rugged Armor Protective Case](https://www.amazon.com/Protective-Shock-Absorption-Anti-Scratch-Accessories-nintendo-switch/dp/B0B75N73N9/) - Suggested protective case made by Spigen.
- [Maglass Screen Protector](https://www.amazon.com/Magglass-Tempered-Designed-Protector-Anti-Glare/dp/B09X82S4XL/) - Suggested screen protector made by Maglass.
- [JSAUX Cooling Fans](https://jsaux.com/products/fan-cooler-for-steam-deck-gp0200) - Cooling fans for reducing overall temperatures made by JSAUX.
- [NexDock](https://nexdock.com/features/) - Turn Steam Deck into a laptop.
- [Killswitch](https://dbrand.com/killswitch) - Protective case made by dbrand for Steam Deck.
- [Carrying Case](https://jsaux.com/products/upgraded-carrying-case-for-steam-deck-bg0106) - Protective case for Steam Deck for accessories, chargers and cables.
- [Standing Case](https://jsaux.com/products/upgraded-protective-standing-case-for-steam-deck-pc0105) - Protective Standing Case for Steam Deck.
- [Silicon Case](https://jsaux.com/products/steam-deck-protective-case) - Silicon Protective Case for Steam Deck.
- [6-in-1 Docking Station](https://jsaux.com/products/upgraded-docking-station-for-steam-deck) - JSAUX 6-in-1 Docking Station for Steam Deck.
- [Steam Deck Dock](https://store.steampowered.com/steamdeckdock) - Steam Deck Docking Station by Valve.
- [iVoler Dock](https://www.ivoler.com/products/upgraded-docking-station-for-steam-deck) - iVoler 6in-1 Docking Station for Steam Deck.
- [Syntech Dock](https://syntechhome.com/products/syntech-docking-station-compatible-with-steam-deck) - Syntech 6-in-1 Docking Station for Steam Deck.
- [UGREEN Dock](https://eu.ugreen.com/collections/docking-station/products/copy-of-snap-deal-ugreen-docking-station-for-steam-deck) - UGREEN Docking Station for Steam Deck.
- [Extreme Rate Shells](https://extremerate.com/collections/steam-deck-shells) - Extreme Rate Steam Deck Shells.
- [GamingCobra Shells](https://www.gamingcobra.com/collections/steam-deck-shells) - Gaming Cobra Steam Deck Shells.
- [JSAUX Transparent Back Plate](https://jsaux.com/products/transparent-back-plate-for-steam-deck-pc0106) - JSAUX Transparent Back Plate for Steam Deck.
- [Corsair K70 Pro Mini](https://www.amazon.com/dp/B0B4SW81GW/) - 60% wireless mechanical keyboard.
- [Razer Viper V2 Pro](https://www.amazon.com/dp/B09VCR969M) - Premium gaming mouse with great set of features.
- [8BitDo Wireless 2.4g Controller](https://www.amazon.com/dp/B0B9BR6H7N/) - Great controller for those who want a console-like gaming experience.
- [HyperX Cloud II Wireless](https://www.amazon.com/dp/B00SAYCXWG/) - Value-for-money wireless headset for your Steam Deck.
- [Razer Hammerhead (2021)](https://www.amazon.com/dp/B099LZ2BGB/) - Wireless earbuds for your Steam Deck.
- [Acer Nitro XV272U Vbmiiprx 27" Monitor](https://www.amazon.com/dp/B09R26XXFW/) - 27-inch WQHD gaming monitor from Asus.
- [ViewSonic VX1755](https://www.amazon.com/dp/B09CQJ39YS/) - Large-screen gaming experience with this portable gaming monitor from ViewSonic.
- [Anker 7-in-1 USB-C Hub](https://www.amazon.com/dp/B07ZVKTP53) - 7-in-1 USB-C hub from Anker is a great alternative to a dedicated Steam Deck dock.
- [Spigen Rugged Armor Case](https://www.amazon.com/dp/B0B75N73N9) - Protect your shiny-new Steam Deck from scratches and drops.
- [Spigen Tempered Glass](https://www.amazon.com/dp/B0BGQSZJTG) - Spigen's Tempered Glass Screen Protector for Steam Deck.
- [Anker PowerCore](https://www.amazon.com/dp/B09VPHVT2Z) - Anker 737 PowerCore portable charger with 24,000mAh battery and offers 140W output.
- [Deckmate Detachable Kickstand System](https://www.amazon.com/dp/B0BV8N5JS2) - Mount Anything to your Steam Deck.

## Software
- [Distrobox](https://github.com/89luca89/distrobox) - Use any Linux distribution inside your terminal.
- [rwfus](https://github.com/ValShaped/rwfus) - Read and write OverlayFS for Steam Deck.
- [BoilR](https://github.com/PhilipK/BoilR) - Synchronize non-Steam games with your Steam library.
- [Steam ROM Manager](https://github.com/SteamGridDB/steam-rom-manager) - An app for managing ROMs in Steam.
- [Discord Overlay](https://trigg.github.io/Discover/deckaddnonsteamgame) - Discord Overlay for Steam.
- [SteamOS Btrfs](https://gitlab.com/popsulfr/steamos-btrfs) - Convert the /home partition from ext4 to btrfs.
- [ProtonUp-Qt](https://davidotek.github.io/protonup-qt/) - Install and manage third-party compatibility tools for Steam Games.
- [Clover](https://github.com/ryanrudolfoba/SteamDeck-Clover-dualboot) - Graphical boot manager for the Steam Deck.
- [Steam Deck Printing Rootless](https://github.com/Tymose/Steam-Deck-Printing-ROOTLESS) - Utility that lets you print on the Steam Deck rootlessly and that survives updates as well.

## Emulation
- [EmuDeck](https://github.com/dragoonDorise/EmuDeck) - Emulator configurator.
- [RetroArch](https://github.com/libretro/RetroArch) - Frontend for emulators, game engines and media players.
- [RetroDECK](https://github.com/XargonWan/RetroDECK) - All-in-one sandboxed application to play your retro games.
- [EmulationStation DE](https://gitlab.com/es-de/emulationstation-de) - Frontend for browsing and launching games from various collections.
- [PCSX2](https://github.com/PCSX2/pcsx2) - PS2 Emulator.
- [RPCS3](https://github.com/RPCS3/rpcs3) - PS3 Emulator.
- [PPSSPP](https://github.com/hrydgard/ppsspp) - PSP Emulator.
- [Vita3K](https://github.com/Vita3K/Vita3K) - PS Vita Emulator.
- [bsnes](https://github.com/bsnes-emu/bsnes) - SNES Emulator.
- [Dolphin](https://github.com/dolphin-emu/dolphin) - Gamecube/Wii Emulator.
- [DeSmuME](https://github.com/TASEmulators/desmume) - Nintendo DS Emulator.
- [Ryujinx](https://github.com/Ryujinx/Ryujinx) - Nintendo Switch Emulator.
- [xemu](https://github.com/xemu-project/xemu) - Xbox Emulator.

## Launcher
- [Lutris](https://lutris.net/) - Open gaming platform.
- [Heroic](https://heroicgameslauncher.com/) - Epic Games and GOG launcher.
- [Bottles](https://github.com/bottlesdevs/Bottles) - Run Windows software and games under Linux.
- [NonSteamLaunchers](https://github.com/moraroy/NonSteamLaunchers-On-Steam-Deck) - Automatic installation of the most popular launchers.

## Remote
- [Chiaki](https://git.sr.ht/~thestr4ng3r/chiaki) - Free and open source software client for PlayStation 4 and PlayStation 5 Remote Play.
- [KDE Connect](https://github.com/KDE/kdeconnect-kde) - Multi-platform app that allows your devices to communicate.
- [LocalSend](https://github.com/localsend/localsend) - Open source app to share files between devices over your local network.
- [Steam Link](https://store.steampowered.com/app/353380/Steam_Link/) - Extend your Steam gaming experience to more devices.
- [Greenlight](https://github.com/unknownskl/greenlight) - An open source client for streaming Xbox Cloud and Xbox Home.

## File Management
- [Deck Drive Manager](https://deckdrivemanager.com/) - Copy PC games from PC to Steam Deck drives.
- [Syncthing](https://github.com/syncthing/syncthing) - Open source continuous file synchronization.
- [OpenCloudSaves](https://github.com/DavidDeSimone/OpenCloudSaves) - A tool used for syncing your save games across your devices.

## Utility
- [Shortix](https://github.com/Jannomag/shortix) - A script that creates human readable symlinks for Proton game prefixes.
- [Cryoutilities](https://github.com/CryoByte33/steam-deck-utilities) - Scripts and utilities to improve performance and manage storage.
- [Steam Deck Shader Cache Killer](https://github.com/scawp/Steam-Deck.Shader-Cache-Killer) - Script to purge Steam Deck shader cache.
- [Ludusavi](https://github.com/mtkennerly/ludusavi) - Backup tool for PC game saves.

## Plugin
- [Decky Loader](https://github.com/SteamDeckHomebrew/decky-loader) - Plugin launcher.
- [Deckbrew Plugins](https://plugins.deckbrew.xyz) - List of Deckbrew plugins.
- [MagicPods](https://magicpods.app/steamdeck) - A magic plugin for Decky Loader that lets you control your AirPods and Beats headphones in a comfortable way.

## Website
- [Steam Deck](https://www.steamdeck.com/) - Official Steam Deck website.
- [Great On Deck](https://store.steampowered.com/steamdeck/mygames) - A list of verified Steam Deck games.
- [CheckMyDeck](https://checkmydeck.ofdgn.com/) - Check compatibility with Steam Deck of your games library.
- [Deck Verified](https://www.steamdeck.com/en/verified) - Steam games compatible with Steam Deck by Valve.
- [Repair Steam Deck](https://www.ifixit.com/Device/Steam_Deck) - Repair, disassembly, and troubleshooting information for the Steam Deck.
- [Steam Deck Web App Generator](https://steam-deck-web-app-generator.vercel.app/) - Create shortcut scripts for your favorite websites to game mode.

## Community
- [r/SteamDeck](https://reddit.com/r/SteamDeck) - Official subreddit.
- [r/EmuDeck](https://www.reddit.com/r/EmuDeck) - Subreddit of EmuDeck, emulators on Steam Deck.
- [r/WindowsOnDeck](https://www.reddit.com/r/WindowsOnDeck/) - Subreddit for Windows users on Steam Deck.
- [Steam Deck Italia](https://t.me/SteamDeckIta) - Telegram italian community.
- [Steam Deck Espana](https://t.me/SteamDeckPortatil) - Telegram spanish community.
- [Steam Deck Group](https://t.me/steamdecktalk) - Telegram chinese community.
- [Steam Deck Чат](https://t.me/steamdeckschat) - Telegram russian community.
- [protondb.com](https://protondb.com) - Official ProtonDB site with games reviews and compatibility lists.
- [Steam Deck Community](https://steamdeck.community/) - An independent community.
- [Steam Deck Discord](https://discord.com/channels/865611969661632521/) - A Discord community.
- [Steam Deck Italia](https://www.facebook.com/groups/340493584341055/) - Facebook italian group.
- [Steam Deck](https://www.facebook.com/groups/steamdeck/) - Facebook english group.

## Blog
- [Steam Deck Life](https://steamdecklife.com/) - A blog about Steam Deck.
- [Steam Deck HQ](https://steamdeckhq.com/) - A blog focused on Steam Deck Games but not only games, everything deck related.

## Podcast
- [On Deck](https://open.spotify.com/show/5oH7NqKxSPiVFANLuYgDSn) - A podcast on Spotify by Nerdnest.
- [Decked Up](https://open.spotify.com/show/4ZW6yNxludK6FZQwvQlfJX) - A podcast on Spotify by Mekel Kasanova.
- [Fan The Deck](https://open.spotify.com/show/74eIOxJhDmmSZFbwlh7HIN) - A podcast on Spotify by Richard Alvarez.
