<div class="github-widget" data-repo="agarrharr/awesome-static-website-services"></div>
## Awesome Static Website Services [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

> A curated list of services for static websites.

Inspired by the [awesome](https://github.com/sindresorhus/awesome) list thing.



---

## Audio

- [SoundCloud](https://soundcloud.com/) - Audio hosting with an embeddable player. Up to 3 hours of content is free.
- [Mixcloud](https://www.mixcloud.com/) - Audio hosting with unlimited uploads and an embeddable player.
- [Spotify](https://www.spotify.com/) - You can embed any song, album, or playlist with a [Spotify Play Button](https://developer.spotify.com/documentation/widgets/guides/adding-a-spotify-embed/).

## Books

- [Google Books](https://github.com/aharris88/google-bookshelves-widget) - Allows you to display the books in your Google Books Library.
- [Goodreads API and widgets](https://www.goodreads.com/api) - Allows you to access any of the Goodreads data. Widgets are found on the widgets tab on your [settings page](https://www.goodreads.com/user/edit).
- [Open Library Open API](https://openlibrary.org/developers/api) — Allows to retrieve book data from the biggest books open dataset on Earth, without any tracking.

## Calendar and Scheduling

- [Google Calendar](http://calendar.google.com/) - Embeddable calendar that you can collaborate with other people.
- [Booking.js](http://booking.timekit.io/) - Beautiful embeddable booking widget.
- [zenplanner](http://zenplanner.com/) - Paid - Online scheduling for fitness.

## Images

- [Flickr](https://www.flickr.com/) - Online photo hosting by Yahoo.
- [Cloudinary](https://cloudinary.com/) - Image hosting, manipulation and delivery.

## Maps

- [Google Maps](http://maps.google.com/) - Google maps are easily embeddable.
- [Mapbox](https://www.mapbox.com/) - Really nice looking embeddable maps.
- [uMap](https://umap.openstreetmap.fr/en/) - Create and embed personalized maps, based on the great [OpenStreetMap](https://openstreetmap.org) dataset.

## Presentations

- [Prezi](https://prezi.com/) - Online presentations with really transitions that can zoom and rotate.
- [Reveal.js](http://lab.hakim.se/reveal-js/) - HTML presentation framework.
- [Slides.com](http://slides.com/) - A place for creating, presenting and sharing slide decks.
- [SpeakerDeck](https://speakerdeck.com/) - Upload your slides as a PDF, and get an online, shareable presentation.

## Video

- [Mux](https://mux.com/) - Paid - An API to play videos directly to the client. Can also power live streams.
- [YouTube](https://www.youtube.com/) - Embeddable videos with unlimited uploads.
- [Vimeo](https://vimeo.com/) - Paid - Embeddable videos with no ads.
- [Vevo](http://www.vevo.com/) - Embeddable music videos.
- [Wistia](http://wistia.com/) - Free plan has a limit of 25 videos.

### Code

- [Codepen](http://codepen.io/) - A playground of embeddable front-end code examples.
- [JS Bin](http://jsbin.com/) - Embeddable front-end code examples.
- [JSFiddle](http://jsfiddle.net/) - Embeddable front-end code examples.
- [highlight.js](https://highlightjs.org/) - Syntax highlighting for the web.
- [Indiepen](https://indiepen.tech/) - A privacy-friendly solution to embed front-end code examples.

## Functions as a Service

- [1Backend](https://github.com/1backend/1backend) - Deploy your backend in seconds. Free tier included. Open source.
- [AWS Lambda](https://aws.amazon.com/lambda/) - AWS Lambda lets you run code without provisioning or managing servers. You pay only for the compute time you consume
- [Google Cloud Functions](https://cloud.google.com/functions/) - Create single-purpose, stand-alone functions that respond to Cloud events without the need to manage a server or runtime environment
- [Webtask by Auth0](https://webtask.io/) - Call code on the server with simple HTTP, easier to set up by far than Lambda or Google's
- [Azure Functions](https://azure.microsoft.com/en-us/services/functions/) - by Microsoft - same premise as Lambda on the Azure cloud
- [IronWorkers](https://www.iron.io/platform/ironworker/) - by Iron.io - Run code in a multilanguage containerized environment with unlimited scale and simple pricing
- [IronFunctions](http://open.iron.io/) - by Iron.io - IronFunctions is an open source serverless computing platform for any cloud - private, public, or hybrid.
- [OpenWhisk by IBM](https://console.ng.bluemix.net/openwhisk/) - part of their BlueMix hosting platform, and open source, ties into their Watson AI ecosystem nicely
- [StackPath EdgeEngine](https://www.stackpath.com/products/edgeengine/) - Write functions as a service in the language of your choice and deploy them to a global network of data centers. All the networking, including intelligent routing and load balancing, is managed by StackPath over a private backbone.
- [Cloud 66](https://www.cloud66.com/) - Build and deploy static websites to your own cloud account. 
- [Vercel](https://vercel.com/home#features) - Vercel lets people write functions as a service in their language of choice and deploy as part of a monorepo.
- [Azure Static Web Apps](https://azure.microsoft.com/en-us/services/app-service/static/#features) - Full-stack static app hosting including serverless Functions, authentication, CDN and more
- [Qoddi](https://qoddi.com) - Full stack app hosting with data storage included, similar to Heroku with a developer centric approach. Free to use up to 3 apps.
- [Autocode](https://autocode.com) - Autocode turns functions into scalable web services in an instant, no configuration required; serverless hosting available with an in-browser IDE, an API library that’s easy to use, and seamlessly managed authentication.

## GraphQL

- [FaunaDB](https://fauna.com) - Serverless GraphQL database. Free tier with no time limit. Easily included in Netlify apps.

## Community

### Comments

- [Staticman](https://github.com/eduardoboucas/staticman) - Staticman is a Node.js application that receives user-generated content and uploads it as data files to a GitHub repository. In practice, this allows you to have dynamic content (e.g. blog post comments) as part of a fully static website, as long as your site automatically deploys on every push to GitHub, as seen on GitHub Pages, Netlify and others.
- [Disqus](https://disqus.com/) - Easily embeddable comments with nested replies, multiple login methods, and email notifications.
- [Facebook Comments](https://developers.facebook.com/docs/plugins/comments) - Embeddable comments for your site by Facebook.
- [IntenseDebate Comments](http://www.intensedebate.com/) - Embeddable comments with nested replies, multiple login methods, and email notifications.
- [LiveFyre](http://web.livefyre.com/apps/comments/) - Real-time comments, SEO-optimized, stocked with social features, and beautiful on both desktop and mobile.
- [Redditjs Embed Widget](http://embed.redditjs.com/) - Embed Reddit comments on your site. If it hasn't been posted, it will show a link to encourage the user to submit.
- [Muut.com](https://muut.com/) - Embeddable comments, forum and private messaging. A lot of functionality, but really low footprint left on your website.
- [Gitment](https://github.com/imsun/gitment) - Comment system based on GitHub Issues, which can be used in the frontend without any server-side implementation.
- [giscus](https://github.com/laymonage/giscus) - A comments widget built on GitHub Discussions.
- [utterances](https://github.com/utterance) - A lightweight comments widget built on GitHub issues. 

### Forms

#### Really Simple Forms

- [Formspree](http://formspree.io/) - Receive emails from a form on your static website.
- [elFormo](https://www.elformo.com/) - Simple form processing and response retrieval via email.
- [Flipmail](http://flipmail.co/) - Simple form processing and response retrieval via email.
- [MailThis](http://mailthis.to/) - Simple form submissions via email with optional attachments.
- [Simple Form](https://getsimpleform.com/) - Simple forms with optional file attachments, email notifications, and online submission viewing.
- [Brisk Forms](https://github.com/stevensona/briskforms) - Free form submission service emails you responses while keeping your email address private and is open source.
- [99 Inbound](https://www.99inbound.com) - Form endpoint service with email/Slack notifications and third party app integrations (e.g. MailChimp)
- [Getform](http://getform.io/) - Form backend platform for designers and developers, with email and integrations.
- [HeyForm](https://heyform.net/) - Free, easy-to-use drag & drop form maker capable of crafting powerful online forms. Includes 40+ field types, integrations, analytics, and more.
- [Form.taxi](https://form.taxi/) - Backend to handle form submissions easily and reliably, with email notifications, file uploads and GDPR-compliant data processing.

#### Normal Forms

- [Formcarry](https://formcarry.com) - Hassle-free HTML form endpoints for your form, powerful dashboard, reliable spam blocking, attachment uploads and Zapier integrations.
- [Formcake](https://formcake.com) - The form backend built for developers: Zapier integrations, simple endpoint API, unlimited forms.
- [Google Forms](https://www.google.com/forms/about/) - Saves results into Google Sheets and can email you when there is a submission.
- [FormKeep](https://formkeep.com/) - Paid - View form submissions in a beautiful web interface. It has spam filtering and it integrates with webhooks such as Gmail, Trello, and Basecamp.
- [123 Contact Form](http://www.123contactform.com/) - Connects to other online services such at MailChimp, Salesforce, and Google Drive. It also integrates with payment Processers and includes security and analytics.
- [FormAssembly](http://www.formassembly.com/) - Allows you to build any kind of form that can include complex branching logic and multiple pages.
- [FormSite](https://www.formsite.com/) - Form builder with payments and form management.
- [FormStack](https://www.formstack.com/) - Forms with A/B testing, partial submission, analytics, and integrations.
- [Sheetsu](https://sheetsu.com/) - POST and GET your data to Google Spreadsheet.
- [Typeform](http://www.typeform.com/) - Awesome forms that can be embedded.
- [Wufoo](http://www.wufoo.com/) - Free or Paid - Forms that you can build with a form designer, with notifications, reports, and payments.
- [Zoho](https://www.zoho.com/crm/help/web-forms/set-up-web-forms.html) - Forms with file upload and captcha.
- [GitHub Issues](https://help.github.com/articles/about-issues/) - This is an interesting way for developers to get comments/questions. See [github.com/sindresorhus/ama](https://github.com/sindresorhus/ama) for an example.
- [Utterences](https://github.com/utterance/utterances) - A lightweight comments widget built on GitHub issues.
- [FormBackend](https://www.formbackend.com) - Create form-backends and submit your HTML forms to our backend. View the entries online and connect to other services. Receive an email every time a new entry is submitted.
- [Pageclip](https://pageclip.co) - A flexible server / backend for HTML forms. View your data in the realtime web interface, or use the API to get CSV and JSON output.
- [Formester](https://www.formester.com) - Forms and email marketing (lead collection, email campaigns, and newsletters) with integrations.
- [StaticKit](https://statickit.com) - Modern forms for static sites, with native support for React.
- [SheetDB](https://sheetdb.io/) - Turn a Google Spreadsheet into a JSON API.
- [Form2Channel](https://form2channel.com/) - Post your HTML form to Form2Channel to store submissions in Google Sheets and receive them via email, Slack or Telegram. No signups, no costs, no limits.
- [reCAPTCHAme](https://recaptchame.com/) - reCAPTCHA and hCAPTCHA token verification service. Post your form to reCAPTCHAme to avoid getting spammed. Made for static websites, no server-side coding required.

#### Provided by the Host

- [Netlify](https://www.netlify.com/docs/form-handling/) - Netlify comes with built-in form handling.

### Live Chat

- [jivochat](https://www.jivochat.com/) - JivoSite is a professional live chat for websites that was specifically designed to increase your online sales.
- [LiveChat](https://www.livechatinc.com/) - Live chat on your website.
- [Olark](https://www.olark.com/) - Live chat on your website. You can also see who's on your website and what they're doing.
- [SnapEngage](https://snapengage.com/) - Live chat with integrations and custom styles.
- [tawk.co](https://www.tawk.to/) - Lets you monitor and chat with visitors on your website.
- [WebsiteAlive](https://www.websitealive.com/) - Live chat for your website & social networks.
- [Zopim](https://www.zopim.com/) - Live chat with free trial.
- [Tiledesk](https://tiledesk.com) - Free Live Chat with open source chatbot builder. 

### Newsletters

- [MailChimp](http://mailchimp.com/) - Free email marketing. You can pay to add more features.
- [Constant Contact](http://www.constantcontact.com/) - Email marketing with campaigns, autoresponders, and analytics.
- [AWeber](http://www.aweber.com/) - Email marketing with campaigns, autoresponders, and analytics.
- [Campaign Monitor](https://www.campaignmonitor.com/) - Email marketing with campaigns, autoresponders, and analytics.
- [MailerLite](https://www.mailerlite.com/) - Free email marketing. You can pay for more subscribers.

### Social Media

- [Pinterest](https://developers.pinterest.com/) - Pin It Button.
- [Twitter](https://dev.twitter.com/web/embedded-tweets) - Embedded tweets.
- [Facebook](https://developers.facebook.com/docs/plugins) - Facebook embedded plugins.
- [ShareThis](http://www.sharethis.com/) - Sharing buttons for multiple social networks.
- [Kontaktify](https://www.kontaktify.com/) - A contact widget that provides an easy way for visitors to get in touch.

### Surveys

- [Google Forms](https://www.google.co.nz/forms/about/) - You can use Google forms for surveys or for forms on your site.
- [SurveyMonkey](https://www.surveymonkey.com/) - Easy to use and free surveys.
- [Typeform](http://www.typeform.com/) - Really beautiful forms.
- [Qualaroo](https://qualaroo.com/) - Embed surveys anywhere on your website that comes up from the bottom right side of the screen.
- [Insight Stash](https://insightstash.com/) - Fast, Simple survey forms.

## E-Commerce

- [Ecwid](https://www.ecwid.com/) - Embeddable shopping cart.
- [FoxyCart](http://www.foxycart.com/) - Add a shopping cart with basic html code.
- [Snipcart](https://snipcart.com/) - Include a few lines of code for a full online shop.
- [Gumroad](https://gumroad.com/) - An all-in-one solution to sell your work.
- [Payhip](https://payhip.com/) - An embeddable way to sell digital downloads & memberships
- [Moltin](https://moltin.com/) - Add eCommerce functionality to anything.
- [Trolley](https://trolley.link/) - Add a popup cart to any website - designed for static & JAMstack sites.
- [Commerce Layer](https://commercelayer.io/) - Add enterprise ecommerce to your JAMstack.

## Payments

 - [MoneyButton](https://www.moneybutton.com/) - Website payments and donations using Bitcoin (Satoshi's Vision).
 - [ShapeShift Shifty Button](https://info.shapeshift.io/tools/shifty-button) - Accept payments using various cryptocurrencies.

## Search

Self-hosted:

- [lunr.js](http://lunrjs.com/) - Simple full-text search in your browser.
- [itemsjs](https://github.com/itemsapi/itemsjs) - Full text, faceted, almost dependency free search engine in javascript
- [minisearch](https://github.com/lucaong/minisearch) - Tiny and powerful JavaScript full-text search engine for browser and Node
- [flexsearch](https://github.com/nextapps-de/flexsearch) - Next-Generation full text search library for Browser and Node.js
- [fuse.js](https://fusejs.io/) - Powerful, lightweight fuzzy-search library, with zero dependencies
- [static-search](https://github.com/dchest/static-search) - A Go program to generate JSON index of HTML files, and a JavaScript component with optional UI to search this index
- [elasticlunr](http://elasticlunr.com/docs/index.html) - Lightweight full-text search engine developed in JavaScript for browser search and offline search based on Lunr.js
- [tinysearch](https://github.com/tinysearch/tinysearch) - Tiny, full-text search engine for static websites built with Rust and Wasm
- [js-search](https://www.npmjs.com/package/js-search) - Client-side searches of JavaScript and JSON objects, ES5 compatible and does not require jQuery or any other third-party libraries
- [search-index](https://github.com/fergiemcdowall/search-index) - A persistent, network resilient, full text search library for the browser and Node.js
- [fuzzysearch](https://github.com/bevacqua/fuzzysearch) - Tiny and blazing-fast fuzzy search in JavaScript
- [fuzzy](https://github.com/mattyork/fuzzy) - Fuzzy search / filter for browser and node
- [fullproof](https://reyesr.github.io/fullproof/) - Javascript library that provides high-quality full-text search in the browser
- [Jets.js](https://jets.js.org/) - Native CSS search engine
- [Hulipaa](https://github.com/sambuccid/hulipaa) - Static full-text search engine capable of handling thousands of pages with a minimalist searchbar UI to add to your static website.

Third party integration:

- [Google Custom Search Engine](https://cse.google.com/cse/) - Search your site with a custom Google Search.
- [Algolia](https://www.algolia.com/) - Hosted Search API that delivers instant and relevant results from the first keystroke.
- [CloudSh](https://cloudsh.com/) - Powerful search for your website with a few lines of JavaScript.

## Analytics

- [Google Analytics](http://www.google.com/analytics/) - Freemium web analytics service offered by Google.
- [Simple Analytics](https://simpleanalytics.io/) - 💲 - Simple, clean, and friendly analytics.

## Authentication

- [Uthentic](https://uthentic.net) - Serverless, passwordless login for static sites in 2 lines of code.

## Other

- [Sketch Fab](https://sketchfab.com/) - Embeddable 3D content.

## Related Lists

- [Awesome Static Hosting](https://github.com/b-long/awesome-static-hosting)
- [Awesome Azure Static Web Apps](https://github.com/staticwebdev/awesome-azure-static-web-apps)

----

## License

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Adam Garrett-Harris](https://twitter.com/agarrharr) has waived all copyright and related or neighboring rights to this work.
