<div class="github-widget" data-repo="standard/awesome-standard"></div>
## Awesome Standard [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[![js-standard-style](https://cdn.rawgit.com/feross/standard/master/badge.svg)](https://github.com/feross/standard)

记录包的爆炸 [`standard`](https://github.com/feross/standard) 生态系统！

## standard

- **[standard](https://www.npmjs.com/package/standard) ** - JavaScript 标准样式. 一种风格来统治他们！

## usage stats

- **[npm packages that use standard (full list)](https://github.com/feross/standard-packages/blob/master/all.json)** - 使用 `standard` 的包列表
- **[download graphs of standard (npm-stat.com)](http://npm-stat.com/charts.html?package=standard&author=&from=&to=)** - npm 注册表下载计数
- **[top npm packages (gist)](https://gist.github.com/feross/e0882df2fe673d6ce064)** - standard 是 npm 上的顶级软件包之一

## packages used by standard

- **[eslint](https://www.npmjs.com/package/eslint)** - 基于 AST 的 JavaScript 模式检查器
- **[standard-engine](https://www.npmjs.com/package/standard-engine) ** - 标准的内容，提取到可重复使用的包中. 建立你自己的！
- **[eslint-config-standard](https://www.npmjs.com/package/eslint-config-standard)** - 标准 eslint 规则，作为可共享的配置
- **[eslint-config-standard-jsx](https://www.npmjs.com/package/eslint-config-standard-jsx)** - JSX 的标准 eslint 规则
- **[eslint-plugin-standard](https://www.npmjs.com/package/eslint-plugin-standard)** - 标准自定义 eslint 规则（不是 eslint 核心的一部分）

## automatic code formatters

- `standard --fix` - 自动格式化内置于 `standard`！
- **[prettier-standard](https://www.npmjs.com/package/prettier-standard)** - 格式为 [prettier](https://github.com/prettier/prettier) 配置为标准规则
- **["unix commands" gist](https://gist.github.com/watson/453fc63cace521fcdadc)** - 搜索和替换 unix 命令的列表，以帮助使节点存储库符合“标准”

## editor plugins

 - 每个主要的文本编辑器都有一个插件或对“标准”的内置支持. 见 [full list](https://github.com/standard/standard#are-there-text-editor-plugins) 支持的编辑器.
- 原子：**[linter-js-standard](https://atom.io/packages/linter-js-standard)** - 棉绒
- 原子：**[linter-js-standard-engine](https://atom.io/packages/linter-js-standard-engine)** - 棉绒
- 原子：**[standard-formatter](https://atom.io/packages/standard-formatter)** - 自动修复器
- 原子：**[standardjs-snippets](https://atom.io/packages/standardjs-snippets)** - 代码片段
- 括号：**[brackets-standard](https://github.com/ishamf/brackets-standard/)** - 棉绒
- Emacs：见 [readme](https://github.com/standard/standard#emacs)
- 崇高的文字：**[SublimeLinter-contrib-standard](https://packagecontrol.io/packages/SublimeLinter-contrib-standard)** - 棉绒
- 崇高的文字：**[StandardFormat](https://packagecontrol.io/packages/StandardFormat)** - 自动修复器
- 视觉工作室代码：**[vscode-standard](https://marketplace.visualstudio.com/items?itemName=standard.vscode-standard)** - linter 和自动修复程序
- Vim: 看 [readme](https://github.com/standard/standard#vim)
- 视觉工作室代码：**[vscode-standardjs-snippets](https://marketplace.visualstudio.com/items?itemName=capaj.vscode-standardjs-snippets)** - 代码片段
- 视觉工作室代码：**[vscode-react-standard](https://marketplace.visualstudio.com/items?itemName=TimonVS.ReactSnippetsStandard)** - 代码片段
 - WebStorm（PhpStorm、IntelliJ、RubyMine、JetBrains 等）：内置支持. 看 [readme](https://github.com/standard/standard#webstorm-phpstorm-intellij-rubymine-jetbrains-etc)

## pretty terminal output (reporters)

- **[snazzy](https://www.npmjs.com/package/snazzy)** - 将 JavaScript 标准样式格式化为时尚（即时髦）输出
- **[standard-tap](https://www.npmjs.com/package/standard-tap)** - 将 JavaScript 标准样式格式化为 TAP 输出
- **[standard-json](https://www.npmjs.com/package/standard-json)** - 将 JavaScript 标准样式输出格式化为 JSON 数组
- **[standard-reporter](https://www.npmjs.com/package/standard-reporter)** - 通过 unix 管道的 feross/standard 报告器，许多选项
- **[standard-summary](https://www.npmjs.com/package/standard-summary)** - 将输出显示为错误列表，按计数排序

## build tools

- **[grunt-standard](https://www.npmjs.com/package/grunt-standard)** - 标准的 Grunt 插件
- **[gulp-standard](https://www.npmjs.com/package/gulp-standard)** - 标准的 Gulp 插件
- **[mocha-standard](https://www.npmjs.com/package/mocha-standard)** - 将标准集成到您的摩卡测试中
- **[standard-loader](https://www.npmjs.com/package/standard-loader)** - Lint webpack 使用标准构建
- **[docker-standard](https://hub.docker.com/r/geniousphp/standard-js/) ** - Standardjs Docker 图像可以轻松快速地检查和报告 javascript 文件. 在基于 Docker 的构建系统中非常有用.
- **[rollup-plugin-standard](https://www.npmjs.com/package/rollup-plugin-standard)** - 使用标准的 Lint Rollup 构建

## code/project generators

- **[generator-babel-standard](https://www.npmjs.com/package/generator-babel-standard)** - 带有 babel 和 standard 的新包的 Yeoman 生成器
- **[generate-swap-project](https://www.npmjs.com/package/generate-swap-project)** - 在几秒钟内生成您的 ESNext+StandardJS+Mocha Ready NodeJS 项目！
- **[generate-swap-generator](https://www.npmjs.com/package/generate-swap-generator)** 在几秒钟内生成您自己的 ESNext+StandardJS+Mocha Ready NodeJS 生成器！

## inspired by `standard`

- **[standard-markdown](https://www.npmjs.com/package/standard-markdown)** - Lint 标记文件中的所有 javascript 代码块
- **[stylelint-config-standard](https://www.npmjs.com/package/stylelint-config-standard)** - stylelint 的标准可共享配置.
- **[standard-sass](https://www.npmjs.com/package/standard-sass) ** - Sass &amp; Scss &amp; Css 标准样式. 一种风格来统治他们！
- **[wemake-frontend-styleguide](https://github.com/wemake-services/wemake-frontend-styleguide) ** - 基于标准工具的 JavaScript &amp; TypeScript &amp; Vue &amp; JsDoc &amp; Scss 风格指南. 非常严格！

## forks

- **[semistandard](https://www.npmjs.com/package/semistandard)** - 标准，带分号
- **[uber-standard](https://www.npmjs.com/package/uber-standard)** - 叉子 [Uber](https://www.uber.com/) 团队
- **[videojs-standard](https://www.npmjs.com/package/videojs-standard)** - 叉子 [video.js](https://github.com/videojs/video.js) 团队
- **[yodlr-standard](https://www.npmjs.com/package/yodlr-standard)** - 叉子 [yodlr](https://getyodlr.com/home) 团队
- **[happiness](https://www.npmjs.com/package/happiness)** - 为让@JedWatson 开心而定制的标准
- **[doublestandard](https://www.npmjs.com/package/doublestandard)** - 标准，分号更多
- **[xo](https://www.npmjs.com/package/xo)** - “JavaScript 幸福风格”
- **[jsw](https://www.npmjs.com/package/jsw)** - “规范不关心分号，你也不应该”
- **[obama](https://www.npmjs.com/package/obama)** - 向前迈进并与奥巴马一起标准化
- **[aStandard](https://npmjs.com/package/a-standard)** - 为 babel 和 es7 制定的更严格的标准
- **[standard-own](https://npmjs.com/package/standard-own)** - 标准，但有更多的定制和个人规则.
- **[standard-focus](https://www.npmjs.com/package/standard-focus)** - 一次关注一个错误.
- **[standa](https://www.npmjs.com/package/standa)** 没有 JSX 规则的标准.

欢迎 PR！

## License

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Feross Aboukhadijeh](http://feross.org) 已放弃该作品的所有版权和相关或邻接权.
