<div class="github-widget" data-repo="dav009/awesome-spanish-nlp"></div>
## Awesome Linguistics Resources for Spanish [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)


Curated list of Linguistic Resources for doing Spanish NLP & CL.

## Clustering
- [Multilingual Latent Dirichlet Allocation LDA](https://github.com/ArtificiAI/Multilingual-Latent-Dirichlet-Allocation-LDA)

## Speech

- [Mexican Spanish Speech Recognition DB - 150 Speakers](http://www.speechocean.com/en-ASR-Corpora/631.html)
- [Mexican Spanish Speech Recognition DB - 299 Speakers](http://www.speechocean.com/en-ASR-Corpora/603.html)
- [Phonetic Transcriptions of Spanish Pronunciation Lexicon](http://www.speechocean.com/en-Text-Corpora/692.html)
- [Sphinx Speech Recognition Models](http://www.speech.cs.cmu.edu/sphinx/models/hub4spanish_itesm/)

## Part of Speech Taggers (POS Taggers)
- [TreeTagger - POSTagger](http://www.cis.uni-muenchen.de/~schmid/tools/TreeTagger/)
- [Stanford - POSTagger](http://nlp.stanford.edu/software/tagger.shtml)
- [Freeling](http://nlp.lsi.upc.edu/freeling/)
- [ixa-pipe-pos](https://github.com/ixa-ehu/ixa-pipe-pos)
- [Ruby Snowball Implementation](https://github.com/MaG21/estem)
- [Spaguetti POSTagger(Based on NLTK +  CESS corpus](https://code.google.com/p/spaghetti-tagger/)

## Multiword Expressions  Extractors (MLWE)
- [Freeling](http://nlp.lsi.upc.edu/freeling/)

## Name Entity Recognition (NER)
- [OpenNLP - Person/Place/Organization models](http://opennlp.sourceforge.net/models-1.5/)
- [DBPedia Spotlight](https://github.com/dbpedia-spotlight/dbpedia-spotlight/)
- [CitiusTagger - Spanish NER and  POSTagger](http://gramatica.usc.es/pln/tools/CitiusTools.html)

## Corpora

### Shared tasks
- [Exploiting Parallel Texts for Statistical  Machine Translation -  NAACL 2006 in New York City](http://www.statmt.org/wmt06/shared-task/)
- [CoNLL-2009 Shared Task: Syntactic and Semantic Dependencies in Multiple Languages](http://ufal.mff.cuni.cz/conll2009-st/trial-data.html)
- [Quality Estimation (Spanish - English) WMT13](http://www.quest.dcs.shef.ac.uk/wmt13_qe.html)
- [ ACL 2010 in Uppsala - Shared Task: Machine Translation for European Languages](http://www.statmt.org/wmt10/translation-task.html)
- [TASS - 2014 (Sentiment Analysis focused on Spanish)](http://www.daedalus.es/TASS2014/tass2014.php)
- [SemEval-2 2010 Coreference Resolution in Multiple Languages](http://semeval2.fbk.eu/semeval2.php?location=tasks)
- [SAB Corpus (Spanish Corpus for Sentiment Analysis towards Brands)](http://sabcorpus.linkeddata.es/)

### Corpora
- [Multilingual Aligned Annotated Corpus (CRATER)](http://catalog.elra.info/product_info.php?products_id=636)
- [UAM Treebank - 1,500 syntactically annotated sentences extracted from newspapers (El País Digital and Compra Maestra](http://elvira.lllf.uam.es/~sandoval/UAMTreebank.html)
- [POSTagged/syntactic dependencies - European Corpus Initiative Multilingual Corpus I ](http://www.elsnet.org/resources/eciCorpus.html)
- [The Corpus of Contemporary Spanish(POStags, lemmas)](http://sfncorpora.uab.es/CQPweb/cea/)
- [Lemmas Dictionary](http://sfn.uab.es:8080/SFN/dictionary/dictionary-information-lemmas-and-expanded-forms)
- [esTenten Spanish (POSTagged) ](http://www.sketchengine.co.uk/documentation/wiki/Corpora/TenTen/esTenTen)
- [Europarl Corpus (Parallel Corpus English-Spanish)](http://www.statmt.org/europarl/)
- [Colombian Political Speeches](https://github.com/dav009/LatinamericanTextResources)
- [South American Slang Expressions/MTWE](https://github.com/dav009/LatinamericanTextResources)
- [Syntax and Semantic Annotations (Subset Ancora Corpus)](http://ufal.mff.cuni.cz/conll2009-st/trial/CoNLL2009-ST-Spanish-trial.zip)
- [Plurilingual Specific Corpus on Economics, Medicine, Computer Science](http://www.iula.upf.edu/corpus/corpusuk.htm)
- [Copenhagen  Treebank (Dependency Parsing)](http://code.google.com/p/copenhagen-dependency-treebank/)
- [Reuters Corpora RCV2 - New Corpora](http://trec.nist.gov/data/reuters/reuters.html)
- [MolinoLabs Corpus - News Corpora from Spain, Argentina and Mexico](http://www.molinolabs.com/corpus.html)
- [PANACEA- Legislation Corpus](http://panacea-lr.eu/en/info-for-researchers/data-sets/monolingual-corpora)
- [PANACEA- Legislation Ngram Corpus](http://panacea-lr.eu/en/info-for-researchers/data-sets/monolingual-corpora-n-grams/)
- [PANACEA- Dependency Parsed Corpus](http://panacea-lr.eu/en/info-for-researchers/data-sets/dependency-parsed-corpora/)
- [PANACEA- Monolingual Lexica (MWE, Frames, Semantic Classes)](http://panacea-lr.eu/en/info-for-researchers/data-sets/monolingual-lexica/)
- [Opinion Mining - User reviews on Cars, Hotels, Washing machines, Books, Cell phones, Music..](https://www.sfu.ca/~mtaboada/SFU_Review_Corpus.html)
- [Cross Lingual Textual Entailment (CLTE) Corpus (English-Spanish)](http://www.celct.it/resources.php?id_page=CLTE)
- [Ngram Frequencies out of Colombia News Corpora](http://ngrams.cavorite.com/datos/)
- [Sagan Textual Entailment Test Suite](http://www.investigacion.frc.utn.edu.ar/mslabs/~jcastillo/Sagan-test-suite/)
- [Garcia, Marcos and Pablo Gamallo, 2013 - Portuguese and Spanish biographical relation extraction corpora (Garcia, Marcos and Pablo Gamallo, 2013. Exploring the Effectiveness of Linguistic Knowledge for Biographical Relation Extraction. Natural Language Engineering, CJO2013. doi:10.1017/S1351324913000314.)](http://gramatica.usc.es/~marcos/corpora_nle.tgz)
- [Garcia, Marcos and Pablo Gamallo, 2014 - Portuguese, Spanish and Galician coreference corpora (Garcia, Marcos and Pablo Gamallo, 2014. Multilingual corpora with coreferential annotation of person entities. In Proceedings of the 9th edition of the Language Resources and Evaluation Conference (LREC 2014), Reykjavik: 3229-3233.)](http://gramatica.usc.es/~marcos/resources/corpora_coref.tar.bz2)
- [COW(Corpora From the Web) Ngram/Annotated People's Name Corpora ](http://hpsg.fu-berlin.de/cow/)
- [Wikicorpus- Portion of 2006's wikipedia annotated with WordNet Synsets and POS](http://www.cs.upc.edu/~nlp/wikicorpus/)
- [Spanish Billion Words Corpus with word2vec Embeddings](http://crscardellino.me/SBWCE/)
- [OSCAR or Open Super-large Crawled ALMAnaCH coRpus Spanish subset](https://traces1.inria.fr/oscar/) 


## Misc

- [Word2Vec vectors for Wikipedia Spanish Articles](https://github.com/idio/wiki2vec)
- [DBpedia Spanish Entities Titles](http://data.dws.informatik.uni-mannheim.de/dbpedia/2014/es/labels_es.nt.bz2)
- [DBpedia Spanish Abstracts](http://data.dws.informatik.uni-mannheim.de/dbpedia/2014/es/short_abstracts_es.nt.bz2)
- [Conshuga - Galician Verb conjugator](http://gramatica.usc.es/pln/tools/conjugador/download.html)

## Contribute

Contributions welcome! Read the [contribution guidelines](https://github.com/dav009/awesome-spanish-nlp/blob/master/contributing.md) first.

## License

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [David Przybilla](http://alejandro.pictures) has waived all copyright and related or neighboring rights to this work.
