<div class="github-widget" data-repo="RayBB/awesome-social-enterprise"></div>
## Awesome Social Enterprise [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)
📗Resources to dive into the world of social enterprises 🌼 

> A social enterprise is an organization that is primarily **focused on social impact** and is at least partially **self-funded**.


<details>
  <summary>Rant on why I made this</summary>
  
  When I was at Eckerd College I repeatedly bumped into the concept of social enterprises. First, in a course called _Technology, Society, and The Environment_, then through meeting the CTO of a social enterprise, and finally by taking a course called _Social Entrepreneurship_. Each step along the way I fell more in love with the concept of social enterprises. However, I never felt like there was an easy way to connect to the world of social enterprises. 
  
  Eventually, I set a [Google Alert](https://support.google.com/websearch/answer/4815696?hl=en) for weekly digests of anything related to "social entrepreneurs." That worked okay but I still felt like I was missing out on something. Fast-forward a few years and I find myself heavily involved in a nonprofit called [hackNY](https://hackny.org/), working at The New York Times, and having a stronger urge than ever to learn about social enterprises. As such, I've started compiling this list of resources to make it easy for people to connect with the world of social enterprises. See the FAQs at the bottom for some common questions.
  
</details>


## What to Read
### Wikipedia Links 🔗
Wikipedia is a great place to explore and find related topics.

* [Social enterprise](https://en.wikipedia.org/wiki/Social_enterprise)
* [Social entrepreneurship](https://en.wikipedia.org/wiki/Social_entrepreneurship)
* [List of social entrepreneurs](https://en.wikipedia.org/wiki/List_of_social_entrepreneurs)
* [Category:Social enterprises](https://en.wikipedia.org/wiki/Category:Social_enterprises)
* [Category:Social entrepreneurs](https://en.wikipedia.org/wiki/Category:Social_entrepreneurs)
* [Category:Social entrepreneurship](https://en.wikipedia.org/wiki/Category:Social_entrepreneurship)
 
 <!--Ignore double link until fixed: https://github.com/sindresorhus/awesome-lint/issues/114-->
<!--lint disable double-link--> 
<!--lint disable table-pipe-alignment-->
### News 📰
#### Finding Articles
* [Pioneers Post](https://www.pioneerspost.com/) - The Social Enterprise Magazine.
* [Impact Boom](https://www.impactboom.org/blog) - Social impact blog and podcast.
* Harvard Business Review - [Articles tagged "social enterprise"](https://hbr.org/topic/social-enterprise) are infrequent but high quality.
* Stanford Social Innovation Review - Great publication with many articles tagged [social enterprise](https://ssir.org/topics/category/social_enterprise#).
* Galileo Impact Stories | [YouTube](https://www.youtube.com/channel/UCtpwKxUCqGfHPKSqYKgfphw) | [Kickstarter](https://www.kickstarter.com/projects/baurens/pro-russia) | [Website](https://iiic.ch/)  
  * A small but growing organization dedicated to covering impact investing. Content is often Russia oriented and not always directly about social enterprises but much of the content is relative. [Here](https://youtu.be/Pzxz38AnXCc) is a video summarizing their work in 2019.
* [Journal of Social Entrepreneurship](https://www.tandfonline.com/toc/rjse20/current) - _The_ academic journal for the topic.
* [The Straits Times](https://www.straitstimes.com/tags/social-enterprises) - Singapore based newspaper with articles about social enterprise.

#### Articles
* [State of Social Entrepreneurship 2020](https://echoinggreen.org/news/state-of-social-entrepreneurship-2020/) - Overview of SE in 2020 by Echoing Green.
  * [Echoing Green 2020 Fellows](https://echoinggreen.org/news/2020-fellows/)
* [90+ Inspiring Books For Impact-Driven Doers and Entrepreneurs](https://www.impactboom.org/blog/2020/1/10/90-inspiring-books-for-impact-driven-doers-and-social-entrepreneurs)


### Papers 📃
* (1998) _The Meaning of "Social Entrepreneurship"_ by J. Gregory Dees
  * A short history of social entrepreneurship (and why the definition isn't agreed upon).
* (2004) _The Legitimacy of Social Enterprise_ Raymond Dart
  * A pragmatic discussion on why social enterprises, in relation to nonprofits, exist.
* (2008) [_Evolution of the social enterprise industry_](https://socialent.org/documents/EVOLUTIONOFTHESOCIALENTERPRISEINDUSTRY--ACHRONOLOGYOFKEYEVENTS.pdf) by the Institute for Social Entrepreneurs
  * Less academic but a detailed history of events related to social enterprises.
* (2010) _Conceptions of Social Enterprise and Social Entrepreneurship_ by Jacques Defourny
  * Parallels between US and European Social Enterprises.
* (2014) _Social Enterprise – A New Phenomenon in the Field of Economic and Social Welfare?_ by Leandro Sepulveda
  * A history of social enterprises from a UK perspective.

### Books 📚

| Title | Author | Year | Notes |
|-------|--------|------|-------|
| Social Entrepreneurship: What Everyone Needs To Know | David Bornstein | 2010 | Great introduction to social entrepreneurship. Short and sweet with lots of great answers to common questions. |
| [Ladderworks books](https://www.ladderworks.co/) | various | 2022 | Diverse picture books for empowering over a million kids to become social entrepreneurs. |
| Becoming a Social Entrepreneur: Starting Out, Scaling Up and Staying True | Michael Gordon | 2019 |  | 
| Paying It Forward: How to Be A Social Entrepreneur | Josh Littlejohn MBE | 2023 | |

## Podcasts 🎧
* [The Tech Matters Podcast](https://techmatters.org/introducing-the-tech-matters-podcast/) - Talking about social enterprise structure and interviewing folks running them. Hosted by social entreprenur and engineer [Jim Fruchterman](https://en.wikipedia.org/wiki/Jim_Fruchterman).

## Courses 🎓
Future Learn
* [Social Enterprise Program](https://www.futurelearn.com/programs/social-enterprise)
  * By Middlesex University Business School & Jindal Centre for Social Innovation + Entrepreneurship program.
  * Free, three courses, nine weeks total.
  * According to [this](https://doi.org/10.3390/su12083247) paper, the courses were quite impactful and helped start many social enterprises.

[Philanthropy University](https://courses.philanthropyu.org/courses) | [Interview with CEO](https://iblnews.org/philanthropy-universitys-connor-diemand-yauman/) | [Origins](https://www.nytimes.com/2015/10/17/your-money/online-university-helps-philanthropic-groups-and-their-leaders.html)  
* Several free courses such as: _Introduction to Fundraising_, _Fundraising Strategies_, _and Setting Up a Nonprofit Board_.

edX   
* [Business and Impact Planning for Social Enterprises](https://www.edx.org/course/business-and-impact-planning-for-social-enterprise) - By MIT.
* [Disciplined Approach to Social Entrepreneurship](https://www.edx.org/course/disciplined-approach-to-social-entrepreneurship) - By Curtin University.

Coursera  
* [Social Entrepreneurship](https://www.coursera.org/learn/wharton-social-entrepreneurship) - By Wharton Business School. One course, approximately nine hours of work.
* [Social Entrepreneurship Specialization](https://www.coursera.org/specializations/social-entrepreneurship-cbs) - By Copenhagen Business School. Three courses to complete over four months.
* [Becoming a Social Entrepreneur: Getting Started](https://www.coursera.org/learn/social-entrepreneurship-getting-started) - By University Of Michigan.

[Acumen Academy](https://acumenacademy.org/learn)
* Offers free and paid courses to help individuals create social change.

## Fellowships
* [Year Here](https://yearhere.org/) - One year social enterprise fellowship to build an organization based in London.
* [Acumen Academy Fellowship](https://acumenacademy.org/fellowship) - One year fellowship with the goal of equipping individuals with the tools to tackle issues in their communities.
* [Echoing Green Fellowship](https://echoinggreen.org/fellowship/) - 18 month fellowship including possible funding.
* [Miller Center Accelerator](https://www.millersocent.org/programs/our-accelerators/) - Six month program, 4-6 hours a week. Geard towards senior leaders.
* [MIT Solve's Global Challenges Program](https://solve.mit.edu/challenges) - Nine month program with funding available. Geared toward specific themes.
* [Fast Forward Accelerator](https://www.ffwd.org/accelerator/) - Startup accelerator for nonprofit tech companies.
* [100x Impact Accelerator](https://www.100ximpact.org/) - 12 week program with 150k for social enterprises.
* [Fashion for Good Accelerator](https://accelerator.fashionforgood.com/) - Nine month program to solve fashion sustainability problems.
* [Social Enterprise Academy Accelerator](https://www.academies-se.org/accelerator) - 20 week program to foster social enterprises. Up to 30k in funding available.
* [Radical Partners](https://www.radical.partners) - Miami-based social impact accelerator.
* [Seaworthy Collective](https://www.seaworthycollective.com) - Miami-based BlueTech entrepreneur support organization.

## Institutions 🏫
Academic institutions researching social enterprise:

* [Middlesex University Business School](https://www.mdx.ac.uk/our-research/centres/ceedr/social-enterprise)
* [Jindal Centre for Social Innovation + Entrepreneurship program](https://www.jsie.in/)
* [Wharton Social Entrepreneurship](https://entrepreneurship.wharton.upenn.edu/wharton-social-entrepreneurship/)
* [Copenhagen Business School Social Entrepreneurship](https://www.cbs.dk/en/knowledge-society/interdisciplinary-initiatives/entrepreneurship/organization/clusters/social-entrepreneurship)
* [USC Marshall Masters in Social Entrepreneurship](https://www.marshall.usc.edu/programs/specialized-masters-programs/master-science-social-entrepreneurship/)
* [The Elisabeth Bruyère School of Social Innovation](https://innovationsocialeusp.ca/en/school) - Canada's first school of social innovation.
* [Pepperdine's MA in Social Entrepreneurship and Change](https://gsep.pepperdine.edu/masters-social-entrepreneurship-and-change/)
* [Centre for Social Impact Swinburne](https://www.swinburne.edu.au/research/centres-groups-clinics/centre-for-social-impact-swinburne/)
* [VUB Chair Social Entrepreneurship](https://www.vubsocialentrepreneurship.com/)


## Tools 🔨
* [GuideStar](https://www.guidestar.org) - Reporting on U.S. nonprofit companies.
* [ProPublica Nonprofit Explorer](https://projects.propublica.org/nonprofits/) - Easily access any U.S. nonprofit's tax documents.
* [Social Bearing](https://socialbearing.com/search/user) - Useful to determine how popular/active any Twitter account is.

## What to Watch

### Videos 📽
* [Social Entrepreneurs: Pioneering Social Change](https://www.youtube.com/watch?v=jk5LI_WcosQ) - Skoll Foundation video about social entrepreneurs.
* [Muhammad Yunus's Nobel Prize Speech](https://www.nobelprize.org/prizes/peace/2006/yunus/lecture/) - Yunus built Grameen Bank, the poster child for social enterprises.
* [Social Enterprise 101](https://www.youtube.com/watch?v=9_g5RqwW51I) - Quick and easy overview oof social enterprise.
* [How social entrepreneurship will change the world](https://www.youtube.com/watch?v=KrQuGTvwl0s) - Inspiring TEDx talk by Erica Wenger about social enterprises.

### Movies 🎥

| Title | Year | Notes |
|-------|------|-------|
| The Social Shift | 2018 | Four young adults travel across Canada interviewing social entrepreneurs. |
| The New Breed | 2020 | Follows three change-makers as they build social enterprises. |

## Communities 🤝

### Online 

* Facebook
  * [Social Entrepreneurs](https://www.facebook.com/groups/socentnet/) - 2k members many posts each day.
* Quora
  * [Social Entrepreneurship](https://www.quora.com/topic/Social-Entrepreneurship) - 375k followers, great for asking questions.
* United States Association for Small Business and Entrepreneurship (USASBE).
  * [Social Entrepreneurship](https://www.usasbe.org/group/Social) - Focused on social entrepreneurship education.

### Conferences
* [Skoll World Forum](https://skoll.org/skoll-world-forum/) - Large annual conference for Skull Foundation.
* [Harvard Social Enterprise Conference](http://socialenterpriseconference.org) - Student run annual social enterprise conference.
* [Indiana University Social Entrepreneurship Conference](https://kelley.iu.edu/news-events/events/bloomington/social-entrepreneurship-conference-2019/index.cshtml) - Two day conference focused on social entrepreneurship research.
* [Social Enterprise Summit](https://www.ses.org.hk/) - Annual social enterprise conference based in Hong Kong.

### Finding Local Communities
* [SEA Chapters](https://socialenterprise.us/programs/chapter-directory/) - Groups all over US focused on social enterprises.
* [Meetup](https://www.meetup.com/) - Popular group meeting site.
* [Eventbrite](https://www.eventbrite.com/) - Easy site for discovering events near you.

### Networks
* [senco (social enterprise network of central ontario)](https://senco.io/home/) - Canada group promoting social enterprises.
* [Social Enterprise Alliance](https://socialenterprise.us/) - US social enterprise advocates.
* [enactus](https://enactus.org/) - Worldwide organization fostering student social entrepreneurs.
* [Buy Good. Feel Good.](https://buygoodfeelgood.com/) - North American expo dedicated to brands that are changing the world.
* [SocialVentures](https://socialventurescbus.com/) - Ohio nonprofit to advocate for, develop, and fund businesses that solve social problems.

### Foundations
* [Skoll Foundation](https://en.wikipedia.org/wiki/Skoll_Foundation) - Large foundation investing in social entrepreneurs.
* [Schwab Foundation for Social Entrepreneurship](https://en.wikipedia.org/wiki/Schwab_Foundation_for_Social_Entrepreneurship) - Advocates for social entrepreneurss on a global level.
* [The Audacious Project](https://audaciousproject.org/) - A TED project funding social entrepreneurs and nonprofits.
* [CA RISE](https://redf.org/ca-rise/) - A $25M California initiative providing capital ($100k-$500k grants) and technical assistance to employment social enterprises.

### Consultants
* [CSED](https://csedottawa.ca) - Canada based nonprofit helping develop, launch, and grow social enterprises.
* [Common Good Solutions](https://commongoodsolutions.ca) - Canada based B-corp helping governments, community organizations and entrepreneurs.

## People 🧑

### Authors
* [Susan Davis](https://en.wikipedia.org/wiki/Susan_Davis_(author)) - Co-authored books on on social enterprise and highly active in community.
* [David Bornstein](https://en.wikipedia.org/wiki/David_Bornstein_(author)) - Wrote several popular books on social entrepreneurship.

### Social Entrepreneurs
* [Muhammad Yunus](https://en.wikipedia.org/wiki/Muhammad_Yunus) - Nobel Prize winner, founder of Grameen Bank, considered father of social enterprise.

### Twitter Accounts 🐦 

See a feed of all these accounts by following my "Social Enterprise News" Twitter list [here](https://twitter.com/i/lists/1256292945243918336).

* [Ken Banks](https://twitter.com/kiwanja) - Founder of Kiwanja.
* [Tech Jobs for Good](https://twitter.com/techjobsforgood) - Posts about tech jobs with social impact.
* [Centre for Social Innovation Toronto](https://twitter.com/csiTO) - A coworking space, community, and launchpad for people who are changing the world.
* [Ashoka](https://twitter.com/Ashoka)
* [Echoing Green](https://twitter.com/echoinggreen)
* [Social Good News](https://twitter.com/mysocialgood)
* [HBS SocialEnterprise](https://twitter.com/HBSSEI)
* [Social Enterprise Alliance](https://twitter.com/SEAlliance)
* [senco](https://twitter.com/senco_io)
* [Pioneers Post](https://twitter.com/PioneersPost)
* [Year Here](https://twitter.com/yearhere)
* [The Audacious Project](https://twitter.com/theaudaciousprj)
* [enactus](https://twitter.com/enactus)
* [Impact Boom](https://twitter.com/ImpactBoomOrg)
* [Acumen](https://twitter.com/Acumen)

## [Social Enterprise Examples](https://github.com/RayBB/awesome-social-enterprise/blob/master/social_enterprise_examples.md)

## Miscellaneous 
* [WorldShapers](https://worldshapers.net/) - An abundance of resources related to social entrepreneurship education.
* [Benefit Corporation](https://en.wikipedia.org/wiki/Benefit_corporation) - A type of for-profit corporate entity, authorized by 35 U.S. states.
* [B Corp Certification](https://en.wikipedia.org/wiki/B_Corporation_(certification)) - Certificate issued for existing for profit organizations demonstrating social responsibility.

## FAQs ❓

Q: What is the goal of this repo?  
A: To provide resources for people to dive into the world of social enterprises. To get people excited about social enterprises. To spread the word of social enterprises.

Q: What do you like about social enterprises?  
A: I love the idea of bringing the goodness of nonprofits and the efficiency of business together. Not all nonprofits are inefficient and not all businesses are bad. However, the potential of unleashing the notoriously efficient business practices to maximize social impact is what I want to encourage people to explore.

Q: Why social enterprise instead of social entrepreneurship?  
A: I want to focus on the organizational structure rather than the individuals within an organization. Social entrepreneurship can mean anything from a large organization championing for social causes to a lone person doing community development. While both of those are important and valuable this is a resource geared towards people interested in the organizational side of things.

Q: How is a social enterprise different from a nonprofit?  
A: A social enterprise may be a nonprofit. While nonprofits are usually focused on social impact they may not be generating any revenue to fund themselves.

Q: Why not just add this information to Wikipedia?  
A: Wikipedia is meant to contain information that's encyclopedic in nature. Meaning, it should contain the most important and verified information in a well summarized form. This document is much more like a phone book trying to link out to relative resources that are useful.


## [Contributing](https://github.com/RayBB/awesome-social-enterprise/blob/master/CONTRIBUTING.md)

### Todo
* Read these books and articles before adding them:
  * An Army of Problem Solvers by Shaun Loney
  * Introduction to Social Entrepreneurship by Teresa Chahine
  * Educating at Scale for Sustainable Development and Social Enterprise Growth by Sara Calvo 

<script async data-id="1fc566b4-8dda-4926-ad18-22bb88e42ecc" src="https://tinyads.io/e"></script>
