<div class="github-widget" data-repo="nekofar/awesome-slim"></div>
## Awesome Slim [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

<!--lint ignore double-link-->
[<img src="https://raw.githubusercontent.com/nekofar/awesome-slim/master/assets/slim-logo.png" align="right" width="260" alt="Slim Framework">](https://www.slimframework.com)

<!--lint ignore double-link-->
&gt; 精选清单 [Slim](https://www.slimframework.com) 框架包和资源.

<!--lint ignore double-link-->
[Slim](https://www.slimframework.com) 是一个 PHP 微型框架，可帮助您快速编写简单但功能强大的 Web 应用程序和 API.



## Educational

- [User Guide](https://www.slimframework.com/docs/v4/) - Slim 框架的官方文档.
- [Stack Overflow](https://stackoverflow.com/questions/tagged/slim) - 关于 Stack Overflow 的 Slim Framework 问题.
- [Discussion Forum](https://discourse.slimframework.com) - 官方 Slim Framework 讨论论坛.
- [Slim 4 - GraphQL](https://odan.github.io/2021/08/12/slim-graphql.html) - 使用 GraphQL 创建现代 HTTP API.
- [Slim 4 - ReactPHP](https://odan.github.io/2021/08/14/slim-reactphp.html) - Slim 与 ReactPHP 结合使用以提高性能.

## Boilerplate

- [Slim 4 MVC Skeleton](https://github.com/semhoun/slim-skeleton-mvc) - 这是一个简单的 Web 应用程序骨架项目.
- [Slim 4 Skeleton](https://github.com/adriansuter/Slim4-Skeleton) - 使用 PHP-DI、Nyholm PSR7 和 Twig 的 Web 应用程序框架.
- [Slim 4 Skeleton](https://github.com/odan/slim4-skeleton) - 这是快速设置新的 Slim 4 应用程序的框架.
- [Slim Skeleton](https://github.com/slimphp/Slim-Skeleton) - 官方 Slim Framework 4 骨架应用程序.
- [Slim 4 Starter](https://github.com/nbayramberdiyev/slim-4-starter) - 适用于中小型 PHP 应用程序的自以为是的 Slim 4 入门模板.

## Middlewares

- [Slim Basic Auth](https://github.com/tuupola/slim-basic-auth) - PSR-7 和 PSR-15 HTTP 基本身份验证中间件.
- [Slim CSRF](https://github.com/slimphp/Slim-Csrf) - Slim Framework CSRF 保护中间件.
- [Slim HTTP Cache](https://github.com/slimphp/Slim-HttpCache) - Slim Framework HTTP 缓存中间件和服务提供者.
- [Slim JWT Auth](https://github.com/tuupola/slim-jwt-auth) - PSR-7 和 PSR-15 JWT 身份验证中间件.
- [Slim Minify](https://github.com/christianklisch/slim-minify) - 用于缩小 slim 生成的 HTML 输出的 Slim 中间件.
- [Slim Session](https://github.com/bryanjhv/slim-session) - 一个非常简单的 Slim 框架会话中间件.
- [Slim Whoops](https://github.com/zeuxisoo/php-slim-whoops) - 在 slim 框架上出现 PHP 错误.

## Templating

- [Slim Twig View](https://github.com/slimphp/Twig-View) - 构建在 Twig 模板组件之上的 Slim Framework 视图助手.
- [Slim Plates](https://github.com/projek-xyz/slim-plates) - 使用 Plates 模板引擎呈现您的 Slim 应用程序视图.
- [Slim PHP View](https://github.com/slimphp/PHP-View) - 这是一个渲染器，用于将 PHP 视图脚本渲染到 PSR-7 响应对象中.

## Development

- [Pest Slim Plugin](https://github.com/nekofar/pest-plugin-slim) - Pest 的 Slim 插件为您提供了基本的测试功能.
- [Slim Test](https://github.com/nekofar/slim-test) - 建立在 PHPUnit 测试框架之上的 Slim Framework 测试助手.

## Miscellaneous

- [BasePath](https://github.com/selective-php/basepath) - Slim 4 的基本路径检测器.
- [PHP-DI Slim Bridge](https://github.com/PHP-DI/Slim-Bridge) - PHP-DI 与 Slim 框架的集成.
- [Slim Config](https://github.com/DavidePastore/Slim-Config) - 支持 PHP、INI、XML、JSON 和 YML 文件的文件配置加载器.
- [Slim Console](https://github.com/slimphp/Slim-Console) - 超薄框架控制台.
- [Slim Flash](https://github.com/slimphp/Slim-Flash) - Slim Framework flash 消息服务提供商.
- [Slim JSON API](https://github.com/entomb/slim-json-api) - 实现快速 JSON API 的 Slim 扩展.
- [Slim Validation](https://github.com/DavidePastore/Slim-Validation) - Slim 框架的验证库.
- [IntelliJ Slim](https://plugins.jetbrains.com/plugin/18751-slim) - 提供样板代码，以便使用骨架更轻松地创建新项目.

## Contributing

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/nekofar/awesome-slim/blob/master/CONTRIBUTING.md) 第一的.
