<div class="github-widget" data-repo="matiassingers/awesome-slack"></div>
[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

<p align="center">
    <img src="https://raw.githubusercontent.com/matiassingers/awesome-slack/master/awesome-slack-pink.png" alt="Logo" width="200px">
</p>

<p align="center">
    <h3 align="center">Awesome Slack</h3>
</p>

<p align="center">
    A curated list of awesome, Slack-related things.
</p>

***

An avid Slack user? A developer looking for awesome tools to build out an integration? Just looking for inspiration? This is a list of all the best things Slack. 


## :pencil: &nbsp; Lists
- [Community-Built Libraries](https://api.slack.com/community) - Slack-curated list of community open-source libraries
- [Slack App Directory](https://slack.com/apps) - Official directory of publicly available Slack apps 
- [Slack Emojis](https://emoji.gg) - Unofficial directory of custom emojis for Slack

## :art: &nbsp; Themes

- [Slack Themes](http://slackthemes.net/) - A Slack sidebar theme browser
- [Sweet Themes Are Made of These](http://sweetthemesaremadeofthe.se/) - Website for sharing Slack custom palettes

## :hammer_and_wrench: &nbsp; Libraries and SDKs

### C&#35;

- [margiebot](https://github.com/jammerware/margiebot) - A .NET library designed to make building bots for Slack fast, easy, and fun
- [Slack.Webhooks](https://github.com/nerdfury/Slack.Webhooks) - A library to work with Slack webhooks more easily
- [SlackAPI](https://github.com/Inumedia/SlackAPI) - A third-party implementation of Slack's API written in C#

### Erlang

- [slacker](https://github.com/julienXX/slacker) - Erlang Slack REST API wrapper

### Go

- [webhook](https://github.com/adnanh/webhook) - Easily run commands in response to HTTP webhook requests from Slack

### Java

- [java-slack-sdk](https://github.com/slackapi/java-slack-sdk) - Slack's official Java framework for building Slack apps
- [simple-slack-api](https://github.com/Ullink/simple-slack-api) - A Slack client library in Java

### JavaScript/TypeScript

- [bolt-js](https://github.com/slackapi/bolt-js) - Slack's official JavaScript framework for building Slack apps
- [jsx-slack](https://github.com/yhatt/jsx-slack) - Build JSON object for Slack Block Kit surfaces from JSX
- [node-slack-sdk](https://github.com/slackapi/node-slack-sdk) - Slack's official SDK for Node.js 
- [slack-block-builder](https://github.com/raycharius/slack-block-builder) - Lightweight Node.js library for building Slack Block Kit UIs, with a declarative syntax inspired by SwiftUI

### PHP

- [SlackBundle](https://github.com/DZunke/SlackBundle) - SlackBundle for Symfony2
- [slack-php-app-framework](https://github.com/slack-php/slack-php-app-framework) - Robust PHP framework for building Slack apps in PHP
- [slack-php-block-kit](https://github.com/jeremeamia/slack-block-kit) - Fluent interface for composing Slack Block Kit messages and modals in PHP 
- [slack-php-socket-mode](https://github.com/slack-php/slack-php-socket-mode) - A Socket Mode implementation for [slack-php-app-framework](https://github.com/slack-php/slack-php-app-framework)
- [slack-php-slick](https://github.com/slack-php/slack-php-slick) - Dependency-free micro-framework for building Slack apps in PHP   

### PowerShell

- [PSSlack](https://github.com/RamblingCookieMonster/PSSlack) -  PowerShell module for simple Slack integration.

### Python

- [blockkit](https://github.com/imryche/blockkit) - A fast way to build Block Kit interfaces in Python
- [bolt-python](https://github.com/slackapi/bolt-python) - Slack's official Python framework for building Slack apps
- [django-slack](https://github.com/lamby/django-slack) - Slack integration for Django, using the templating engine to generate messages
- [django-slack-oauth](https://github.com/izdi/django-slack-oauth) - Slack OAuth module for Django
- [python-slack-events-api](https://github.com/slackapi/python-slack-events-api) - Slack Events API adapter for Python 
- [python-slack-sdk](https://github.com/slackapi/python-slack-sdk) - Slack's official SDK for Python
- [slackblocks](https://github.com/nicklambourne/slackblocks) - Python API for building Slack Block Kit messages
- [slack-php-api](https://github.com/jolicode/slack-php-api) - PHP Slack client based on the official OpenAPI specification 
- [slacker-cli](https://github.com/juanpabloaj/slacker-cli) - Messages to slack from the command line
- [slashbot](https://github.com/ebrassell/slashbot) - An easy way to create slash commands using AWS Lambda functions
- [boltworks](https://github.com/YSaxon/boltworks) - Extensions to Slack's bolt framework: expandable GUIs, easier callbacks, richer CLIs

### R

- [slackr](https://github.com/hrbrmstr/slackr) - A package to send webhook API messages to Slack channels/users from R

### Ruby

- [slack-notifier](https://github.com/stevenosloan/slack-notifier) - A simple wrapper for posting to Slack
- [slack-notify](https://github.com/sosedoff/slack-notify) - Send notifications to Slack
- [slack-poster](https://github.com/rikas/slack-poster) - Simple gem to post messages on Slack using webhooks
- [slack-ruby-block-kit](https://github.com/CGA1123/slack-ruby-block-kit) - A ruby wrapper for Slack's Block Kit
- [slack-ruby-bot](https://github.com/dblock/slack-ruby-bot) - The easiest way to write a Slack bot in Ruby
- [slack-ruby-bot-server](https://github.com/slack-ruby/slack-ruby-bot-server) - Ruby library for building Slack applications
- [slack-ruby-client](https://github.com/dblock/slack-ruby-client) - A Ruby client for the Slack Web and RealTime Messaging APIs

### Rust

- [slack-morphism-rust](https://github.com/abdolence/slack-morphism-rust) - A modern async Slack API client for Rust

### Scala

- [slack-scala-client](https://github.com/gilbertw1/slack-scala-client) - A Scala Slack client for the Web and RTM API

### Swift

- [SwiftBlocksUI](https://github.com/SwiftBlocksUI/SwiftBlocksUI/) - Interactive Slack messages and modals using a SwiftUI-like declarative style

## :gear: &nbsp; Open-Source Slack Apps and Integrations

### CoffeeScript

- [jinora](https://github.com/sdslabs/jinora) - Slack webhook app to create anonymous public channels

### Java

- [simple-slack-api](https://github.com/Ullink/simple-slack-api) - A Slack client library in Java
- [tasks-app](https://github.com/slackapi/tasks-app) - Simple task management app produced by Slack

### JavaScript/Typescript

- [definition-app](https://github.com/slackapi/definition-app) - App for storing and accessing company-specific phrases
- [slack-github-action](https://github.com/slackapi/slack-github-action) - Send data into Slack using this GitHub Action
- [slack-reporting-tool](https://github.com/slackapi/slack-reporting-tool) - App that allows team members to report offensive messages
- [tesla-slack](https://github.com/heikkipora/tesla-slack) - Track your Tesla from Slack
- [tasks-app](https://github.com/slackapi/tasks-app) - Simple task management app produced by Slack

### PHP

- [MantisBT-Slack](https://github.com/infojunkie/MantisBT-Slack) - MantisBT plugin to send bug updates to Slack
- [monolog](https://github.com/Seldaek/monolog) - Sends your logs to Slack  

### Python

- [slackbot](https://github.com/lins05/slackbot) - A chat bot for Slack
- [slacker-cli](https://github.com/juanpabloaj/slacker-cli) - Messages to slack from the command line
- [tasks-app](https://github.com/slackapi/tasks-app) - Simple task management app produced by Slack
- [wee-slack](https://github.com/rawdigits/wee-slack) - A WeeChat plugin for Slack

### Ruby

- [slack-gamebot](https://github.com/dblock/slack-gamebot) - A game bot for Slack
- [snarkov](https://github.com/gesteves/snarkov) - Sinatra-based Markov bot for Slack
- [tickbot](https://github.com/barryf/tickbot) - Simple team time tracking reminder
- [trebekbot](https://github.com/gesteves/trebekbot) - A Jeopardy! bot for Slack

## :busts_in_silhouette: &nbsp; Contributions

Contributions are always welcome! Please read the [contribution guidelines](https://github.com/matiassingers/awesome-slack/blob/master/contributing.md) first.

## :classical_building: &nbsp; License

[![CC0](https://licensebuttons.net/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Matias Singers](http://mts.io) has waived all copyright and related or neighboring rights to this work.
