<div class="github-widget" data-repo="pmuens/awesome-serverless"></div>
## Awesome Serverless [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; 有关无服务器所有事物的精选资源列表.

*灵感来自 [awesome](https://github.com/sindresorhus/awesome) 列出项目.*

**说*你好* [Twitter](https://twitter.com/pmmuens).**



---

## General

- [Serverless.com](http://serverless.com) - Serverless.com homepage.
- [Documentation](http://docs.serverless.com) - Serverless.com 文档.
- [Forum](http://forum.serverless.com) - 官方无服务器论坛.
- [Meetups](http://serverlessmeetups.com) - 列出所有官方无服务器聚会.
- [Stack Overflow](http://stackoverflow.com/questions/tagged/serverless-framework) - 堆栈溢出问题.
- [ServerlessConf](http://serverlessconf.io) - 无服务器专业会议.
- [Serverless Weekly](https://serverless.email) - 关于无服务器架构和范例的每周时事通讯.
- [Serverless working group](https://github.com/cncf/wg-serverless) - CNCF 无服务器工作组.
- [Serverless Summit](http://inserverless.com) - 关于无服务器技术/计算的会议.
- [Serverless Plugin Directory](https://www.serverlessconsultants.com/plugins/) - 无服务器框架插件目录.
- [OpenEvents](https://openevents.io) - 以通用方式描述事件数据的规范.
- [The power of serverless](https://thepowerofserverless.info) - 概述为什么无服务器是一个很好的选择 - 特别是对于前端开发人员.

## Blogs

- [Serverless Code](https://serverlesscode.com) - 关于与无服务器相关的所有内容的博客.
- [Serverless Zone](https://serverless.zone) - 无服务器相关的一切.
- [Serverless Blog](http://blog.serverless.com) - Serverless Framework 官方博客.
- [Serverless Stories](https://medium.com/serverless-stories) - 由无服务器框架背后的团队发布的中型出版物.
- [Going Serverless](http://www.goingserverless.com) - 关于无服务器架构和无服务器框架的博客.
- [Foobar Tech](https://foobar123.com/@marciavillalba) - 关于无服务器架构和一般编程的博客.
- [Serverless Guy](http://www.serverlessguy.com/) - 关于“没有服务器的生活”的博客.
- [Serverless City](http://www.serverless.city/) - 新闻、产品、意见、指南，以及成为无服务器公民所需知道的一切.
- [FaaS Forward](https://faaslane.wordpress.com) - 在 FaaS-Lane 上学习和生活.
- [ServerlessOps](http://www.serverlessops.io) - 设计、构建和运行可靠的无服务器系统.

## Blog posts

- [Serverless computing requires a shift in mindset](https://blogs.wsj.com/cio/2018/10/30/serverless-computing-requires-a-shift-in-mindset/) - 为什么 IT 领导者在谈论无服务器解决方案时必须传达业务价值.
- [Hosted vs. installable serverless platforms](https://thenewstack.io/serverless-roadmaps-platforms/) - 涵盖托管与可安装无服务器解决方案的调查.
- [Launching TriggerMesh](https://triggermesh.com/2018/11/01/launching-triggermesh/) - TriggerMesh（基于 knative 的无服务器管理平台）公告博客文章.
- [Serverless without containers](https://blog.cloudflare.com/cloud-computing-without-containers/) - Cloudflare 如何利用 v8 引擎隔离和运行用 Node.js 编写的 Cloudflare Worker.
- [Takeaways from ServerlessNYC 2018](https://www.jeremydaly.com/takeaways-from-serverlessnyc-2018/) - ServerlessNYC 2018 会议的要点.
- [Serverless & Functions - Not one and the same](https://hackernoon.com/serverless-functions-not-one-and-the-same-150eb070d9a3) - 发布无服务器计算和 FaaS 之间的区别.
- [Serverless for startups](https://medium.com/swlh/serverless-for-startups-its-the-fastest-way-to-build-your-technology-idea-a0f0b5efe2f3) - 为什么无服务器是构建技术理念的最快方式.
- [Serverless monitoring, security, frameworks, tools](https://thenewstack.io/serverless-roadmaps-monitoring-security-frameworks-tools/) - 发布有关不同的无服务器监控、安全、框架和工具解决方案的信息.
- [Writing portable serverless applications](https://medium.com/datreeio/writing-portable-serverless-applications-252fd8623bce) - 发布如何编写可在不同计算环境中运行的便携式无服务器应用程序.
- [Serverless sea change](https://www.infoq.com/articles/serverless-sea-change) - 定义和解释无服务器与其他应用程序架构有何不同的文章.
- [Serverless Instant Checkout Links with Square](https://developer.squareup.com/blog/serverless-instant-checkout-links-with-square/) - 一个示例，展示了如何构建由 Square API 支持的无服务器即时结账链接.

## Screencasts

- [Build apps faster with Azure Serverless](https://www.youtube.com/watch?v=OnJt4qfsfOc) - Microsoft Azure Functions 无服务器产品演练.
- [FaaS performance comparison](https://www.youtube.com/watch?v=JS2h8pmqsww) - 比较无服务器函数性能.
- [Introduction to Kubeless](https://www.youtube.com/watch?v=ROA7Ig7tD5s) - 介绍 Kubeless 项目及其无服务器框架集成的视频.
- [What's new in Serverless v1.22](https://www.youtube.com/watch?v=ykkeliDAs-c) - 有关无服务器 v1.22 中所有新功能的视频演练.
- [Kuhiro: Birth of the NearCloud](https://www.youtube.com/watch?v=BQXCn6xBYzA) - 解释 NearCloud 概念的视频.
- [How to build a regionally distributed serverless architecture](https://www.youtube.com/watch?v=6uijFRFURPQ) - 关于如何构建区域分布式无服务器架构的网络研讨会.
- [Autoscaling DynamoDB with the Serverless Framework](https://www.youtube.com/watch?v=HVQVEjNpMeQ) - 有关如何将 DynamoDB 自动缩放功能与无服务器框架结合使用的演练.
- [Building React + Serverless full stack apps](https://www.youtube.com/watch?v=UGrGce6-cX4) - 如何使用 React 和无服务器框架构建全栈应用程序.
- [Become a serverless black belt](https://www.youtube.com/watch?v=4nrRt0dOcFk) - 关于如何优化无服务器应用程序的 AWS 在线技术讲座.
- [Jazz serverless developer teaser](https://www.youtube.com/watch?v=6Kp1yxMjn1k) - T-Mobile Jazz 无服务器开发人员预告片.

## Talks

- [The serverless and event-driven future](https://www.youtube.com/watch?v=TZPPjAv12KU) - 事件网关如何启用一种构建事件驱动应用程序的新方法.
- [Serverless, Not So FaaS](https://www.youtube.com/watch?v=_1-5YFfJCqM) - CloudNativeCon 2018 主题演讲，作者是 Google Kubernetes 社区成员 Kelsey Hightower.
- [Bringing serverless to Rock 'n Roll](http://www.thecloudcast.net/2018/05/the-cloudcast-348-bringing-serverless.html) - 关于 Fender 如何将无服务器技术用于其数字学习平台的播客.
- [Using the Event Gateway to build serverless multi-cloud applications](https://www.youtube.com/watch?v=h1PIqbi93eE) - 如何使用事件网关构建多云应用程序.
- [Deep dive into serverless](https://www.slideshare.net/AmazonWebServices/deep-dive-on-serverless-application-development-102837125) - 关于无服务器应用程序开发的幻灯片.
- [Discussing serverless](https://soundcloud.com/thenewstackanalysts/discussing-serverless-with-symphoniaio-and-serverless-inc) - 关于无服务器环境的播客.
- [Confusion in the land of the serverless](https://www.youtube.com/watch?v=Y6B3Eqlj9Fw) - Sam Newmans 在 GOTO 2018 上谈论无服务器技术.
- [Serverless state of the union](https://www.youtube.com/watch?v=q7mFl9sLiCY) - Austen Collins 在 2018 年开源峰会上关于无服务器和联盟现状的主题演讲.
- [ServerlessConf SF 2018 videos](https://acloud.guru/series/serverlessconf-sf-2018) - 来自 ServerlessConf SF 2018 的演讲.
- [Serverless at iRobot](https://www.infoq.com/podcasts/serverless-build-connected-robots) - iRobot 如何使用无服务器技术.

## Projects

- [Official joke API](https://github.com/15Dkatz/official_joke_api) -Vue Jokester 应用程序后端.
- [Event Gateway Getting Started](https://github.com/serverless/event-gateway-getting-started) - 使用事件网关的演练应用程序.
- [Utils](https://github.com/serverless/utils) - 通用无服务器实用程序.
- [CloudWatch public metrics](https://github.com/RafalWilinski/cloudwatch-public-metrics) - 将 AWS CloudWatch 指标公开为公共 HTML 页面.
- [Invoicely](https://github.com/EwanValentine/invoicely) - 发票自动化工具.
- [World Cup Slackbot](https://github.com/phstc/serverless-world-cup-slack-bot) - 2018 年 FIFA World Cup Russia™ 将赛事与 Slack 相匹配.
- [Serverless Express](https://github.com/mikestaub/serverless-express) - 通过无服务器框架在 AWS Lambda 上运行未经修改的 Express 应用程序.
- [TypeScript composite monorepo](https://github.com/tommedema/serverless-mono-example) - 带有 Typescript 3.0 复合引用的 Yarn / Lerna 工作区使用 `nohoist` 进行兼容的无服务器应用程序打包.
- [Next serverless](https://github.com/cyrilwanner/next-serverless) - 将您的 next.js 应用程序部署到 AWS Lambda.
- [Serverless Central](https://github.com/zotoio/serverless-central) - 样本 Lambda 单体仓库.
- [Tipe](https://tipe.io) - 下一代无服务器 CMS.
- [Spiderless](https://github.com/slashbit/spider-less) - 使用 Lambda、API 网关、DynamoDB 和 SNS 构建的网络蜘蛛/抓取工具/网站更改检测器.
- [PriceTrack](https://github.com/duyetdev/pricetrack)  - 用于电子商务价格跟踪的 API / 网站. 使用 Firebase 函数和 Firebase 托管构建.

## Related projects

- [FaaS boilerplates](https://github.com/hasura/cloud-functions-boilerplates) - 与 Hasura GraphQL 引擎的事件触发器结合使用的 FaaS 产品样板.
- [CloudCompose](https://cloudcompose.io) - 无服务器功能和工作流的开放社区市场.
- [Mutton](https://github.com/hmngwy/mutton) - 用于更好的 AWS Lambda 处理程序的 Python shim 库.
- [Begin](https://begin.com) - 使用数据库、会话和完整的 CI/CD 创建 AWS 无服务器应用程序、API 和站点.
- [Operiant](https://operiant.com) - 将您的事件流连接到操作.
- [TriggerMesh](https://triggermesh.com) - 具有事件触发器库的无服务器云可实现混合云和工作负载可移植性.
- [Handly](https://github.com/harijoe/handly) - 无服务器处理程序的包装器，以防止愚蠢的错误.
- [Serverless boilerplate](https://github.com/harijoe/serverless-boilerplate) - 最小但功能超级强大的无服务器样板.
- [Firecracker](https://github.com/firecracker-microvm/firecracker) - 用于无服务器计算的安全且快速的 microVM.
- [Cirrus](https://github.com/ucbrise/cirrus) - 无服务器机器学习框架.
- [OpenFaaS](https://docs.openfaas.com/) - 使 Docker 和 Kubernetes 变得简单的无服务器功能.
- [OpenFaaS Cloud](https://github.com/openfaas/openfaas-cloud) - OpenFaaS Cloud：由 git 驱动的多用户无服务器功能.

## Serverless Framework Plugins

- [Local environment](https://github.com/piercus/serverless-local-environment) - 设置本地环境变量.
- [Offline SSM](https://github.com/janders223/serverless-offline-ssm) - 从 `.env` 文件而不是 AWS 读取 SSM 参数.
- [Nocode](https://github.com/ServerlessOpsIO/serverless-nocode) - 通过无服务器框架部署 nocode.
- [Canary deployments](https://github.com/davidgf/serverless-plugin-canary-deployments) - 实施 AWS Lambda 函数的金丝雀部署.
- [Flow-based programming](https://github.com/p0wl/serverless-fbp) - 用于无服务器的基于流的编程插件.
- [Go serverless](https://github.com/thepauleh/goserverless)  - 用于无服务器框架的 GoFormation. 使用 Go 结构创建无服务器配置.
- [Event Gateway](https://github.com/serverless/serverless-event-gateway-plugin) - 无服务器框架的事件网关插件.
- [Fn](https://github.com/fnproject/serverless-fn) - Fn 供应商插件.
- [Cloudflare Workers](https://github.com/cloudflare/serverless-cloudflare-workers) - Cloudflare Workers 的提供商插件.
- [S3 Deploy](https://github.com/funkybob/serverless-s3-deploy) - 用于将文件部署到 S3 存储桶的插件.

## Literature / Education

- [Going serverless](https://leanpub.com/going-serverless) - 使用无服务器框架和 AWS Lambda 构建可扩展的应用程序.
- [AWS Lambda, Kinesis & Serverless Framework](https://www.udemy.com/code-along-aws-lambda-kinesis-serverless-framework/) - 关于无服务器框架的 Udemy 课程.
- [The Serverless Framework: Quick Start](http://codemore.teachable.com/p/serverless-framework-qs-node) - 提供无服务器框架快速入门的视频课程.
- [Intro to the Serverless Framework](http://codemore.teachable.com/p/serverless-framework-node) - 无服务器框架的介绍课程.
- [ServerlessLab](https://serverlesslab.com) - 有效的无服务器、AWS Lambda 和 Node.js 培训.
- [Serverless Applications with AWS](http://bit.ly/serverless-apps-aws)  - AWS 和无服务器框架的介绍课程. 使用最常见的 AWS 无服务器服务构建类似产品的应用程序.
- [Event Gateway Workshop](https://github.com/serverless/event-gateway-workshop) - 了解事件网关是什么、它是如何工作的并构建您的第一个事件驱动的多云应用程序.
- [Serverless streaming architectures](https://d1.awsstatic.com/serverless/Whitepaper/Stream%20Processing%20Whitepaper.pdf) - 无服务器流媒体架构和最佳实践.
- [Develop a Serverless Backend using Node.js on AWS Lambda](https://egghead.io/courses/develop-a-serverless-backend-using-node-js-on-aws-lambda) - 了解如何创建无服务器 API 并利用 Lambda 的新异步/等待语法将其连接到 DynamoDB.
- [Agile development for serverless platforms](https://www.manning.com/books/agile-development-for-serverless-platforms) - 如何在完全无服务器架构中应用敏捷实践.
- [AI as a Service](https://www.manning.com/books/ai-as-a-service) 一本教您如何利用基于云的 AI 服务和无服务器计算的力量的书. 无服务器 AI 的工程方法.

## Professional services

- [Cloudonaut](https://cloudonaut.io/serverless-consulting/) - 咨询.
- [PromptWorks](https://www.promptworks.com/serverless/) - 咨询.
- [Craftship](https://craftship.io) - 咨询.
- [EPX Labs](http://www.epxlabs.com) - 咨询.
- [Red Badger](https://red-badger.com) - 机构.
- [Langa](http://langa.io) - 机构.
- [Emerging Technology Advisors](https://www.emergingtechnologyadvisors.com) - 咨询.
- [OneSpeed](https://onespeed.io) - 机构.
- [Seraro](http://www.seraro.com) - 机构.
- [Superluminar](https://superluminar.io) - 机构.
