<div class="github-widget" data-repo="SE-ML/awesome-seml"></div>
## Awesome Software Engineering for Machine Learning [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://github.com/SE-ML/awesome-seml/blob/master/contributing.md)

机器学习软件工程是构建 ML 应用程序的技术和指南，这些应用程序不涉及核心 ML 问题——例如新算法的开发——而是围绕数据摄取、编码、测试、版本控制、部署、质量控制等周边活动，以及团队协作.
良好的软件工程实践可以使用机器学习组件增强生产级应用程序的开发、部署和维护.

⭐ 必读

科学出版物


<br>
基于这些文献，我们编制了一份关于对具有机器学习组件的应用程序采用软件工程实践的调查.


随意地 [take and share the survey](https://se-ml.github.io/survey) 并 [read more](https://se-ml.github.io/practices)!





## Broad Overviews

这些资源涵盖了方方面面.
- [AI Engineering: 11 Foundational Practices](https://resources.sei.cmu.edu/asset_files/WhitePaper/2019_019_001_634648.pdf) ⭐
- [Best Practices for Machine Learning Applications](https://pdfs.semanticscholar.org/2869/6212a4a204783e9dd3953f06e103c02c6972.pdf)
- [Engineering Best Practices for Machine Learning](https://se-ml.github.io/practices/) ⭐
- [Hidden Technical Debt in Machine Learning Systems](https://papers.nips.cc/paper/5656-hidden-technical-debt-in-machine-learning-systems.pdf) ⭐
- [Rules of Machine Learning: Best Practices for ML Engineering](https://developers.google.com/machine-learning/guides/rules-of-ml) ⭐
- [Software Engineering for Machine Learning: A Case Study](https://www.microsoft.com/en-us/research/publication/software-engineering-for-machine-learning-a-case-study/) ⭐


## Data Management

如何管理您在机器学习中使用的数据集.

- [A Survey on Data Collection for Machine Learning A Big Data - AI Integration Perspective_2019](https://deepai.org/publication/a-survey-on-data-collection-for-machine-learning-a-big-data-ai-integration-perspective) 
- [Automating Large-Scale Data Quality Verification](http://www.vldb.org/pvldb/vol11/p1781-schelter.pdf) 
- [Data management challenges in production machine learning](https://static.googleusercontent.com/media/research.google.com/en//pubs/archive/46178.pdf)
- [Data Validation for Machine Learning](https://mlsys.org/Conferences/2019/doc/2019/167.pdf) 
- [How to organize data labelling for ML](https://www.altexsoft.com/blognp/datascience/how-to-organize-data-labeling-for-machine-learning-approaches-and-tools/)
- [The curse of big data labeling and three ways to solve it](https://aws.amazon.com/blogs/apn/the-curse-of-big-data-labeling-and-three-ways-to-solve-it/)
- [The Data Linter: Lightweight, Automated Sanity Checking for ML Data Sets](http://learningsys.org/nips17/assets/papers/paper_19.pdf) 
- [The ultimate guide to data labeling for ML](https://www.cloudfactory.com/data-labeling-guide)


## Model Training

如何组织模型训练实验.

- [10 Best Practices for Deep Learning](https://nanonets.com/blog/10-best-practices-deep-learning/#track-model-experiments)
- [Apples-to-apples in cross-validation studies: pitfalls in classifier performance measurement](https://dl.acm.org/doi/abs/10.1145/1882471.1882479) 
- [Fairness On The Ground: Applying Algorithmic FairnessApproaches To Production Systems](https://scontent-amt2-1.xx.fbcdn.net/v/t39.8562-6/159714417_1180893265647073_4215201353052552221_n.pdf?_nc_cat=111&ccb=1-3&_nc_sid=ae5e01&_nc_ohc=6WFnNMmyp68AX95bRHk&_nc_ht=scontent-amt2-1.xx&oh=7a548f822e659b7bb2f58a511c30ee19&oe=606F33AD)🎓
- [How do you manage your Machine Learning Experiments?](https://medium.com/@hadyelsahar/how-do-you-manage-your-machine-learning-experiments-ab87508348ac)
- [Machine Learning Testing: Survey, Landscapes and Horizons](https://arxiv.org/pdf/1906.10742.pdf) 
- [Nitpicking Machine Learning Technical Debt](https://matthewmcateer.me/blog/machine-learning-technical-debt/)
- [On Comparing Classifiers: Pitfalls to Avoid and a Recommended Approach](https://link.springer.com/article/10.1023/A:1009752403260) ⭐
- [On human intellect and machine failures: Troubleshooting integrative machine learning systems](https://arxiv.org/pdf/1611.08309.pdf) 
- [Pitfalls and Best Practices in Algorithm Configuration](https://www.jair.org/index.php/jair/article/download/11420/26488/) 
- [Pitfalls of supervised feature selection](https://academic.oup.com/bioinformatics/article/26/3/440/213774) 
- [Preparing and Architecting for Machine Learning](https://www.gartner.com/en/documents/3889770/preparing-and-architecting-for-machine-learning-2018-upd)
- [Preliminary Systematic Literature Review of Machine Learning System Development Process](https://arxiv.org/abs/1910.05528) 
- [Software development best practices in a deep learning environment](https://towardsdatascience.com/software-development-best-practices-in-a-deep-learning-environment-a1769e9859b1)
- [Testing and Debugging in Machine Learning](https://developers.google.com/machine-learning/testing-debugging)
- [What Went Wrong and Why? Diagnosing Situated Interaction Failures in the Wild](https://www.microsoft.com/en-us/research/publication/what-went-wrong-and-why-diagnosing-situated-interaction-failures-in-the-wild/) 


## Deployment and Operation

如何在生产环境中部署和操作您的模型.

- [Best Practices in Machine Learning Infrastructure](https://algorithmia.com/blog/best-practices-in-machine-learning-infrastructure)
- [Building Continuous Integration Services for Machine Learning](http://pages.cs.wisc.edu/~wentaowu/papers/kdd20-ci-for-ml.pdf) 
- [Continuous Delivery for Machine Learning](https://martinfowler.com/articles/cd4ml.html) ⭐
- [Continuous Training for Production ML in the TensorFlow Extended (TFX) Platform](https://www.usenix.org/system/files/opml19papers-baylor.pdf) 
- [Fairness Indicators: Scalable Infrastructure for Fair ML Systems](https://ai.googleblog.com/2019/12/fairness-indicators-scalable.html) 
- [Machine Learning Logistics](https://mapr.com/ebook/machine-learning-logistics/)
- [Machine learning: Moving from experiments to production](https://blog.codecentric.de/en/2019/03/machine-learning-experiments-production/)
- [ML Ops: Machine Learning as an engineered disciplined](https://towardsdatascience.com/ml-ops-machine-learning-as-an-engineering-discipline-b86ca4874a3f)
- [Model Governance Reducing the Anarchy of Production](https://www.usenix.org/conference/atc18/presentation/sridhar) 
- [ModelOps: Cloud-based lifecycle management for reliable and trusted AI](http://hummer.io/docs/2019-ic2e-modelops.pdf)
- [Operational Machine Learning](https://www.kdnuggets.com/2018/04/operational-machine-learning-successful-mlops.html)
- [Scaling Machine Learning as a Service](http://proceedings.mlr.press/v67/li17a/li17a.pdf)🎓
- [TFX: A tensorflow-based Production-Scale ML Platform](https://dl.acm.org/doi/pdf/10.1145/3097983.3098021?download=true) 
- [The ML Test Score: A Rubric for ML Production Readiness and Technical Debt Reduction](https://research.google/pubs/pub46555/) 
- [Underspecification Presents Challenges for Credibility in Modern Machine Learning](https://arxiv.org/abs/2011.03395) 
- [Versioning for end-to-end machine learning pipelines](https://doi.org/10.1145/3076246.3076248) 



## Social Aspects

如何组织团队和项目以确保有效的协作和问责制.

- [Data Scientists in Software Teams: State of the Art and Challenges](http://web.cs.ucla.edu/~miryung/Publications/tse2017-datascientists.pdf) 
- [Machine Learning Interviews](https://github.com/chiphuyen/machine-learning-systems-design/blob/master/build/build1/consolidated.pdf)
- [Managing Machine Learning Projects](https://d1.awsstatic.com/whitepapers/aws-managing-ml-projects.pdf)
- [Principled Machine Learning: Practices and Tools for Efficient Collaboration](https://dev.to/robogeek/principled-machine-learning-4eho)


## Governance
- [A Human-Centered Interpretability Framework Based on Weight of Evidence](https://arxiv.org/pdf/2104.13299.pdf) 
- [An Architectural Risk Analysis Of Machine Learning Systems](https://berryvilleiml.com/docs/ara.pdf) 
- [Beyond Debiasing](https://complexdiscovery.com/wp-content/uploads/2021/09/EDRi-Beyond-Debiasing-Report.pdf)
- [Closing the AI Accountability Gap: Defining an End-to-End Framework for Internal Algorithmic Auditing](https://dl.acm.org/doi/pdf/10.1145/3351095.3372873) 
- [Inherent trade-offs in the fair determination of risk scores](https://arxiv.org/abs/1609.05807) 
- [Responsible AI practices](https://ai.google/responsibilities/responsible-ai-practices/) ⭐
- [Toward Trustworthy AI Development: Mechanisms for Supporting Verifiable Claims](https://arxiv.org/abs/2004.07213)
- [Understanding Software-2.0](https://dl.acm.org/doi/abs/10.1145/3453478) 

## Tooling

工具可以让您的生活更轻松.

我们仅共享开源工具或提供大量免费研究包的商业平台.

- [Aim](https://aimstack.io) - Aim 是一个开源实验跟踪工具.
- [Airflow](https://airflow.apache.org/) - 以编程方式创作、安排和监控工作流程.
- [Alibi Detect](https://github.com/SeldonIO/alibi-detect) - 专注于异常值、对抗性和漂移检测的 Python 库.
- [Archai](https://github.com/microsoft/archai) - 神经结构搜索.
- [Data Version Control (DVC)](https://dvc.org/) - DVC 是一种数据和 ML 实验管理工具.
- [Facets Overview / Facets Dive](https://pair-code.github.io/facets/) - 强大的可视化功能有助于理解机器学习数据集.
- [FairLearn](https://fairlearn.github.io/) - 评估和改进机器学习模型公平性的工具包.
- [Git Large File System (LFS)](https://git-lfs.github.com/) - 用 Git 中的文本指针替换大文件，例如数据集.
- [Great Expectations](https://github.com/great-expectations/great_expectations) - 通过管道集成进行数据验证和测试.
- [HParams](https://github.com/PetrochukM/HParams) - 一种用于机器学习项目配置管理的深思熟虑的方法.
- [Kubeflow](https://www.kubeflow.org/) - 为想要构建和试验 ML 管道的数据科学家提供的平台.
- [Label Studio](https://github.com/heartexlabs/label-studio) - 具有标准化输出格式的多类型数据标记和注释工具.
- [LiFT](https://github.com/linkedin/LiFT) - Linkedin 公平工具包.
- [MLFlow](https://mlflow.org/) - 管理 ML 生命周期，包括实验、部署和中央模型注册表.
- [Model Card Toolkit](https://github.com/tensorflow/model-card-toolkit)  - 简化和自动化模型卡的生成； 用于模型文档.
- [Neptune.ai](https://neptune.ai/) - 实验跟踪工具为数据科学项目带来组织和协作.
- [Neuraxle](https://github.com/Neuraxio/Neuraxle) - 用于深度学习项目中的超参数调整和 AutoML 的类似 Sklearn 的框架.
- [OpenML](https://www.openml.org) - 为机器学习构建开放、有组织的在线生态系统的包容性运动.
- [PyTorch Lightning](https://github.com/PyTorchLightning/pytorch-lightning)  - 用于高性能 AI 研究的轻量级 PyTorch 包装器. 缩放模型，而不是样板.
- [REVISE: REvealing VIsual biaSEs](https://github.com/princetonvisualai/revise-tool) - 自动检测视觉数据集中的偏差.
- [Robustness Metrics](https://github.com/google-research/robustness_metrics) - 用于评估分类模型稳健性的轻量级模块.
- [Seldon Core](https://github.com/SeldonIO/seldon-core) - 一个 MLOps 框架，用于在 Kubernetes 上打包、部署、监控和管理数以千计的生产机器学习模型.
- [Spark Machine Learning](https://spark.apache.org/mllib/) - Spark 的 ML 库，包含常见的学习算法和实用程序.
- [TensorBoard](https://www.tensorflow.org/tensorboard/) - TensorFlow 的可视化工具包.
- [Tensorflow Extended (TFX)](https://www.tensorflow.org/tfx/) - 用于部署生产 ML 管道的端到端平台.
- [Tensorflow Data Validation (TFDV)](https://github.com/tensorflow/data-validation)  - 用于探索和验证机器学习数据的库. 类似于 Great Expectations，但用于 Tensorflow 数据.
- [Weights & Biases](https://www.wandb.com/) - 实验跟踪、模型优化和数据集版本控制.


## Contribute

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/SE-ML/awesome-seml/blob/master/contributing.md) 第一
