<div class="github-widget" data-repo="seed-rs/awesome-seed-rs"></div>
<!--lint disable double-link-->

## Awesome Seed RS [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

<p align="center">
    <a href="https://seed-rs.org/">
        <img src="https://raw.githubusercontent.com/seed-rs/seed-rs.org/81ed1acc77062ede3295683f21f2d39611843192/seed_branding/seed_logo.min.svg" width="256" title="Seed logo">
    </a>
</p>

&gt; 与 Seed 相关的精选清单

[Seed](https://seed-rs.org/) 是一个开源 Rust 框架，用于创建在 WebAssembly 中运行的快速可靠的 Web 应用程序.

欢迎投稿. 通过拉取请求添加链接或创建问题以开始讨论.



## Official Resources

- [Homepage](https://seed-rs.org/)
- [GitHub repo](https://github.com/seed-rs/seed)
- [Forum](https://seed.discourse.group)
- [Chat](https://discord.gg/JHHcHp5)

## Books
- [Engineering Rust Web Applications](https://erwabook.com/) - 柴油、火箭和种子.
- [Porting a JS app to Rust](https://slowtec.de/posts/2019-12-20-porting-javascript-to-rust-part-1.html) - 使用 Rust 将 JavaScript 应用程序移植到 WebAssembly（博客系列）.

## Quickstarts

- [Default quickstart](https://github.com/seed-rs/seed-quickstart) - 仅包含 Rust 库.
- [Quickstart with Webpack](https://github.com/seed-rs/seed-quickstart-webpack) - 主要特点：自动重新加载、预渲染、缩小， [TailwindCSS](https://tailwindcss.com/), 打字稿.

## Bundlers

- [Trunk](https://github.com/thedodd/trunk) - 用于 Rust 的 WASM Web 应用程序捆绑器.
- [Web Bundler](https://github.com/panoptix-za/web-bundler) - 捆绑用于发布的种子 SPA.
- [Seeder](https://github.com/MartinKavik/seeder) - 设置种子应用程序并通过运行一个命令启动开发服务器.

## Examples

- [RealWorld example](https://github.com/seed-rs/seed-rs-realworld) - “所有演示应用程序之母”— Exampleary fullstack [Medium.com](https://medium.com/) 克隆.
- [Dark lang Realworld](https://github.com/MartinKavik/seed-realworld-darklang) - 在 _Quickstart with Webpack_ 上使用集成的种子 Realworld 示例 [Dark lang](https://darklang.com/) 真实世界.
- [Official examples](https://github.com/seed-rs/seed/tree/master/examples) - 官方回购中包含的较小示例.
- [ERWA mytodo](https://github.com/seed-rs/erwa_mytodo)  - Rust 全栈示例. 柴油，火箭，种子.
- [Template for GUIs with seed+gotham](https://gitlab.com/liketechnik/local-gui-seed-gotham) - 类似 Electron 的本地/桌面 GUI 模板，带有 Gotham、rust-embed、web-view 和 Seed.
- [Seeded Game of Life](https://github.com/arn-the-long-beard/seeded_game_of_life) - 生活游戏 [tutorial](https://dev.to/arnthelongbeard/how-to-only-rust-for-web-frontend-1026) 在纯粹的 Rust 中，灵感来自 [wasm tutorial](https://rustwasm.github.io/docs/book/).
- [Dota Underlord Perfect Build](https://github.com/warycat/dotawasm) - 帮助在 Dota Underlord 中构建最佳卡组的应用程序.
- [Play Seed](https://ide.play-seed.dev) - 带有几个默认示例的游乐场.

## Projects Using Seed

- [AdEx Explorer](https://github.com/adexnetwork/adex-explorer) - 显示有关 AdEx 广告协议支付渠道网络的精选信息.
- [Kavik.cz](https://github.com/MartinKavik/kavik.cz) - 开源个人网站.
- [benxu.dev/blog](https://github.com/AlterionX/benxu-dev)  - 一个比较简单的开源个人博客. 建立在 [`Seed`](https://seed-rs.org/), [`maud`](https://maud.lambda.xyz), [`Rocket`](https://rocket.rs)， 和 [`Diesel`](https://diesel.rs).
- [seed-rs.org](https://github.com/seed-rs/seed-rs.org) - 种子的官方网站.
- [WeightRS](https://gitlab.com/mkroehnert/weightrs) - 用于跟踪您的体重的简约且隐私友好的渐进式网络应用程序.
- [Music composer](https://github.com/ethanboxx/planters-rdconf-hackathon-project) - 一个基本的音乐创作应用程序.
- [Play Seed](https://play-seed.dev) - 关于 Play Seed 的网站，用于演示 Seed 应用程序的游乐场.
- [Typesync](https://typesync.rutrum.net)  - 测试你在歌词上的打字速度. 用途 [`Seed`](https://seed-rs.org/), [`Rocket`](https://rocket.rs)， 和 [`Diesel`](https://diesel.rs).
- [CalcuPi](https://dvjn.github.io/CalcuPi) - 一个漂亮的蒙特卡洛模拟，用于近似 pi 的值.
- [Love Letter Tracker](https://www.fosskers.ca/en/tools/love-letter) - 纸牌游戏_情书_的知识追踪器.
- [Whatlang.org](https://whatlang.org/) - whatlang（语言识别库）的交互式演示.
- [Pslink](https://pslink.teilgedanken.de) - 专注于在出版物中使用的 URL 缩短页面（[demo](https://demo.pslink.teilgedanken.de/app/)  （用户、密码：demo））. 用途 [`Seed`](https://seed-rs.org/), [`actix-web`](https://actix.rs/)， 和 [`sqlx`](https://github.com/launchbadge/sqlx).

## Libraries

- [Savory](https://gitlab.com/MAlrusayni/savory) - 基于种子构建用户界面的库.
- [seed-icons](https://crates.io/crates/seed-icons) - 包含图标集合的库，以包含在基于种子的应用程序中.
- [Seed Bootstrap](https://github.com/panoptix-za/seed-bootstrap) - 的集合 [Bootstrap](https://getbootstrap.com/) CSS 组件.
- [seed_heroicons](https://github.com/mh84/seed_heroicons) - 图书馆提供 [Heroicons](https://heroicons.com/) 包含到基于种子的应用程序中.

## Contribute

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/seed-rs/awesome-seed-rs/blob/master/contributing.md) 第一的.
