<div class="github-widget" data-repo="Famolus/awesome-sass"></div>
![Awesome Sass](https://raw.githubusercontent.com/Famolus/awesome-sass/master/awesome-sass-logo-github.png)

## Awesome Sass [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; 精选清单 [Sass](http://sass-lang.com/) 和 [SCSS](http://sass-lang.com/) frameworks, libraries, style guides, articles, 和 resources.

- 使用<kbd>command</kbd> + <kbd>F</kbd>或<kbd>ctrl</kbd> + <kbd>F</kbd>搜索关键字.
- 欢迎投稿，请参阅 [contribution guide](https://github.com/Famolus/awesome-sass/blob/master/contributing.md).


## About
[Sass](http://sass-lang.com/) 是 CSS 的扩展，为基本语言增添了力量和优雅. 它允许您使用变量、嵌套规则、混合、内联导入等，所有这些都具有完全 CSS 兼容的语法.  Sass 有助于保持大型样式表井井有条，并使小型样式表快速启动和运行.

 Sass 有两种语法. 新的主要语法（从 Sass 3 开始）被称为“SCSS”（“Sassy CSS”），是 CSS 语法的超集. 这意味着每个有效的 CSS 样式表也是有效的 SCSS.  SCSS 文件使用扩展名 .scss .

第二种较旧的语法称为缩进语法（或简称为“Sass”）. 受 Haml 的简洁性启发，它适用于喜欢简洁而不是 CSS 相似性的人. 它不使用方括号和分号，而是使用行的缩进来指定块. 虽然不再是主要语法，但缩进语法将继续受到支持. 缩进语法中的文件使用扩展名“.sass”.

## Getting Started
- [Official Sass and SCSS Guide](http://sass-lang.com/guide) - 官方 Sass 和 SCSS 指南.
- [Tutorialzine](http://tutorialzine.com/2016/01/learn-sass-in-15-minutes/) - 在 15 分钟教程中学习 SASS.
- [Codecademy](https://www.codecademy.com/learn/learn-sass) - 通过 Codecademy 学习 Sass.
- [Lynda](https://www.lynda.com/SASS-training-tutorials/1435-0.html) - 通过行业专家教授的在线视频教程，了解如何使用 Sass，从初学者基础知识到高级技术.
- [Official Sass and SCSS Reference](http://sass-lang.com/documentation/file.SASS_REFERENCE.html) - 官方 Sass 和 SCSS 文档参考.
- [SitePoint Sass and SCSS Reference](https://www.sitepoint.com/sass-reference/) - SitePoint Sass 和 SCSS 参考.

## Sass vs SCSS
- [SitePoint](https://www.sitepoint.com/whats-difference-sass-scss/) - Sass 和 SCSS 有什么区别？
- [The Sass Way](http://thesassway.com/editorial/sass-vs-scss-which-syntax-is-better) - 哪种语法更好？
- [Stack Overflow](http://stackoverflow.com/questions/5654447/whats-the-difference-between-scss-and-sass) - SCSS 和 Sass 有什么区别？

## Frameworks
- [avalanche](https://avalanche.oberlehner.net) - 为基于包的 CSS 工作流程构建基础的框架.
- [Bootstrap 4](https://github.com/twbs/bootstrap) - Bootstrap 版本 4，最流行的 HTML、CSS 和 JS 框架，用于在 Web 上开发响应式、移动优先的项目.
- [Bootstrap-sass](https://github.com/twbs/bootstrap-sass) - Bootstrap 2 和 3 的官方 Sass 端口.
- [Bulma](https://github.com/jgthms/bulma) - 基于 Flexbox 的现代 CSS 框架.
- [Cirrus](https://github.com/Spiderpig86/Cirrus) - 一个以组件和实用程序为中心的 SCSS 框架，专为快速原型设计而设计.
- [Foundation for Sites](https://github.com/zurb/foundation-sites)  - 世界上最先进的响应式前端框架. 为可在任何类型的设备上运行的站点快速创建原型和生产代码.
- [Hocus-Pocus](https://bkzl.github.io/hocus-pocus/) - 通用且轻量级的样式表入门套件，专注于基本 html 元素和排版.
- [iotaCSS](https://www.iotacss.com) - 为扩展而构建的基于 Sass 的开源 OOCSS 框架.
- [Kickoff](http://trykickoff.com) - Kickoff 是一个轻量级的前端框架，用于创建可扩展、高性能和响应迅速的网站.
- [Materialize](http://materializecss.com) - 基于 Material Design 的现代响应式前端框架.
- [mini.css](http://minicss.org/) - 最小的、响应式的、风格不可知的 CSS 框架.
- [Scooter](http://dropbox.github.io/scooter/) - SCSS 框架旨在为 Dropbox 提供基本样式、CSS 组件和快速静态原型制作.
- [Sierra](http://sierra-library.github.io/) - 微型 SCSS 库可帮助您构建网站，无需所有任意选择器.

## Libraries and Mixins

### Grid
- [Avalanche](http://colourgarden.net/avalanche) - 轻量级、响应式、基于 Sass 的 BEM 语法网格系统.
- [csswizardry-grids](http://csswizardry.com/csswizardry-grids/) - 简单、流畅、可嵌套、灵活、基于 Sass 的响应式网格系统.
- [Griddle](http://necolas.github.io/griddle/) - Extremely flexable CSS grid constructor.
- [Gridlex](http://gridlex.devlint.fr/) - Flexbox 网格系统.
- [Jeet](https://github.com/mojotech/jeet) - Sass 和 Stylus 的简单分数网格系统.
- [Neat](http://neat.bourbon.io/) - 使用 Sass 构建的轻量级语义网格框架.
- [Sass Flexible Grid System](https://dnomak.com/flexiblegs/install/sass/) - Sass 灵活的网格系统.
- [SCSS Flexible Grid System](https://dnomak.com/flexiblegs/install/scss/) - SCSS 灵活的网格系统.
- [Susy](https://github.com/oddbird/susy) - Sass 的响应式布局工具包.
- [Toast](http://daneden.github.io/Toast/) - 来自创建者的灵活轻便的网格框架 [animate.css](https://daneden.github.io/animate.css/).
- [Waffle Grid](https://lucasgruwez.github.io/waffle-grid/) - 易于使用的 flexbox 网格系统.

### Media Queries
- [Breakpoint](https://github.com/at-import/breakpoint) - 断点使得在 Sass 中编写媒体查询变得超级简单.
- [include-media](https://eduardoboucas.github.io/include-media/) - 简单、优雅和可维护的媒体查询.
- [mq-scss](https://github.com/Dan503/mq-scss) - 一个极其强大但易于使用的 Sass 媒体查询混合.
- [Sass MediaQueries](http://rafalbromirski.github.io/sass-mediaqueries/) - 为 Sass（包括 iOS 设备、电视等）收集有用的媒体查询混合.
- [Sass MQ](https://github.com/sass-mq/sass-mq) - Sass mixin 可帮助您以优雅的方式编写媒体查询.

### Color
- [brand-colors](http://brand-colors.com/) - Sass、Less、Stylus 和 CSS 中提供的 1100 多种流行品牌颜色.
- [Open color](https://github.com/yeun/open-color)  - Open color是UI设计的配色方案. 适用于 CSS、SCSS、LESS、Stylus、Adobe 库、Photoshop/Illustrator 色板和 Sketch 调色板.
- [sass-planifolia](https://github.com/xi/sass-planifolia) - 香草 Sass 中的高级颜色处理和对比度计算.
- [scss-blend-modes](https://github.com/heygrady/scss-blend-modes) - 在 Sass 中使用标准颜色混合函数.

### Typography
- [Sassline](https://sassline.com/) - 使用 Sass &amp; rems 使用响应式模块化比例将 Web 上的文本设置为基线网格.
- [Sassy-Gridlover](https://github.com/hiulit/Sassy-Gridlover)  - 超级好用的 Sass mixins 来建立一个具有模块化比例和垂直韵律的排版系统. 基于 Gridlover 应用程序.
- [Shevy](http://kyleshevlin.github.io/shevy/)  - 排版变得容易. 垂直节奏库.
- [Typi](https://github.com/zellwk/typi) - Sass mixin 使响应式排版变得容易.

### Animation
- [Animate.scss](https://github.com/geoffgraham/animate.scss) - 丹伊登港 [Animate.css](https://daneden.github.io/animate.css/) 对于SASS.
- [Hover](http://ianlunn.github.io/Hover/)  - CSS3 驱动的悬停动画效果集合，可应用于链接、按钮、徽标、SVG、特色图像等. 在 CSS、Sass 和 LESS 中可用.
- [Kf](https://kf-sass.com) - Sass mixin 库，用于从地图创建基于关键帧的动画.
- [Sass Burger](https://github.com/jorenvanhee/sass-burger) - 用于创建动画汉堡包图标的 Sass mixin.
- [SpinThatShit](https://matejkustec.github.io/SpinThatShit/) - 用于单个元素加载器和微调器的 SCSS 混合集.

### Miscellaneous
- [Angled Edges](https://github.com/josephfusco/angled-edges) - Sass mixin 用于通过动态编码 SVG 在部分上创建有角度的边缘.
- [Bourbon](http://bourbon.io/) - Sass 的简单轻量级 mixin 库.
- [Buttono](https://github.com/hsnaydd/buttono) - 用于创建 BEM 样式按钮的灵活 Sass 混合.
- [Buttons](https://github.com/alexwolfe/Buttons) - 使用 Sass 和 Compass 构建的 CSS 按钮库.
- [csstyle](https://csstyle.io) - 一个 SCSS 库，可帮助您构建模块化 CSS，为您生成选择器并自动处理特异性.
- [Family.scss](http://lukyvj.github.io/family.scss/) - 一组 26 个智能 Sass mixin，将帮助您以简单而优雅的方式管理 :nth-child&#39;ified 元素的样式.
- [Gerillass](https://gerillass.com/) - 帮助您创建现代网站的 Sass mixin 库.
- [Juice](http://kylebrumm.com/juice/) - Sass 混入和函数的集合.
- [Modular Scale](https://github.com/modularscale/modularscale-sass) - 内置于 Sass 中的模块化比例计算器.
- [normalize-scss](https://github.com/JohnAlbin/normalize-scss) - Normalize.css 的 Sass/Compass 版本，HTML 元素和属性规则集的集合，用于规范所有浏览器的样式.
- [Pretty checkbox](https://github.com/lokesh-coder/pretty-checkbox) - 用于美化复选框和单选按钮的 SCSS/CSS 库.
- [retina.js](https://github.com/imulus/retinajs) - 用于呈现高分辨率图像变体的 JavaScript、SCSS、Sass、Less 和 Stylus 助手.
- [Sass Accoutrement](http://oddbird.net/open-source/accoutrement/)  - 装备模块是 Sass 工具包，它们一起工作以形成项目的中央配置. 这些工具可以单独使用，也可以集成使用以提供额外的功能.
- [Sass Deprecate](https://github.com/salesforce-ux/sass-deprecate) - 有助于管理代码弃用的 Sass mixin.
- [Sass flexbox mixin](https://github.com/mastastealth/sass-flex-mixin) - 为那些想使用当前浏览器的本机支持来摆弄 flexbox 的人准备的混合集.
- [Sassdash](https://github.com/davidkpiano/sassdash) - lodash 的 Sass 实现 ([API documentation](http://davidkpiano.github.io/sassdash)).
- [Scut](https://github.com/davidtheclark/scut) - 收集 Sass 实用程序，以简化和改进常见样式代码模式的实现.

## Style Guides
- [Hugo Giraudel's Sass Guidelines](https://sass-guidelin.es/) - 编写合理、可维护和可扩展的 Sass 的指南.
- [BigCommerce Sass Coding Guidelines](https://github.com/bigcommerce/sass-style-guide) - BigCommerce 使用指南.
- [Airbnb Sass and CSS Style Guide](https://github.com/airbnb/css) - Airbnb 的 Sass 和 CSS 风格指南.
- [Dropbox (S)CSS Style Guide](https://github.com/dropbox/css-style-guide) - Dropbox 的 (S)CSS 创作风格指南.

## Articles
- [Hugo Giraudel Personal Awesome Sass List](https://github.com/HugoGiraudel/awesome-sass) - Hugo Giraudel 在 Sass 上的工作记录.
- [Cubic Bézier Representation in Sass](http://thesassway.com/advanced/cubic-bezier-representation-in-sass)
- [Faster Sass builds with Webpack](http://eng.localytics.com/faster-sass-builds-with-webpack/)
- [Transitioning to SCSS at Scale](https://codeascraft.com/2015/02/02/transitioning-to-scss-at-scale/)
- [Sass Maps to UI Components](https://blog.prototypr.io/sass-maps-to-ui-components-f14e1f34412e#.9zt0s0rxt)
- [Inverse trigonometric functions with Sass](http://thesassway.com/advanced/inverse-trigonometric-functions-with-sass)
- [Stop Arguing So Much with Your Mixins](http://sassbreak.com/stop-arguing-with-your-mixins)
- [Styling React Components in Sass](http://hugogiraudel.com/2015/06/18/styling-react-components-in-sass/)
- [A Sass !default use case](https://robots.thoughtbot.com/sass-default)
- [Aesthetic Sass 3: Typography and Vertical Rhythm](https://scotch.io/tutorials/aesthetic-sass-3-typography-and-vertical-rhythm)
- [A Tale of CSS and Sass Precision](https://www.sitepoint.com/a-tale-of-css-and-sass-precision/)
- [Build a Style Guide Straight from Sass](https://css-tricks.com/build-style-guide-straight-sass/)
- [Advanced SCSS, or, 16 cool things you may not have known your stylesheets could do](https://gist.github.com/jareware/4738651)
- [The 80-20 Approach to Sustainable SCSS](https://zendev.com/2018/05/30/the-80-20-approach-to-sustainable-scss.html)
- [Advanced Use of Sass Maps](https://itnext.io/advanced-use-of-sass-maps-bd5a47ca0d1a)

## Tools
- [dart-sass](https://github.com/sass/dart-sass) - Sass 的 Dart 实现.
- [diamond](https://diamond.js.org) - 为 Sass、Less 和 CSS 构建的依赖管理.
- [libsass-python](https://github.com/dahlia/libsass-python) - 为 Python 绑定 libsass.
- [libsass](https://github.com/sass/libsass) - Sass 编译器的 C/C++ 实现.
- [node-sass-magic-importer](https://github.com/maoberlehner/node-sass-magic-importer) - 用于选择器特定导入、节点导入、模块导入、globbing 支持和仅导入文件一次的自定义 node-sass 导入器.
- [node-sass](https://github.com/sass/node-sass) - Node.js 绑定到 libsass.
- [OctoLinker](https://github.com/OctoLinker/browser-extension) - 使用 GitHub 的 OctoLinker 浏览器扩展高效地浏览 *.scss 和 *.sass 文件.
- [sass-extract](https://github.com/jgranstrom/sass-extract)  - 从 scss 文件中提取变量. 通过将计算出的样式提取到 js 对象中，使用 scss 来描述在 javascript 中使用的样式. 支持导入和高级语言功能.
- [sass-loader](https://github.com/jtangelder/sass-loader) - 用于 webpack 的 Sass 加载器.
- [sass-rails](https://github.com/rails/sass-rails) - Sass 的 Ruby on Rails 样式表引擎.
- [SassDoc](http://sassdoc.com/) - 文档系统（如 JSDoc for JavaScript）可在眨眼间构建漂亮而强大的文档.
- [Scout-App](http://scout-app.io/) - 无需任何命令行知识即可将 Sass 和 SCSS 文件处理成 CSS.
- [scss-lint](https://github.com/brigade/scss-lint) - 用于编写干净一致的 SCSS 的可配置工具. [(deprecated)](https://github.com/brigade/scss-lint#notice-consider-other-tools-before-adopting-scss-lint)
- [SharpScss](https://github.com/xoofx/SharpScss) - P/调用 libsass 周围的 .NET 包装器以将 SCSS 转换为支持 NET2.0/NET3.5/NET4.x+ 和 CoreCLR 平台的 CSS.
- [stylelint](https://stylelint.io/)  - 一个强大的现代 CSS linter，可帮助您执行一致的约定并避免样式表中的错误. 支持类似 CSS 的语法，包括 SCSS.

## Books
- [Sass in the Real World: Book I of IV](https://anotheruiguy.gitbooks.io/sassintherealworld_book-i/content/)
- [Sass in the Real World: Book II of IV](https://anotheruiguy.gitbooks.io/sass-in-the-real-world-book-2-of-4/content/)
- [Jump Start Sass: Get Up to Speed With Sass in a Weekend](https://www.amazon.com/Jump-Start-Sass-Speed-Weekend/dp/0994182678)
- [Sass and Compass for Designers](https://www.amazon.com/Sass-Compass-Designers-Ben-Frain/dp/1849694540)

## Videos
- [Sass Tutorial](https://www.youtube.com/watch?v=wz3kElLbEHE)
- [Series of Sass tutorials showing the installing of, the basics, and using key features](https://www.youtube.com/playlist?list=PL2CB1F80266E986EA)
- [Sass or LESS? What should you use?](https://www.youtube.com/watch?v=lJclQekSfSM)
- [Learn Sass in this Free Crash Course - Give your CSS Superpowers!](https://www.youtube.com/watch?v=roywYSEPSvc)
- [The Net Ninja Sass playlist](https://www.youtube.com/watch?v=St5B7hnMLjg&list=PL4cUxeGkcC9iEwigam3gTjU_7IA3W2WZA)

## Community
- [Reddit](https://www.reddit.com/r/Sass/)
- [Stack Overflow](http://stackoverflow.com/questions/tagged/sass)
- [@SassCSS on Twitter](https://twitter.com/SassCSS)

## License
[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)
