<div class="github-widget" data-repo="Kiloreux/awesome-robotics"></div>
Awesome Robotics
================

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

This is a list of various books, courses and other resources for robotics. It's an attempt to gather useful material in one place for everybody who wants to learn more about the field.


### Courses ###
* [Artificial Intelligence for Robotics](https://www.udacity.com/course/artificial-intelligence-for-robotics--cs373) **Udacity**
* [Robotics Nanodegree](https://www.udacity.com/course/robotics-software-engineer--nd209) **Udacity** :dollar:
* [Autonomous Mobile Robots](https://courses.edx.org/courses/course-v1:ETHx+AMRx+2T2019/5b151c51e8bf47c29d97f8a12369df17/) **edX**
* [Underactuated Robotics](http://underactuated.csail.mit.edu/underactuated.html) **MIT CSAIL**
* [Autonomous Mobile Robots](https://courses.edx.org/courses/ETHx/AMRx/1T2014/info) **edX**
* [Robot Mechanics and Control, Part I](https://www.edx.org/course/robot-mechanics-control-part-i-snux-snu446-345-1x) **edX**
* [Robot Mechanics and Control, Part II](https://www.edx.org/course/robot-mechanics-control-part-ii-snux-snu446-345-2x) **edX**
* [Autonomous Navigation for Flying Robots](https://www.edx.org/course/autonomous-navigation-flying-robots-tumx-autonavx-0) **edX**
* [Robotics Specialization by GRASP Lab](https://www.coursera.org/specializations/robotics) **Coursera** :dollar:
* [Control of Mobile Robots](https://www.coursera.org/course/conrob) **Coursera**
* [QUT Robot Academy](https://robotacademy.net.au/) **QUT**
* [Robotic vision](https://www.qut.edu.au/study/short-courses-and-professional-development/short-courses/robotic-vision) **QUT**
* [Introduction to robotics](http://ocw.mit.edu/courses/mechanical-engineering/2-12-introduction-to-robotics-fall-2005/) **MIT**
* [Robotics: Vision Intelligence and Machine Learning](https://www.edx.org/course/robotics-vision-intelligence-machine-pennx-robo2x) **edX**
* [Applied robot design](https://www.youtube.com/user/StanfordCS235/videos) **Stanford University**
* [Introduction to Robotics](https://see.stanford.edu/Course/CS223A) **Stanford University**
* [Introduction to Mobile Robotics](http://ais.informatik.uni-freiburg.de/teaching/ss16/robotics/index_en.php) **University of Freiburg**
* [Robotics](https://www.edx.org/micromasters/pennx-robotics) **edx** :dollar:
* [Columbia Robotics](https://www.edx.org/course/robotics-columbiax-csmm-103x-2) **edx** 
* [Modern Robotics: Mechanics, Planning, and Control](https://www.coursera.org/specializations/modernrobotics?) **Coursera**
* [Hello (Real) World with ROS – Robot Operating System](https://www.edx.org/course/hello-real-world-with-ros-robot-operating-system-2) **edx**
* [Advanced Robotics](https://people.eecs.berkeley.edu/~pabbeel/cs287-fa19/) **UCBerkeley**
* [Building Arduino robots and devices](https://www.coursera.org/learn/arduino) **Coursera**
* [Introduction to The Robot Operating System (ROS2)](https://www.coursera.org/projects/ros2-intro) **Coursera**
* [Modern Robotics: Mechanics, Planning, and Control Specialization](https://www.coursera.org/specializations/modernrobotics) **Coursera**
* [Become a Robotics Software Enginee](https://www.udacity.com/course/robotics-software-engineer--nd209) **Udacity**
* [Advanced Robotics](http://www.cs.berkeley.edu/~pabbeel/cs287-fa13/) **UC Berkeley**
* [Self-Driving Cars with Duckietown](https://www.edx.org/learn/technology/eth-zurich-self-driving-cars-with-duckietown) **edX**

### Books ###
* [Probabilistic Robotics (Intelligent Robotics and Autonomous Agents series)](http://www.amazon.com/Probabilistic-Robotics-Intelligent-Autonomous-Agents/dp/0262201623/)  :dollar:
* [Introduction to Autonomous Mobile Robots (Intelligent Robotics and Autonomous Agents series)](http://www.amazon.com/Introduction-Autonomous-Mobile-Intelligent-Robotics/dp/0262015358/)  :dollar:
* [Springer Handbook of Robotics](https://www.amazon.com/Springer-Handbook-Robotics-Handbooks/dp/3319325507/)  :dollar:
* [Planning Algorithms](http://planning.cs.uiuc.edu/)
* [A gentle introduction to ROS](https://cse.sc.edu/~jokane/agitr/agitr-letter.pdf)
* [A Mathematical Introduction to Robotic Manipulation](http://www.cds.caltech.edu/~murray/mlswiki/?title=First_edition)
* [Learning Computing With Robots](http://wiki.roboteducation.org/Introduction_to_Computer_Science_via_Robots)
* [Robotics, Vision and Control: Fundamental Algorithms in MATLAB (Springer Tracts in Advanced Robotics)](http://www.amazon.com/Robotics-Vision-Control-Fundamental-Algorithms/dp/3642201431)  :dollar:
* [INTECH Books](http://www.intechopen.com/subjects/robotics)
* [Introduction to Autonomous Robots](https://github.com/correll/Introduction-to-Autonomous-Robots/releases)
* [Principles of Robot Motion: Theory, Algorithms, and Implementations ](https://www.amazon.com/Principles-Robot-Motion-Implementations-Intelligent/dp/0262033275):dollar:
* [Introduction to Modern Robotics: Mechanics, Planning, and Control](http://hades.mech.northwestern.edu/index.php/LynchAndPark) [[pdf](http://hades.mech.northwestern.edu/images/7/7f/MR.pdf)]
* [Programming Robots with ROS: A Practical Introduction to the Robot Operating System](https://www.amazon.com/Programming-Robots-ROS-Practical-Introduction/dp/1449323898/) :dollar:
* [Learning ROS for Robotics Programming](https://www.amazon.com/Learning-ROS-Robotics-Programming-Second/dp/1783987588) :dollar:
* [Mastering ROS for Robotics Programming](https://www.amazon.com/Mastering-Robotics-Programming-Lentin-Joseph/dp/1783551798) :dollar:
* [Behavior Trees in Robotics and AI: An Introduction](https://btirai.github.io/) [[pdf](https://arxiv.org/pdf/1709.00084)]
* [Automated Planning and Acting](http://projects.laas.fr/planning/) [[pdf](http://projects.laas.fr/planning/book.pdf)]
* [Robotics for Software Engineers](https://www.manning.com/books/robotics-for-software-engineers) :dollar:


### Software and Libraries ###
[**Gazebo**](http://gazebosim.org/)
Robot Simulator

[**ROS**](http://www.ros.org/)
The Robot Operating System (ROS) is a flexible framework for writing robot software. It is a collection of tools, libraries, and conventions that aim to simplify the task of creating complex and robust robot behavior across a wide variety of robotic platforms.

[**ROS2**](https://index.ros.org/doc/ros2/)
ROS2 is a new version of ROS with radical design changes and improvement over older ROS version.

[**RobWork**](http://www.robwork.dk/apidoc/nightly/rw/)
RobWork is a collection of C++ libraries for simulation and control of robot systems. RobWork is used for research and education as well as for practical robot applications.

[**MRPT**](http://www.mrpt.org/)
Mobile Robot Programming Toolkit provides developers with portable and well-tested applications and libraries covering data structures and algorithms employed in common robotics research areas.

[**Robotics Library**](http://www.roboticslibrary.org/)
The Robotics Library (RL) is a self-contained C++ library for robot kinematics, motion planning and control. It covers mathematics, kinematics and dynamics, hardware abstraction, motion planning, collision detection, and visualization.

[**Simbad**](http://simbad.sourceforge.net/)
2D/3D simulator in Java and Jython.

[**Morse**](https://www.openrobots.org/wiki/morse/)
General purpose indoor/outdoor 3D simulator.

[**Carmen**](http://carmen.sourceforge.net/)
CARMEN is an open-source collection of software for mobile robot control. CARMEN is modular software designed to provide basic navigation primitives including: base and sensor control, logging, obstacle avoidance, localization, path planning, and mapping.

[**Peekabot**](http://www.peekabot.org/)
Peekabot is a real-time, networked 3D visualization tool for robotics, written in C++. Its purpose is to simplify the visualization needs faced by a roboticist daily.

[**YARP**](http://www.yarp.it/)
Yet Another Robot Platform.

[**V-REP**](http://www.coppeliarobotics.com/)
Robot simulator, 3D, source available, Lua scripting, APIs for C/C++, Python, Java, Matlab, URBI, 2 physics engines, full kinematic solver.

[**Webots**](https://www.cyberbotics.com/overview)
Webots is a development environment used to model, program and simulate mobile robots.

[**Drake**](http://drake.mit.edu/)
A planning, control and analysis toolbox for nonlinear dynamical systems.

[**Neurorobotics Platform (NRP)**](https://neurorobotics.net/)
An Internet-accessible simulation system that allows the simulation of robots controlled by spiking neural networks.

[**The Player Project**](http://playerstage.sourceforge.net/)
Free Software tools for robot and sensor applications

[**Open AI's Roboschool**](https://github.com/openai/roboschool)
Open-source software for robot simulation, integrated with OpenAI Gym.

[**ViSP**](http://visp.inria.fr/)
Open-source visual servoing platform library, is able to compute control laws that can be applied to robotic systems.

[**ROS Behavior Trees**](https://github.com/miccol/ROS-Behavior-Tree)
Open-source library to create robot's behaviors in form of Behavior Trees running in ROS (Robot Operating System).

[**g2core**](https://github.com/synthetos/g2)
Open-source motion control software for CNC and Robotics, designed to run on Arduino Due class microcontrollers.

[**ur5controller**](https://github.com/roboticsleeds/ur5controller)
Open-source OpenRAVE controller for UR5 robot integrated with ROS.

[**RBDL**](https://github.com/rbdl/rbdl)
Open-source (zlib) C++ libray for both forward and inverse dynamics and kinematics. Also supports contacts and loops.

[**Unity Robotics Hub**](https://github.com/Unity-Technologies/Unity-Robotics-Hub)
Central repository for open-source Unity packages, tutorials, and other resources demonstrating how to use Unity for robotics simulations. Includes new support for ROS integration.

### Papers ###
* [Optimization Based Controller Design and Implementation for the
Atlas Robot in the DARPA Robotics Challenge Finals](https://www.cs.cmu.edu/~cga/drc/ICHR15_0025_MS.pdf)


### Conferences ###
* [ACM/IEEE International Conference on Human Robot Interaction (HRI)](http://ieeexplore.ieee.org/xpl/conhome.jsp?punumber=1040036)
* [CISM IFToMM Symposium on Robot Design, Dynamics and Control (RoManSy)](http://www.romansy2016.org/)
* [IEEE Conference on Decision and Controls (CDC)](http://ieeexplore.ieee.org/servlet/opac?punumber=1000188)
* [IEEE International Conference on Rehabilitation Robotics (ICORR)](http://www.rehabrobotics.org/)
* [IEEE International Conference on Robotics and Automation (ICRA)](http://www.ieee-ras.org/conferences-workshops/fully-sponsored/icra)
* [IEEE/RSJ International Conference on Intelligent Robots and Systems (IROS)](http://www.iros.org/)
* [IEEE-RAS International Conference on Humanoid Robots (Humanoids)](http://ieeexplore.ieee.org/servlet/opac?punumber=1002042)
* [International Symposium of Robotic Research (ISRR)](http://ifrr.org/isrr.php)
* [International Symposium of Experimental Robotics (ISER)](http://ifrr.org/iser.php)
* [Robotica](http://www.ieee-ras.org/conferences-workshops/technically-co-sponsored/robotica)
* [Robotics: Science and Systems Conference (RSS)](http://www.roboticsconference.org/)
* [The International Workshop on the Algorithmic Foundations of Robotics (WAFR)](http://www.wafr.org/)


### Journals ###
* [Autonomous Robots](http://www.springer.com/engineering/robotics/journal/10514)
* [Bioinspiration & Biomimetics](http://iopscience.iop.org/journal/1748-3190)
* [Frontiers in Robotics and AI](http://journal.frontiersin.org/journal/robotics-and-ai)
* [IEEE Robotics & Automation Magazine](http://ieeexplore.ieee.org/xpl/RecentIssue.jsp?punumber=100)
* [IEEE Transactions on Haptics](http://ieeexplore.ieee.org/xpl/RecentIssue.jsp?punumber=4543165)
* [IEEE Transactions on Robotics](http://ieeexplore.ieee.org/xpl/RecentIssue.jsp?punumber=8860)
* [IEEE/ASME Transactions on Mechatronics](http://ieeexplore.ieee.org/xpl/RecentIssue.jsp?punumber=3516)
* [International Journal of Social Robotics](http://www.springer.com/engineering/robotics/journal/12369)
* [Journal of Field Robotics](http://www.journalfieldrobotics.org/Home.html)
* [Journal of Intelligent & Robotic Systems](http://www.springer.com/engineering/robotics/journal/10846)
* [Mechatronics](http://www.journals.elsevier.com/mechatronics)
* [Robotics and Computer-Integrated Manufacturing](http://www.journals.elsevier.com/robotics-and-computer-integrated-manufacturing)
* [Robotics and Autonomous Systems](http://www.journals.elsevier.com/robotics-and-autonomous-systems)
* [The International Journal of Robotics Research](http://www.ijrr.org/)


### Competitions ###
* [ICRA Robot Challenges](http://www.icra2017.org/conference/robot-challenges)
* [RobotChallenge](http://www.robotchallenge.org/)
* [DARPA Robotics Challenge](http://www.theroboticschallenge.org/)
* [European Robotics Challenges](http://www.euroc-project.eu/)
* [First Robotics Competition](http://www.firstinspires.org/robotics/frc)
* [VEX Robotics Competition](https://www.vexrobotics.com/)
* [RoboCup](http://www.robocup.org/)
* [RoboCupJunior](https://junior.robocup.org/)
* [Eurobot](http://www.eurobot.org/) International Students Robotics Contest
* [RoboMasters](https://www.robomaster.com/en-US)
* [RoboSoft, Grand Challenge](http://www.robosoftca.eu/)
* [Intelligent Ground Vehicle Competition](http://www.igvc.org/)
* [Robotex](https://robotex.ee/en/) The biggest robotics festival in Europe
* [First Lego League](https://www.firstlegoleague.org/)

### Companies ###
* [Boston Dynamics](http://www.bostondynamics.com/) robotics R&D company, creator of the state of the art [Atlas](https://www.youtube.com/watch?v=rVlhMGQgDkY) and [Spot](https://www.youtube.com/watch?v=M8YjvHYbZ9w) robots
* [iRobot](http://www.irobot.com/) manufacturer of the famous [Roomba](https://en.wikipedia.org/wiki/Roomba) robotic vacuum cleaner
* [PAL Robotics](http://pal-robotics.com)
* [Aldebaran Robotics](https://www.aldebaran.com/en) creator of the [NAO robot](https://www.youtube.com/watch?v=nNbj2G3GmAo)
* [ABB Robotics](http://new.abb.com/products/robotics) the largest manufacturer of industrial robots
* [KUKA Robotics](http://www.kuka-robotics.com/en/) major manufacturer of industrial robots targeted at factory automation
* [FANUC](http://www.fanucamerica.com/) industrial robots manufacturer with the biggest install base
* [Rethink Robotics](http://www.rethinkrobotics.com/) creator of the collaborative robot [Baxter](https://www.youtube.com/watch?v=fCML42boO8c)
* [DJI](http://www.dji.com/) industry leader in drones for both commerical and industrial needs.
* [The construct sim](http://www.theconstructsim.com/)  A cloud based tool for building modern, future-proof robot simulations.
* [Fetch Robotics](http://www.fetchrobotics.com/) A robotics startup in San Jose, CA building the future of e-commerce fulfillment and R&D robots.
* [Festo Robotics](https://www.festo.com/) Festo is known for making moving robots that move like animals such as the sea gull like SmartBird, jellyfish, butterflies and kangaroos.
* [Neobotix](https://www.neobotix-robots.com/homepage) manufacturer of industrial, research and as well as custom mobile robots. 

### Misc ###
* [IEEE Spectrum Robotics](http://spectrum.ieee.org/robotics) robotics section of the IEEE Spectrum magazine
* [MIT Technology Review Robotics](https://www.technologyreview.com/c/robotics/) robotics section of the MIT Technology Review magazine
* [reddit robotics subreddit](https://www.reddit.com/r/robotics/)
* [RosCON conference (video talks included)](http://roscon.ros.org/2015/)
* [Carnegie Mellon Robotics Academy](http://education.rec.ri.cmu.edu/)
* [Let's Make Robots](http://letsmakerobots.com/)
* [How do I learn Robotics?](https://www.quora.com/How-do-I-learn-robotics)
* [Free NXT Lego MindStorms NXT-G code tutorials](http://www.drgraeme.net/DrGraeme-free-NXT-G-tutorials/ChV4.htm)
* [StackExachange Robotics community](https://robotics.stackexchange.com)
* [47 Programmable robotic kits](http://www.intorobotics.com/47-programmable-robotic-kits/)
* [Linorobot](https://linorobot.org/) A suite of DIY ROS compatible robots
* [Hexapod Robot Simulator](https://github.com/mithi/hexapod) - Solve and visualize hexapod robot inverse kinematics and gaits in the web
* [PythonRobotics](https://github.com/AtsushiSakai/PythonRobotics) - Implementations of various robotics algorithms in python

### Related awesome lists ###
* [Awesome Artificial Intelligence](https://github.com/owainlewis/awesome-artificial-intelligence)
* [Awesome Computer Vision](https://github.com/jbhuang0604/awesome-computer-vision)
* [Awesome Machine Learning](https://github.com/josephmisiti/awesome-machine-learning)
* [Awesome Deep Learning](https://github.com/ChristosChristofidis/awesome-deep-learning)
* [Awesome Deep Vision](https://github.com/kjw0612/awesome-deep-vision)
* [Awesome Gazebo](https://github.com/fkromer/awesome-gazebo)
* [Awesome Reinforcement Learning](https://github.com/aikorea/awesome-rl/)
* [Awesome Robotics](https://github.com/ahundt/awesome-robotics)
* [Awesome Robotics Libraries](https://github.com/jslee02/awesome-robotics-libraries)
* [Awesome ROS2](https://github.com/fkromer/awesome-ros2)
* [Awesome RoboCupJunior Soccer](https://github.com/RoboCupJuniorTC/awesome-rcj-soccer)
