<div class="github-widget" data-repo="protontypes/awesome-robotic-tooling"></div>
## Awesome Robotic Tooling [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

**使用 C++ 和 Python 进行专业机器人开发的精选工具列表，其中包含一些 ROS、自动驾驶和航空航天**

 &gt; 要停止重新发明轮子，您需要了解轮子. 这份清单试图展示在软件和硬件开发方面的各种开放和免费工具，这些工具在专业机器人开发中很有用.

您的贡献对于保持此列表的活力、提高质量和扩展它是必要的. 您可以阅读更多关于它的起源以及如何参与 [contribution guide](https://github.com/protontypes/awesome-robotic-tooling/blob/master/CONTRIBUTING.md) 和相关 [blog post](https://rosindustrial.org/news/2020/5/11/guest-article-on-the-story-of-the-autonomous-logistics) . 所有新项目条目都会有一条推文来自 [protontypes](https://twitter.com/protontypes).

<!--lint ignore double-link-->
[<img src="https://i.imgur.com/qI1Jfyl.gif" align="right" width="60%" />](https://raw.githubusercontent.com/leggedrobotics/xpp)
<!--lint ignore double-link-->
[![](https://img.shields.io/twitter/follow/protontypes?style=social)](https://twitter.com/intent/follow?screen_name=protontypes) [![Join the chat at https://gitter.im/protontypes/community](https://badges.gitter.im/protontypes/community.svg)](https://gitter.im/protontypes/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

<!--toc-->



<!--toc_end-->

## Communication and Coordination
* [Agile Development](https://agilemanifesto.org/) - 敏捷软件开发宣言.
* [Gitflow](https://github.com/nvie/gitflow) - 通过将新开发与已完成的工作隔离开来，使并行开发变得非常容易.
* [DeepL](https://github.com/uinput/deeplator) - 超越谷歌、微软和 Facebook 的在线翻译器.
* [Taiga](https://github.com/benhutchins/docker-taiga) - 敏捷项目管理工具.
* [Kanboard](https://github.com/kanboard/kanboard) - 简约的看板.
* [kanban](https://gitlab.com/leanlabsio/kanban) - 用于 GitLab 问题的免费、开源、自托管的看板.
* [Gitlab](https://github.com/sameersbn/docker-gitlab) - 带有 Docker 的简单自托管 Gitlab 服务器.
* [Gogs](https://github.com/gogs/gogs) - 构建一个简单、稳定和可扩展的自托管 Git 服务，可以以最轻松的方式进行设置.
* [Wekan](https://github.com/wekan/wekan) - 基于流星的看板.
* [JIRA API](https://github.com/pycontribs/jira) - 用于 Jira REST API 的 Python 库.
* [Taiga API](https://github.com/nephila/python-taiga) - Taiga REST API 的 Python 库.
* [Chronos-Timetracker](https://github.com/web-pal/chronos-timetracker)  - JIRA 的桌面客户端. 跟踪时间，轻松上传工作日志.
* [Grge](https://gitlab.com/ApexAI/grge) - Grge 是增强 GitLab 的守护进程和命令行实用程序.
* [gitlab-triage](https://gitlab.com/gitlab-org/gitlab-triage) - Gitlab 的问题和合并请求分类，自动化.
* [Helpy](https://github.com/helpyio/helpy) - 现代的开源帮助台客户支持应用程序.
* [ONLYOFFICE](https://github.com/ONLYOFFICE/CommunityServer) - 一个免费的开源协作系统，用于在一个地方管理文档、项目、客户关系和电子邮件通信.
* [discourse](https://github.com/discourse/discourse)  - 社区讨论的平台. 免费、开放、简单.
* [Gerrit](https://gerrit.googlesource.com/gerrit/) - 基于 Git 的项目的代码审查和项目管理工具.
* [jitsi-meet](https://github.com/jitsi/jitsi-meet) - 安全、简单和可扩展的视频会议，您可以将其用作独立应用程序或嵌入到您的 Web 应用程序中.
* [mattermost](https://github.com/mattermost/mattermost-server) - 开源、私有云、Slack 替代品.
* [openproject](https://github.com/opf/openproject) - 领先的开源项目管理软件.
* [leantime](https://github.com/Leantime/leantime) - Leantime 是面向创新者的精益项目管理系统.

## Documentation and Presentation
* [Typora](https://typora.io/) - 极简主义的 Markdown 编辑器.
* [Markor](https://github.com/gsantner/markor) - 适用于您的 Android 设备的简单 Markdown 编辑器.
* [Pandoc](https://github.com/jgm/pandoc) - 通用标记转换器.
* [Yaspeller](https://github.com/hcodes/yaspeller) - 用于拼写检查的命令行工具.
* [ReadtheDocs](https://docs.readthedocs.io/en/stable/development/buildenvironments.html) - 构建您本地的 ReadtheDocs 服务器.
* [Doxygen](https://github.com/doxygen/doxygen) - Doxygen 是事实上的标准工具，用于从带注释的 C++ 源代码生成文档.
* [Sphinx](https://github.com/sphinx-doc/sphinx/) - 一个可以轻松为 Python 项目创建智能且美观的文档的工具.
* [paperless](https://github.com/the-paperless-project/paperless) - 索引并存档所有扫描的纸质文档.
* [carbon](https://github.com/carbon-app/carbon) - Share beautiful images of your source code.
* [undraw](https://undraw.co/illustrations) - 易于定制的免费专业商业 SVG.
* [asciinema](https://github.com/asciinema/asciinema) - 让您轻松记录终端会话并在终端和网络浏览器中重播它们.
* [inkscape](https://inkscape.org/) - Inkscape 是适用于 Linux、Windows 和 macOS 的专业矢量图形编辑器.
* [Hugo-Webslides](https://github.com/RCJacH/hugo-webslides) - This is a Hugo template to create WebSlides presentation using markdown.
* [jupyter2slides](https://github.com/datitran/jupyter2slides) - 使用 Jupyter Notebook + Reveal.js 的云原生演示幻灯片.
* [patat](https://github.com/jaspervdj/patat) - 使用 Pandoc 的基于终端的演示.
* [github-changelog-generator](https://github.com/github-changelog-generator/github-changelog-generator) - 从您在 GitHub 上的标签、问题、标签和拉取请求自动生成更改日志.
* [GitLab-Release-Note-Generator](https://github.com/jk1z/GitLab-Release-Note-Generator) - 一个 Gitlab 发行说明生成器，可生成有关最新标签的发行说明.
* [OCRmyPDF](https://github.com/jbarlow83/OCRmyPDF) - 将 OCR 文本层添加到扫描的 PDF 文件中，以便对其进行搜索.
* [papermill](https://github.com/nteract/papermill) - 用于参数化、执行和分析 Jupyter 笔记本的工具.
* [docsy](https://github.com/google/docsy-example) - 使用 Docsy Hugo 主题的示例文档站点.
* [actions-hugo](https://github.com/peaceiris/) - 部署基于Hugo的网站到GitHub Pages.
* [overleaf](https://github.com/overleaf/overleaf) - 开源在线实时协作 LaTeX 编辑器.
* [landslide](https://github.com/adamzap/landslide) - 从 markdown、ReST 或 textile 生成 HTML5 幻灯片.
* [libreoffice-impress-templates](https://github.com/dohliam/libreoffice-impress-templates) - 免费许可的 LibreOffice Impress 模板.
* [opensourcedesign](https://opensourcedesign.net/resources/) - 免费设计和徽标创建的社区和资源.
* [olive](https://www.olivevideoeditor.org/) - 免费的非线性视频编辑器，旨在为高端专业视频编辑软件提供功能齐全的替代方案.
* [buku](https://github.com/jarun/buku) - 独立于浏览器的书签管理器.
* [swiftlatex](https://www.swiftlatex.com/) - 基于浏览器的所见即所得的 LaTeX 编辑器.
* [foam](https://github.com/foambubble/foam) - Foam 是一个个人知识管理和共享系统，其灵感来自 Roam Research，构建于 Visual Studio Code 和 GitHub 之上.
* [CodiMD](https://github.com/codimd/server) - 开源在线实时协作处理 markdown 中的团队文档.
* [jupyter-book](https://github.com/executablebooks/jupyter-book) - Build interactive, publication-quality documents from Jupyter Notebooks.
* [InvoiceNet](https://github.com/naiveHobo/InvoiceNet) - 深度神经网络从发票文档中提取智能信息.
* [tesseract](https://github.com/tesseract-ocr/tesseract) - 开源 OCR 引擎.
* [mkdocs](https://github.com/mkdocs/mkdocs/) - 一个快速、简单和彻头彻尾的华丽静态站点生成器，适用于构建项目文档.
* [PlotNeuralNet](https://github.com/HarisIqbal88/PlotNeuralNet) - 为报告和演示绘制神经网络的 Latex 代码.
* [Excalidraw](https://github.com/excalidraw/excalidraw) - 用于绘制类似图表的手绘素描的虚拟白板.
* [SVGrepo](https://www.svgrepo.com/) - 下载免费的 SVG 矢量用于商业用途.
* [gollum](https://github.com/gollum/gollum) - 一个简单的、基于 Git 的 wiki，带有友好的 API 和本地前端.
* [GanttLab](https://gitlab.com/ganttlab/ganttlab) - GitLab 和 GitHub 的易于使用、功能齐全的甘特图.
* [Zotero](https://github.com/zotero/zotero) - 一个免费、易于使用的工具，可帮助您收集、组织、引用和共享您的研究资源.


## Requirements and Safety
* [awesome-safety-critical](https://github.com/stanislaw/awesome-safety-critical) - 有关编写安全关键软件的编程实践的资源列表.
* [open-autonomous-safety](https://github.com/voyage/open-autonomous-safety) - OAS 是 Voyage 安全流程和测试程序的完全开源库，旨在补充全球自动驾驶汽车初创公司现有的安全计划.
* [CarND-Functional-Safety-Project](https://github.com/udacity/CarND-Functional-Safety-Project) - 在此 Udacity 项目中创建功能安全文档.
* [Automated Valet Parking Safety Documents](https://avp-project.uk/publication-of-safety-documents) - 旨在支持在停车场使用 StreetDrone 测试车辆对自动代客泊车功能进行安全测试.
* [safe_numerics](https://github.com/boostorg/safe_numerics) - 标准数字类型的替换，这些类型在错误时抛出异常.
* [Air Vehicle C++ development coding standards](http://www.stroustrup.com/JSF-AV-rules.pdf) - 为 C++ 程序员提供方向和指导，使他们能够采用良好的编程风格和经过验证的编程实践，从而生成安全、可靠、可测试和可维护的代码.
* [AUTOSAR Coding Standard](https://www.autosar.org/fileadmin/user_upload/standards/adaptive/17-10/AUTOSAR_RS_CPP14Guidelines.pdf) - 在关键和安全相关系统中使用 C++14 语言的指南.
* [doorstop](https://github.com/doorstop-dev/doorstop) - 使用版本控制的需求管理.
* [capella](https://www.eclipse.org/capella/) - 全面、可扩展且经过现场验证的 MBSE 工具和方法
成功设计系统架构.
* [robmosys](https://robmosys.eu/) - RobMoSys 设想通过应用模型驱动的方法和工具，在当前以代码为中心的机器人平台之上构建一种集成方法.
* [Papyrus for Robotics](https://www.eclipse.org/papyrus/components/robotics/) - 符合 RobMoSys 方法的机器人应用程序图形编辑工具.
* [fossology](https://github.com/fossology/fossology) - 一个工具包，您可以从命令行运行许可证、版权和出口控制扫描.
* [ScenarioArchitect](https://github.com/TUMFTM/ScenarioArchitect) - Scenario Architect 是一个基本的 python 工具，用于生成、导入和导出短场景快照.


## Architecture and Design
* [Guidelines](https://github.com/S2-group/icse-seip-2020-replication-package/blob/master/ICSE_SEIP_2020.pdf) - 如何构建基于 ROS 的系统.
* [yEd](https://www.yworks.com/products/yed) - 一个功能强大的桌面应用程序，可用于快速有效地生成高质量图表.
* [yed_py](https://github.com/true-grue/yed_py) - 生成可以在 yEd 中打开的 graphML.
* [Plantuml](https://github.com/plantuml/plantuml-server) - 用于在您的实时文档中即时生成 UML 图的 Web 应用程序.
* [rqt_graph](https://wiki.ros.org/rqt_graph) - 提供用于可视化 ROS 计算图的 GUI 插件.
* [rqt_launchtree](https://github.com/pschillinger/rqt_launchtree) - 用于分层启动文件配置自省的 RQT 插件.
* [cpp-dependencies](https://github.com/tomtom-international/cpp-dependencies) - Tool to check C++ #include dependencies (dependency graphs created in .dot format).
* [pydeps](https://github.com/thebjorn/pydeps) - Python 模块依赖关系图.
* [aztarna](https://github.com/aliasrobotics/aztarna) - 机器人足迹工具.
* [draw.io](https://www.draw.io/) - 一个免费的在线图表软件，用于制作流程图、流程图、组织结构图、UML、ER 和网络图.
* [vscode-drawio](https://github.com/hediet/vscode-drawio) - 此扩展将 Draw.io 集成到 VS Code 中.
* [Architecture_Decision_Record](https://github.com/joelparkerhenderson/architecture_decision_record) - 一份记录重要架构决策及其上下文和结果的文档.

## Frameworks and Stacks
* [ROS](https://github.com/ros) - （机器人操作系统）提供库和工具来帮助软件开发人员创建机器人应用程序.
* [awesome-ros2](https://github.com/fkromer/awesome-ros2) - 精选的机器人操作系统 2.0 版 (ROS 2) 资源和库列表.
* [Autoware.Auto](https://gitlab.com/autowarefoundation/autoware.auto) - Autoware.Auto 将一流的软件工程应用于自动驾驶.
* [Autoware.ai](https://github.com/Autoware-AI) - Autoware.AI 是世界上第一个用于自动驾驶技术的“一体化”开源软件.
* [OpenPilot](https://github.com/commaai/openpilot) - 开源自适应巡航控制 (ACC) 和车道保持辅助系统 (LKAS).
* [Apollo](https://github.com/ApolloAuto/apollo) - 高性能、灵活的架构，可加速自动驾驶汽车的开发、测试和部署.
* [PythonRobotics](https://github.com/AtsushiSakai/PythonRobotics/) - 这是机器人算法的 Python 代码集合，尤其适用于自主导航.
* [Stanford Self Driving Car Code](https://github.com/emmjaykay/stanford_self_driving_car_code) - 来自进入 DARPA 大挑战的汽车的斯坦福代码.
* [astrobee](https://github.com/nasa/astrobee) - Astrobee 是一种自由飞行的机器人，旨在作为国际空间站 (ISS) 内的有效载荷运行.
* [CARMAPlatform](https://github.com/usdot-fhwa-stol/CARMAPlatform) - 启用协同自动驾驶插件.
* [Automotive Grade Linux](https://www.automotivelinux.org/) - Automotive Grade Linux 是一个协作开源项目，它将汽车制造商、供应商和技术公司聚集在一起，以加速开发和采用用于互联汽车的完全开放的软件堆栈.
* [PX4](https://github.com/PX4/Firmware) - 用于无人机和其他无人驾驶车辆的开源飞行控制软件.
* [KubOS](https://github.com/kubos/kubos) - 用于卫星的开源软件堆栈.
* [mod_vehicle_dynamics_control](https://github.com/TUMFTM/mod_vehicle_dynamics_control) - TUM Roborace Team 软件堆栈 - 路径跟踪控制、速度控制、曲率控制和状态估计.
* [Aslan](https://github.com/project-aslan/Aslan) - 用于低速环境的开源自动驾驶软件.
* [open-source-rover](https://github.com/nasa-jpl/open-source-rover) - 基于喷气推进实验室火星漫游车的自制 6 轮漫游车.
* [pybotics](https://github.com/engnadeau/pybotics) - 用于机器人运动学和校准的开源和同行评审的 Python 工具箱.
* [makani](https://github.com/google/makani) - 包含可用的 Makani 飞行模拟器、控制器（自动驾驶仪）、可视化工具和指挥中心飞行监控工具.
* [mir_robot](https://github.com/dfki-ric/mir_robot) - 这是一个将 MiR 机器人与 ROS 结合使用的社区项目.
* [COMPAS](https://github.com/compas-dev/compas_fab) - COMPAS 框架的机器人制造包.
* [JdeRobot Academy](https://github.com/JdeRobot/RoboticsAcademy) - JdeRobot Academy 是一个开源练习集合，以实用的方式学习机器人技术.
* [clover](https://github.com/CopterExpress/clover) - 基于 ROS 的框架和 RPi 图像来控制 PX4 驱动的无人机.
* [ArduPilot](https://github.com/ArduPilot/ardupilot) - 用于自动驾驶车辆的开源控制软件 - 直升机/飞机/漫游车/船/潜水器.
* [F Prime](https://github.com/nasa/fprime) - 一个组件驱动的框架，可以快速开发和部署航天和其他嵌入式软件应用程序.

## Development Environment
### Code and Run
* [Vim-ros](https://github.com/taketwo/vim-ros) - 用于 ROS 开发的 Vim 插件.
* [Visual Studio Code](https://github.com/Microsoft/vscode) - 用于编辑-构建-调试循环的代码编辑器.
* [atom](https://github.com/atom/atom) - 21 世纪的可破解文本编辑器.
* [Teletype](https://github.com/atom/teletype) - 与团队成员共享您的工作区并在 Atom 中实时协作编写代码.
* [Sublime](https://www.sublimetext.com/) - 用于代码、标记和散文的复杂文本编辑器.
* [ade-cli](https://gitlab.com/ApexAI/ade-cli) - ADE 开发环境 (ADE) 使用 docker 和 Gitlab 来管理每个项目开发工具和可选卷映像的环境.
* [recipe-wizard](https://github.com/trn84/recipe-wizard) - A Dockerfile generator for running OpenGL (GLX) applications with nvidia-docker2, CUDA, ROS, and Gazebo on a remote headless server system.
* [Jupyter ROS](https://github.com/RoboStack/jupyter-ros) - 机器人操作系统 ROS 的 Jupyter 小部件助手.
* [ros_rqt_plugin](https://github.com/ros-industrial/ros_qtc_plugin) - 适用于 Python 的 ROS Qt Creator 插件.
* [xeus-cling](https://github.com/QuantStack/xeus-cling) - C++ 编程语言的 Jupyter 内核.
* [ROS IDEs](http://wiki.ros.org/IDEs) - 此页面收集了有关将集成开发环境 (IDE) 与 ROS 结合使用的经验和建议.
* [TabNine](https://github.com/zxqfl/TabNine) - 全语言自动完成器.
* [kite](https://kite.com/) - 使用机器学习为您提供有用的 Python 代码补全.
* [jedi](https://github.com/davidhalter/jedi) - python 的自动完成和静态分析库.
* [roslibpy](https://github.com/gramaziokohler/roslibpy) - Python ROS Bridge 库允许使用 Python 和 IronPython 与开源机器人中间件 ROS 交互.
* [pybind11](https://github.com/pybind/pybind11) - C++11 和 Python 之间的无缝操作.
* [Sourcetrail](https://github.com/CoatiSoftware/Sourcetrail) - 免费和开源的跨平台资源管理器.
* [rebound](https://github.com/shobrook/rebound) - 在抛出异常时立即获取 Stack Overflow 结果的命令行工具.
* [mybinder](https://mybinder.org/) - 在可执行环境中打开笔记本，让任何人在任何地方都可以立即复制您的代码.
* [ROSOnWindows](https://ms-iot.github.io/ROSOnWindows/) - 适用于 Windows 的 ROS1 实验性版本.
* [live-share](https://github.com/MicrosoftDocs/live-share) - 使用您最喜欢的工具进行实时协作开发.
* [cocalc](https://github.com/sagemathinc/cocalc) - 云端协同计算.
* [EasyClangComplete](https://github.com/niosus/EasyClangComplete) - 用于 Sublime Text 3 的强大 C/C++ 代码完成.
* [vscode-ros](https://github.com/ms-iot/vscode-ros) - 用于机器人操作系统 (ROS) 开发的 Visual Studio Code 扩展.
* [awesome-hpp](https://github.com/p-ranav/awesome-hpp) - 精选的仅标头 C++ 库的精选列表.
* [Gitpod](https://github.com/gitpod-io/gitpod) - 一个开源开发人员平台，可自动配置准备好编码的开发环境.

### Template
* [ROS](https://github.com/leggedrobotics/ros_best_practices/tree/master/ros_package_template) - C++ 中 ROS 节点标准化模板.
* [Launch](https://wiki.ros.org/roslaunch/Tutorials/Roslaunch%20tips%20for%20larger%20projects) - 有关如何为大型项目创建启动文件的模板.
* [Bash](https://github.com/ralish/bash-script-template) - 包含最佳实践和几个有用功能的 bash 脚本模板.
* [URDF](https://wiki.ros.org/urdf/Examples) - 有关如何为不同类型的机器人创建统一机器人描述格式 (URDF) 的示例.
* [Python](http://wiki.ros.org/PyStyleGuide) - 为 ROS 编写 Python 代码时应遵循的风格指南.
* [Docker](https://ade-cli.readthedocs.io/en/latest/create-custom-base-image.html) - minimal-ade 项目中的 Dockerfile 显示了如何创建自定义基础映像的最小示例.
* [VS Code ROS2 Workspace Template](https://github.com/athackst/vscode_ros2_workspace) - 使用 VSCode 作为 ROS2 开发的 IDE 的模板.

### Build and Deploy
* [qemu-user-static](https://github.com/multiarch/qemu-user-static) - 通过 QEMU 和 binfmt_misc 启用不同的多架构容器的执行.
* [Cross compile ROS 2 on QNX](https://gitlab.apex.ai/snippets/97) - 介绍如何在 QNX 上交叉编译 ROS 2.
* [bloom](https://github.com/ros-infrastructure/bloom) - 一个发布自动化工具，可以更轻松地发布 catkin 包.
* [superflore](https://github.com/ros-infrastructure/superflore) - 机器人操作系统的扩展平台发布管理器.
* [catkin_tools](https://github.com/catkin/catkin_tools) - 用于处理 catkin 的命令行工具.
* [industrial_ci](https://github.com/ros-industrial/industrial_ci) - ROS 存储库的简单持续集成存储库.
* [ros_gitlab_ci](https://gitlab.com/VictorLamoine/ros_gitlab_ci) - 包含有关如何对托管在 GitLab 实例上的 ROS 项目使用持续集成 (CI) 的帮助程序脚本和说明.
* [gitlab-runner](https://gitlab.com/gitlab-org/gitlab-runner) - 运行测试并将结果发送到 GitLab.
* [colcon-core](https://github.com/colcon/colcon-core) - 用于改进构建、测试和使用多个软件包的工作流程的命令行工具.
* [gitlab-release](https://gitlab.com/alelec/gitlab-release) - 将文件（从 ci）上传到当前项目版本（标签）的简单 python3 脚本.
* [clang](https://github.com/llvm-mirror/clang) - 这是 C 语言家族（C、C++、Objective-C 和 Objective-C++）的编译器前端，作为 LLVM 编译器基础设施项目的一部分构建.
* [catkin_virtualenv](https://github.com/locusrobotics/catkin_virtualenv) - 通过 virtualenv 在 catkin 包中捆绑 python 要求.
* [pyenv](https://github.com/pyenv/pyenv) - 简单的 Python 版本管理.
* [aptly](https://github.com/aptly-dev/aptly) - Debian 存储库管理工具.
* [cross_compile](https://github.com/ros-tooling/cross_compile) - 用于 ROS2 交叉编译的资产.
* [docker_images](https://github.com/osrf/docker_images) - 由 OSRF 在 ROS(2) 和 Gazebo 上维护的官方 Docker 图像.
* [robot_upstart](https://github.com/clearpathrobotics/robot_upstart) - 提供一套脚本来帮助在 Ubuntu Linux PC 上启动后台 ROS 进程.
* [robot_systemd](http://docs.ros.org/kinetic/api/robot_systemd/html/#) - 用于管理 roscore 和 roslaunch 的启动和关闭的单元.
* [ryo-iso](https://ryo-iso.readthedocs.io/en/latest/) - 现代 ISO 构建器，可简化从 yaml 配置文件部署完整机器人操作系统的过程.
* [network_autoconfig](http://docs.ros.org/kinetic/api/network_autoconfig/html/) - 为大多数用例自动配置 ROS 网络，而不会影响需要手动配置的使用.
* [rosbuild](https://roscon.ros.org/2016/presentations/ROSCon2016%20Build%20Farm.pdf) - ROS 构建农场.
* [cros](https://github.com/ros-industrial/cros) - ROS 框架的单线程纯 C 实现.


### Unit and Integration Test
* [setup-ros](https://github.com/ros-tooling/setup-ros) - 此操作设置 ROS 和 ROS 2 环境以用于 GitHub 操作.
* [UnitTesting](https://wiki.ros.org/Quality/Tutorials/UnitTesting) - 此页面列出了为 ROS 编写和运行单元测试和集成测试的基本原理、最佳实践和策略.
* [googletest](https://github.com/google/googletest) - 谷歌的 C++ 测试框架.
* [pytest](https://github.com/pytest-dev/pytest/) - pytest 框架使编写小型测试变得容易，但可以扩展以支持复杂的功能测试.
* [doctest](https://github.com/onqtam/doctest) - 最快的功能丰富的 C++11/14/17/20 单头测试框架，用于单元测试和 TDD.
* [osrf_testing_tools_cpp](https://github.com/osrf/osrf_testing_tools_cpp) - 包含 C++ 测试工具，用于 OSRF 项目.
* [code_coverage](https://github.com/mikeferguson/code_coverage) - 用于运行覆盖测试的 ROS 包.
* [action-ros-ci](https://github.com/ros-tooling/action-ros-ci) - 使用 colcon 构建和测试 ROS 2 包的 GitHub Action.

### Lint and Format
* [action-ros-lint](https://github.com/ros-tooling/action-ros-lint) - 在 ROS 2 包上运行 linters 的 GitHub 操作.
* [cppcheck](https://github.com/danmar/cppcheck) - C/C++ 代码的静态分析.
* [hadolint](https://github.com/hadolint/hadolint) - Dockerfile linter，验证内联 bash，用 Haskell 编写.
* [shellcheck](https://github.com/koalaman/shellcheck) - 一个shell脚本的静态分析工具.
* [catkin_lint](https://github.com/fkie/catkin_lint) - 检查 ROS 的 catkin 构建系统的包配置.
* [pylint](https://github.com/PyCQA/pylint/) - Pylint 是一种 Python 静态代码分析工具，可查找编程错误、帮助执行编码标准、嗅探代码异味并提供简单的重构建议.
* [black](https://github.com/psf/black) - 不妥协的 Python 代码格式化程序.
* [pydocstyle](https://github.com/PyCQA/pydocstyle) - 用于检查是否符合 Python 文档字符串约定的静态分析工具.
* [haros](https://github.com/git-afsantos/haros) - ROS 应用程序代码的静态分析.
* [pydantic](https://github.com/samuelcolvin/pydantic) - 使用 Python 类型提示进行数据解析和验证.


### Debugging and Tracing
* [heaptrack](https://github.com/KDE/heaptrack) - 跟踪所有内存分配并使用堆栈跟踪注释这些事件.
* [ros2_tracing](https://gitlab.com/ros-tracing/ros2_tracing) - ROS 2 的跟踪工具.
* [Linuxperf](http://www.brendangregg.com/linuxperf.html) - 各种 Linux 性能材料.
* [lptrace](https://github.com/khamidou/lptrace) - 它可以让您实时查看 Python 程序正在运行的功能.
* [pyre-check](https://github.com/facebook/pyre-check) - python 的高性能类型检查.
* [FlameGraph](https://github.com/brendangregg/FlameGraph) - 可视化分析代码.
* [gpuvis](https://github.com/mikesart/gpuvis) - GPU 跟踪可视化工具.
* [sanitizer](https://github.com/google/sanitizers) - AddressSanitizer、ThreadSanitizer、MemorySanitizer.
* [cppinsights](https://github.com/andreasfertig/cppinsights) - C++ Insights - 用编译器的眼光看你的源代码.
* [inspect](https://pymotw.com/2/inspect/) - inspect 模块提供用于了解活动对象的功能，包括模块、类、实例、函数和方法.
* [Roslaunch Nodes in Valgrind or GDB](https://wiki.ros.org/roslaunch/Tutorials/Roslaunch%20Nodes%20in%20Valgrind%20or%20GDB) - 在调试使用 roslaunch 启动的 roscpp 节点时，您可能希望在调试程序（如 gdb 或 valgrind）中启动节点.
* [pyperformance](https://github.com/python/pyperformance) - Python 性能基准套件.
* [qira](https://github.com/geohot/qira) - QIRA 是 strace 和 gdb 的竞争对手.
* [gdb-frontend](https://github.com/rohanrhu/gdb-frontend) - GDBFrontend 是一个简单、灵活和可扩展的图形用户界面调试器.
* [lttng](https://lttng.org/docs/) - 一个开源软件工具包，可用于同时跟踪 Linux 内核、用户应用程序和用户库.
* [ros2-performance](https://github.com/irobot-ros/ros2-performance) - 允许轻松创建任意 ROS2 系统，然后测量其性能.
* [bcc](https://github.com/iovisor/bcc) - 基于 BPF 的 Linux IO 分析、网络、监控等工具.
* [tracy](https://github.com/wolfpld/tracy) - 用于游戏和其他应用程序的实时、纳秒分辨率、远程遥测帧分析器.
* [bpftrace](https://github.com/iovisor/bpftrace) - Linux eBPF 的高级跟踪语言.
* [pudb](https://github.com/inducer/pudb) - Python 的全屏控制台调试器.
* [backward-cpp](https://github.com/bombela/backward-cpp) - 用于 C++ 的漂亮堆栈跟踪漂亮打印机.
* [gdb-dashboard](https://github.com/cyrus-and/gdb-dashboard) - GDB dashboard is a standalone .gdbinit file written using the Python API that enables a modular interface showing relevant information about the program being debugged.
* [hotspot](https://github.com/KDAB/hotspot) - 用于性能分析的 Linux perf GUI.
* [memory_profiler](https://github.com/pythonprofilers/memory_profiler) - 一个 python 模块，用于监视进程的内存消耗以及对 python 程序的内存消耗进行逐行分析.
* [ros1_fuzzer](https://github.com/aliasrobotics/ros1_fuzzer) - 该模糊器旨在通过对目标节点处理的主题执行模糊测试来帮助开发人员和研究人员发现 ROS 节点中的错误和漏洞.
* [vscode-debug-visualizer](https://github.com/hediet/vscode-debug-visualizer) - VS Code 的扩展，可在调试期间可视化数据.
* [action-tmate](https://github.com/mxschmitt/action-tmate) - 通过使用 tmate 访问运行器系统本身，通过 SSH 调试 GitHub Actions.
* [libstatistics_collector](https://github.com/ros-tooling/libstatistics_collector) - ROS 2 库提供类来收集测量值并计算它们的统计数据.
* [system_metrics_collector](https://github.com/ros-tooling/system_metrics_collector) - 用于 ROS2 系统的轻量级实时系统指标收集器.


### Version Control
* [git-fuzzy](https://github.com/bigH/git-fuzzy) - 严重依赖 fzf 的 git 的 CLI 接口.
* [meld](https://github.com/GNOME/meld) - Meld 是一种可视化差异和合并工具，可帮助您比较文件、目录和版本控制项目.
* [tig](https://github.com/jonas/tig) - git 的文本模式界面.
* [gitg](https://github.com/GNOME/gitg) - git 的图形用户界面.
* [git-cola](https://github.com/git-cola/git-cola) - 高度含咖啡因的 Git GUI.
* [python-gitlab](https://github.com/python-gitlab/python-gitlab) - 一个 Python 包，提供对 GitLab 服务器 API 的访问.
* [bfg-repo-cleaner](https://github.com/rtyley/bfg-repo-cleaner) - 像 git-filter-branch 那样删除大的或有问题的 blob，但速度更快.
* [nbdime](https://github.com/jupyter/nbdime) - 用于区分和合并 Jupyter 笔记本的工具.
* [semantic-release](https://github.com/semantic-release/semantic-release) - 全自动版本管理和包发布.
* [go-semrel-gitab](https://gitlab.com/juhani/go-semrel-gitlab) - 自动化 Gitlab 的版本管理.
* [Git-repo](https://gerrit.googlesource.com/git-repo/) - Git-Repo 帮助管理许多 Git 存储库，上传到版本控制系统，并自动化部分开发工作流程.
* [dive](https://github.com/wagoodman/dive) - 用于探索 docker 图像中每一层的工具.
* [dvc](https://github.com/iterative/dvc) - 数据集和机器学习模型的管理和版本控制.
* [learnGitBranching](https://github.com/pcottle/learnGitBranching) - git 存储库可视化工具、沙箱以及一系列教育教程和挑战.
* [gitfs](https://github.com/Presslabs/gitfs) - 您可以在本地挂载远程存储库的分支，对文件所做的任何后续更改都将自动提交到远程.
* [git-secret](https://github.com/sobolevn/git-secret) - 使用允许用户的公钥加密文件，允许您信任的用户使用 pgp 及其秘密密钥访问加密数据.
* [git-sweep](https://github.com/arc90/git-sweep) - 一个命令行工具，可以帮助你清理已经合并到 master 中的 Git 分支.
* [lazygit](https://github.com/jesseduffield/lazygit) - 用于 git 命令的简单终端 UI，使用 gocui 库用 Go 编写.
* [glab](https://github.com/profclems/glab) - 一个开源的 GitLab 命令行工具.


## Simulation
* [AI2-THOR](https://github.com/allenai/ai2thor) - 带有 Unity 后端的 Python 框架为基于家庭的机器人代理提供交互、导航和操作支持，包括 200 多个自定义场景、1500 多个自定义注释对象和 200 多个动作.
* [Drake](https://github.com/RobotLocomotion/drake) - Drake aims to simulate even very complex dynamics of robots.
* [Webots](https://github.com/cyberbotics/webots) - Webots 是一个开源机器人模拟器，兼容（除其他外） [ROS](http://wiki.ros.org/webots_ros) 和 [ROS2](http://wiki.ros.org/webots_ros2).
* [lgsv](https://github.com/lgsvl/simulator) - LG 电子美国研发中心为自动驾驶汽车开发人员开发了基于 HDRP Unity 的多机器人模拟器.
* [carla](https://github.com/carla-simulator/carla) - 用于自动驾驶研究的开源模拟器.
* [awesome-CARLA](https://github.com/Amin-Tgz/awesome-CARLA) - 精彩的 CARLA 教程、博客和相关项目的精选列表.
* [ros-bridge](https://github.com/carla-simulator/ros-bridge) - 用于 CARLA 模拟器的 ROS 桥.
* [scenario_runner](https://github.com/carla-simulator/scenario_runner) - 交通场景定义和执行引擎.
* [deepdive](https://github.com/deepdrive/deepdrive) - 自动驾驶汽车的端到端模拟.
* [uuv_simulator](https://github.com/uuvsimulator/uuv_simulator) - 用于水下机器人仿真的 Gazebo/ROS 包.
* [AirSim](https://github.com/microsoft/AirSim) - 基于虚幻引擎构建的自动驾驶汽车开源模拟器.
* [self-driving-car-sim](https://github.com/udacity/self-driving-car-sim) - 使用 Unity 构建的自动驾驶汽车模拟器.
* [ROSIntegration](https://github.com/code-iai/ROSIntegration) - 启用 ROS 支持的虚幻引擎插件.
* [gym-gazebo](https://github.com/erlerobot/gym-gazebo) - 一个使用 Gazebo 的 OpenAI 健身房扩展，称为 gym-gazebo.
* [gym-pybullet-drones](https://github.com/utiasDSL/gym-pybullet-drones) - 基于 PyBullet 的健身房环境，用于四轴飞行器控制的单代理和多代理强化学习.
* [safe-control-gym](https://github.com/utiasDSL/safe-control-gym) - 基于 PyBullet 的 CartPole 和 Quadrotor 环境——具有 CasADi 符号动力学和约束——用于安全和稳健的基于学习的控制.
* [highway-env](https://github.com/eleurent/highway-env) - 自动驾驶和战术决策任务的环境集合.
* [VREP Interface](http://www.coppeliarobotics.com/helpFiles/en/rosInterf.htm) - 用于 VREP 模拟器的 ROS Bridge.
* [car_demo](https://github.com/osrf/car_demo) - 这是 Gazebo 9 中 Prius 的模拟，传感器数据使用 ROS kinetic 发布.
* [sumo](https://github.com/eclipse/sumo) - Eclipse SUMO 是一个开源、高度便携、微观和连续的道路交通模拟包，旨在处理大型道路网络.
* [open-simulation-interface](https://github.com/OpenSimulationInterface/open-simulation-interface) - 虚拟场景中自动驾驶功能环境感知的通用接口.
* [ESIM](https://github.com/uzh-rpg/rpg_esim/) - 一个开放事件相机模拟器.
* [Menge](https://github.com/MengeCrowdSim/Menge) - 人群模拟框架.
* [pedsim_ros](https://github.com/srl-freiburg/pedsim_ros) - 由 Gazebo 的社会力量模型提供支持的行人模拟器.
* [opencrg](http://www.opencrg.org/download.html) - 用于详细描述、创建和评估路面的开放文件格式和开源工具.
* [esmini](https://github.com/esmini/esmini) - 一个基本的 OpenSCENARIO 播放器.
* [OpenSceneGraph](https://github.com/openscenegraph/OpenSceneGraph) - 一个开源的高性能 3D 图形工具包，供视觉模拟、游戏、虚拟现实、科学可视化和建模等领域的应用程序开发人员使用.
* [morse](https://github.com/morse-simulator) - 基于 Blender 游戏引擎和 Bullet Physics 引擎的学术机器人模拟器.
* [ROSIntegrationVision](https://github.com/code-iai/ROSIntegrationVision) - 支持在虚幻引擎项目中获取支持 ROS 的 RGBD 数据.
* [fetch_gazebo](https://github.com/fetchrobotics/fetch_gazebo) - 包含 Fetch Robotics Fetch 和 Freight Research Edition 机器人的 Gazebo 模拟.
* [rotors_simulator](https://github.com/ethz-asl/rotors_simulator) - 提供部分多旋翼模型.
* [flow](https://github.com/flow-project/flow) - 用于交通微观模拟的深度 RL 和控制实验的计算框架.
* [gnss-ins-sim](https://github.com/Aceinna/gnss-ins-sim)  - GNSS + 惯性导航、传感器融合模拟器. 运动轨迹生成器、传感器模型和导航.
* [Ignition Robotics](https://ignitionrobotics.org) - 安全测试控制策略，并在持续集成测试中利用模拟.
* [simulation assets for the SubT](https://subtchallenge.world/openrobotics/fuel/collections/SubT%20Tech%20Repo) - 此集合包含用于 Gazebo 中的 SubT 挑战虚拟竞赛的模拟资产.
* [gazebo_ros_motors](https://github.com/nilseuropa/gazebo_ros_motors) - 目前包含两个用于 Gazebo 的电机插件，一个带有理想的速度控制器，另一个没有模拟直流电机的控制器.
* [map2gazebo](https://github.com/shilohc/map2gazebo) - 用于从 2D 地图创建 Gazebo 环境的 ROS 包.
* [sim_vehicle_dynamics](https://github.com/TUMFTM/sim_vehicle_dynamics) - TUM Roborace Team 的车辆动力学仿真软件.
* [gym-carla](https://github.com/cjy1992/gym-carla) - 用于 CARLA 模拟器的 OpenAI 健身房包装器.
* [simbody](https://github.com/simbody/simbody) - 高性能 C++ 多体动力学/物理库，用于模拟铰接式生物力学和机械系统，如车辆、机器人和人体骨骼.
* [gazebo_models](https://github.com/osrf/gazebo_models) - 此存储库包含 Gazebo 模型数据库.
* [pylot](https://github.com/erdos-project/pylot) - 在 CARLA 模拟器上运行的自动驾驶平台.
* [flightmare](https://github.com/uzh-rpg/flightmare) - Flightmare 由两个主要组件组成：基于 Unity 构建的可配置渲染引擎和用于动态模拟的灵活物理引擎.
* [champ](https://github.com/chvmp/champ) - ROS Packages for CHAMP Quadruped Controller.
* [rex-gym](https://github.com/nicrusso7/rex-gym) - 用于开源四足机器人 (SpotMicro) 的 OpenAI Gym 环境.
* [Trick](https://github.com/nasa/Trick) - 由 NASA 约翰逊航天中心开发，是一个强大的模拟开发框架，使用户能够为太空飞行器开发的所有阶段构建应用程序.
* [usv_sim_lsa](https://github.com/disaster-robotics-proalertas/usv_sim_lsa) - 水流和风在 Gazebo 上的无人水面车辆模拟.
* [42](https://github.com/ericstoneking/42) - 航天器姿态控制系统分析和设计仿真.
* [Complete_Street_Rule](https://github.com/d-wasserman/Complete_Street_Rule) - 一种面向场景的设计工具，旨在使用户能够在 ArcGIS CityEngine 中快速创建程序生成的多式联运街道.
* [fields-ignition](https://github.com/azazdeaz/fields-ignition) - 为 Ignition Gazebo 生成随机作物田.
* [Unity-Robotics-Hub](https://github.com/Unity-Technologies/Unity-Robotics-Hub) - Unity 机器人仿真工具、教程、资源和文档的中央存储库.
* [BlueSky](https://github.com/TUDelft-CNS-ATM/bluesky) - BlueSky 的目标是为每个想要可视化、分析或模拟空中交通的人提供一种工具，而无需任何限制、许可或限制.
* [Cloe](https://github.com/eclipse/cloe) - 通过提供统一的闭环仿真接口，为自动驾驶软件组件的开发人员提供支持.
* [Dynamic_logistics_Warehouse](https://github.com/belal-ibrahim/dynamic_logistics_warehouse) - 仓库动态环境的凉亭模拟.
* [OpenCDA](https://github.com/ucla-mobility/OpenCDA) - 用于在 CARLA+SUMO 下对全栈协同驾驶自动化应用程序进行原型设计的通用框架.


## Electronics and Mechanics
* [HRIM](https://github.com/AcutronicRobotics/HRIM) - 机器人硬件的信息模型.
* [URDF](https://github.com/ros/urdf) - 统一机器人描述格式 (URDF) 解析代码的存储库.
* [phobos](https://github.com/dfki-ric/phobos) - Blender 的附加组件，允许在 WYSIWYG 环境中创建 URDF、SDF 和 SMURF 机器人模型.
* [urdf-viz](https://github.com/OTL/urdf-viz) - 可视化 URDF/XACRO 文件，URDF 查看器适用于 Windows/macOS/Linux.
* [solidworks_urdf_exporter](https://github.com/ros/solidworks_urdf_exporter) - SolidWorks 到 URDF 导出器.
* [FreeCAD](https://github.com/FreeCAD/FreeCAD) - 您自己的 3D 参数化建模器.
* [kicad](http://www.kicad.org/) - 跨平台和开源电子设计自动化套件.
* [PcbDraw](https://github.com/yaqwsx/PcbDraw) - 将您的 KiCAD 板转换为适合引脚图的漂亮 2D 绘图.
* [kicad-3rd-party-tools](https://github.com/xesscorp/kicad-3rd-party-tools) - 其他人为增强 KiCad PCB EDA 套件而制作的工具.
* [PandaPower](http://www.pandapower.org) - 一种易于使用的开源工具，用于高度自动化的电力系统建模、分析和优化.
* [LibrePCB](https://github.com/LibrePCB/LibrePCB) - 适合所有人的强大、创新和直观的 EDA 工具.
* [openscad](https://github.com/openscad/openscad) - 用于创建实体 3D CAD 模型的软件.
* [ngspice](http://ngspice.sourceforge.net/) - 用于电气和电子电路的开源 spice 模拟器.
* [GNSS-SDR](https://github.com/gnss-sdr/gnss-sdr) - GNSS-SDR 为各种射频前端和原始样本文件格式提供接口，生成标准格式的处理输出.
* [riscv](https://riscv.org) - 免费开放的 RISC 指令集架构.
* [urdfpy](https://github.com/mmatl/urdfpy) - 一个简单易用的库，用于加载、操作、保存和可视化 URDF 文件.
* [FMPy](https://github.com/CATIA-Systems/FMPy) - 在 Python 中模拟功能模型单元 (FMU).
* [FMIKit-Simulink](https://github.com/CATIA-Systems/FMIKit-Simulink) - 使用 Simulink 导入和导出功能模型单元.
* [oemof-solph](https://github.com/oemof/oemof-solph) - 用于模拟能源供应系统的模块化开源框架.
* [NASA-3D-Resources](https://github.com/nasa/NASA-3D-Resources) - 在这里，您会发现越来越多的 3D 模型、纹理和来自 NASA 内部的图像.
* [SUAVE](https://github.com/suavecode/SUAVE) - 飞机设计工具箱.
* [opem](https://github.com/ECSIM/opem) - 开源 PEMFC 仿真工具 (OPEM) 是一种用于评估质子交换膜燃料电池性能的建模工具.
* [pvlib-python](https://github.com/pvlib/pvlib-python) - 一个社区支持的工具，提供一组用于模拟光伏能源系统性能的函数和类.
* [WireViz](https://github.com/formatc1702/WireViz) - 一种用于轻松记录电缆、线束和连接器引出线的工具.
* [Horizon](https://github.com/horizon-eda/horizon) - EDA 是一个电子设计自动化包，支持印刷电路板设计的集成端到端工作流程，包括零件管理和原理图输入.
* [tigl](https://github.com/DLR-SC/tigl) - TiGL 几何库可用于计算和处理存储在 CPACS 文件中的飞机几何形状.
* [foxBMS](https://github.com/foxBMS/foxbms) - 用于设计电池管理系统的免费、开放和灵活的开发环境.
* [cadCAD](https://github.com/cadCAD-org/cadCAD) - 一个 Python 包，可通过模拟协助设计、测试和验证复杂系统的过程，支持蒙特卡罗方法、A/B 测试和参数扫描.
* [OpenMDAO](https://github.com/OpenMDAO/OpenMDAO) - 用于高效多学科优化的开源框架.
* [ODrive](https://github.com/madcowswe/ODrive) - 目的是使在高性能机器人项目中使用便宜的无刷电机成为可能.
* [OpenTirePython](https://github.com/OpenTire/OpenTirePython) - 一个开源数学轮胎建模库.
* [Inkscape Ray Optics](https://github.com/damienBloch/inkscape-raytracing) - Inkscape 的扩展，可以更轻松地绘制光学图.
* [OpenAeroStruct](https://github.com/mdolab/OpenAeroStruct) - 使用 OpenMDAO 执行航空结构优化的轻量级工具.

## Sensor Processing
### Calibration and Transformation
* [tf2](http://wiki.ros.org/tf2) - 转换库，它允许用户随着时间的推移跟踪多个坐标系.
* [TriP](https://github.com/TriPed-Robot/TriP) - 用于串行机器人、并联机器人和两者混合体的反向运动学库.
* [lidar_align](https://github.com/ethz-asl/lidar_align) - 一种用于查找 3D 激光雷达和 6 自由度位姿传感器之间外部校准的简单方法.
* [kalibr](https://github.com/ethz-asl/kalibr) - Kalibr 视觉惯性校准工具箱.
* [Calibnet](https://github.com/epiception/CalibNet) - 使用 3D 空间变换器网络进行自监督外部校准.
* [lidar_camera_calibration](https://github.com/ankitdhall/lidar_camera_calibration) - ROS 包，用于查找 LiDAR 和相机之间的刚体转换.
* [ILCC](https://github.com/mfxox/ILCC) - 反射强度辅助 3D LiDAR 的自动和准确外部校准.
* [easy_handeye](https://github.com/IFL-CAMP/easy_handeye) - 用于手眼校准的简单、直接的 ROS 库.
* [imu_utils](https://github.com/gaowenliang/imu_utils) - 用于分析 IMU 性能的 ROS 封装工具.
* [kalibr_allan](https://github.com/rpng/kalibr_allan) - 用于 Kalibr 和惯性卡尔曼滤波器的 IMU Allan 标准偏差图表.
* [pyquaternion](https://github.com/KieranWynn/pyquaternion) - 用于表示和使用四元数的全功能 Python 模块.
* [robot_calibration](https://github.com/mikeferguson/robot_calibration/) - 该软件包提供对机器人许多参数的校准，例如：3D 相机内在参数、外在参数关节角度偏移和机器人框架偏移.
* [multi_sensor_calibration](https://github.com/tudelft-iv/multi_sensor_calibration/) - 包含一个校准工具，用于校准由激光雷达、雷达和相机组成的传感器设置.
* [LiDARTag](https://github.com/UMich-BipedLab/LiDARTag) - 使用点云激光雷达数据的实时基准标签.
* [multicam_calibration](https://github.com/KumarRobotics/multicam_calibration) - 相机的外部和内部校准.
* [ikpy](https://github.com/Phylliade/ikpy) - 一个以性能和模块化为目标的反向运动学库.
* [livox_camera_lidar_calibration](https://github.com/Livox-SDK/livox_camera_lidar_calibration) - 校准Livox LiDAR 和相机之间的外部参数.
* [lidar_camera_calibration](https://github.com/heethesh/lidar_camera_calibration) - 使用 ROS、OpenCV 和 PCL 的相机 LiDAR 校准.
* [e2calib](https://github.com/uzh-rpg/e2calib) - 包含从事件数据实现视频重建以进行校准的代码.


### Perception Pipeline
* [SARosPerceptionKitti](https://github.com/appinho/SARosPerceptionKitti) - 用于 KITTI 视觉基准套件的感知（传感器处理、检测、跟踪和评估）的 ROS 包.
* [multiple-object-tracking-lidar](https://github.com/praveen-palanisamy/multiple-object-tracking-lidar) - 使用 LIDAR 扫描或点云检测、跟踪和分类多个对象的 C++ 实现.
* [cadrl_ros](https://github.com/mfe7/cadrl_ros) - 用于使用深度 RL 训练的地面机器人动态避障的 ROS 包.
* [AugmentedAutoencoder](https://github.com/DLR-RM/AugmentedAutoencoder) - 用于对象检测和 6D 姿态估计的基于 RGB 的管道.
* [jsk_recognition](https://github.com/jsk-ros-pkg/jsk_recognition) - JSK 实验室中使用的感知包堆栈.
* [GibsonEnv](https://github.com/StanfordVL/GibsonEnv) - 吉布森环境：具体代理人的真实世界感知.
* [morefusion](https://github.com/wkentaro/morefusion) - 基于体积融合的 6D 姿态估计的多目标推理.
* [se(3)-TrackNet](https://github.com/wenbowen123/iros20-6d-pose-tracking) - 当对象的 CAD 模型可用时，用于动态对象的 6D 姿态跟踪的包.

### Machine Learning
* [DLIB](https://github.com/davisking/dlib) - 用于在 C++ 中制作真实世界机器学习和数据分析应用程序的工具包.
* [fastai](https://github.com/fastai/fastai) - fastai 库使用现代最佳实践简化了快速准确的神经网络训练.
* [tpot](https://github.com/EpistasisLab/tpot) - 一种 Python 自动机器学习工具，可使用遗传编程优化机器学习管道.
* [deap](https://github.com/DEAP/deap) - Python 中的分布式进化算法.
* [gym](https://github.com/openai/gym) - 用于开发和比较强化学习算法的工具包.
* [tensorflow_ros_cpp](https://github.com/tradr-project/tensorflow_ros_cpp) - 一个 ROS 包，允许在 C++ 中进行 Tensorflow 推理，而无需自己编译 TF.
* [Tensorflow Federated](https://github.com/tensorflow/federated) - TensorFlow Federated (TFF) 是一个开源框架，用于机器学习和其他分散数据计算.
* [finn](https://github.com/Xilinx/finn) - FPGA 上快速、可扩展的量化神经网络推理.
* [neuropod](https://github.com/uber/neuropod) - Neuropod 是一个库，它提供了一个统一的接口来运行来自 C++ 和 Python 的多个框架的深度学习模型.
* [leela-zero](https://github.com/leela-zero/leela-zero) - 这是对 Alpha Go Zero 论文“在没有人类知识的情况下掌握围棋游戏”中描述的系统的相当忠实的重新实现.
* [Trax](https://github.com/google/trax) - 专注于序列模型和强化学习的深度学习库.
* [mlflow](https://github.com/mlflow/mlflow) - 一个简化机器学习开发的平台，包括跟踪实验、将代码打包成可重现的运行以及共享和部署模型.
* [Netron](https://github.com/lutzroeder/Netron) - 神经网络、深度学习和机器学习模型的可视化工具.
* [MNN](https://github.com/alibaba/MNN) - 一个快速、轻量级的深度学习框架，经过阿里巴巴关键业务用例的实战测试.
* [Tensorforce](https://github.com/tensorforce/tensorforce) - 一个开源深度强化学习框架，强调模块化灵活的库设计和研究和实践应用的直接可用性.
* [Dopamine](https://github.com/google/dopamine) - 强化学习算法快速原型设计的研究框架.
* [catalyst](https://github.com/catalyst-team/catalyst) - 开发的重点是可重复性、快速实验和代码/想法的重用.
* [ray](https://github.com/ray-project/ray) - 用于构建和运行分布式应用程序的快速而简单的框架.
* [tf-agents](https://github.com/tensorflow/agents) - 用于上下文强盗和强化学习的可靠、可扩展且易于使用的 TensorFlow 库.
* [ReAgent](https://github.com/facebookresearch/ReAgent) - Facebook 开发和使用的用于应用强化学习 (RL) 的开源端到端平台.
* [Awesome-Mobile-Machine-Learning](https://github.com/fritzlabs/Awesome-Mobile-Machine-Learning) - 适用于 iOS、Android 和边缘设备的精选移动机器学习资源列表.
* [cnn-explainer](https://github.com/poloclub/cnn-explainer) - 通过交互式可视化学习卷积神经网络.
* [modelzoo](https://github.com/autowarefoundation/modelzoo) - 用于自动驾驶应用的机器学习模型集合.
* [nnstreamer-ros](https://github.com/nnstreamer/nnstreamer-ros) - 一组 Gstreamer 插件和 ROS 示例，可让 Gstreamer 开发人员轻松高效地采用神经网络模型，并让神经网络开发人员轻松高效地管理神经网络管道及其过滤器.


### Parallel Processing
* [dask](https://github.com/dask/dask) - 并行计算与 Python 的任务调度.
* [cupy](https://github.com/cupy/cupy) - 使用 CUDA 加速的类似 NumPy 的 API.
* [Thrust](https://github.com/thrust/thrust) - 类似于 C++ 标准库的 C++ 并行编程库.
* [ArrayFire](https://github.com/arrayfire/arrayfire) - 通用 GPU 库.
* [OpenMP](https://www.openmp.org/) - 支持 C、C++ 和 Fortran 多平台共享内存多处理编程的应用程序编程接口.
* [VexCL](https://github.com/ddemidov/vexcl) - VexCL 是用于 OpenCL/CUDA/OpenMP 的 C++ 矢量表达式模板库.
* [PYNQ](https://github.com/Xilinx/PYNQ) - Xilinx 的一个开源项目，可以轻松设计带有 Zynq All Programmable Systems on Chip 的嵌入式系统.
* [numba](https://github.com/numba/numba) - 使用 LLVM 的 NumPy 感知动态 Python 编译器.
* [TensorRT](https://github.com/NVIDIA/TensorRT) - 用于在 NVIDIA GPU 和深度学习加速器上进行高性能推理的 C++ 库.
* [libcudacxx](https://github.com/NVIDIA/libcudacxx) - 提供可在 CPU 和 GPU 代码中和之间使用的 C++ 标准库的异构实现.


### Image Processing
* [CV-pretrained-model](https://github.com/balavenkatesh3322/CV-pretrained-model) - 一组计算机视觉预训练模型.
* [image_pipeline](https://github.com/ros-perception/image_pipeline) - 填补了从相机驱动程序获取原始图像与更高级别视觉处理之间的差距.
* [gstreamer](https://gstreamer.freedesktop.org/) - 基于管道的多媒体框架，将各种媒体处理系统连接在一起以完成复杂的工作流程.
* [ros2_openvino_toolkit](https://github.com/intel/ros2_openvino_toolkit) - 提供适用于 ROS 的神经网络运行时框架，可快速部署用于视觉推理的应用程序和解决方案.
* [vision_visp](https://github.com/lagadic/vision_visp) - 将 ViSP 视觉伺服库提供的 ViSP 移动边缘跟踪器包装到 ROS 包中.
* [apriltag_ros](https://github.com/AprilRobotics/apriltag_ros) - AprilTag 3 视觉基准检测器的 ROS 包装器.
* [deep_object_pose](https://github.com/NVlabs/Deep_Object_Pose) - 深度物体姿态估计.
* [DetectAndTrack](https://github.com/facebookresearch/DetectAndTrack) 检测和跟踪：高效姿势.
* [SfMLearner](https://github.com/tinghuiz/SfMLearner) - 用于深度和自我运动估计的无监督学习框架.
* [imgaug](https://github.com/aleju/imgaug) - 用于机器学习实验的图像增强.
* [vision_opencv](https://github.com/ros-perception/vision_opencv) - 用于将 ROS 与 OpenCV 连接的软件包，OpenCV 是一个用于实时计算机视觉的编程函数库.
* [darknet_ros](https://github.com/leggedrobotics/darknet_ros) - YOLO ROS：ROS 的实时对象检测.
* [ros_ncnn](https://github.com/nilseuropa/ros_ncnn) - YOLACT / YOLO *( among other things )* on NCNN inference engine for ROS.
* [tf-pose-estimation](https://github.com/ildoonet/tf-pose-estimation) - 使用带有自定义架构的 Tensorflow 实现深度姿态估计以进行快速推理.
* [find-object](https://github.com/introlab/find-object) - 用于尝试 SIFT、SURF、FAST、BRIEF 和其他特征检测器和描述符的 OpenCV 实现的简单 Qt 接口.
* [yolact](https://github.com/dbolya/yolact) - 用于实时实例分割的简单、全卷积模型.
* [Kimera-Semantics](https://github.com/MIT-SPARK/Kimera-Semantics) - 基于 2D 数据的实时 3D 语义重建.
* [detectron2](https://github.com/facebookresearch/detectron2) - 用于对象检测和分割的下一代研究平台.
* [OpenVX](https://www.khronos.org/openvx/) - 实现性能和功率优化的计算机视觉处理，这在嵌入式和实时用例中尤为重要.
* [3d-vehicle-tracking](https://github.com/ucbdrive/3d-vehicle-tracking) - 联合单目 3D 车辆检测和跟踪的正式实施.
* [pysot](https://github.com/STVIR/pysot) - PySOT 的目标是为视觉跟踪研究提供高质量、高性能的代码库.
* [semantic_slam](https://github.com/floatlazer/semantic_slam) - 使用手持式 RGB-D 相机在 ROS 中进行实时语义冲击.
* [kitti_scan_unfolding](https://github.com/ltriess/kitti_scan_unfolding) - We propose KITTI scan unfolding in our paper Scan-based Semantic Segmentation of LiDAR Point Clouds: An Experimental Study.
* [packnet-sfm](https://github.com/TRI-ML/packnet-sfm) - 由丰田研究所 (TRI) 的 ML 团队发明的自监督单眼深度估计方法的官方 PyTorch 实现.
* [AB3DMOT](https://github.com/xinshuoweng/AB3DMOT) - 这项工作提出了一个简单而准确的实时基线 3D 多目标跟踪系统.
* [monoloco](https://github.com/vita-epfl/monoloco) - 在 PyTorch 中正式实施“MonoLoco：单目 3D 行人定位和不确定性估计”.
* [Poly-YOLO](https://gitlab.com/irafm-ai/poly-yolo) - 基于 YOLOv3 的原始思想并消除了它的两个弱点：大量重写的标签和低效的锚点分布.
* [satellite-image-deep-learning](https://github.com/robmarkcole/satellite-image-deep-learning) - 使用卫星和航拍图像进行深度学习的资源.
* [robosat](https://github.com/mapbox/robosat) - 航空和卫星图像的语义分割.
* [big_transfer](https://github.com/google-research/big_transfer) - 由 Google Research 创建的通用视觉表示学习模型.
* [LEDNet](https://github.com/xiaoyufenfei/LEDNet) - 用于实时语义分割的轻量级编码器-解码器网络.
* [TorchSeg](https://github.com/ycszen/TorchSeg) - 该项目旨在为使用 PyTorch 的语义分割模型提供快速、模块化的参考实现.
* [simpledet](https://github.com/tusimple/simpledet) - 用于对象检测和实例识别的简单而通用的框架.
* [meshroom](https://github.com/alicevision/meshroom) - Meshroom 是一款免费的开源 3D 重建软件，基于 AliceVision 摄影测量计算机视觉框架.
* [EasyOCR](https://github.com/JaidedAI/EasyOCR) - 即用型光学字符识别 (OCR)，支持 40 多种语言，包括中文、日文、韩文和泰文.
* [pytracking](https://github.com/visionml/pytracking) - 基于 PyTorch 的视觉对象跟踪和视频对象分割的通用 python 框架.
* [ros_deep_learning](https://github.com/dusty-nv/ros_deep_learning) - 支持 NVIDIA Jetson TX1/TX2/Xavier 和 TensorRT 的 ROS 深度学习推理节点.
* [hyperpose](https://github.com/tensorlayer/hyperpose) - HyperPose：用于实时人体姿势估计的灵活库.
* [fawkes](https://github.com/Shawn-Shan/fawkes) - 针对面部识别系统的隐私保护工具.
* [anonymizer](https://github.com/understand-ai/anonymizer) - 混淆面孔和车牌的匿名器.
* [opendatacam](https://github.com/opendatacam/opendatacam) - 仅保存调查的元数据，特别是对象移动的路径或某个点的计数对象的数量.
* [Cam2BEV](https://github.com/ika-rwth-aachen/Cam2BEV) - 用于根据多个车载摄像头的图像计算语义分割鸟瞰图 (BEV) 图像的 TensorFlow 实现.
* [flownet2-pytorch](https://github.com/NVIDIA/flownet2-pytorch) - FlowNet 2.0 的 Pytorch 实现：深度网络光流估计的演变.
* [Simd](https://github.com/ermig1979/Simd) - 使用 SIMD 的 C++ 图像处理和机器学习库：SSE、SSE2、SSE3、SSSE3、SSE4.1、SSE4.2、AVX、AVX2、AVX-512、VMX(Altivec) 和 VSX(Power7)、NEON for ARM .
* [AliceVision](https://github.com/alicevision/AliceVision) - 提供 3D 重建和相机跟踪算法的摄影测量计算机视觉框架.
* [satpy](https://github.com/pytroll/satpy) - 用于读取和操作气象遥感数据并将其写入各种图像和数据文件格式的 python 库.
* [eo-learn](https://github.com/sentinel-hub/eo-learn) - 已开发的开源 Python 包的集合，可以及时、自动地无缝访问和处理任何卫星舰队获取的时空图像序列.
* [libvips](https://github.com/libvips/libvips) - 具有低内存需求的快速图像处理库.


### Radar Processing
* [pyroSAR](https://github.com/johntruckenbrodt/pyroSAR) - 大规模 SAR 卫星数据处理框架.
* [CameraRadarFusionNet](https://github.com/TUMFTM/CameraRadarFusionNet) - TUM Roborace Team 软件堆栈 - 路径跟踪控制、速度控制、曲率控制和状态估计.


### Lidar and Point Cloud Processing
* [cilantro](https://github.com/kzampog/cilantro) - 用于处理点云数据的精简 C++ 库.
* [open3d](https://github.com/intel-isl/Open3D) - Open3D：用于 3D 数据处理的现代库.
* [SqueezeSeg](https://github.com/BichenWuUCB/SqueezeSeg) - 实施 SqueezeSeg，用于 LiDAR 点影响分割的卷积神经网络.
* [point_cloud_io](https://github.com/ANYbotics/point_cloud_io) - ROS 节点从文件（例如 ply、vtk）读取和写入点云.
* [python-pcl](https://github.com/strawlab/python-pcl) - Python 绑定到点云库.
* [libpointmatcher](https://github.com/ethz-asl/libpointmatcher) - 用于机器人技术中 2-D/3-D 映射的“迭代最近点”库.
* [depth_clustering](https://github.com/PRBonn/depth_clustering) - 使用 Velodyne 传感器生成的点云的快速且稳健的聚类.
* [lidar-bonnetal](https://github.com/PRBonn/lidar-bonnetal) - 用于自动驾驶的 LiDAR 点云的语义和实例分割.
* [CSF](https://github.com/jianboqi/CSF) - 基于布料模拟的LiDAR点云地面过滤/分割（bare earth extraction）方法.
* [robot_body_filter](https://github.com/peci1/robot_body_filter) - 高度可配置的 LaserScan/PointCloud2 过滤器，允许从测量中动态移除机器人的 3D 身体.
* [grid_map](https://github.com/ANYbotics/grid_map) - 用于移动机器人制图的通用网格地图库.
* [elevation_mapping](https://github.com/ANYbotics/elevation_mapping) - 用于粗糙地形导航的以机器人为中心的高程映射.
* [rangenet_lib](https://github.com/PRBonn/rangenet_lib) - 包含有关 RangeNet++ 推理如何与 TensorRT 和 C++ 接口一起工作的简单用法说明.
* [pointcloud_to_laserscan](https://github.com/ros-perception/pointcloud_to_laserscan) - 将 3D 点云转换为 2D 激光扫描.
* [octomap](https://github.com/OctoMap/octomap) - 基于八叉树的高效概率 3D 映射框架.
* [pptk](https://github.com/heremaps/pptk) - 来自 HEREMaps 的点处理工具包.
* [gpu-voxels](https://www.gpu-voxels.org/) - GPU-Voxels 是一个基于 CUDA 的库，它允许在动画 3D 模型和来自各种 3D 传感器的实时点云之间进行高分辨率体积碰撞检测.
* [spatio_temporal_voxel_layer](https://github.com/SteveMacenski/spatio_temporal_voxel_layer) - 一个新的体素层利用现代 3D 图形工具使导航环境表示现代化.
* [LAStools](https://github.com/LAStools/LAStools) - 用于高效 LiDAR 处理的屡获殊荣的软件.
* [PCDet](https://github.com/sshaoshuai/PCDet) - 基于 PyTorch 的通用代码库，用于从点云进行 3D 对象检测.
* [PDAL](https://github.com/PDAL/PDAL) - 用于转换和操作点云数据的 C++ BSD 库.
* [PotreeConverter](https://github.com/potree/PotreeConverter) - 从 las、laz、二进制层、xyz 或 ptx 文件构建一个 potree 八叉树.
* [fast_gicp](https://github.com/SMRT-AIST/fast_gicp) - 一组基于 GICP 的快速点云配准算法.
* [ndt_omp](https://github.com/koide3/ndt_omp) - 多线程和 SSE 友好的 NDT 算法.
* [laser_line_extraction](https://github.com/kam3k/laser_line_extraction) - 从 LaserScan 消息中提取线段的 ROS 包.
* [Go-ICP](https://github.com/yangjiaolong/Go-ICP) - 实施用于全局最优 3D 点集配准的 Go-ICP 算法.
* [PointCNN](https://github.com/yangyanli/PointCNN) - 一个简单通用的点云特征学习框架.
* [segmenters_lib](https://github.com/LidarPerception/segmenters_lib) - LiDAR 分割器库，用于基于分割的检测.
* [MotionNet](https://github.com/pxiangwu/MotionNet) - 基于鸟瞰图的自动驾驶联合感知和运动预测.
* [PolarSeg](https://github.com/edwardzhou130/PolarSeg) - 改进的在线 LiDAR 点云语义分割网格表示.
* [traversability_mapping](https://github.com/TixiaoShan/traversability_mapping) - 从 Velodyne VLP-16 激光雷达获取点云，并实时输出用于自主导航的可穿越性地图.
* [lidar_super_resolution](https://github.com/RobustFieldAutonomyLab/lidar_super_resolution) - 用于地面车辆的基于仿真的激光雷达超分辨率.
* [Cupoch](https://github.com/neka-nat/cupoch) - 使用 CUDA 实现快速 3D 数据处理和机器人计算的库.
* [linefit_ground_segmentation](https://github.com/lorenwel/linefit_ground_segmentation) - 地面分割算法的实现.
* [Draco](https://github.com/google/draco) - 用于压缩和解压缩 3D 几何网格和点云的库.
* [Votenet](https://github.com/facebookresearch/votenet) - 用于点云中 3D 对象检测的深度霍夫投票.
* [lidar_undistortion](https://github.com/ethz-asl/lidar_undistortion) - 提供基于外部 6DoF 姿态估计输入的激光雷达运动不失真.
* [superpoint_graph](https://github.com/loicland/superpoint_graph) - 具有超点图的大规模点云语义分割.
* [RandLA-Net](https://github.com/QingyongHu/RandLA-Net) - 大规模点云的高效语义分割.
* [Det3D](https://github.com/poodarchu/Det3D) - 第一个 3D 对象检测工具箱，它提供了许多 3D 对象检测算法的现成实现，例如 PointPillars、SECOND、PIXOR.
* [OverlapNet](https://github.com/PRBonn/OverlapNet) - 一种改进的连体网络，可预测由 3D LiDAR 扫描生成的一对距离图像的重叠和相对偏航角.
* [mp2p_icp](https://github.com/MOLAorg/mp2p_icp) - C++ 中的多原语到原语 (MP2P) ICP 算法库.
* [OpenPCDet](https://github.com/open-mmlab/OpenPCDet) - 用于基于 LiDAR 的 3D 对象检测的工具箱.
* [torch-points3d](https://github.com/nicolas-chaulet/torch-points3d) - 用于在点云上进行深度学习的 Pytorch 框架.
* [PolyFit](https://github.com/LiangliangNan/PolyFit) - 从点云重建多边形表面.
* [mmdetection3d](https://github.com/open-mmlab/mmdetection3d) - 用于通用 3D 对象检测的下一代平台.
* [gpd](https://github.com/atenpas/gpd) - 将点云作为输入并生成可行抓取的姿势估计作为输出.
* [SalsaNext](https://github.com/TiagoCortinhal/SalsaNext) - 用于自动驾驶的 LiDAR 点云的不确定性感知语义分割.
* [Super-Fast-Accurate-3D-Object-Detection](https://github.com/maudzung/Super-Fast-Accurate-3D-Object-Detection) - 基于 3D LiDAR 点云（PyTorch 实现）的超快速和准确的 3D 对象检测.
* [kaolin](https://github.com/NVIDIAGameWorks/kaolin) - 用于加速 3D 深度学习研究的 PyTorch 库.
* [CamVox](https://github.com/ISEE-Technology/CamVox) - 基于摄像头和 Livox 激光雷达的低成本 SLAM 系统.
* [SA-SSD](https://github.com/skyhehe123/SA-SSD) - 来自点云的结构感知单级 3D 对象检测.
* [cuda-pcl](https://github.com/NVIDIA-AI-IOT/cuda-pcl) - 使用基于 NVIDIA CUDA 的 PCL 加速机器人激光雷达.
* [urban_road_filter](https://github.com/jkk-research/urban_road_filter) - 用于自动驾驶车辆的基于激光雷达的实时城市道路和人行道检测.
* [Removert](https://github.com/irapkaist/removert)  - 删除然后还原. 野外静态地图构建和动态点移除工具通过构建静态地图.
* [KISS-ICP](https://github.com/PRBonn/kiss-icp) - 一个 LiDAR 里程计管道，只适用于大多数情况，无需调整任何参数.

## Localization and State Estimation
* [evo](https://github.com/MichaelGrupp/evo) - 用于评估里程计和 SLAM 的 Python 包.
* [robot_localization](https://github.com/cra-ros-pkg/robot_localization) - 一组非线性状态估计节点.
* [fuse](https://github.com/locusrobotics/fuse) - 在机器人上实时执行传感器融合的通用架构.
* [GeographicLib](https://github.com/Sciumo/GeographicLib) - 用于地理投影的 C++ 库.
* [ntripbrowser](https://github.com/emlid/ntripbrowser) - 用于浏览 NTRIP（通过 Internet 协议的 RTCM 网络传输）的 Python API.
* [imu_tools](https://github.com/ccny-ros-pkg/imu_tools) - IMU 相关过滤器和可视化工具.
* [RTKLIB](https://github.com/rtklibexplorer/RTKLIB) - 为单频和双频低成本 GPS 接收器优化的 RTKLIB 版本，尤其是 u-blox 接收器.
* [gLAB](https://gage.upc.edu/gLAB/) - 在厘米级对 GNSS 可观测值（伪距和载波相位）进行精确建模，允许独立的 GPS 定位、PPP、SBAS 和 DGNSS.
* [ai-imu-dr](https://github.com/mbrossar/ai-imu-dr) - 包含我们仅基于 IMU 的轮式车辆航位推算的新颖准确方法的代码.
* [Kalman-and-Bayesian-Filters-in-Python](https://github.com/rlabbe/Kalman-and-Bayesian-Filters-in-Python) - 使用 Jupyter 笔记本的卡尔曼滤波器书.
* [mcl_3dl](https://github.com/at-wat/mcl_3dl) - 一个 ROS 节点，用于为具有 3-D LIDAR(s) 的移动机器人执行概率 3-D/6-DOF 定位系统.
* [se2lam](https://github.com/izhengfan/se2lam) - On-SE(2) 通过融合里程计和视觉对地面车辆进行定位和映射.
* [mmWave-localization-learning](https://github.com/gante/mmWave-localization-learning) - 来自毫米波传输的基于 ML 的定位方法 - 具有高精度和能源效率.
* [dynamic_robot_localization](https://github.com/carlosmccosta/dynamic_robot_localization) - 一个 ROS 包，使用 PCL 提供 3 DoF 和 6 DoF 定位，并允许使用 OctoMap 进行动态地图更新.
* [eagleye](https://github.com/MapIV/eagleye) - 利用 GNSS 和 IMU 进行车辆定位的开源软件.
* [python-sgp4](https://github.com/brandon-rhodes/python-sgp4) - SGP4 卫星位置库的 Python 版本.
* [PROJ](https://github.com/OSGeo/PROJ) - 制图投影和坐标变换库.
* [rpg_trajectory_evaluation](https://github.com/uzh-rpg/rpg_trajectory_evaluation) - 实现视觉（惯性）里程计的常用轨迹评估方法.
* [pymap3d](https://github.com/geospace-code/pymap3d) - 用于地理空间 ecef enu eci 的纯 Python（Numpy 可选）3D 坐标转换.
* [libRSF](https://github.com/TUC-ProAut/libRSF) - 用于在线本地化的强大传感器融合库.

## Simultaneous Localization and Mapping
### Lidar
* [KISS-ICP](https://github.com/PRBonn/kiss-icp) - 一个 LiDAR 里程计管道，只适用于大多数情况，无需调整任何参数.
* [loam_velodyne](https://github.com/laboshinl/loam_velodyne) - 激光测距和测绘 (Loam) 是一种使用 3D 激光雷达进行状态估计和测绘的实时方法.
* [lio-mapping](https://github.com/hyye/lio-mapping) - 紧耦合 3D 激光雷达惯性里程计和映射（LIO 映射）的实现.
* [A-LOAM](https://github.com/HKUST-Aerial-Robotics/A-LOAM) - LOAM 的高级实施.
* [Fast LOAM](https://github.com/wh200720041/floam) - 快速和优化的激光雷达里程计和映射.
* [LIO_SAM](https://github.com/TixiaoShan/LIO-SAM) - 通过平滑和映射的紧耦合激光雷达惯性里程计.
* [cartographer_ros](https://github.com/googlecartographer/cartographer_ros) - 为 Cartographer 提供 ROS 集成.
* [loam_livox](https://github.com/hku-mars/loam_livox) - 用于 Livox-LiDAR 的强大的 LiDAR 里程计和映射 (LOAM) 包.
* [StaticMapping](https://github.com/EdwardLiuyc/StaticMapping) - 使用 LiDAR 绘制静态世界地图.
* [semantic_suma](https://github.com/PRBonn/semantic_suma/) - 使用面元映射和语义分割的语义映射.
* [slam_toolbox](https://github.com/SteveMacenski/slam_toolbox) - Slam 工具箱，用于使用 ROS 在潜在的大型地图中进行终身映射和定位.
* [maplab](https://github.com/ethz-asl/maplab) - 一个开放的视觉惯性映射框架.
* [hdl_graph_slam](https://github.com/koide3/hdl_graph_slam) - 用于使用 3D LIDAR 进行实时 6DOF SLAM 的开源 ROS 包.
* [interactive_slam](https://github.com/SMRT-AIST/interactive_slam) - 与现有的自动 SLAM 包相比，我们用最少的人力.
* [LeGO-LOAM](https://github.com/RobustFieldAutonomyLab/LeGO-LOAM) - 轻型和地面优化的可变地形激光雷达测距和测绘.
* [pyslam](https://github.com/luigifreda/pyslam) - 包含 Python 中的单眼视觉里程计 (VO) 管道.
* [Kitware SLAM](https://gitlab.kitware.com/keu-computervision/slam/) - 由 Kitware 开发的仅限 LiDAR 的视觉 SLAM，以及更易于使用的 ROS 和 ParaView 封装.
* [horizon_highway_slam](https://github.com/Livox-SDK/horizon_highway_slam) - 适用于 Livox Horizo​​n 激光雷达的稳健、低漂移和实时高速公路 SLAM 包.
* [mola](https://github.com/MOLAorg/mola) - 用于定位和映射的模块化系统.
* [DH3D](https://github.com/JuanDuGit/DH3D) - 用于强大的大规模 6DOF 重新定位的深度分层 3D 描述符.
* [LaMa](https://github.com/iris-ua/iris_lama) - LaMa 是一个用于机器人定位和映射的 C++11 软件库.
* [Scan Context](https://github.com/irapkaist/scancontext) - Global LiDAR descriptor for place recognition and long-term localization.
* [M-LOAM](https://github.com/gogojjh/M-LOAM) - 具有在线外部校准的多 LiDAR 系统的稳健里程计和映射.


### Visual
* [orb_slam_2_ros](https://github.com/appliedAI-Initiative/orb_slam_2_ros) - ORB_SLAM2 的 ROS 实现.
* [orbslam-map-saving-extension](https://github.com/TUMFTM/orbslam-map-saving-extension) - 在此扩展中，ORB 特征图将保存到磁盘中，作为未来沿同一轨道运行的参考.
* [dso](https://github.com/JakobEngel/dso/) - 直接稀疏里程计.
* [viso2](https://github.com/srv/viso2) - 用于 libviso2 的 ROS 包装器，用于视觉里程计的库.
* [xivo](https://github.com/ucla-vision/xivo) - X 惯性辅助视觉里程计.
* [rovio](https://github.com/ethz-asl/rovio) - 强大的视觉惯性里程计框架.
* [LSD-SLAM](https://github.com/tum-vision/lsd_slam) - Large-Scale Direct Monocular SLAM 是一种实时的单目 SLAM.
* [CubeSLAM and ORB SLAM](https://github.com/shichaoy/cube_slam) - CubeSLAM 和 ORB SLAM 的单目 3D 物体检测和 SLAM 包.
* [VINS-Fusion](https://github.com/HKUST-Aerial-Robotics/VINS-Fusion) - 稳健且多功能的多传感器视觉惯性状态估计器.
* [openvslam](https://github.com/xdspacelab/openvslam) - OpenVSLAM：一个多功能的视觉 SLAM 框架.
* [basalt](https://gitlab.com/VladyslavUsenko/basalt) - 具有非线性因子恢复的视觉惯性映射.
* [Kimera](https://github.com/MIT-SPARK/Kimera) - 用于实时度量语义同时定位和映射的 C++ 库，它使用相机图像和惯性数据来构建环境的语义注释 3D 网格.
* [tagslam](https://github.com/berndpfrommer/tagslam) - 基于 ROS 的包，用于使用 AprilTag 基准标记进行同步定位和映射.
* [LARVIO](https://github.com/PetWorm/LARVIO) - 基于多态约束卡尔曼滤波器的轻量级、准确且稳健的单目视觉惯性里程计.
* [fiducials](https://github.com/UbiquityRobotics/fiducials) - 使用基准标记同时定位和映射.
* [open_vins](https://github.com/rpng/open_vins) - 用于视觉惯性导航研究的开源平台.
* [ORB_SLAM3](https://github.com/UZ-SLAMLab/ORB_SLAM3) - ORB-SLAM3：用于视觉、视觉惯性和多地图 SLAM 的精确开源库.
* [Atlas](https://github.com/magicleap/Atlas) - 从姿势图像重建端到端 3D 场景.
* [vilib](https://github.com/uzh-rpg/vilib) - 该库专注于使用 CUDA 的 VIO 管道的前端.
* [hloc](https://github.com/cvg/Hierarchical-Localization)  - 用于最先进的 6-DoF 视觉定位的模块化工具箱. 它实现了分层定位，利用图像检索和特征匹配，并且快速、准确和可扩展.
* [ESVO](https://github.com/HKUST-Aerial-Robotics/ESVO) - 一种使用基于立体事件的相机进行实时视觉里程计的新颖管道.
* [gradslam](https://github.com/gradslam/gradslam) - 用于 PyTorch 的开源可区分密集 SLAM 库.


### Vector Map
* [OpenDRIVE](http://www.opendrive.org/index.html) - 用于道路网络逻辑描述的开放文件格式.
* [MapsModelsImporter](https://github.com/eliemichel/MapsModelsImporter) - 用于从谷歌地图导入模型的 Blender 插件.
* [Lanelet2](https://github.com/fzi-forschungszentrum-informatik/Lanelet2) - 用于自动驾驶的地图处理框架.
* [barefoot](https://github.com/bmwcarit/barefoot) - 可以独立使用和在云端使用的在线和离线地图匹配.
* [iD](https://github.com/openstreetmap/iD) - 易于使用的 JavaScript OpenStreetMap 编辑器.
* [RapiD](https://github.com/facebookincubator/RapiD) - 增强版 iD，用于与 Facebook 创建的 AI 进行映射.
* [segmap](https://github.com/ethz-asl/segmap) - 基于 3D 分段的地图表示.
* [Mapbox](https://github.com/mapbox/mapbox-gl-js) - 一个 JavaScript 库，用于在 Web 上进行交互式、可自定义的矢量地图.
* [osrm-backend](https://github.com/Project-OSRM/osrm-backend) - 开源路由机 - C++ 后端.
* [assuremapingtools](https://github.com/hatem-darweesh/assuremapingtools) - 基于桌面的工具，用于查看、编辑和保存自动驾驶车辆平台（例如 Autoware）的道路网络地图.
* [geopandas](https://github.com/geopandas/geopandas) - 一个为熊猫对象添加地理数据支持的项目.
* [MapToolbox](https://github.com/autocore-ai/MapToolbox) - 在 Unity 中制作 Autoware 矢量地图的插件.
* [imagery-index](https://github.com/ideditor/imagery-index) - 对制图有用的航空和卫星图像索引.
* [mapillary_tools](https://github.com/mapillary/mapillary_tools) - 用于处理图像并将图像上传到 Mapillary 的库.
* [mapnik](https://github.com/mapnik/mapnik) - 将像素完美的图像输出与闪电般快速的制图算法相结合，并在 C++、Python 和 Node.js 中公开接口.
* [gdal](https://github.com/OSGeo/gdal) - GDAL 是一个开源的 X/MIT 许可翻译库，用于栅格和矢量地理空间数据格式.
* [grass](https://github.com/OSGeo/grass) - GRASS GIS - 免费和开源的地理信息系统 (GIS).
* [3d-tiles](https://github.com/CesiumGS/3d-tiles) - 流式传输大量异构 3D 地理空间数据集的规范.
* [osmnx](https://github.com/gboeing/osmnx)  - 用于街道网络的 Python. 从 OpenStreetMap 检索、建模、分析和可视化街道网络和其他空间数据.

## Prediction
* [Awesome-Interaction-aware-Trajectory-Prediction](https://github.com/jiachenli94/Awesome-Interaction-aware-Trajectory-Prediction) - 一系列关于轨迹预测的最先进的研究材料.
* [sgan](https://github.com/agrimgupta92/sgan) - 生成对抗网络的社会可接受轨迹.

## Behavior and Decision
* [Groot](https://github.com/BehaviorTree/Groot)  - 创建行为树的图形编辑器. 符合 BehaviorTree.CPP.
* [BehaviorTree.CPP](https://github.com/BehaviorTree/BehaviorTree.CPP) - C++ 中的行为树库.
* [RAFCON](https://github.com/DLR-RM/RAFCON) - 使用具有并发状态执行功能的分层状态机来表示机器人程序.
* [ROSPlan](https://github.com/KCL-Planning/ROSPlan) - ROS 系统中任务规划的通用框架.
* [ad-rss-lib](https://github.com/intel/ad-rss-lib) - 为自动驾驶汽车实施责任敏感安全模型 (RSS) 的图书馆.
* [FlexBE](https://flexbe.github.io/) - 分层状态机的图形编辑器，基于 ROS 的 smach.
* [sts_bt_library](https://github.com/Autonomous-Logistics/sts_bt_library) - 该库提供了通过使用定义的树结构（如 Fallback、Sequence 或 Parallel Nodes）来设置您自己的行为树逻辑的功能.
* [SMACC](https://github.com/reelrbtx/SMACC) - 一个事件驱动、异步、行为状态机库，用于用 C++ 编写的实时 ROS（机器人操作系统）应用程序.
* [py_trees_ros](https://github.com/splintered-reality/py_trees_ros) - 扩展 py_trees 以与 ROS 一起使用的行为、树和实用程序.

## Planning and Control
* [pacmod](https://github.com/astuff/pacmod) - 旨在允许用户使用 PACMod 线控驱动系统控制车辆.
* [mpcc](https://github.com/alexliniger/MPCC) - 用于自动赛车的模型预测轮廓控制器.
* [rrt](https://github.com/RoboJackets/rrt) - C++ RRT（快速探索随机树）实现.
* [HypridAStarTrailer](https://github.com/AtsushiSakai/HybridAStarTrailer) - 一种基于混合A*的拖车路径规划算法.
* [path_planner](https://github.com/karlkurzer/path_planner) - KTH 研究概念车的混合 A* 路径规划器.
* [open_street_map](https://github.com/ros-geographic-info/open_street_map) - 用于处理 Open Street Map 地理信息的 ROS 包.
* [Open Source Car Control](https://github.com/PolySync/oscc) - 软件和硬件设计的组合，使计算机能够控制现代汽车，以促进自动驾驶汽车技术的发展.
* [fastrack](https://github.com/HJReachability/fastrack) - 快速安全跟踪 (FaSTrack) 的 ROS 实现.
* [commonroad](https://commonroad.in.tum.de/) - 道路运动规划的可组合基准.
* [traffic-editor](https://github.com/osrf/traffic-editor) - 机器人交通流的图形编辑器.
* [steering_functions](https://github.com/hbanzhaf/steering_functions) - 包含一个 C++ 库，该库为具有有限转弯半径的类车机器人实现转向功能.
* [moveit](https://moveit.ros.org/) - 易于使用的机器人操作平台，用于开发应用程序、评估设计和构建集成产品.
* [flexible-collision-library](https://github.com/flexible-collision-library/fcl) - 用于对由三角形组成的一对几何模型执行三种类型的邻近查询的库.
* [aikido](https://github.com/personalrobotics/aikido) - 用于运动学、动力学和优化的人工智能.
* [casADi](https://github.com/casadi/casadi) - 用于在稀疏矩阵值计算图上实现正向和反向模式自动微分的数值优化的符号框架.
* [ACADO Toolkit](https://github.com/acado/acado) - 用于自动控制和动态优化的软件环境和算法集合.
* [control-toolbox](https://github.com/ethz-adrl/control-toolbox) - An efficient C++ library for control, estimation, optimization and motion planning in robotics.
* [CrowdNav](https://github.com/vita-epfl/CrowdNav) - 具有基于注意力的深度强化学习的人群感知机器人导航.
* [ompl](https://github.com/ompl/ompl) - 由许多最先进的基于采样的运动规划算法组成.
* [openrave](https://github.com/rdiankov/openrave) - 开放式机器人自动化虚拟环境：用于测试、开发和部署机器人运动规划算法的环境.
* [teb_local_planner](https://github.com/rst-tu-dortmund/teb_local_planner) - 考虑基于定时弹性带的移动机器人独特拓扑结构的最佳轨迹规划器.
* [pinocchio](https://github.com/stack-of-tasks/pinocchio) - 快速灵活地实施刚体动力学算法及其分析衍生物.
* [rmf_core](https://github.com/osrf/rmf_core) - rmf_core 包提供机器人中间件框架 (RMF) 的集中功能.
* [OpEn](https://github.com/alphaville/optimization-engine) - 用于下一代机器人和自主系统的快速准确嵌入式优化的求解器.
* [autogenu-jupyter](https://github.com/mayataka/autogenu-jupyter) - 该项目为非线性模型预测控制 (NMPC) 提供基于延拓/GMRES 方法（C/GMRES 方法）的求解器和 NMPC 的自动代码生成器.
* [global_racetrajectory_optimization](https://github.com/TUMFTM/global_racetrajectory_optimization) - 此存储库包含多种生成全局轨迹的方法.
* [toppra](https://github.com/hungpham2511/toppra) - 用于计算受运动学和动态约束的机器人的时间最优路径参数化的库.
* [tinyspline](https://github.com/msteinbeck/tinyspline) - TinySpline 是一个用于插值、转换和查询任意 NURBS、B-Splines 和 Bézier 曲线的小而强大的库.
* [dual quaternions ros](https://github.com/Achllle/dual_quaternions_ros) - 用于双四元数 SLERP 的 ROS python 包.
* [mb planner](https://github.com/unr-arl/mbplanner_ros)  - 适用于狭小空间的飞行器规划器. 用于 DARPA SubT 挑战赛.
* [ilqr](https://github.com/anassinator/ilqr) - 具有自动微分动力学模型的迭代线性二次调节器.
* [EGO-Planner](https://github.com/ZJU-FAST-Lab/ego-planner) - 一种没有 ESDF 构造的轻量级基于梯度的局部规划器，与一些最先进的方法相比，它显着减少了计算时间.
* [pykep](https://github.com/esa/pykep) - 一个科学图书馆，为行星际轨道设计研究提供基本工具.
* [am_traj](https://github.com/ZJU-FAST-Lab/am_traj) - 用于四旋翼飞行器的基于交替最小化的轨迹生成.
* [GraphBasedLocalTrajectoryPlanner](https://github.com/TUMFTM/GraphBasedLocalTrajectoryPlanner) - 在 Roborace Season Alpha 期间用于真正的赛车并达到 200 公里/小时以上的速度.
* [se2_navigation](https://github.com/leggedrobotics/se2_navigation) - 用于 SE(2) 空间导航的纯追踪控制器和基于 Reeds-Shepp 采样的规划器.
* [Ruckig](https://ruckig.com)  - 瞬时运动生成. 即时的. 混蛋约束. 时间最优.


## User Interaction
### Graphical User Interface
* [qtpy](https://github.com/spyder-ide/qtpy) - 提供一个统一的层来支持 PyQt5、PySide2、PyQt4 和 PySide 的单一代码库.
* [mir](https://github.com/MirServer/mir) - Mir 是一组用于构建基于 Wayland 的 shell 的库.
* [rqt](https://wiki.ros.org/rqt)  - 用于 ROS GUI 开发的基于 Qt 的框架. 它由三个部分/元包组成.
* [cage](https://github.com/Hjdskes/cage)  - 这是 Cage，一个 Wayland 售货亭. 信息亭运行单个最大化的应用程序.
* [chilipie](https://github.com/futurice/chilipie-kiosk) - 易于使用的 Raspberry Pi 图像，用于直接启动进入全屏 Chrome.
* [pencil](https://github.com/evolus/pencil) - 每个人都可以使用的制作图表和 GUI 原型的工具.
* [dynamic_reconfigure](https://wiki.ros.org/dynamic_reconfigure) - dynamic_reconfigure 的重点是提供一种标准方法来将节点参数的子集公开给外部重新配置.
* [ddynamic_reconfigure](https://github.com/pal-robotics/ddynamic_reconfigure) - 允许使用 dynamic_reconfigure 框架修改 ROS 节点的参数，而无需编写 cfg 文件.
* [elements](https://github.com/cycfi/elements) - 一个轻量级的、细粒度的、分辨率独立的、模块化的 GUI 库.
* [NanoGUI](https://github.com/wjakob/nanogui) - 用于 OpenGL 3.x 或更高版本的简约跨平台小部件库.


### Acoustic User Interface
* [pyo](https://github.com/belangeo/pyo) - 一个用 C 编写的 Python 模块，包含用于各种音频信号处理类型的类.
* [rhasspy](https://github.com/synesthesiam/rhasspy) - Rhasspy（发音为 RAH-SPEE）是一个离线的多语言语音助手工具包，其灵感来自 Jasper，可与 Home Assistant、Hass.io 和 Node-RED 配合使用.
* [mycroft-core](https://github.com/MycroftAI/mycroft-core) - Mycroft 是一个可破解的开源语音助手.
* [DDSP](https://github.com/magenta/ddsp) - 通用 DSP 功能（例如合成器、波形整形器和滤波器）的可区分版本库.
* [NoiseTorch](https://github.com/lawl/NoiseTorch) - 在任何应用程序中创建一个抑制噪音的虚拟麦克风.
* [DeepSpeech](https://github.com/mozilla/DeepSpeech) - 一个开源的 Speech-To-Text 引擎，使用基于百度深度语音研究论文的机器学习技术训练的模型.
* [waveglow](https://github.com/NVIDIA/waveglow) - 用于语音合成的基于流的生成网络.
* [TTS](https://github.com/coqui-ai/TTS) - 用于文本到语音的深度学习工具包，在研究和生产中经过实战测试.


### Command Line Interface
* [the-art-of-command-line](https://github.com/jlevy/the-art-of-command-line) - 在一页中掌握命令行.
* [dotfiles of cornerman](https://github.com/cornerman/dotfiles) - 强大的 zsh 和 vim 点文件.
* [dotbot](https://github.com/anishathalye/dotbot) - 引导您的点文件的工具.
* [prompt-hjem](https://github.com/cornerman/prompt-hjem) - 漂亮的 zsh 提示符.
* [ag](https://github.com/ggreer/the_silver_searcher) - 类似于 ack 的代码搜索工具，但速度更快.
* [fzf](https://github.com/junegunn/fzf) - 命令行模糊查找器.
* [pkgtop](https://github.com/orhun/pkgtop) - 为 GNU/Linux 设计的交互式包管理器和资源监视器.
* [asciimatics](https://github.com/peterbrittain/asciimatics) - 一个执行类似诅咒操作的跨平台包，加上更高级别的 API 和小部件来创建文本 UI 和 ASCII 艺术动画.
* [gocui](https://github.com/jroimartin/gocui) - 旨在创建控制台用户界面的极简主义 Go 包.
* [TerminalImageViewer](https://github.com/stefanhaustein/TerminalImageViewer) - 使用 RGB ANSI 代码和 unicode 块图形字符在（现代）终端中显示图像的小型 C++ 程序.
* [rosshow](https://github.com/dheera/rosshow) - 使用 Unicode/ASCII 艺术在终端内可视化 ROS 主题.
* [python-prompt-toolkit](https://github.com/prompt-toolkit/python-prompt-toolkit) - 用于在 Python 中构建强大的交互式命令行应用程序的库.
* [guake](https://github.com/Guake/guake) - GNOME 的下拉终端.
* [wemux](https://github.com/zolrath/wemux) - 多用户 Tmux 变得简单.
* [tmuxp](https://github.com/tmux-python/tmuxp) - 基于 libtmux 的会话管理器.
* [mapscii](https://github.com/rastapasta/mapscii) - 控制台的世界地图渲染器.
* [terminator](https://launchpad.net/terminator) - 这个项目的目标是产生一个有用的工具来安排终端.
* [bat](https://github.com/sharkdp/bat) - 一只带翅膀的猫 (1) 克隆体.
* [fx](https://github.com/antonmedv/fx) - 命令行工具和终端 JSON 查看器.
* [tmate](https://github.com/tmate-io/tmate) - 即时终端共享.

## Data Visualization and Mission Control
* [xdot](https://github.com/jrfonseca/xdot.py) - 以 Graphviz 的点语言编写的图表的交互式查看器.
* [guacamole](https://guacamole.apache.org/)  - 无客户端远程桌面网关. 它支持 VNC、RDP 和 SSH 等标准协议.
* [ros3djs](https://github.com/RobotWebTools/ros3djs) - 用于 ROS JavaScript 库的 3D 可视化库.
* [webviz](https://github.com/cruise-automation/webviz) - 基于 Web 的可视化库，如 rviz.
* [plotly.py](https://github.com/plotly/plotly.py) - 一个用于 Python 的开源交互式图形库.
* [PlotJuggler](https://github.com/facontidavide/PlotJuggler) - 您值得拥有的时间序列可视化工具.
* [bokeh](https://github.com/bokeh/bokeh) - 浏览器中的交互式数据可视化，来自 Python.
* [voila](https://github.com/voila-dashboards/voila) - 从 Jupyter 笔记本到独立的 Web 应用程序和仪表板.
* [Pangolin](https://github.com/stevenlovegrove/Pangolin) - Pangolin 是一个轻量级的便携式快速开发库，用于管理 OpenGL 显示/交互和抽象视频输入.
* [rqt_bag](http://wiki.ros.org/rqt_bag) - 提供用于显示和重放 ROS 包文件的 GUI 插件.
* [kepler.gl](https://github.com/keplergl/kepler.gl) - Kepler.gl 是一款强大的开源地理空间分析工具，适用于大规模数据集.
* [qgis_ros](https://github.com/locusrobotics/qgis_ros) - 在功能强大的 GIS 环境中访问袋装和实时主题数据.
* [openmct](https://github.com/nasa/openmct) - 基于网络的任务控制框架.
* [web_video_server](https://github.com/RobotWebTools/web_video_server) - 多种格式的 ROS 图像主题的 HTTP 流.
* [RVizWeb](https://github.com/osrf/rvizweb) - 提供了一种构建和启动具有类似于 RViz 功能的 Web 应用程序的便捷方式.
* [marvros](https://github.com/mavlink/mavros) - MAVLink 到 ROS 网关，代理地面控制站.
* [octave](https://www.gnu.org/software/octave/) - 提供方便的命令行界面，用于以数值方式解决线性和非线性问题，以及使用与 Matlab 大部分兼容的语言执行其他数值实验.
* [streetscape.gl](https://github.com/uber/streetscape.gl) - Streetscape.gl 是一个工具包，用于可视化 XVIZ 协议中的自主和机器人数据.
* [urdf-loaders](https://github.com/gkjohnson/urdf-loaders) - 用于 Unity 和 THREE.js 的 URDF 加载器，带有示例 ATHLETE URDF 文件.
* [obs-studio](https://github.com/obsproject/obs-studio) - 用于直播和屏幕录制的免费开源软件.
* [K3D-tools](https://github.com/K3D-tools) - 用于 3D 可视化的 Jupyter 笔记本扩展.
* [PyQtGraph](https://github.com/pyqtgraph/pyqtgraph) - 用于科学/工程应用的快速数据可视化和 GUI 工具.
* [ipygany](https://github.com/QuantStack/ipygany) - Jupyter Notebook 中的 3-D 科学可视化.
* [Foxglove Studio](https://github.com/foxglove/studio)  - 用于机器人可视化和调试的 Web 和桌面应用程序； 积极维护 webviz 的分支.
* [ROS-Mobile](https://github.com/ROS-Mobile/ROS-Mobile-Android) - Android 的可视化和控制应用程序.


### Annotation
* [labelbox](https://github.com/Labelbox/labelbox) - 注释数据以构建和发布人工智能应用程序的最快方式.
* [PixelAnnotationTool](https://github.com/abreheret/PixelAnnotationTool) - 快速注释图像.
* [LabelImg](https://github.com/tzutalin/labelImg) - 图形图像注释工具和图像中的标签对象边界框.
* [cvat](https://github.com/opencv/cvat) - 强大高效的计算机视觉标注工具（CVAT）.
* [point_labeler](https://github.com/jbehley/point_labeler) - 用于标记单个点云或点云流的工具.
* [label-studio](https://github.com/heartexlabs/label-studio) - Label Studio 是一种具有标准化输出格式的多类型数据标注和注释工具.
* [napari](https://github.com/napari/napari) - 用于 python 的快速、交互式、多维图像查看器.
* [semantic-segmentation-editor](https://github.com/Hitachi-Automotive-And-Industry-Lab/semantic-segmentation-editor) - 用于创建 AI 训练数据集（2D 和 3D）的基于 Web 的标记工具.
* [3d-bat](https://github.com/walzimmer/3d-bat) - 用于点云和图像标记的 3D 边界框注释工具.
* [labelme](https://github.com/wkentaro/labelme) - 使用 Python 进行图像多边形注释（多边形、矩形、圆形、直线、点和图像级标志注释）.
* [universal-data-tool](https://github.com/UniversalDataTool/universal-data-tool) - 在简单的 Web 界面或桌面应用程序中协作和标记任何类型的数据、图像、文本或文档.
* [BMW-Labeltool-Lite](https://github.com/BMW-InnovationLab/BMW-Labeltool-Lite) - 为您提供易于使用的标记工具，用于最先进的深度学习培训目的.
* [3d-annotation-tool](https://github.com/StrayRobots/3d-annotation-tool) - 使用边界框、矩形、关键点等注释点云的轻量级工具.


### Point Cloud
* [CloudCompare](https://github.com/CloudCompare/CloudCompare) - CloudCompare 是一款 3D 点云（和三角网格）处理软件.
* [Potree](https://github.com/potree/potree) - 大型数据集的 WebGL 点云查看器.
* [point_cloud_viewer](https://github.com/googlecartographer/point_cloud_viewer) - 使查看大量点云变得简单方便.
* [LidarView](https://github.com/Kitware/LidarView) - 对来自激光雷达传感器的实时捕获的 3D LiDAR 数据执行实时可视化和轻松处理.
* [VeloView](https://github.com/Kitware/VeloView) - 对来自 Velodyne 的 HDL 传感器的实时捕获的 3D LiDAR 数据进行实时可视化.
* [entwine](https://github.com/connormanning/entwine/) - 用于海量点云的数据组织库，旨在征服数万亿点的数据集以及桌面级点云.
* [polyscope](https://github.com/nmwsharp/polyscope) - 用于网格和点云等 3D 数据的 C++ 和 Python 查看器.
* [Pcx](https://github.com/keijiro/Pcx) - Unity 的点云导入器和渲染器.
* [ImmersivePoints](https://github.com/rmeertens/ImmersivePoints) - 用于虚拟现实设备的 Web 应用程序，用于以最自然的方式探索 3D 数据.


### RViz
* [mapviz](https://github.com/swri-robotics/mapviz) - 用于 2D 数据的模块化 ROS 可视化工具.
* [rviz_cinematographer](https://github.com/AIS-Bonn/rviz_cinematographer) - 易于使用的工具来创建和编辑 rviz 相机的轨迹.
* [rviz_satellite](https://github.com/gareth-cross/rviz_satellite) - 在 RViz 中显示互联网卫星图像.
* [rviz_visual_tools](https://github.com/PickNikRobotics/rviz_visual_tools) - 用于在 Rviz 中显示形状和网格的 C++ API 包装器.
<!--lint ignore double-link-->
* [xpp](https://github.com/leggedrobotics/xpp) - 腿式机器人运动计划的可视化.
* [rviz stereo](http://wiki.ros.org/rviz/Tutorials/Rviz%20in%20Stereo) - 3D 立体渲染向每只眼睛显示不同的视图，使场景看起来具有深度.
* [jsk_visualization](https://github.com/jsk-ros-pkg/jsk_visualization) - 用于 rviz 和 rqt 的 Jsk 可视化 ros 包.
* [moveit_visual_tools](https://github.com/ros-planning/moveit_visual_tools)  - 用于显示和调试 MoveIt 的辅助函数！  Rviz 中的数据通过已发布的标记.


## Operation System
### Monitoring
* [rosmon](https://github.com/xqms/rosmon) - ROS 节点启动器和监控守护进程.
* [multimaster_fkie](https://github.com/fkie/multimaster_fkie) - 基于 GUI 的管理环境，对于管理 ROS 启动配置和控制运行节点非常有用.
* [collectd](https://github.com/collectd/collectd/) - 一个小型守护进程，它定期收集系统信息并提供以多种方式存储和监控值的机制.
* [lnav](http://lnav.org/) - 增强的日志文件查看器，它利用可以从正在查看的文件中收集到的任何语义信息，例如时间戳和日志级别.
* [htop](https://github.com/hishamhm/htop)  - 用于 Unix 系统的交互式文本模式进程查看器. 它旨在成为更好的“顶级”.
* [atop](https://github.com/Atoptool/atop) - 具有日志记录和重放功能的 Linux 系统和进程监视器.
* [psutil](https://github.com/giampaolo/psutil) - 用于 Python 中进程和系统监控的跨平台库.
* [gputil](https://github.com/anderskm/gputil) - 一个 Python 模块，用于在 Python 中使用 nvidia-smi 以编程方式从 NVIDA GPU 获取 GPU 状态.
* [gpustat](https://github.com/wookayin/gpustat) - 用于查询和监控 GPU 状态的简单命令行实用程序.
* [nvtop](https://github.com/Syllo/nvtop) - NVIDIA GPU htop 类监控工具.
* [ShellHub](https://www.shellhub.io)  - ShellHub 是一个现代 SSH 服务器，用于通过命令行（使用任何 SSH 客户端）或基于 Web 的用户界面远程访问 linux 设备，设计为 sshd 的替代方案. 将 ShellHub 视为边缘和云计算的集中式 SSH.
* [Sshwifty](https://github.com/nirui/sshwifty) - Sshwifty 是为 Web 制作的 SSH 和 Telnet 连接器.
* [spdlog](https://github.com/gabime/spdlog) - 非常快，仅标头/编译的 C++ 日志库.
* [ctop](https://github.com/bcicen/ctop) - 容器指标的类似顶部的界面.
* [ntop](https://github.com/ntop/ntopng) - 基于 Web 的流量和安全网络流量监控.
* [jupyterlab-nvdashboard](https://github.com/rapidsai/jupyterlab-nvdashboard) - 用于显示 GPU 使用情况仪表板的 JupyterLab 扩展.

### Database and Record
* [ncdu](https://dev.yorhel.nl/ncdu) - Ncdu 是一个带有 ncurses 接口的磁盘使用分析器.
* [borg](https://github.com/borgbackup/borg) - 具有压缩和经过身份验证的加密的重复数据删除存档器.
* [bag-database](https://github.com/swri-robotics/bag-database) - 对包文件进行分类并提供用于访问它们的基于 Web 的 UI 的服务器.
* [marv-robotics](https://gitlab.com/ternaris/marv-robotics) - MARV Robotics 是一个功能强大且可扩展的数据管理平台.
* [kitti2bag](https://github.com/tomas789/kitti2bag) - 以简单的方式将 KITTI 数据集转换为 ROS 包文件.
* [pykitti](https://github.com/utiasSTARS/pykitti) - 用于处理 KITTI 数据的 Python 工具.
* [rosbag_editor](https://github.com/facontidavide/rosbag_editor) - 使用简单的 GUI 从给定的 rosbag 创建一个 rosbag.
* [nextcloud](https://github.com/nextcloud/server) - Nextcloud 是一套用于创建和使用文件托管服务的客户端-服务器软件.
* [ros_type_introspection](https://github.com/facontidavide/ros_type_introspection) - 反序列化编译时未知的 ROS 消息.
* [syncthing](https://github.com/syncthing/syncthing) - 连续文件同步程序.
* [rqt_bag_exporter](https://gitlab.com/InstitutMaupertuis/rqt_bag_exporter) - Qt GUI 将 ROS 包主题导出到文件（CSV 和/或视频）.
* [xviz](https://github.com/uber/xviz) - 自治数据实时传输和可视化协议.
* [kitti_to_rosbag](https://github.com/ethz-asl/kitti_to_rosbag)  - 用于处理 KITTI 数据集原始数据并将其转换为 ROS 包的数据集工具. 还允许库直接访问姿势、velodyne 扫描和图像.
* [ros_numpy](https://github.com/eric-wieser/ros_numpy) - 将 ROS 消息与 numpy 数组相互转换的工具.
* [kitti_ros](https://github.com/LidarPerception/kitti_ros) - 基于 ROS 的播放器，用于重播 KiTTI 数据集.
* [DuckDB](https://github.com/cwida/duckdb) - 可嵌入的 SQL OLAP 数据库管理系统.

### Network Distributed File System
* [sshfs](https://github.com/osxfuse/sshfs) - 基于 SSH 文件传输协议的文件系统.
* [moosefs](https://github.com/moosefs/moosefs) - 可扩展的分布式存储系统.
* [ceph](https://github.com/ceph/ceph) - 分布式对象、块和文件存储平台.
* [nfs](https://github.com/sahlberg/libnfs) - 最初由 Sun Microsystems 开发的分布式文件系统协议.
* [ansible-role-nfs](https://github.com/geerlingguy/ansible-role-nfs) - 在 RedHat/CentOS 或 Debian/Ubuntu 上安装 NFS 实用程序.


### Server Infrastructure and High Performance Computing
* [mass](https://github.com/maas/maas) - 在真实服务器上自助远程安装 Windows、CentOS、ESXi 和 Ubuntu，将您的数据中心变成裸机云.
* [polyaxon](https://github.com/polyaxon/polyaxon) - 用于复制和管理机器学习和深度学习应用程序的整个生命周期的平台.
* [localstack](https://github.com/localstack/localstack)  - 功能齐全的本地 AWS 云堆栈. 离线开发和测试您的云和无服务器应用程序.
* [nvidia-docker](https://github.com/NVIDIA/nvidia-docker) - 利用 NVIDIA GPU 构建和运行 Docker 容器.
* [kubeflow](https://github.com/kubeflow/kubeflow) - Kubernetes 机器学习工具包.
* [log-pilot](https://github.com/AliyunContainerService/log-pilot) - 收集 docker 容器的日志.
* [traefik](https://github.com/containous/traefik) - 云原生边缘路由器.
* [graylog2-server](https://github.com/Graylog2/graylog2-server) - 免费和开源日志管理.
* [ansible](https://github.com/ansible/ansible) - Ansible 是一个极其简单的 IT 自动化平台，可让您的应用程序和系统更易于部署.
* [pyinfra](https://github.com/Fizzadar/pyinfra) - 它可用于临时命令执行、服务部署、配置管理等.
* [docker-py](https://github.com/docker/docker-py) - 用于 Docker Engine API 的 Python 库.
* [noVNC](https://github.com/novnc/noVNC) - 使用 HTML5 的 VNC 客户端.
* [Slurm](https://github.com/SchedMD/slurm) - Slurm：高度可扩展的工作负载管理器.
* [jupyterhub](https://github.com/jupyterhub/jupyterhub) - Jupyter 笔记本的多用户服务器.
* [Portainer](https://github.com/portainer/portainer) - 使 Docker 管理变得简单.
* [enroot](https://github.com/NVIDIA/enroot) - 一个简单但功能强大的工具，可将传统的容器/操作系统映像转换为非特权沙箱.
* [docker-firefox](https://github.com/jlesage/docker-firefox) - 使用 Firefox 和 noVNC 运行 Docker 容器以远程访问无头服务器.
* [luigi](https://github.com/spotify/luigi)  - 一个 Python 模块，可帮助您构建批处理作业的复杂管道. 它处理依赖项解析、工作流管理、可视化等.它还内置了 Hadoop 支持.
* [triton-inference-server](https://github.com/NVIDIA/triton-inference-server) - NVIDIA Triton 推理服务器提供针对 NVIDIA GPU 优化的云推理解决方案.
* [cudf](https://github.com/rapidsai/cudf) - 提供数据工程师和数据科学家熟悉的类似 pandas 的 API，因此他们可以使用它轻松加速工作流程，而无需深入了解 CUDA 编程的细节.


### Embedded Operation System
* [vxworks7-ros2-build](https://github.com/Wind-River/vxworks7-ros2-build) - 构建系统以自动构建 VxWorks 7 和 ROS2.
* [Yocto](https://git.yoctoproject.org/) - 开发工具和流程，支持为嵌入式软件创建独立于嵌入式硬件底层架构的 Linux 发行版.
* [Automotive Graded Linux](https://www.automotivelinux.org/software) - 一个协作开源项目，将汽车制造商、供应商和技术公司聚集在一起，为汽车应用构建一个基于 Linux 的开放软件平台，该平台可以作为事实上的行业标准.
* [bitbake](https://github.com/openembedded/bitbake) - 一个通用的任务执行引擎，允许 shell 和 Python 任务在复杂的任务间依赖性约束下高效并行运行.
* [Jailhouse](https://github.com/siemens/jailhouse) - Jailhouse 是一个基于 Linux 的分区管理程序.
* [Xen](https://wiki.debian.org/Xen) - 开源 (GPL) type-1 或裸机管理程序.
* [QEMU](https://www.qemu.org/) - 一个通用的开源机器模拟器和虚拟器.
* [qemu-xilinx](https://github.com/Xilinx/qemu) - Quick EMUlator (QEMU) 的一个分支，改进了对 Xilinx 平台的支持和建模.
* [rosserial](https://github.com/ros-drivers/rosserial) - 用于小型嵌入式设备（例如 Arduino）的 ROS 客户端库.
* [meta-ros](https://github.com/ros/meta-ros/tree/thud-draft) - 用于 ROS 应用程序的 OpenEmbedded 层.
* [meta-balena](https://github.com/balena-os/meta-balena) - 在嵌入式设备上运行 Docker 容器.
* [micro-ros](https://micro-ros.github.io/) - The major changes compared to "regular" ROS 2 is that micro-ROS uses a Real-Time Operating System (RTOS) instead of Linux, and DDS for eXtremely Resource Constrained Environments.
* [nvidia-container-runtime](https://github.com/NVIDIA/nvidia-container-runtime/) - NVIDIA Container Runtime is a GPU aware container runtime, compatible with the Open Containers Initiative (OCI) specification used by Docker, CRI-O, and other popular container technologie.
* [fusesoc](https://github.com/olofk/fusesoc) - 用于 FPGA/ASIC 开发的包管理器和构建抽象工具.
* [jetson_easy](https://github.com/rbonghi/jetson_easy) - 自动编写脚本来设置和配置您的 NVIDIA Jetson.
* [docker-jetpack-sdk](https://github.com/trn84/docker-jetpack-sdk) - 允许在 docker 容器中使用 NVIDIA JetPack SDK 进行下载、刷写和安装.
* [Pressed](https://wiki.debian.org/DebianInstaller/Preseed) - 提供了一种方法来设置 debian 安装过程中提出的问题的答案，而无需在安装运行时手动输入答案.
* [jetson_stats](https://github.com/rbonghi/jetson_stats) - 用于监视和控制 NVIDIA Jetson（Xavier NX、Nano、AGX Xavier、TX1、TX2）的软件包适用于所有 NVIDIA Jetson 生态系统.
* [ros_jetson_stats](https://github.com/rbonghi/ros_jetson_stats)  - ROS jetson-stats 包装器. 诊断消息中 NVIDIA jetson 的状态.
* [OpenCR](https://github.com/ROBOTIS-GIT/OpenCR) - ROS 的开源控制模块.
* [acrn-hypervisor](https://github.com/projectacrn/acrn-hypervisor) - 定义设备管理程序参考堆栈和架构，用于运行多个软件子系统，通过虚拟机管理器在整合系统上安全管理.
* [jetson-containers](https://github.com/dusty-nv/jetson-containers) - 用于 Jetson 和 JetPack 4.4 的机器学习容器.


### Real-Time Kernel
* [ELISA](https://elisa.tech/) - 该项目旨在使公司更容易构建和认证基于 Linux 的安全关键应用程序——这些系统的故障可能导致人员伤亡、重大财产损失或环境破坏.
* [PREEMPT_RT kernel patch](https://wiki.linuxfoundation.org/realtime/documentation/start) - PREEMPT_RT 内核补丁的目的是最小化不可抢占的内核代码量.

## Network and Middleware
* [performance_test](https://github.com/ApexAI/performance_test) - 测试基于发布/订阅的通信框架性能的工具.
* [realtime_support](https://github.com/ros2/realtime_support) - 用于测量抖动和延迟的最小实时测试实用程序.
* [ros1_bridge](https://github.com/ros2/ros1_bridge) - ROS 2 包，提供 ROS 1 和 ROS 2 之间的双向通信.
* [Fast-RTPS](https://github.com/eProsima/Fast-RTPS) - 一种协议，它通过对象管理组 (OMG) 联盟定义和维护的不可靠传输（例如 UDP）提供发布者-订阅者通信.
* [protobuf](https://github.com/protocolbuffers/protobuf) - Google 的数据交换格式.
* [opensplice](https://github.com/ADLINK-IST/opensplice) - Vortex OpenSplice 社区版.
* [cyclonedds](https://github.com/eclipse-cyclonedds/cyclonedds) - Eclipse Cyclone DDS 是一个非常高效和健壮的开源 DDS 实现.
* [iceoryx](https://github.com/eclipse/iceoryx) - 用于基于 POSIX 的系统的 IPC 中间件.
* [rosbridge_suite](https://github.com/RobotWebTools/rosbridge_suite) - 为ROS提供JSON接口，允许任何客户端发送JSON来发布或订阅ROS主题，调用ROS服务等.
* [ros2arduino](https://github.com/ROBOTIS-GIT/ros2arduino) - 该库帮助 Arduino 板使用 XRCE-DDS 与 ROS2 通信.
* [eCAL](https://github.com/continental/) - 增强型通信抽象层 (eCAL) 是一种中间件，可在单个计算机节点或计算机网络中的不同节点之间实现可扩展的高性能进程间通信.
* [AUTOSAR-Adaptive](https://github.com/UmlautSoftwareDevelopmentAccount/AUTOSAR-Adaptive) - 基于 R19-11 的 AUTOSAR 自适应平台的实现.
* [ocpp](https://github.com/NewMotion/ocpp) - 开放式充电点协议 (OCPP) 是一种用于电动汽车充电器和中央后台系统之间通信的网络协议.
* [micro-ROS for Arduino](https://github.com/micro-ROS/micro_ros_arduino) - 用于基于 Arduino IDE 或 Arduino CLI 的裸机项目的实验性微型 ROS 库.
* [mqtt_bridge](https://github.com/groove-x/mqtt_bridge) - 提供在 ROS 和 MQTT 之间双向桥接的功能.


### Ethernet and Wireless Networking
* [SOES](https://github.com/OpenEtherCATsociety/SOES) - SOES 是一个用 C 语言编写的 EtherCAT 从站协议栈.
* [netplan](https://netplan.io/) - 只需创建所需网络接口的 YAML 描述以及每个接口应配置的用途.
* [airalab](https://github.com/airalab) - AIRA 是支持 ROS 的网络物理系统的参考 Robonomics 网络客户端.
* [rdbox](https://github.com/rdbox-intec/rdbox) - RDBOX 是 ROS 机器人的 IT 基础设施.
* [ros_ethercat](https://github.com/shadow-robot/ros_ethercat) - 这是 pr2_ethercat 主循环的重新实现，不依赖于 PR2 软件.
* [wavemon](https://github.com/uoaerg/wavemon) - 基于 ncurses 的无线网络设备监控应用程序.
* [wireless](https://github.com/clearpathrobotics/wireless) - 使有关无线网络的信息可供 ROS 使用.
* [ptpd](https://github.com/ptpd/ptpd)  - PTP 守护程序 (PTPd) 是“IEEE Std 1588-2008”定义的精确时间协议 (PTP) 版本 2 的实现.  PTP 为以太网 LAN 连接的计算机提供精确的时间协调.
* [iperf](https://github.com/esnet/iperf) - 一个 TCP、UDP 和 SCTP 网络带宽测量工具.
* [tcpreplay](https://github.com/appneta/tcpreplay) - Pcap 编辑和回放工具.
* [nethogs](https://github.com/raboof/nethogs) - 它按进程对带宽进行分组.
* [pyshark](https://github.com/KimiNewt/pyshark) - 用于 tshark 的 Python 包装器，允许使用 wireshark 解析器解析 python 数据包.
* [pingtop](https://github.com/laixintao/pingtop) - Ping 多台服务器并在类似顶部的终端用户界面中显示结果.
* [termshark](https://github.com/gcla/termshark) - 受 Wireshark 启发的 tshark 终端用户界面.
* [udpreplay](https://github.com/rigtorp/udpreplay) - 从 pcap 文件重播 UDP 数据包.
* [openwifi](https://github.com/open-sdr/openwifi) - Linux mac80211 兼容全栈 IEEE802.11/Wi-Fi 设计，基于软件无线电.

### Controller Area Network
* [awesome CAN](https://github.com/iDoka/awesome-canbus) - 很棒的 CAN 总线工具、硬件和资源的精选列表.
* [AndrOBD](https://github.com/fr3ts0n/AndrOBD) - Android OBD 诊断与任何 ELM327 适配器​​.
* [ddt4all](https://github.com/cedricp/ddt4all) - DDT4All 是一种工具，用于创建您自己的 ECU 参数屏幕并使用廉价的 ELM327 接口连接到 CAN 网络.
* [cabana](https://github.com/commaai/cabana) - CAN 可视化工具和 DBC 制造商.
* [opendbc](https://github.com/commaai/opendbc) - 使汽车解码器环的访问民主化的项目.
* [libuavcan](https://github.com/UAVCAN/libuavcan) - 一种开放式轻量级协议，旨在通过强大的车载网络（如 CAN 总线）在航空航天和机器人应用中实现可靠通信.
* [python-can](https://github.com/hardbyte/python-can) - can 包为 Python 开发人员提供控制器区域网络支持.
* [CANopenNode](https://github.com/CANopenNode/CANopenNode) - 国际标准化 (EN 50325-4) (CiA301) 基于 CAN 的嵌入式控制系统高层协议.
* [python-udsoncan](https://github.com/pylessard/python-udsoncan) - UDS (ISO-14229) 标准的 Python 实现.
* [uds-c](https://github.com/openxc/uds-c) - 统一诊断服务 (UDS) 和 OBD-II（车辆车载诊断）C 库.
* [cantools](https://github.com/eerimoq/cantools) - Python 3 中的 CAN BUS 工具.
* [CANdevStudio](https://github.com/GENIVI/CANdevStudio)  - CANdevStudio 旨在成为 CAN 仿真软件的经济高效的替代品. 它可以与各种 CAN 硬件接口一起工作.
* [can-utils](https://github.com/linux-can/can-utils) - Linux-CAN / SocketCAN 用户空间应用程序.
* [ros_canopen](https://github.com/ros-industrial/ros_canopen) - ROS 的 CANopen 驱动程序框架.
* [decanstructor](https://github.com/JWhitleyAStuff/decanstructor) - 权威的 ROS CAN 分析工具.
* [kvaser_interface](https://github.com/astuff/kvaser_interface) - 这个包是作为从 ROS 访问 Kvaser CAN 设备的标准化方式开发的.
* [canmatrix](https://github.com/ebroecker/canmatrix) - 转换 CAN 数据库格式 .arxml .dbc .dbf .kcd.
* [autosar](https://github.com/cogu/autosar) - 一组用于处理 AUTOSAR XML 文件的 python 模块.
* [canopen](https://github.com/christiansandberg/canopen)  - CANopen 标准的 Python 实现. 该项目的目的是在 Pythonic 接口中支持 CiA 301 标准的最常见部分.
* [SavvyCAN](https://github.com/collin80/SavvyCAN) - 基于 Qt5 的跨平台工具，可用于加载、保存和捕获 canbus 帧.
* [Open-Vehicle-Monitoring-System-3](https://github.com/openvehicles/Open-Vehicle-Monitoring-System-3) - 该系统提供对车辆指标的实时监控，如充电状态、温度、轮胎压力和诊断故障情况.


### Sensor and Acuator Interfaces
* [Tesla-API](https://github.com/timdorr/tesla-api) - 提供远程监控和控制 Model S（以及未来的 Tesla 车辆）的功能.
* [flirpy](https://github.com/LJMUAstroecology/flirpy) - 一个与 FLIR 热成像相机和图像交互的 Python 库.
* [nerian_stereo](https://github.com/nerian-vision/nerian_stereo) - Nerian 的 SceneScan 和 SP1 立体视觉传感器的 ROS 节点.
* [pymmw](https://github.com/m6c7l/pymmw) - 这是一个由 Python 脚本组成的工具箱，用于与 TI 的 IWR1443 毫米波传感设备评估模块 (BoosterPack) 进行交互.
* [ti_mmwave_rospkg](https://github.com/radar-lab/ti_mmwave_rospkg) - TI 毫米波雷达 ROS 驱动程序（具有传感器融合和混合）.
* [pacmod3](https://github.com/astuff/pacmod3) - 此 ROS 节点旨在允许用户使用 PACMod 线控驱动系统（电路板修订版 3）控制车辆.
* [ros2_intel_realsense](https://github.com/intel/ros2_intel_realsense) - 这些是将英特尔实感相机（D400 系列）与 ROS2 一起使用的软件包.
* [sick_scan](https://github.com/SICKAG/sick_scan) - 该堆栈为 SICK TiM 系列激光扫描仪提供 ROS2 驱动程序.
* [ouster_example](https://github.com/ouster-lidar/ouster_example) - 用于连接和配置 OS1、读取和可视化数据以及与 ROS 接口的示例代码.
* [ros2_ouster_drivers](https://github.com/ros-drivers/ros2_ouster_drivers) - 这些是 Ouster OS-1 3D 激光雷达的 ROS2 驱动程序的实现.
* [livox_ros_driver](https://github.com/Livox-SDK/livox_ros_driver) - 新的ROS包，专门用于连接Livox生产的LiDAR产品.
* [velodyne](https://github.com/ros-drivers/velodyne) - 一组支持 Velodyne 高清 3D 激光雷达的 ROS 包.
* [ublox](https://github.com/KumarRobotics/ublox) - 为 u-blox GPS 接收器提供支持.
* [crazyflie_ros](https://github.com/whoenig/crazyflie_ros) - Bitcraze Crazyflie 的 ROS 驱动程序.
* [pointgrey_camera_driver](https://github.com/ros-drivers/pointgrey_camera_driver)  - Pt 的 ROS 驱动程序. 灰色相机，基于官方 FlyCapture2 SDK.
* [novatel_gps_driver](https://github.com/swri-robotics/novatel_gps_driver) - NovAtel GPS / GNSS 接收器的 ROS 驱动程序.
* [pylon-ros-camera](https://github.com/basler/pylon-ros-camera) - 用于 Basler GigE Vision 和 USB3 Vision 相机的官方 pylon ROS 驱动程序.
* [ethz_piksi_ros](https://github.com/ethz-asl/ethz_piksi_ros) - 包含 (python) ROS 驱动程序、工具、启动文件和关于如何在 ROS 中使用 Piksi 实时运动 (RTK) GPS 设备的维基.
* [sick_safetyscanners](https://github.com/SICKAG/sick_safetyscanners) - 一个 ROS 驱动程序，它从 SICK 安全扫描仪读取原始数据并将数据发布为 laser_scan 消息.
* [bosch_imu_driver](https://github.com/mdrwiega/bosch_imu_driver)  - 传感器 IMU Bosch BNO055 的驱动程序. 它仅实现了 UART 通信接口（应选择正确的传感器模式）.
* [oxford_gps_eth](https://bitbucket.org/DataspeedInc/oxford_gps_eth/) - 使用 NCOM 数据包结构的 OxTS GPS 接收器的以太网接口.
* [ifm3d](https://github.com/ifm/ifm3d) - 用于使用基于 ifm pmd 的 3D ToF 相机的库和实用程序.
* [cepton_sdk_redist](https://github.com/ceptontech/cepton_sdk_redist/) - 为 Cepton LiDAR 提供 ROS 支持.
* [jetson_csi_cam](https://github.com/peter-moran/jetson_csi_cam) - 一个 ROS 包，使在带有 ROS 的 Nvidia Jetson TK1、TX1 或 TX2 上使用 CSI 相机变得简单.
* [ros_astra_camera](https://github.com/orbbec/ros_astra_camera) - 用于 Orbbec 3D 相机的 ROS 驱动程序.
* [spot_ros](https://github.com/clearpathrobotics/spot_ros) - Spot 的 ROS 驱动程序.
* [blickfeld-scanner-lib](https://github.com/Blickfeld/blickfeld-scanner-lib) - 用于与 Blickfeld GmbH 的 LiDAR 设备通信的跨平台库.
* [TauLidarCamera](https://github.com/OnionIoT/tau-LiDAR-camera) - 用于使用 Tau LiDAR 相机构建应用程序的主机端 API.


## Security
* [owasp-threat-dragon-desktop](https://github.com/mike-goodwin/owasp-threat-dragon-desktop) - Threat Dragon 是一款免费、开源、跨平台的威胁建模应用程序，包括系统图表和自动生成威胁/缓解措施的规则引擎.
* [launch_ros_sandbox](https://github.com/ros-tooling/launch_ros_sandbox) - 可以定义在受限环境中运行节点的启动文件，例如 Docker 容器或具有有限权限的单独用户帐户.
* [wolfssl](https://github.com/wolfSSL/wolfssl) - 一种小型、快速、便携的 TLS/SSL 实现，用于将嵌入式设备连接到云端.
* [CANalyzat0r](https://github.com/schutzwerk/CANalyzat0r) - 专有汽车协议的安全分析工具包.
* [RSF](https://github.com/aliasrobotics/RSF) - 机器人安全框架 (RSF) 是一种在机器人技术中执行安全评估的标准化方法.
* [How-to-Secure-A-Linux-Server](https://github.com/imthenachoman/How-To-Secure-A-Linux-Server) - 用于保护 Linux 服务器的不断发展的操作指南.
* [lynis](https://github.com/CISOfy/lynis) - Security auditing tool for Linux, macOS, and UNIX-based systems. Assists with compliance testing (HIPAA/ISO27001/PCI DSS) and system hardening.
* [OpenVPN](https://github.com/OpenVPN/openvpn) - 一个开源的 VPN 守护进程.
* [openfortivpn](https://github.com/adrienverge/openfortivpn) - 用于 PPP+SSL VPN 隧道服务并与 Fortinet VPN 兼容的客户端.
* [WireGuard](https://github.com/WireGuard/WireGuard) - WireGuard 是一种在 Linux 内核中运行并使用最先进的加密技术的新型 VPN.
* [ssh-auditor](https://github.com/ncsa/ssh-auditor) - 扫描您网络上的弱 ssh 密码.
* [vulscan](https://github.com/scipag/vulscan) - 使用 Nmap NSE 进行高级漏洞扫描.
* [nmap-vulners](https://github.com/vulnersCom/nmap-vulners) - 基于 Vulners.com API 的 NSE 脚本.
* [brutespray](https://github.com/x90skysn3k/brutespray) - 自动尝试对找到的服务使用默认信用.
* [fail2ban](https://github.com/fail2ban/fail2ban) - 守护程序禁止导致多个身份验证错误的主机.
* [DependencyCheck](https://github.com/jeremylong/DependencyCheck) - 一种软件组成分析实用程序，可检测应用程序依赖项中公开披露的漏洞.
* [Firejail](https://github.com/netblue30/firejail) - 一个 SUID 沙箱程序，通过使用 Linux 命名空间、seccomp-bpf 和 Linux 功能限制不受信任的应用程序的运行环境来降低安全漏洞的风险.
* [RVD](https://github.com/aliasrobotics/RVD)  - 机器人漏洞数据库. 社区贡献的机器人漏洞和弱点档案.
* [ros2_dds_security](http://design.ros2.org/articles/ros2_dds_security.html) - 通过定义服务插件接口 (SPI) 体系结构、一组 SPI 的内置实现以及 SPI 强制执行的安全模型来添加安全增强功能.
* [Security-Enhanced Linux](https://github.com/SELinuxProject/selinux) - 一个 Linux 内核安全模块，提供一种支持访问控制安全策略的机制，包括强制访问控制 (MAC).
* [OpenTitan](https://github.com/lowRISC/opentitan)  - 将使硅信任根的设计和实施对企业、平台提供商和芯片制造商来说更加透明、可信和安全.  OpenTitan 作为一个协作项目由 lowRISC CIC 管理，旨在生产高质量、开放的 IP，以作为全功能产品进行实例化.
* [bandit](https://github.com/PyCQA/bandit) - 旨在查找 Python 代码中常见安全问题的工具.
* [hardening](https://github.com/konstruktoid/hardening) - 使 Ubuntu 服务器更安全的快速方法.
* [Passbolt](https://github.com/passbolt/passbolt_docker) - Passbolt 是一个免费的开源密码管理器，允许团队成员安全地存储和共享凭据.
* [gopass](https://github.com/gopasspw/gopass) - 用 Go 编写的命令行密码管理器.
* [pass](https://www.passwordstore.org/) - The standard unix password manager.
* [Vault](https://github.com/hashicorp/vault)  - 安全访问秘密的工具. 秘密是您想要严格控制访问的任何内容，例如 API 密钥、密码、证书等.
* [legion](https://github.com/GoVanguard/legion) - 一个开源、易于使用、超级可扩展和半自动化的网络渗透测试框架，有助于发现、侦察和利用信息系统.
* [openscap](https://github.com/OpenSCAP/openscap) - oscap 程序是一个命令行工具，允许用户加载、扫描、验证、编辑和导出 SCAP 文档.


## Datasets
* [Papers With Code](https://www.paperswithcode.com/datasets) - Papers With Code 提供的数千个机器学习数据集.
* [KITTI-360](https://github.com/autonomousvision/kitti360Scripts) - 这个大型数据集包含 73.7 公里行驶距离内的 320k 图像和 100k 激光扫描.
* [waymo_ros](https://github.com/YonoHub/waymo_ros) - 这是一个 ROS 包，用于将 Waymo 开放数据集连接到 ROS.
* [waymo-open-dataset](https://github.com/waymo-research/waymo-open-dataset) - Waymo 开放数据集由 Waymo 自动驾驶汽车在各种条件下收集的高分辨率传感器数据组成.
* [Ford Autonomous Vehicle Dataset](https://avdata.ford.com/home/default.aspx) - 福特展示了一个具有挑战性的多代理季节性数据集，由福特自动车队在不同的日期和时间收集.
* [awesome-robotics-datasets](https://github.com/sunglok/awesome-robotics-datasets) - 一组有用的机器人和计算机视觉数据集.
* [nuscenes-devkit](https://github.com/nutonomy/nuscenes-devkit) - nuScenes 数据集的开发套件.
* [dataset-api](https://github.com/ApolloScapeAuto/dataset-api) - 这是 ApolloScape 数据集、CVPR 2019 自动驾驶挑战研讨会和 ECCV 2018 挑战的工具包的回购.
* [utbm_robocar_dataset](https://github.com/epan-utbm/utbm_robocar_dataset) - 具有用于自动驾驶的多个传感器的欧盟长期数据集.
* [DBNet](https://github.com/driving-behavior/DBNet) - 用于驾驶行为学习的大规模数据集.
* [argoverse-api](https://github.com/argoai/argoverse-api) - Argoverse 数据集的官方 GitHub 存储库.
* [DDAD](https://github.com/TRI-ML/DDAD) - 来自 TRI（丰田综合研究所）的新自动驾驶基准，用于在具有挑战性和多样化的城市条件下进行长距离（高达 250 米）和密集深度估计.
* [pandaset-devkit](https://github.com/scaleapi/pandaset-devkit) - Hesa​​i &amp; Scale 提供的自动驾驶公共大规模数据集.
* [a2d2_to_ros](https://gitlab.com/MaplessAI/external/a2d2_to_ros) - 将 A2D2 数据集转换为 ROS 包的实用程序.
* [awesome-satellite-imagery-datasets](https://github.com/chrieke/awesome-satellite-imagery-datasets) - 带有计算机视觉和深度学习注释的卫星图像训练数据集列表.
* [sentinelsat](https://github.com/sentinelsat/sentinelsat) - 搜索和下载哥白尼哨兵卫星图像.
* [adas-dataset-form](https://www.flir.com/oem/adas/adas-dataset-form/) - 用于算法训练的热数据集.
* [h3d](https://usa.honda-ri.com/h3d) - H3D 是本田的大规模全环绕 3D 多目标检测和跟踪数据集.
* [Mapillary Vistas Dataset](https://www.mapillary.com/dataset/vistas) - 多样化的街道级图像数据集，具有像素精确和实例特定的人类注释，用于了解世界各地的街道场景.
* [TensorFlow Datasets](https://www.tensorflow.org/datasets/catalog/overview) - TensorFlow Datasets 提供许多公共数据集作为 tf.data.Datasets.
* [racetrack-database](https://github.com/TUMFTM/racetrack-database) - 包含全世界 20 多个赛道（主要是 F1 和 DTM）的中心线（x 和 y 坐标）、赛道宽度和赛道线.
* [BlenderProc](https://github.com/DLR-RM/BlenderProc) - 用于逼真的训练图像生成的程序 Blender 管道.
* [Atlatec Sample Map Data](https://www.atlatec.de/getsampledata.html) - 用于自动驾驶和模拟的 3D 地图仅由旧金山市中心的两个摄像头和 GPS 创建.
* [Lyft Level 5 Dataset](https://self-driving.lyft.com/level5/data/)  - Level 5 正在为 Lyft 网络开发自动驾驶系统. 我们正在从我们的自主车队收集和处理数据并与您分享.
* [holicity](https://github.com/zhou13/holicity) - 用于学习整体 3D 结构的城市规模数据平台.
* [UTD19](https://utd19.ethz.ch/) - 最大的公开可用的多城市交通数据集.
* [ASTYX HIRES2019 DATASET](http://www.pinchofintelligence.com/visualising-lidar-and-radar-in-virtual-reality/) - 用于基于深度学习的 3D 对象检测的汽车雷达数据集.
* [Objectron](https://github.com/google-research-datasets/Objectron/) - 一系列以对象为中心的短视频剪辑，伴随着 AR 会话元数据，包括相机姿势、稀疏点云和周围环境中平面表面的特征.
* [ONCE dataset](https://once-for-auto-driving.github.io/index.html) - 具有 2D 和 3D 对象注释的大规模自动驾驶数据集.

## Footnotes

感谢团队 [xpp](http://wiki.ros.org/xpp) 用于创建我们使用的这个很棒的 GIF.
