<div class="github-widget" data-repo="vhpoet/awesome-ripple"></div>
## Awesome Ripple [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; 精选的 Ripple 资源列表.

拉取请求非常受欢迎.

#### Official
- [Ripple Website](https://ripple.com/)
- [Ripple Github](https://github.com/ripple/)
- [Blog](https://ripple.com/insights/)
- [Ripple Labs](https://ripple.com)
- [Twitter](https://twitter.com/ripple/)
- [Facebook](https://www.facebook.com/ripplepay/)
- [Weibo](http://www.weibo.com/RippleLabs/)

#### Books / Docs / Videos
- [Wiki](https://ripple.com/wiki/Main_Page)
- [Ripple Primer](https://ripple.com/ripple_primer.pdf)
- [Ripple Gateways](https://ripple.com/ripple-gateways.pdf)
- [Steven Zeiler's Ripple coding lessons](https://www.youtube.com/user/stevenzeiler/videos?flow=grid&view=0)
- [Wikipedia](https://en.wikipedia.org/wiki/Ripple_(payment_protocol))
- ["Ripple, The future of payments" video](https://vimeo.com/73887321)
- [Ripple Labs: Building the Internet of Money](https://www.youtube.com/watch?v=aoixyCNWg5k)
- [Build a VueJS WebApp connecting to the Ripple Ledger](https://itnext.io/develop-awesome-webapps-using-vuejs-webpack-bda08ebb691c)
- [Most common XRP misconceptions debunked](https://fudbingo.com)

#### Gateways / Bridges
- [Bitstamp](http://www.bitstamp.net/)
- [SnapSwap US](https://snapswap.us/)
- [SnapSwap EU](https://snapswap.eu/)
- [RippleCN](http://www.rebopay.com/)
- [RippleChina](http://www.ripplechina.net/)
- [Kraken](https://www.kraken.com/)
- [JustCoin](https://justcoin.com/)
- [RippleWise](https://www.ripplewise.com/)
- [Ripple Union](https://xagate.com)
- [Divident Rippler](https://www.dividendrippler.com/)
- [Ripple Israel](http://rippleisrael.co.il/)
- [The Rock Trading](https://www.therocktrading.com/)
- [WisePass](https://wisepass.com/)
- [Devcoin](http://ripple.d.evco.in/)
- [BuyXrp](http://buyxrp.net/)
- [BTC2Ripple](https://btc2ripple.com/)
- [NoFiatCoin](http://www.nofiatcoin.com/)
- [Ripple Singapore](https://www.ripplesingapore.com/)
- [PaxMoneta](https://paxmoneta.com)
- [Ripple Market Korea](http://ripple-market.co.kr/)
- [RippleFox](https://ripplefox.com/)
- [ShapeShift](https://shapeshift.io): 立即购买硬币，无需帐户
- [saldo.mx](http://saldo.mx/)

#### Code
###### Rippled - The Guy!
- [rippled](https://github.com/ripple/rippled/): Ripple 点对点网络守护进程
- [rippled Docker container (node)](https://github.com/WietseWind/docker-rippled) - [Docker hub](https://hub.docker.com/r/xrptipbot/rippled/)
- [rippled Docker container (validator)](https://github.com/WietseWind/docker-rippled-validator) - [Docker hub](https://hub.docker.com/r/xrptipbot/rippledvalidator/) - [Tutorial](https://medium.com/@WietseWind/how-to-run-a-ripple-validator-digitalocean-7e5fca1c3d77)

###### Libs - Libraries for talking to the Ripple API
- [ripple-libpp](https://github.com/ripple/ripple-libpp): C++ Standalone RCL-compatible transaction signing and serialization library
- [ripple-rest](https://github.com/ripple/ripple-rest)：用于在 Ripple 网络上提交付款和监控帐户的 RESTful API
- [ripple-lib](https://github.com/ripple/ripple-lib/): Java 脚本
- [xrpl-client](https://www.npmjs.com/package/xrpl-client): 具有健康检测和自动重新连接功能的 Javascript/Typescript nodejs WebSocket 客户端
- [xrpl-accountlib](https://www.npmjs.com/package/xrpl-accountlib) : Javascript/Typescript nodejs 库. 从家庭种子、助记符和秘密数字中签名和派生
- [ripple-lib-java](https://github.com/ripple/ripple-lib-java/): 爪哇
- [ripple-lib-ruby](https://github.com/kevinejohn/ripple-lib-rpc-ruby/): 红宝石
- [ripple-python](https://github.com/miracle2k/ripple-python/): Python 库
- [ripple-python-lib](https://github.com/arsenlosenko/python-ripple-lib): JSON-RPC 和数据 API 调用的 Python 实现
- [ripple-haskell](https://github.com/singpolyma/ripple-haskell/): 哈斯克尔
- [rubblelabs/ripple](https://github.com/rubblelabs/ripple): Go包与Ripple协议交互
- [RippleKit](https://github.com/xasos/RippleKit): 斯威夫特

###### Clients / Apps
- [ripple-client](https://github.com/ripple/ripple-client/): 网络客户端
- [ripple-client-desktop](https://github.com/ripple/ripple-client-desktop)：桌面客户端
- [ripple-client-ios](https://github.com/ripple-unmaintained/ripple-client-ios): iOS 客户端
- [ripplecharts](https://github.com/ripple/ripplecharts/): RippleCharts.com 图表网站
- [ripple-graph](https://github.com/ripple-unmaintained/ripple-graph): 波纹图
- [Ripple Go](https://bitbucket.org/dchapes/ripple/): Ripple Go 是一组 Go 包和一个 ripple 客户端.
- [Snow](https://github.com/justcoin/snow): 用node.js编写的数字货币兑换引擎.
- [Ripplectron](https://github.com/devjin0617/ripplectron): 电子桌面客户端

###### Other
- [gatewayd](https://github.com/ripple/gatewayd): Ripple网关软件自动化框架
- [ripple-blobvault](https://github.com/ripple/ripple-blobvault): 用于为 Ripple 客户端存储持久数据的服务器
- [ripple-authd](https://github.com/ripple/ripple-authd): Ripple peer-assisted key derivation server
- [rippled-historical-database](https://github.com/ripple/rippled-historical-database): SQL 数据库作为 Ripple 历史数据的规范来源
- [ripple-data-api](https://github.com/ripple/ripple-data-api)
- [https://github.com/vhpoet/awesome-ripple/blob/master/ripple-vault-client](https://github.com/vhpoet/awesome-ripple/blob/master/ripple-vault-client)
- [federation-php](https://github.com/ripple-unmaintained/federation-php): 具有静态 JSON 数据集的简单 PHP 联合端点
- [federation-python](https://github.com/miracle2k/ripple-federation-python)：用于简单联合端点的 Python 模块.
- [Ripple Rails](https://github.com/singpolyma/ripple-rails/)
- [Ripple Gen](https://github.com/CodeShark/RippleGen/)
- [Ripple Checkout](https://github.com/emschwartz/ripple-donate-widget)：用于使用 Ripple 支付的可嵌入小部件.
- [Magento plugin](http://www.magentocommerce.com/magento-connect/ripple-json-rpc.html)
- [rubblelabs/tx](https://github.com/rubblelabs/tx): 用于在 Ripple 网络上执行交易的工具
- [xrpayments.co](https://xrpayments.co): 生成付款请求二维码的工具（带货币转换）
- [XRP Text](https://xrptext.com)：使用 SMS 文本消息发送 XRP（即使在哑铃上）

#### Hosted Tools
###### Clients
- [Ripple Trade](https://rippletrade.com/): Ripple Labs开发的官方Ripple客户端
- [GateHub](https://gatehub.net/)

###### Developer tools
- [Ripple API Tool](https://ripple.com/build/websocket-tool/)
- [Ripple Info Tool](https://ripple.com/build/ripple-info-tool/)
- [Ripple.txt checker](https://ripple.com/tools/txt/)
- [jRippleAPI](https://github.com/pmarches/jStellarAPI)
- [Rippleserver Google Group](https://groups.google.com/forum/#!forum/ripple-server/)

###### Trader tools / charts
- [Ripple Charts](https://ripplecharts.com/)
- [Webr3](http://xrp.webr3.org/usd-xrp)

###### Visualizations
- [Ripple Graph](https://www.ripplecharts.com/%23/graph/)
- [Ripple Live (GateHub)](https://gatehub.net/live)
- [Rich list, ledger stats & XRP distribution](https://ledger.exposed)

###### Other tools
- [Ripple Helpers](https://github.com/vhpoet/ripple-helpers/)
- [XRPTools](http://xrptools.com/)
- [XRPValue](http://xrpvalue.com/): 实时 XRP 价格.
- [RippleGen](https://github.com/CodeShark/RippleGen)：用于 ripple p2p 网络的简单多线程虚荣生成器.
- [Dollero](http://dollero.com/): 全球汇款支付软件

#### Other
- [International Ripple Business Association](http://www.ripplebusiness.org/)
- [Ripple Federation](http://ripplefederation.org/)
- [WhatisRipple.info](http://whatisripple.info/)

#### Social
- [Reddit 'ripple'](https://www.reddit.com/r/ripple/)
- [Reddit 'ripplers'](https://www.reddit.com/r/ripplers/)
- [XRPTalk](https://xrptalk.org/)
- [Ripple Forum](http://rippleforum.org/)
- [Ripple Lounge](http://www.ripplelounge.com/)
- [Rippleusers Google Group](https://groups.google.com/forum/#!forum/rippleusers)
- [XRP Tip Bot for Reddit, Twitter & Discord](https://xrptipbot.com)

#### Codius
- [Codius Website](https://codius.org/)
- [Codius Github](https://github.com/codius)
- [Codius Hosts](http://codiushosts.com/)

## License

[![CC0](https://i.creativecommons.org/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)
