<div class="github-widget" data-repo="lukasz-madon/awesome-remote-job"></div>
## Awesome Remote Job [![Awesome](https://cdn.jsdelivr.net/gh/sindresorhus/awesome@d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Track Awesome List](https://www.trackawesomelist.com/badge.svg)](https://www.trackawesomelist.com/lukasz-madon/awesome-remote-job/)

A curated list of awesome [remote working](https://en.wikipedia.org/wiki/Telecommuting) resources.

*To contribute, click README.md and then the pencil icon. Make your changes and click the "Propose file change" button to submit a pull request. Make sure to follow [the contributions guidelines](CONTRIBUTING.md).*


<!-- MarkdownTOC depth=4 -->

- [Awesome Remote Job  ](#awesome-remote-job--)
  - [Table of Contents](#table-of-contents)
  - [Articles \& Posts](#articles--posts)
  - [Videos](#videos)
  - [Books](#books)
  - [Humor](#humor)
  - [Job boards](#job-boards)
  - [Job boards aggregators](#job-boards-aggregators)
  - [Housing](#housing)
  - [Relocation Incentives](#relocation-incentives)
  - [Interviewing](#interviewing)
  - [Events](#events)
  - [Newsletters](#newsletters)
  - [Podcasts](#podcasts)
  - [Companies with "remote DNA"](#companies-with-remote-dna)
  - [Q\&A](#qa)
  - [Communities](#communities)
  - [Conferences](#conferences)
  - [Tools](#tools)
      - [HR](#hr)
      - [Communication](#communication)
      - [Project Management](#project-management)
      - [Others](#others)
  - [Law \& Finance](#law--finance)
  - [Others](#others-1)
  - [License](#license)

<!-- /MarkdownTOC -->

## Articles & Posts
  1. [3 mistakes to avoid if you want to get hired remotely](https://x-team.com/blog/mistakes-remote-developers)
  1. [5 Little-Known Hacks for Finding Remote Work](https://hubstaff.com/blog/hacks-find-remote-jobs/)
  1. [5 Things I've Learned From Working Remotely](https://www.donedone.com/blog/five-things-ive-learned-working-remotely)
  1. [5 Tricks to Get More Done While Working Remotely](https://rdutel.medium.com/working-remotely-getting-things-done-38dcd0413733)
  1. [8 tips that will make you a more active, healthier remote developer](https://x-team.com/blog/how-to-be-healthy-remote)
  1. [10 Lessons from 4 Years Working Remotely at Automattic](https://whenihavetime.com/2014/07/08/10-lessons-from-4-years-working-remotely/)
  1. [10 Secrets to Becoming a Great Remote Developer](https://x-team.com/blog/10-secrets-to-becoming-a-great-remote-developer)
  1. [21 tools that will help your remote team work better together](https://thenextweb.com/news/tools-remote-teams)
  1. [30 Tips for Successful Communication as a Remote Worker](https://www.hanselman.com/blog/30-tips-for-successful-communication-as-a-remote-worker)
  1. [Acceptance of Telecommuting Project Management Grows](https://www.amanet.org/articles/acceptance-of-telecommuting-project-management-grows/)
  1. [Andreessen-Incubated Teleport Aims To Make Location Irrelevant For Mobile Workers](https://techcrunch.com/2014/05/19/teleport/)
  1. [Bosses without borders: Essential tools for managing remote workers](https://www.pcworld.com/article/453170/bosses-without-borders-essential-tools-for-managing-remote-workers.html)
  1. [Communication for Distributed Teams](https://www.lullabot.com/articles/communication-for-distributed-teams)
  1. [Currents: The Remote Developer Experience (July 2019)](https://www.digitalocean.com/blog/currents-july2019)
  1. [Datadog Engineering: 9 ways to make working remote work for you](https://www.datadoghq.com/blog/pup-culture/9-ways-to-make-working-remote-work-for-you/)
  1. [Death of the office and rise of the telecommuter](https://www.zdnet.com/article/death-of-the-office-and-rise-of-the-telecommuter/)
  1. [Distributed Design: How Stack Overflow builds strong remote teams](https://www.tedgoas.com/blog/distributed-design/)
  1. [Find "Hidden" Remote Jobs with Google Search](https://medium.com/ft-remote-job/how-to-find-hidden-remote-jobs-using-google-search-12ebaa2ea8ea?source=friends_link&sk=3bc251fed25dddd4c1a024ae4dd58e30)
  1. [GitLab's Remote Manifesto](https://about.gitlab.com/blog/2015/04/08/the-remote-manifesto/)
  1. [Give people the freedom of where to work](https://www.virgin.com/branson-family/richard-branson-blog)
  1. [Hiring Secrets Of A Distributed Company](https://www.lullabot.com/articles/hiring-secrets-of-a-distributed-company)
  1. [How GitHub Works](https://zachholman.com/posts/how-github-works/)
  1. [How many companies are 100% distributed? (Research Summary)](https://scottberkun.com/2013/how-many-companies-are-100-distributed/)
  1. [How many people really work from home? (research summary)](https://scottberkun.com/2013/how-many-people-really-work-from-home-research-summary/)
  1. [How to focus when working remotely](https://x-team.com/blog/focus-working-remotely)
  1. [How to Handle Client Work Remotely: Our Communication Stack](https://marsbased.com/blog/2015/12/07/how-to-handle-client-work-remotely-our-communication-stack)
  1. [How to Make Remote Working Work for You](https://www.toptal.com/remote/how-to-make-remote-working-work-for-you)
  1. [How to run a team of people who never see each other](https://qz.com/230998/how-to-run-a-team-of-people-who-never-see-each-other)
  1. [How to suggest improvements remotely](https://x-team.com/blog/suggest-improvements-remotely)
  1. [How Working at Home Works (For Us)](https://www.lullabot.com/articles/how-working-at-home-works-for-us)
  1. [It’s Unclearly Defined, but Telecommuting Is Fast on the Rise](https://www.nytimes.com/2014/03/08/your-money/when-working-in-your-pajamas-is-more-productive.html?_r=0)
  1. [Latest Telecommuting Statistics | Global Workplace Analytics](https://globalworkplaceanalytics.com/telecommuting-statistics)
  1. [Learning From Distributed Companies](https://www.lullabot.com/articles/learning-from-distributed-companies)
  1. [Managing a Geographically Dispersed Team: Achieving Your Goals Together, While Apart](https://www.mindtools.com/awe2ycs/managing-a-geographically-dispersed-team)
  1. [My Ideal Day as a Remote Programmer: Taking Charge of Your Daily Routine](https://buffer.com/resources/my-ideal-day-as-a-programmer-taking-charge-of-your-daily-routine/)
  1. [My Remote Developer Life](https://shift.infinite.red/my-remote-developer-life-ama-bb91fa7bd0bd)
  1. [Phoning It In: 3 Years of Lessons From Running a Remote Business](https://observer.com/2014/02/phoning-it-in-3-years-of-lessons-from-running-a-remote-business/)
  1. [Remote versus Co-located Work](https://martinfowler.com/articles/remote-or-co-located.html)
  1. [Remote Work: How to work the Precision Nutrition way](https://www.precisionnutrition.com/remote-how-to-work-the-pn-way)
  1. [Remote worker vs distributed team](https://opensource.com/life/11/11/remote-worker-vs-distributed-team)
  1. [Remote Working – 3 Year Retrospective](http://blog.jonliv.es/blog/2015/01/14/remote-working-3-year-retrospective/)
  1. [Rethinking Agile in an office-less world](https://signalvnoise.com/posts/3641-rethinking-agile-in-an-office-less-world)
  1. [Six Strategies for Managing Telecommuters](https://www.cio.com/article/280749/leadership-management-six-strategies-for-managing-telecommuters.html)
  1. [Solo Workers Bond at Shared Workspaces](https://www.nytimes.com/2013/05/05/fashion/solo-workers-bond-at-shared-workspaces.html)
  1. [The 5 most important things we do as a remote company](https://x-team.com/blog/5-important-things-remote-company)
  1. [The case for all-remote companies](https://about.gitlab.com/blog/2018/10/18/the-case-for-all-remote-companies/)
  1. [The future of telecommuting: Corralling the Yahoos](https://www.economist.com/business/2013/03/02/corralling-the-yahoos?fsrc=scn%2Ftw%2Fte%2Fpe%2Fcorallingtheyahoos)
  1. [The Pros & Cons of Being a Remote Team (& How We Do It)](https://blog.groovehq.com/being-a-remote-team)
  1. [The Ultimate Remote Team Culture](https://www.toptal.com/remote-work-playbook)
  1. [The Villains of Remote Work](https://blog.dnsimple.com/2016/10/the-villains-of-remote-work/)
  1. [Things To Watch Out For While Working Remotely](https://www.toptal.com/remote/remote-work-burnout-a-cautionary-tale)
  1. [Tips to Land a Remote Job](https://moduscreate.com/blog/tips-to-land-a-remote-job/)
  1. [To Raise Productivity, Let More Employees Work from Home](https://hbr.org/2014/01/to-raise-productivity-let-more-employees-work-from-home)
  1. [What is a Distributed Company?](https://www.lullabot.com/articles/what-is-a-distributed-company)
  1. [Who Needs an Office? How to Go 100 Percent Remote.](https://www.entrepreneur.com/growing-a-business/who-needs-an-office-how-to-go-100-percent-remote/242708)
  1. [Why I work remotely (hint: it has nothing to do with productivity)](https://signalvnoise.com/svn3/why-i-work-remotely-hint-it-has-nothing-to-do-with-productivity/)
  1. [Why Coworking Is a Hit for Telecommuters and Entrepreneurs](https://www.cio.com/article/300381/telecommuting-why-coworking-is-a-hit-for-telecommuters-and-entrepreneurs.html)
  1. [Why Remote Workers Are More (Yes, More) Engaged](https://hbr.org/2012/08/are-you-taking-your-people-for)
  1. [Why Small Businesses Are Building Remote Workforces](https://www.businessinsider.com/why-small-businesses-are-building-remote-workforces-2013-10)
  1. [Why We (Still) Believe in Working Remotely](https://stackoverflow.blog/2013/02/01/why-we-still-believe-in-working-remotely/)
  1. [Working Remotely: A Complete Guide to Turn You Into a Pro](https://www.paymoapp.com/blog/working-remotely/)
  1. [Working Remotely for Extroverts](https://stephyiu.com/2014/12/13/working-remotely-for-extroverts/)
  1. [Yahoo, Best Buy, and Telecommuting: Advice From A Distributed Company](https://www.lullabot.com/articles/yahoo-best-buy-and-telecommuting-advice-from-a-distributed-company)
  1. [Your Commute Is Killing You](https://slate.com/business/2011/05/long-commutes-cause-obesity-neck-pain-loneliness-divorce-stress-and-insomnia.html)
  1. [Why remote work makes disagreement hard](https://zapier.com/blog/how-to-disagree-remote-work/)
  1. [10 Leadership Lessons from 10 Years Working in a Fully-Distributed and Remote Company](https://whenihavetime.com/2020/07/09/10-leadership-lessons-from-10-years-working-remotely/)
  1. [Remote Work for Everyone - NY Times](https://www.nytimes.com/2021/07/06/technology/remote-work-for-everyone.html)
  1. [This Is the Future Of Remote Work In 2021](https://www.forbes.com/sites/carolinecastrillon/2021/12/27/this-is-the-future-of-remote-work-in-2021/?sh=500189961e1d)


## Videos
  1. [David Copeland: The Effective Remote Developer](https://www.infoq.com/presentations/effective-remote-developer-2017/)
  1. [Fluent 2013: Mike Hostetler, “Remote Working Works!”](https://www.youtube.com/watch?v=23oBUH270YU)
  1. [Jason Fried: Why work doesn't happen at work](https://www.youtube.com/watch?v=5XD2kNopsUs)

## Books
  1. [Async Remote](https://products.arkency.com/async-remote/).
     by Robert Pankowecki and Andrzej Krzywda (Arkency), 2014.
  1. [Distributed Teams](https://oduinn.com/book/).
     by John O'Duinn, 2018.
  1. [Remote: Office Not Required](https://basecamp.com/books/remote).
     by Jason Fried and David Heinemeier Hansson (37signals), 2013.
  1. [The Ultimate Guide to Remote Work](https://zapier.com/resources/guides/remote-work).
     by Wade Foster (Zapier), 2015.
  1. [The Year Without Pants: WordPress.com and the Future of Work](https://scottberkun.com/yearwithoutpants/).
     by Scott Berkun, 2013.

## Humor

  1. [Why working from home is both awesome and horrible](https://theoatmeal.com/comics/working_home)

## Job boards
  1. [Real Work From Anywhere](https://www.realworkfromanywhere.com/) - A site for fully location independent jobs. All jobs on the site are 100% work from anywhere.
  1. [4 Day Week](https://4dayweek.io) - Software jobs with a better work / life balance.
  1. [Authentic Jobs](https://authenticjobs.com/?search_location=remote)
  1. [Built In](https://builtin.com/jobs/remote)
  1. [ClojureJobboard.com](https://clojurejobboard.com/remote-clojure-jobs.html)- Clojure jobs, filter -> Remote only
  1. [Crypto Jobs](https://crypto.jobs/?jobs=remote) - Blockchain jobs for crypto enthusiasts.
  1. [Crypto Jobs List](https://cryptojobslist.com/remote) - #1 job board to find and post crypto, bitcoin and blockchain jobs.
  1. [Cryptocurrency Jobs](https://cryptocurrencyjobs.co/remote/) - Location filter -> *Remote*
  1. [CyberJobHunt.in](https://cyberjobhunt.in/) - Explore Cyber Security Jobs in top Companies and Startups. 
  1. [Daily Remote](https://dailyremote.com) Filter and find remote jobs for every role!
  1. [Diversify Tech](https://www.diversifytech.com/job-board) - Companies are transparent about their Diversity & Inclusion efforts 
  1. [Dribbble Jobs](https://dribbble.com/jobs?location=Anywhere)
  1. [Drupal Jobs](https://jobs.drupal.org/home/type/telecommute-remote-3588)
  1. [freelancermap](https://www.freelancermap.com/projects/remote.html) - Freelance & contract jobs for IT experts (mostly German projects)
  1. [Golangprojects](https://www.golangprojects.com/golang-remote-jobs.html) filter -> Remote only
  1. [Guru](https://www.guru.com/) - (has MANY different categories outside software)
  1. [HackerX](https://hackerx.org/jobs/)
  1. [Hasjob](https://hasjob.co/) – Location filter -> "*Anywhere/Remote*"
  1. [HigherEdJobs](https://www.higheredjobs.com/search/remote.cfm) has remote type filter.
  1. [HN hiring](https://www.hnhiring.me/) – Filter REMOTE.
  1. [JOBBOX.io](https://landing.jobs/jobs) – Filter -> Remote only.
  1. [JobsCollider](https://jobscollider.com/remote-jobs) - * Tens of thousands of remote jobs from over 10,000 companies and startups worldwide. *
  1. [Jobspresso](https://jobspresso.co/) * High-quality remote positions that are open and legitimate *
  1. [JustRemote](https://justremote.co)
  1. [Larajobs](https://larajobs.com/?location=&remote=1) – The artisan employment connection
  1. [No Fluff Jobs](https://nofluffjobs.com/pl/#criteria=remote) – Filter -> “*remote*”
  1. [NODESK](https://nodesk.co/remote-jobs/)
  1. [Power to Fly](https://powertofly.com/jobs/) - Specific to women
  1. [Remote AI Jobs](https://www.moaijobs.com/remote-ai-jobs) - Remote AI jobs in Machine Learning, Engineering, Data Science, Research, etc
  1. [Remote Backend Jobs](https://www.remotebackendjobs.com/) - Find exclusively remote backend jobs aggregated from the top 22 job boards in the world.
  1. [Remote Frontend Jobs](https://www.remotefrontendjobs.com/) - Find exclusively remote frontend jobs aggregated from the top 22 job boards in the world.
  1. [PyJobs.com](https://www.pyjobs.com/?remoteLevel[0]=1&remoteLevel[1]=2) - Jobs for Python developers
  1. [Remote Game Jobs](https://remotegamejobs.com/) - Find remote work and talent in the game industry.
  1. [remote-es/remotes](https://github.com/remote-es/remotes) - Repository listing companies which offer full-time remote jobs with Spanish contracts
  1. [thatmlopsguy/remote-pt](https://github.com/thatmlopsguy/remote-pt) - Repository listing companies which offer full-time remote jobs with Portuguese contracts
  1. [remote-jobs](https://github.com/remoteintech/remote-jobs) - A list of semi to fully remote-friendly companies in tech
  1. [Remotees](https://weworkremotely.com/?utm_source=Remotees&utm_medium=Redirect&utm_campaign=Remotees)
  1. [Remote.co Jobs](https://remote.co/remote-jobs/)
  1. [RemoteJobs.lat](https://remotejobs.lat/) -  Remote jobs for LATAM people
  1. [Remotive Jobs](https://remotive.com/)
  1. [Remote People](https://remotepeople.io/)
  1. [Remote Works](https://remote.works-hub.com) - Remote jobs in software development
  1. [Ruby On Remote](https://rubyonremote.com/) - All ruby remote jobs in one place
  1. [Skip the Drive](https://www.skipthedrive.com/)
  1. [Slasify](https://slasify.com/en) - Remote tech, art/design and marketing opportunities from Asia, global payroll service included.
  1. [Stream Native Jobs](https://streamnative.io/careers) - Scroll down to `Join Us`
  1. [SwissDev Jobs](https://swissdevjobs.ch/) - Filter -> "Remote / Work from home"
  1. [UI & UX Designer Jobs](https://uiuxdesignerjobs.com/remote-ui-ux-designer-jobs/) - Remote jobs for UI, UX & UXR Designers
  1. [Upwork](https://www.upwork.com) - Find remote jobs in any category
  1. [Virtual Vocations](https://www.virtualvocations.com/)
  1. [Vue.js Jobs](https://vuejobs.com/) Find Vue.js jobs all around the world - Click on "Remote" tab.
  1. [Web3Jobs](https://web3.career/remote-jobs) - Remote Web3 Jobs
  1. [Wellfound](https://wellfound.com/jobs) - Startup Jobs. Search by going to Job Type, and selecting "Remote OK".
  1. [We Work Remotely](https://weworkremotely.com/)
  1. [Workana](https://www.workana.com/) Freelance Job Board in Spanish and Portuguese
  1. [Working Nomads](https://www.workingnomads.com/jobs)
  1. [zuhausejobs.com](https://zuhausejobs.com) - Remote Jobs in German-speaking countries (Germany/Austria/Switzerland)
  1.  [Dataaxy](https://dataaxy.com) Job board and reverse job board specialized in Data and AI in North America
  1.  [Freel](https://freel.ca) Freelancers job board in Canada
  1.  [DevOpsJobs](https://devopsprojectshq.com) DevOps, SRE, Cloud and Platform engineering jobs
## Job boards aggregators
  1. [Career Vault](https://careervault.io/) - Hundreds of remote jobs added each day from thousands of company career pages. Free and no signup required.
  1. [Findwork](https://findwork.dev/) Crawls multiple job boards and enriches job postings with Glassdoor (reviews) and Crunchbase (funding).
  1. [Google Jobs](https://www.google.com/search?q=remote&ibp=htl;jobs#fpstate=tldetail&htidocid=IO0hI7dpKTSlzSKoAAAAAA%3D%3D&htin=1&htivrt=jobs)  – Aggregates from multiple boards and employer sites with sensitivity to location, job type, and more. Find out how to use it [here](https://support.google.com/websearch/answer/7498276?p=job_search_box&sa=X&ved=0ahUKEwid_qyLmJfXAhVD4YMKHYGBAK8Qra4CCGQoAQ&visit_id=1-636449234996681631-3229288694&rd=1).
  1. [JS Remotely](https://javascript.jobs/remote) - All remote JavaScript jobs on one board
  1. [Remote.io](https://www.remote.io/) - Job board and aggregator for remote jobs, primarily tech.
  1. [Remote 4 Me](https://remote4me.com/) - An aggregator for remote jobs in tech and non-tech.
  1. [Remote Index](https://remoteindex.co/) - Job board and aggregator for remote jobs in tech.
  1. [Remote Leaf](https://remoteleaf.com) - Hand-picked remote jobs from 40+ remote job boards, 1500+ company career pages, Twitter feed, Linkedin, Reddit, Hacker News Hiring and only sends the ones that apply to you.
  1. [Remote OK](https://remoteok.com/) - Scrapes many job board feeds for remote positions.
  1. [Remote Python](https://www.remotepython.com/) - Job board and aggregator specifically for remote Python jobs.
  1. [SlashJobs](https://slashjobs.com/) - Remote dev jobs aggregator. `and`/`or`/`not` filters, location search, fast, no sign-up/login.
  1. [UN Talent](https://untalent.org/jobs/home-based) - Vacancies at the United Nations and its agencies.
  1. [Vollna](https://www.vollna.com/) - An aggregator for top freelance sites.
  1. [whoishiring.io](https://whoishiring.io/#!/search/19.41/-43.14/2/?remote=true)

## Housing
  1. [bedndesk](https://www.bedndesk.com/) - Coworking & coliving space in Mallorca island in Spain
  1. [Common](https://www.common.com/) - Coliving House in New York
  1. [Coworking in the Sun](https://www.coworkinginthesun.com/) - Coliving & coworking space in Tenerife island in Spain
  1. [HubBOG](https://www.hubbog.com/) - Coworking Space + Startup Accelerator. Bogotá, Colombia
  1. [Mokrin House](https://mokrinhouse.com/) - Coliving & coworking space in a rural area of Serbia
  1. [Nest Copenhagen](https://www.nestcopenhagen.dk/) - Coliving space in Copenhagen, Denmark
  1. [NoHatDigital](https://www.nohatdigital.com/mansionpage/) - Coliving space in Mexico
  1. [Nomad House](https://nomadhouse.io) - Global network of nomad housing
  1. [Sende](https://www.sende.co/) - Coliving & coworking space in northern Spain
  1. [Sun Desk](https://sun-desk.com/) - Coliving & coworking space in Taghazout, Morocco
  1. [Talent Garden](https://talentgarden.com/en/coworking) - Coworking space mainly in Italy but available in some other countries
  1. [The Surf Office](https://www.surfoffice.com/) - Coworking & vacation space in Portugal, Canaries and California
  1. [Work From Curacao](http://www.workfromcuracao.com/) - Coliving space in Curacao
  1. [Worldpackers](https://www.worldpackers.com) - Housing/work exchange
  1. [Anceu](https://anceu.com) - Rural Coliving & coworking space in Galicia, Spain

## Relocation Incentives
  1. [Live And Work In Maine](https://www.liveandworkinmaine.com/opportunity-maine) - The amount spent on student loan payments each year is subtracted from your state income taxes. Out-of-state residents must have earned their bachelors or associates degrees after 2015 to qualify.
  1. [Tulsa Remote](https://www.tulsaremote.com/) - Get $10,000 cash to work from Tulsa.
  1. [Vermont Remote Worker Grant Program](https://thinkvermont.com/relocate/) - Receive up to a max of $5,000 per year to work from Vermont. Cannot exceed $10,000 for life of the program per individual.
  1. [Remote Shoals](https://remoteshoals.com/) - Work remotely? Get $10,000 to do your job from the Shoals.
  1. [Visto](https://visto.ai/) - We relocate developers to canada and help companies to bring developers outside the world!

## Interviewing
  1. [andreis/interview](https://github.com/Olshansk/interview) - Everything you need to kick ass on your coding interview
  1. [awesome-interviews](https://github.com/DopplerHQ/awesome-interview-questions) - A curated awesome list of lists of interview questions
  1. [adaface.com/pair-pro](https://www.adaface.com/online-assessment-platform) - Remote pair programming interview tool with shared editor, code compiler and video conferencing
  1. [interviewing.io](https://interviewing.io/) - Become awesome at technical interviews
  1. [karat.io](https://karat.com/) - Have a free practice coding interview with a professional interviewer
  1. [exponent](https://www.tryexponent.com) - Practice coding interviews (both sides of the table) with other candidates
  1. [remoteinterview.io](https://www.remoteinterview.io/) - Coding tests & pair programming interview tools
  1. [skillmeter.com](https://skillmeter.com/) - Online skills testing platform for recruiters & companies
  1. [hackerrank.com](https://www.hackerrank.com/) - Online platform for code studying and recruiting with job offers also
  1. [Codility](https://www.codility.com/) - Online platform that offers sponsored challenges
  1. [Meetapro](https://www.meetapro.com/) - An Airbnb style mock interview platform with top FAANG interviewers

## Events
  1. [deceler8](https://sierraymar.exposure.co/decelerate-bali) - 10 days retreat
  1. [Project Getaway](https://www.projectgetaway.com/) - 30 days retreat
  1. [Recurse Center](https://www.recurse.com/) - free 3-month retreat

## Newsletters
  1. [Daily Remote](https://dailyremote.com/newsletter) - A newsletter containing remote jobs crafted and curated especially for you
  2. [European Remote](https://europeanremote.com/alerts/) - Selected opportunities for European tech folks, every week in your inbox
  1. [Making Remote Work](https://www.mailerlite.com) - MailerLite's monthly remote newsletter sharing best practices, mistakes and learnings, world views (quite literally) and remote job vacancies.
  1. [NODESK](https://nodesk.co/) - A newsletter about digital nomads and remote work that is sent out every two weeks.
  1. [Remote Internships](https://smash.vc/startup-newsletter/)
  1. [Remote Jobs Club](https://remotejobsclub.com) - Weekly newsletter featuring a hand curated list of remote jobs
  1. [Remoteur](https://newsletter.remoteur.com/) - Remote jobs in Europe delivered to your inbox bi-weekly
  

## Podcasts
  1. [Building Remote Teams](https://www.buildingremoteteams.com/) - Targeted at people already working remotely and focuses on nuanced challenges of remote work.
  1. [Distributed](https://distributed.blog/podcast/) - Interview podcast by Matt Mullenweg. Focused on the benefits and challenges of distributed work and recruiting people around the globe.
  1. [Lessons from Distributed Companies](https://www.lullabot.com/podcasts/drupalizeme-podcast/lessons-from-distributed-companies)
  1. [Remote Works](https://remote.works) - The Remote Works podcast publishes every two weeks with host Jonathan Sharp discussing the opportunities, experiences, culture and community surrounding remote work, remote teams, telecommuting and digital nomads.
  1. [Wide Teams](https://www.wideteams.com/) - Each episode a one-on-one interview with a remote worker taking about workflow and practices


## Companies with "remote DNA"
  1. [10up](https://10up.com/careers/) - 10up makes the web better by finely crafting websites & tools for content creators.
  1. [15Five](https://www.15five.com/about/careers/) - Join our mission to create the spaces where people become their greatest selves, by joining some of the greatest employees around.
  1. [1Password](https://1password.com/careers) - The world’s most-loved password manager.
  1. [Adeva](https://adevait.com) - An exclusive remote developers network. Adeva partners with companies to scale engineering teams on-demand.
  1. [AgentFire](https://agentfire.com/) - Hyper local real estate websites powered by Wordpress.
  1. [Affirm](https://www.affirm.com/careers) - financial technology company that offers point-of-sale financing options to consumers.
  1. [Aha!](https://www.aha.io/company/careers/current-openings) - Aha! is roadmapping software for PMs who want their mojo back.
  1. [AirTreks](https://airtreks.com/about/) - Multi-stop international flight planner with a distributed team.
  1. [Alley](https://alley.com/careers/) - Digital Agency. We are strategists, researchers, designers, and developers who craft custom digital experiences for publishers, nonprofit institutions, museums, and brands.
  1. [amazee.io](https://www.amazee.io/careers/) - Open source container hosting - high-performance flexible solutions. Kubernetes, TypeScript (Node.js and React), Go, GraphQL.
  1. [Arkency](https://arkency.com/join-our-team/) - Rails and React.js experts, fully remote/async.
  1. [Array.com](https://array.com/company/careers) - Financial, identity, and privacy protection tools.
  1. [Articulate](https://www.articulate.com/about/careers/) - EdTech. Makes software that helps teachers make e-learning courses. Ruby, Node, C#, and .NET for Windows app.
  1. [AT&T](https://www.att.jobs) - Nearly [20% of the eligible workforce](https://www.att.com/Common/about_us/files/csr_2012/worklife_balance.pdf) works remotely.
  1. [Aurora Solar](https://aurorasolar.com/careers/) - solar permitting.
  1. [Auth0](https://www.okta.com/company/careers/) - Zero-friction authentication and authorization for developers.
  1. [Authentic F & F](https://authenticff.com/) - Independent design and technology studio based in Denver and Minnesota
  1. [Aurity](https://aurity.co/) - 100% remote company, specializing in React and React Native.
  1. [Automattic](https://automattic.com/work-with-us/) - Makers of WordPress.com and Gravatar.
  1. [AssemblyAI](https://www.assemblyai.com/careers) - AI models to transcribe and understand speech.
  1. [Avallain](https://www.avallain.com/) - Education Technology and Digital Publishing. We have the tools and processes to achieve the positive impact on human potential that technology enhanced education can provide
  1. [AvantStay](https://apply.workable.com/avantstay/) - Short-term rental company based in Los Angeles, with remote dev team.
  1. [Axelerant](https://www.axelerant.com/careers)
  1. [BandLab](https://www.bandlab.com/careers) - Social music platform that enables creators to make music and share the creative process with musicians and fans.
  1. [Baremetrics](https://baremetrics.com/about) - Analytics and insights for Stripe, Braintree, Recurly and Chargify.
  1. [BaseCamp](https://basecamp.com/about) - Project management software.
  1. [Baselayer](https://www.baselayer.com/) - Data center and infrastructure management software.
  1. [BeBanjo](https://www.bebanjo.com/company/careers) - Software as a service for managing video on-demand. Ruby / Rails, Elasticsearch, Sidekiq.
  1. [Bilsteingroup](https://bilsteingroup.com/en/career/) - Automotive spare parts. Python, Java, Postgres. Teams accross Europe. HQ in Germany.
  1. [Binti](https://binti.com/current-openings/) - Foster care.
  1. [Bluespark Labs](https://www.bluespark.com/careers) - WebDev Consulting and makers of Roomify. Remote team with HQs in Raleigh, NC and Italy. Drupal.
  1. [Blend](https://blend.com/company/careers/) - Fintech.
  1. [BookingSync](https://www.smily.com/company/jobs) - Vacation Rental Software for professionals. Fully distributed team, we work remotely and try to make a company retreat each year. Proud Ember.js official sponsor, Ruby / Rails
  1. [Brave](https://brave.com) - Web browser with built-in ad blocker and crypto-token micro-payments.
  1. [Buffer](https://buffer.com/journey) - Tools to help manage social media. PHP, CodeIgniter, MongoDB, Memcache, Backbone.js, React.js, Grunt.js, LESS, and Python.
  1. [Bugfender](https://bugfender.com/) - Bugfender is a remote logger for multiple platforms including iOS and Android. It stores logs created by your application and sends them to our server, creating a remote console where you can see logs in real time. Remote company based in Barcelona.
  1. [ButterCloud](https://www.buttercloud.com/) - A small team of web & app developers. We help startups & small to medium-sized businesses build, maintain, and grow their products.
  1. [Calm](https://www.calm.com/careers) - improve your health and happiness.
  1. [Cadasta](https://cadasta.org/) - Secure platform for mapping global land & resource rights. 100% remote team; Python, Django, JavaScript, PostgreSQL.
  1. [Canonical](https://canonical.com/careers/all) - Ubuntu.
  1. [Ceros](https://labs.ceros.com/jobs/#/) - .
  1. [Chef](https://www.chef.io/careers) - We are all about IT automation for speed and awesomeness. Ruby, JavaScript & shell scripting. HQ in Seattle but we have employees all around US.
  1. [Ciao Bambino](https://ciaobambino.com/) - Family destinations and hotel reviews.
  1. [Circonus](https://www.apica.io) - SaaS and on-prem monitoring, analytics, alerting, and more.  C, Go, Java, Perl.  HQ in Fulton MD, most employees are remote.
  1. [Clevertech](https://lumenalta.com/remote-jobs) - We build incredible, game-changing technology.
  1. [Close](https://jobs.lever.co/close.io/) - Inside sales CRM for startups and SMBs.
  1. [Codeship](https://www.cloudbees.com/products/codeship) - SaaS Continuous Delivery
  1. [CodeWeavers](https://www.codeweavers.com/about/jobs) - Wine-based open source software.
  1. [Collabora](https://www.collabora.com/careers.html) - Open source software-based consulting.
  1. [ConsenSys](https://consensys.io/careers) - Blockchain software technology company with offices all around the world, and independent employees in even more locations.
  1. [Continu](https://www.continu.com/) - Continuous learning software for modern teams.
  1. [Coursera](https://careers.coursera.com/jobs/search) - online courses.
  1. [CRO Metrics](https://crometrics.com/careers/) - Data-driven expirementation and growth programs.
  1. [Crosscan](https://crosscan.com/jobs/) - Retail Analytics, IoT (PHP, React, Web, Mobile, Rust)
  1. [Crossover](https://app.crossover.com/x/marketplace/available-jobs) - Project-based Java, .Net and DevOps positions.
  1. [Customer.io](https://customer.io/careers) - Customer engagement platform. 100% remote and globally distributed team. Go, MySQL, Typescript, Ember, React, etc
  1. [DataCose](https://www.datacose.com) - Custome web development and custom automations. Python, Vue.Js, TypeScript
  1. [Datadog](https://careers.datadoghq.com) - Easy to use and scalable monitoring systems for modern and dynamic infrastructure.  Distributed team with offices in New York, Boston and Paris.  Engineers based all around the world.
  1. [DataStax](https://www.datastax.com/company/careers) - Consulting based on Apache Cassandra.
  1. [Deeson](https://manifesto.co.uk/) - UK-based with European team. Digital agency specialising in Drupal, Symfony and Laravel
  1. [DigitalOcean](https://www.digitalocean.com/careers) - Simple Cloud Hosting, Built for Developers
  1. [Discourse](https://www.discourse.org/team) - Civilized discussion for your community.
  1. [DNSimple](https://dnsimple.com/) - Small 100% remote and globally distributed team working to make domain management an afterthought.
  1. [Docker](https://www.docker.com/career-openings/) - 
  1. [Doist](https://doist.com/careers) - Redefining productivity since 2007.
  1. [DoIT](https://careers.doit.com/) - technology and cloud expertise.
  1. [Dotnetos](https://dotnetos.org/) - Dotnet performance conferences, meetups and courses.
  1. [Doximity](https://workat.doximity.com) - Largest online medical network of US physicians. Ruby, Rails, Go, JavaScript, MySQL.
  1. [Drupal Association](https://assoc.drupal.org/jobs) - Non-profit supporting the Drupal project.
  1. [DuckDuckGo](https://duckduckgo.com/duckduckgo-help-pages/) - Search engine.
  1. [EasyCommunicationTechnology](https://www.easycomtec.com/homeoffice/developer) - .NET development using C#, Angular, Azure. Remote-first company.
  1. [Elastic](https://www.elastic.co/) - Open source search & analytics
  1. [Eloquentix](https://www.eloquentix.com/) - All remote company across 3 continents and 9 timezones.
  1. [Envato](https://www.envato.com/about/careers/) - Maker of ThemeForest and other online marketplaces. MySQL, Ruby, Rails, JavaScript. Distributed team with HQ in Melbourne, Australia.
  1. [Ergeon](https://www.ergeon.com/careers/) - Home Services and construction company. An all-remote company with HQ in Palo Alto, California, but hiring worldwide.
  1. [Etsy](https://careers.etsy.com) - Marketplace for artists. MySQL, Memcache, PHP. Offices in Dublin, Paris, San Francisco, New York, London and Melbourne.
  1. [ExportData](https://www.exportdata.io/) - Export, search & analyse Twitter data. Ruby, Rails, React.JS, Terraform, AWS.
  1. [Factorial](https://factorialhr.com/) - A Human Resources management platform for SMEs 
  1. [Feeld](https://feeld.co/) - Dating app for couples and singles.  
  1. [Findify](https://findify.io/) - E-commerce search powered by machine learning and big data. Team distributed across Europe.
  1. [General Assembly](https://generalassemb.ly/careers) - Physical and on-line education for technology, business, and design.
  1. [Ghost](https://ghost.org/about/#careers) - Publishing platform.
  1. [Giant Swarm](https://www.giantswarm.io/) - Giant Swarm’s managed microservices infrastructure enables enterprises to run agile, resilient, distributed systems at scale, while removing the tasks related to managing the complex underlying infrastructure
  1. [Gigster](https://gigster.com/) - vetted network of top 5% freelancers worldwide. PM, Dev, Sales positions available.
  1. [TestGrid](https://testgrid.io/) - TestGrid is a leading provider of end-to-end automation cloud and on-premise testing solutions. With a focus on simplifying the testing process, TestGrid's innovative AI-powered technology allows organizations to streamline their end to end testing process. Hiring developers, sales & marketing folks worldwide.
  1. [HeadSpin](https://www.headspin.io/) - world’s first Digital Experience AI Platform that combines cloud-hosted and on-prem global device infrastructure, test automation, and ML-driven performance & quality of experience analytics for mobile, web, audio, and video.
  1. [Gitbook](https://gitbook.gitbook.io/join-gitbook) - Publishing toolchain based on git. JavaScript, node.js, Go.
  1. [GitHub](https://www.github.careers/careers-home)
  1. [GitLab](https://about.gitlab.com/jobs/) - Competitor to GitHub.
  1. [Gitee](https://gitee.com) - GitHub alternative in China.
  1. [Gradle](https://gradle.com/careers/) - Open Source Build Tool ; Enterprise SaaS and on-premise. Fully remote. Java, Groovy, Kotlin.
  1. [GrooveHQ](https://www.groovehq.com/about) - Help desk software.
  1. [GoGuardian](https://www.goguardian.com/careers) - K-12 digital learning environments.
  1. [Harvest](https://www.getharvest.com/careers) - Time tracking software.
  1. [HashiCorp](https://www.hashicorp.com/careers) - Open source tools for automating the modern data center. Go, Ruby, Rails, Ember, JavaScript.
  1. [Hatica](https://www.hatica.io) - Work analytics for engineering teams: Hatica equips engineering leaders and managers with actionable insights to promote effort alignment, accelerate delivery, drive team engagement, and promote team well-being.
  1. [Heap](https://www.heap.io/careers/jobs) – Web & Mobile Analytics, 2 of our 8 teammates are remote.
  1. [Heetch](https://www.heetch.com/jobs) – Ride Hailing service, operating in Europe and Africa. Fully Remote across Europe or similar timezones. Go, AWS.
  1. [Help Scout](https://www.helpscout.com/company/careers/) - A help desk for teams that insist on a delightful customer experience.
  1. [Heroku](https://www.heroku.com/careers) - PaaS Cloud, makes devs' experience awesome, Ruby, Erlang, JavaScript, Golang, Python.
  1. [Honeybadger](https://www.honeybadger.io/) - Ruby. 100% remote.
  1. [Hotjar](https://www.hotjar.com/careers/) - Analytics & Feedback tool.
  1. [Hubstaff](https://hubstaff.com/jobs) - Time tracking solution with multiple integrations.
  1. [Igalia](https://www.igalia.com/about/) - Open source consultancy. HQ in Spain.
  1. [Incsub](https://incsub.com/careers/) - Remote team that builds WordPress projects.
  1. [Inpsyde GmbH](https://syde.com/) - WordPress Agency in Germany.
  1. [Institute for Nonprofit News](https://inn.users.membersuite.com/community/career-center/browse-jobs/allJobs/allCities/allStates) - Nonprofit news organization.
  1. [Instructure](https://www.instructure.com/about/careers) - We make software that makes people smarter.
  1. [Intellum](https://www.intellum.com/) - We build employee collaboration, performance and learning tools. Ruby, iOS, Android, AWS, GCS.
  1. [Intevity](https://www.intevity.com/)
  1. [Intuition Machines, Inc.](https://apply.workable.com/imachines/) - Intuition Machines specializes in deep learning and visual domain ML at scale. Python, JavaScript, Kubernetes, Kafka, Dask/Spark, ML/Computer Vision
  1. [InVision](https://www.invisionapp.com/company#jobs) - prototyping, collaboration & workflow platform.
  1. [Iterative](https://iterative.notion.site/Iterative-ai-is-Hiring-852cb978129645e1906e2c9a878a4d22) - ML Model Development for teams. Remotely worldwide
  1. [iRonin.IT](https://careers.ironin.it) - software house. Polish language. Ruby on Rails, Node.js, JavaScript, React, Angular, Vue.js.
  1. [Isos Technology](https://careers.isostech.com/) - premier Atlassian Platinum & Enterprise Solution Partner, helping organizations solve complex development and business problems with the Atlassian tools.
  1. [Jackson River](https://www.jacksonriver.com/about) - Digital-first technology and strategy for nonprofits.
  1. [Jibble Group](https://careers.jibblegroup.com/) - Remote team across 15 different countries building the next world-class workforce management and payroll Software-as-a-Service.
  1. [journy.io](https://www.journy.io/about-us) - Customer Data Platform.
  1. [Judge.me](https://judge.me/) - A review platform for ecommerces. Our company is fully remote across 4 continents.
  1. [Keepsafe](https://www.getkeepsafe.com) - Mobile-first privacy products, making privacy easy for the world to opt into.
  1. [Khan Academy](https://www.khanacademy.org/careers) - EdTech. Non-profit focusing on K-12 STEM. Less, React, Flux, Backbone, jQuery, Python, Google App Engine, Swift, and Objective-C.
  1. [Knack](https://www.knack.com/careers/) - The easy online database helping customers streamline their business processes and automate workflow. The product is DIY with no-code/low-code. The company is 100% remote.
  1. [LaunchPotato](https://launchpotato.com/careers) - Startup studio based in Delray Beach, Florida.
  1. [Librato](https://jobs.solarwinds.com/) - Cloud Monitoring.
  1. [Linaro](https://www.linaro.org/careers/) - OpenSource Engineering on ARM.
  1. [Lincoln Loop](https://lincolnloop.com) - WebDev shop.
  1. [LiveChat](https://www.livechat.com/careers/) - online customer service software with online chat, help desk software, and web analytics
  1. [LivingSocial](https://www.grouponcareers.com/) - Company-wide support for teams of experienced, remote developers. Lots of autonomy.
  1. [Logit.io](https://logit.io/about-us/#careers) - Fully remote first logging and metrics management company with 100% of operations and development based remotely
  1. [Lullabot](https://www.lullabot.com/jobs) - Strategy, design and development using Drupal.
  1. [madewithlove](https://madewithlove.com/careers/) - We help companies build digital products and bring new juice to teams that seem to jam.
  1. [Maintainer Mountaineer](https://maintainer.io) - Open source community management as a service.
  1. [MailerLite](https://www.mailerlite.com/) - Email marketing tool with a remote-first team that's scattered all over the world. Twice a year, they go on workation to places like Bali, Panama and Miami.
  1. [MariaDB](https://mariadb.com/about-us/careers/) - Open source database.
  1. [MarsBased](https://marsbased.com) - MarsBased is a development consultancy from Barcelona offering end‑to‑end web & mobile apps based on Ruby on Rails, Angular and other JavaScript frameworks.
  1. [Mapbox](https://www.mapbox.com/careers) - Map integration tools for various platforms.
  1. [MeetEdgar](https://meetedgar.com/careers) - Automated social sharing. US remote.
  1. [Meta](https://www.metacareers.com/jobs/) - Partent company of Facebook, Instagram. Filter by remote.
  1. [Merico](https://www.devinsight.ai/) - Code deep analysis engine.
  1. [Mixmax](https://www.mixmax.com/) - Email with superpowers.
  1. [Modern Tribe](https://tri.be/careers/ ) - A digital agency with a modern twist. All freelancers. All experts.
  1. [MODLR](https://modlr.co/au/home) - MODLR is business modelling and collaborative planning tool for connected financial planning process
  1. [Modus Create](https://moduscreate.com/) - Modus is a digital design-build agency driven by world-class talent. PHP, JavaScript.
  1. [Mode Analytic](https://www.thoughtspot.com/careers) - BI.
  1. [Mosalingua](https://www.mosalingua.com/en/jobs/) - Learn words, enjoy the world.
  1. [Mozilla](https://www.mozilla.org/en-US/careers/listings/) - Firefox has a 'Remote' option under it's location searchbar
  1. [NearForm](https://www.nearform.com/careers/) - NearForm evolves enterprises by building high-performance, open software. Our global team uses modern processes and tools to help clients innovate at speed.
  1. [Netlandish](https://www.netlandish.com/) - Software development for businesses of all sizes. Python, Django, DevOps. 100% Remote.
  1. [Netsparker](https://www.invicti.com/careers/) - Web Application Security Scanner.
  1. [NinjaCat](https://www.ninjacat.io/company/about-us) - Reporting, Monitoring & Call Tracking Platform for Leading Digital Agencies.
  1. [Niteo](https://niteo.co/careers) - A decade old SaaS studio full of bright ideas, building smart solutions to empower small businesses online.
  1. [NodeSource](https://nodesource.com/about) - NodeSource is dedicated to creating a sustainable ecosystem for Node.js.
  1. [Nozbe](https://nozbe.com/careers) - GTD app for Mac, Windows, Linux, Android, iPad and iPhone.
  1. [Neon Postgres Database](https://neon.tech/careers) - Neon is a distributed fully remote team building open-source, cloud-native Postgres and Neon is an open-source alternative to AWS Aurora or Google's Cloud SQL for Postgres.
  1. [Olark](https://www.olark.com/jobs) - Chat support funnel.
  1. [onTheGo Systems](https://onthegosystems.com:443/jobs/) - WordPress Developer, Supporter and Marketing Jobs.
  1. [OpenCraft](https://opencraft.com/) - Open edX development (Free Software MOOC project).
  1. [Parknav](https://parknav.com) - Intelligent parking using AI
  1. [Parsely](https://www.parse.ly/careers/) - Analytics solutions
  1. [Particular Software (NServiceBus)](https://particular.net/careers) - Enterprise Service Bus, Messaging, C#, Open Source
  1. [Patients Know Best](https://apply.workable.com/patients/) - Empowering patients to manage their care, enabling professionals to share information while improving efficiencies for payers.
  1. [Paylocity](https://www.paylocity.com/careers/) - HR and payroll solutions
  1. [Pilot](https://plane.com) - Pilot is a software platform that removes all the pain from contract work. We find work, negotiate contracts, send invoices and chase payments for hundreds of forward-looking engineers and designers around the world.
  1. [Pleo](https://www.pleo.io/en/careers) - Pleo is a company payment card solution that automates expense reports and simplifies company spending.
  1. [Precision Nutrition](https://www.precisionnutrition.com/) -  Online Nutrition Coaching and Certification.
  1. [PreviousNext](https://www.previousnext.com.au) - Australian based Drupal agency.
  1. [Prezly](https://www.prezly.com/) - SaaS PR platform. PHP, React, JS, Postgres. 100% remote.
  1. [Prodperfect](https://prodperfect.com/) - Automated QA testing from live user data. Remote-first org with workplaces in Boston and San Fran.
  1. [ProFinda](https://www.profinda.com/) - Workforce planning & optimization. 100% remote dev team. Ruby on Rails, React.js and Python. Company based in UK.
  1. [Prosopo](https://prosopo.io/) - Bot protection & web security company. Fully remote team based in UK. Typescript, Rust, Open Source.  
  1. [RainforestQA](https://jobs.lever.co/rainforest) - On demand QA as a service.
  1. [RebelMouse](https://www.rebelmouse.com/st/blog) - Social publishing platform. Python, JS & iOS/Android developers. All over the world team.
  1. [Recurly](https://recurly.com/careers/) - recurring billing management for subscription-based businesses
  1. [Red Hat](https://www.redhat.com/en/jobs)
  1. [Redox](https://redoxengine.com/company/careers/) - Healthcare API platform. Proudly remote-first team.
  1. [Relevant Bits](https://relevantbits.com) - Relevant Bits positively influences customer experiences and outcomes with data, design, technology, and critical thinking. Based out of Ontario Canada, Relevant Bits is 100% remote.
  1. [RenoFi](https://www.renofi.com/careers/) - 100% remote from day 1. Ruby, React.js, GraphQL, k8s.
  1. [Riak](https://riak.com/careers/) - An open source platform and k/v database. We code in Erlang and hang out on clouds. Everyone works remote and gets together a few times a year at HQ in Seattle.
  1. [RightScale](https://www.flexera.com/about-us/careers)
  1. [Sangoma](https://sangoma.com/) - Trusted leader in delivering globally scalable Voice-Over-IP telephony systems, both on-site and cloud-based. C, PHP, Python, JavaScript, Linux, FreePBX, VoIP.
  1. [SearchApi](https://www.searchapi.io/) - Real-time API to access structured search results of Google, Bing, Baidu, Amazon, Youtube, and other search engines. Ruby, Rails, Hotwire, TailwindCSS, PostgreSQL, Redis, Sidekiq, Terraform.
  1. [Sketch](https://www.sketch.com/about-us/#careers-at-sketch) - design tool for Mac.
  1. [SerpApi](https://serpapi.com/team) - Real-time API to access structured search results of Google, Youtube, eBay and other search engines. Ruby, Rails, React.js.
  1. [ServiceNow](https://www.jobvite.com/support/job-seeker-support/?invalid=1) - Enterprise cloud computing to improve service levels, energize employees, and change the way your enterprise works. Work at lightspeed.
  1. [ShakaCode](https://www.shakacode.com/career/) - A global web development software consultancy and product company.
  1. [Shiphero](https://shiphero.breezy.hr/?&remote=remote#positions) - ShipHero builds a fully featured Warehouse Management System. 100% remote. 
  1. [Shogun](https://getshogun.com/) - Build and optimize eCommerce landing pages. Ruby / Rails, Go, JavaScript, React. 100% remote.
  1. [Signal](https://signal.org/workworkwork/) - These people make the fantastic Signal app. US Only.
  1. [Skyscrapers](https://skyscrapers.eu/join-us/) - Cloud hosting services & management. Working with multiple cloud providers (AWS, Digital Ocean, Linode, ...). 100% remote.
  1. [SoftwareMill](https://softwaremill.com/join-us/)
  1. [Soshace](https://soshace.com/) - Angular/React/Vue.js/Java/Python remote development company
  1. [Songspace](https://songspace.com) Helps music creators collaborate, catalog, and share work with their professional team
  1. [Sourcegraph](https://github.com/sourcegraph/careers) - Code search and navigation for teams (self-hosted, OSS). Fully remote (across time zones).
  1. [Spreaker](https://careers.spreaker.com/opportunities/) Create, host, distribute and monetize your podcasts. All engineers are remote. Tech stack: Javascript (React, Node.js), PHP (Symfony), iOS, Android. All hosted on AWS..
  1. [StackExchange](https://stackoverflow.co/company/work-here/)
  1. [Stream Native](https://streamnative.io) Cloud-Native messaging and event streaming powered by Apache Pulsar
  1. [Stripe](https://stripe.com/blog/remote-hub) Stripe builds financial tools and economic infrastructure for the internet
  1. [StyleSeat](http://static.styleseat.com/jobs/index.html) - we love high-impact remote engineers, collaboration, creativity, python, angularjs
  1. [SuperOrbital](https://superorbital.io/) - Kubernetes engineering and training.
  1. [Surevine](https://surevine.com/careers)
  1. [Surge](https://catalyte.wd1.myworkdayjobs.com/catalyte) - 100% remote consulting company working primarily in Node.JS, iOS, .NET, PHP, and Android
  1. [Square](https://block.xyz/careers/jobs?businessUnits[]=square) - Square helps millions of sellers run their business-from secure credit card processing to point of sale solutions. Products: Square and Cash App.
  1. [Svix](https://www.svix.com/careers/) - Open source and hosted webhook service so you can launch webhooks in days, not months.
  1. [Sysdig Cloud](https://sysdig.com/careers/open-positions/)
  1. [Taskade](https://www.taskade.com/contact) - Remote team building real-time collaboration & collaborative editing for teams.
  1. [TaxJar](https://www.taxjar.com) - Eliminate sales tax headaches.
  1. [Teamed.io](https://www.teamed.io/)
  1. [TeamSnap](https://www.teamsnap.com/company/careers) - TeamSnap is the No. 1 online sports team management software. 80% remote employees
  1. [TED](https://www.ted.com/about/our-organization/jobs-at-ted) - Technology team supports ted.com and internal tools. All engineers are remote. Ruby on Rails, JavaScript, Ember.js
  1. [Tesera](https://www.tesera.com/) - We disrupt conventional thinking to expand what is possible. We ignite change in the future we share.
  1. [The Grid](https://thegrid.io/) - AI website builder. 100% distributed team.
  1. [Thermeon](https://thermeon.com/vacancies/) - Car rental software - 100% remote technical team
  1. [Thorn](https://thorn.org/careers) - 100% remote company, building technology to fight child sexual abuse & trafficking online.
  1. [TimeDoctor](https://www.timedoctor.com/about) - Time tracking with screenshots, web and app usage monitoring, and integrations.
  1. [Toggl](https://toggl.com/jobs/)
  1. [Toptal](https://www.toptal.com/careers) - 100% remote development company, solving worldwide talent shortage
  1. [Tortuga Backpacks](https://www.tortugabackpacks.com/pages/careers) - Backpacks for city travel.
  1. [Transloadit](https://transloadit.com/jobs/) - The world's most versatile file uploading & encoding service, since 2009, by devs for devs
  1. [Trello](https://trello.com/jobs)
  1. [TRM labs](https://www.trmlabs.com/careers)
  1. [Truelogic](https://www.truelogic.io/careers) - Outsourcing company focused on Latin America talent for US companies
  1. [Tyk](https://tyk.io/current-vacancies/) - API Gateway and API Management. Built with Go, open source.
  1. [Vidalingua](https://www.vidalingua.com/amaze.php) - Bringing language apps to life.
  1. [WAAT](https://waat.eu/job/) - A cross-functional digital agency that adapts to project needs.
  1. [Water Lily Pond](https://waterlilypond.co.uk/) - Advertising and marketing communication services.
  1. [wemake.services](https://wemake.services/meta/) - We sell repeatable software development process. Fully remote. Python, JavaScript, Vue
  1. [Wheel](https://www.wheel.com/careers) - healthcare startup.
  1. [Wikimedia](https://wikimediafoundation.org/about/jobs/)
  1. [You Need a Budget](https://www.ynab.com/careers) - Bank syncing and goals and debt management.
  1. [Quora](https://www.careers.quora.com/) - Q&A site.
  1. [Zamphyr](https://zamphyr.com/) - School 2.0 for learning computer science. Remote-first, 100% JavaScript mostly Meteor.
  1. [Zapier](https://zapier.com/about)
  1. [ZipRecruiter](https://www.ziprecruiter.com/careers) - Perl/Catalyst shop that has some of the best Perl devs working remotely.

## Q&A
  1. Quora: [Telecommuting and Working Remotely](https://www.quora.com/topic/Telecommuting-and-Working-Remotely) / [Virtual Workplace](https://www.quora.com/topic/Virtual-Workplace) / [Working at Home](https://www.quora.com/topic/Working-at-Home)
  1. Remote.co: [Q&A's with 90+ Remote Companies](https://remote.co/qa-leading-remote-companies/)
  1. StackExchange
    - Workplace: [telecommute](https://workplace.stackexchange.com/questions/tagged/telecommute?sort=votes)
    - Freelancing: [remote](https://freelancing.stackexchange.com/questions/tagged/remote?sort=votes) / [working from home](https://freelancing.stackexchange.com/questions/tagged/working-from-home?sort=votes)

## Communities
  1. [/r/telecommuting](https://www.reddit.com/r/telecommuting/?rdt=54904) - Subreddit.
  1. [##remotes](https://github.com/remotesclub/remotes) - IRC channel 
  1. [Hacker Paradise](https://www.hackerparadise.org/) - Traveling remote workers.
  1. [Remote Year](https://www.remoteyear.com/) - Traveling techies for 1 year.
  1. [Remote Indian](https://remoteindian.com/) - Remote workers from India.
  1. [Eleduck](https://eleduck.com) - A remote worker community in China(来自中国的远程工作社区).
  1. [Invide](https://www.invidelabs.com/developer.html) - Invite-only community of experienced remote developers since 2016. Also has a [public discord community](https://discord.com/invite/92q23kCad2) for newbies.

## Conferences
  1. [9punto5](https://9punto5.cl/) - Remote work conference in Latin America.
  1. [Git Commit Show](https://gitcommit.show/) - Global Developer Conference to promote remote work an education, attend from anywhwere

## Tools

#### HR
  1. [Remoteteam.com](https://gusto.com) – Automated payrolls, time off, HR tools, and compliance for remote companies.

#### Communication
  1. [Codeshare.io](https://codeshare.io/) – Browser-based multi-user live code sharing with optional video chat.
  1. [Fleep](https://fleep.io/) - Internal chat and collaboration tool for development teams
  1. [Floobits](https://floobits.com) - Remote pair programming with screen share. Integrates with Sublime, IntelliJ, Atom and others
  1. [Gather](https://www.gather.town/) - Gather is a video-calling space that lets multiple people hold separate conversations in parallel, walking in and out of those conversations just as easily as they would in real life.
  1. [IRCCloud](https://www.irccloud.com) – Browser-based IRC client with permanent storage.
  1. [Jitsi](https://jitsi.org) - Multi-platform open-source video conferencing
  1. [Matrix](https://github.com/ResultadosDigitais/matrix) – Matrix is the online open-source workplace for distributed teams.
  1. [Mumble](https://www.mumble.info/documentation/) Mumble is an open source voice chat software
  1. [Precursor](https://precursorapp.com) - Simple prototyping & brainstorming web app with real-time collaboration.
  1. [PukkaTeam](https://pukkateam.com/) - Real team presence through regular automated selfies and one-click video calling
  1. [Rocket.Chat](https://www.rocket.chat/) — The Ultimate Open Source WebChat Platform.
  2. [Signal](https://signal.org/) - Encrypted, secure chat and video calls.
  1. [Skype](https://www.skype.com/) – Video calls.
  1. [Slack](https://slack.com/) – Text, voice, and video chat system with loads of integration options including [Huddles](https://slack.com/features/huddles), a real-time, HD screen sharing system for collaboration in teams
  1. [Talky](https://talky.io/) — Truly simple video chat and screen sharing for groups
  1. [TeamHub](https://git.live/) — Realtime status and progress reporting directly inside your IDE
  1. [Tips for immersive video calls](https://www.benkuhn.net/vc/) —     Tips for immersive video calls
  1. [Twist](https://twist.com/) — A communications platform where long-form discussions and casual messaging live in harmony.
  1. [Whereby](https://whereby.com) – Browser-based, plugin-less group video calls.
  1. [Zoom](https://www.zoom.com) — High-quality group video and sharing screen, run on linux, record session and support telephone calls.
  1. [Krisp](https://krisp.ai/) - Mute background noise in any communication app.
  1. [flat.social](https://flat.social/) - Create fun virtual spaces for online meetings, team activities and virtual socials.

#### Project Management
  1. [Asana](https://asana.com/) - Project management good for distributed teams.
  1. [ClickUp](https://clickup.com/) - All-in-one productivity platform that brings teams, tasks, and tools together in one place.
  1. [Harvest](https://www.getharvest.com/) - Time tracking
  1. [Hitask](https://hitask.com/) - Easy task and project management for teams.
  1. [Jira](https://www.atlassian.com/software/jira) - Issue and project tracking tool.
  1. [Notion](https://www.notion.so/) - All in one workspace to write, plan, collaborate, and get organized.
  1. [Outplanr](https://www.outplanr.com/) - Project and task management tool.
  1. [Pinitto.me](https://pinitto.me) - Lightweight realtime infinite virtual corkboard application (open source).
  1. [Shortcut](https://www.shortcut.com/) (fka Clubhouse) - Project management for software development teams.
  1. [Taskade](https://www.taskade.com/) - Real-time collaborative notes, checklists and outlines for teams.
  1. [Trello](https://trello.com/) - Lean project boards.
  1. [gantt-online](https://gantt-online.com/) - Gantt Chart Project Management Tool.

#### Others
  1. [Coffitivity](https://coffitivity.com/) - Coffitivity recreates the ambient sounds of a cafe to boost your creativity and help you work better.
  1. [Fiverr](https://www.fiverr.com/) - Fiverr is the world's largest freelance services marketplace for lean entrepreneurs, where you can hire remote workers to do small tasks for you.
  1. [EasyRetro](https://easyretro.io) - EasyRetro is a retrospective online board for distributed teams.
  1. [Listen to Wikipedia (Hatnote)](http://listen.hatnote.com) - Listen to the sound of Wikipedia's recent changes feed.
  1. [Noisli](https://www.noisli.com/) - Noisli has a list of diferent ambient sounds that can be combined to boost creativity and focus.
  1. [musicforprogramming.net](https://musicforprogramming.net/) - `return 'A series of mixes intended for listening while '+task+' to aid concentration and increase productivity (also compatible with other activities).';`
  1. [Qbserve](https://qotoqot.com/qbserve/) - Time tracking automation: freelance project tracking, timesheets, invoicing & real-time productivity feedback (Mac).
  1. [Miro](https://miro.com) (fka Realtime Board) - Distributed permanent virtual whiteboard.
  1. [Timing](https://timingapp.com/?lang=en) - Automatic time and productivity tracking for Mac. Helps you stay on track with your work (especially important when working remotely). Also ensures that no billable hours get lost if you are billing hourly (Mac).

## Law & Finance
  1. [1099 contractors](https://www.smartcapitalmind.com/what-is-a-1099-contractor.htm) – US based companies can hire remote workers as.
  1. [Transferwise](https://wise.com/gb/business/payouts) - Easy way to pay remote employees.

## Others
  1. [awesome-digital-nomads](https://github.com/cbovis/awesome-digital-nomads) - 🏝 A curated list of awesome resources for Digital Nomads.
  1. [Established Remote](https://github.com/yanirs/established-remote) - A list of established remote companies
  1. [Hacker Spaces](https://wiki.hackerspaces.org/List_of_Hacker_Spaces) - List of hacker spaces.
  1. [LiquidSpace](https://liquidspace.com/) - Daily & Hourly Office & Meeting Room Rental.
  1. [Nomad List](https://nomads.com/) - Compare cost and quality of living in different cities.
  1. [Regus USA](https://www.regus.com/en-gb) - Executive suites, virtual offices & conference room space.
  1. [Remote Companies on Careers SO](https://stackoverflow.com/jobs/companies?q=&l=&r=true)
  1. [Remote Working](https://github.com/greatghoul/remote-working) - A list of remote working resources for Chinese.
  1. [WorkFrom](https://workfrom.co/) - Find coffee shops that are good to work from.
  2. [Websoft9](https://github.com/Websoft9/websoft9) - Open source software self-hosting platform, one-click to install 200+ application includes remote tools like Jiti Meet, Rocket.chat, GitLab, Mattermost.

## License

[![CC0](https://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Lukasz Madon](https://github.com/lukasz-madon) has waived all copyright and related or neighboring rights to this work.
