<div class="github-widget" data-repo="enaqx/awesome-react"></div>
## Awesome React [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

A collection of awesome things regarding the React ecosystem.


### React

#### React General Resources

- [React Official Website](https://react.dev/)
- [React GitHub](https://github.com/facebook/react)
- [Reactiflux Discord Channel](http://www.reactiflux.com/)
- [React Community](https://react.dev/community)
- [React Conferences](https://react.dev/community/conferences)
- [React CodeSandbox Playground](https://codesandbox.io/s/new)

#### React Tutorials

- [React Official Tutorial](https://react.dev/learn)
- [Using React in Visual Studio Code](https://code.visualstudio.com/docs/nodejs/reactjs-tutorial)
- [React Interview Questions & Answers](https://github.com/sudheerj/reactjs-interview-questions)
- [Design patterns and Component patterns for building powerful Web Apps](https://www.patterns.dev/)
- [A simple, scalable, and powerful architecture for building production ready React applications](https://github.com/alan2207/bulletproof-react)
- [Cheatsheets for experienced React developers getting started with TypeScript](https://github.com/typescript-cheatsheets/react-typescript-cheatsheet)
- [The Fullstack Tutorial for GraphQL](https://github.com/howtographql/howtographql)

#### React Frameworks

- [next](https://github.com/vercel/next.js) - The React Framework
- [remix](https://github.com/remix-run/remix) - Full stack web Framework that lets you focus on the user interface
- [gatsby](https://github.com/gatsbyjs/gatsby) - Build modern websites with React
- [react-admin](https://github.com/marmelab/react-admin) - A frontend Framework for building B2B applications
- [refine](https://github.com/refinedev/refine) - Build your React-based CRUD applications, without constraints

#### React Component Libraries

- [material-ui](https://github.com/mui/material-ui) - Ready-to-use foundational React components
- [ant-design](https://github.com/ant-design/ant-design) - An enterprise-class UI design language and React UI library
- [shadcn-ui](https://github.com/shadcn-ui/ui) - Beautifully designed components built using Radix UI and Tailwind CSS
- [react-bootstrap](https://github.com/react-bootstrap/react-bootstrap) - Bootstrap components built with React
- [fluentui](https://github.com/microsoft/fluentui) - Microsoft's Fluent UI
- [framework7](https://github.com/framework7io/framework7) - Full featured HTML framework for building iOS & Android apps
- [ariakit](https://github.com/ariakit/ariakit) - Toolkit for building accessible web apps with React
- [mantine](https://github.com/mantinedev/mantine) - Fully featured React components library
- [react-email](https://github.com/resend/react-email) - Unstyled components for creating beautiful emails

#### React State Management and Data Fetching

- [redux](https://github.com/reduxjs/redux) - Predictable State Container for JavaScript Apps
- [mobx](https://github.com/mobxjs/mobx) - Simple, scalable state management
- [zustand](https://github.com/pmndrs/zustand) - Bear necessities for state management in React
- [tanstack-query](https://github.com/TanStack/query) - Powerful asynchronous state management
- [swr](https://github.com/vercel/swr) - React Hooks for Data Fetching
- [apollo-client](https://github.com/apollographql/apollo-client) - A fully-featured, production ready caching GraphQL client
- [relay](https://github.com/facebook/relay) - A framework for building data-driven React applications
- [jotai](https://github.com/pmndrs/jotai) - Primitive and flexible state management for React
- [xstate](https://github.com/statelyai/xstate) - State machines and statecharts for the modern web
- [effector](https://github.com/zerobias/effector) - Business logic with ease
- [immer](https://github.com/immerjs/immer) - Create the next immutable state by mutating the current one
- [immutable-js](https://github.com/immutable-js/immutable-js) - Immutable persistent data collections for Javascript
- [rxdb](https://github.com/pubkey/rxdb) - A fast, offline-first, reactive database for JavaScript Applications

#### React Styling

- [styled-components](https://github.com/styled-components/styled-components) - Visual primitives for the component age
- [emotion](https://github.com/emotion-js/emotion) - CSS-in-JS library designed for high performance style composition
- [vanilla-extract](https://github.com/seek-oss/vanilla-extract) - Zero-runtime Stylesheets-in-TypeScript

#### React Routing

- [react-router](https://github.com/remix-run/react-router) - Declarative routing for React
- [wouter](https://github.com/molefrog/wouter) - A minimalist-friendly routing
- [tanstack-router](https://github.com/TanStack/router) - Type-safe router with built-in caching & URL state management

#### React Development Tools

- [create-react-app](https://github.com/facebook/create-react-app) - Set up a modern Web app by running one command
- [vite](https://github.com/vitejs/vite) - Next Generation Frontend Tooling
- [parcel](https://github.com/parcel-bundler/parcel) - The zero configuration build tool for the web
- [million](https://github.com/aidenybai/million) - An extremely fast and lightweight optimizing compiler
- [reactotron](https://github.com/skellock/reactotron) - A desktop app for inspecting your React and React Native projects
- [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) - React specific linting rules for ESLint
- [why-did-you-render](https://github.com/welldone-software/why-did-you-render) - Monkey patches React to notify you about avoidable re-renders

#### React Libraries

- [preact](https://github.com/preactjs/preact) - Fast React alternative with the same modern API
- [floating-ui](https://github.com/floating-ui/floating-ui) - Toolkit to create floating elements
- [loadable-components](https://github.com/gregberge/loadable-components) - The recommended Code Splitting library for React
- [react-uploady](https://github.com/rpldy/react-uploady) - Modern file-upload components & hooks for React
- [downshift](https://github.com/downshift-js/downshift) - React autocomplete, combobox or select dropdown components
- [react-error-boundary](https://github.com/bvaughn/react-error-boundary) - A React error boundary component that lets you catch errors

#### React Testing

- [jest](https://github.com/facebook/jest) - Delightful JavaScript Testing
- [react-testing-library](https://github.com/testing-library/react-testing-library) - Simple and complete React DOM testing utilities
- [cypress](https://github.com/cypress-io/cypress) - Fast, easy and reliable testing for anything that runs in a browser

#### React Awesome Components

- [Awesome React Components](https://github.com/brillout/awesome-react-components)
- [react-select](https://github.com/JedWatson/react-select) - The Select Component for React
- [react-big-calendar](https://github.com/jquense/react-big-calendar) - Calendar component
- [react-datepicker](https://github.com/Hacker0x01/react-datepicker/) - A simple and reusable datepicker component for React
- [react-loading-skeleton](https://github.com/dvtng/react-loading-skeleton) - Create skeleton screens that automatically adapt to your app
- [react-qrcode](https://github.com/zpao/qrcode.react) - QR component for use with React
- [react-archer](https://github.com/pierpo/react-archer) - Draw arrows between React elements
- [react-icons](https://github.com/react-icons/react-icons) - SVG React icons of popular icon packs
- [react-complex-tree](https://github.com/lukasbach/react-complex-tree) - Unopinionated Accessible Tree
- [react-insta-stories](https://github.com/mohitk05/react-insta-stories) - A React component for Instagram like stories
- [swiper](https://github.com/nolimits4web/swiper) - Most modern mobile touch slider
- [keen-slider](https://github.com/rcbyr/keen-slider) - The Touch slider carousel
- [cookie-consent-banner](https://github.com/porscheofficial/cookie-consent-banner) – The lightweight and flexible Cookie Consent Banner
- [heart-switch](https://github.com/anatoliygatt/heart-switch) - A heart-shaped toggle switch component for React
- [kbar](https://github.com/timc1/kbar) - Fast, portable, and extensible cmd+k interface for your site
- [tagify](https://github.com/yairEO/tagify) - Lightweight, efficient Tags input component
- [puck](https://github.com/measuredco/puck) - The visual editor for React

#### React Components Sandboxes

- [storybook](https://github.com/storybookjs/storybook) - Storybook is a frontend workshop for building UI components and pages in isolation
- [react-styleguidist](https://github.com/styleguidist/react-styleguidist) - Isolated React component development environment with a living style guide
- [react-cosmos](https://github.com/react-cosmos/react-cosmos) - Dev tool for creating reusable React components
- [bit](https://github.com/teambit/bit) - A build system for development of composable software

#### React Forms

- [react-hook-form](https://github.com/react-hook-form/react-hook-form) - React Hooks for form state management and validation
- [formik](https://github.com/jaredpalmer/formik) - Build forms in React, without the tears
- [react-jsonschema-form](https://github.com/mozilla-services/react-jsonschema-form) - A React component for building Web forms from JSON Schema
- [formily](https://github.com/alibaba/formily) - Alibaba Group Unified Form Solution
- [vest](https://github.com/ealush/vest) - Declarative validations framework

#### React Tables and Grids

- [react-grid-layout](https://github.com/react-grid-layout/react-grid-layout) - A draggable and resizable grid layout with responsive breakpoints
- [tanstack-table](https://github.com/TanStack/table) - Headless UI for building powerful tables & datagrids
- [react-data-grid](https://github.com/adazzle/react-data-grid) - Feature-rich and customizable data grid React component

#### React Maps

- [react-map-gl](https://github.com/visgl/react-map-gl) - React friendly API wrapper around MapboxGL JS
- [react-leaflet](https://github.com/PaulLeCam/react-leaflet) - React components for Leaflet maps

#### React Charts

- [recharts](https://github.com/recharts/recharts) - Redefined chart library built with React and D3
- [visx](https://github.com/airbnb/visx) - Visualization components
- [victory](https://github.com/FormidableLabs/victory) - A collection of composable React components for building interactive data visualizations
- [react-vis](https://github.com/uber/react-vis) - Data Visualization Components
- [nivo](https://github.com/plouc/nivo) - Provides a rich set of data visualization components built on top of the D3 and React libraries
- [xyflow](https://github.com/xyflow/xyflow) - A customizable React component for building node-based editors and interactive diagrams

#### React Renderers

- [react-three-fiber](https://github.com/pmndrs/react-three-fiber) - A React renderer for Three.js
- [ink](https://github.com/vadimdemedes/ink) - React for interactive command-line apps
- [remotion](https://github.com/remotion-dev/remotion) - Make videos programmatically with React
- [react-pdf](https://github.com/diegomura/react-pdf) - Create PDF files using React
- [react-figma](https://github.com/react-figma/react-figma) - A React renderer for Figma

#### React Internationalization

- [formatjs](https://github.com/formatjs/formatjs) - Internationalize your web apps
- [react-i18next](https://github.com/i18next/react-i18next) - Internationalization for React done right

#### React Graphics and Animations

- [react-spring](https://github.com/pmndrs/react-spring) - A spring physics based React animation library
- [framer-motion](https://github.com/framer/motion) - Open source, production-ready animation and gesture library for React
- [auto-animate](https://github.com/formkit/auto-animate) - A zero-config, drop-in animation utility that adds smooth transitions
- [react-tsparticles](https://github.com/matteobruni/tsparticles) - Easily create highly customizable particles effects
- [react-parallax-tilt](https://github.com/mkosir/react-parallax-tilt) - Easily apply tilt hover effect on React components
- [simple-parallax-js](https://github.com/geosigno/simpleParallax.js) - The easiest way to get a parallax effect with React and JavaScript

#### React Integration

- [rescript-compiler](https://github.com/rescript-lang/rescript-compiler) - A robustly typed language that compiles to efficient and human-readable JavaScript
- [react-rails](https://github.com/reactjs/react-rails) - Integrate React with Rails
- [fulcro](https://github.com/fulcrologic/fulcro) - A library for development of web applications in clj/cljs
- [tailwind-react](https://tw-elements.com/docs/standard/integrations/react-integration/) - Article that shows you how to integrate React application with Tailwind

#### React Real Apps

- [mattermost-server](https://github.com/mattermost/mattermost-server) - An open source platform for secure collaboration
- [kibana](https://github.com/elastic/kibana) - Your window into the Elastic Stack
- [webamp](https://github.com/captbaritone/webamp) - Winamp 2 reimplemented for the browser
- [overreacted](https://github.com/gaearon/overreacted.io) - Personal blog by Dan Abramov
- [wave](https://github.com/wavetermdev/waveterm) - An open-source, cross-platform terminal for seamless workflows

### React Native

#### React Native General Resources

- [React Native Official Website](https://reactnative.dev/)
- [React Native GitHub](https://github.com/facebook/react-native)
- [React Native Community](https://reactnative.dev/community/overview)
- [Expo](https://expo.dev/)
- [Expo Snack Playground](https://snack.expo.dev/)

#### React Native Navigation

- [react-navigation](https://github.com/react-navigation/react-navigation) - Routing and navigation for your React Native apps

#### React Native Awesome Components

- [react-native-vector-icons](https://github.com/oblador/react-native-vector-icons) - Customizable Icons for React Native
- [react-native-gifted-chat](https://github.com/FaridSafi/react-native-gifted-chat) - The most complete chat UI for React Native

#### React Native Libraries

- [realm-js](https://github.com/realm/realm-js) - A mobile database: an alternative to SQLite & key-value stores
- [react-native-device-info](https://github.com/react-native-device-info/react-native-device-info) - Device Information for React Native iOS and Android

### Contribution

This list began as a personal compilation of interesting things related to React. When it was initiated, React was still in beta, a special script was required to convert JSX to JS, and Flux had not yet been released. Today, React has become mainstream, with numerous developments taking place. Kindly refrain from using this list as an advertisement board or a space to promote your experiments. We focus on sharing entirely free resources here. Please feel free to propose updates for outdated projects and articles, as well as new contributions. Your input and suggestions are wholeheartedly♡ appreciated. (✿◠‿◠)

[![CC0](https://i.creativecommons.org/l/by/4.0/88x31.png)](http://creativecommons.org/licenses/by/4.0/)
