<div class="github-widget" data-repo="jondot/awesome-react-native"></div>
<br/>
<br/>
<br/>

<p align="center">
    <img alt="awesome" src="https://raw.githubusercontent.com/jondot/awesome-react-native/master/arn.svg?sanitize=true" width="480" />
</p><br/>
<br/>
<br/>
Awesome React Native 是一个很棒的样式列表，它精选了最好的 React Native 库，
tools, tutorials, articles and more. PRs are welcome!

<br/>
<br/>

<p align="center">
<a href="https://bit.ly/arn-wkly">不要错过！</a> <a href="https://bit.ly/arn-wkly">订阅我们的每周时事通讯</a>
</p>
<br/>
<br/>

<img
src="https://travis-ci.org/jondot/awesome-react-native.svg?branch=master"
alt=&quot;构建状态&quot; /&gt;



## Sponsors

### _Never leave your command line for secrets_

<a href="https://raw.githubusercontent.com/spectralops/teller"><img src="https://raw.githubusercontent.com/SpectralOps/teller/raw/master/media/cover.png"/></a>

_Teller 是一个 OSS 和免费的开发人员生产力秘密管理器 [SpectralOps](https://github.com/spectralops/teller) ，支持云原生应用程序和多个云提供商. 混合搭配所有保险库和其他密钥存储，并在您编码、测试和构建应用程序时安全地使用机密. 它快速、简单、安全._

[Get Started Now!](https://github.com/spectralops/teller)




## Categories

<!-- START doctoc generated TOC please keep comment here to allow auto update -->

<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

非常感谢 [贡献者
list](https://github.com/jondot/awesome-react-native/graphs/contributors)\\:)

## Conferences

专门针对 React Native 的会议.  React 列表
大会可以在 [ReactJS
site](https://facebook.github.io/react/docs/conferences.html).

### Chain React - Portland, OR USA

<http://chainreactconf.com>

研讨会 - 2018 年 7 月 11 日\\
会议 - 2018 年 7 月 12-13 日

### React Native EU - Wroclaw, Poland

<http://react-native.eu/>

研讨会 - 2018 年 9 月 3-4 日\\
会议 - 2018 年 9 月 5-6 日

### React Alicante - Alicante, Spain

<http://reactalicante.es/>

研讨会 - 2018 年 9 月 13 日\\
会议 - 2018 年 9 月 14-15 日

### ReactNext - Tel Aviv, Israel

<https://react-next.com/>

会议 - 2018 年 11 月 4 日

### App.js Conf - Krakow, Poland

<https://appjs.co/>

会议 - 2019 年 4 月 4 日
研讨会 - 2019 年 4 月 5 日

### Chain React - Portland, OR USA

<https://infinite.red/ChainReactConf>

研讨会 - 2019 年 7 月 10 日
会议 - 2019 年 7 月 11 日至 12 日

### React Native EU - Wroclaw, Poland

<https://react-native.eu/>

研讨会 - 2019 年 9 月 4 日
Conference - September 5th-6th, 2019

### React Berlin - Berlin, Germany

<https://reactday.berlin/>

研讨会 - 2019 年 12 月 4 日至 5 日
会议 - 2019 年 12 月 6 日

### ReactEurope - Paris, France

<https://www.react-europe.org/>

会议 - 2020 年 5 月 14 日至 15 日
研讨会 - 2020 年 5 月 12 日至 13 日


## Articles

在 Web 上发布的内容.

### Reference

* [React Native Styling Cheatsheet ★2679](https://github.com/vhpoet/react-native-styling-cheat-sheet)

### Howtos

* [How to add Firebase Auth with React Native ★4](https://github.com/g6ling/React-Native-Tips/tree/master/How_to_add_Firebase_Auth_with_react_native)
* [How to get started with Cloud Firestore on React Native](https://invertase.io/blog/getting-started-with-cloud-firestore-on-react-native)
* [How to upgrade React Navigation 1.x to 2.x](https://shift.infinite.red/upgrading-from-react-navigation-v1-to-v2-312d932329ba)
* [How to use React Native Navigation v2 with Redux and Google Analytics](https://www.codingsavvy.com/2018/08/react-native-navigation-v2-with-redux.html)
* [React-Navigation Drawer](https://shift.infinite.red/react-navigation-drawer-tutorial-a802fc3ee6dc)
* [Getting Started with React Native Development on Windows](https://shift.infinite.red/getting-started-with-react-native-development-on-windows-90d85a72ae65#.lygadl38g)
* [Getting Started with React Native Development for Windows](https://shift.infinite.red/getting-started-with-react-native-development-for-windows-ba23a4be90b6#.n6vtqtikh)
* [Blueprint to becoming a React Native Developer](https://medium.com/@spencer_carli/blueprint-to-becoming-a-react-native-developer-6cad2b894887#.t3uw4j4u8)
* [How to Use the ListView Component](https://medium.com/@spencer_carli/react-native-basics-how-to-use-the-listview-component-a0ec44cf1fe8#.ur0hyi3h9)
* [How to upload photo/file in react-native](https://github.com/g6ling/React-Native-Tips/tree/master/How_to_upload_photo%2Cfile_in%20react-native)
* [Change splash screen in React Native Android app](https://android.jlelse.eu/change-splash-screen-in-react-native-android-app-d3f99ac1ebd1#.pgjimxpgg)
* [Remote Push Notifications with OneSignal](https://medium.com/differential/react-native-push-notifications-with-onesignal-9db6a7d75e1e#.d0zob0pdw)
* [Release React Native App to Android Play Store](https://shift.infinite.red/simple-react-native-android-releases-319dc5e29605)
* [React Native & Apple TV today](https://medium.com/@7ynk3r/react-native-apple-tv-today-48beb398a1ab#.5pp5drlyy)
* [Record and Upload Videos with React Native](https://medium.com/react-native-training/uploading-videos-from-react-native-c79f520b9ae1)
* [How to Setup your First React Native app](https://hackernoon.com/react-native-how-to-setup-your-first-app-a36c450a8a2f)
* [Using React Native With TypeScript](https://medium.com/@jan.hesters/using-typescript-with-react-native-946aa4b4ae6f)
* [How To Build a News Reader App with React Native and NewsAPI](https://medium.com/crowdbotics/how-to-build-a-news-reader-app-with-react-native-and-newsapi-8508f48f2b43)
* [How to Build a Real Time Logo Detection App with React Native](https://medium.com/crowdbotics/how-to-build-a-real-time-logo-detection-app-with-react-native-google-vision-api-and-crowdbotics-9ed65fbcd15)
* [Build a Chatbot with Dialogflow and React Native](https://blog.jscrambler.com/build-a-chatbot-with-dialogflow-and-react-native/)
* [How To Build Your First VR App with ViroReact and React Native](https://medium.com/crowdbotics/how-to-build-your-first-vr-app-with-viroreact-react-native-and-crowdboticsp-a376b49e1e1d)
* [React Hooks Basics— Building a React Native App with React Hooks](https://medium.com/crowdbotics/build-a-react-native-app-with-react-hooks-5498e1d5fdf6)
* [How to Build a Web App with React Native](https://heartbeat.fritz.ai/how-to-build-a-web-app-with-react-native-b93575a16a5e)
* [Building a React Native Mobile App with AWS Amplify and Expo](https://heartbeat.fritz.ai/building-a-react-native-mobile-app-with-aws-amplify-and-expo-fcab6ee0555e)
* [User Authentication with Amplify in a React Native and Expo app](https://heartbeat.fritz.ai/user-authentication-with-amplify-in-a-react-native-and-expo-app-d00cdaf1ac28)
* [How to build an Email Authentication app with Firebase, Firestore and React Native](https://heartbeat.fritz.ai/how-to-build-an-email-authentication-app-with-firebase-firestore-and-react-native-a18a8ba78574)
* [How to Gracefully Use Environment Variables in a React Native App](https://levelup.gitconnected.com/how-to-gracefully-use-environment-variables-in-a-react-native-app-7f1600446116)
* [How to build a xylophone app with Audio API, React Native, and Expo](https://heartbeat.fritz.ai/how-to-build-a-xylophone-app-with-audio-api-react-native-and-expo-7d6754a0603c)
* [How To Use WebViews in a React Native App](https://blog.jscrambler.com/how-to-use-webviews-in-a-react-native-app/)

### Assorted

* [React Native Twitter Clone](https://www.cosmicjs.com/apps/react-native-twitter-clone) - 由 Cosmic Headless CMS 提供支持的 React Native Twitter Clone. [Read about how it was built](https://www.cosmicjs.com/blog/how-to-make-a-simple-twitter-clone-with-react-native).
* [Versioning React Native Application in elegant way (cross-platformely) ★10](https://github.com/szhigunov/react-native-npm-version)
* [Best Practices for Building a Large Scale React Application](https://buttercms.com/blog/best-practices-for-building-a-large-scale-react-application)
* [React Native - Nic or Not App](https://shift.infinite.red/cage-against-the-machine-a419b6980424)
* [React and React Native State Museum](https://hackernoon.com/the-react-state-museum-a278c726315)
* [Top 15 React Native libraries that I use in my apps](https://codingislove.com/top-15-react-native-libraries/)
* [Building 3 React Native Apps in One Summer](https://medium.com/@rpastorelle/building-3-react-native-apps-in-one-summer-dcd0c31454ff)
* [React Native: Bringing modern web techniques to mobile](https://code.facebook.com/posts/1014532261909640/react-native-bringing-modern-web-techniques-to-mobile/)
* [First impressions using React Native](http://jlongster.com/First-Impressions-using-React-Native)
* [Wrapping Cocoapods for React Native](https://shift.infinite.red/beginner-s-guide-to-using-cocoapods-with-react-native-46cb4d372995#.wzp2qq1hn)
* [React Native: Initial Thoughts (opinion)](https://redalemeden.com/blog/2015/initial-thoughts-about-react-native)
* [A Dynamic Crazy Native Mobile Future Powered by Javascript](https://medium.com/@clayallsopp/a-dynamic-crazy-native-mobile-future-powered-by-javascript-70f2d56b1987)
* [ReactNative NES & More](https://moduscreate.com/blog/react-native-has-landed/)
* [React Native Installation and Setup](https://github.com/checkraiser/beginning-react-native/blob/master/1.Installation_and_setup.md)
* [Diary of Building an iOS App with React Native](http://herman.asia/building-a-flashcard-app-with-react-native)
* [Reflecting on React Native development](http://habd.as/reflecting-on-react-native-development/)
* [React-Native layout examples](http://browniefed.com/blog/2015/06/07/react-native-layout-examples/)
* [React Native in Production](https://medium.com/@clayallsopp/react-native-in-production-2b3c6e6078ad) - 来自 Clay Allsop 的笔记
* [An iOS Developer on React Native](https://medium.com/ios-os-x-development/an-ios-developer-on-react-native-1f24786c29f0)
* [React Native and WebRTC](https://webrtchacks.com/reacting-to-react-native-for-native-webrtc-apps-alexey-aylarov/)
* [How to bridge a Swift view](http://browniefed.com/blog/2015/11/28/react-native-how-to-bridge-a-swift-view/)
* [How to select the right React Native database](https://www.simform.com/react-native-database-selection-guide/)
* [Building a Native SoundCloud Android app with Redux](https://wiredcraft.com/blog/native-soundcloud-android-app/) - 讨论 Android 上的 redux、代码重用和性能.
* [React Native Twitter exploding heart](http://browniefed.com/blog/2015/11/07/react-native-how-to-create-twitter-exploding-hearts/) - 使用 Animation 和 ReactART 的硬核动画
* [Using AI to discover UI components](https://www.youtube.com/watch?v=_iiKl0BB6ho) - 有趣的图像处理/AI 辅助过程来发现和生成 React Native UI
* [Writing Android Components](https://medium.com/@sejoker/writing-android-component-for-react-native-e34802bf3377)
* [Unit Testing React Native with Mocha and Enzyme](https://formidable.com/blog/2016/02/08/unit-testing-react-native-with-mocha-and-enzyme/)
* [React Native's Layout Animation is Awesome](https://medium.com/@Jpoliachik/react-native-s-layoutanimation-is-awesome-4a4d317afd3e)
* [Avoiding the Keyboard](https://shift.infinite.red/avoiding-the-keyboard-in-react-native-56d05b9a1e81#.g1lwixck6)
* [How To Use OpenCV In React Native For Image Processing](https://brainhub.eu/blog/opencv-react-native-image-processing/)
* [Using Styled Components with React Native](https://medium.com/swlh/using-styled-components-with-react-native-de645fcf4787)
* [Create a React Native Image Recognition App with Google Vision API](https://blog.jscrambler.com/create-a-react-native-image-recognition-app-with-google-vision-api/)
* [A comprehensive guide on building offline React Native apps with AsyncStorage](https://heartbeat.fritz.ai/building-offline-react-native-apps-with-asyncstorage-dcb4b0657f93)
* [Build a Chat App with Firebase and React Native](https://blog.jscrambler.com/build-a-chat-app-with-firebase-and-react-native/)
* [Building Stylistic UIs with Emotion-JS for React Native](https://heartbeat.fritz.ai/how-to-use-emotion-js-with-react-native-fccac9c78779)
* [Getting Started with Firestore and React Native](https://blog.jscrambler.com/getting-started-with-firestore-and-react-native/)
* [React Native: Native Modules made for React developers](https://blog.photoeditorsdk.com/react-native-native-modules-made-for-react-developers-59ca93c41541) - 关于 RN 0.60+ 的 3rd 方库的开发人员体验
* [Flutter vs React Native - Choosing your approach](https://buttercms.com/blog/flutter-vs-react-native-choosing-your-approach) - 比较文章可帮助您根据您的项目和经验选择最佳方法.

### Continuous Integration

* [How to build and deploy React Native apps for iOS and Android automatically with Appcircle CI/CD](https://appcircle.io/blog/guide-to-automated-mobile-ci-cd-for-react-native-appcircle/)
* [Distributing beta builds with Fastlane on Android and iOS](https://github.com/thecodingmachine/react-native-boilerplate/blob/master/docs/beta%20builds.md)
* [Deploying a React Native App with Fastlane](https://dbanck.svbtle.com/deploying-a-react-native-app-with-fastlane)
* [Continuous Integration for React Native Apps With Fastlane and Bitrise (iOS)](http://blog.thebakery.io/continuous-integration-for-react-native-applications-with-fastlane-and-bitrise-ios-version/)
* [How to automate Android build process on Bitrise CI](https://medium.com/@hesam.kamalan/how-to-automate-android-build-process-on-bitrise-ci-71ae3a94362e#.fryuiays4)
* [fastlane for React Native iOS & Android app DevOps](https://medium.com/react-native-training/fastlane-for-react-native-ios-android-app-devops-8ca85bee614e)
* [The simplest way to automate delivery of your React Native Application](https://jtway.co/the-simplest-way-to-automate-delivery-of-your-react-native-application-f37f2c71eb1d)
* [21 Useful Open Source Packages for React Native](https://medium.com/crowdbotics/21-useful-open-source-packages-for-react-native-807f65a818a1)

### Internals

* [Performance](https://facebook.github.io/react-native/docs/performance.html#common-sources-of-performance-problems)
* [React Native Debugger Internals](https://medium.com/@shaheenghiassy/deep-diving-react-native-debugging-ea406ed3a691)
* [Dirty-up and execute top-down](http://blog.vjeux.com/2015/javascript/dirty-up-and-execute-top-down.html) - @vjeux 关于 React 对背景颜色、布局等的优化
* [Optimizing React Native](https://www.youtube.com/watch?v=0MlT74erp60)
* [Diving into React Native Performance](https://code.facebook.com/posts/895897210527114/)
* [Wait… What Happens When my React Native Application Starts? — An In-depth Look Inside React Native](https://levelup.gitconnected.com/wait-what-happens-when-my-react-native-application-starts-an-in-depth-look-inside-react-native-5f306ef3250f)

## Components

组件和本机模块.

### UI

* [lottie-react-native ★10415](https://github.com/airbnb/lottie-react-native) - 适用于 Android 和 iOS 的移动库，可解析使用 bodymovin 导出为 JSON 的 Adob​​e After Effects 动画，并在移动设备上原生呈现它们！
* [react-icomoon](https://github.com/aykutkardas/react-icomoon)  - 通过 React-Icomoon，您可以轻松地使用您在 icomoon 中选择或创建的图标. 零依赖和轻量级. 
* [react-native-vector-icons ★9985](https://github.com/oblador/react-native-vector-icons)  - React Native 的可自定义图标，支持 NavBar/TabBar、图像源和完整样式. 从 3000 多个捆绑图标中选择或使用您自己的图标.
* [react-native-maps ★8388](https://github.com/lelandrichardson/react-native-maps) - 适用于 iOS + Android 的 React Native Map 组件
* [react-native-swiper ★6955](https://github.com/leecade/react-native-swiper) - React Native 的最佳 Swiper 组件.
* [react-native-gifted-chat ★6546](https://github.com/FaridSafi/react-native-gifted-chat) - 最完整的 React Native 聊天 UI（以前称为 Gifted Messenger）
* [react-native-scrollable-tab-view ★5664](https://github.com/brentvatne/react-native-scrollable-tab-view) - 用于 React Native 的可滚动标签视图
* [react-native-image-picker ★4709](https://github.com/marcshilling/react-native-image-picker) - 一个 React Native 模块，允许您使用本机 UIImagePickerController UI 从设备库或直接从相机中选择照片.
* [react-native-material-kit ★4124](https://github.com/xinthink/react-native-material-kit) - 将 Material Design 引入 React Native
* [react-native-snap-carousel ★3959](https://github.com/archriss/react-native-snap-carousel) - 用于 React Native 的 Swiper 组件，具有预览、多布局、视差图像、大量项目的高性能处理和 RTL 支持
* [react-native-calendars ★3402](https://github.com/wix/react-native-calendars) - React Native 日历组件
* [react-native-ui-kitten ★3140](https://github.com/akveo/react-native-ui-kitten) - 可定制和可重复使用的 react-native 组件套件
* [react-native-svg ★2982](https://github.com/magicismight/react-native-svg) - 适用于 iOS 和 Android 的 SVG 库
* [react-native-image-crop-picker ★2736](https://github.com/ivpusic/react-native-image-crop-picker) - 支持多张图片和裁剪的 iOS/Android 图像选择器
* [react-native-splash-screen ★2663](https://github.com/crazycodeboy/react-native-splash-screen) - 反应本机的启动画面，在应用程序加载时隐藏，适用于 iOS 和 Android.
* [react-native-material-ui ★2536](https://github.com/xotahal/react-native-material-ui) - 高度可定制的 React Native 材料设计组件
* [react-native-app-intro ★2433](https://github.com/FuYaoDe/react-native-app-intro) - React Native 视差效果应用介绍
* [react-native-drawer ★2276](https://github.com/root-two/react-native-drawer) - 反应本机抽屉
* [react-native-typography ★2260](https://github.com/hectahertz/react-native-typography) React Native 的像素完美、原生外观排版样式
* [react-native-fast-image ★2240](https://github.com/DylanVann/react-native-fast-image) - FastImage，高性能的 React Native 图像组件.
* [react-native-blurhash ★105](https://github.com/mrousavy/react-native-blurhash) - 为您的用户提供他们想要的加载体验.
* [react-native-paper ★2218](https://github.com/callstack/react-native-paper) - React Native 的材料设计
* [react-native-swipeout ★2194](https://github.com/dancormier/react-native-swipeout) - 组件后面的 iOS 风格滑动按钮
* [react-native-blur ★2172](https://github.com/Kureev/react-native-blur) - React Native Blur 组件
* [react-native-progress ★2069](https://github.com/oblador/react-native-progress) - 使用 ReactART 的 React Native 进度指示器和微调器.
* [react-native-textinput-effects ★2062](https://github.com/halilb/react-native-textinput-effects)  - 带有自定义标签和图标动画的文本输入，适用于 iOS 和 Android. 由 React Native 构建，灵感来自 Codrops.
* [react-native-modalbox ★2043](https://github.com/maxs15/react-native-modalbox) - 用于反应本机的组件
* [react-native-lightbox ★1917](https://github.com/oblador/react-native-lightbox) - 一个非常光滑和现代的移动灯箱实现
* [react-native-action-button ★1762](https://github.com/mastermoo/react-native-action-button) - 用于 React Native 的可自定义浮动按钮组件
* [gl-react-native ★1750](https://github.com/ProjectSeptemberInc/gl-react-native) - 使用 OpenGL 对图像和视频进行性能处理
* [react-native-modal ★1728](https://github.com/react-native-community/react-native-modal) - 一个增强的、动画的和可定制的反应本机模式
* [nachos-ui ★1684](https://github.com/avocode/nachos-ui)  - 用于 React Native 的 NACHOS UI 套件. 从一堆预编码的 UI 组件中挑选，为您的下一个 JavaScript 或 React 应用程序做好准备.
* [react-native-mapbox-gl ★1663](https://github.com/mapbox/react-native-mapbox-gl) - 用于创建自定义地图的 Mapbox GL 反应本机模块
* [react-native-foldview ★1616](https://github.com/jmurzy/react-native-foldview) - React Native 中的动画 FoldingCell 实现
* [react-native-modern-datepicker ★12](https://github.com/HosseinShabani/react-native-modern-datepicker) - React Native 现代日期选择器
* [react-native-spinkit ★1585](https://github.com/maxs15/react-native-spinkit) - React Native 的动画加载指示器集合
* [react-native-recyclerlist ★1515](https://github.com/Flipkart/recyclerlistview) - 支持复杂布局的 React Native 和 Web 的高性能列表视图.
* [react-native-parallax-scroll-view ★1486](https://github.com/jaysoo/react-native-parallax-scroll-view) - 具有视差和粘性标题支持的类似 ScrollView 的组件.
* [react-native-chart ★1464](https://github.com/onefold/react-native-chart) - React-native-chart 是一个简单的模块，用于向您的 React Native 应用程序添加折线图、面积图或条形图.
* [react-native-gifted-listview ★1443](https://github.com/FaridSafi/react-native-gifted-listview) - 一个 ListView，嵌入了一些循环功能，如下拉刷新、无限滚动等，适用于 Android 和 iOS React-Native 应用程序
* [react-native-datepicker ★1365](https://github.com/xgfe/react-native-datepicker) - 适用于 Android 和 IOS 的 React Native 日期、日期时间和时间选择器
* [react-native-viewpager ★1350](https://github.com/race604/react-native-viewpager) - React Native 的 ViewPager 组件
* [react-virgin ★1319](https://github.com/Trixieapp/react-virgin) 您一直在寻找的 react-native UI 套件.
* [react-native-easy-grid ★1304](https://github.com/GeekyAnts/react-native-easy-grid) - 用于 React Native 的简单响应式网格布局.
* [victory-native ★1264](https://github.com/FormidableLabs/victory-native) - Victory-native 是一组组件，可帮助您创建图表、条形图等.
* [react-native-picker ★1238](https://github.com/beefe/react-native-picker) - 反应本机选择器
* [react-native-collapsible ★1174](https://github.com/oblador/react-native-collapsible)  - React Native 的动画可折叠组件使用带有回退功能的新动画 API. 适用于手风琴、肘节等
* [react-native-icons ★1168](https://github.com/corymsmith/react-native-icons) - React Native 中快速简单的图标 [video](https://www.youtube.com/watch?v=TEdM7IwTT1g#t=50)
* [react-native-orientation ★1162](https://github.com/yamill/react-native-orientation) - 聆听本机设备方向的变化，并在屏幕上设置首选方向
* [react-native-tableview ★1105](https://github.com/aksonov/react-native-tableview) - 用于 React Native 的原生 iOS TableView 包装器
* [react-native-keyboard-spacer ★1103](https://github.com/Andr3wHur5t/react-native-keyboard-spacer) - 即插即用反应本机键盘垫片视图.
* [react-native-looped-carousel ★1094](https://github.com/appintheair/react-native-looped-carousel) - 创建视图或图像的循环旋转木马
* [react-native-circular-progress ★1088](https://github.com/bgryszko/react-native-circular-progress) - React Native 组件，用于使用 ReactART 创建动画、循环进度
* [react-native-popup-dialog ★1088](https://github.com/jacklam718/react-native-popup-dialog)  - React Native 弹出对话框易于使用和支持使用自定义动画. 适用于 IOS 和安卓
* [react-native-largelist ★1054](https://github.com/bolan9999/react-native-largelist) - 用于 React Native（iOS 和 Android）的最佳性能大型列表组件
* [react-native-offline ★977](https://github.com/rauliyohmc/react-native-offline)  - 方便的工具带，可以很好地处理 React Native 应用程序中的离线/在线连接. 平滑的 redux 集成.
* [react-native-root-toast ★971](https://github.com/magicismight/react-native-root-toast) - React native toast like component，纯javascript解决方案
* [react-native-dropdownalert ★894](https://github.com/testshallpass/react-native-dropdownalert) - 具有 4 种预定义类型的简单下拉警报.
* [react-native-loading-spinner-overlay ★885](https://github.com/niftylettuce/react-native-loading-spinner-overlay) - 唯一的纯 React Native、Native iOS 和 Android 加载微调器（进度条指示器）叠加
* [react-native-tinder-swipe-cards ★881](https://github.com/meteor-factory/react-native-tinder-swipe-cards) - 火种卡式刷卡.
* [react-native-slider ★845](https://github.com/jeanregisser/react-native-slider) - 用于 react-native 的纯 JavaScript 组件
* [react-native-pathjs-charts ★842](https://github.com/capitalone/react-native-pathjs-charts) - 基于 react-native-svg 和 paths-js 的 Android 和 iOS 图表
* [react-native-flash-message ★810](https://github.com/lucasferreira/react-native-flash-message#readme) - React Native flashbar 和顶部通知警报实用程序
* [react-native-svg-charts ★764](https://github.com/JesperLekland/react-native-svg-charts) - 一个库来管理 React Native 的所有图表
* [react-native-masonry ★758](https://github.com/brh55/react-native-masonry) - 用于渲染图像的砖石结构布局.
* [react-native-credit-card-input ★742](https://github.com/sbycrosz/react-native-credit-card-input) - 为您的 React Native 项目提供简单（且美观）的信用卡输入
* [action-sheet-rn ★1](https://github.com/mfrachet/action-sheet-rn) - 可能是 React Native 中 ActionSheets 最具声明性的 API
* [react-native-sglistview ★731](https://github.com/sghiassy/react-native-sglistview) - React Native 的 ListView 的记忆实现
* [react-native-modal-dropdown ★708](https://github.com/sohobloo/react-native-modal-dropdown) - 适用于 Android 和 iOS 的反应本机下拉/选择器/选择器组件.
* [react-native-button ★707](https://github.com/ide/react-native-button)
* [react-native-bottom-sheet-behavior ★701](https://github.com/cesardeazevedo/react-native-bottom-sheet-behavior) - Android BottomSheetBehavior 的反应本机包装器.
* [react-native-tabs ★687](https://github.com/aksonov/react-native-tabs)  - React Native 独立于平台的选项卡. 可用于底部标签栏和剖视图（带有标签按钮）
* [react-native-search-bar ★671](https://github.com/umhan35/react-native-search-bar) - React Native 的原生搜索栏.
* [react-native-timeline-listview ★665](https://github.com/thegamenicorus/react-native-timeline-listview) - React Native App 的时间轴组件
* [react-native-toastboard](https://github.com/MAKARD/react-native-toastboard) - 显示通知的最简单方式.
* [apsl-react-native-button ★653](https://github.com/APSL/react-native-button) - 带有圆角的 React Native 按钮组件.
* [react-native-popup-menu ★653](https://github.com/instea/react-native-popup-menu) - React Native 的可扩展弹出菜单组件.
* [react-native-qrcode ★644](https://github.com/cssivision/react-native-qrcode) - react-native 二维码生成器
* [react-native-easy-toast ★616](https://github.com/crazycodeboy/react-native-easy-toast) - 一个反应本机模块，像 android 一样显示吐司，它适用于 iOS 和 Android.
* [react-router-native ★612](https://github.com/jmurzy/react-router-native) - 一个用于 React Native 的路由库，力求与 [React Router](https://github.com/reactjs/react-router)
* [react-native-copilot ★595](https://github.com/okgrow/react-native-copilot) - 逐步演练您的 React Native 应用程序
* [react-native-photo-browser ★565](https://github.com/halilb/react-native-photo-browser) - 具有标题、选择和网格视图支持的本地和远程照片浏览器.
* [react-native-calendar ★559](https://github.com/christopherdro/react-native-calendar) - React Native 的日历组件
* [react-native-calendar-events ★510](https://github.com/wmcmahan/react-native-calendar-events)
* [react-native-parsed-text ★552](https://github.com/taskrabbit/react-native-parsed-text) - 解析文本并将它们制作成多个 React Native Text 元素
* [react-native-step-indicator ★538](https://github.com/24ark/react-native-step-indicator) - 与 ViewPager 和 ListView 兼容的步骤指示器小部件的简单反应本机实现.
* [react-native-popover-haobtc ★514](https://github.com/jeanregisser/react-native-popover) - 用于反应本机的组件
* [react-native-dropdown ★507](https://github.com/alinz/react-native-dropdown) - 更好的 React-native 选择下拉菜单
* [react-native-star-rating ★489](https://github.com/djchie/react-native-star-rating) - 用于生成和显示交互式星级的 React Native 组件
* [react-native-rating-element ★8](https://github.com/ui-ninja/react-native-rating-element) - 反应原生评级系统支持：小数点评级，方向感知图标，如从下到上或从右到左等，来自 Ionicons 的自定义图标，自定义图像和用户给出的记录评级.
* [react-native-parallax ★479](https://github.com/oblador/react-native-parallax) - 使用动画 API 的 React Native 视差效果
* [react-native-sketch ★467](https://github.com/jgrancher/react-native-sketch) - 一个反应本机 &lt;Sketch /&gt; 组件，用于绘制触摸事件.
* [react-native-dialogs ★463](https://github.com/aakashns/react-native-dialogs) - React Native 包装器<https://github.com/afollestad/material-dialogs>
* [galio ★458](https://github.com/galio-org/galio) - 一个全新的 React 本机 UI 框架.
* [react-native-root-siblings ★452](https://github.com/magicismight/react-native-root-siblings) - 在您的应用程序根元素之后添加兄弟元素.
* [react-native-size-matters ★436](https://github.com/nirsky/react-native-size-matters) - 一个 React-Native 实用工具带，用于在不同大小的设备上缩放应用程序 UI 的大小.
* [react-native-button-component ★434](https://github.com/jacklam718/react-native-button-component) - 适用于 iOS 和 Android 的漂亮、可定制的 React Native Button 组件
* [react-native-super-grid ★434](https://github.com/saleel/react-native-super-grid) - React Native 的响应式网格视图.
* [react-native-activity-view ★427](https://github.com/naoufal/react-native-activity-view) - 用于 React Native 的 iOS 共享和操作表
* [react-native-canvas ★421](https://github.com/lwansbrough/react-native-canvas) - 用于 React Native 的 Canvas 元素
* [react-native-refresher ★419](https://github.com/syrusakbary/react-native-refresher)  - 一个 React Native 拉动刷新 ListView 完全用 js 编写. 还支持自定义动画.
* [react-native-sortable-list ★412](https://github.com/gitim/react-native-sortable-list) React Native 的可排序列表，支持垂直和水平方向.
* [react-native-gesture-password ★410](https://github.com/spikef/react-native-gesture-password) - React Native 的手势密码组件
* [react-native-carousel ★406](https://github.com/nick/react-native-carousel) - 用于反应本机的简单轮播组件
* [react-native-country-picker-modal ★403](https://github.com/xcarpentier/react-native-country-picker-modal)  - 国家选择器提供了一个模式，允许用户从列表中选择一个国家. 它在每个国家名称旁边显示一面旗帜.
* [react-native-radio-buttons ★399](https://github.com/ArnaudRinquin/react-native-radio-buttons) - 一个用于实现自定义单选按钮行为的反应组件：多个选项，只能一次选择.
* [react-native-masked-text ★392](https://github.com/benhurott/react-native-masked-text) - 用于 React Native 的简单屏蔽文本和输入文本组件.
* [react-native-accordion ★390](https://github.com/naoufal/react-native-accordion) - React Native 的手风琴组件
* [react-native-invertible-scroll-view ★388](https://github.com/exponentjs/react-native-invertible-scroll-view) - 用于 React Native 的可翻转 ScrollView
* [react-native-message-bar ★384](https://github.com/KBLNY/react-native-message-bar) - 用于通过屏幕顶部/底部的动画消息栏呈现通知的模块，高度可定制，适用于 React Native（Android 和 iOS）项目.
* [react-native-fit-image ★383](https://github.com/huiseoul/react-native-fit-image) - 响应式图像组件，完美契合自身.
* [react-native-text-input-mask ★383](https://github.com/ivanzotov/react-native-text-input-mask) - Android 和 iOS 的文本输入掩码，本机实现 RedMadRobot 库
* [react-native-alphabetlistview ★372](https://github.com/sunnylqm/react-native-alphabetlistview) - 基于 johanneslumpe 的 react-native-selectablesectionlistview，带有侧边栏的 ListView 可以直接跳转到各个部分
* [react-native-check-box ★372](https://github.com/crazycodeboy/react-native-check-box) - React Native 的复选框组件，适用于 iOS 和 Android.
* [react-native-really-awesome-button ★370](https://github.com/rcaferati/react-native-really-awesome-button) - RNRAB 是一个 60fps 的 3D，支持进度，可扩展，生产就绪组件，呈现一组很棒的动画 UI 按钮.
* [react-native-autocomplete-input ★366](https://github.com/l-urence/react-native-autocomplete-input) - react-native 的纯 javascript 自动完成输入
* [react-native-splashscreen ★358](https://github.com/remobile/react-native-splashscreen) - 反应本机的启动画面
* [react-native-responsive-image ★344](https://github.com/Dharmoslap/react-native-responsive-image) - 最优雅的响应式图片组件
* [react-native-pdf-view ★338](https://github.com/cnjon/react-native-pdf-view) - 使用 react-native 查看 pdf 文件
* [react-native-image-header-scroll-view ★338](https://github.com/bamlab/react-native-image-header-scroll-view) - 标题中带有图像的 ScrollView 成为导航栏
* [react-native-toast ★336](https://github.com/remobile/react-native-toast) - 一个类似 toast 的 android，用于对 iOS 和 Android 的 react-native 支持
* [react-native-modal-picker ★333](https://github.com/d-a-n/react-native-modal-picker) - 跨平台（iOS / Android），用于 React Native 的选择器/选择器组件，可高度自定义并支持部分.
* [react-native-off-canvas-menu ★327](https://github.com/shoumma/react-native-off-canvas-menu) - 为 React 本机应用程序精心制作的画布菜单组件.
* [rn-sliding-up-panel ★321](https://github.com/octopitus/rn-sliding-up-panel)  - React Native 可拖动向上滑动面板完全用 Javascript 实现. 在 iOS 和 Android 上都能很好地工作.
* [react-native-search-box ★319](https://github.com/crabstudio/react-native-search-box) - 一个带有动画的简单搜索框，灵感来自 ios 搜索栏.
* [react-native-parallax-swiper ★315](https://github.com/zachgibson/react-native-parallax-swiper)  - 基于 iOS 模式的可配置视差滑动器. 使用本机驱动程序实现超级平滑的视差.
* [react-native-gesture-recognizers ★313](https://github.com/johanneslumpe/react-native-gesture-recognizers) - 反应本机的手势识别器装饰器
* [react-native-searchbar ★313](https://github.com/localz/react-native-searchbar) - 一个动画搜索栏，用于通过内置搜索（iOS 和 Android）进行本机反应
* [react-native-app-auth ★310](https://github.com/FormidableLabs/react-native-app-auth) - React Native bridge for AppAuth - 一个符合 PKCE 标准的 SDK，用于与 OAuth2 提供商通信
* [react-native-circular-action-menu ★305](https://github.com/geremih/react-native-circular-action-menu) - 动画和可定制的圆形浮动菜单.
* [react-native-effects-view ★304](https://github.com/voronianski/react-native-effects-view) - 使 iOS8 UIVisualEffect 易于使用的 React Native 组件
* [react-native-root-modal ★304](https://github.com/magicismight/react-native-root-modal) - 反应本机模态组件
* [react-native-timeago ★278](https://github.com/TylerLH/react-native-timeago) - 为 React Native 自动更新 timeago 组件
* [react-native-grid-view ★276](https://github.com/lucholaf/react-native-grid-view) - React Native 网格/集合视图组件
* [react-native-md-textinput ★275](https://github.com/evblurbs/react-native-md-textinput) - 使用 Material Design 设计样式的 React Native TextInput.
* [react-native-timer-mixin ★274](https://github.com/reactjs/react-timer-mixin)  - TimerMixin 为将来执行代码提供计时器功能，这些代码在组件卸载时会被安全清理. 这是一个包括 react-native InteractionManager 支持的分支.
* [react-native-tableview-simple ★267](https://github.com/Purii/react-native-tableview-simple) - 用纯 CSS 制作的 TableView 的 React Native 组件
* [react-native-keyboard-manager ★267](https://github.com/douglasjunior/react-native-keyboard-manager) - 允许防止键盘向上滑动和覆盖 React-Native iOS 项目的问题的库.
* [react-native-tabbar ★261](https://github.com/alinz/react-native-tabbar) - 更自由的标签栏
* [react-native-simple-router ★255](https://github.com/react-native-simple-router-community/react-native-simple-router) - 社区维护的 React Native 路由器组件
* [react-native-cacheable-image ★255](https://github.com/jayesbe/react-native-cacheable-image) - 用于 react-native 的文件系统可缓存图像组件
* [react-native-segmented-control-tab ★252](https://github.com/kirankalyan5/react-native-segmented-control-tab) react-native-segmented-control-tab（适用于 Android/iOS）
* [react-native-modal-selector ★249](https://github.com/peacechen/react-native-modal-selector) - 跨平台（iOS / Android），用于 React Native 的选择器/选择器组件，可高度自定义并支持部分. 
* [react-native-keyboardevents ★247](https://github.com/johanneslumpe/react-native-keyboardevents) - 监控键盘显示/隐藏通知
* [react-native-multiselect ★246](https://github.com/toystars/react-native-multiple-select) - 用于 react-native 的简单多选组件.
* [react-native-cardview ★239](https://github.com/Kishanjvaghela/react-native-cardview) - 反应本机的 CardView（所有 Android 版本和 iOS）
* [react-native-shimmer-placeholder ★231](https://github.com/tomzaku/react-native-shimmer-placeholder) - React Native 的占位符
* [react-native-progress-hud ★228](https://github.com/naoufal/react-native-progress-hud) - 为您的 React Native 应用程序提供干净轻便的进度 HUD
* [react-native-qrcode-svg ★228](https://github.com/awesomejerry/react-native-qrcode-svg) - 基于 react-native-svg 和 node-qrcode 的 React Native 二维码生成器.
* [react-native-bottom-action-sheet ★226](https://github.com/prscX/react-native-bottom-action-sheet) - React Native：原生底部操作表
* [react-native-awesome-button ★222](https://github.com/larsvinter/react-native-awesome-button) - 一个 React Native 组件呈现一个按钮，支持在给定传递的道具的情况下显示不同的外观和功能
* [react-native-mobx ★220](https://github.com/aksonov/react-native-mobx) - 让你的应用程序与 MobX 和 react-native-router-flux 反应
* [react-native-egg ★220](https://github.com/FuYaoDe/react-native-egg) - 一个彩蛋组件实现简单的手势检测实现触发可以让你的react native app无限好玩.
* [react-native-progress-bar ★218](https://github.com/lwansbrough/react-native-progress-bar) - React Native 的动画进度条组件
* [react-native-tooltip ★217](https://github.com/chirag04/react-native-tooltip) - 用于显示工具提示的本机包装器
* [react-native-emoji ★216](https://github.com/jorilallo/react-native-emoji) - React Native 的表情符号组件
* [react-native-image-cache-hoc ★211](https://github.com/billmalarky/react-native-image-cache-hoc) - 为标准图像组件添加高级缓存和持久性功能的高阶组件.
* [react-native-parallax-scroll ★209](https://github.com/monterosalondon/react-native-parallax-scroll) - 具有粘性标题、前景、本机驱动程序和所有可滚动组件（FlatList、ListView、SectionList、ScrollView）支持的视差滚动组件.
* [react-native-shine-button ★205](https://github.com/prscX/react-native-shine-button) - React Native 效果如闪耀
* [autoresponsive-react-native ★201](https://github.com/xudafeng/autoresponsive-react-native) - 一个神奇的 React 布局库
* [react-native-autolink ★201](https://github.com/joshswan/react-native-autolink) - React Native 的自动链接组件
* [react-native-carousel-control ★199](https://github.com/machadogj/react-native-carousel-control) - 支持 iOS 和 Android 的 React Native Carousel 控件.
* [react-native-picker-select ★199](https://github.com/lawnstarter/react-native-picker-select)  - 一个用于 React Native 的 Picker 组件，它模拟了原生的`<select> ` 适用于 iOS 和 Android 的界面
* [react-native-calendar-select ★195](https://github.com/Tinysymphony/react-native-calendar-select) - 用于从日历模式中选择日期期间的组件，例如 Airbnb.
* [react-native-wheel-picker ★190](https://github.com/lesliesam/react-native-wheel-picker) - React 本机跨平台选择器.
* [react-native-grid-component ★188](https://github.com/phil-r/react-native-grid-component)  - 易于为您的反应本机项目使用网格组件. 支持 iOS 和安卓系统.
* [react-native-popover-menu ★188](https://github.com/prscX/react-native-popover-menu) - React Native：原生弹出式菜单
* [react-native-collapsing-toolbar ★185](https://github.com/cesardeazevedo/react-native-collapsing-toolbar) - android CollapsingToolbarLayout 包装器
* [react-native-pagination ★182](https://github.com/garrettmac/react-native-pagination) - 一个漂亮的列表分页插件.
* [react-native-hero ★180](https://github.com/brh55/react-native-hero) - 支持动态或静态图像、动态调整大小、颜色叠加等的英雄/横幅组件.
* [react-native-selectme ★178](https://github.com/gs-akhan/react-native-select) - 更好的 React-native 选择下拉菜单
* [react-native-swiper-animated ★176](https://github.com/chitezh/react-native-swiper-animated) - 类似 Tinder 的滑动器，用于反应本机
* [react-native-tab ★171](https://github.com/vczero/react-native-tab) - react-native-tab 是一个简单的模块，用于将“选项卡菜单”添加到您的 React Native 应用程序.
* [react-native-webbrowser ★167](https://github.com/d-a-n/react-native-webbrowser) - 用于 React Native 应用程序的跨平台（iOS / Android），功能齐全，高度可定制的 Web 浏览器模块.
* [react-native-autocomplete ★163](https://github.com/nulrich/RCTAutoComplete) - 为 MLPAutoCompleteTextField 反应本机组件
* [react-native-segmented-view ★159](https://github.com/lelandrichardson/react-native-segmented-view) - React Native 的分段视图（带动画）
* [react-native-cache-image ★158](https://github.com/remobile/react-native-cache-image) - 用于反应本机的缓存图像
* [react-native-pulse-loader ★158](https://github.com/mastermoo/react-native-pulse-loader) - 类似 Tinder 的 React Native 应用加载器
* [stacks ★156](https://github.com/mobily/stacks) - 堆栈：一组用于快速构建 RN 视图的布局组件 ⚡，使用调试模式和设计系统网格，您可以研究重要的视觉问题.
* [react-native-display ★155](https://github.com/sundayhd/react-native-display)  - 此模块带来“显示：无”（css 样式）以从渲染打开/关闭组件. 使用此模块将通过进入/退出动画改善您的应用程序性能和外观.
* [RNParallax ★155](https://github.com/kyaroru/RNParallax) - 带有视差标题的反应本机滚动视图组件
* [react-native-checkbox ★154](https://github.com/sconxu/react-native-checkbox) - React native 的复选框组件
* [react-native-phone-input ★154](https://github.com/thegamenicorus/react-native-phone-input) - React Native 的电话输入框
* [react-native-switch-pro ★153](https://github.com/poberwong/react-native-switch-pro) - 一个非常好的 Android 和 iOS 开关，在两个平台上具有相同的性能并且库中的代码干净.
* [react-native-popup ★153](https://github.com/beefe/react-native-popup) - 反应本机的弹出窗口
* [react-native-radial-menu ★153](https://github.com/omulet/react-native-radial-menu) - 针对触摸界面优化的径向菜单
* [react-native-gestures ★152](https://github.com/kiddkai/react-native-gestures) - React Native 中的可组合手势系统
* [react-native-page-control ★151](https://github.com/silentcloud/react-native-page-control) - React 原生页面控件，如 ios UIPageControl
* [react-native-iconic ★149](https://github.com/prscX/react-native-iconic) - React Native - 不同状态的动画图标
* [react-native-google-place-picker ★148](https://github.com/q6112345/react-native-google-place-picker) - 适用于 Android 和 iOS 的 Google Place Picker 的 React Native Wrapper.
* [react-native-scaling-drawer ★148](https://github.com/melihberberolu/react-native-scaling-drawer) - 反应本机缩放抽屉.
* [react-native-image-carousel ★148](https://github.com/anvilabs/react-native-image-carousel) - 图像轮播，支持全屏模式、图像滑动和全屏模式下的双指缩放.
* [react-native-offline-mode ★144](https://github.com/rauchy/react-native-offline-mode) - 在没有连接的情况下将您的应用程序换成离线版本
* [react-native-orientation-listener ★141](https://github.com/walmartreact/react-native-orientation-listener) - 用于获取当前设备方向的反应本机库
* [react-native-multi-slider ★137](https://github.com/JackDanielsAndCode/react-native-multi-slider) - Pure JS slider component with multiple markers for React Native
* [react-native-color-picker ★137](https://github.com/instea/react-native-color-picker) - Android 和 iOS 颜色选择器的 React Native 实现.
* [react-native-android-statusbar ★135](https://github.com/NishanthShankar/react-native-android-statusbar) - 一个反应本机 android 包来控制状态栏.
* [react-native-privacy-snapshot ★133](https://github.com/kayla-tech/react-native-privacy-snapshot) - 当反应本机应用程序转换到后台时模糊密码和其他敏感的个人信息
* [react-native-custom-segmented-control ★132](https://github.com/wix/react-native-custom-segmented-control) - 具有自定义样式的分段控制的本机 UI iOS 组件
* [react-native-map-link ★131](https://github.com/includable/react-native-map-link) - 在用户选择的地图应用程序中打开一个位置.
* [react-native-sketch-canvas ★129](https://github.com/terrylinla/react-native-sketch-canvas)  - 用于在 iOS 和 Android 上通过触摸绘图的 React Native 组件.  （支持在图片、文字上绘图）
* [react-native-floating-labels ★126](https://github.com/mayank-patel/react-native-floating-labels) - Reusabe 浮动标签组件以响应本机
* [react-native-beautiful-video-recorder ★125](https://github.com/phuochau/react-native-beautiful-video-recorder)  - 从 react-native-camera 扩展而来的录像机组件. 它适用于 iOS 和 Android.
* [react-native-cell-components ★125](https://github.com/lodev09/react-native-cell-components)  - 很棒的 react-native 细胞组件！ 从 Cell 到更复杂和更棒的组件.
* [react-native-material-menu ★119](https://github.com/mxck/react-native-material-menu) - React Native 的纯 JavaScript 材料菜单组件.
* [react-native-bouncy-drawer ★116](https://github.com/SoftZen/react-native-bouncy-drawer) - 高度可定制的弹力抽屉
* [react-native-taptargetview ★114](https://github.com/prscX/react-native-taptargetview)  - 用于 Android KeepSafe/TapTargetView 的 React Native Bridge. 用于功能发现的 Material Design 指南中的点击目标的实现.
* [photo-viewer ★114](https://github.com/merryjs/photo-viewer) - 用于在 NYTPhotoViewer 和 FrescoImageViewer 之上构建的本机照片查看器
* [react-native-switch-selector ★112](https://github.com/App2Sales/react-native-switch-selector) - 适用于 Android 和 iOS 的自定义开关选择器组件.
* [react-native-flexi-radio-button ★111](https://github.com/thegamenicorus/react-native-flexi-radio-button) - 用于 React Native 的简单灵活的单选按钮
* [react-native-triangle ★108](https://github.com/Jpoliachik/react-native-triangle) - 在 React Native 中绘制三角形视图
* [react-native-viewport-units ★107](https://github.com/jmstout/react-native-viewport-units) - 非常简单的实用程序（某种程度上）将视口单元与 React Native 结合使用.
* [react-native-wheel-picker-android ★186](https://github.com/ElekenAgency/ReactNativeWheelPicker) - 简单灵活的 Android 原生 React 滚轮选择器，包括 DatePicker 和 TimePicker.
* [react-native-device-display ★105](https://github.com/kkjdaniel/react-native-display-view) - 一种通过设备和显示检测创建动态视图的简单方法，允许创建适应性强的通用应用程序.
* [react-native-android-kit ★104](https://github.com/ayoubdev/react-native-android-kit) - 一组用于 React Native 框架的原生 Android UI 组件和模块（Android 设计支持库、TabLayout、浮动操作按钮等...）.
* [react-native-fading-slides ★103](https://github.com/chagasaway/react-native-fading-slides) - 用于 React Native 的简单循环淡入淡出幻灯片轮播
* [react-native-scl-alert ★102](https://github.com/rafaelmotta/react-native-scl-alert) - React Native 实现包 SCLAlertView-Swift
* [react-native-card-view ★101](https://github.com/jacklam718/react-native-card-view) - 反应本机卡组件
* [react-native-marquee-label ★100](https://github.com/remobile/react-native-marquee-label) - 反应本机的字幕标签
* [react-native-drawer-menu ★97](https://github.com/Tinysymphony/react-native-drawer-menu) - React Native 抽屉菜单
* [react-native-simple-dialogs ★97](https://github.com/douglasjunior/react-native-simple-dialogs) - 基于 Modal 组件的 React Native 的跨平台简单对话框.
* [react-native-swipe-a-lot ★96](https://github.com/nickjanssen/react-native-swipe-a-lot) - 适用于 iOS 和 Android 的 React Native 滑动组件.
* [react-native-submit-button ★96](https://github.com/ronak301/react-native-submit-button)  - 动画提交按钮. 适用于 android 和 ios
* [react-native-actions-sheet ★94](https://github.com/ammarahm-ed/react-native-actions-sheet) - 具有灵活 api、本机性能和零依赖代码的跨平台（Android 和 iOS）ActionSheet
* [react-native-dialog ★92](https://github.com/mmazzarolo/react-native-dialog) - 纯 JavaScript React-Native 对话框
* [react-native-scrollable-mixin ★91](https://github.com/exponentjs/react-native-scrollable-mixin) - 可滚动的 React Native 组件的标准接口，使组合组件更容易
* [react-native-open-maps ★90](https://github.com/brh55/react-native-open-maps) - 一个简单的库，用于从 react-native 中的一组坐标（纬度和经度）打开相应的地图应用程序（谷歌或苹果地图）
* [react-native-swiper2 ★86](https://github.com/sunnylqm/react-native-swiper2)  - React Native 的 Swiper 组件. 超级酷的 react-native-swipers
* [react-native-listitem ★86](https://github.com/dancormier/react-native-listitem) - 用于 React Native 的 iOS 风格列表项组件
* [react-native-progressive-input ★86](https://github.com/khaiql/react-native-progressive-input) - 带有清除按钮和活动指示器的文本输入，用作自动完成列表的一部分.
* [react-native-in-app-notification ★86](https://github.com/robcalcroft/react-native-in-app-notification) - Customisable in-app notification component for React Native
* [react-native-shared-preferences ★85](https://github.com/sriraman/react-native-shared-preferences) - React Native中Android的Native键值存储系统
* [react-native-emoji-picker ★85](https://github.com/yonahforst/react-native-emoji-picker) - 简单的表情符号选择器，用于反应本机，带有可选的类似模态的组件
* [react-native-scalable-image ★85](https://github.com/ihor/react-native-scalable-image) - React Native Image 组件自动缩放宽度或高度以保持原始纵横比.
* [react-native-page-swiper ★83](https://github.com/fixt/react-native-page-swiper) - React Native 的 Page Swiper 组件.
* [react-native-material-showcase-ios ★81](https://github.com/prscX/react-native-material-showcase-ios)  - 用于 iOS 的 React Native Bridge aromajoin/material-showcase-ios. 优雅漂亮的 iOS 应用程序展示.
* [react-native-label-select ★81](https://github.com/Tinysymphony/react-native-label-select) - React Native 的模态选择器，所选项目显示为标签.
* [react-native-3dcube-navigation ★80](https://github.com/zehfernandes/react-native-3dcube-navigation) - 具有 3D 立方体过渡（水平和垂直）的 Page Swiper 组件
* [react-native-keyboard-accessory ★80](https://github.com/ardaogulcan/react-native-keyboard-accessory)  - 键盘附件（视图、导航）组件. 键盘上的粘性视图.
* [react-native-draggable-grid ★79](https://github.com/SHISME/react-native-draggable-grid) - 由 typescript 编写的 React Native 可拖动和可排序网格组件.
* [react-native-textinput-utils ★79](https://github.com/DickyT/react-native-textinput-utils) - 一个反应本机扩展，允许您更好地控制 TextInput.
* [react-native-idle-timer ★79](https://github.com/marcshilling/react-native-idle-timer) - 一个 Objective-C 桥，允许您在 React Native 应用程序中启用和禁用屏幕空闲计时器
* [react-native-snackbar-component ★77](https://github.com/SiDevesh/React-Native-SnackBar-Component) - 适用于 Android 和 iOS 的快餐栏组件，可自定义且简单.
* [react-native-charts ★76](https://github.com/PrazAs/react-native-charts) - 令人愉快的动画数据可视化.
* [react-native-android-blurryoverlay ★75](https://github.com/kwaak/react-native-android-blurryoverlay) - 反应本机 android 包显示模糊覆盖.
* [react-native-calendar-datepicker ★75](https://github.com/vlad-doru/react-native-calendar-datepicker) - 一个跨平台的日历日期选择器
* [react-native-scrollview-smart ★75](https://github.com/bolket/react-native-scrollview-smart) - 适用于 IOS 和 Android 的智能滚动视图组件.
* [react-native-zoom-image ★75](https://github.com/Tinysymphony/react-native-zoom-image) - 用于 react-native 的图像查看器组件，如 twitter 的图像查看器.
* [react-native-picker-xg ★74](https://github.com/xgfe/react-native-picker-xg) - 适用于 Android 和 iOS 的选择器
* [react-native-status-bar-height ★73](https://github.com/ovr/react-native-status-bar-height)  - 一个帮助您轻松获取状态栏高度的小型库. 它还支持 iPhone X.
* [react-native-color-wheel ★72](https://github.com/netbeast/react-native-color-wheel) - 反应本机可重复使用的颜色选择器轮
* [react-native-scrollview-lazyload ★71](https://github.com/IskenHuang/react-native-scrollview-lazyload) - 带有图像延迟加载的本机滚动视图
* [react-native-pure-navigation-bar ★71](https://github.com/gaoxiaosong/react-native-pure-navigation-bar) - React Native 中完全可定制的导航栏.
* [react-native-material-cards ★70](https://github.com/SiDevesh/React-Native-Material-Cards) - 材料设计卡片组件，可定制且用途广泛.
* [react-native-item-cell ★69](https://github.com/APSL/react-native-item-cell) - React Native 默认样式 iOS 项目单元格
* [react-native-calendario ★69](https://github.com/maggialejandro/react-native-calendario) - React Native 日历 DatePicker
* [react-native-picker-android ★67](https://github.com/beefe/react-native-picker-android) - react-native-picker-android
* [react-native-nested-stylesheet ★67](https://github.com/pjjanak/react-native-nested-stylesheets) - 用于反应本机的可嵌套样式表.
* [react-native-dropdown-android ★65](https://github.com/chymtt/ReactNativeDropdownAndroid) - Android Spinner 的简单包装器，用于 react-native
* [react-native-slot-machine ★65](https://github.com/atlanteh/react-native-slot-machine) - 用于 react-native 的文本老虎机组件
* [react-native-swipeview ★65](https://github.com/rishabhbhatia/react-native-swipeview) - SwipeView 组件用于执行滑动删除等操作，适用于 iOS 和 Android
* [react-native-download-button ★64](https://github.com/prscX/react-native-download-button) - React Native 下载按钮：带有非常酷的动画
* [react-native-siri-wave-view ★64](https://github.com/prscX/react-native-siri-wave-view) - React Native：原生 Siri Wave 视图
* [react-native-card-media ★63](https://github.com/dondoko-susumu/react-native-card-media) - 卡片媒体组件 &amp; 支持多图布局
* [react-native-simple-picker ★62](https://github.com/puredazzle/react-native-simple-picker) - 一个简单的 react-native 选择器
* [react-native-view-pdf ★62](https://github.com/rumax/react-native-PDFView) - React Native 的 PDF 查看器
* [react-native-touchable-bounce ★62](https://github.com/grabbou/react-native-touchable-bounce) - React Native Touchable Bounce
* [react-native-streetview ★61](https://github.com/nesterapp/react-native-streetview) - 适用于 iOS 和 Android 的 Google 全景/街景组件.
* [react-native-thumbnail ★60](https://github.com/phuochau/react-native-thumbnail) - 从本地媒体获取缩略图.
* [react-native-simple-stepper ★60](https://github.com/testshallpass/react-native-simple-stepper) - UIStepper iOS 控件的超级简单的反应本机实现.
* [react-native-phone-picker ★58](https://github.com/Spikef/react-native-phone-picker) - 快速电话选择器控件
* [react-native-infinite-scrollview ★58](https://github.com/baspellis/react-native-infinite-scrollview) - 具有无限分页滚动的 ScrollView（无循环）
* [react-native-select-multiple  ★58](https://github.com/tableflip/react-native-select-multiple) - 一个简单易用的组件，用于从列表中选择多个项目.
* [react-native-multiple-choice ★57](https://github.com/d-a-n/react-native-multiple-choice) - 跨平台（iOS / Android）单选和多选 React Native 组件.
* [k-react-native-swipe-unlocker ★55](https://github.com/leowang721/k-react-native-swipe-unlocker) - React Native 的简单滑动解锁
* [react-native-walkthrough-tooltip ★55](https://github.com/CompanyCam/react-native-walkthrough-tooltip) - 通过工具提示/弹出窗口突出显示组件
* [react-native-adbannerview ★52](https://github.com/Purii/react-native-adbannerview) - 用于 ADBannerView 的 React Native Bridge
* [react-native-fxblurview ★52](https://github.com/magus/react-native-fxblurview) - 流行的 FXBlurView 库的 React Native 包装器，用于实时、微调的模糊效果
* [react-native-beautiful-image ★52](https://github.com/phuochau/react-native-beautiful-image) - Beautiful Image组件，支持fadeIn动画，如果无法加载主源则显示placeholderSource.
* [react-native-360-image-viewer ★100](https://github.com/phuochau/react-native-360-image-viewer) - 该组件有助于从多个图像中模拟 360 度图像.
* [react-native-fs-modal ★51](https://github.com/kirkness/react-native-fs-modal) - 反应本机全屏模式组件.
* [react-native-toast-native ★51](https://github.com/onemolegames/react-native-toast-native) 适用于 Android 和 iOS 的 React Native Toast 组件.
* [react-native-masked-view ★50](https://github.com/gilbox/react-native-masked-view) - 反应本机的元素
* [react-native-md-motion-buttons ★50](https://github.com/zecaptus/react-native-md-motion-buttons) - 受 inVision 应用程序启发的材料设计运动按钮.
* [react-native-drop-refresh ★49](https://github.com/Obooman/RCTRefreshControl) - 用于 React Native 的下拉刷新控件.
* [react-native-pin-view ★48](https://github.com/talut/react-native-pin-view)  - 简单、方便、快速成型的 PinView 组件. 它在 IOS 和 Android 上运行流畅.
* [react-native-radio-button-classic ★47](https://github.com/pressly/react-native-radio-button-classic) - 将经典广播带到 React-Native
* [react-native-image-intent ★47](https://github.com/sonnylazuardi/react-native-image-intent) - React Native android 的图像意图接收器
* [react-native-dial ★47](https://github.com/netbeast/react-native-dial) - 反应本机可重复使用和高效的拨号旋钮元素.
* [react-native-date ★46](https://github.com/nucleartux/react-native-date) - 适用于 Android 的 React Native 日期和时间选择器
* [react-native-draggable-drawer ★46](https://github.com/llanox/react-native-draggable-drawer) - React Native 的 DraggableDrawer 组件.
* [react-native-date-picker ★46](https://github.com/henninghall/react-native-date-picker) - 适用于 Android 和 iOS 的日期选择器组件
* [react-native-message-composer ★45](https://github.com/anarchicknight/react-native-message-composer) - React Native 模块桥接到 iOS MFMessageComposeViewController
* [react-native-layout ★45](https://github.com/jerolimov/react-native-layout) - 用于 react-native 的语义 JSX 布局组件
* [react-native-touch-visualizer ★45](https://github.com/zachgibson/react-native-touch-visualizer) - 在 iOS 的 React Native 应用程序上可视化触摸和拖动.
* [react-native-calendar-android ★44](https://github.com/chymtt/ReactNativeCalendarAndroid) - 一个简单的材料主题日历，用于反应本机 android
* [react-native-air-progress-bar ★44](https://github.com/kis/react-native-air-progress-bar) - React Native 进度条组件，可定制和动画
* [react-native-full-screen ★44](https://github.com/Anthonyzou/react-native-full-screen) - React Native FullScreen api 和元素
* [react-native-full-image-picker ★44](https://github.com/gaoxiaosong/react-native-full-image-picker) - 支持拍照、录像或从照片库中选择.
* [react-native-viewport ★43](https://github.com/pjjanak/react-native-viewport) - 反应本机的视口尺寸

* [react-native-progress-circular ★43](https://github.com/andy9775/React-Native-CircularProgress) - 用于 iOS 和 Android 的循环进度条的纯 React Native 组件.
* [react-native-tween-animation ★43](https://github.com/kirkness/react-native-tween-animation) - 一个简单的反应本机状态补间动画模块.
* [react-native-flanimatedimage ★43](https://github.com/nihgwu/react-native-flanimatedimage) - 用于 React Native 的 FLAnimatedImage.
* [react-native-grading ★43](https://github.com/Tinysymphony/react-native-grading) - 使用 ReactART 对分数进行评分的 React Native 组件.
* [react-native-auto-typing-text ★43](https://github.com/phuongla/react-native-auto-typing-text) - 用于 react-native 的自动输入文本组件
* [react-native-slack-webhook ★42](https://github.com/xcarpentier/react-native-slack-webhook) - 通过 Slack 和此 webhook 库从您的应用程序关注一些活动（新用户、付款等）.
* [react-native-responsive-linechart ★41](https://github.com/N1ghtly/react-native-responsive-linechart)  - 轻松绘制折线图和面积图. 反应灵敏.
* [react-native-simpledialog-android ★41](https://github.com/lucasferreira/react-native-simpledialog-android) - React Native Android 模块以使用 Android 的 AlertDialog - 与 AlertIOS 相同的想法
* [react-native-toolkit ★41](https://github.com/marty-wang/react-native-toolkit) - 用于反应本机移动应用程序的通用 UI 组件的集合.
* [react-native-draggable-grid ★41](https://github.com/SHISME/react-native-draggable-grid) - 由 typescript 编写的 React Native 可拖动和可排序网格组件.
* [react-native-sortable-gridview ★4](https://github.com/ge6285790/react-native-sortable-gridview) - 一个 React Native 可排序和可拖动的网格视图组件.
* [react-native-elastic-stack ★41](https://github.com/monterosalondon/react-native-elastic-stack) - 实现的 ReactNative 组件 [elastic stack effect](https://tympanus.net/Development/ElasticStack/)
* [react-native-big-slider ★41](https://github.com/netbeast/react-native-big-slider) - 另一个大的纯 JS 易于定制和破解的反应本机滑块组件.
* [react-native-custom-actsheet ★40](https://www.npmjs.com/package/react-native-custom-actsheet) - 用于 react-native 的自定义 ActionSheet
* [rn-render-perfs ★40](https://github.com/mfrachet/rn-render-perfs) - 使用 UI 控件测量 React 渲染生命周期
* [react-native-animated-check-mark ★40](https://github.com/AppliKeySolutions/RocketButton) - 用于动画十字标记转换的小型反应组件.
* [react-native-easy-dnd ★39](https://github.com/mohebifar/react-native-easy-dnd) - 用于反应本机的拖放组件
* [react-native-fab ★39](https://github.com/SiDevesh/React-Native-FAB) - 适用于 Android 和 iOS 的 FAB 按钮组件，可自定义，简单且符合材料设计规范.
* [react-native-popupwindow ★38](https://github.com/beefe/react-native-popupwindow) - 用于反应本机模块的 Android PopupWindow
* [react-native-wheel ★38](https://github.com/shexiaoheng/react-native-wheel) - android wheel view for react-native
* [react-native-bar-collapsible ★38](https://github.com/caroaguilar/react-native-bar-collapsible) - 可折叠（切换/手风琴）、可点击或纯文本的 Bar 组件.
* [react-native-circle-view ★37](https://github.com/nucleartux/react-native-circle-view) - 使用 CircleView 圈出反应本机 android 的进度
* [react-native-slidable-tab-bar ★37](https://github.com/pwbrown/react-native-slidable-tab-bar) - 用于即时视图渲染的可滑动标签栏（react-native）
* [react-native-scrollable-decorator ★37](https://github.com/exponentjs/react-native-scrollable-decorator) - 可滚动的 React Native 组件的标准接口，使组合组件更容易
* [react-native-circle-checkbox ★37](https://github.com/ParamoshkinAndrew/ReactNativeCircleCheckbox) - React Native 的圆形复选框组件
* [react-native-newsticker ★35](https://github.com/moschan/react-native-newsticker) - React Native 的 News Ticker 组件
* [react-native-awesome-alert ★35](https://github.com/heyman333/react-native-awesome-alert) - 在 React Native 中带有 ✔️check 选项的可定制模态组件
* [react-native-view ★34](https://github.com/i6mi6/react-native-view) - 用于快速样式化的轻量级视图组件.
* [react-native-draggable-calendar ★34](https://github.com/SmallStoneSK/react-native-draggable-calendar) - 支持拖动的日历组件.
* [react-native-countdown ★33](https://github.com/buhe/react-native-countdown) - 反应本机倒计时按钮
* [react-native-dashed-border ★33](https://github.com/chirag04/react-native-dashed-border) - 反应本机的元素
* [react-native-writebox ★33](https://github.com/bdryanovski/react-native-writebox) - (iOS / Android) 自动增长和计数字符的 Facebook/Twitter 文本区域.
* [react-native-ibeacon-simulator ★32](https://github.com/williamtran29/react-native-ibeacon-simulator) - React Native Library 来模拟设备充当 iBeacon
* [react-native-suggester ★32](https://github.com/xcarpentier/react-native-suggester) - React-Native 包来装饰 TextInput 并获得具有良好用户体验的建议.
* [react-native-photo-grid ★31](https://github.com/christopherabouabdo/react-native-photo-grid) - React Native 组件处理构建照片网格的复杂性，每行照片数量灵活.
* [react-native-android-iconify ★30](https://github.com/lwhiteley/react-native-android-iconify) - 使用 android-iconify 反应本机 android 的图标
* [react-native-touchable-set-active ★30](https://github.com/jmstout/react-native-TouchableSetActive)  - React Native 的可触摸组件，通过设置活动状态启用更高级的样式. 对于在其上构建您自己的可触摸/按钮组件最有用.
* [react-native-telephone-input ★30](https://github.com/kundigo/react-native-telephone-input) - React Native Telephone Input，发现国家和屏蔽电话输入
* [react-native-nmrangeslider-ios ★29](https://github.com/Enrise/react-native-nmrangeslider-ios) - React Native 的 NMRangeSlider 组件
* [react-native-fade-in-view ★29](https://github.com/robcalcroft/react-native-fade-in-view) - 一个简单轻量级的 RN 组件，在其子组件中消失
* [react-native-gl-image-filters ★27](https://github.com/GregoryNative/react-native-gl-image-filters) - 用于图像实现的 React Native GL 过滤器.
* [react-native-focus-scroll ★26](https://github.com/c-bata/react-native-focus-scroll) - react-native-focus-scroll 可以检测滚动时关注了哪些孩子.
* [react-native-about-libraries ★26](https://github.com/prscX/react-native-about-libraries) - React Native：它提供有关安装包的信息
* [react-native-actionsheet-native ★25](https://github.com/slowpath/react-native-actionsheet) - Android ActionSheet 支持 React Native
* [react-native-comparison-slider ★25](https://github.com/charlot567/react-native-comparison-slider) - 与滑盖功能相比显示两个图像的简单组件.
* [react-native-selectmultiple-button ★25](https://github.com/danceyoung/react-native-selectmultiple-button) - 一个按钮（或一组按钮）支持多选或单选
* [react-native-timeline-theme ★25](https://github.com/tomzaku/react-native-timeline-theme)  - 时间线主题的集合. 这个包只使用 flexbox（没有绝对）和 FlatList
* [react-native-date-range-picker ★25](https://github.com/lazaronixon/react-native-date-range-picker) - 从 react-native-calendars 扩展的简单日期范围选择器
* [react-native-circle-progress ★24](https://www.npmjs.com/package/react-native-circle-progress) - 用于 React Native 的自定义圆圈进度指示器
* [react-native-app-intro-v2 ★24](https://github.com/Sh1n1x/react-native-app-intro) - 最新的应用介绍
* [react-native-starrating ★24](https://github.com/bluesky0109/react-native-starRating) - 用于显示交互式星级的反应本机组件
* [react-native-echarts-wrapper ★24](https://github.com/tomLadder/react-native-echarts-wrapper) - 为 React Native 构建强大的 ECharts 包装器
* [react-native-orientation-controller ★23](https://github.com/inProgress-team/react-native-orientation-controller) - 用于获取和控制当前设备和应用程序方向的 react-native 库
* [react-native-match-media ★23](https://github.com/tuckerconnelly/match-media-mocks) - 用于 React Native 的 window.matchMedia 模拟
* [react-native-simple-card-view ★23](https://github.com/talut/react-native-simple-card-view) - 在屏幕上添加卡片视图的最简单方法.
* [monalisa-ui ★22](https://github.com/tuantvk/monalisa-ui) - MonalisaUI 是 React Native 的 UI 组件库，用于为 iOS 和 Android 平台构建原生移动应用程序
* [react-native-square-view ★22](https://github.com/Shuangzuan/react-native-square-view) - 用于反应本机的方形视图组件.
* [react-native-ichart ★22](https://github.com/AdonRain/react-native-ichart) - 用于反应本机的图表
* [react-native-dropbox-chooser ★21](https://github.com/tinycreative/react-native-dropbox-chooser) - React Native 保管箱选择器模块
* [react-native-compress ★21](https://github.com/phuochau/react-native-compress)  - 压缩视频以响应本机. 仅适用于 iOS，Android 即将推出.
* [react-native-custom-actionsheet ★21](https://github.com/valerybugakov/react-native-custom-actionsheet) - 用于 React Native 的完全可定制的 ActionSheet.
* [react-native-timepicker ★20](https://github.com/milasevicius/react-native-timepicker) - 适用于 iOS 的 React Native 时间选择器
* [react-native-custom-checkbox ★20](https://github.com/caroaguilar/react-native-custom-checkbox)  - 可以自定义的 React Native 复选框. 适用于 Android 和 iOS.
* [react-native-tilt ★20](https://github.com/psicotropicos/react-native-tilt) - React Native 组件的加速度计倾斜效果.
* [react-native-drawpad ★20](https://github.com/Partido-Asia/react-native-drawpad) - 供用户通过触摸绘图的垫子
* [rn-ab-hoc ★19](https://github.com/mfrachet/rn-ab-hoc) - 使用 HoC 而不是组件进行 A/B 测试的侵入式方法很差.
* [react-native-expand ★19](https://github.com/hejiaji/react-native-expand) - 适用于 Android 和 iOS 的 react-native 可扩展组件
* [react-native-modal-loader ★19](https://github.com/kdastan/react-native-modal-loader) - 用于 React 应用程序的可定制动画模式进度 HUD.
* [react-native-images-collage ★19](https://github.com/lukebrandonfarrell/react-native-images-collage) - 用于 React Native 的强大交互式图像拼贴组件.
* [react-native-avatar-gravatar ★18](https://github.com/niborb/react-native-gravatar) - React Native Gravatar 组件
* [react-native-image-modal ★16](https://github.com/dev-yakuza/react-native-image-modal)  - 适用于 iOS 和 Android 的简单全尺寸模态图像. 支持放大/缩小、双击放大/缩小、移动和滑动关闭
* [react-native-notifier ★16](https://github.com/seniv/react-native-notifier) - 用于 React Native 的快速简单的应用内通知
* [react-native-grid ★15](https://github.com/thewei/react-native-grid) - react-native 的 24 列网格组件
* [react-native-search ★15](https://github.com/StevenIseki/react-native-search) - 用于反应本机的本机搜索组件.
* [rn-displayable ★15](https://github.com/mfrachet/rn-displayable) - 根据道具或一组规则显示您的组件
* [react-native-custom-picker ★15](https://github.com/budiadiono/react-native-custom-picker) - 反应本机可定制的选择器组件.
* [react-native-confirmation-code-field ★15](https://github.com/retyui/react-native-confirmation-code-field) - 一个React Native组件，用于输入Android和IOS的确认码
* [react-native-android-circles ★14](https://github.com/kwaak/react-native-android-circles) - 一个反应本机 android 包来显示一个圆形进度视图.
* [react-native-anchor-point ★14](https://github.com/sueLan/react-native-anchor-point) - 让精美的 3D 转换在 React Native 中更容易
* [react-native-code-verification ★13](https://github.com/danchokobo/react-native-code-verification) - 用于用户端密码验证的 UI 模块.
* [react-native-hijri-date-picker ★13](https://github.com/Codelabsys/react-native-hijri-date-picker-android) - Android 回历日历的日期选择器对话框.
* [react-native-imagewand ★13](https://github.com/NorthFoxz/react-native-imagewand) - 用于反应本机的图像棒
* [react-native-gravatar ★13](https://github.com/lwhiteley/react-native-gravatar) - 用于 gravatar-api 的 react-native 包装器
* [react-native-rebound-scrollview ★12](https://github.com/jaxchow/react-native-rebound-scrollview) - React Native Android ReboundScrollView 实现.
* [react-native-calculator ★12](https://github.com/budiadiono/react-native-calculator) - React Native 计算器和计算器输入组件.
* [react-native-navbar-color ★12](https://github.com/BhavanPatel/react-native-navbar-color) - 在 Android 中更改导航栏颜色
* [radio-buttons-react-native ★11](https://github.com/sramezani/radio-buttons-react-native) - 用于反应本机的动画单选按钮组件
* [react-native-piechart ★10](https://github.com/frostney/react-native-piechart) - 用于 React Native 的组件
* [react-native-seekbar-android ★10](https://github.com/DispatcherInc/react-native-seekbar-android) - 一个 React Native 包装器 Android 的 SeekBar
* [react-native-coachmasks ★10](https://github.com/TranLuongTuanAnh/react-native-coachmasks)  - 反应本机教练标记！ 它可以帮助您轻松创建 Coach Marks 以增强用户体验！
* [react-native-progress-button ★10](https://github.com/xinghui0000/react-native-progress-button) - 一个可以显示进度的反应本机按钮组件.
* [react-native-quiltview ★9](https://github.com/mmslate/react-native-quiltview) - 带有用于 React Native 的 RFQuiltLayout 的原生 iOS UICollectionView 包装器
* [react-native-relative-units ★9](https://github.com/benzhe/react-native-relative-units) - React Native 的相对单位
* [react-native-simple-button ★9](https://github.com/remobile/react-native-simple-button) - 一个简单的反应本机按钮
* [react-native-styled-toast ★9](https://github.com/jeanverster/react-native-styled-toast) - 用于 React Native 的主题吐司组件.
* [react-native-frame-loading ★9](https://github.com/heyman333/react-native-frame-loading) - 带有逐帧视图动画的加载指示器
* [react-native-rheostat ★9](https://github.com/DrChai/react-native-rheostat) - 灵感来自 Airbnb [rheostat](https://github.com/airbnb/rheostat)，一个功能强大的滑块，带有各种数据可视化图表.
* [react-native-country-picker ★8](https://github.com/tofugear/react-native-country-picker) - React Native Country Picker
* [react-native-flex-label ★8](https://github.com/eccolabs/react-native-flex-label) - 一个用于 React Native 的文本标签，它处理多行带有省略号截断的文本以及它的视图容器中的垂直对齐.
* [react-native-link ★8](https://github.com/650Industries/react-native-link) - 链接组件
* [react-native-stylesheet-xg ★8](https://github.com/xgfe/react-native-stylesheet-xg) - 跨平台和响应式扩展样式表
* [react-native-bouncing-ball ★8](https://github.com/hankzhuo/react-native-bouncing-ball) - 适用于 iOS 和 Android 的 React Native 组件弹跳球.
* [react-native-loading ★7](https://github.com/alcat2008/react-native-loading) - 为您的 React Native 应用程序轻量级加载.
* [react-native-segment-control ★7](https://github.com/ainurb/react-native-segment-control) - 用于 React Native 应用程序的可滑动 SegmentedControl 组件.
* [react-native-animated-styles ★7](https://github.com/ericpkerr/react-native-animated-styles) - 轻松动画/过渡两种样式状态之间的反应组件.
* [react-native-hide-modal ★6](https://github.com/heyman333/react-native-hide-modal) - 可以隐藏的模态组件
* [react-native-hole-view ★6](https://github.com/ibitcy/react-native-hole-view)  - 用于在任何视图中切出点击孔的组件. 非常适合制作类似教程的叠加层
* [react-native-masonry-brick-list ★5](https://github.com/lvlrSajjad/react-native-masonry-brick-list) - 纯 js 编写的 React Native 的交错或砌体列表视图
* [react-native-blur-overlay ★5](https://github.com/lvlrSajjad/react-native-blur-overlay) - 适用于 Ios 和 Android 的 React Native Blur Overlay 库
* [react-native-rate-modal ★5](https://github.com/omergulen/react-native-rate-modal) - 用于 React Native 的可破解的“评价我们”组件.
* [react-native-fancy-carousel-viewpager ★4](https://github.com/lvlrSajjad/react-native-fancy-carousel-viewpager) - React Native 设计的 View Pager 库（纯 js）
* [pinar ★4](https://github.com/kristerkari/pinar) - 具有辅助功能支持的可定制、轻量级 React Native 轮播组件.
* [react-native-svg-transformer ★4](https://github.com/kristerkari/react-native-svg-transformer)  - 在 React Native 组件中导入 SVG 文件. 使用 react-native-svg 库渲染 SVG 图像.
* [react-native-progress-steps ★4](https://github.com/colbymillerdev/react-native-progress-steps) - 一个简单且完全可定制的 React Native 组件，可实现进度步进器 UI.
* [react-native-loader-hud ★3](https://github.com/EdgeJay/react-native-loader-hud) - React Native 的 Loader 动画库
* [react-native-double-buffer ★3](https://github.com/alinz/react-native-double-buffer) - 简单的 React Native 双缓冲视图
* [react-native-fontbase ★3](https://github.com/frostney/react-native-fontbase) - 在 React Native 中定义字体大小
* [react-native-units ★2](https://github.com/alexfoxy/react-native-units) - React Native 中用于响应式布局的有用单元和简单网格实现的集合.
* [react-native-easy-checkbox ★2](https://github.com/BhavanPatel/react-native-easy-checkbox) - 用于反应本机的简单复选框
* [react-native-scene-manager ★2](https://github.com/alinz/react-native-scene-manager) - React-Native 的简单场景管理器
* [react-native-rounded-navigation-drawer ★2](https://github.com/lvlrSajjad/react-native-rounded-navigation-drawer) - React Native 设计的导航抽屉库（纯 Js）
* [react-native-expandable-fab-menu ★2](https://github.com/lvlrSajjad/react-native-expandable-fab-menu) - React Native 可扩展 Fab 菜单组件（纯 js）
* [react-native-animated-bottom-tabbar ★2](https://github.com/lvlrSajjad/react-native-animated-bottom-tabbar) - 用于反应本机的动画底部标签栏
* [react-native-create-new-file-ios ★1](https://github.com/rhaker/react-native-create-new-file-ios)  - 用于在 ios 上创建空白新文件的 react-native 界面. 文件必须不存在.
* [react-native-picker-module ★1](https://github.com/talut/react-native-picker-module) - React Native Picker 的另一种方法.
* [react-native-countries ★1](https://github.com/talut/react-native-countries) - 此软件包直接为您提供来自设备的本国名称和代码列表.
* [react-native-scrubber ★1](https://github.com/repodio/react-native-scrubber/tree/master) - 适用于 iOS 和 Android 的简单音频/视频洗涤器.
* [react-native-loader-kit ★1](https://github.com/maitrungduc1410/react-native-loader-kit) - React Native 的纯原生加载动画.
* [react-native-new-feature ★1](https://github.com/maitrungduc1410/react-native-new-feature) - 一个简单轻量级的 What&#39;s New 组件，用于展示您最新的 React 本机功能.
* [react-native-sdr](https://github.com/i6mi6/react-native-sdr) - React Native 的服务器驱动渲染 (SDR) 组件
* [react-native-store-view ★19](https://github.com/rh389/react-native-store-view) - 包装 SKStoreProductViewController 以用于本机反应项目
* [react-native-image-container ★0](https://github.com/frostney/react-native-image-container) - React Native 的图像容器
* [react-native-counters ★0](https://github.com/yasaricli/react-native-counters) - React Native 的减号计数器
* [react-native-gradient-buttons](https://github.com/thomaswangio/react-native-gradient-buttons) - 用于 React Native 的轻量级、可定制和触觉渐变按钮组件.
* [react-native-auth-screens](https://github.com/thomaswangio/auth-screens)  - React Native 的一系列身份验证视图：登录、社交登录注册和忘记密码. 使用 `react-native-gradient-buttons`.
* [react-native-animated-flatlist](https://github.com/shakogegia/react-native-animated-flatlist) - React Native 的动画平面列表.
* [swipeable-modal-react-native](https://github.com/bzurkow/swipeable-modal-react-native) - 可以向左或向右滑动以运行不同功能的“弹出式”模式.
* [react-native-countdown-text](https://github.com/realKfiros/react-native-countdown-text) - 一个 React Native 组件，可根据格式将未来日期的时间戳转换为可读的倒计时时钟.
* [rn-actionsheet-module ★0](https://github.com/talut/rn-actionsheet-module) - BottomsheetDialog 和 ActionSheetIOS 具有相同的道具和用法.
* [react-native-animated-loader](https://github.com/vikrantnegi/react-native-animated-loader) - 一个 React Native Loader 组件，它使用 Airbnb 的 Lottie 来制作漂亮的加载器动画.
* [rn-verifcode](https://github.com/xcarpentier/rn-verifcode) - React-Native 组件为安卓和IOS输入确认码
* [react-native-picker-modal-view](https://github.com/pankod/react-native-picker-modal-view) - 反应本机模块以选择项目选择器模式.
* [rn-material-textinput](https://github.com/akshit5230/React-Native-Material-TextInput) - 一个简单的 TextInput 包装器，用于 iOS 和 Android 中的材料样式，具有可自定义的样式和动画标签.
* [rn-action-picker](https://github.com/akshit5230/rn-action-picker)  - 适用于 iOS 和 Android 的简单操作选择器. 在 iOS 中呈现本机 ActionSheetIOS 组件，在 Android 中呈现自定义 ActionSheet 相似组件.
* [rn-collapsible-section](https://github.com/akshit5230/React-Native-Collapsible-Section)  - 可折叠的部分/部分列表，带有可定制的部分正文和子正文. 同时支持 iOS 和安卓.
* [view-on-steroids](https://github.com/vko-online/pane) - 具有内联样式的 React-Native View 组件
* [react-native-eva-icons](https://github.com/artyorsh/react-native-eva-icons) - [Eva Icons](https://github.com/akveo/eva-icons) 基于 react-native-svg 元素的 React Native 实现.
* [react-native-dots-pagination ★3](https://github.com/tsepeti/react-native-dots-pagination) - React Native 的简单点分页.
* [react-native-gesture-detector](https://github.com/mxmzb/react-native-gesture-detector) - 在 React Native 上轻松创建和检测自定义的复杂手势.
* [react-native-scrollview-header ★5](https://github.com/weifxn/react-native-scrollview-header) - 在滚动时从透明背景过渡到不透明的动画 ScrollView 标题.
* [react-native-wizard](https://github.com/talut/react-native-wizard)  - 轻松导航您的用户以进行下一步. 快速成型向导组件.
* [react-native-timetable](https://github.com/gomjellie/react-native-timetable) - React Native 的时间表库
* [react-native-material-drawer](https://github.com/codypearce/react-native-material-drawer) - React Native Material Drawer 适用于 iOS、Android、Web 和 Electron

### Navigation

* [react-navigation ★14233](https://github.com/react-community/react-navigation) - 易于使用的 React Native 导航
* [react-native-navigation ★9325](https://github.com/wix/react-native-navigation) - 应用程序范围内支持 100% 本机导航，具有简单的跨平台界面.
- [react-native-navigation-hooks ★109](https://github.com/underscopeio/react-native-navigation-hooks) - 一组用于 React Native Navigation 的 React 挂钩.
* [react-native-router-flux ★7720](https://github.com/aksonov/react-native-router-flux) - 基于新的 React Native Navigation API 的 React Native Router
* [kittenTricks ★4227](https://github.com/akveo/kittenTricks) - 具有 40 多个屏幕和主题热重载支持的 React 本机移动入门套件
* [native-navigation ★3060](https://github.com/airbnb/native-navigation) - React Native 应用程序的本地导航库
* [react-native-navbar ★1824](https://github.com/Kureev/react-native-navbar) - 用于反应本机的简单可定制导航栏组件
* [react-native-router ★1203](https://github.com/t4t5/react-native-router) - 为您的本机应用程序提供很棒的导航.
* [ex-navigation ★1019](https://github.com/exponentjs/ex-navigation) - 一个以路线为中心、包含电池的导航库，适用于 Exponent 和 React Native，可在 Android 和 iOS 上无缝运行.
* [react-native-controllers ★580](https://github.com/wix/react-native-controllers) - 真正原生的不妥协的 iOS 导航，适用于 React Native.
* [ex-navigator ★531](https://github.com/exponentjs/ex-navigator) - 建立在 React Native 的 Navigator 之上的以路线为中心的导航
* [react-native-nav ★262](https://github.com/jineshshah36/react-native-nav) - 跨平台（iOS / Android），完全可定制的 React Native Navigation Bar 组件
* [react-native-navigation-drawer ★98](https://github.com/ilansas/react-native-navigation-drawer) - 受 Android for React-Native 启发的滑动菜单
* [react-native-ya-navigator ★88](https://github.com/xxsnakerxx/react-native-ya-navigator) - 另一个反应本机导航器组件
* [navbar-native ★86](https://github.com/redbaron76/navbar-native) - 用于 React-Native 的全新、完全可定制的 Navbar 组件
* [react-native-swiper-flatlist ★★ ★81](https://github.com/gusgard/react-native-swiper-flatlist) - 使用 FlatList 实现的 React Native Swiper 组件
* [react-native-easy-router ★78](https://github.com/sergeyshpadyrev/react-native-easy-router) - 具有易于使用的 API 的 React Native 路由器
* [react-native-navigator ★74](https://github.com/thewei/react-native-navigator) - 一个用于 React Native 的简单路由器
* [react-navigation-magic-move ★62](https://github.com/IjzerenHein/react-navigation-magic-move) - 结合使用 react-navigation 和 react-native-magic-move ✨（共享元素转换）
* [react-native-navigation-bar ★59](https://github.com/beefe/react-native-navigation-bar) - 反应本机导航栏
* [react-native-url-handler ★37](https://github.com/exponentjs/react-native-url-handler) - 导航到外部 URL、处理应用内 URL 和访问系统 URL
* [react-native-grid-list ★ ★28](https://github.com/gusgard/react-native-grid-list) - React Native 网格列表组件
* [react-native-route-navigator ★27](https://github.com/Andr3wHur5t/react-native-route-navigator) - 使用 URI 的 React-Native 页面导航.
* [react-native-transparent-bar ★16](https://github.com/23c/react-native-transparent-bar) - 反应本机导航器透明栏
* [react-native-email-chip ★8](https://github.com/arelstone/react-native-email-chip) - 一个简单但可自定义的组件，用于显示电子邮件的芯片列表
* [react-native-invoke-app ★8](https://github.com/vicke4/react-native-invoke-app) - 将 React Native App 从 Headless JS 带到前台
* [react-native-keyboard-sticky-view ★7](https://github.com/melihberberolu/React-Native-Keyboard-Sticky-View) - 带动画和 renderProps 的键盘粘性视图
* [sajjad-brick-list ★5](https://github.com/lvlrSajjad/sajjad-brick-list) - 纯 js 编写的 React Native 的交错或砌体列表视图
* [react-native-router-sinux ★ ★4](https://github.com/jbpin/react-native-router-sinux) - React Native Router 基于使用 Sinux 作为 Flux 实现的新 NavigationExperimental.
* [react-native-simple-slider ★3](https://github.com/NesChaiyapon/react-native-simple-slider) - 这是一个简单的 javascript 滑块组件，用于响应本机
* [react-native-header-scroll-view ★3](https://github.com/jonsamp/react-native-header-scroll-view) - iOS 风格的大标题滚动视图.
* [react-native-navigation-buttons ★2](https://github.com/shayne/react-native-navigation-buttons) - React Native Navigator 的 iOS 导航按钮
* [react-native-hotspot ★2](https://github.com/lawnstarter/react-native-hotspot) - 一个 React Native 组件，它在所需组件上显示热点，以帮助引导您的用户完成入门流程或将他们引导到新的 UI 元素
* [react-native-pointer-interactions ★2](https://github.com/thefunbots/react-native-pointer-interactions) - 将 iPad 鼠标和触控板交互暴露给 React Native. 
* [react-native-yynavigator ★1](https://github.com/yiyangest/react-native-yynavigator) - 反应本机的自定义导航栏
* [react-native-telegraph ★1](https://github.com/robertherber/react-native-telegraph) - 支持 Snackbars、横幅和对话框的应用内消息编排


#### Navigation/Routing Articles

* [Basics of using react-native-router-flux](https://medium.com/@spencer_carli/react-native-basics-using-react-native-router-flux-f11e5128aff9#.di5mvrbdr)
* [Routing and Navigation in React Native](http://blog.paracode.com/2016/01/05/routing-and-navigation-in-react-native/)
* [NavigatorIOS: Accessing onRightButtonPress from within child component](https://github.com/facebook/react-native/issues/31)

#### Navigation Demos

* [movieapp ★1441](https://github.com/JuneDomingo/movieapp) – 发现电影和电视节目 - 它使用 redux 和 wix/react-native-navigation
* [ExNavRelay ★23](https://github.com/sibelius/ExNavRelay) - React Native + Ex-navigation + Relay 集成模板
* [React Native Drawer & Bottom-Tab Navigation ★6](https://github.com/tassdr/react-native-template)
* [React Native Example App: Navigation](http://tech.taskrabbit.com/blog/2015/09/21/react-native-example-app/)

### Deep Linking

* [react-native-deep-link ★36](https://github.com/Starotitorov/react-native-deep-link) - React Native 库来处理深层链接


* [react-native-hyperlink ★354](https://github.com/obipawan/hyperlink)  - 一个`<Hyperlink />  ` 使 url、模糊链接、电子邮件等可点击和样式化的 react-native 组件
* [react-native-draftjs-render ★253](https://github.com/globocom/react-native-draftjs-render) - 用于 Draft.js 模型的 React Native 渲染
* [react-native-html-to-pdf ★171](https://github.com/christopherdro/react-native-html-to-pdf) - 使用 React Native 将 html 字符串转换为 PDF 文档
* [react-native-htmltext ★132](https://github.com/siuying/react-native-htmltext) - 使用 HTML 之类的标记在 react-native 中创建风格化的文本.
* [react-native-html-webview ★102](https://github.com/almost/react-native-html-webview) - 在 React Native 中使用 UIWebView 显示（可能不受信任的）HTML.
* [react-native-html-render ★98](https://github.com/soliury/react-native-html-render) - 用于 react-native 的 html 渲染
* [react-native-markdown-display ★57](https://github.com/iamacup/react-native-markdown-display/) - 高度可定制的 Markdown 渲染器，其所有元素均使用本机组件，无需任何 Web 视图.
* [react-native-measure-text ★48](https://github.com/airamrguez/react-native-measure-text) - 无需布局即可测量文本高度.
* [react-native-markdown-editor ★47](https://github.com/kunall17/react-native-markdown-editor) - Markdown 编辑器，如 github 评论编辑器（包含预览、Markdown 按钮）
* [react-native-showdown ★43](https://github.com/jerolimov/react-native-showdown) - 将 markdown 渲染到 webview 中的 React-native 组件！
* [react-native-file-viewer ★33](https://github.com/vinzscam/react-native-file-viewer) - 预览移动设备支持的任何类型的文件
* [react-native-responsive-fontsize ★22](https://github.com/heyman333/react-native-responsive-fontsize) - 在 React-Native 中提供基于设备高度的响应式字体大小
* [react-native-text-size ★21](https://github.com/aMarCruz/react-native-text-size) - 在布局之前准确测量文本并从您的应用程序获取字体信息.
* [react-native-hypertext ★20](https://github.com/agentcooper/react-native-hypertext) - React Native 模块呈现超文本（带链接的文本）
* [react-native-asciimage ★17](https://github.com/turley/react-native-asciimage) - 用于 React Native 的 ASCIImage 组件
* [react-native-universal-modal ★16](https://github.com/bokuweb/react-native-universal-modal) - 用于 React Native 的通用简单模态组件
* [react-native-html ★11](https://github.com/turingou/react-native-html) - 将 html 呈现为反应本机自定义元素
* [react-native-responsive-fontsize ★83](https://github.com/heyman333/react-native-responsive-fontsize) - 在 React-Native 中提供基于设备高度的响应式字体大小
* [rn-pdf-reader-js ★6](https://github.com/xcarpentier/rn-pdf-reader-js/blob/master/README.md) - PDF 阅读器，仅使用 JavaScript，适用于 Expo，支持 Android，PDF.JS
* [@typeskill/typer ★4](https://github.com/typeskill/typer) - 基于操作转换（React）的原生富文本库

### Analytics

* [react-native-fabric ★1097](https://github.com/corymsmith/react-native-fabric) - 用于 Fabric、Crashlytics 和 Answers 的 React Native 库
* [react-native-google-analytics-bridge ★1071](https://github.com/idehub/react-native-google-analytics-bridge)  - 用于 React Native 的原生 Google Analytics 桥. 在 iOS 和 Android 上使用官方库.
* [react-native-google-analytics ★325](https://github.com/lwansbrough/react-native-google-analytics) - 用于 React Native 的谷歌分析！
* [react-native-mixpanel ★307](https://github.com/davodesign84/react-native-mixpanel) - 用于 Mixpanel 跟踪的 React Native 包装器
* [react-native-ab ★160](https://github.com/lwansbrough/react-native-ab) - 用于在 React Native 中呈现 A/B 测试的组件
* [react-native-segment-io-analytics ★68](https://github.com/smore-inc/react-native-segment-io-analytics) - 一个 React Native Segment 包装器！
* [react-native-ux-cam ★32](https://github.com/negativetwelve/react-native-ux-cam) - 用于 uxcam.com 的 React Native 包装器.
* [react-native-td ★26](https://github.com/quipper/react-native-td) - 用于 Treasure Data 的非官方 React Native SDK.
* [react-native-flurry-sdk ★15](https://github.com/flurry/react-native-flurry-sdk)  - Flurry SDK 的官方 React Native 包装器. 支持安卓、iOS 和 tvOS.

### Utils & Infra

* [detox ★3566](https://github.com/wix/detox) - Graybox 端到端（功能）测试和移动自动化库，具有对 React Native 的一流支持
* [react-native-workers ★616](https://github.com/devfd/react-native-workers) - react-native 的后台服务和网络工作者
* [react-native-mock ★504](https://github.com/RealOrangeOne/react-native-mock) - 一个完全模拟和测试友好的 React Native 版本
* [loki ★395](https://github.com/oblador/loki) - 故事书的视觉回归测试
* [react-native-slowlog ★271](https://github.com/jondot/react-native-slowlog) - 用于 React Native 的基于计时器的高性能分析器，可帮助您跟踪重大性能问题
* [react-native-zip-archive ★173](https://github.com/plrthink/react-native-zip-archive) - 压缩/解压缩存档实用程序
* [react-native-tips ★160](https://github.com/frichti/react-native-tips) - 此模块用于轻松创建一些提示，以帮助您的新用户了解您的应用程序的工作原理.
* [codemod-RN24-to-RN25 ★104](https://github.com/sibeliusseraphini/codemod-RN24-to-RN25) - 一个简单的 codemod 来处理 &gt;=RN25 上的新导入样式
* [react-native-linkedin ★101](https://github.com/xcarpentier/react-native-linkedin) React-Native LinkedIn，一个简单的 LinkedIn 登录库，用于带有 WebView 和 Modal 的 React-Native 或 Expo
* [react-native-eval ★75](https://github.com/artemyarulin/react-native-eval) - 从您的本机代码调用任何 JS 函数
* [react-native-device-log ★73](https://github.com/olofd/react-native-device-log) - 用于在设备上显示开发日志的 UI 和服务.
* [react-native-call-detection ★73](https://github.com/priteshrnandgaonkar/react-native-call-detection) - 有助于检测不同的呼叫状态，如传入、断开、拨号和连接
* [react-native-userdefaults-ios ★66](https://github.com/dsibiski/react-native-userdefaults-ios) - NSUserDefaults 的 React Native 模块
* [react-native-webp ★56](https://github.com/dbasedow/react-native-webp) - react-native-webp 为 react-native 组件添加了对 WebP 图像的支持.
* [react-native-global-event-emitter ★50](https://github.com/paramaggarwal/react-native-global-event-emitter) - 用于 React Native 的本机和 JS 之间的共享事件发射器.
* [react-native-user-defaults ★48](https://github.com/wwayne/react-native-user-defaults) - 本机使用的 ios UserDefaults
* [react-native-console-time-polyfill ★45](https://github.com/MaxGraey/react-native-console-time-polyfill) - console.time 和 console.timeEnd 用于 react-native 的 polyfill
* [react-native-aws-signature ★42](https://github.com/leimd/react-native-aws-signature)  - 帮助生成使用 AWS API 所需的签名. 使用 S3、ec2 或其他服务所必需的.
* [react-native-rsa ★41](https://github.com/z-hao-wang/react-native-rsa) - 用于本机反应的 RSA 加密库
* [react-native-html-parser ★38](https://github.com/g6ling/react-native-html-parser) - 在 react-native 中解析 html
* [pixels-catcher ★26](https://github.com/rumax/react-native-PixelsCatcher) - 用于测试 React Native UI 组件和屏幕的库
* [react-native-aes ★24](https://github.com/mvayngrib/react-native-aes) - 反应本机中的 AES
* [react-native-network-logger ★20](https://github.com/alexbrazier/react-native-network-logger) - 用于 React Native 的 HTTP 网络请求监视器，包括应用程序内界面.
* [eslint-config-kingstinct-react-native ★23](https://github.com/robertherber/eslint-config-kingstinct-react-native) - 针对 React Native 和 TypeScript 的自以为是的 ESLint 配置
* [react-native-hour-format ★20](https://github.com/SoftwareMansion/react-native-hour-format) - 从操作系统设置中获取小时格式.
* [react-native-des ★20](https://github.com/remobile/react-native-des) - 一个 des crypto for react-native
* [react-native-babel-jest ★15](https://github.com/apentle/react-native-babel-jest) - 带有 Jest 的 React Native 的简单测试配置
* [react-native-simple-encryption ★14](https://github.com/BhavanPatel/react-native-simple-encryption) - react-native的简单异或和base_64加密解密
* [react-native-immutable ★12](https://github.com/thewei/react-native-immutable) - 将 immutable.js 库与 react-native 结合使用
* [react-native-util ★12](https://github.com/exponentjs/react-native-util) - 与 React Native 一起使用的 io.js util 模块的分支
* [react-native-referrer ★11](https://github.com/JeandeCampredon/react-native-referrer) - React Native android only library 来检索活动引荐来源网址.
* [react-native-webpackager-server ★6](https://github.com/changfuguo/react-native-webpackager-server) - 反应本机 webpackager 服务器
* [react-native-crypto ★6](https://github.com/mvayngrib/react-native-crypto) - 为 React Native 实现加密
* [react-native-fluxbone ★5](https://github.com/jgable/react-native-fluxbone) - 一组有助于 React Native 中的 FluxBone 模式的库
* [react-native-cross-settings ★5](https://github.com/aMarCruz/react-native-cross-settings) - 适用于 Android 和 iOS 的 React Native 设置模块.
* [react-native-HsvToRgb ★3](https://github.com/Copypeng/react-native-HsvToRgb) - 将 HSV(HSB) 颜色转换为 RGB 的助手.
* [react-native-use-persist-storage ★3](https://github.com/visuallylab/react-native-use-persist-storage) - 使用 React Hooks 保持和补充你的上下文（状态）
* [react-native-tools ★0](https://github.com/kkennis/react-native-tools) - React Native 项目开发工具
* [react-native-call-observer](https://github.com/liamse/react-native-call-observer) - 帮助观察呼叫状态，如传入、结束和连接 (iOS).
* [react-native-iphone-se-helper ★0](https://github.com/heyman333/react-native-iphone-se-helper) - 用于开发 iphone SE 尺寸的实用程序.
* [react-native-native-log ★0](https://github.com/JessicaYeh/react-native-native-log) - 在后台调用本机日志的 React Native 日志功能.
* [react-native-mov-to-mp4 ★44](https://github.com/taltultc/react-native-mov-to-mp4) - 用于将 mov 文件转换为 mp4 以实现跨平台播放兼容性的实用程序.
* [react-native-test-runner ★1](https://github.com/acostalima/react-native-test-runner) - 在 React Native 的环境中运行单元和集成测试.

### Forms

* [formik ★10633](https://github.com/jaredpalmer/formik) - React 中的表单，没有眼泪.
* [react-hook-form ★9346](https://github.com/react-hook-form/react-hook-form) - React hooks 用于表单验证，没有麻烦.
* [redux-form ★4829](http://redux-form.com) - Redux 表单状态管理（Web 和 Native）
* [redux-hook-form ★2700](https://github.com/react-hook-form/react-hook-form)  - React 挂钩可轻松进行表单验证.  （网络和本机）
* [tcomb-form-native ★2831](https://github.com/gcanti/tcomb-form-native) - 生成 React Native 表单
* [react-native-gifted-form ★1317](https://github.com/FaridSafi/react-native-gifted-form) - react-native 的表单组件
* [react-native-clean-form ★414](https://github.com/esbenp/react-native-clean-form)  - 具有 redux-form 集成的美观表单元素. 带有样式组件的样式.
* [react-native-form-generator ★354](https://github.com/MichaelCereda/react-native-form-generator) - 轻而易举地生成惊人的 React Native 表单
* [react-native-form ★138](https://github.com/julianocomg/react-native-form) - 一个简单的反应本机组件来包装您的表单字段！
* [react-reactive-forms ★106](https://github.com/bietkul/react-reactive-form) - Angular 像 React 中的反应形式.
* [react-native-forms ★86](https://github.com/michaelhelvey/react-native-forms) - 用于创建、验证和序列化原生形式的声明式 API.
* [react-native-formawesome](https://github.com/MAKARD/react-native-formawesome) - Complex and simple forms builder.
* [react-native-from-builder ★69](https://github.com/bietkul/react-native-form-builder) - 以巧妙的方式处理您的表格.
* [foect ★37](https://github.com/unexge/foect) - React Native 的简单表单验证库
* [react-native-fm-form ★13](https://github.com/peter4k/react-native-fm-form) - 只需几行代码即可生成 React Native 的列表视图形式
* [react-native-form-flux ★2](https://github.com/aksonov/react-native-form-flux) - 使用 Flux 架构的 React Native Form 管理
* [react-native-form-validator ★0](https://github.com/srfaytkn/react-native-form-validator) - 一个简单的 React Native 验证库

### Geolocation

* [react-native-background-geolocation ★1316](https://github.com/transistorsoft/react-native-background-geolocation) - 复杂的跨平台后台位置跟踪和地理围栏模块，具有电池感知型运动检测智能（Android 需要付费许可）.
* [react-native-mauron85-background-geolocation ★657](https://github.com/mauron85/react-native-background-geolocation) - React Native Android 和 iOS 模块用于后台和前台地理定位，具有省电的“圆形区域监控”和“停止检测”
* [react-native-geocoder ★344](https://github.com/devfd/react-native-geocoder) - 反应本机地理编码和反向地理编码
* [react-native-geo-fencing ★100](https://github.com/surialabs/react-native-geo-fencing) - 使用 Google Geometry 库确定位置是否在定义的地理边界内的本机模块
* [react-native-fused-location ★82](https://github.com/MustansirZia/react-native-fused-location) - 使用新的 Fused API 在 Android 上进行本机反应的最佳位置.
* [react-native-android-geolocation ★19](https://github.com/garysye/react-native-android-geolocation) - React Native 模块通过 Google Play API 使用 Android Geolocation
* [react-native-reverse-geo ★18](https://github.com/aaronksaunders/react-native-reverse-geo) - React Native 模块桥将地址转换为地理坐标.
* [react-native-boundary ★12](https://github.com/eddieowens/react-native-boundary)  - React Native 模块使用地理围栏.  iOS 和 Android 的本机实现.
* [react-native-geolocation-android ★3](https://github.com/lxsameer/react-native-geolocation-android) - 用于反应本机android的地理定位模块

### Internationalization

* [fbt ★3202](https://github.com/facebookincubator/fbt) - 一个 JavaScript 国际化框架
* [react-native-localize ★603](https://github.com/react-native-community/react-native-localize) - React Native 本地化
* [react-native-globalize ★192](https://github.com/joshswan/react-native-globalize) - React Native 的全球化助手

* [redux-react-native-i18n ★40](https://github.com/derzunov/redux-react-native-i18n) - Redux 上 React Native 应用程序的国际化解决方案
* [react-native-intl ★37](https://github.com/taggon/react-native-intl) - React Native 模块提供了本地 Intl 实现和翻译扩展
* [rn-translate-template ★18](https://github.com/hiaw/rn-translate-template) - 适用于所有 iOS 和 Android 支持语言的 I18n 模板
* ~~[react-native-i18n ★1778](https://github.com/AlexanderZaytsev/react-native-i18n) - React Native + i18n.js ~~ 已弃用 react-native-localize
* ~~[react-native-languages ★246](https://github.com/react-community/react-native-languages) - 与设备语言相关的 React Native 属性和方法~~ 现在称为 react-native-localize

### Build & Development

* [reactotron ★9198](https://github.com/skellock/reactotron) - 从您的终端舒适地控制、监控和检测您的 React Native 应用程序.
* [react-native-code-push ★5184](https://github.com/Microsoft/react-native-code-push) - 用于 CodePush 服务的 React Native 插件
* [react-native-webpack-server ★935](https://github.com/mjohnston/react-native-webpack-server) - 使用 Webpack 构建 React Native 应用程序
* [generator-rn-toolbox ★800](https://github.com/bamlab/generator-rn-toolbox) - Yeoman 生成器来启动您的项目并设置持续部署.
* [babel-preset-react-native-stage-0 ★97](https://github.com/skevy/babel-preset-react-native-stage-0) - 带有最新 Javascript 功能的 Babel 预设
* [react-native-debug-stylesheet ★75](https://github.com/brentvatne/react-native-debug-stylesheet) - 为所有视图添加彩色边框或背景，以便更轻松地调试布局问题
* [react-native-console-panel ★73](https://github.com/sospartan/react-native-console-panel) - 反应本机组件以显示控制台消息.
* [react-native-css-loader ★39](https://github.com/thewei/react-native-css-loader) - 您可以将react-native-css-loader 与react-native-webpack-server 一起使用，它可以使用webpack 更好地构建react-native 应用程序.
* [react-native-assets ★31](https://github.com/llanox/react-native-assests)  - 管理资产的模块. 它允许您从网络下载资产并存储到 iOS 上的特定本地文件夹中
* [react-native-cosmos ★18](https://github.com/jerolimov/react-native-cosmos) - DX 工具，用于使用定义的 props/state fixtures 测试 react-native 组件.
* [react-native-kill-packager ★15](https://github.com/livioso/react-native-kill-packager) - 终止正在运行的 React Native 打包程序.
* [react-native-build-cli ★3](https://github.com/adonpro/react-native-build-cli) - 用于 react-native 构建的 cli 工具
* [react-native-react-bridge](https://github.com/inokawa/react-native-react-bridge) - 在 React Native 中运行 React Web 应用程序并处理它们之间的通信的工具集.

### Styling

* [styled-components ★20064](https://github.com/styled-components/styled-components) - 使用标记的模板文字来设计 React 和 React Native.
* [emotion ★5627](https://github.com/emotion-js/emotion) - 风格作为状态的函数.
* [react-native-extended-stylesheet ★1689](https://github.com/vitalets/react-native-extended-stylesheet) - 使用变量、相对单位、百分比、数学运算、缩放和其他内容扩展 React Native 样式表.
* [react-native-css ★755](https://github.com/sabeurthabti/react-native-css) - 使用 css 设计 React-Native 组件并内置对 SASS 的支持.
* [react-native-style-tachyons ★525](https://github.com/tachyons-css/react-native-style-tachyons) - 基于 tachyons.css 的功能性、可维护性设计.
* [glamorous-native ★454](https://github.com/robinpowered/glamorous-native) - glamorous 的 React Native 版本 - 一个组件样式库.
* [react-native-responsive ★295](https://github.com/ayoubdev/react-native-responsive)  - 媒体查询的力量现在在你的 React Native 项目（ios 和 android）中！ 现在可以轻松管理响应式设计！
* [cairn ★110](https://github.com/adamterlson/cairn) - 简单的、基于字符串的样式选择器引擎，支持基本继承.
* [react-native-theme ★104](https://github.com/apentle/react-native-theme) - React Native 项目的主题管理器！
* [react-native-css-modules ★44](https://github.com/kristerkari/react-native-css-modules) - 使用 CSS、Sass、Less 或 Stylus 设计 React-Native 组件的样式.
* [rn-less ★15](https://github.com/blackmiaool/rn-less) - 样式 react-native with less（支持 VS Code 扩展）
* [react-native-prism ★10](https://github.com/tmpfs/prism) - React Native 的最小化、惯用风格管理
* [react-native-paint ★5](https://github.com/brankeye/react-native-paint)  - 对 React Native StyleSheet 的主题化抽象. 了解它 [here](https://medium.com/@brankeye/making-easily-themeable-react-native-stylesheets-bd8782b4e685).
* [binstorm ★5](https://github.com/binbytes/binstorm)  - BinStorm 是一种用于快速构建自定义用户界面的 React Native 样式实用程序. 了解它 [here](https://docs-binstorm.binbytes.com/).
* [styled-react-native](https://github.com/jsifalda/styled-react-native)  - 使用简单方法（样式覆盖、组件组合、增强样式属性）的高级反应本机样式. 完整介绍 [this Medium article](https://medium.com/@JSifalda/advanced-react-native-styling-with-a-few-lines-of-code-4b6a94385015).
* [react-native-tailwindcss](https://github.com/TVke/react-native-tailwindcss) - 基于 TailwindCSS 的 React 原生样式系统.

### System

* [react-native-firebase ★4192](https://github.com/invertase/react-native-firebase) - 经过良好测试的 React Native 功能丰富的 Firebase 实现，支持 iOS 和 Android 平台的 10 多个 Firebase 模块（包括 Cloud Firestore）.
* [react-native-push-notification ★3431](https://github.com/zo0r/react-native-push-notification) - React Native 本地和远程通知
* [react-native-device-info ★3145](https://github.com/rebeccahughes/react-native-device-info) - 使用react-native获取设备信息
* [react-native-fs ★2465](https://github.com/johanneslumpe/react-native-fs) - 反应本机的本机文件系统访问
* [react-native-config ★1894](https://github.com/luggit/react-native-config) - React Native 应用程序的配置变量
* [react-native-ultimate-config](https://github.com/maxkomarychev/react-native-ultimate-config) - 使用单个文件配置所有级别的 react-native 应用程序
* [react-native-fcm ★1564](https://github.com/evollu/react-native-fcm) - 为 firebase 云消息传递和本地通知做出反应本机模块
* [react-native-notifications ★1396](https://github.com/wix/react-native-notifications) - 反应本机通知
* [react-native-arkit ★1290](https://github.com/HippoAR/react-native-arkit) - iOS ARKit 的 React Native 绑定
* [react-native-permissions ★1118](https://github.com/yonahforst/react-native-permissions) - 使用单个 api 检查并请求所有权限
* [react-native-keychain ★992](https://github.com/oblador/react-native-keychain) - React Native 的钥匙串访问
* [react-native-touch-id ★902](https://github.com/naoufal/react-native-touch-id) - 使用本机 Touch ID 弹出窗口响应本机身份验证.
* [react-native-contacts ★882](https://github.com/rt2zz/react-native-contacts) - React Native 联系人（android 和 ios）
* [react-native-communications ★871](https://github.com/anarchicknight/react-native-communications) - 在 React Native 中轻松打电话、发电子邮件、发短信或使用 iMessage 给某人
* [react-native-onesignal ★871](https://github.com/geektimecoil/react-native-onesignal) - 用于 OneSignal 推送通知服务 (iOS + Android) 的 React Native 库
* [react-native-in-app-utils ★743](https://github.com/chirag04/react-native-in-app-utils) - 用于处理应用内支付的反应本机包装器.
* [react-native-image-resizer ★636](https://github.com/bamlab/react-native-image-resizer) - 使用 React Native 重新缩放本地图像文件.
* [react-native-quick-actions ★593](https://github.com/madriska/react-native-quick-actions) - 用于 3D Touch 主屏幕快速操作的反应本机界面
* [react-native-billing ★534](https://github.com/idehub/react-native-billing) - Android 上 React Native 的应用内购买实现.
* [react-native-barcodescanner ★491](https://github.com/ideacreation/react-native-barcodescanner) - A barcode scanner component for react native - not maintained anymore - use react-native-camera.
* [react-native-iap ★450](https://github.com/dooboolab/react-native-iap) - 用于应用内购买的 React-native 本机模块.
* [react-native-dotenv ★450](https://github.com/zetachang/react-native-dotenv) - Babel 预设让您从 .env 文件导入应用程序配置（零运行时依赖性）
* [react-native-location ★425](https://github.com/timfpark/react-native-location) - 对 React Native 的本地 GPS 位置支持.
* [react-native-background-fetch ★373](https://github.com/transistorsoft/react-native-background-fetch)  - iOS BackgroundFetch API 实现. 唤醒后台挂起的 iOS 应用，大约每 15 分钟执行一次“callbackFn”.
* [react-native-queue ★359](https://github.com/billmalarky/react-native-queue) - 你在 React Native 中用于任务管理的瑞士军刀 - 轻松管理应用程序关闭时定期运行的后台任务和专用工作线程.
* [react-native-sensors ★355](https://github.com/react-native-sensors/react-native-sensors) - 具有 RxJS 接口的陀螺仪、加速度计和磁力计等传感器的平台独立包装器
* [react-native-social-share ★347](https://github.com/doefler/react-native-social-share) - 使用 iOS 原生的 Twitter 和 Facebook 分享来自 React Native 的视图
* [react-native-ibeacon ★334](https://github.com/geniuxconsulting/react-native-ibeacon)  - iBeacon 支持 React Native. 该 API 与 CoreLocation Objective-C 非常相似，唯一的主要区别在于区域是纯 JavaScript 对象. 信标在 iOS 模拟器中不起作用.
* [react-native-lock-ios ★291](https://github.com/auth0/react-native-lock-ios) - React Native (iOS) 的 Auth0 锁
* [react-native-motion-manager ★223](https://github.com/pwmckenna/react-native-motion-manager) - 用于使用陀螺仪、加速度计和磁力计的反应本机界面
* [react-native-android-sms-listener ★194](https://github.com/CentaurWarchief/react-native-android-sms-listener) - 允许您收听传入的短信
* [react-native-device ★185](https://github.com/GertjanReynaert/react-native-device) - React Native 的 UIDevice 包装器
* [react-native-gcm-android ★174](https://github.com/oney/react-native-gcm-android) - Android 版 GCM
* [react-native-sensor-manager ★172](https://github.com/kprimice/react-native-sensor-manager)  - 用于提供本地传感器访问的 react-native 的包装器.  （陀螺仪、加速度计、磁力计、温度计……）
* [react-native-ble ★157](https://github.com/jacobrosenthal/react-native-ble) - 使用高贵的 api 表面反应本机 BLE
* [react-native-haptic ★137](https://github.com/charlesvinette/react-native-haptic) - iOS 10 + React Native 应用程序的触觉反馈
* [react-native-pinch ★130](https://github.com/localz/react-native-pinch) - 用于本机反应的 SSL 固定
* [react-native-unified-contacts ★120](https://github.com/joshuapinter/react-native-unified-contacts) - React Native iOS 9+ 联系人 (ios)
* [react-native-callkit ★94](https://github.com/ianlin/react-native-callkit) - 适用于 React Native 的 iOS 10 CallKit 框架
* [react-native-discovery ★89](https://github.com/yonahforst/react-native-discovery) - Discover nearby devics using BLE. Turn iOS and Android devices into beacons
* [react-native-passcode-auth ★87](https://github.com/naoufal/react-native-passcode-auth) - 使用 iOS 密码反应本机身份验证.
* [react-native-addressbook ★81](https://github.com/rt2zz/react-native-addressbook) - 反应本机的地址簿模块
* [react-native-fingerprint-identify ★79](https://github.com/williamtran29/react-native-fingerprint-identify) - React Native authentication with the Fingerprint on Android, fingerprint API compatible lib，它还结合了三星，小米和魅族的官方指纹API.
* [react-native-phone-call ★76](https://github.com/tiaanduplessis/react-native-phone-call) - 在 React Native 中发起电话呼叫的简单方法
* [react-native-calendar-reminders ★69](https://github.com/wmcmahan/React-Native-CalendarReminders) - 用于 IOS EventKit 提醒的 React Native 模块
* [react-native-bluetooth-state ★61](https://github.com/frostney/react-native-bluetooth-state)  - 回答“我的蓝牙打开了吗？”的问题在 React Native 中
* [react-native-google-nearby-messages ★14](https://github.com/mrousavy/react-native-google-nearby-messages) - 通过使用 Google Nearby Messages API，使用蓝牙、BLE、WiFi 和近超声波音频与附近的设备通信
* [react-native-barcode-scanner ★60](https://github.com/lifuzu/ReactNativeBarcodeScanner) - React Native 的条形码扫描仪
* [react-native-haptic-feedback ★60](https://github.com/mkuczera/react-native-haptic-feedback) - 在 iOS 和 Android 上触发原生触觉反馈
* [react-native-media-clipboard](https://github.com/Jarred-Sumner/react-native-media-clipboard) - 用于从剪贴板获取图像、URL 和字符串的 React Native 模块
* [react-native-nfc-ios ★52](https://github.com/barodeur/react-native-nfc-ios) - 易于将 CoreNFC 用于 React Native
* [react-native-android-sms ★48](https://github.com/msmakhlouf/react-native-android-sms) - 用于列出/发送短信的本机 android 模块.
* [react-native-voip-push-notification ★48](https://github.com/ianlin/react-native-voip-push-notification) - iOS 优先 VoIP 推送通知
* [react-native-android-speech ★47](https://github.com/mihirsoni/react-native-android-speech) - 适用于 Android React Native 的文本转语音库.
* [react-native-app-info ★42](https://github.com/Iragne/react-native-app-info) - React Native 应用程序信息和版本
* [react-native-icloud-sync ★41](https://github.com/chirag04/react-native-icloud-sync) - 用于与 icloud 同步的 react-native 包装器
* [react-native-carrier-info ★41](https://github.com/anarchicknight/react-native-carrier-info) - React Native 模块桥获取有关用户的家庭蜂窝服务提供商的信息.
* [react-native-sms-android ★40](https://github.com/rhaker/react-native-sms-android) - 用于向电话号码发送短信的反应本机模块.
* [react-native-touch-id-android ★32](https://github.com/ElekenAgency/react-native-touch-id-android) - 在 Android 上使用指纹反应本机身份验证.
* [react-native-heading ★31](https://github.com/yonahforst/react-native-heading) - 在 iOS 或 Android 上获取设备航向（罗盘）信息
* [react-native-battery ★30](https://github.com/oojr/react-native-battery) - 一个返回设备电池电量/状态的 React Native 模块
* [react-native-device-battery ★30](https://github.com/robinpowered/react-native-device-battery) - 观察你的本机应用程序中的电池状态变化
* [react-native-device-motion ★29](https://github.com/paramaggarwal/react-native-device-motion) - 用于 React Native 的 iOS 设备运动包装器.
* [react-native-wifi-manager ★29](https://github.com/skierkowski/react-native-wifi-manager) - Android 上 React Native 的 Wifi 连接管理器
* [react-native-android-sqlite ★28](https://github.com/jbrodriguez/react-native-android-sqlite) - SQLite 的反应本机 android 包装器
* [react-native-search-api ★27](https://github.com/ombori/react-native-search-api) - SearchApi 模块为您提供了一个通用的 React Native 界面，用于与 iOS 搜索 API、Core Spotlight 进行交互.
* [react-native-ssl-pinning ★20](https://github.com/MaxToyberman/react-native-ssl-pinning) - 在 Android 上使用 OkHttp 3 和 iOS 上的 AFNetworking 反应本机 SSL 固定
* [react-native-localsearch ★17](https://github.com/wmcmahan/React-Native-LocalSearch) - 用于 MapKit 本地搜索的 React Native 模块
* [rn-secure-storage ★17](https://github.com/talut/rn-secure-storage) - React Native 的安全存储（Android 和 iOS）
* [react-native-contacts-rx ★14](https://github.com/JeanLebrument/react-native-contacts-rx) - 包括 RxJS 支持的 react-native-contacts 对应物.
* [react-native-mipush ★13](https://github.com/cpunion/react-native-mipush) - MiPush for React Native
* [react-native-device-angles ★12](https://github.com/cristianszwarc/RNDeviceAngles) - 获取以度数为单位的旋转信息（俯仰、偏航、滚动）- ios
* [react-native-detect-device ★11](https://github.com/peachmeco/react-native-detect-device) - 在反应本机中检测 iOS 或 android 上的设备.
* [react-native-battery-status ★11](https://github.com/remobile/react-native-battery-status) - 反应本机的电池状态
* [react-native-system-notification ★10](https://github.com/Neson/react-native-system-notification) - React Native 的通知
* [react-native-home-pressed ★8](https://github.com/evanjmg/react-native-home-pressed) - 收听 Android 的家庭和最近的应用程序事件
* [react-native-lock-android ★7](https://github.com/auth0/react-native-lock-android) - React Native (Android) 的 Auth0 锁
* [react-native-push-with-gcm ★6](https://github.com/lilach/react-native-push-with-gcm) - 为 GCM 推送通知服务注册设备（仅支持 iOS）
* [react-native-device-info-pod ★3](https://github.com/mchinyakov/react-native-device-info) - 使用react-native获取设备信息
* [react-native-sms-retriever](https://github.com/Bruno-Furtado/react-native-sms-retriever) - 短信检索器 API (Android).
* [react-native-background-downloader ★93](https://github.com/EkoLabs/react-native-background-downloader) - 帮助您在 iOS 和 Android 上在前台和最重要的后台下载大文件.
* [rn-in-app-review](https://github.com/ravirupareliya/rn-in-app-review) - 帮助您整合 Android 和 iOS 的应用内评论
* [react-native-system-setting](https://github.com/c19354837/react-native-system-setting)- 提供了一些系统设置API iOS 和Android.

### Web

* [react-native-webrtc ★1805](https://github.com/oney/react-native-webrtc) - 用于 React Native 的 WebRTC 模块.
* [react-native-webview-bridge ★1112](https://github.com/alinz/react-native-webview-bridge) - React Native WebView Javascript Bridge
* [react-native-safari-view ★387](https://github.com/naoufal/react-native-safari-view) - 用于 Safari 视图控制器的 React Native 包装器
* [react-native-webview-android ★305](https://github.com/lucasferreira/react-native-webview-android) - 简单的 React Native Android 模块在您的应用程序中使用 Android 的 WebView
* [react-native-for-web ★247](https://github.com/KodersLab/react-native-for-web)  - 一组类和反应组件，使您的反应本机应用程序在浏览器中运行.  （显然有一些限制）
* [react-native-browser ★107](https://github.com/PrestoDoctor/react-native-browser) - 基于 TOWebViewController 的 React Native 应用程序的全功能网络浏览器模块
* [react-native-webview-crosswalk ★88](https://github.com/jordansexton/react-native-webview-crosswalk) - Crosswalk 的 WebView for React Native on Android
* [react-native-turbolinks ★72](https://github.com/lazaronixon/react-native-turbolinks) - React Native 适配器用于使用 Turbolinks 5 构建混合应用程序
* [react-native-webintent ★53](https://github.com/ivanph/react-native-webintent) - React native android module to open links in the default browser
* [react-native-web-container ★36](https://github.com/danrigsby/react-native-web-container) - 一个围绕反应本机 WebView 的包装器，用于添加自动高度、擦除 html 等
* [react-native-inappbrowser-reborn ★30](https://github.com/proyecto26/react-native-inappbrowser) - 用于 React Native（Android 和 iOS）的 InAppBrowser
* [react-native-browser-polyfill ★29](https://github.com/johanneslumpe/react-native-browser-polyfill) - 用于 react-native Javascript 环境的 polyfill 集合.
* [react-native-cookiemanager ★19](https://github.com/beefe/react-native-cookiemanager) - 反应本机 cookie 管理器库.
* [react-native-bridgeable-webview ★16](https://github.com/Intellicode/react-native-bridgeable-webview) - 一个反应本机 webview 与反应本机代码的桥梁
* [react-native-html2native ★3](https://github.com/labithiotis/react-native-html-render) - 用于 react-native 的 html 渲染
* [react-native-webview ★3](https://github.com/beefe/react-native-webview) - 用于反应本机的android webview

### Media

* [react-native-camera ★6227](https://github.com/lwansbrough/react-native-camera) - 相机组件
* [react-native-video ★3470](https://github.com/brentvatne/react-native-video) - 用于 react-native 的视频组件
* [react-native-sound ★1556](https://github.com/zmxv/react-native-sound) - 用于播放声音片段的 React Native 模块
* [react-native-audio ★798](https://github.com/jsierles/react-native-audio)  - 在您的 iOS 或 Android React Native 应用程序中录制和播放音频.  （不再维护）
* [react-native-audio-toolkit ★764](https://github.com/react-native-community/react-native-audio-toolkit)  - 用于反应本机的音频播放和录制. 除了基本功能外，还实现了许多有用的功能，例如通过网络搜索、循环播放和流式传输音频文件.
* [react-native-camera-kit ★701](https://github.com/wix/react-native-camera-kit) - 高级原生相机和图库组件以及设备照片 API.
* [react-native-audio-streaming ★679](https://github.com/tlenclos/react-native-audio-streaming) - 用于播放音频流的 iOS 和 Android 模块，具有背景支持和媒体控制：扬声器：
* [react-native-video-processing ★712](https://github.com/shahen94/react-native-video-processing) - React-Native 的本地视频编辑/修剪/过滤库
* [react-native-track-player ★441](https://github.com/react-native-kit/react-native-track-player)  - 为音乐应用程序创建的完全成熟的音频模块. 为 Android、iOS 和 Windows 提供音频播放、外部媒体控制、chromecast 支持和后台模式.
* [react-native-music-control](https://github.com/tanguyantoine/react-native-music-control/) - React Native 模块在锁屏上显示正在播放的信息并处理控制事件
* [react-native-camera-roll-picker ★312](https://github.com/jeanpan/react-native-camera-roll-picker) - 一个 React Native 组件，提供从相机胶卷中选择的图像
* [react-native-incall-manager ★272](https://github.com/zxcpoiu/react-native-incall-manager) - 在像 webrtc 这样的音频/视频聊天期间处理媒体路由/传感器/事件
* [react-native-speech ★246](https://github.com/naoufal/react-native-speech) - 用于 React Native 的文本转语音库.
* [react-native-screcorder ★214](https://github.com/maxs15/react-native-screcorder) - 使用类似 Vine 的点击来拍摄照片和录制视频
* [react-native-photos-framework ★154](https://github.com/olofd/react-native-photos-framework) - 用于 React Native 的现代且全面的 CameraRoll/iCloud 库
* [react-native-audioplayer ★99](https://github.com/andreaskeller/react-native-audioplayer) - 用于反应本机的小型音频播放器库
* [react-native-player ★81](https://github.com/xeodou/react-native-player) - 反应本机的媒体播放器
* [react-native-vlc-player ★80](https://github.com/ghondar/react-native-vlc-player) - 反应本机的 VLC 播放器
* [react-native-volume-slider ★69](https://github.com/IFours/react-native-volume-slider) - React Native VolumeView 组件
* [react-native-sound-demo ★63](https://github.com/zmxv/react-native-sound-demo) - 反应原生声音演示项目
* [react-native-interactive-image-gallery ★60](https://github.com/InterfaceKit/react-native-interactive-image-gallery) - 用于显示图片库的 React Native 组件.
* [react-native-color-grabber ★57](https://github.com/bsudekum/react-native-color-grabber) - 反应本机组件以查找图像中的主色
* [react-native-hue-player ★43](https://github.com/App2Sales/react-native-hue-player) - 离线/本地和在线/流媒体音频的音频播放器.
* [react-native-media-meta ★41](https://github.com/mybigday/react-native-media-meta) - 在您的 React Native 应用程序中获取媒体文件元数据
* [react-native-sound-recorder ★41](https://github.com/kevinresol/react-native-sound-recorder) - React Native 的无障碍录音机.
* [react-native-fullscreen-video ★39](https://github.com/mostafa/react-native-fullscreen-video) - 在 react-native-video 之上的全屏视频组件
* [react-native-android-audio-streaming-aac ★25](https://github.com/EstebanFuentealba/react-native-android-audio-streaming-aac) - 反应本机流媒体播放器
* [react-native-photoeditorsdk ★24](https://github.com/imgly/pesdk-react-native) - React Native 模块 [PhotoEditor SDK](https://www.photoeditorsdk.com) （安卓和 iOS）
* [react-native-videoeditorsdk ★18](https://github.com/imgly/vesdk-react-native) - React Native 模块 [VideoEditor SDK](https://www.videoeditorsdk.com) （安卓和 iOS）
* [react-native-true-sight ★18](https://github.com/ScreamZ/react-native-true-sight) - 具有 React Native 可自定义控件的跨平台视频播放器.
* [react-native-audio-manager ★15](https://github.com/Tricy/react-native-audio-manager) - 用于反应本机 Android 的音频播放器库
* [react-native-safe-image ★13](https://github.com/xcarpentier/react-native-safe-image) - 真正轻量级的 React-Native 包，用于在图像出错时处理回退
* [react-native-audio-player ★12](https://github.com/sh3rawi/react-native-audio-player) - 用于在 Android 上播放音频的 React Native 模块
* [react-native-mediaplayer ★12](https://github.com/chriselly/react-native-mediaplayer) - 用于 React Native 的简单全屏媒体播放器.
* [react-native-simple-sound ★11](https://github.com/mikehedman/react-native-simple-sound)  - 开始、停止和暂停声音. 仅限 iOS. 源自`react-native-sound`
* [react-native-tone ★7](https://github.com/oliviachang29/react-native-tone)  - 生成简单的正弦波，指定频率和振幅. 无限期或指定时间间隔播放声音（仅限 iOS）.
* [react-native-media-capture ★6](https://github.com/remobile/react-native-media-capture) - 用于反应本机的媒体捕获
* [react-native-android-video ★8](https://github.com/Cherrypick-Consulting/react-native-android-video) - 用于反应本机的 Android ExoPlayer 视频组件.
* [react-native-airplay-button](https://github.com/CBCNewMedia/react-native-airplay-button) - 原生 iOS Airplay 按钮组件

### Storage

* [RxDB ★12797](https://github.com/pubkey/rxdb) - 用于 JavaScript 应用程序的实时数据库.
* [WatermelonDB ★4649](https://github.com/Nozbe/WatermelonDB) - 用于强大的 React 和 React Native 应用程序的下一代数据库，可扩展到 10,000 条记录并保持快速.
* [realm ★3184](https://github.com/realm/realm-js) - SQLite 和键值存储的替代移动数据库.
* [react-native-storage ★2115](https://github.com/sunnylqm/react-native-storage)  - 这是 react-native(AsyncStorage) 和 browser(localStorage) 的本地存储包装器. 需要 ES6/babel.
* [react-native-sqlite-storage ★1508](https://github.com/andpor/react-native-sqlite-storage) - 用于 React Native（Android 和 iOS）的 SQLite3 绑定
* [react-native-simple-store ★731](https://github.com/jasonmerino/react-native-simple-store) - 围绕 React Native 的 AsyncStorage 的简约包装器.
* [react-native-store ★561](https://github.com/thewei/react-native-store) - 一个基于 react-native AsyncStorage 的简单数据库.
* [react-native-db-models ★168](https://github.com/darkrishabh/react-native-db-models) - React Native 应用程序的本地数据库模型
* [react-native-sqlite-2 ★106](https://github.com/noradaiko/react-native-sqlite-2) - 适用于 Android 和 iOS 的 React Native 的 SQLite3 Native 插件
* [react-native-couchbase-lite ★105](https://github.com/fraserxu/react-native-couchbase-lite) - 用于反应本机的 couchbase lite 绑定
* [react-native-persistent-job ★72](https://github.com/Gabrn/react-native-persistent-job) - 运行在崩溃、连接丢失或异常后重试的异步任务
* [pouchdb-adapter-react-native-sqlite ★49](https://github.com/noradaiko/pouchdb-adapter-react-native-sqlite) - 使用 ReactNative SQLite 作为后备存储的 PouchDB 适配器
* [react-native-pouchdb ★38](https://github.com/carbureted/react-native-pouchdb) - 在 React Native 中运行 pouchdb！
* [react-native-level-fs ★20](https://github.com/tradle/react-native-level-fs) - fs for react-native 使用 level-filesystem 和 asyncstorage-down
* [react-native-mongoose ★17](https://github.com/remobile/react-native-mongoose) - 基于 AsyncStorage 的 mongoose 类 react-native 存储
* [react-native-leveldown](https://github.com/andymatuschak/react-native-leveldown) - 用于 React Native 的原生 LevelDB 绑定
* [typed-async-storage](https://github.com/artxty/typed-async-storage) - 用于使用 React 道具类型为 AsyncStorage 创建模式和验证的包装器.

### Backend

* [react-native-fetch-blob ★2299](https://github.com/wkh237/react-native-fetch-blob)  - 一个模块集成了网络和文件系统. 支持文件流.
* [reactivesearch-native ★1218](https://github.com/appbaseio/reactivesearch/tree/dev/packages/native) - 用于 React Native 的 appbase.io 和 Elasticsearch UI 组件.
* [react-native-meteor ★673](https://github.com/inProgress-team/react-native-meteor) - 完整的 Meteor 客户端
* [aws-sdk-react-native ★650](https://github.com/awslabs/aws-sdk-react-native) - 适用于 React Native 的 AWS SDK（官方开发者预览版）
* [react-native-simple-auth ★592](https://github.com/adamjmcgrath/react-native-simple-auth) - iOS 上 React Native 的原生社交身份验证
* [react-native-uploader ★455](https://github.com/aroth/react-native-uploader)  - 用于上传文件和相机胶卷资产的 React Native 模块. 支持进度通知.
* [react-native-lazyload ★342](https://github.com/magicismight/react-native-lazyload) - 延迟加载用于本机反应
* [react-native-aws3 ★293](https://github.com/benjreinhart/react-native-aws3) - 用于上传到 AWS S3 的纯 JavaScript React Native 库
* [react-native-background-upload ★270](https://github.com/Vydia/react-native-background-upload)  - 即使在后台运行时，也可以在 React Native 应用程序中上传文件. 支持 Android 和 iOS，包括 iOS 相机胶卷资产.
* [react-native-xmpp ★256](https://github.com/aksonov/react-native-xmpp) - 用于 React Native 的 XMPP 库
* [react-native-tcp ★199](https://github.com/PeelTechnologies/react-native-tcp) - 用于反应本机的节点网络 API
* [react-native-udp ★147](https://github.com/tradle/react-native-udp) - 用于反应本机的节点 dgram API
* [react-native-aws-cognito-js ★131](https://github.com/AirLabsTeam/react-native-aws-cognito-js) - 适用于 JavaScript 的 Amazon Cognito Identity SDK 与适用于 React Native 的 AWS SDK for JavaScript 的改编版.
* [feathers-client ★121](https://github.com/feathersjs/feathers-client) - 适用于 React Native、NodeJS 和任何客户端框架的 Feathers 客户端.
* [react-native-multipeer ★117](https://github.com/lwansbrough/react-native-multipeer) - 使用 Multipeer Connectivity 通过 ad hoc wifi 进行通信
* [react-native-swift-socketio ★105](https://github.com/kirkness/react-native-swift-socketio) - socket.io-client-swift 的反应本机包装器
* [react-native-file-upload ★103](https://github.com/booxood/react-native-file-upload) - 用于 react-native 的文件上传插件
* [react-native-networking ★99](https://github.com/eduedix/react-native-networking) - 使用 AFNetworking 下载和上传文件的 react-native 模块
* [react-native-s3 ★80](https://github.com/mybigday/react-native-s3) - 用于 AWS iOS/Android S3 SDK (TransferUtility) 的 React Native 包装器
* [react-native-rest-kit ★65](https://github.com/peter4k/react-native-rest-kit) - 一个使用 fetch 方法的 React Native RESTful API 套件
* [react-native-cognito ★63](https://github.com/morcmarc/react-native-cognito) - 用于 React Native 的基于 AWS Cognito 的身份验证模块.
* [react-native-file-download ★45](https://github.com/plrthink/react-native-file-download) - 一个简单的react-native文件下载模块
* [react-native-jwt ★37](https://github.com/StanScates/react-native-jwt) - React 本机兼容的 JSON 网络令牌实用程序
* [react-native-sync ★28](https://github.com/pervasync/react-native-sync) - 两种方式，React Native realmjs 数据库与 MySQL、Oracle、MS SQL Server 和 PostgreSQL 之间的增量同步
* [react-native-ssdp ★26](https://github.com/netbeast/react-native-ssdp) - SSDP 协议的 React Native 分支，用于发现即插即用设备.
* [react-native-http ★13](https://github.com/iktw/react-native-jwt) - 反应本机 http
* [react-native-async-http ★5](https://github.com/szq4119/react-native-async-http) - 用于异步 http 的 React Native 组件
* [react-native-nchan ★3](https://github.com/indatawetrust/react-native-nchan) - React Native 的 Nchan（发布/订阅服务器）模块
* [react-native-blob-courier ★8](https://github.com/edeckers/react-native-blob-courier) - 在本机线程上高效下载和上传 blob
* [fetch ★10](https://github.com/react-native-community/fetch) - 具有文本流支持的 React Native 的获取 API polyfill.

### Integrations

* [react-native-wechat ★2016](https://github.com/weflex/react-native-wechat) - 用于微信应用程序的反应本机库
* [react-native-facebook-login ★1141](https://github.com/magus/react-native-facebook-login) - 为原生 iOS Facebook SDK 登录按钮和管理器 React Native 包装器
* [react-native-google-signin ★1123](https://github.com/apptailor/react-native-google-signin) - 谷歌登录你的本机应用程序
* [react-native-google-places-autocomplete ★846](https://github.com/FaridSafi/react-native-google-places-autocomplete) - 适用于 iOS 和 Android React-Native 应用程序的可定制 Google Places 自动完成组件
* [react-instantsearch ★644](https://github.com/algolia/react-instantsearch) - 闪电般快速搜索 React 和 React Native 应用程序，由 Algolia 提供
* [react-native-awesome-card-io ★331](https://github.com/Kerumen/react-native-awesome-card-io) - 用于 React Native（iOS 和 Android）的完整跨平台 card.io 组件
* [react-native-qq ★278](https://github.com/reactnativecn/react-native-qq) - React Native 支持 QQ 登录和分享.
* [react-native-facebook-account-kit ★227](https://github.com/underscopeio/react-native-facebook-account-kit) - 用于 React Native 的 Facebook Account Kit SDK 包装器.
* [react-native-wechat-ios ★199](https://github.com/beefe/react-native-wechat-ios) - 适用于 React Native(iOS) 的微信 SDK.
* [react-native-card-io ★171](https://github.com/kayla-tech/react-native-card-io) - 用于 card.io 的 React Native 组件
* [react-native-voximplant ★126](https://github.com/voximplant/react-native-voximplant) - VoxImplant Mobile SDK，用于将语音和视频通信嵌入到 React Native 应用程序中.
* [instabug-reactnative ★122](https://github.com/Instabug/instabug-reactnative) - 用于错误报告 Instabug SDK 的 React Native 包装器.
* [react-native-fabric-digits ★112](https://github.com/JeanLebrument/react-native-fabric-digits) React-Native 的 Fabric Digits 包装器
* [react-native-braintree ★104](https://github.com/alawong/react-native-braintree) - 用于使用 Braintree 的 v.zero SDK（目前仅限 iOS）集成支付的反应本机界面
* [react-native-dialogflow ★104](https://github.com/innFactory/react-native-dialogflow) - 谷歌 Dialogflow (api.ai) 的 React-Native 桥
* [react-native-signalr ★100](https://github.com/olofd/react-native-signalr) - 用于反应本机的 SignalR 客户端
* [react-native-twilio ★87](https://github.com/rogchap/react-native-twilio) - Twilio 客户端 SDK 的 React Native 包装器.
* [react-native-twilio-programmable-voice ★86](https://github.com/hoxfon/react-native-twilio-programmable-voice) - Twilio 可编程语音 SDK 的 React Native 包装器.
* [react-native-qqsdk ★83](https://github.com/iVanPan/react-native-qqsdk)  - 用于 Android 和 iOS 的腾讯 QQ SDK 的 React Native 包装器. 提供QQ ssoLogin、QQ分享、QQ空间分享等功能.
* [react-native-braintree-xplat ★81](https://github.com/kraffslol/react-native-braintree-xplat) - 跨平台 Braintree v.zero 模块.
* [react-native-android-vitamio ★72](https://github.com/sejoker/react-native-android-vitamio) - 用于 android Vitamio 视频播放器的 React-native 组件
* [react-native-linkedin-login ★69](https://github.com/jodybrewster/react-native-linkedin-login) - Linkedin 登录您的 React Native 应用程序
* [react-native-twitter-signin ★140](https://github.com/GoldenOwlAsia/react-native-twitter-signin) - 使用客户端 Twitter 帐户登录您的 React Native 应用程序
* [react-native-spring-scrollview ★64](https://github.com/bolan9999/react-native-spring-scrollview) - React Native Spring ScrollView V2 是一款用于 React Native 的高性能跨平台原生 bounces ScrollView.（iOS 和 Android）
* [react-native-instagram-oauth ★63](https://github.com/watzak/react-native-instagram-oauth) - 反应本机 instagram 登录
* [react-native-digits ★60](https://github.com/fixt/react-native-digits) - 在 React Native 中使用的数字包装器
* [react-native-realtimemessaging-android ★53](https://github.com/realtime-framework/RCTRealtimeMessagingAndroid) - 用于 React-Native Android 的 Realtime Framework Cloud Messaging Pub/Sub 客户端
* [react-native-new-relic ★53](https://github.com/wix/react-native-newrelic) - 用于 react-native 的新 Relic 事件报告.
* [react-native-onepassword ★52](https://github.com/DriveWealth/react-native-onepassword) - React Native 与 OnePassword 扩展的集成.
* [react-native-level ★38](https://github.com/tradle/react-native-level) - 用于反应本机 AsyncStorage 的升级 API.
* [react-native-instagram-share ★28](https://github.com/watzak/react-native-instagram-share) - 用于在 Instagram (iOS) 中共享图像和视频的反应本机界面
* [react-native-braintree-android ★24](https://github.com/surialabs/react-native-braintree-android) - Braintree 的原生 Android Drop-in 支付用户界面
* [react-native-amap ★21](https://github.com/laoqiu/react-native-amap) - 用于使用 AMap Android SDK 构建地图的 React Native 组件
* [react-native-realtime-pusher ★19](https://github.com/gijoehosaphat/react-native-realtime-pusher) - 实现 Pusher Realtime API 的 React Native 模块
* [react-native-conekta ★17](https://github.com/zo0r/react-native-conekta) - 用于 React Native 的 Conekta SDK
* [react-native-fitness ★17](https://github.com/OvalMoney/react-native-fitness) - 与 Apple Healthkit 和 Google Fit 交互的 React Native 模块
* [react-native-woopra ★14](https://github.com/isair/react-native-woopra) - 用于反应本机的基于承诺的 Woopra 库
* [react-native-sinch-verification ★14](https://github.com/kevinresol/react-native-sinch-verification) - React Native 的 Sinch 验证
* [react-native-testfairy ★13](https://github.com/testfairy/react-native-testfairy) - 用于 React Native 的 TestFairy
* [react-native-leancloud ★10](https://github.com/turingou/react-native-leancloud) - 反应本机 LeanCloud 组件
* [react-native-flurry ★9](https://github.com/amitkothari/react-native-flurry) - 用于 Flurry 的 React Native 包装器
* [react-native-realtimemessaging-ios ★8](https://github.com/realtime-framework/RCTRealtimeMessaging) - 用于 React-Native 的 Realtime Framework Cloud Messaging Pub/Sub 客户端
* [react-native-realtimestorage-ios ★8](https://github.com/realtime-framework/RCTRealtimeCloudStorage) - React-Native 的实时框架云存储客户端
* [react-native-axmall-alipay ★7](https://github.com/szq4119/react-native-alipay) - 反应本机支付宝
* [react-native-youtube-oauth ★7](https://github.com/indatawetrust/react-native-youtube-oauth) - react-native 界面登录到 youtube (iOS)
* [react-native-intercom-native ★7](https://github.com/mateioprea/react-native-intercom) - React Native 的基于本机的对讲机实现
* [react-native-hawk ★5](https://github.com/andyscott/react-native-hawk) - 用于本机反应的 Hawk 包装器
* [react-native-sumup ★5](https://github.com/APSL/react-native-sumup) - SumupSDK 的 React Native 实现.
* [react-native-instagram ★5](https://github.com/watzak/react-native-instagram) - react-native instagram wrapper api (iOS)
* [react-native-realtimestorage-android ★4](https://github.com/realtime-framework/RCTRealtimeStorageAndroid) - 用于 React-Native Android 的实时云存储客户端
* [react-native-fbintent ★4](https://github.com/syarul/react-native-fbintent) - Android Facebook 应用程序的 React Native 意图
* [react-native-onfido ★2](https://github.com/React-Native-Nation/react-native-onfido) - Onfido 库的 React Native 包装器.
* [react-native-heyzap](https://github.com/react-native-contrib/react-native-heyzap)- React Native 的 Heyzap 插件
* [react-native-launch-navigator](https://github.com/dpa99c/react-native-launch-navigator) - React Native 模块可从单个 API（Android 和 iOS）启动流行的导航/乘车应用程序
* [react-native-agora +190](https://github.com/syanbo/react-native-agora) - 一个 React Native Agora WebRTC 包装器.
* [agora-react-native-rtm +5](https://github.com/agoraio/agora-react-native-rtm) - 一个 React Native Agora 实时消息云服务包装器.
* [react-native-intercom *323](https://github.com/tinycreative/react-native-intercom) - 一个 React Native Intercom Wrapper.
* [react-native-bugfender *7](https://github.com/bugfender/rn-bugfender) - 用于 Bugfender 日志和错误报告的 React Native 包装器.

### Monetization

* [react-native-admob ★713](https://github.com/sbugert/react-native-admob) - 用于 Google AdMob 横幅的反应本机组件.
* [react-native-stripe-api ★155](https://github.com/xcarpentier/react-native-stripe-api) - 用于 Stripe Rest API 的小型 React Native 库
* [react-native-revmob ★15](https://github.com/RevMob/react-native-revmob) - React Native 的 RevMob 包装器.
* [react-native-google-pay ★2](https://github.com/busfor/react-native-google-pay) - 为 React Native 应用程序接受 Google Pay 付款.
* [react-native-apay ★2](https://github.com/busfor/react-native-apay) - 用于 Apple Pay 的 React Native 桥
* [react-native-square-in-app-payments ★18](https://github.com/square/in-app-payments-react-native-plugin) - 用于应用内支付 SDK 的 Square React Native 插件.

### Animation

* [react-native-animatable ★5787](https://github.com/oblador/react-native-animatable) - 一套标准的易于使用的动画和 React Native 的声明式转换
* [react-native-interactable ★4148](https://github.com/wix/react-native-interactable) - React Native 中高性能可交互视图的实验性实现
* [react-native-reanimated ★680](https://github.com/kmagiera/react-native-reanimated) - 重新实现了 React Native 的动画库
* [react-native-spruce ★412](https://github.com/prscX/react-native-spruce) - React Native Bridge 用于 Spruce 动画库
* [react-native-magic-move ★402](https://github.com/IjzerenHein/react-native-magic-move) - 在 react-native 中的场景之间创建神奇的移动过渡 ✨（共享元素过渡）
* [react-native-gl-model-view ★210](https://github.com/rastapasta/react-native-gl-model-view) - 以 60fps (iOS) 显示和动画纹理波前 .OBJ 3D 模型
* [react-native-animated-sprite ★104](https://github.com/micahrye/react-native-animated-sprite) - 用于动画、补间和拖动精灵的功能丰富的声明性组件.
* [react-native-animated-math ★54](https://github.com/rastapasta/react-native-animated-math) - 动画 API 数学扩展 - 将 sin、cos、tan 和 pow 实现为动画节点，并具有完整的原生驱动程序支持

### Extension

* [React Native Today Widget ★190](https://github.com/matejkriz/react-native-today-widget) - React Native 中的 iOS Today 小部件扩展
* [React Native Android Widget Proof of Concept ★127](https://github.com/netbeast/react-native-android-widget-poc) - React Native 中的 Android Widget 概念证明
* [React Native Floating Bubble ★14](https://github.com/hybriteq/react-native-floating-bubble) - 一个简单的 Facebook 聊天头，如响应本机的气泡
* [React Native WidgetKit](https://github.com/fasky-software/react-native-widgetkit) - 用于 iOS WidgetKit 框架的 React Native 库

### Other Platforms

* [react-native-web ★10904](https://github.com/necolas/react-native-web) - 为网络反应本机
* [react-native-macos ★10453](http://github.com/ptmt/react-native-macos) - 适用于 OS X 的 React Native
* [reactxp ★7268](https://github.com/Microsoft/reactxp) - 跨平台应用程序开发库
* [react-native-windows ★5547](https://github.com/ReactWindows/react-native-windows) - React Native for Universal Windows Platform
* [@areslabs/alita ★392](https://github.com/areslabs/alita) - react native for mini-program(微信小程序)
* [react-native-tvos-controller ★15](https://github.com/ycinfinity/react-native-tvos-controller) - 用于本机反应的 TvOS 远程控制器模块.
* [react-native-watchkit ★1](https://github.com/MystK/react-native-watchkit) - 对 WatchKit 做出原生反应

## Utilities

有用的 React Native 工具.

* [upgrade-helper ★398](https://github.com/react-native-community/upgrade-helper) - ⚛️ 支持 React Native 开发人员升级其应用程序的 Web 界面. [Link to tool](https://react-native-community.github.io/upgrade-helper)
* [react-native-debugger ★4017](https://github.com/jhen0409/react-native-debugger) - React Native Debugger 的独立应用程序，带有 React DevTools / Redux DevTools
* [haul ★2711](https://github.com/callstack-io/haul) - 用于开发 React Native 应用程序的命令行工具
* [rnpm ★2408](https://github.com/rnpm/rnpm) - 反应本机包管理器
* [generact ★1125](https://github.com/diegohaz/generact) - 无论您如何构建应用程序，都会根据现有组件生成组件的 CLI
* [react-native-rename ★901](https://github.com/junedomingo/react-native-rename) - 只需一个命令即可重命名 react-native 应用程序
* [react-native-exception-handler ★504](https://github.com/master-atul/react-native-exception-handler) – 避免在您的应用程序的生产构建中发生静默崩溃和错误
* [Electrode Native ★439](https://github.com/electrode-io/electrode-native) - 一个平台，用于简化 React Native 组件在现有移动应用程序中的集成.
* [Ruby React Native (via Opal) ★391](https://github.com/zetachang/opal-native) - 使用 Ruby 构建 React Native 应用程序
* [rn-snoopy ★329](https://github.com/jondot/rn-snoopy) - 通过 React Native 桥进行分析、监控和警报. [More here](https://medium.com/@jondot/debugging-react-native-performance-snoopy-and-the-messagequeue-fe014cd047ac).
* [react-native-snippets ★249](https://github.com/Shrugs/react-native-snippets) - 用于 react-native 的 Sublime Text Snippets 的集合
* [react-native-bundle-visualizer ★141](https://github.com/IjzerenHein/react-native-bundle-visualizer)  - 查看您的 RN 包中有什么； 对优化包大小很有用
* [Makeicon ★70](https://github.com/beplus/makeicon) - 为 iOS 和 Android 生成所有分辨率的移动应用程序图标
* [rn-diff-purge ★64](https://github.com/react-native-community/rn-diff-purge)  - 升级 React Native 版本的最简单方法. 您可以找到每个 React Native 版本的差异，这些差异是通过将以前的版本与新版本中新创建的应用程序进行差异而创建的.
* [React Native Actions ★55](https://github.com/lucasbento/react-native-actions) - 从 VSCode 中运行 React Native 操作.
* [rsx ★29](https://github.com/react-native-contrib/rsx) - `react-native` CLI 工具的替代品
* [ADB Auto Restarter ★8](https://github.com/mahanhaz/adb-auto-restarter) - 自动重启 ADB 服务，以防在使用设备调试应用程序时崩溃.
* [rn-nodeify ★6](https://github.com/mvayngrib/rn-nodeify) - hack 以允许 react-native 项目使用节点核心模块
* [react-native-ruler ★3](https://github.com/lfkwtz/react-native-ruler) - 用于测量 React Native 屏幕上像素尺寸的开发工具
* [BuilderX](https://builderx.io/) - 一个为你编写 React Native 代码的设计工具，桌面 Mac 应用程序来取代你传统的 UX 设计工具.
* [CodePush](http://microsoft.github.io/code-push/) - 立即将代码更新推送到您的应用程序
* [Storybook](https://storybook.js.org) - React 组件的 UI 开发环境
* [BugSnag](https://www.bugsnag.com/platforms/react-native-error-reporting/)  - 记录本机和 JS 错误的工具. 有免费套餐. 包括有关用户、环境、会话、发布等的有用数据.
* [React Native Playground](https://rnplay.org/) - 通过实时模拟器在浏览器中运行 React Native 应用程序
* [exponent](https://expo.io/) - 在没有 XCode 的情况下使用 React Native（预览应用程序 + 本地服务器基础设施）
* [Deco IDE](https://www.decosoftware.com/) - React Native IDE 与组件管理器
* [react-hook-hooker](https://github.com/fjcaetano/react-hook-hooker) - 一个漂亮的小 HOC，可以为你的 React 组件添加钩子.
* [React Native Elements Playground 🚀](https://react-native-elements.js.org/) - 修补网络中的“react-native-elements”组件.
* [SimpleLocalize CLI](https://github.com/simplelocalize/simplelocalize-cli) - 用于在项目文件中查找 i18n 密钥的开源本地化 CLI 工具.

## Seeds

使用现有种子抢先进行开发.

* [🔥 Ignite ★8832](https://github.com/infinitered/ignite) - React Native 的不公平开始 - 用于 redux/sagas 等的生成器 CLI.
* [Pepperoni ★4383](https://github.com/futurice/pepperoni-app-kit) - **（已弃用）** 适用于 Android 和 iOS、Redux、Immutable.js、磁盘持久化应用程序状态的入门工具包
* [Snowflake ★4321](https://github.com/bartonhammond/snowflake) - Android & iOS, Redux, Jest (88% coverage), Immutable, Parse.com
* [native-starter-kit ★1506](https://github.com/start-react/native-starter-kit) - 用于 React Native + NativeBase + React Navigation + Redux + CodePush 应用程序（iOS 和安卓）的入门套件
* [React Native Hackathon Starter ★732](https://github.com/dabit3/react-native-hackathon-starter)  - React Native Starter Project，非常适合编程马拉松或快速原型制作. 包括选项卡、导航、Redux、React Native 矢量图标和 React Native 元素
* [React Native Boilerplate Typescript](https://github.com/mengheangrat/react-native-boilerplate) - React Native Boilerplate - Redux + Saga + Reselect + redux-persist + react-navigation + TypeScript 
* [React Native Meteor Boilerplate ★615](https://github.com/spencercarli/react-native-meteor-boilerplate)
* [:octopus: React Native Boilerplate ★551](https://github.com/thecodingmachine/react-native-boilerplate) - React Native 样板，通过关注点分离促进可靠的架构.
* [React Native Seed ★504](https://github.com/GeekyAnts/react-native-seed)  - 一组 React Native Boilerplates 可供选择. 用于状态管理的 MobX 或 Redux，用于静态类型检查的 TypeScript 或 Flow，以及用于堆栈的 CRNA 或普通 React Native - 由 Native Base 的创建者提供.
* [🚀 React Native Starter ★388](https://github.com/flatlogic/react-native-starter) - 一个功能强大的入门模板，可引导您的移动应用程序的开发.
* [ReactNativeTS ★353](https://github.com/mrpatiwi/ReactNativeTS) - Typescript 中 React Native 项目的样板.
* [react-native-starter by Ueno ★311](https://github.com/ueno-llc/react-native-starter) - 专业的 react-native 入门套件，包含部署坚如磐石的应用程序所需的一切
* [react-native-babel ★241](https://github.com/roman01la/react-native-babel)
* [react-native-vanilla ★185](https://github.com/pavjacko/react-native-vanilla)  - 使用 React Native 构建通用的跨平台应用程序. 包括最新的 `iOS`、`tvOS`、`Android`、`Android TV`、`Android Wear`、`Web`、`Tizen TV`、`Tizen Watch`、`LG webOS`、`macOS/OSX`、` Windows` 和 `KaiOS` 平台
* [react-native-template-typescript ★183](https://github.com/emin93/react-native-template-typescript) - 简洁且极简的 React Native 模板，可快速开始使用 TypeScript.
* [react-native-template-airbnb](https://github.com/iboldurev/react-native-template-airbnb) - 干净简约的 React Native 模板，可快速开始使用 Airbnb（Flow、Prettier）.
* [react-native-redux ★160](https://github.com/sibelius/react-native-redux) - React Native + Redux + Redux Saga
* [react-native-es6-reflux ★145](https://github.com/filp/react-native-es6-reflux)
* [react-native-hot-redux-starter ★135](https://github.com/adampash/react-native-hot-redux-starter)
* [react-native-typescript-boilerplate ★129](https://github.com/AmitM30/react-native-typescript-boilerplate)  - 在 TypeScript 中使用 React Native Navigation v3 + Redux + Thunk 构建的自以为是的样板. 遵循行业最佳实践.
* [Rhinos-app ★81](https://github.com/rhinos-app/rhinos-app-dev) - 基于 react-native-web 构建的跨平台 React Native 样板（iOS、Android、Web）.
* [react-native-web-boilerplate ★72](https://github.com/agrcrobles/react-native-web-boilerplate) - 一个 react-native-web 无状态 hmr 样板
* [react-native-boilerplate ★61](https://github.com/pcofilada/react-native-boilerplate) - 使用 React Native 和 Redux 进行移动开发的简单样板
* [react-native-easy-starter ★50](https://github.com/HarishJangra/react-native-easy-starter) - 使用最新的 react 和 react-native 的 React-native 入门套件 [0.60.5](https://github.com/react-native-community/releases/blob/master/CHANGELOG.md#v0605)、简单的状态管理、钩子工作流、hermes、codepush 即用型自定义钩子、react-native-paper、contextapis、主题支持等等（android + ios）
* [react-native-web-workspace ★58](https://github.com/agrcrobles/react-native-web-workspace) - 在 monorepo 中做出反应的跨平台应用程序
* [🍞 Baker ★46](http://baker.thebakery.io/) - 一个自以为是的 MVP 工具包，可帮助您使用 React Native 和 Parse Server 快速构建移动应用程序
* [React-Native-Starter-Pack ★40](https://github.com/iSimar/React-Native-Starter-Pack) - React Native 0.34 + React-Redux（带 Redux-Storage）+ Native Base + 代码推送
* [react-native-relay-example ★38](https://github.com/sibelius/react-native-relay-example) - React Native 与 Relay 一起工作
* [MeteorNative Boilerplate ★23](https://github.com/redbaron76/MeteorNative) - a React Native and Meteor boilerplate with Redux.
* [rn-mobx-template ★17](https://github.com/hiaw/rn_mobx_template) - React Native 与 MobX 模板
* [react-native-boilerplate-chucknorris ★15](https://github.com/Ali-Ayyad/react-native-boilerplate-chucknorris) - React Native + React Navigation + React Native Elements (iOS &amp; Android) 样板
* [react-native-template-super ★7](https://github.com/lohanitech/react-native-template-super) - 用于 react-native + React Navigation + Redux + Redux Persist 的 turbo starter 模板
* [rn-relay-drawer-template ★4](https://github.com/hiaw/rn-relay-drawer-template) - React Native 与 RNRF、drawer 和 relay 一起工作
* [react-native-community-maps ★3](https://github.com/yonahforst/react-native-community-maps) - 用于在地图上浏览用户生成的照片的样板应用程序
* [React Native Starter Kit](https://github.com/instamobile/react-native-starter-kit) - 带有用户入职元素的 React Native 入门工具包，包括 Firebase Auth 和 Facebook 登录集成.
* [Awesome React Native Boilerplates](https://github.com/appitr/awesome-react-native-boilerplates) - 使用最流行的 react-native 导航和 UI 库为您的开发提供有效的开端
* [react-int](https://github.com/leafOfTree/react-int) - 将 react/react-native 与 redux 和 redux-saga 一起使用的简单方法.
* [RNStarter](https://github.com/i-mighty/RNStarter) - ✨ 带有 10 多个常用库的 React Native Starter ✨

## Libraries

用于 React Native 开发的库/SDK 类型添加.

* [React Native Elements ★13599](https://github.com/dabit3/React-Native-Elements) - React Native UI 元素和组件的集合.
* [Shoutem UI ★3802](https://github.com/shoutem/ui) - 来自 Shoutem 的 React Native 的完整 UI 工具包.
* [Panza ★243](https://github.com/bmcmahen/panza) - 用于 react-native 的无状态、功能性、跨平台 ui 组件的集合.
* [BlankApp UI ★78](https://github.com/blankapp/ui) - 用于 React Native 的高度可定制和主题化组件.
* [react-native-easy-app ★220](https://github.com/chende008/react-native-easy-app) - React Native 一站式解决方案.
* [React Native Common ★49](https://github.com/rghorbani/react-native-common) - React Native 的 UI 和 API 组件库.
* [react-native-colibri ★5](https://github.com/nidorx/react-native-colibri) - React Native 通用 UI 组件.
* [Statek ★3](https://statek.dev) - 用于 React &amp; React Native 的简单 &amp; Reactive 状态管理库

## Open Source Apps

开源 React Native 应用程序和其他示例.

* [Artsy](https://github.com/artsy/eigen) - 移动应用程序 [artsy.net](https://artsy.net) . 发现美术. 口袋里的艺术世界.
* [f8app ★13070](https://github.com/fbsamples/f8app) - 2017 年官方 F8（Facebook 开发者大会）应用程序.请参阅 [blog post](http://makeitopen.com/blog/2017/12/04/blog-post-f82017-open-source.html).
* [30-days-of-react-native ★5192](https://github.com/fangwei716/30-days-of-react-native) - 30 天的 React Native 示例（灵感来自 30DaysofSwift）
* [react-native-nw-react-calculator ★4624](https://github.com/benoitvallon/react-native-nw-react-calculator) - 具有相同代码的移动、桌面和网站应用程序
* [GitPoint ★3833](https://github.com/gitpoint/git-point) - 适用于 iOS 和 Android 的移动 GitHub 客户端.
* [Hacker News (iOS & Android) ★3460](https://github.com/iSimar/HackerNews-React-Native)
* [reading ★2947](https://github.com/attentiveness/reading) - 阅读用 React-Native 编写的应用程序.
* [Status.im ★2470](https://github.com/status-im/status-react) - 以太坊客户端.
* [GitHub Popular ★2452](https://github.com/crazycodeboy/GitHubPopular) - 这是 GitHub 最受欢迎的 React Native 存储库查看器.
* [Dribbble React Native ★1927](https://github.com/catalinmiron/react-native-dribbble-app)
* [react-native-gitfeed ★1709](https://github.com/xiekw2010/react-native-gitfeed) - 另一个用 react-native 编写的 Github 客户端（iOS 和 android）
* [Finance React Native ★1680](https://github.com/7kfpun/FinanceReactNative) - 以 React Native 编写的 iOS 股票应用程序克隆，用于演示目的.
* [Quirk 🐙 ★965](https://github.com/flaque/quirk) - 适用于 iOS 和 Android 的认知行为疗法.
* [TaskRabbit's Sample App ★802](https://github.com/taskrabbit/ReactNativeSampleApp) - Task Rabbit 应用制作的试验场
* [React Weather ★702](https://github.com/stage88/react-weather) - 使用 React Native 构建的简单天气应用程序
* [Boostnote ★630](https://github.com/BoostIO/boostnote-mobile) - Boostnote：开源笔记.
* [react-native-sudoku ★540](https://github.com/nihgwu/react-native-sudoku) - 用 React Native 编写的数独游戏
* [react-native-hiapp ★513](https://github.com/BelinChung/react-native-hiapp) - 一个用 react-native 编写的简单且类似于 Twitter 的演示应用程序
* [React Native Netflix ★489](https://github.com/mariodev12/react-native-netflix) - 类似 Netflix 的应用程序.
* [what the thing? ★430](https://github.com/vigzmv/what_the_thing) - 将相机对准事物以学习如何用不同的语言说出来.
* [react-native-basketball ★425](https://github.com/FaridSafi/react-native-basketball) - Facebook 篮球游戏的克隆
* [Surmon.me.native ★406](https://github.com/surmon-china/surmon.me.native) surmon.me 的反应本机应用程序
* [An example React Native project for client login authentication ★402](https://github.com/ryanmcdermott/react-native-login)
* [GitterMobile ★387](https://github.com/terrysahaidak/GitterMobile) - 适用于 iOS 和 Android 的 Gitter（github 聊天）客户端
* [ReactNativeRedditReader ★345](https://github.com/akveo/react-native-reddit-reader)
* [Assemblies ★322](https://github.com/buildreactnative/assemblies) - a Meetup clone
* [DuckDuckGo App (Unofficial) ★273](https://github.com/kiok46/duckduckgo)
* [Ziliun React Native ★266](https://github.com/sonnylazuardi/ziliun-react-native) - 使用 React Native 构建的基于 Wordpress 的文章阅读器
* [Luno ★266](https://github.com/alwx/luno-react-native) - ClojureScript React Native 应用程序演示
* [ReactNativeHackerNews ★241](https://github.com/jsdf/ReactNativeHackerNews)
* [iOS Conference App made with React Native ★234](https://github.com/mikkoj/NortalTechDay)
* [MagicMirror ★232](https://github.com/ajwhite/MagicMirror)
* [Redux Demo ★226](https://github.com/chentsulin/react-native-counter-ios-android) - ReactNative iOS 和 Android 上 redux 计数器示例的最小实现
* [React Native Embedded App ★218](https://github.com/dsibiski/react-native-embedded-app-example) -在已有的iOS应用中使用React Native的例子合集
* [React Native Example, Geo and Location ★216](https://github.com/bgryszko/react-native-example)
* [uestc-bbs-react-native ★216](https://github.com/just4fun/uestc-bbs-react-native)  - 一个 iOS 客户端<http://bbs.uestc.edu.cn/>用 React Native 和 Redux 编写
* [Sh\*\*t! I Smoke ★209](https://github.com/amaurymartiny/shoot-i-smoke) - Know how many cigarettes you smoke based on the pollution of your location.
* [PxView ★198](https://github.com/alphasp/pxview) - 适用于 Android 和 iOS 的非官方 Pixiv 应用程序客户端
* [BBC News (Unofficial) ★187](https://github.com/joeltrew/BBCNews-React-Native) - BBC 新闻应用程序
* [HackerBuzz ★179](https://github.com/RCiesielczuk/HackerBuzz-ReactNative) - 黑客新闻阅读器.
* [Vecihi App ★170](https://github.com/yasintoy/vecihi) – 构建您自己的照片共享应用程序.
* [Rocket.Chat ★161](https://github.com/RocketChat/Rocket.Chat.ReactNative) - 开源团队沟通
* [HackerWeb ★158](https://github.com/cheeaun/hackerweb-native) - 适用于 iOS 和 Android 的简单易读的 Hacker News 网络应用程序.
* [Buyscreen sample ★151](https://github.com/appintheair/react-native-buyscreen)
* [NewsWatch video viewer ★150](https://github.com/bradoyler/newswatch-react-native)
* [YouTrack Mobile ★136](https://github.com/JetBrains/youtrack-mobile) – YouTrack 的客户端 – 来自 JetBrains 的问题跟踪器.
* [ndash ★129](https://github.com/alexindigo/ndash) - npm 仪表板.
* [Look Lock ★126](https://github.com/7kfpun/PhotosReactNative) - 一个可以无忧显示照片的应用程序.
* [Kakapo - ambient sound mixer ★126](https://github.com/bluedaniel/Kakapo-native)
* [Appointments ★116](https://github.com/iZaL/my-appointment) - 用于预约的成熟 ReactNative 应用程序
* [Alt/Flux Demo ★106](https://github.com/mrblueblue/react-native-alt-demo)
* [Buttercup Mobile ★103](https://github.com/buttercup/buttercup-mobile) - 手机密码管理器
* [Insta Snap ★102](https://github.com/iZaL/insta-snap) - 图片分享应用
* [live translator ★94](https://github.com/agrcrobles/react-native-live-translator) - 一款实时翻译您在手机上看到的内容的应用程序.
* [Finance MacOS React Native ★88](https://github.com/7kfpun/FinanceMacOSReactNative)  - 为 MacOS 编写的 iOS 股票应用程序克隆，支持 Touch Bar. 数据来自雅虎财经.
* [NBAreact ★88](https://github.com/jbkuczma/NBAreact)
* [Urban Dictionary ★83](https://github.com/edwinbosire/Urbandict) - 流行的 Urban Dictionary 网站的移动实施.
* [ASOS ★83](https://github.com/edwinbosire/ASOS) - ASOS 电子商务应用程序（克隆）
* [Reddit made with React Native and Redux ★81](https://github.com/KevinOfNeu/xReddit)
* [react-native-redux-facebook ★79](https://github.com/bkspace/react-native-redux-facebook) - 一个简单的 React Redux Facebook 身份验证演示应用程序.
* [Hekla for Hacker News ★77](https://github.com/birkir/hekla) - 具有 TypeScript、mobx-state-tree、本机导航和 css 模块的 Hackernews 客户端.
* [QRCode App ★74](https://github.com/insiderdev/react-native-qrcode-app) - 用于扫描和生成二维码的应用程序.
* [Nearby Live ★72](https://github.com/N3TC4T/Nearby-Live) - 适用于 Android 和 iOS 的非官方 NearbyLive 应用程序
* [SoundcloudMboX ★67](https://github.com/trazyn/SoundcloudMboX) SoundcloudMobX 是适用于 iOS 的 Soundcloud，使用 React-Native 和 MobX 构建.
* [Native iOS font list ★60](https://github.com/yayolius/react-native-font-list)
* [React Native Chromecast App ★56](https://github.com/holoed/ChromeCast_ReactNative)
* [MoeFM ★54](https://github.com/codeestX/MoeFM) - 使用 React Native 和 Redux 构建的轻量级 MusicPlayer，适用于 Android 和 iOS.
* [iTunesConnect ★53](https://github.com/oney/iTunesConnect) - 非官方 iTunes Connect 应用程序
* [Sequent ★52](https://github.com/sobstel/sequent) - 短期记忆训练游戏（W/Redux）.
* [AudienceNetworkReactNative ★50](https://github.com/7kfpun/AudienceNetworkReactNative) - Facebook 受众网络性能工具.
* [rndrawer-implemented-rnrouter ★50](https://github.com/efkan/rndrawer-implemented-rnrouter) - 一个 react-native-drawer 实现的示例和 react-native-router-flux 的脚手架
* [Magento 2 Mobile App ★47](https://github.com/troublediehard/magento-react-native) - 使用 React Native 构建的 Magento 2.x 移动应用程序
* [iOS app that transcript your voice with IBM Watson Cloud ★41](https://github.com/yrezgui/meowth-ios)
* [Splitcloud ★35](https://github.com/egm0121/splitcloud-app) - 分享同时从 Soundcloud 收听两首歌曲（通过拆分右/左声道）.
* [ZudVPN ★32](https://github.com/zudvpn/ZudVPN) - 在主要云提供商上部署私有 VPN [ZudVPN](https://www.zudvpn.com)
* [Todo List ★31](https://github.com/rishabhbhatia/react-native-todo) - Todo-List 应用程序使用 SwipeView，适用于 iOS 和 Android 的 ES6 标准.
* [Paramap ★30](https://github.com/twist900/paramap)  - 无障碍地图.  React-native 与 Redux 和 Firebase.  iOS 和安卓.
* [Confreaks ★29](https://github.com/cabaret/confreaks-react-native)
* [Vocab React Native ★27](https://github.com/thaiinhk/VocabReactNative) - 泰语词汇学习应用
* [Premier League ★25](https://github.com/ennioma/react-native-premier-league)
* [Roxie ★23](https://github.com/venepe/react-native-roxie) - 声音处理和蓝牙硬件控制.
* [Roverz ★21](https://github.com/mongrov/roverz) - 适用于 iOS 和 Android 上的 Rocket.Chat 的本机移动聊天客户端库.
* [Text Blast ★18](https://github.com/SeshApp/text-blast-react-native) - 具有类似功能的 MMS 文本爆破应用程序的 iOS 客户端 [ionic version](https://github.com/SeshApp/text-blast-ionic) 为了比较
* [NewYorkTimesTopStories ★14](https://github.com/vidyuthd/NYTimesTopStories-React-Native) - 阅读 NewYorkTimes 的 Topstories，使用其在 react-native 中为 android 编写的 api.
* [Quick-Sample ★14](https://github.com/innFactory/react-native-quick-sample) - 一个带有导航、数据持久性、redux、列表视图和动画的小而简单的示例应用程序.
* [iGap Plus ★13](https://github.com/RooyeKhat-Media/iGap-Plus)  - iGap+ 是一个跨平台的消息传递应用程序（目前为 Android、iOS 和 Windows UWP），并且是使用所有最新的现代技术创建的.  iGap+ 旨在轻松支持其他平台，如 web、macOS 和 linux.
* [Posters_Galore_Android ★11](https://github.com/marmelab/Posters_Galore_Android) - 使用 Redux 和 REST API 的实验性 Android 应用程序
* [react-native-medium-clap-animation ★11](https://github.com/saketkumar95/react-native-medium-clap-animation) - React Native 中的中型拍手动画
* [HupuApp ★9](https://github.com/MelonRice/ReactNative-HupuJRS)  - 第三方虎扑APP（<http://bbs.hupu.com/>  ) 客户端使用 React Native（Android 和 iOS）实现.
* [react-native-uber-clone ★9](https://github.com/saketkumar95/react-native-uber-clone) - Uber UI Clone with react native 中的动画
* [Commit Strip (Unofficial) ★8](https://github.com/rizalibnu/commit-strip-react-native) - 内置 React Native 的 CommitStrip.com 阅读器.
* [react-native-otello ★6](https://github.com/hiaw/react_native_otello) - 用 React Native 编写的黑白棋游戏
* [GitHub Jobs Search App (Unofficial) ★6](https://github.com/rizalibnu/github-jobs-react-native) - 在 React Native 中构建的 GitHub 职位搜索应用程序.
* [Minimal Quotes ★6](https://github.com/insiderdev/minimal-quotes) - 移动应用程序，以超级干净的最小版本向您抛出随机报价.
* [Hello Bemans ★5](https://github.com/rapportyou/HelloBemans) - 健康教练连接应用程序（安卓版）
* [RNV2ex ★5](https://github.com/dyygtfx/RNV2ex) - 对 v2ex 的反应本机
* [Renote ★4](https://github.com/mavajee/react-native-note-example) - 一个简单的 react-native 示例应用程序，用于做笔记.
* [Manyverse](https://github.com/staltz/manyverse) – 脱离网格的社交网络（Scuttlebutt Android 客户端）
* [Bristol Pound](http://blog.scottlogic.com/2017/11/22/developing-bristol-pound-an-open-source-react-native-app.html) - 一个适用于英国当地货币布里斯托尔镑的应用程序.
* [React Native Showcase](https://facebook.github.io/react-native/showcase.html)
* [Instagram clone](https://github.com/reindexio/reindex-examples/tree/master/react-native-gallery) - 一个 Instagram 克隆
* [Joplin](https://github.com/laurent22/joplin/tree/master/ReactNativeClient) - 适用于桌面、CLI 和移动设备的笔记应用程序（此处链接的是移动应用程序）.
* [Cat-or-dog](https://github.com/punksta/Cat-or-dog) - 带有拖放和动画的简单游戏.
* [Forex Rates](https://github.com/MicroPyramid/forex-rates-mobile-app)  - 外汇汇率. 货币汇率转换器. 历史汇率. 安卓和 iOS.
* [Smog Alert App](https://github.com/Bartozzz/smog-alert-app) – 提供世界各地的实时空气污染数据，并显示附近的污染者.
* [Audio Book App](https://github.com/minhtc/sachnoiapp) – 已完成的有声读物应用程序带有一些很酷的动画.
* [FastBuy](https://github.com/Bruno-Furtado/fastbuy-app) - 用于管理虚拟商店中的产品的应用程序（使用 React Native 和 Redux 构建）.
* [Hydropuzzle](https://github.com/hydropuzzle/hydropuzzle) - 时尚的益智冒险游戏.
* [Github-Gist](https://github.com/Arjun-sna/react-native-githubgist-client) - 为 github gist 反应本机移动应用程序
* [Lyrics King](https://github.com/SKempin/Lyrics-King-React-Native) - 极简时尚的歌词搜索应用程序.
* [TensorFlow.js Starter](https://github.com/t73liu/tfjs-starter) - 使用 MobileNet 预测图像类别的 TensorFlow.js 入门应用. [Blog post](https://t73liu.github.io/posts/experimenting-with-tfjs/) 额外的上下文.
* [Art Museum](https://github.com/pedrobern/react-native-art-museums-app) - 浏览无穷无尽的哈佛艺术博物馆藏品.
* [NMF.earth ★14](https://github.com/NotMyFaultEarth/nmf-app)  - 计算、了解并减少您的碳足迹. 适用于 Android 和 iOS，使用 Expo、Redux Toolkit 和 Typescript.
* [Nyxo ★12](https://github.com/hello-nyxo/nyxo-app)  - 睡眠追踪器和睡眠指导应用程序. 适用于 Android 和 iOS.
* [Post Card App ★1](https://github.com/adarsh0d/postcardApp)  - 创建旧式明信片并作为图像在 whatsapp 上分享. 使用 Expo 构建并可用于 android.


## Frameworks

* [NativeBase ★10520](https://github.com/GeekyAnts/NativeBase) - 在 React Native 之上构建一个层，为您提供用于移动应用程序开发的基本组件集
* [Awesome React Native Meteor ★152](https://github.com/meteor-factory/awesome-react-native-meteor) - 一起使用 Meteor 和 React Native 的很棒的资源列表
* [first-born ★106](https://github.com/99xt/first-born) - 具有预构建组件的 UI 框架，可根据底层移动平台单独呈现.
* [OsmiCSX ★48](https://github.com/OsmiCSX/osmicsx) - 用于快速构建自定义用户界面的实用 React Native 风格框架.
* [React Native Diagnose ★13](https://github.com/netbeast/react-native-diagnose) - 在运行时和生产期间测试 React Native 应用程序的框架

## Tutorials

帮助您学习 React Native 的演练和教程.

* [Fully-immersive, hands-on, and fun learning experience for React Native ★825](https://github.com/jondot/ReactNativeKatas)
* [React Native with Django backend ★12](https://github.com/shunpochang/connect_love_mobile_demo)
* [Setting up background tasks that run periodically when app is closed in React Native](https://hackernoon.com/easy-os-background-tasks-in-react-native-bc4476c48b8a)
* [Animate React Native UI Elements](https://egghead.io/courses/animate-react-native-ui-elements)
* [Build a streaming audio app with React Native](http://slides.com/jhabdas/streaming-audio-react-native/)
* [Building a Calculator for Android and iOS with React Native](https://kylewbanks.com/blog/react-native-tutorial-part-1-hello-react)
* [Building Custom React Native Components From Scratch](http://moduscreate.com/blog/react_native_custom_components_ios/)
* [Deploying React Native using Fastlane](https://shift.infinite.red/simple-react-native-ios-releases-4c28bb53a97b#.bjifers3r)
* [Enabling Live Reload](https://www.reddit.com/r/reactnative/comments/30hbg3/enabling_live_reload/)
* [Facebook's F8 App Walkthrough Tutorial: React Native, Redux, Relay, Flow, Jest](http://makeitopen.com/)
* [Facebook Login With React Native](http://brentvatne.ca/facebook-login-with-react-native)
* [Integrating Parse and React Native for iOS](http://www.raywenderlich.com/106369/integrating-parse-react-native-ios)
* [Introducing React Native (on Ray Wenderlich's)](http://www.raywenderlich.com/99473/introducing-react-native-building-apps-javascript)
* [Leverage Existing iOS Views In Your React Native App](http://moduscreate.com/blog/leverage-existing-ios-views-react-native-app/)
* [React Native Periscope Hearts Animation](http://browniefed.com/blog/2015/09/07/react-native-periscope-hearts-animation/)
* [React Native Youtube Animated Video Slide](http://browniefed.com/blog/2015/08/31/react-native-youtube-animated-video-slide/)
* [React Native and Socket.io](https://bullpen.bullish.io/how-to-actually-use-socket-io-in-react-native-39082d8d6172)
* [React-Native Animated with React-Art - Firework Tap To Shoot](http://browniefed.com/blog/2015/08/29/react-native-animated-with-react-art-firework-show/)
* [React-native Animated API Basic Example](http://browniefed.com/blog/2015/07/26/react-native-animated-api-basic-example/)
* [React-native Animated API with PanResponder](http://browniefed.com/blog/2015/08/15/react-native-animated-api-with-panresponder/)
* [React-native Animated ScrollView Row Swipe Actions](http://browniefed.com/blog/2015/08/01/react-native-animated-listview-row-swipe/)
* [React-native press and hold button actions](http://browniefed.com/blog/2015/08/22/react-native-press-and-hold-button-actions/)
* [React Native Express](http://www.reactnativeexpress.com/)
* [Simple React Native forms with redux-form, immutable.js and styled-components](http://esbenp.github.io/2017/01/06/react-native-redux-form-immutable-styled-components/)
* [A Mini-Course on React Native Flexbox](https://medium.com/@yoniweisbrod/a-mini-course-on-react-native-flexbox-2832a1ccc6)
* [The beauty of react-native -Build a stunning wallpaper app](https://www.smashingmagazine.com/2016/04/the-beauty-of-react-native-building-your-first-ios-app-with-javascript-part-1/)
* [Adding and removing custom fonts in React Native IOS Android](https://medium.com/@danielskripnik/how-to-add-and-remove-custom-fonts-in-react-native-b2830084b0e4#.s73pqh4ez)
* [Adding Custom Fonts to A React Native Application](https://medium.com/@dabit3/adding-custom-fonts-to-react-native-b266b41bff7f)
* [Building a Minimalist Weather App with React Native and Expo](https://blog.expo.io/building-a-minimalist-weather-app-with-react-native-and-expo-fe7066e02c09)
* [Getting Started with Lottie, React Native and Expo](https://hackernoon.com/react-native-getting-started-with-lottie-and-expo-8b2105fbb496)
* [How to integrate Redux into your application with React Native and Expo](https://medium.freecodecamp.org/how-to-integrate-redux-into-your-application-with-react-native-and-expo-ec37c9ca6033)
* [React Native for Designers](https://designcode.io/react-native)
* [Start React Native - Animation tutorial series](https://start-react-native.dev/)

## Books

书籍 - 免费和商业（但只有好书）.

* [Programming React Native](https://leanpub.com/programming-react-native) -（免费）一本深入的 React Native 书籍，您应该在完成其中许多教程后阅读.
* [React Native Animation Book](http://browniefed.com/react-native-animation-book/) -（免费）React Native 动画.

书籍 - 出售.

* [React Native In Action](https://www.manning.com/books/react-native-in-action) - 了解如何从头开始使用 React Native 构建应用程序.
* [React Native - Building Mobile Apps with JavaScript](https://www.packtpub.com/application-development/react-native-building-mobile-apps-javascript) - 使用 React 和 JavaScript 创建真正原生的 iOS 和 Android 移动应用程序的首选指南.
* [Fullstack React Native](https://fullstackreact.com/react-native/) - 最新、深入、完整的 React Native 指南.

## Videos

各种会议和培训视频.

### Talks
* 链式反应 2019： [React Native Only Playlist](https://www.youtube.com/playlist?list=PLq2wBqKQbpCqVKqZwysoo2MEDwVX7auhX)
* [awesome-react-native-talks ★312](https://github.com/mightyCrow/awesome-react-native-talks) - 关于 React Native 或与 React Native 相关的主题的精选列表.
* [Actually Building Things In React Native , Jani Eväkallio, Futurice](https://www.youtube.com/watch?v=ZqKYk0aTaYk)
* [Using Redux, Jonas Ohlsson, State](https://www.youtube.com/watch?v=Ola8U-SpL6U)
* [Native Testing](https://www.youtube.com/watch?v=6aVDe2Y-co4)
* [Reactotron](https://www.youtube.com/watch?v=tPBRfxswDjA)
* [React Native In The Wild - Bonnie Eisenman](https://www.youtube.com/watch?v=KWEhFWm0SL8)
* 链式反应 2019： [Playlist](https://www.youtube.com/watch?v=zEjqDWqeDdg&list=PLFHvL21g9bk2bTWTCP1BueiiIz8q258z9)
* 链式反应 2018： [Playlist](https://www.youtube.com/watch?v=UiPo9A9k7xc&t=0s&list=PLFHvL21g9bk1skdjnKVGXREDmP_HVDj-u)
* 链式反应 2017： [Playlist](https://www.youtube.com/watch?v=cz5BzwgATpc&list=PLFHvL21g9bk3RxJ1Ut5nR_uTZFVOxu522)
* 反应会议 2015： [Introducing React Native](https://youtu.be/KVZ-P-ZI6W4)
* 反应会议 2015： [A Deep Dive into React Native](https://youtu.be/7rDsRXj9-cU)
* F8 2015： [React Native and Relay](https://www.youtube.com/watch?v=X6YbAKiLCLU)

### Training & tutorials

* [Awesome React Native Education ★455](https://github.com/hsavit1/Awesome-React-Native-Education)
* [React Native training ★238](https://www.gitbook.com/book/unbug/react-native-training/details)
* [Let's build a React Native app in 20 minutes](https://www.youtube.com/watch?v=9ArhJiMGVDc) 和 [Gist](https://gist.github.com/peterjmag/2ef39ba5d25f3f1e0008)
* [Mario Díez Channel](https://www.youtube.com/channel/UCisGMoxaVxJMcbio2FBHORg/search?query=React+Native) - 西班牙语的 Youtube 频道有一系列关于 React Native 的视频
* [React Native Basics: Build a Currency Converter](http://learn.handlebarlabs.com/p/react-native-basics-build-a-currency-converter?ref=awesome-react-native) -（免费）一个多小时的深入视频课程，向您展示如何使用 React Native 构建应用程序.
* [React Native in Arabic: Build a newspaper app](https://www.youtube.com/playlist?list=PLk-CkzAysw4BLLNtATmnZOA8E8I6TP8MS) -（免费）一个简单易懂的阿拉伯语视频系列，向您展示如何使用 React Native 构建报纸应用程序.
* [Building Youtube UI in 30 Minutes](https://www.youtube.com/watch?v=LdKtugH-sb8)  - 一个快速教程，展示如何使用 React Native 构建 Youtube 移动应用程序的 UI. 本教程有助于从头开始编码设计.
* [Adding Authentication to a React Native Project](https://www.youtube.com/watch?v=dhOk7aNIzKw) - 本教程展示了如何使用以下方法轻松地将身份验证添加到 React Native 应用程序 [AWS Mobile Hub](https://aws.amazon.com/mobile/)
* [Generate React Native Forms](http://react.rocks/example/tcomb-form-native) 与 `tcomb-form-native`
* [Build a chat app with React Native](https://pusher.com/tutorials/chat-react-native)
* Egghead.io: [React Native Fundamentals](https://egghead.io/series/react-native-fundamentals)
* Pluralsight.com: [Build iOS Apps with React Native](http://www.pluralsight.com/courses/build-ios-apps-react-native)
* Udemy.com: [Build apps with React Native](https://www.udemy.com/the-complete-react-native-and-redux-course/)
* Udemy.com: [Create Your First React Native App](https://www.udemy.com/create-your-first-react-native-app/?couponCode=AWESOME-REACT-NATIVE) - 介绍构建 React Native 应用程序和学习基础部分.
* Handlebarlabs.com: [Learn React Native + Meteor](http://reactnativemeteor.com) - 关于使用 React Native 和 Meteor 构建应用程序的综合课程和社区.
* Udemy.com: [Automate Your React Native Releases with Fastlane & Bitrise](https://www.udemy.com/automate-your-react-native-releases-with-fastlane-and-bitrise/?couponCode=AWESOME-REACT-NATIVE) - 逐步了解如何使用 Fastlane 和 Bitrise 将您的 React Native 应用程序自动发布到商店中.

## Blogs

* [React Native Training](https://medium.com/react-native-training)
* [Use React Native Blog](http://www.reactnative.com/)
* [Facebook Code Blog](https://code.facebook.com/)
* [The Bakery](http://blog.thebakery.io/) - JavaScript、React、React Native 帖子.
* [Christopher Chedeau aka Vjeux](http://blog.vjeux.com/)
* [Brent Vatne](http://brentvatne.ca/)
* [Kyle Corbitt](https://corbt.com/posts/) - Emberall 的联合创始人.
* [Made with React](http://madewithreact.com/) - 展示使用 React 或 React Native 的应用程序.
* [Spencer Carli](https://medium.com/@spencer_carli)
* [Official React Native Blog](http://facebook.github.io/react-native/blog/)
* [reactnative.gallery](https://reactnative.gallery/) - 为 React Native 开发者展示和讲述
* [Ideamotive's Blog](https://www.ideamotive.co/blog/tag/react-native) - 关于 React Native 的博客

## Newsletters

* [React Native Now](https://reactnativenow.com)
* [React Native Newsletter](http://reactnative.cc)

## Releases

* [Stable: 0.57.0](https://github.com/react-native-community/react-native-releases/blob/master/CHANGELOG.md#057)
* [Next: latest](https://github.com/facebook/react-native/releases/latest)
* [All Versions](https://facebook.github.io/react-native/versions)
* [All Changelogs](https://github.com/react-native-community/react-native-releases/blob/master/CHANGELOG.md)
* [Upgrading Versions](https://facebook.github.io/react-native/docs/upgrading.html)
* [Release Process](http://facebook.github.io/react/blog/2015/05/22/react-native-release-process.html)
