<div class="github-widget" data-repo="glauberfc/awesome-react-hooks"></div>
## Awesome React Hooks [![Awesome](https://awesome.re/badge-flat.svg)](https://awesome.re)

[<img src="https://user-images.githubusercontent.com/15311858/47717137-ab421180-dc23-11e8-9ee8-a0de40260113.png">](https://reactjs.org/docs/hooks-intro.html)

关于 React Hooks 的精选列表.

 &gt; _Hooks 是 React 16.8 中的新增功能. 它们让你无需编写类就可以使用状态和其他 React 特性._



## Hooks

- [Introducing Hooks](https://reactjs.org/docs/hooks-intro.html)
- [Hooks at a Glance](https://reactjs.org/docs/hooks-overview.html)
- [Using the State Hook](https://reactjs.org/docs/hooks-state.html)
- [Using the Effect Hook](https://reactjs.org/docs/hooks-effect.html)
- [Rules of Hooks](https://reactjs.org/docs/hooks-rules.html)
- [Building Your Own Hooks](https://reactjs.org/docs/hooks-custom.html)
- [Hooks API Reference](https://reactjs.org/docs/hooks-reference.html)
- [Hooks FAQ](https://reactjs.org/docs/hooks-faq.html)

## Tutorials/Articles/Workshops

- [React Today and Tomorrow and 90% Cleaner React](https://www.youtube.com/watch?v=dpw9EHDh2bM) - 丹·阿布拉莫夫和索菲·艾伯特.
- [Making Sense of React Hooks](https://medium.com/@dan_abramov/making-sense-of-react-hooks-fdbde8803889) - 丹阿布拉莫夫.
- [React Hooks and Suspense](https://egghead.io/playlists/react-hooks-and-suspense-650307f2) - 肯特 C. 多兹.
- [React Hooks & testing: Stepping through React code](https://youtu.be/JQeB9miT9Wc) - 肯特 C. 多兹.
- [My Thoughts on React Hooks](https://youtu.be/gmF4k6P2va8) - 本·阿瓦德.
- [Fetching Data from an API with React Hooks useEffect](https://youtu.be/k0WnY0Hqe5c) - 本·阿瓦德.
- [Are React Hooks Slower than Class Components?](https://youtu.be/tKRWuVOEB2w) - 本·阿瓦德.
- [Building a Todo List with React Hooks useState](https://youtu.be/cAZ-fOd1RpA) - 本·阿瓦德.
- [Using React Hooks vs. Class Components](https://youtu.be/vbaIZ3xMj9U) - 本·阿瓦德.
- [Using Immer with Reducers and React Hooks](https://youtu.be/FmKjwh34Rn8) - 本·阿瓦德.
- [React Hooks useContext](https://youtu.be/xWXxkFzgnFM) - 本·阿瓦德.
- [Everything you need to know about React Hooks](https://medium.com/@vcarl/everything-you-need-to-know-about-react-hooks-8f680dfd4349) - 卡尔·维图洛.
- [Hooks in react-spring, a tutorial](https://medium.com/@drcmda/hooks-in-react-spring-a-tutorial-c6c436ad7ee4) - 保罗亨舍尔.
- [React Hooks: Notes Taken](https://medium.com/@tomaskonrady/react-hooks-notes-taken-c42376af3ab0) - 托马斯·康拉迪.
- [Getting Started with React Hooks](https://scotch.io/tutorials/getting-started-with-react-hooks) - 克里斯塞维利亚.
- [React hooks: not magic, just arrays](https://medium.com/@ryardley/react-hooks-not-magic-just-arrays-cd4f1857236e) - 鲁迪亚德利.
- [Why React’s new Hooks API is a game changer](https://itnext.io/why-reacts-hooks-api-is-a-game-changer-8731c2b0a8c) - 鲁迪亚德利.
- [Writing Custom React Hooks for GraphQL](https://medium.com/open-graphql/react-hooks-for-graphql-3fa8ebdd6c62) - 纳德会给
- [Manage global state with React Hooks](https://medium.com/@Charles_Stover/manage-global-state-with-react-hooks-6065041b55b4) - 查尔斯斯托弗.
- [React Hooks: Managing Web Sockets with useEffect and useState](https://medium.com/@rossbulat/react-hooks-managing-web-sockets-with-useeffect-and-usestate-2dfc30eeceec) - 罗斯回合.
- [Primer on React Hooks](https://testdriven.io/blog/react-hooks-primer/) - 奥斯汀约翰斯顿.
- [React Hooks - A deeper dive featuring useContext and useReducer](https://testdriven.io/blog/react-hooks-advanced/) - 奥斯汀约翰斯顿.
- [Advanced React Hooks Workshop](https://github.com/kentcdodds/advanced-react-hooks) - 肯特 C. 多兹.

## Discussions

- [v6 Candidate Preview: Use React Hooks for connect](https://github.com/reduxjs/react-redux/pull/1065) - 马克埃里克森.
- [RFC: React Hooks](https://github.com/reactjs/rfcs/pull/68) - 塞巴斯蒂安马克博格.
- [Using Hooks in React Native](https://github.com/facebook/react-native/issues/21967#issuecomment-434113687) - 赫克托·拉莫斯.

## Examples

- [Color Match](https://codesandbox.io/s/jjy215l7w3) - 颜色匹配游戏.
- [React Hooks counter](https://codesandbox.io/s/yjn90lzwrx?module=%2Fsrc%2FApp.js) - 使用 React Hooks 的 useState 计数器.
- [Toggle component](https://codesandbox.io/s/m449vyk65x) - 使用 React Hooks 制作的切换组件.
- [Hooks test](https://github.com/jacobp100/hooks-test) - 使用 React Hooks 相对较好地解决了一些复杂的用例.
- [React Hanger](https://github.com/kitze/react-hanger) - 反应衣架示例.
- [React Navigation Hooks](https://github.com/react-navigation/react-navigation-hooks) - 反应挂钩，方便反应导航使用.
- [Haunted](https://github.com/matthewp/haunted) - 为 Web 组件实现的 React 的 Hooks API.
- [useHooks](https://usehooks.com/) - 易于理解的 React Hook 食谱 [Gabe Ragland](https://twitter.com/gabe_ragland).
- [Collection of React Hooks](https://nikgraf.github.io/react-hooks/) - 反应钩子的集合.
- [React Spring demo](https://codesandbox.io/s/ppxnl191zx) - 演示 react-spring 如何使用 React Hooks 作为新的 API.
- [React Hooks](https://codesandbox.io/s/yq5qowzrvz) - React Hooks useState() 和 useEffect().
- [Hooks Todo App](https://codesandbox.io/s/9kwyzy0y4) - 使用 React Hooks 制作的应用程序.
- [react-thanos](https://github.com/codeshifu/react-thanos) - React 挂钩 Google 的 Thanos 复活节彩蛋的实现.

## Extensions/Libraries

- [redux-react-hook](https://github.com/facebookincubator/redux-react-hook) - React Hook 用于从 Redux 存储访问状态和调度.
- [react-use](https://github.com/streamich/react-use) - 基本的 React Hooks 集合.
- [The Platform](https://github.com/palmerhq/the-platform) - 浏览器 API 变成了 React Hooks 和常见情况下对 Suspense 友好的 React 元素.
- [eslint-plugin-react-hooks](https://www.npmjs.com/package/eslint-plugin-react-hooks) - 此插件强制执行挂钩规则以避免常见错误.
- [react-hooks-lib](https://github.com/beizhedenglong/react-hooks-lib) - 一组可重复使用的 React Hooks.
- [use-immer](https://github.com/mweststrate/use-immer) - 使用 immer 作为 React 钩子来操纵状态的钩子.
- [react-hanger](https://github.com/kitze/react-hanger) - React 16.7 的一小部分有用的钩子.
- [react-firebase-hooks](https://github.com/csfrequency/react-firebase-hooks) - 一组可重复使用的 Firebase React Hooks.
- [react-intersection-visible-hook](https://github.com/AvraamMavridis/react-intersection-visible-hook) - React hook 基于 IntersectionVisible Observer 跟踪功能组件的可见性.
- [use-timer](https://github.com/thibaultboursier/use-timer) - 用于处理计时器的简单 React 挂钩.
- [react-native-hooks](https://github.com/react-native-community/react-native-hooks) - React Native API 转变为 React Hooks，用于无状态 React 组件.
- [react-with-hooks](https://github.com/yesmeck/react-with-hooks) - 用于建议的 React Hooks API 的 Ponyfill.
- [react-hooks-screen-type](https://github.com/pankod/react-hooks-screen-type) - 确定 Bootstrap 4 网格的屏幕尺寸类型.
- [use-http](https://github.com/alex-cory/react-usefetch) - 用于发出同构 HTTP 请求的 React 挂钩.
- [react-fetch-hook](https://github.com/ilyalesik/react-fetch-hook) - React hook 方便使用 Fetch API.
- [storeon](https://github.com/storeon/storeon) - 173 字节的基于钩子的状态管理器.
- [react-hook-form](https://github.com/bluebill1049/react-hook-form) - 性能、灵活和可扩展的表单，易于验证.

## License

令人敬畏的 React 钩子是 [CC0 licensed](https://github.com/glauberfc/awesome-react-hooks/blob/master//LICENSE.md).
