<div class="github-widget" data-repo="iamericfletcher/awesome-r-learning-resources"></div>
<div align="center">
	<div>
		<a href=https://www.r-project.org/about.html><img width="400" id="im" src=https://user-images.githubusercontent.com/64165327/95934136-26177f00-0d9e-11eb-8bdc-748ee65ad17a.png></a>
	</div>
	<a href="https://awesome.re">
		<img src="https://awesome.re/badge-flat2.svg" alt="Awesome"></a>
</div>

<br>

> The `Awesome R Learning Resources` repository is meant to help users from all skill levels and backgrounds deepen their understanding of `R`, which is a programming language and environment for statistical computing and graphics.

<br>

> The `R` `Discord` server is a friendly and dedicated community for `R` enthusiasts, programmers, statisticians, data scientists, and students. Whether you are looking to connect with fellow useRs, have awesome data viz to share, or just needed help with your stats assignment, you are at the right place! 

<div align="center">
	To join the R Discord server, please click the discoRd badge below. <br>
<a href="https://discord.gg/6fcReuUHgg">
<img alt="Discord" src="https://img.shields.io/discord/676433858782298142?label=discoRd%20server&logo=R&logoColor=blue"></a>
<br>
</div>
<br>


## Topic Areas 

### Comprehensive R Tutorials

- [Data Flair](https://data-flair.training/blogs/r-tutorials-home/) - The tutorials are grouped by skill level (beginner, intermediate, expert). 
- [Intro to R course by Fabio Votta - part 1](https://colab.research.google.com/drive/1dLsdGbkvgn1JbWgsy9Z-pFmPd_2MG4Xu?usp=sharing#scrollTo=vGnW7giO9AeD) - A fun introduction to R programming grouped into categories (operators, objects, functions, exercises, and data frames).
- [Intro to R course by Fabio Votta - part 2](https://colab.research.google.com/drive/14CRElnKewnp5MnlxhqVu6OOcIXd-Bkaj?usp=sharing) - A fun introduction to R programming grouped into categories (data manipulation and cleaning featuring the janitor, tidyr, and dplyr packages).
- [Introduction to Data Analysis with R](https://jmbuhr.de/dataIntro20/) - This is a lecture series with videos, scripts and exercises introducing R and the tidyverse as well as statistical concepts.
- [R CODER](https://r-coder.com) - The tutorials are grouped into categories (introduction, data structures, data wrangling, programming, import & export, graphics) that cover in-depth all the basic needs for someone starting learning the R programming language. 
- [Tutorials Point](https://www.tutorialspoint.com/r/index.htm) - The tutorials are grouped into categories (R tutorial, R Data Interfaces, R Charts & Graphs, R Statistics Examples, R Useful Resources) that cover in-depth all the basic needs for someone starting learning the R programming language.

### Functions

- [stat.berkeley - Introduction to Functions](https://www.stat.berkeley.edu/~statcur/Workshop2/Presentations/functions.pdf) - An introduction to functions in the R language by the organizers of Integrating Computing into the Statistics Curricula (U.C. Berkeley).

### Generative Art

- [12 Months of aRt](https://www.williamrchase.com/work/art/) - In 2019, William Chase began a project to make a new series of artwork every month made entirely with R. In this project, he explored different techniques, developed algorithms, and provided detailed posts detailing the development process for each month.

### Joining Data

- [Joining Data in R with dplyr](https://rpubs.com/williamsurles/293454) - Course notes from the Joining Data in R with dplyr course on DataCamp. Topics include mutating joins, filtering joins and set operations, assembling data, advanced joining. Author: William Surles.

### Math

- [Descriptive Statistics](https://rcompanion.org/handbook/C_02.html) - A tutorial of descriptive statistics which are used to summarize data in a way that provides insight into the information contained in the data. Author: Salvatore S. Mangiafico.
- [Descriptive statistics in R](https://statsandr.com/blog/descriptive-statistics-in-r/) - This article explains how to compute the main descriptive statistics in R and how to present them graphically. Author - Antoine Soetewey.
- [Essential Math for Data Science](https://medium.com/s/story/essential-math-for-data-science-why-and-how-e88271367fbd) - An article discussing the key mathematical topics to master to become a better data scientist. Author: Tirthajyoti Sarkar.
- [Gallery of Statistical Distributions](https://www.itl.nist.gov/div898/handbook/eda/section3/eda366.htm) - Author: NIST/SEMATECH.
- [Plotting distributions (ggplot2)](http://www.cookbook-r.com/Graphs/Plotting_distributions_(ggplot2)/) - A tutorial for plotting a distribution of data. Author: Winston Chang.

### Shiny

- [Awesome R Shiny](https://github.com/grabear/awesome-rshiny) - A curated list of resources for R Shiny. Author: Rob Gilmore.
- [Building Shiny Applications with R Tutorial (Deprecated)](https://rstudio.github.io/shiny/tutorial/#) - Introductory tutorial to Shiny. Note, this tutorial is deprecated. Author: RStudio.
- [Building Shiny apps - an interactive tutorial](https://deanattali.com/blog/building-shiny-apps-tutorial/) - This tutorial is a hands-on activity complement to a set of [presentation slides](https://docs.google.com/presentation/d/1dXhqqsD7dPOOdcC5Y7RW--dEU7UfU52qlb0YD3kKeLw/edit) for learning how to build Shiny apps. Author: Dean Attali.
- [How to Start with Shiny](https://vimeo.com/rstudioinc/review/131218530/212d8a5a7a) - Detailed introductory video tutorial. Author: Garrett Grolemund.
- [Learn Shiny](https://shiny.rstudio.com/tutorial/) - The video and written tutorials on this page are primarily designed for users who are new to Shiny and want a guided introduction. Author: RStudio.
- [Shiny Articles](https://shiny.rstudio.com/articles/) - Various articles covering individual Shiny topics at a more advanced level. Author: RStudio.

### Spatial

- [An Introduction to Choropleth maps in R](https://rstudio-pubs-static.s3.amazonaws.com/324400_69a673183ba449e9af4011b1eeb456b9.html) - Author: Henry Cann.
- [Getting latitude & longitude for any address](https://discourse.looker.com/t/get-latitude-longitude-for-any-location-through-google-sheets-and-plot-these-in-looker/5402) - Author: Brecht Vermeire.
- [Map Plots Created With R And Ggmap](https://www.littlemissdata.com/blog/maps) - Author: Laura Ellis.
- [Plot Spatial Data / Shapefiles in R](https://www.youtube.com/watch?v=uZtto0cYjZM) - From the "math et al" YouTube channel.

### Viz

- [A ggplot2 Tutorial for Beautiful Plotting in R](https://cedricscherer.netlify.app/2019/08/05/a-ggplot2-tutorial-for-beautiful-plotting-in-r/) - A comprehensive and easy to follow tutorial that covers working with axes, titles, legends, backgrounds, grid lines, margins, multi-panel plots, colors, themes, lines, text, coordinates, chart types, ribbons, smoothings, and interactive plots. Author: Cédric Scherer.
- [AISEKA](https://www.aiseka.com/) - Discover the best Color Palette & Color Tools. Author: meetqy.
- [Awesome ggplot2](https://github.com/erikgahner/awesome-ggplot2) - A curated list of awesome ggplot2 tutorials, packages etc. Author: Erik Gahner Larsen.
- [Chart Suggestions — A thought-starter on choosing the way to show your data](https://extremepresentation.typepad.com/files/choosing-a-good-chart-09.pdf) - Author: Andrew Abela, Ph.D.
- [Color Hex Color Codes](https://www.color-hex.com/) - Author: Color-Hex.
- [Combine Multiple GGPlots into a Figure](https://www.datanovia.com/en/lessons/combine-multiple-ggplots-into-a-figure/) - Author: Alboukadel Kassambara.
- [Coolors](https://coolors.co/) - The super fast color schemes generator! Create the perfect palette or get inspired by thousands of beautiful color schemes. Features include color picker, pick palette from photo, create a collage, make your own gradient palette, create a gradient, contrast checker, etc.
- [From Data to Viz](https://www.data-to-viz.com/) - From Data to Viz leads you to the most appropriate graph for your data. Author: Yan Holtz.
- [ggplot2 extensions - gallery](https://exts.ggplot2.tidyverse.org/gallery/) - Maintained by Daniel Emaasit.
- [ggplot2 - Modify components of a theme](https://ggplot2.tidyverse.org/reference/theme.html) - How to modify components of a theme in ggplot2. Author: the developers of Tidyverse.
- [Graphics in R with ggplot2](https://www.statsandr.com/blog/graphics-in-r-with-ggplot2/) - A detailed guide for the use of graphics within ggplot2. Author: Antoine Soetewey.
- [htmlwidgets for R](https://www.htmlwidgets.org/) - Showcase and gallery of the various interactive web visualizations you can build using R. 
- [r-color-palettes](https://github.com/EmilHvitfeldt/r-color-palettes) - Comprehensive list of color palettes available in r. Author: Emil Hvitfeldt.
- [The Data Visualization Catalogue](https://datavizcatalogue.com/index.html) - The Data Visualization Catalogue is a project developed by Severino Ribecca to create a library of different information visualization types.
- [The Graphic Continuum](https://www.informationisbeautifulawards.com/showcase/611-the-graphic-continuum) - The Graphic Continuum shows the many different types of visualizations available to us when we encode and present data. Authors: Jonathan Schwabish, and Severino Ribecca.
- [The R Graph Gallery](https://www.r-graph-gallery.com/) - A collection of charts made with the R programming language. Author: Yan Holtz.
- [Time Based Heatmaps in R](https://www.littlemissdata.com/blog/heatmaps) - Author: Laura Ellis.
- [Top 50 ggplot2 Visualizations - The Master List (With Full R Code)](http://r-statistics.co/Top50-Ggplot2-Visualizations-MasterList-R-Code.html) - This tutorial helps you choose the right type of chart for your specific objectives and how to implement it in R using ggplot2. Author: Selva Prabhakaran.

### Web Scraping

- [Web Scraping Reference: Cheat Sheet for Web Scraping using R](https://github.com/yusuzech/r-web-scraping-cheat-sheet) - Guide, reference and cheatsheet on web scraping using rvest, httr and Rselenium. Author: [yifyan et al.](https://github.com/yusuzech)

### Wrangling

- [Data Wrangling Part 1: Basic to Advanced Ways to Select Columns](https://suzan.rbind.io/2018/01/dplyr-tutorial-1/) - Author: Suzan Baert.
- [Data Wrangling Part 2: Transforming your columns into the right shape](https://suzan.rbind.io/2018/02/dplyr-tutorial-2/) - Author: Suzan Baert.
- [Data Wrangling Part 3: Basic and more advanced ways to filter rows](https://suzan.rbind.io/2018/02/dplyr-tutorial-3/) - Author: Suzan Baert.
- [Data Wrangling Part 4: Summarizing and slicing your data](https://suzan.rbind.io/2018/04/dplyr-tutorial-4/) - Author: Suzan Baert.

### Uncategorized

- [Data.Table and Dplyr Tour](https://atrebas.github.io/post/2019-03-03-datatable-dplyr/#reshape-data) - A detailed comparison of R packages data.table and dplyr. Author: Atrebas.
- [data.table: A gentle introduction](https://atrebas.github.io/post/2020-06-17-datatable-introduction/) - A quick introduction to data.table. The main objective is to present the data.table syntax, showing how to perform basic, but essential, data wrangling tasks. Author: Atrebas.
- [Fakir - Create Fake Data in R for Tutorials](https://thinkr-open.github.io/fakir/) - Author: Colin Fay.
- [From base R to stringr](https://stringr.tidyverse.org/articles/from-base.html) - This vignette compares stringr functions to their base R equivalents to help users transitioning from using base R to stringr. Author: Sara Stoudt.
- [Help me help you: creating reproducible examples](https://www.youtube.com/watch?v=5gqksthQ0cM) - Making a great reprex is both an art and a science and this webinar will cover both aspects. A reprex makes a conversation about code more efficient and pleasant for all. This comes up whenever you ask someone for help, report a bug in software, or propose a new feature. The reprex package (https://reprex.Tidyverse.org) makes it especially easy to prepare R code as a reprex, in order to share on sites such as https://community.rstudio.com, https://github.com, or https://stackoverflow.com. Author: Jenny Bryan.
- [R - discoRd server](https://discord.gg/88uG5UVyE2) - Dedicated discoRd server with the following topic-based channels: `R-Main` for more general discussions, `R-Share` for showing off your data visuals, `General R Help` for asking questions and sharing learning resources, and `Topical Help/Discussion` for issues dealing with statistics, dbi, tidymodels, shiny, natural-science, social-science, bayesians, gis, and finance. 
- [Subreddit - r/Rlanguage - R Programming Language](https://www.reddit.com/r/Rlanguage/new/) - A Reddit subreddit focused on implementing the R programming language for statistics and data science.
- [Subreddit - r/programming - The R Project for Statistical Computing](https://www.reddit.com/r/rprogramming/) - A Reddit subreddit focused on using R for statistical computing.
- [Syntax equivalents: base R vs Tidyverse](https://tavareshugo.github.io/data_carpentry_extras/base-r_tidyverse_equivalents/base-r_tidyverse_equivalents.html) - A detailed comparison of base R and tidyverse. Author: Hugo Tavares.
- [The ultimate R data.table cheat sheet](https://www.infoworld.com/article/3575086/the-ultimate-r-datatable-cheat-sheet.html) - Find code for dozens of data tasks in this searchable cheat sheet of R data.table and Tidyverse code. Author: Sharon Machlis.


## Blogs

- [Alex Cookson](https://www.alexcookson.com/) - Alex Cookson loves making beautiful visualizations and easy-to-read walkthroughs of R concepts. He's particularly interested in data about media, like books, movies, and musicals.
- [Avery Robbins](https://www.avery-robbins.com) - Avery Robbins loves to learn and to share useful or awesome things that have benefited him personally. This website is a tool for him to actively do just that: share knowledge, ideas, and tips that are helpful.
- [Tony ElHabr](https://tonyelhabr.rbind.io/) - Tony ElHabr is passionate mostly about energy markets and sports analytics. His blog provides detailed tutorials, project explanations, and presentations.
- [Cédric Scherer](https://cedricscherer.netlify.app/) - Cédric Scherer is a graduated computational ecologist and freelance data visualization expert who has created visualizations across all disciplines, purposes, and styles and regularly teaches data visualization principles, R, and ggplot2. 
- [Data Imaginist](https://www.data-imaginist.com/) - Thomas Lin Pedersen is a data scientist turned software engineer who focuses on improving researchers’ interactions with the data they produce.
- [Data meets Narrative](http://www.rebeccabarter.com/blog/) - Rebecca Barter enjoys making sense of complex, messy and sometimes nonsensical datasets, such as electronic health records, and insurance claims. Her dual passions are explaining “seemingly complicated” concepts to others in plain English, and exploring and uncovering the stories that underlie complex datasets.
- [HighlandR](https://johnmackintosh.net/) - John Mackintosh's blog is a place for him to showcase demonstrations or workshops, notes he's learned at work, chart makeovers, and techniques and technology that he doesn't currently use in his role.
- [Julia Silge](https://juliasilge.com/blog/) - Julia Silge is a data scientist and software engineer at RStudio where she work on open source modeling tools. She is passionate about making beautiful charts, the statistical programming language R, Jane Austen, black coffee, and red wine.
- [Musings on R](https://martinctc.github.io/blog/) - A blog on all things R and Data Science by Martin Chan. Topics covered include comparing dplyr and data.table, Shiny apps, ggplot, data cleaning, using RStudio, interviews with other R users/data scientists, and web scraping.
- [rweekly](https://rweekly.org/about) - Weekly Updates from the Entire R Community by Bruce Zhao, Colin Fay, Eric Nantz, Hao Zhu, Jon Calder, Jonathan Carroll, Maëlle Salmon, Ryo Nakagawara, and Wolfram Qin.
- [r-bloggers](https://www.r-bloggers.com/) - R-Bloggers.com was created by Tal Galili and is a blog aggregator of content contributed by bloggers who write about R (in English). The site helps R bloggers and users to connect and follow the R blogosphere.
- [Ryo Nakagawara](https://ryo-n7.github.io/) - Ryo Nakagawara is a Data Scientist and has been doing work as both a reporting analyst and a software developer in R and SQL to improve ACDI and VOCA data pipelines, create R packages, reproducible reports, dashboards, and Shiny apps to communicate how his projects worldwide are progressing.
- [Statistics Globe](https://statisticsglobe.com/) - Joachim Schork started this platform to share his statistical know-how and to improve his own statistical skills by discussing with other statisticians and programmers.
- [Stats and R](https://www.statsandr.com/) - Through his blog, Antoine Soetewey (PhD in statistics) aims at helping academics and professionals working with data to grasp important statistical concepts, and shows how to apply them in R.

## Books

- [A Sufficient Introduction to R](https://dereksonderegger.github.io/570L/) - This book is intended to guide people that are completely new to programming along a path towards a useful skill level using R. Author: Derek L. Sonderegger.
- [An Introduction to Statistical Learning](http://faculty.marshall.usc.edu/gareth-james/ISL/ISLR%20Seventh%20Printing.pdf) - This book provides an introduction to statistical learning methods. Authors: Gareth James, Daniela Witten, Trevor Hastie and Robert Tibshirani.
- [Advanced R](https://adv-r.hadley.nz/introduction.html) - This book is designed for R programmers who want to deepen their understanding of the language, and programmers experienced in other languages who want to understand what makes R different and special. [Exercise Solutions](https://advanced-r-solutions.rbind.io/) Author: Hadley Wickham.
- [An Introduction to R](https://cran.r-project.org/doc/manuals/r-release/R-intro.pdf) - This introduction to R is derived from an original set of notes describing the S and S-Plus environments written in 1990–2 by Bill Venables and David M. Smith when at the University of Adelaide.
- [An Introduction to R](https://intro2r.com/) - The aim of this book is to introduce you to using R, a powerful and flexible interactive environment for statistical computing and research. Authors: Alex Douglas, Deon Roos, Francesca Mancini, Ana Couto & David Lusseau
- [Answering Questions with Data](https://crumplab.github.io/statistics/) - This is a free textbook teaching introductory statistics for undergraduates in Psychology. The textbook was written with math-phobia in mind and attempts to reduce the phobia associated with arithmetic computations. Author: Matthew J. C. Crump.
- [Data Science in a Box](https://datasciencebox.org/index.html) - The core content of the course focuses on data acquisition and wrangling, exploratory data analysis, data visualization, inference, modelling, and effective communication of results.
- [Data Science in Education Using R](https://datascienceineducation.com/) - This book is primarily about learning to use R as a tool for data science in education. Authors: Ryan A. Estrellado, Emily A. Bovee, Jesse Mostipak, Joshua M. Rosenberg, and Isabella C. Velásquez.
- [Efficient R programming](https://csgillespie.github.io/efficientR/) - Efficient R Programming is about increasing the amount of work you can do with R in a given amount of time. It’s about both computational and programmer efficiency. Authors: Colin Gillespie, Robin Lovelace.
- [Engineering Production-Grade Shiny Apps](https://engineering-shiny.org/) - This book covers the process of building a Shiny application that will later be sent to production. Authors: Colin Fay, Sébastien Rochette, Vincent Guyader, Cervan Girard.
- [Exploratory Data Analysis with R](https://bookdown.org/rdpeng/exdata/) - This book covers the essential exploratory techniques for summarizing data with R. These techniques are typically applied before formal modeling commences and can help inform the development of more complex statistical models. Author: Roger D. Peng.
- [Forecasting: Principles and Practice](https://otexts.com/fpp3/) - This textbook is intended to provide a comprehensive introduction to forecasting methods and to present enough information about each method for readers to be able to use them sensibly. Authors: Rob J Hyndman and George Athanasopoulos.
- [Geocomputation with R](https://geocompr.robinlovelace.net/) - This book is about using the power of computers to do things with geographic data. It teaches a range of spatial skills, including reading, writing and manipulating geographic data; making static and interactive maps; applying geocomputation to solve real-world problems; and modeling geographic phenomena. Authors: Robin Lovelace, Jakub Nowosad, Jannes Muenchow.
- [ggplot2: Elegant Graphics for Data Analysis](https://ggplot2-book.org/index.html) - This book provides a hands-on introduction to ggplot2 with lots of example code and graphics. It also explains the grammar on which ggplot2 is based. Author: Hadley Wickham.
- [Happy Git and GitHub for the useR](https://happygitwithr.com/) - Happy Git provides opinionated instructions on how to install Git and get it working smoothly with GitHub, in the shell and in the RStudio IDE, develop a few key workflows that cover your most common tasks, and integrate Git and GitHub into your daily work with R and R Markdown. Authors: Jenny Bryan, the STAT 545 TAs, Jim Hester.
- [Introduction to Data Science - Data Analysis and Prediction Algorithms with R](https://rafalab.github.io/dsbook/) - This book started out as the class notes used in the HarvardX Data Science Series. It introduces concepts and skills that can help you tackle real-world data analysis challenges. It covers concepts from probability, statistical inference, linear regression, and machine learning. It also helps you develop skills such as R programming, data wrangling with dplyr, data visualization with ggplot2, algorithm building with caret, file organization with UNIX/Linux shell, version control with Git and GitHub, and reproducible document preparation with knitr and R markdown.  Author: Professor Rafael A. Irizarry.
- [Introduction to Probability and Statistics Using R](http://www.atmos.albany.edu/facstaff/timm/ATM315spring14/R/IPSUR.pdf) - The book can be subdivided into three basic parts. The first part includes the introductions and elementary descriptive statistics; I want the students to be knee-deep in data right out of the gate. The second part is the study of probability, which begins at the basics of sets and the equally likely model, journeys past discrete/continuous random variables, and continues through to multivariate distributions. The chapter on sampling distributions paves the way to the third part, which isinferential statistics. This last part includes point and interval estimation, hypothesis testing, and finishes with introductions to selected topics in applied statistics. Author: G. Jay Kerns.
- [Introduction to R & Spatial Data with Raster and Terra](https://rspatial.org/intr/index.html) - This document provides a concise introduction to R. It emphasizes what you need to know to be able to use the language in any context. Author: Professor Robert Hijmans.
- [JavaScript for R](https://book.javascript-for-r.com/) - The ultimate aim of this work is to demonstrate to the reader the many great benefits one can reap by inviting JavaScript into their data science workflow. Author: John Coene.
- [Learning Statistics with R](https://learningstatisticswithr.com/) - Learning Statistics with R covers the contents of an introductory statistics class, as typically taught to undergraduate psychology students, focusing on the use of the R statistical software. Author: Danielle Navarro.
- [Mastering Shiny](https://mastering-shiny.org/) - This is the online version of Mastering Shiny, a book currently under early development and intended for a late 2020 release. This book complements the [Shiny online documentation](https://shiny.rstudio.com/) and is intended to help app authors develop a deeper understanding of Shiny. Author: Hadley Wickham. [Mastering Shiny Exercise solutions](https://mastering-shiny-solutions.org/index.html)
- [Modern R with the tidyverse](https://b-rodrigues.github.io/modern_R/) - The idea of Chapters 1 to 7 is to make you efficient with R as quickly as possible, especially if you already have prior programming knowledge. Starting with Chapter 8 you will learn more advanced topics, especially programming with R. Author: Bruno Rodrigues.
- [Modern Statistics with R](http://www.modernstatisticswithr.com/) - From wrangling and exploring data to inference and predictive modelling. The book includes plenty of examples and more than 200 exercises with worked solutions. Author: Måns Thulin.
- [Practical Data Science with R](https://www.manning.com/books/practical-data-science-with-r-second-edition#toc) - The intent of this book is to present data science from a pragmatic, practice-oriented viewpoint. The book concentrates on the process of data science, from the planning stages of a project, through the data collection and exploration, to the modeling, and finally to deployment and the sharing of results. Authors: Nina Zumel and John Mount.
- [Practical Regression and Anova using R](https://cran.r-project.org/doc/contrib/Faraway-PRA.pdf) - The emphasis of this text is on the practice of regression and analysis of variance. The objective is to learn what methods are available and more importantly, when they should be applied. Author: Julian Faraway.
- [Practicals and Exercises](http://www.columbia.edu/~cjd11/charles_dimaggio/DIRE/resources/R/practicalsBookNoAns.pdf) - This series of exercises reviews some of the content discussed during the author's lectures, and introduces some other basic concepts about working with data in R. Author: Charles DiMaggio, PhD.
- [Quantitative Politics with R](http://qpolr.com/qpolr.pdf) - The aim of this book is to provide an easily accessible introduction to R for the
collection, study and presentation of different types of political data. Authors: Erik Gahner Larsen and Zoltán Fazekas.
- [R Cookbook, 2nd Edition](https://rc2e.com/index.html) - This book is full of how-to recipes, each of which solves a specific problem. The recipe includes a quick introduction to the solution followed by a discussion that aims to unpack the solution and give you some insight into how it works. Authors: James (JD) Long and Paul Teetor.
- [R for Data Science](https://r4ds.had.co.nz/) - This book will teach you how to do data science with R. You will learn how to get your data into R, get it into the most useful structure, transform it, visualize it and model it. [Exercise Solutions](https://jrnold.github.io/r4ds-exercise-solutions/) Authors: Garrett Grolemund and Hadley Wickham.
- [R Packages](http://r-pkgs.had.co.nz/) - In this book you will learn how to turn your code into packages that others can easily download and use. Author: Hadley Wickham.
- [R Programming for Data Science](https://leanpub.com/rprogramming) - This book brings the fundamentals of R programming to you, using the same material developed as part of the industry-leading Johns Hopkins Data Science Specialization. Author: Roger Peng.
- [R Tutorial – Be a Data Science rock star with R](https://data-flair.training/blogs/r-tutorial/) - A tour of the R programming language that explores its different and essential concepts. This R DataFlair Tutorial Series is designed to help beginners to get started with R and experienced to brush up their R programming skills and gain perfection in the language.
- [Statistical Inference via Data Science](https://moderndive.com/) - This is intended to be a gentle introduction to the practice of analyzing data and answering questions using data the way data scientists, statisticians, data journalists, and other researchers would. Authors: Chester Ismay and Albert Y. Kim.
- [Supervised Machine Learning for Text Analysis in R](https://smltar.com/) - This book focuses on supervised or predictive modeling for text, using text data to make predictions about the world around us. Authors: Emil Hvitfeldt and Julia Silge.
- [Text Mining with R](https://www.tidytextmining.com/) - This book serves as an introduction of text mining using the tidytext package and other tidy tools in R. Authors: Julia Silge and David Robinson.
- [The Art of R Programming](http://diytranscriptomics.com/Reading/files/The%20Art%20of%20R%20Programming.pdf) - This book is for those who wish to learn about developing software in R. Author: Norman Matloff.
- [The Book of R](https://web.itu.edu.tr/~tokerem/The_Book_of_R.pdf) - The aim of The Book of R: A First Course in Programming and Statistics is to provide a relatively gentle yet informative exposure to the statistical software environment R, alongside some common statistical analyses, so that readers may have a solid foundation from which to eventually become experts in their own right. [Exercise solutions](https://nostarch.com/bookofr) Author: Tilman M. Davies.
- [The R Inferno](http://www.burns-stat.com/pages/Tutor/R_inferno.pdf) - A book about trouble spots, oddities, traps, and glitches in R. Author: Patrick Burns.
- [The R Language](https://stat.ethz.ch/R-manual/R-patched/doc/html/) - An introduction to R written by the authors of the R language.
- [Tidy Modeling with R](https://www.tmwr.org/) - This book is a guide to using a new collection of software in the R programming language for model building.

## Communities of Practice

> A community of practice is a group of people who share a concern or a passion for something they do and learn how to do it better as they interact regularly.

- [TidyTuesday](https://github.com/rfordatascience/tidytuesday) - TidyTuesday is a weekly data project aimed at the R ecosystem with an emphasis placed on understanding how to summarize and arrange data to make meaningful charts.
- [R for Data Science (R4DS) Online Learning Community](https://www.rfordatasci.com/) - Founded by Jessie Mostipak (@kierisi) to create a supportive and responsive online space for learners and mentors to gather and work through the R for Data Science book by Garrett Grolemund and Hadley Wickham. Grown into a community of R learners at all skill levels working together to improve their skills.

## Podcasts 

- [Not so Standard Deviations](http://nssdeviations.com/) - A data science podcast where Roger Peng and Hilary Parker talk about the latest in data science and data analysis in academia and industry.
- [The R-Podcast](https://r-podcast.org/) - Practical advice on how to take advantage of R to accomplish innovative and robust data analyses. Hosted by Eric Nantz.

## YouTube

- [Andrew Couch](https://www.youtube.com/channel/UCnwYO3Sz_emBTC1sTZ6TlsQ) - Topics include modeling, creating functions, dashboards, and forecasting.
- [Ben Stenhaug](https://www.youtube.com/user/benastenhaug/videos) - Topics include saving and reading data, map functions in purrr, t-tests, item response theory, and the basics of R and the tidyverse.
- [Cédric Scherer](https://www.youtube.com/playlist?list=PLd6eTXMmV3X-4-pHkZSJwHRACzSSyeT9T) - A collection of talks and seminars about R-related topics such as ggplot2 or Shiny, and data visualization in general.
- [Colin Quirk](https://www.youtube.com/channel/UC-vtwz7ueU2dtnHk5e-WblA) - Topics include regular expressions, data types, Shiny, and gganimate.
- [Data Analysis and Visualization Using R](https://www.youtube.com/channel/UClLf9MZuUy89IwGtRHC0RzQ) - Topics for the online course Data Analysis and Visualization Using R.
- [Data Science with Tom](https://www.youtube.com/channel/UCb5aI-GwJm3ZxlwtCsLu78Q) - Topics include time series, analyzing word relationships with ggraph and tidytext, and tidymodels.
- [David Jablonski](https://www.youtube.com/channel/UCzE7zgPikKvVUJPBKrndHMA) - The UC Berkeley R Bootcamp playlists include videos on R basics, handling data, performing calculations, programming, graphics, workflows, and statistics.
- [David Robinson](https://www.youtube.com/channel/UCeiiqmVK07qhY-wvg3IZiZQ) - Topics include graphing for EDA, data manipulation, animated mapping, visualization, text mining, time series, forecasting, regression, bootstrapping, package development, network graphs, ANOVA, JSON, simulation, survival analysis, and tidymetrics. Click [here](https://github.com/dgrtwo/data-screencasts/tree/master/screencast-annotations) for detailed TidyTuesday screencast annotations.
- [Dean Attali](https://www.youtube.com/c/DAattali/videos) - Shiny, including several videos on debugging Shiny.
- [Dragonfly Statistics](https://www.youtube.com/c/DragonflyStatistics/videoss) - Topics include numerical computing, generating random walks, markov chains, encoding categorical variables, probability, correlation plots, feature engineering, time series, binary classifiers, models, data.table, confusion matrices, machine learning, geocoding, summary statistics, and simulation.
- [IDG TECHtalk](https://www.youtube.com/playlist?list=PL7D2RMSmRO9JOvPC1gbA8Mc3azvSfm8Vv) - Do More with R playlist includes tutorials on shiny, data.table, getting API data, using Git and Github with R, writing your own packages, run Python in R code, RStudio addins and keyboard shortcuts, dashboards and flexdashboards.
- [Julia Silge](https://www.youtube.com/channel/UCTTBgWyJl2HrrhQOOc710kA) - Topics include predictive text modeling, impute missing data, tidymodels, sentiment analysis, multinomial classification, principal component analysis, data preprocessing and resampling, and multinomial classification.
- [Lander Analytics](https://www.youtube.com/channel/UC2-hKemnrmVCH_29duyJ26A/videos) - In-depth talks by different experts on a wide variety of topics.
- [MarinStatsLectures](https://www.youtube.com/c/marinstatlectures/featured) - Topics include descriptive statistics, ANOVA, bootstrapping, linear regression, bivariate analysis, and probability distributions.
- [Numyard](https://www.youtube.com/c/TheLearnR/videos) - Topics include working with dataframes, for loops, basic math, vectors, lists, creating functions, data types, and random sampling.
- [R Programming 101](https://www.youtube.com/c/RProgramming101/featured) - This channel provides teaching videos on data analysis and statistical analysis using R programming. The teaching videos include subjects like data cleaning, data manipulation, data visualization, statistical analysis, and machine learning and AI (artificial intelligence).
- [Richard Webster](https://www.youtube.com/channel/UC5ktyacv_aPSBmKB7uX5Piw/videos) - Topics include the paste function, the apply family of functions, while and for loops, conditional statements, visualization, removing NAs, and combining data.
- [RichardOnData](https://www.youtube.com/playlist?list=PLOKCg4WX8ZG4nboHnOgA8PJxGWnO4csiZ) - The R playlist includes videos on manipulating data with dplyr, visualizing data with ggplot2 and ggThemeAssist, data types and structures, important base r functions, handling datetimes with lubridate, conquering factors with forcats, manipulating text with stringr. 
- [Shiny Developer Series](https://www.youtube.com/c/ShinyDeveloperSeries/videos) - The goals of the Shiny Developer Series are to showcase the innovative applications and packages in the ever-growing Shiny ecosystem, as well as the brilliant developers behind them! 
- [Simplilearn](https://www.youtube.com/playlist?list=PLEiEAq2VkUUKAw0aAJ1W4jpZ1q9LpX4yG) - The R Programming for Beginners playlist includes videos on data science, charting, data visualization, algorithms, business analytics, regression, random forest, SVM, clustering, time series, modeling, and analytical techniques.
- [Statistics Globe](https://www.youtube.com/channel/UCyHEww8_SCdxZvEnkCfi55w) - A collection of short but detailed tutorials on how to work through common problems you will face while using R. Topics include data formatting, reordering data, strings, and ggplot2.
- [StatistikinDD](https://www.youtube.com/c/StatistikinDD/featured) - Playlists on Efficient R Programming (e. g. running R code in parallel), Visualization, Regression Analyses.
- [StatQuest with Josh Starmer](https://www.youtube.com/playlist?list=PLblh5JKOoLUJJpBNfk8_YadPwDTO2SCbx) - The Statistics and Machine Learning in R playlist deals with principal component analysis, random forest, regression, ROC and AUC, and ridge, lasso and elastic-net.
- [TidyX](https://www.youtube.com/channel/UCP8l94xtoemCH_GxByvTuFQ) - TidyX is a screen cast where the hosts select code from the TidyTuesday project and go through their code line-by-line, explaining what they did and how the functions they used work. They also break down the visualizations they create and talk about how to apply similar approaches to other data sets. The objective is to help more people learn R and get involved in the TidyTuesday community.

## Contributing
- Your contributions are always welcome! Please visit our [contributing.md](https://github.com/iamericfletcher/r-learning-resources/blob/main/contributing.md) to learn how to contribute to this list.
