<div class="github-widget" data-repo="woop/awesome-quantified-self"></div>
## Awesome Quantified Self [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)




> Carefully curated list of awesome Quantified Self resources.

The [Quantified Self](https://en.wikipedia.org/wiki/Quantified_Self) is a movement to incorporate technology into data acquisition on aspects of a person's daily life in terms of inputs (e.g. food consumed, quality of surrounding air), states (e.g. mood, arousal, blood oxygen levels), and performance (mental and physical).

Contributions welcome. Add links through pull requests or create an issue to start a discussion.



## Websites and Resources

- [Quantified Self](http://quantifiedself.com/) - Official website.
- [Flowing Data](http://flowingdata.com/category/self-surveillance/) - Self surveillance and quantification news.
- [Wolfram Connected Devices Project](http://devices.wolfram.com/) - IoT and Quantified Self device list.

## Articles & Blogs

- [The Personal Analytics of My Life by Stephen Wolfram](http://blog.stephenwolfram.com/2012/03/the-personal-analytics-of-my-life/) - Stephen Wolfram explores the data he has collected on the use of his time.
- [Measured Me](http://measuredme.com/) - Personal experiment in self-quantification and self-optimization.
- [Lifestream Blog](http://lifestreamblog.com/) - Social data aggregation, lifelogging, Quantified Self and digital legacy.
- [Quantified Bob](https://www.quantifiedbob.com/) - Follow one guy's quest for self knowledge, betterment, and optimization through experimentation and personal analytics.
- [Shadow of the Stream](https://mokestrel.wordpress.com/) - Quantified Self, lifelogging, journaling, education.
- [QS on Medium](https://medium.com/@quantifiedself) - Quantified Self posts on Medium.
- [QS on Venture Beat](http://venturebeat.com/tag/quantified-self/) - Quantified Self articles on Venture Beat.
- [QS on Wired](https://www.wired.com/tag/quantified-self/) - Quantified Self articles on Wired.com.
- [QS on LiveScience](http://www.livescience.com/topics/quantified-self) - Quantified Self articles on LiveScience.
- [Gwern](http://www.gwern.net/) - Esoteric blog which includes blinded self-experiments & Quantified Self analyses amongst other topics.
- [beepb00p](https://beepb00p.xyz) - Writing about Quantified Self, owning the data and building the infrastructure.
- [QS Experiments](https://blog.kto.to) - Science-based approach for Quantified Self, sharing raw data and analysis, modelling physical processes, health trackers comparison and analysis.


## Books

-  [Your life, uploaded: The digital way to better memory, health, and productivity](https://www.amazon.com/Your-Life-Uploaded-Digital-Productivity-ebook/dp/B0043EV52G/) (2010) - Gordon Bell & Jim Gemmell
- [The Quantified Self](https://www.amazon.com/Quantified-Self-Deborah-Lupton-ebook/dp/B01M0QCSF7/) (2016) - Deborah Lupton
- [Self-Tracking](https://www.amazon.com/Self-Tracking-MIT-Press-Essential-Knowledge-ebook/dp/B01HNIVBZ4/) (2016) - Gina Neff & Dawn Nafus
- [Everyday Data Science](https://www.amazon.com/dp/B08TZ1MT3W/ref=cm_sw_r_cp_apa_fabc_a0ceGbWECF9A8) (2021) - Andrew N Carr [(cheaper PDF version)](http://gum.co/everydaydata)

## Talks

- [Ted Talk: The Quantified Self](https://www.ted.com/talks/gary_wolf_the_quantified_self?language=en) - Ted talk by Gary Wolf on the Quantified Self movement.
- [Tedx Talk: Wearable Tech Expands Human Potential](https://www.youtube.com/watch?v=FESv2CgyJag) - Lauren Costantini explores what it means to be human in the age of the Quantified Self.
- [Don't Unplug!!! How Technology Saved My Life and Can Save Yours Too](https://www.youtube.com/watch?v=EaYsr_ir1R8) - A keynote by Chris Dancy ("the Most Connected Man on Earth") in which he explores how technology helped him become a better person by paying attention to the data he collected about his life.

## Applications and Platforms

### Fitness
- [Runkeeper](http://runkeeper.com/) - Outdoor fitness activity tracker (iOS & Android).
- [Runtastic](https://www.runtastic.com/) - Running, cycling, and fitness GPS tracker (iOS & Android).
- [Strava](https://www.strava.com/) - Athletic activity tracking and social network.
- [Gym Hero](https://gymhero.me/) - Track workouts, strength training and other fitness exercise (iOS, Web)
- [OpenTracks](https://opentracksapp.com/) - Privacy-respecting offline-capable fitness activity tracker (Android).

### Places & Travel
- [RoadGoat](https://www.roadgoat.com/) - Travel tracking, automated integrations with many platforms listed here (Web).
- [Swarm](https://www.swarmapp.com/) - Point of interest auto-checkins via GPS (iOS & Android).
- [Arc](https://itunes.apple.com/us/app/arc-app-location-activity/id1063151918) - Track your movements and places visited via GPS (iOS).

### Aggregators & Dashboards
- [Apple Health](http://www.apple.com/ios/health/) - Multi-purpose tracking platform for Apple devices. Tracks activities, sleep, nutrition, mindfulness, and other metrics.
- [Google Fit](https://www.google.com/fit) - Open ecosystem to store, access, and manage fitness data (Android).
- [Gyroscope](https://gyrosco.pe/) - Quantified Self health dashboard (web, iOS, & Android).
- [Exist](https://exist.io/) - Track everything in one place (web, iOS & Android).
- [Zenobase](https://zenobase.com/) - Store, aggregate and visualize your data from multiple 3rd party sources (web).
- [Vital](https://tryvital.io/) - Plaid like widget that joins together all your fitness data, wearables data and at home lab tests.
- [Validic](https://validic.com/) - Cloud-based platform that connects patient-recorded data from digital health applications, devices, and wearables.
- [FitnessSyncer](https://www.fitnesssyncer.com/) - Joins health and fitness data into a single centralized platform.
- [IoTool](https://iotool.io/) - Smartphone IoT platform for automation and data collection.
- [Tictrac](https://tictrac.com/) - Dashboard for health and fitness data (web).
- [QS Access](https://apps.apple.com/us/app/qs-access/id920297614) - Export Apple Health data into CSV table format (iOS).
- [KeepTrack](https://play.google.com/store/apps/details?id=com.zagalaga.keeptrack&hl=en) - Multi-purpose tracker (Android).
- [BiomarkerDash](https://github.com/NoTranslationLayer/biomarkerdash) - Simple dashboard to visualize trends in bloodwork biomarkers.

### Automation
- [Tasker](https://play.google.com/store/apps/details?id=net.dinglisch.android.taskerm&hl=en) - Automation and event triggering app (Android).
- [Apple Shortcuts](https://support.apple.com/guide/shortcuts/welcome/ios) - Powerful automation app (iOS).
- [If This Then That (IFTTT)](https://ifttt.com/) - Awesome conditional automation platform.
- [Zapier](https://zapier.com/) - Automate tasks between apps.

### Data Collection
- [AskMeEvery](https://www.askmeevery.com/) - Automated data entry through email or text questions.
- [Reporter](http://www.reporter-app.com/) - Tracking app that collects data through random surveys (iOS).
- [Reflect](https://ntl.ai/reflect) - Tracking app with customizable forms and data insights (iOS).
- [RTracker](https://janerob.com/rTracker/rTracker/iPhone/pages/rTracker-main.html) - Generic, customisable personal data tracker (iOS).
- [Sink](https://sinkapp.io) - Voice-enabled Lifelogger for tracking anything with automatic sync to Google Sheets (iOS).

### Diet
- [MyFitnessPal](http://www.myfitnesspal.com/) - Food tracking and diet plan app (iOS & Android).
- [Fat Secret](https://www.fatsecret.com/) - Calorie counter and diet tracker for weight loss (iOS & Android).
- [Cronometer](https://cronometer.com/) - Food, activity, and biometric tracker (iOS & Android).
- [Zero](https://www.zerofasting.com/) - A simple fasting tracker used for intermittent, circadian rhythm, and custom fasting (iOS & Android). 
- [Bitesnap](https://www.getbitesnap.com/) - Image based food logging app powered by computer vision (iOS & Android).
- [Coffee It](https://apps.apple.com/us/app/coffee-it-record-caffeine/id1216049514) - Record Caffeine intake, with database inside & Apple Health sync. (iOS)
- [HiCoffee](https://apps.apple.com/us/app/hicoffee-caffeine-tracker/id1507361706) - Super efficient caffeine tracker app with Apple Watch support (iOS and Apple Watch).
- [Nutriely](https://nutriely.com) - Food and nutrition tracking, diary. Focusing on detailed micro and vitamin breakdown. (Web)

### Goals
- [GoalsOnTrack](http://www.goalsontrack.com/) - Web-based goal setting and tracking software (iOS & Android).
- [Lifetick](https://lifetick.com/) - Online goal tracking platform.
- [stickK](http://www.stickk.com/) - Goal tracking with a monetary commitment.
- [Beeminder](https://www.beeminder.com/) - Goal tracking with a monetary commitment. Integrates with many devices and apps.
- [Taskade](https://www.taskade.com/) - Simple and sharable tasks, checklists, and notes. (Web, iOS & Android).

### Habits
- [Habitica](https://habitica.com) - A habit tracking app which treats your goals like a role playing game (Web, iOS & Android).
- [HabitBull](http://www.habitbull.com/) - A simple mobile habit tracking app to build and track streaks (iOS & Android).
- [Strides](http://www.stridesapp.com/) - App to track your goals, habits and projects with SMART goal setting (Web, iOS).
- [Habit List](http://habitlist.com/) - Create good habits, break bad ones, build a better you (iOS).
- [Streaks](https://streaksapp.com/) - The to-do list that helps you form good habits (iOS).
- [Taskade](https://taskade.com/) - Modern task lists that syncs across all your devices. (Web, iOS, Android, Chrome, Mac and PC).
- [Productive](https://productiveapp.io/) - Habits and daily goals tracker with flexible scheduling, reminders and data export (iOS).
- [Everyday](https://everyday.app/) - Simple and beautiful habit tracker for the Web, iOS and Android. Has a web extension to add it to your browser's new tab.
- [Emoji Log](https://emojilog.rosano.ca) - Track habits without streaks using emoji.
- [Conjure](https://conjure.so) - Habits, goals and time tracker with rules engine, data layer, API, dashboards and more. (Web, Desktop, iOS, Android).

### Health
- [AlcDroid](http://alcdroid.flx-apps.com/) - Alcohol consumption tracking and BAC calculation app that offers various statistics regarding your drinking behavior (Android).

### Heart
- [Instant Heart Rate](http://www.azumio.com/s/instantheartrate/index.html) - Fast and accurate mobile heart rate monitor (iOS, Android, Windows).
- [HRV4Training](https://www.hrv4training.com/) - Track Heart Rate Variability, Stress, and other contextual data points using your smartphone camera and receive personalized advice to optimize your health and training (iOS, Android).
- [Welltory](https://www.welltory.com/) - The go-to health app that lets users track their heart rate variability, stress, and energy levels, along with aggregated health and fitness analytics from different wearable devices and apps.

### Media Consumption
- [Goodreads](https://www.goodreads.com/) - Lets users track and rate books and network with other readers (Web, iOS, Android). 
- [HistoryHound](https://www.stclairsoft.com/HistoryHound/) - Searchable cross-browser history database that can be exported as HTML (MacOS).
- [Last.fm](http://www.last.fm/) - Track the music you listen to by scrobbling via desktop and mobile apps or by connecting to music services (Web, iOS, Android).
- [Trakt](https://trakt.tv/) - Automatically track TV & movies you're watching (Web, Media Players).
- [Pocket](https://getpocket.com/)  - Lets you save articles to read later (Web, iOS, Android).
- [WordCounter](https://wordcounterapp.com/) - Word count tracker for writers (Mac). 
- [Podcast Tracker](http://www.podcasttracker.com/) -  Lets you log, aggregate and export your podcast listening history (Web).

### Mind & Cognition

### Mood
- [MoodCast](https://2appstudio.com/moodcast/) - Keep track of your daily mood & activities (Android).
- [MoodJam](http://moodjam.com/) - Track your moods with colors. (Web only).
- [iMoodJournal](https://www.imoodjournal.com/) - Mood Tracking on a 10-point scale from Really great to Couldn't be worse. Exportable data. (Android, iOS, Apple Watch).
- [Perspective](https://itunes.apple.com/us/app/perspective-daily-journal/id1186753097?mt=8) - Journaling to captures Thoughts, Moods, and Interests with the goal of helping you reflect and find perspective. (iOS).
- [Moods by Mokriya](https://itunes.apple.com/us/app/moods-tracking-for-better-mental-health/id1023271188?mt=8) - Quick track your mood as good, okay or bad. Specify feelings using a word cloud. No data export option. (iOS, Apple Watch).

### Sleep
- [Sleep as Android](http://sleep.urbandroid.org/) - Full featured sleep tracker with wearable integration (Android).
- [Sleep Cycle](https://www.sleepcycle.com/) - Intelligent alarm clock and sleep tracker (iOS & Android).
- [Pillow](https://neybox.com/pillow/) - Track your sleep from your Apple Watch or iPhone (iOS). 

### Tally

### Time
- [Toggl](https://toggl.com/) - Time tracker and employee timesheet software (iOS & Android).
- [Timesheet](http://timesheet.rauscha.com/) - Android time tracker (Android).
- [Hours Time Tracker](https://www.hourstimetracking.com/) - Awesome time tracking app (iOS).
- [Rescue Time](https://www.rescuetime.com/) - Automatically tracks where you spend your time (Mac, Windows, Android, Linux).
- [Qbserve](https://qotoqot.com/qbserve/) - Time tracking automation: Real-time productivity feedback, project tracking, timesheets, and invoicing (Mac).
- [Timing](https://timingapp.com/) - Automatic time and productivity tracking for Mac. Helps you stay on track with your work and tells you exactly how many seconds you spent in each document, website and app (Mac).
- [Quality Time](http://www.qualitytimeapp.com/) - Precise time tracker for Android (Android).
- [Manic Time](http://www.manictime.com/) - Automatic time tracking software which tracks computer usage (Windows).
- [Streaks](https://streaksapp.com/) - To do list that helps you form habits and track goals (iOS).
- [Hindsight](http://hindsightapp.io/) - Tracks the passage of time since something happened (iOS, Apple Watch).
- [ActivityWatch](https://activitywatch.net/) - Open source automated time tracker (Mac, Windows, Linux, Android).
- [Hourly](http://hourly-app.com) - Minimalistic time tracker with smart functions and nice design (iOS).
- [arbtt](https://arbtt.nomeata.de/) - Automatic, rule-based time tracker, which works by periodically snapshotting the metadata of your desktop window state. Rules are specified in the arbtt DSL and can be written retroactively (Linux, Mac, Windows).

### Wealth
- [Personal Capital](https://www.personalcapital.com/) - Financial software and wealth management.
- [You Need A Budget (YNAB)](http://www.youneedabudget.com/) - Personal home budget software.
- [GNU Cash](https://www.gnucash.org/) - Personal and small-business financial-accounting software.
- [Ledger](https://github.com/ledger/ledger) - Simple but powerful command line accounting.
- [Credit Karma](https://www.creditkarma.com/) - Lean and reputable credit score tracker.
- [Actual](https://actualbudget.com/) - Personal home budget software.
- [Lunch Money](https://lunchmoney.app/) - Web app to import transactions, categorize, and budget.
- [Firefly III](https://github.com/firefly-iii/firefly-iii) - A free and open source personal finance manager
- [Menot](https://www.menot.xyz) - Simple expense and finance tracker for multiple currencies, including crypto.

## Devices and Wearables

- [Fitbit](http://www.fitbit.com/) - Awesome activity tracking wearables to track steps, heart rate, quality of sleep, and other personal metrics.
- [Garmin](https://buy.garmin.com/en-US/US/wearables/c10002-p1.html) - World-class range of wearables.
- [Withings](http://www.withings.com/) - Activity tracking and connected devices.
- [Wahoo](http://wahoofitness.com/) - Connected cycling, running, and fitness devices.
- [Hexo Skin](http://www.hexoskin.com/) - Awesome biometric shirts.
- [Whoop](http://whoop.com/) - Athletic performance monitoring.
- [Zephyr BioHarness](https://www.zephyranywhere.com/products/bioharness-3) - Performance monitoring wearables.
- [Apple Watch](http://www.apple.com/watch/) - Fitness and other health oriented tracking.
- [Spire](https://spire.io/) - Activity tracker that determines stress and focus levels by measuring breathing.
- [Oura Ring](https://ouraring.com/) - Highly-accurate sleep (and activity) tracker worn on the finger that measures HR, HRV, temperature, and movement.
- [Aidlab](https://www.aidlab.com/) - Smart and hackable wearable, compatible with special T-shirts and chest straps.
- [Gadgetbridge](https://gadgetbridge.org/) - FOSS fitness tracker app for use with a wide variety of wearables.
- [Dreem](https://dreem.com/) - Consumer-grade EEG used to monitor and optimize sleep; it also has pulse oxymeter, bone conduction audio, accelerometer and sonometer.

## Research and Analysis

- [23andMe](https://www.23andme.com/) - Genetic testing and analysis.
- [Open Humans](https://www.openhumans.org/) - Data sharing and project collaboration.
- [Enlis](https://www.enlis.com/personal_edition.html) - Software to organize and analyze your genomic data.
- [DNA Fit](https://www.dnafit.com/) - Genetic information for fitness and nutrition.
- [Family Tree DNA](https://www.familytreedna.com/) - Genetic testing for ancestry, family history and genealogy.
- [Inside Tracker](https://www.insidetracker.com/) - Science-based blood analytics for performance and health.
- [Wellness FX](https://www.wellnessfx.com/) - Blood analysis and health checkup.
- [Human API](http://humanapi.co/) - Health data integration platform.
- [FoundMyFitness](https://www.foundmyfitness.com/genetics) - Comprehensive genetic report from on self-uploaded genetic data.

## Open Source Projects

- [Open mHealth](http://www.openmhealth.org/) - Open source health data integration tools.
- [Flow Dashboard](https://github.com/onejgordon/flow-dashboard) - Habit tracker and personal data analytics app.
- [Timeliner](https://github.com/mholt/timeliner) - A data aggregation and and timeline visualization tool.
- [TimelineBuilder](https://github.com/facebookresearch/personal-timeline) - A data aggregation and and timeline visualization tool by Facebook.
- [Me API](https://github.com/danfang/me-api) - An extensible, personal API with custom integrations.
- [Memacs](https://github.com/novoid/Memacs) - Visualize your life in Orgmode.
- [HumanProgrammingInrerface](https://github.com/karlicoss/HPI) - Unify, acces and interact with all of your personal data.
- [Dogsheep](https://dogsheep.github.io/) - A collection of data exporters and tools for personal analytics using SQLite and/or Datasette.
- [Chronicle](https://github.com/chronicle-app/chronicle-etl) - A CLI toolkit for extracting and working with your digital history.
- [QS-Schema](https://github.com/QS-Schema/qs-schema) - Open schemes for QS applications.
- [Datasette](https://github.com/simonw/datasette) - An open source multi-tool for exploring and publishing data.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Willem Pienaar](https://github.com/willempienaar) has waived all copyright and related or neighboring rights to this work.
