<div class="github-widget" data-repo="fityanos/awesome-quality-assurance-roadmap"></div>
## Awesome Quality Assurance Roadmap [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)


## Introduction

测试是任何产品生命周期中必不可少的阶段； 无论是食品、汽车还是软件生产线，结果都应该符合预期并满足，满足我们创建产品的需求.

拥有扎实的理解软件组件如何工作和相互集成的基础以及获得破坏事物的技能是任何 QA 工程师的基本技能. 软件测试是调查软件并发现任何可能产生意外情况的意外行为的艺术.

您可以在下面找到您可能需要开始旅程的 QA 路径和软件测试学习曲线.

## Test Plan Sample

 QA 团队要生成的最重要的文件之一是测试计划，因为团队会在没有的情况下盲目行动； 不知道标准、起点，甚至不知道何时执行不同的测试类型，都可能会冒整个交付的风险并导致错误的代码交付.

测试计划部分和内容可能因项目和交付性质而异，因此，附加的测试计划 PDF 被视为通用的，可用于所有软件测试交付目的.

可以在此处找到附件 PDF [test_plan_sample.pdf](https://github.com/anas-qa/Quality-Assurance-Road-Map/blob/master/Test_Plan_Sample.pdf) 用于下载.

## The Road Map

![QA Engineer Road Map 2022](https://i.imgur.com/cM9cM8T.png)
![QA Engineer Road Map 2022](https://i.imgur.com/meodAKp.png)

## Advices

- 不要相信你没有看到它失败的测试代码.

 - 了解软件测试，不要跳入自动化； 就个人而言，我将自动化归类为处理冗余任务的有效方式. 确保正确设计您的测试标准，稍后，您可以自动实现之前的标准.

- 自动化只不过是记录手动编写的测试并以代码可读、可理解和可重用的方式对其进行工程设计.

- 确保您的测试代码确实在测试某些东西.

- 您的测试代码不需要测试.

 - 200~OK 并不总是可以的； 测试时不要只依赖服务器状态，未经授权的 API 调用获得 200 状态会危及您的软件安全.

## Contributing

见 [contributing.md](https://github.com/fityanos/awesome-quality-assurance-road-map/blob/master/contributing.md) 有关如何贡献的详细信息.
