<div class="github-widget" data-repo="ebraminio/awesome-qsharp"></div>
## Awesome Q## [![Awesome](https://awesome.re/badge-flat.svg)](https://awesome.re)

> [Q#](https://docs.microsoft.com/en-us/quantum/) 是一种用于表达量子算法的特定领域编程语言. 它最初由微软作为量子开发工具包的一部分向公众发布.  –[Wikipedia](https://en.wikipedia.org/wiki/Q_Sharp)

A list of Q# code and resources.

随意使用 GitHub 拉取请求机制改进此列表，请参阅 [CONTRIBUTING](https://github.com/ebraminio/awesome-qsharp/blob/master/contributing.md) 了解更多信息.


## Official Resources
- [Installation guide](https://docs.microsoft.com/en-us/quantum/quantum-installconfig)
- [Q# samples](https://github.com/Microsoft/Quantum)
- [Q# libraries](https://github.com/Microsoft/QuantumLibraries)
- [Quantum Development Kit documentation](https://docs.microsoft.com/quantum/) - 特别是“量子计算概念”很好地介绍了一般的量子计算.
- [Quantum Computing Libraries for noncommercial use](https://github.com/Microsoft/Quantum-NC)
- [Q# libraries for the Quantum Development Kit](https://github.com/microsoft/QuantumLibraries)

## Tutorials
- [Quantum Katas](https://github.com/Microsoft/QuantumKatas/) - Programming exercises for learning Q# and quantum computing.
- [Quantum Kata Notebooks](https://mybinder.org/v2/gh/Microsoft/QuantumKatas/master?filepath=index.ipynb) - Online self-paced tutorials for learning Q# programming and quantum computing.
- [Create your first Q# program by using the Quantum Development Kit](https://docs.microsoft.com/en-us/learn/modules/qsharp-create-first-quantum-development-kit/) - 微软学习模块.
- [Deutsch-Jozsa Algorithm](https://github.com/Microsoft/GHC18-IntroToQuantumComputing/) - 在 Grace Hopper Celebration 2018 和 Hopper x1 Seattle 2019 上展示的自定进度的“量子计算简介”研讨会的材料.
- [Quantum Perceptron](https://github.com/Microsoft/MLADS2018-QuantumML) - 在 MLADS 2018 上展示的自定进度的“量子机器学习简介”研讨会的材料.
- [Quantum Classification](https://github.com/microsoft/MLADS2020-QuantumClassification) - 在 MLADS 2020 上展示的自定进度的“量子分类简介”实验室的材料.
- [Quantum Computing with Microsoft QDK](https://www.manning.com/liveprojectseries/quantum-computing-with-microsoft-qdk) - Manning liveProject series that guides the learner through implementation of a variety of protocols and algorithms using Q# and Microsoft QDK.

## Books
- [Learn Quantum Computing with Python 和 Q#](https://www.manning.com/books/learn-quantum-computing-with-python-和-q-sharp) - 曼宁，2021 年， [Sarah Kaiser](https://www.sckaiser.com/) 和 [Chris Granade](https://www.cgranade.com/).
- [Q# Pocket Guide](https://www.oreilly.com/library/view/q-pocket-guide/9781098108854/) - O&#39;Reilly，2022 年，Mariia Mykhailova.
- [Introduction to Quantum Computing with Q# and QDK](https://link.springer.com/book/10.1007/978-3-030-99379-5) - 施普林格，2022 年，Filip Wojcieszyn.
- [Introducing Microsoft Quantum Computing for Developers](https://link.springer.com/book/10.1007/978-1-4842-7246-6) - Apress，2022，Johnny Hooyberghs.

## Videos
<!--lint ignore double-link-->
- [Microsoft Quantum Development Kit Preview](https://www.youtube.com/watch?v=v7b4J2INq9c) - Krysta Svore - Microsoft Mechanics 的量子隐形传态分步演示.
- [Introduction to Quantum Programming through the Quantum Katas](https://www.youtube.com/watch?v=h3M8OomE19o) - Bettina Heim，Microsoft Ignite 2018 会议（[here](https://www.youtube.com/watch?v=AjBLsrGgEkY) 与 VS Code 而不是 Visual Studio 举行的会议相同）.
- [Learn to build your first quantum solution with the Quantum Development Kit and Q#](https://www.youtube.com/watch?v=YE4m3yCdcqE) - John Azariah，Microsoft Build 2018 会议.
- [Programming quantum computers in .NET using Microsoft Q#](https://www.youtube.com/watch?v=qOg6weW-IDo) - 罗尔夫豪氏威马.
- [Quantum computing sessions at //Build](https://mybuild.microsoft.com/sessions?q=quantum)

## Q/A
- [Q# tag on Stack Overflow](https://stackoverflow.com/questions/tagged/q%23)
- [Q# tag on Quantum Computing StackExchange](https://quantumcomputing.stackexchange.com/questions/tagged/q%23)

## Coding Contests and Solutions

### Official resources
- [Microsoft Q# Coding Contest (Summer 2018)](https://codeforces.com/contest/1002)
- [Microsoft Q# Coding Contest (Summer 2018) Warmup Round](https://codeforces.com/contest/1001)
- 解决方案说明 [Microsoft Q# Coding Contest (Summer 2018)](https://assets.codeforces.com/rounds/997-998/main-contest-editorial.pdf) 并为 [Warmup Round](https://assets.codeforces.com/rounds/997-998/warmup-editorial.pdf)
- [Microsoft Q# Coding Contest (Winter 2019)](https://codeforces.com/contest/1116)
- [Microsoft Q# Coding Contest (Winter 2019) Warmup Round](https://codeforces.com/contest/1115)
- 解决方案说明 [Microsoft Q# Coding Contest (Winter 2019)](https://codeforces.com/blog/entry/65702) 并为 [Warmup Round](https://assets.codeforces.com/rounds/1115/warmup-editorial.pdf)
- [Microsoft Q# Coding Contest (Summer 2020)](https://codeforces.com/contest/1357)
- [Microsoft Q# Coding Contest (Summer 2020) Warmup Round](https://codeforces.com/contest/1356)
- 解决方案说明 [Microsoft Q# Coding Contest (Summer 2020)](https://codeforces.com/blog/entry/79208) 并为 [Warmup Round](https://codeforces.com/blog/entry/78832)

### Participants' solutions
- [Solutions to the 2018 Microsoft Q# Coding Challenge and Warm-Up on Codeforces](https://github.com/RobertDurfee/QSharpCodingChallenge)
- [Q# codes by Hiroshi Kurokawa](https://github.com/hkurokawa/QSharpCodingContest2018)
- [No Description_ by Hajime Fukuda](https://github.com/hajifkd/qsharp-vscode)

## IDE Integration
<!--lint ignore double-link-->
- [Visual Studio](https://marketplace.visualstudio.com/items?itemName=quantum.DevKit)
- [Visual Studio Code](https://marketplace.visualstudio.com/items?itemName=quantum.quantum-devkit-vscode)
- [Emacs](https://github.com/forked-from-1kasper/emacs-qsharp-mode)
- [Atom](https://github.com/ivangabriele/atom-qsharp)
- [Vim](https://github.com/gootorov/q-sharp.vim)
- [Jupyter Notebook](https://docs.microsoft.com/en-us/azure/quantum/install-jupyter-qdk)

## Demos, Samples, and Additional Libraries
- [Quantum Computing Q# Introduction 2018](https://github.com/Djohnnie/QuantumComputingQSharpIntroduction2018)
- [A implementation of Shor's algorithm written in Python calling Q# for the quantum part](https://github.com/Michaelvll/myQShor)
- [Hadamard Gate Q# Demo](https://github.com/jwulf/HGate)
- [Q# Bell State Program](https://github.com/pktippa/q_sharp_bell_state)
- [Q# playgroud](https://github.com/weize07/Qsharp-playgroud)
- [QuantumPeep](https://github.com/mapmeld/quantum-peep) - Generate Q# from JavaScript/TypeScript.

## Blogs
- [Q# Dev Blog](https://devblogs.microsoft.com/qsharp/) - Official blog of Q# dev team.
- [Microsoft Quantum Blog](https://cloudblogs.microsoft.com/quantum/) - Microsoft Quantum 团队的官方博客.
- [Q# Advent Calendar 2018](https://devblogs.microsoft.com/qsharp/q-advent-calendar-2018/) - Collection of Q#-related blog posts.
- [Q# Advent Calendar 2019](https://devblogs.microsoft.com/qsharp/q-advent-calendar-2019/) - Collection of Q#-related blog posts.
- [Q# Advent Calendar 2020](https://devblogs.microsoft.com/qsharp/q-advent-calendar-2020/) - Collection of Q#-related blog posts.
- [Q# Advent Calendar 2021](https://devblogs.microsoft.com/qsharp/q-advent-calendar-2021/) - Collection of Q#-related blog posts.
- [The Hitchhiker's Guide to the Quantum Computing and Q#](https://blogs.msdn.microsoft.com/uk_faculty_connection/2018/02/26/the-hitchhikers-guide-to-the-quantum-computing-and-q-blog/)
- [El Bruno's blog posts](https://elbruno.com/tag/q/)
- [Q# Community](https://qsharp.community)
