<div class="github-widget" data-repo="make-github-pseudonymous-again/awesome-qr-code"></div>
## Awesome QR Code [![Awesome](https://awesome.re/badge.svg)](https://github.com/sindresorhus/awesome)

[<img src="https://raw.githubusercontent.com/make-github-pseudonymous-again/awesome-qr-code/master/repo-link.svg?sanitize=true" align="right" width="100">](https://github.com/make-github-pseudonymous-again/awesome-qr-code#readme)

A curated list of awesome QR code libraries, software and resources.

> QR code (abbreviated from Quick Response code) is a type of matrix barcode (or two-dimensional barcode) first designed in 1994 for the automotive industry in Japan.
>
> *Wikipedia* ~ https://en.wikipedia.org/wiki/QR_code




---

## Apps

### Readers

- [Web App](https://github.com/code-kotis/qr-code-scanner) - A progressive web application to scan QR codes.

### File Transfer

- [qrcp](https://github.com/claudiodangelis/qrcp) - Transfer files over Wi-Fi from your computer to a mobile device by scanning a QR code without leaving the terminal.
- [qr-filetransfer](https://github.com/sdushantha/qr-filetransfer) - Transfer files over Wi-Fi between your computer and your smartphone from the terminal.

## CLI

- [qrencode](https://fukuchi.org/works/qrencode) - Command line tool to generate QR codes.
- [qrap](https://github.com/make-github-pseudonymous-again/qrap) - Generate a QR code payload for Wi-Fi access point credentials.
- [spqr](https://github.com/make-github-pseudonymous-again/spqr) - Generate a QR code payload for initiating a SEPA transfer.
- [qrscan](https://github.com/sayanarijit/qrscan) - Scan a QR code in the terminal using the system camera or a given image.
- [qrcode.show](https://qrcode.show) - Generate QR codes using curl.

## Libraries

In this section `R` means the library allows to read QR codes and `W` means
that the library allows to generate QR codes.

### C

- [libqrencode `W`](https://github.com/fukuchi/libqrencode) - A fast and compact library for encoding data in a QR code symbol.

### C, C++, JavaScript, Python, Java, Rust

- [QR-Code-generator `W`](https://github.com/nayuki/QR-Code-generator) - High-quality QR code generator library in Java, TypeScript/JavaScript, Python, C++, C, Rust.

### Java

- [Qart `W`](https://github.com/scola/Qart) - An app to merge a picture and a QR code.

### JavaScript

- [instascan `R`](https://github.com/schmich/instascan) - HTML5 QR code scanner using your webcam.
- [qrious `W`](https://github.com/neocotic/qrious) - Pure JavaScript library for QR code generation using canvas.

### TypeScript

- [jsQR `R`](https://github.com/cozmo/jsQR) - A pure JavaScript QR code reading library.

### React

- [qrcode.react `W`](https://github.com/zpao/qrcode.react) - A `<QRCode/>` component for use with React.

### React Native

- [react-native-qrcode-scanner `R`](https://github.com/moaazsidat/react-native-qrcode-scanner) - A QR code scanner component for React Native.

### Vue

- [vue-qrcode-reader `R`](https://github.com/gruhn/vue-qrcode-reader) - A set of Vue.js components for detecting and decoding QR codes.

### Python

- [sylnsfar/qrcode `W`](https://github.com/sylnsfar/qrcode) - Artistic QR code in Python (can produce GIFs).

### Ruby
- [rqrcode `W`](https://github.com/whomwah/rqrcode) - A neat Ruby QR code generator exporting to `svg`, `png` and `ansi` with configurable size, color and other attributes.

### Objective-C

- [SGQRCode `R`](https://github.com/kingsic/SGQRCode) - Easy to use QR code scan library for iOS.

### Swift

- [EFQRCode `W`](https://github.com/EFPrefix/EFQRCode) - A better way to operate QR code in Swift, support iOS, macOS, watchOS and tvOS.

### C\#

- [QRCoder `W`](https://github.com/codebude/QRCoder) - A pure C# Open Source QR code implementation.

### Android

- [BGAQRCode-Android `RW`](https://github.com/bingoogolapple/BGAQRCode-Android) - QR code reader and generator written in C.
- [AwesomeQRCode (Kotlin) `W`](https://github.com/SumiMakito/AwesomeQRCode) - An awesome QR code generator for Android (can produce GIFs).

### PHP

- [php-qrcode-detector-decoder `R`](https://github.com/khanamiryan/php-qrcode-detector-decoder) - PHP library to detect and decode QR codes.
- [simple-qrcode `W`](https://github.com/SimpleSoftwareIO/simple-qrcode) - An easy-to-use PHP QR code generator.
- [endroid/qr-code `W`](https://github.com/endroid/qr-code) - QR code generator.
- [BaconQRCode `W`](https://github.com/Bacon/BaconQRCode) - QR code generator for PHP.


## Resources

- [zxing](https://github.com/zxing/zxing/wiki/Barcode-Contents) - QR code payload format catalog.


## Contributing

Your contributions are always welcome! Please take a look at the [contribution guidelines](https://github.com/make-github-pseudonymous-again/awesome-qr-code/blob/main/CONTRIBUTING.md).

---

If you have any question about this opinionated list, do not hesitate to open an issue.
