<div class="github-widget" data-repo="seriousran/awesome-qa"></div>
## Awesome Question Answering [![Awesome](https://awesome.re/badge.svg)](https://github.com/sindresorhus/awesome) 

_精选清单 __[Question Answering (QA)](https://en.wikipedia.org/wiki/Question_answering)__ 信息检索和自然语言处理 (NLP) 领域内的一门计算机科学学科，旨在使用机器学习和深度学习_

_信息检索和自然语言处理领域问答集——从机器学习到深度学习_<br/>
_问答系统主题的精选列表，是信息检索和自然语言处理领域的计算机科学学科 - 使用机器学习和深度学习_


<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Recent Trends
### Recent QA Models
- DilBert：在基于转换器的编码器中延迟交互层以实现高效的开放域问答（2020）
  - 论文：https://arxiv.org/pdf/2010.08422.pdf
  -github: https://github.com/wissam-sib/dilbert
- UnifiedQA：使用单一 QA 系统跨越格式边界 (2020)
  - 演示：https://unifiedqa.apps.allenai.org/
 - ProQA：为开放域 QA 和 IR 预训练密集语料库索引的资源高效方法.  (2020)
  - 论文：https://arxiv.org/pdf/2005.00038.pdf
  -github: https://github.com/xwhan/ProQA
- TYDI QA：类型多样语言中信息搜索问答的基准（2020）
  - 论文：https://arxiv.org/ftp/arxiv/papers/2003/2003.05002.pdf
- 机器阅读理解回顾阅读器
  - 论文：https://arxiv.org/pdf/2001.09694v2.pdf
- TANDA：迁移和调整用于回答句子选择的预训练变压器模型（AAAI 2020）
  - 论文：https://arxiv.org/pdf/1911.04118.pdf
### Recent Language Models
- [ELECTRA: Pre-training Text Encoders as Discriminators Rather Than Generators](https://openreview.net/pdf?id=r1xMH1BtvB), Kevin Clark 等人，ICLR，2020 年.
- [TinyBERT: Distilling BERT for Natural Language Understanding](https://openreview.net/pdf?id=rJx0Q6EFPB), Xiaoqi Jiao, et al., ICLR, 2020.
- [MINILM: Deep Self-Attention Distillation for Task-Agnostic Compression of Pre-Trained Transformers](https://arxiv.org/abs/2002.10957), Wenhui Wang, et al., arXiv, 2020.
- [T5: Exploring the Limits of Transfer Learning with a Unified Text-to-Text Transformer](https://arxiv.org/abs/1910.10683), Colin Raffel 等人，arXiv 预印本，2019 年.
- [ERNIE: Enhanced Language Representation with Informative Entities](https://arxiv.org/abs/1905.07129), Zhengyan Zhang, et al., ACL, 2019.
- [XLNet: Generalized Autoregressive Pretraining for Language Understanding](https://arxiv.org/abs/1906.08237), Zhilin Yang, et al., arXiv preprint, 2019.
- [ALBERT: A Lite BERT for Self-supervised Learning of Language Representations](https://arxiv.org/abs/1909.11942), Zhenzhong Lan, et al., arXiv preprint, 2019.
- [RoBERTa: A Robustly Optimized BERT Pretraining Approach](https://arxiv.org/abs/1907.11692), Yinhan Liu, et al., arXiv preprint, 2019.
- [DistilBERT, a distilled version of BERT: smaller, faster, cheaper and lighter](https://arxiv.org/pdf/1910.01108.pdf), Victor sanh 等人，arXiv，2019 年.
- [SpanBERT: Improving Pre-training by Representing and Predicting Spans](https://arxiv.org/pdf/1907.10529v3.pdf), Mandar Joshi 等人，TACL，2019 年.
- [BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding](https://arxiv.org/abs/1810.04805), Jacob Devlin 等人，NAACL 2019、2018.
### AAAI 2020
  - [TANDA: Transfer and Adapt Pre-Trained Transformer Models for Answer Sentence Selection](https://arxiv.org/pdf/1911.04118.pdf), Siddhant Garg 等人，AAAI 2020，2019 年 11 月.
### ACL 2019
  - [Overview of the MEDIQA 2019 Shared Task on Textual Inference,
问题蕴涵和问题回答](https://www.aclweb.org/anthology/W19-5039)，Asma Ben Abacha 等人，ACL-W 2019，2019 年 8 月.
  - [Towards Scalable and Reliable Capsule Networks for Challenging NLP Applications](https://arxiv.org/pdf/1906.02829v1.pdf), Wei Zhao, et al., ACL 2019, Jun 2019.
  - [Cognitive Graph for Multi-Hop Reading Comprehension at Scale](https://arxiv.org/pdf/1905.05460v2.pdf), Ming Ding, et al., ACL 2019, Jun 2019.
  - [Real-Time Open-Domain Question Answering with Dense-Sparse Phrase Index](https://arxiv.org/abs/1906.05807), Minjoon Seo 等人，ACL 2019，2019 年 6 月.
  - [Unsupervised Question Answering by Cloze Translation](https://arxiv.org/abs/1906.04980), Patrick Lewis 等人，ACL 2019，2019 年 6 月.
  - [SemEval-2019 Task 10: Math Question Answering](https://www.aclweb.org/anthology/S19-2153), Mark Hopkins 等人，ACL-W 2019，2019 年 6 月.
  - [Improving Question Answering over Incomplete KBs with Knowledge-Aware Reader](https://arxiv.org/abs/1905.07098), Wenhan Xiong, et al., ACL 2019, May 2019.
  - [Matching Article Pairs with Graphical Decomposition and Convolutions](https://arxiv.org/pdf/1802.07459v2.pdf), Bang Liu, et al., ACL 2019, May 2019.
  - [Episodic Memory Reader: Learning what to Remember for Question Answering from Streaming Data](https://arxiv.org/abs/1903.06164), Moonsu Han 等人，ACL 2019，2019 年 3 月.
  - [Natural Questions: a Benchmark for Question Answering Research](https://ai.google/research/pubs/pub47761), Tom Kwiatkowski 等人，TACL 2019，2019 年 1 月.
  - [Textbook Question Answering with Multi-modal Context Graph Understanding and Self-supervised Open-set Comprehension](https://arxiv.org/abs/1811.00232), Daesik Kim 等人，ACL 2019，2018 年 11 月.
### EMNLP-IJCNLP 2019
  - [Language Models as Knowledge Bases?](https://arxiv.org/pdf/1909.01066v2.pdf), Fabio Petron, et al., EMNLP-IJCNLP 2019, Sep 2019.
  - [LXMERT: Learning Cross-Modality Encoder Representations from Transformers](https://arxiv.org/pdf/1908.07490v3.pdf), Hao Tan, et al., EMNLP-IJCNLP 2019, Dec 2019.
  - [Answering Complex Open-domain Questions Through Iterative Query Generation](https://arxiv.org/pdf/1910.07000v1.pdf), Peng Qi, et al., EMNLP-IJCNLP 2019, Oct 2019.
  - [KagNet: Knowledge-Aware Graph Networks for Commonsense Reasoning](https://arxiv.org/pdf/1909.02151v1.pdf), Bill Yuchen Lin, et al., EMNLP-IJCNLP 2019, Sep 2019.
  - [Mixture Content Selection for Diverse Sequence Generation](https://arxiv.org/pdf/1909.01953v1.pdf), Jaemin Cho, et al., EMNLP-IJCNLP 2019, Sep 2019.
  - [A Discrete Hard EM Approach for Weakly Supervised Question Answering](https://arxiv.org/pdf/1909.04849v1.pdf), Sewon Min, et al., EMNLP-IJCNLP, 2019, Sep 2019.
### Arxiv
  - [Investigating the Successes and Failures of BERT for Passage Re-Ranking](https://arxiv.org/abs/1905.01758), Harshith Padigela 等人，arXiv 预印本，2019 年 5 月.
  - [BERT with History Answer Embedding for Conversational Question Answering](https://arxiv.org/abs/1905.05412), Chen Qu, et al., arXiv preprint, 5 月
  - [Understanding the Behaviors of BERT in Ranking](https://arxiv.org/abs/1904.07531), Yifan Qiao, et al., arXiv preprint, Apr 2019.
  - [BERT Post-Training for Review Reading Comprehension and Aspect-based Sentiment Analysis](https://arxiv.org/abs/1904.02232), Hu Xu, et al., arXiv 预印本，2019 年 4 月.
  - [End-to-End Open-Domain Question Answering with BERTserini](https://arxiv.org/abs/1902.01718), Wei Yang, et al., arXiv preprint, Feb.
  - [A BERT Baseline for the Natural Questions](https://arxiv.org/abs/1901.08634), Chris Alberti 等人，arXiv 预印本，2019 年 1 月.
  - [Passage Re-ranking with BERT](https://arxiv.org/abs/1901.04085), Rodrigo Nogueira 等人，arXiv 预印本，2019 年 1 月.
  - [SDNet: Contextualized Attention-based Deep Network for Conversational Question Answering](https://arxiv.org/abs/1812.03593), Chenguang Zhu, et al., arXiv, Dec 2018.
### Dataset
  - [ELI5: Long Form Question Answering](https://arxiv.org/abs/1907.09190), Angela Fan 等人，ACL 2019，2019 年 7 月
  - [CODAH：一个对抗性编写的问答数据集
Common Sense](https://www.aclweb.org/anthology/W19-2008.pdf)，Michael Chen 等人，RepEval 2019，2019 年 6 月.
  
## About QA
### Types of QA
- 单轮 QA：在不考虑任何上下文的情况下回答
- 对话式 QA：使用预先对话轮流
#### Subtypes of QA
- 基于知识的质量保证
- 基于表格/列表的 QA
- 基于文本的质量保证
- 基于社区的质量保证
- 视觉质量保证

### Analysis and Parsing for Pre-processing in QA systems
语言分析
  1. [Morphological analysis](https://www.cs.bham.ac.uk/~pjh/sem1a5/pt2/pt2_intro_morphology.html)
  2. [Named Entity Recognition(NER)](https://github.com/seriousran/awesome-qa/blob/master/mds/named-entity-recognition.md)
  3.同音词/多义词分析
  4.句法解析（依赖解析）
  5.语义识别

### Most QA systems have roughly 3 parts
1. 事实提取<br/>
    1.实体提取<br/>
        1. [Named-Entity Recognition(NER)](https://github.com/seriousran/awesome-qa/blob/master/mds/named-entity-recognition.md)
    2. [Relation Extraction](https://github.com/seriousran/awesome-qa/blob/master/mds/relation-extraction.md) <br/>
2.理解问题
3.生成答案

## Events
- Wolfram Alpha 于 2009 年推出了答案引擎.
- IBM Watson 系统击败顶级 *[Jeopardy!](https://www.jeopardy.com)* 2011年冠军.
- Apple 的 Siri 在 2011 年集成了 Wolfram Alpha 的答案引擎.
- 谷歌通过在 2012 年利用免费基础知识库推出其知识图来拥抱质量检查.
 - 亚马逊回声 |  Alexa (2015)，谷歌主页 |  Google Assistant (2016), INVOKE | 微软小娜 (2017)、HomePod (2017)

## Systems
- [IBM Watson](https://www.ibm.com/watson/) - 具有最先进的性能. 
- [Facebook DrQA](https://research.fb.com/downloads/drqa/)  - 适用于 SQuAD1.0 数据集.  SQuAD2.0 数据集已发布. 但 DrQA 尚未经过测试.
- [MIT media lab's Knowledge graph](http://conceptnet.io/) - 是一个免费提供的语义网络，旨在帮助计算机理解人们使用的单词的含义.

## Competitions in QA

 |  | 数据集 | 语言 | 主办单位 | 自 | 排名靠前 | 型号 | 状态 | 超越人类表现 |
|---|------------------|---------------|---------------------|-------|-------------------------|-------------------------|--------|------------------------|
| 0 | [Story Cloze Test](http://cs.rochester.edu/~nasrinm/files/Papers/lsdsem17-shared-task.pdf)  | 英语 | 大学罗彻斯特 |  2016年| 管理部门 | 逻辑回归 | 关闭 |  × |
| 1 | MS MARCO         | English       | Microsoft           | 2016  | YUANFUDAO research NLP  | MARS                    | Closed | o                      |
 |  2 |  MS 马可 V2 | 英语 | 微软 |  2018 |  NTT 媒体智能. 实验室.  | 面具问答风格 | 开业 |  × |
| 3 | [SQuAD](https://arxiv.org/abs/1606.05250)             | 英语 | 大学斯坦福 |  2018 |  XLNet（单模型）|XLNet Team | 关闭 |  o |
| 4 | [SQuAD 2.0](https://rajpurkar.github.io/SQuAD-explorer/)         | 英语 | 大学斯坦福 |  2018 | 平安全华|  ALBERT + DAAF + Verifier（合奏）| 打开| 哦|
| 5 | [TriviaQA](http://nlp.cs.washington.edu/triviaqa/)          | 英语 | 大学华盛顿 |  2017 | 明艳 |  - | 关闭 |  - |
| 6 | [decaNLP](https://decanlp.com/)           | 英语 | 销售人员研究 |  2018 | 销售人员研究 |  MQAN | 关闭 |  × |
| 7 | [DuReader Ver1.](https://ai.baidu.com/broad/introduction)           | 中文 | 百度|  2015 | 试用者 |  T-Reader（单） | 关闭 |  × |
| 8 | [DuReader Ver2.](https://ai.baidu.com/broad/introduction)           | 中文 | 百度|  2017 | 文艺复兴 | 阿里阅读器 | 开业 |  - |
| 9 | [KorQuAD](https://korquad.github.io/KorQuad%201.0/)     | 韩语 |  LG CNS 人工智能研究 |  2018 |  Clova AI LaRva 团队 |  LaRva-Kor-Large+ + CLaF（单个）| 关闭 |  o |
| 10 | [KorQuAD 2.0](https://korquad.github.io/)     | 韩语 |  LG CNS 人工智能研究 |  2019 | 江原大学 |  KNU-baseline(单模型) | 开业 |  × |
| 11 | [CoQA](https://stanfordnlp.github.io/coqa/)     | 英语 | 大学斯坦福 |  2018 | 追一科技 |  RoBERTa + AT + KD（合奏）| 开业 |  o |

## Publications
- 论文
  - ["Learning to Skim Text"](https://arxiv.org/pdf/1704.06877.pdf), Adams Wei Yu, Hongrae Lee, Quoc V. Le, 2017.
    ：仅在文本中显示您想要的内容
  - ["Deep Joint Entity Disambiguation with Local Neural Attention"](https://arxiv.org/pdf/1704.04920.pdf), Octavian-Eugen Ganea 和 Thomas Hofmann，2017 年.
  - ["BI-DIRECTIONAL ATTENTION FLOW FOR MACHINE COMPREHENSION"](https://arxiv.org/pdf/1611.01603.pdf), Minjoon Seo, Aniruddha Kembhavi, Ali Farhadi, Hananneh Hajishirzi, ICLR, 2017.
  - ["Capturing Semantic Similarity for Entity Linking with Convolutional Neural Networks"](http://nlp.cs.berkeley.edu/pubs/FrancisLandau-Durrett-Klein_2016_EntityConvnets_paper.pdf)、Matthew Francis-Landau、Greg Durrett 和 Dan Klei，NAACL-HLT 2016.
    - https://GitHub.com/matthewfl/nlp-entity-convnet
  - ["Entity Linking with a Knowledge Base: Issues, Techniques, and Solutions"](https://ieeexplore.ieee.org/document/6823700/), Wei Shen, Jianyong Wang, Jiawei Han, IEEE Transactions on Knowledge and Data Engineering(TKDE), 2014.
  - ["Introduction to “This is Watson"](https://ieeexplore.ieee.org/document/6177724/), IBM 研究与开发期刊，DA Ferrucci，2012 年.
  - ["A survey on question answering technology from an information retrieval perspective"](https://www.sciencedirect.com/science/article/pii/S0020025511003860), 信息科学, 2011.
  - ["Question Answering in Restricted Domains: An Overview"](https://www.mitpressjournals.org/doi/abs/10.1162/coli.2007.33.1.41), Diego Mollá 和 José Luis Vicedo，计算语言学，2007 年
  - [“自然语言问答：从这里看”]()，L Hirschman，R Gaizauskas，自然语言工程，2001 年.
  - 实体消歧/实体链接

## Codes
- [BiDAF](https://github.com/allenai/bi-att-flow) - 双向注意流（BIDAF）网络是一个多阶段的层次化过程，它以不同的粒度级别表示上下文，并使用双向注意流机制来获得查询感知的上下文表示，而无需进行早期总结. 
   - 官方的; 张量流 v1.2
  - [Paper](https://arxiv.org/pdf/1611.01603.pdf)
- [QANet](https://github.com/NLPLearn/QANet) - 问答架构不需要循环网络：它的编码器完全由卷积和自注意力组成，其中卷积模拟局部交互，自注意力模拟全局交互.
   - 谷歌; 非官方; 张量流 v1.5
- [R-Net](https://github.com/HKUST-KnowComp/R-Net) - 用于阅读理解式问答的端到端神经网络模型，旨在回答给定段落中的问题.
   - 多发性硬化症; 由香港科技大学非正式提供； 张量流 v1.5
  - [Paper](https://www.microsoft.com/en-us/research/wp-content/uploads/2017/05/r-net.pdf)
- [R-Net-in-Keras](https://github.com/YerevaNN/R-NET-in-Keras) - 在 Keras 中重新实现 R-NET.
   - 多发性硬化症; 非官方; 凯拉斯 v2.0.6
  - [Paper](https://www.microsoft.com/en-us/research/wp-content/uploads/2017/05/r-net.pdf)
- [DrQA](https://github.com/hitvoice/DrQA) - DrQA 是一个应用于开放域问答的阅读理解系统.
   - Facebook; 官方的; 火炬 v0.4
- [BERT](https://github.com/google-research/bert)  - 一种新的语言表示模型，代表来自 Transformers 的双向编码器表示. 与最近的语言表示模型不同，BERT 旨在通过联合调节所有层中的左右上下文来预训练深度双向表示. 
  - Google; Official implementation; Tensorflow v1.11.0
  - [Paper](https://arxiv.org/abs/1810.04805)

## Lectures
- [Question Answering - Natural Language Processing](https://youtu.be/Kzi6tE4JaGo)  - 作者：Dragomir Radev，博士 | 密歇根大学 |  2016.

## Slides
- [Question Answering with Knowledge Bases, Web and Beyond](https://github.com/scottyih/Slides/blob/master/QA%20Tutorial.pdf) - By Scott Wen-tau Yih & Hao Ma | Microsoft Research | 2016.
- [Question Answering](https://hpi.de/fileadmin/user_upload/fachgebiete/plattner/teaching/NaturalLanguageProcessing/NLP2017/NLP8_QuestionAnswering.pdf)  - 由博士玛丽安娜·内维斯 | 哈索普拉特纳研究所 |  2017年

## Dataset Collections
- [NLIWOD's Question answering datasets](https://github.com/dice-group/NLIWOD/tree/master/qa.datasets)
- [karthinkncode's Datasets for Natural Language Processing](https://github.com/karthikncode/nlp-datasets)

## Datasets
- [AI2 Science Questions v2.1(2017)](http://data.allenai.org/ai2-science-questions/)
   - 它包括美国小学和中学各年级学生评估中使用的问题. 每个问题都是 4 向多项选择格式，可能包含也可能不包含图表元素.
  - 论文：http://ai2-website.s3.amazonaws.com/publications/AI2ReasoningChallenge2018.pdf
- [Children's Book Test](https://uclmr.github.io/ai4exams/data.html)
 - 它是 Facebook AI Research 的 bAbI 项目之一，旨在实现自动文本理解和推理的目标.  CBT 旨在直接衡量语言模型利用更广泛的语言环境的能力.
- [CODAH Dataset](https://github.com/Websail-NU/CODAH)
- [DeepMind Q&A Dataset; CNN/Daily Mail](https://github.com/deepmind/rc-data)
   - 赫尔曼等人.  (2015) 使用新闻文章创建了两个很棒的数据集用于问答研究. 每个数据集包含许多文档（每个 90k 和 197k），每个文档平均包含大约 4 个问题. 每个问题都是一个句子，其中缺少一个单词/短语，可以从随附的文档/上下文中找到.
  - 论文：https://arxiv.org/abs/1506.03340
- [ELI5](https://github.com/facebookresearch/ELI5)
  - 论文：https://arxiv.org/abs/1907.09190
- [GraphQuestions](https://github.com/ysu1989/GraphQuestions)
  - 为 QA 评估生成特征丰富的问题​​集.
- [LC-QuAD](http://sda.cs.uni-bonn.de/projects/qa-dataset/)
   - 这是包含 5000 个问题和 SPARQL 查询的黄金标准 KBQA（知识库问答）数据集.  LC-QuAD 使用 DBpedia v04.16 作为目标 KB.
- [MS MARCO](http://www.msmarco.org/dataset.aspx)
  - 这是用于真实世界的问题回答.
  - 论文：https://arxiv.org/abs/1611.09268
- [MultiRC](https://cogcomp.org/multirc/)
  - 短段落和多句问题的数据集
  - 论文：http://cogcomp.org/page/publication_view/833 
- [NarrativeQA](https://github.com/deepmind/narrativeqa)
  - 它包括带有维基百科摘要的文档列表、完整故事的链接以及问题和答案.
  - 论文：https://arxiv.org/pdf/1712.07040v1.pdf
- [NewsQA](https://github.com/Maluuba/newsqa)
  - 机器理解数据集
  - 论文：https://arxiv.org/pdf/1611.09830.pdf
- [Qestion-Answer Dataset by CMU](http://www.cs.cmu.edu/~ark/QA-data/)
   - 这是维基百科文章的语料库，从中手动生成的事实问题，以及对这些问题的手动生成的答案，用于学术研究. 这些数据由 Noah Smith、Michael Heilman、Rebecca Hwa、Shay Cohen、Kevin Gimpel 以及卡内基梅隆大学和匹兹堡大学的许多学生在 2008 年至 2010 年间收集.
- [SQuAD1.0](https://rajpurkar.github.io/SQuAD-explorer/)
  - 斯坦福问答数据集 (SQuAD) 是一个阅读理解数据集，由众包工作者针对一组维基百科文章提出的问题组成，其中每个问题的答案都是来自相应阅读文章的一段文本或跨度，或问题可能无法回答.
  - 论文：https://arxiv.org/abs/1606.05250
- [SQuAD2.0](https://rajpurkar.github.io/SQuAD-explorer/)
   - SQuAD2.0 结合了 SQuAD1.1 中的 100,000 个问题和超过 50,000 个新的、无法回答的问题，这些问题由众包工作者以对抗方式编写，看起来与可回答的问题相似. 要想在 SQuAD2.0 上做好，系统不仅要在可能的情况下回答问题，还要判断什么时候段落不支持答案并放弃回答.
  - 论文：https://arxiv.org/abs/1806.03822
- [Story cloze test](http://cs.rochester.edu/nlp/rocstories/)
   - “故事完形填空测试”是一种新的常识性推理框架，用于评估故事理解、故事生成和脚本学习. 这个测试需要一个系统来选择一个四句故事的正确结局.
  - 论文：https://arxiv.org/abs/1604.01696
- [TriviaQA](http://nlp.cs.washington.edu/triviaqa/)
   - TriviaQA 是一个阅读理解数据集，包含超过 650K 个问答证据三元组.  TriviaQA 包括 95K 由问答爱好者编写的问答对和独立收集的证据文件，平均每个问题 6 个，为回答问题提供高质量的远程监督. 
  - 论文：https://arxiv.org/abs/1705.03551
- [WikiQA](https://www.microsoft.com/en-us/download/details.aspx?id=52419&from=https%3A%2F%2Fresearch.microsoft.com%2Fen-US%2Fdownloads%2F4495da01-db8c-4041-a7f6-7984a4f6a905%2Fdefault.aspx)
  - 一组公开可用的问题和句子对，用于开放域问答.
  
### The DeepQA Research Team in IBM Watson's publication within 5 years
- 2015
  - “从 IBM Watson 中的电子病历自动生成问题列表”，Murthy Devarakonda，Ching-Huei Tsou，IAAI，2015 年.
  - “IBM Watson 问答系统中的决策”，J. William Murdock，Ontology 峰会，2015 年.
  - ["Unsupervised Entity-Relation Analysis in IBM Watson"](http://www.cogsys.org/papers/ACS2015/article12.pdf), Aditya Kalyanpur, J William Murdock, ACS, 2015.
  - “常识推理：基于事件演算的方法”，ET Mueller，Morgan Kaufmann/Elsevier，2015 年.
- 2014
  - “面向问题的病历摘要：Watson 应用程序的早期报告”，M. Devarakonda、Dongyang Zhang、Ching-Huei Tsou、M. Bornea、Healthcom，2014 年.
  - ["WatsonPaths: Scenario-based Question Answering and Inference over Unstructured Information"](http://domino.watson.ibm.com/library/Cyberdig.nsf/1e4115aea78b6e7c85256b360066f0d4/088f74984a07645485257d5f006ace96!OpenDocument&Highlight=0,RC25489), Adam Lally, Sugato Bachi, Michael A. Barborak, David W. Buchanan, Jennifer Chu-Carroll, David A. Ferrucci*, Michael R. Glass, Aditya Kalyanpur, Erik T. Mueller, J. William Murdock, Siddharth Patwardhan, 约翰M. Prager、Christopher A. Welty，IBM 研究报告 RC25489，2014 年.
  - ["Medical Relation Extraction with Manifold Models"](http://acl2014.org/acl2014/P14-1/pdf/P14-1078.pdf), Chang Wang 和 James Fan，ACL，2014 年.

### MS Research's publication within 5 years
- 2018
  - "Characterizing and Supporting Question Answering in Human-to-Human Communication", Xiao Yang, Ahmed Hassan Awadallah, Madian Khabsa, Wei Wang, Miaosen Wang, ACM SIGIR, 2018.
  - ["FigureQA: An Annotated Figure Dataset for Visual Reasoning"](https://arxiv.org/abs/1710.07300), Samira Ebrahimi Kahou, Vincent Michalski, Adam Atkinson, Akos Kadar, Adam Trischler, Yoshua Bengio, ICLR, 2018
- 2017
  - "Multi-level Attention Networks for Visual Question Answering", Dongfei Yu, Jianlong Fu, Tao Mei, Yong Rui, CVPR, 2017.
  - “问题回答和问题生成的联合模型”，Tong Wang、Xingdi (Eric) Yuan、Adam Trischler，ICML，2017 年.
  - “用于机器理解中迁移学习的两阶段合成网络”，David Golub、Po-Sen Huang、Xiaodong He、Li Deng、EMNLP，2017 年.
  - “Question-Answering with Grammatically-Interpretable Representations”, Hamid Palangi, Paul Smolensky, Xiaodong He, Li Deng, 
  - “用于顺序问答的基于搜索的神经结构化学习”，Mohit Iyyer、Wen-tau Yih、Ming-Wei Chang，ACL，2017 年.
- 2016
  - ["Stacked Attention Networks for Image Question Answering"](https://www.cv-foundation.org/openaccess/content_cvpr_2016/html/Yang_Stacked_Attention_Networks_CVPR_2016_paper.html), Zichao Yang, Xiaodong He, Jianfeng Gao, Li Deng, Alex Smola, CVPR, 2016.
  - ["Question Answering with Knowledge Base, Web and Beyond"](https://www.microsoft.com/en-us/research/publication/question-answering-with-knowledge-base-web-and-beyond/), Yih, Scott Wen-tau and Ma, Hao, ACM SIGIR, 2016.
  - ["NewsQA: A Machine Comprehension Dataset"](https://arxiv.org/abs/1611.09830), Adam Trischler, Tong Wang, Xingdi Yuan, Justin Harris, Alessandro Sordoni, Philip Bachman, Kaheer Suleman, RepL4NLP, 2016.
  - ["Table Cell Search for Question Answering"](https://dl.acm.org/citation.cfm?id=2883080), Sun, Huan and Ma, Hao and He, Xiaodong and Yih, Wen-tau and Su, Yu and Yan, Xifeng, WWW, 2016.
- 2015
  - ["WIKIQA: A Challenge Dataset for Open-Domain Question Answering"](https://www.microsoft.com/en-us/research/wp-content/uploads/2016/02/YangYihMeek_EMNLP-15_WikiQA.pdf), Yi Yang, Wen-tau Yih, and Christopher Meek, EMNLP, 2015.
  - ["Web-based Question Answering: Revisiting AskMSR"](https://www.microsoft.com/en-us/research/wp-content/uploads/2016/02/AskMSRPlusTR_082815.pdf), Chen-Tse Tsai、Wen-tau Yih 和 Christopher JC Burges，MSR-TR，2015 年.
  - ["Open Domain Question Answering via Semantic Enrichment"](https://dl.acm.org/citation.cfm?id=2741651), Huan Sun, Hao Ma, Wen-tau Yih, Chen-Tse Tsai, Jingjing Liu, and Ming-Wei Chang, WWW, 2015.
- 2014
  - ["An Overview of Microsoft Deep QA System on Stanford WebQuestions Benchmark"](https://www.microsoft.com/en-us/research/wp-content/uploads/2016/02/Microsoft20Deep20QA.pdf), Zhenghao Wang, Shengquan Yan, Huaming Wang, and Xuedong Huang, MSR-TR, 2014.
  - [“单关系问答的语义解析”]()，Wen-tau Yih、Xiaodong He、Christopher Meek，ACL，2014 年.
  
### Google AI's publication within 5 years
- 2018
  - 谷歌质量检查<a name="qanet"></a>
    - ["QANet: Combining Local Convolution with Global Self-Attention for Reading Comprehension"](https://openreview.net/pdf?id=B14TlG-RW), Adams Wei Yu, David Dohan, Minh-Thang Luong, Rui Zhao, Kai Chen, Mohammad Norouzi, Quoc V. Le, ICLR, 2018.
    - ["Ask the Right Questions: Active Question Reformulation with Reinforcement Learning"](https://openreview.net/pdf?id=S1CChZ-CZ)、Christian Buck、Jannis Bulian、Massimiliano Ciaramita、Wojciech Paweł Gajewski、Andrea Gesmundo、Neil Houlsby 和 Wei Wang，ICLR，
    - ["Building Large Machine Reading-Comprehension Datasets using Paragraph Vectors"](https://arxiv.org/pdf/1612.04342.pdf), Radu Soricut, Nan Ding, 2018.
  - 句子表示
    - ["An efficient framework for learning sentence representations"](https://arxiv.org/pdf/1803.02893.pdf), Lajanugen Logeswaran, Honglak Lee, ICLR, 2018.
  - ["Did the model understand the question?"](https://arxiv.org/pdf/1805.05492.pdf), Pramod K. Mudrakarta 和 Ankur Taly 以及 Mukund Sundararajan 和 Kedar Dhamdhere，ACL，2018 年.
- 2017
  - ["Analyzing Language Learned by an Active Question Answering Agent"](https://arxiv.org/pdf/1801.07537.pdf)、Christian Buck、Jannis Bulian、Massimiliano Ciaramita、Wojciech Gajewski、Andrea Gesmundo、Neil Houlsby 和 Wei Wang，NIPS，
  - ["Learning Recurrent Span Representations for Extractive Question Answering"](https://arxiv.org/pdf/1611.01436.pdf), Kenton Lee、Shimi Salant、Tom Kwiatkowski、Ankur Parikh、Dipanjan Das 和 Jonathan Berant，ICLR，2017 年.
  - 确定相同的问题
    - ["Neural Paraphrase Identification of Questions with Noisy Pretraining"](https://arxiv.org/pdf/1704.04565.pdf)、Gaurav Singh Tomar、Thyago Duque、Oscar Täckström、Jakob Uszkoreit 和 Dipanjan Das，SCLeM，
- 2014
  - “好问题！社区问答中的问题质量”，Sujith Ravi 和 Bo Pang 以及 Vibhor Rastogi 和 Ravi Kumar，ICWSM，2014 年.

### Facebook AI Research's publication within 5 years
- 2018
  - [Embodied Question Answering](https://research.fb.com/publications/embodied-question-answering/), Abhishek Das、Samyak Datta、Georgia Gkioxari、Stefan Lee、Devi Parikh 和 Dhruv Batra，CVPR，2018
  - [Do explanations make VQA models more predictable to a human?](https://research.fb.com/publications/do-explanations-make-vqa-models-more-predictable-to-a-human/), Arjun Chandrasekaran、Viraj Prabhu、Deshraj Yadav、Prithvijit Chattopadhyay 和 Devi Parikh，EMNLP，2018 年
  - [Neural Compositional Denotational Semantics for Question Answering](https://research.fb.com/publications/neural-compositional-denotational-semantics-for-question-answering/), Nitish Gupta, Mike Lewis, EMNLP, 2018
- 2017
  - 博士QA<a name="drqa"></a>
    - [Reading Wikipedia to Answer Open-Domain Questions](https://cs.stanford.edu/people/danqi/papers/acl2017.pdf), Danqi Chen, Adam Fisch, Jason Weston &amp; Antoine Bordes, ACL, 2017.

## Books
- 自然语言问答系统平装本 - Boris Galitsky (2003)
- 问题解答的新方向 - Mark T. Maybury (2004)
- 第 3 部分.5. 《牛津计算语言学手册》中的问答 - Sanda Harabagiu 和 Dan Moldovan（2005 年）
- 第 28 章语音和语言处理中的问答 - Daniel Jurafsky &amp; James H. Martin (2017)

## Links
- [Building a Question-Answering System from Scratch— Part 1](https://towardsdatascience.com/building-a-question-answering-system-part-1-9388aadff507)
- [Qeustion Answering with Tensorflow By Steven Hewitt, O'REILLY, 2017](https://www.oreilly.com/ideas/question-answering-with-tensorflow)
- [Why question answering is hard](http://nicklothian.com/blog/2014/09/25/why-question-answering-is-hard/)


## Contributing

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/seriousran/awesome-qa/blob/master/contributing.md) 第一的.

## License
[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/share-your-work/public-domain/cc0/)

在法律允许的范围内， [seriousmac](https://github.com/seriousmac) （维护者）放弃了该作品的所有版权和相关或邻接权.
