<div class="github-widget" data-repo="passy/awesome-purescript"></div>
## awesome-purescript [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; PureScript 的令人愉快的库、工具和其他闪亮事物的精选列表.

## Build Tooling

- [pulp](https://github.com/bodil/pulp)
- [psvm-js](https://github.com/ThomasCrvsr/psvm-js) - PureScript 版本管理器
- [purescript-psa](https://github.com/natefaubion/purescript-psa) - 一个漂亮、灵活的 `psc` 错误/警告报告前端
- [grunt-purescript](https://github.com/purescript-contrib/grunt-purescript)
- [gulp-purescript](https://github.com/purescript-contrib/gulp-purescript)
- [purs-loader](https://github.com/ethul/purs-loader) 对于 webpack
- [psc-package](https://github.com/purescript/psc-package) - 基于包集的 PureScript 包管理器
- [spago](https://github.com/spacchetti/spago) - 由 Dhall 和包集提供支持的 PureScript 包管理器和构建工具

## Preludes

- [purescript-prelude](https://github.com/purescript/purescript-prelude) - 标准序曲.
- [purescript-batteries](https://github.com/tfausak/purescript-batteries) - 具有更多功能的 PureScript 前奏.

## UI Libraries

CSS:

- [purescript-css](https://github.com/slamdata/purescript-css) - 一个干净的、类型安全的库，用于描述、操作和渲染 CSS.

React-based:

- [purescript-thermite](https://github.com/paf31/purescript-thermite) - 受 `react-blaze` 启发的 ReactJS 的简单包装器.
- [purescript-react](https://github.com/purescript-contrib/purescript-react) - PureScript 的 React 绑定
- [purescript-react-basic](https://github.com/lumihq/purescript-react-basic) - 一组固定的 React 库绑定，针对最基本的用例进行了优化.
- [purescript-react-basic-hooks](https://github.com/spicydonuts/purescript-react-basic-hooks)  - 另一种使用 React 的“挂钩”API 定义 React 组件的方法. 与 `purescript-react-basic` 兼容.
- [purescript-pux](https://github.com/alexmingoia/purescript-pux) - 使用 PureScript 构建类型安全的 Web 应用程序.
- [purescript-spork](https://github.com/natefaubion/purescript-spork) - 类似于 PureScript 的榆树.
- [purescript-concur](https://github.com/ajnsit/purescript-concur)  - 同意 UI 框架.  React 后端，但可以使用其他后端.
- [purescript-presto](https://github.com/juspay/purescript-presto) - 编写数学方程式等应用程序！
- [purescript-optic-ui](https://github.com/zrho/purescript-optic-ui) - 借助镜头和遍历以声明和简洁的方式编写单页 Web 用户界面.
- [purescript-react-explor](https://github.com/paf31/purescript-react-explore) - 尝试使用 comonads 对 React UI 进行建模.

基于虚拟 DOM：

- [purescript-halogen](https://github.com/slamdata/purescript-halogen) - 声明式、类型安全的 UI 库.
- [purescript-hedwig](https://github.com/utkarshkukreti/purescript-hedwig) - Hedwig 是一个快速、类型安全、声明式的 PureScript 库，用于构建 Web 应用程序.
- [purescript-flame](https://github.com/easafe/purescript-flame) - Flame 是一个快速简单的框架，用于在受 purescript-hedwig 和 Elm 启发的 PureScript 中构建 Web 应用程序

Signals/Behaviors/FRP:

- [purescript-flare](https://github.com/sharkdp/purescript-flare) - 建立在纯脚本信号之上的应用式反应式用户界面.
- [purescript-turbine](https://github.com/funkia/purescript-turbine) - 由 FRP 提供支持的纯功能性前端框架.
- [purescript-outwatch](https://github.com/OutWatch/purescript-outwatch) - 基于 Rx 和 VirtualDom 的功能性和反应性 UI 框架.
- [purescript-panda](https://github.com/i-am-tom/purescript-panda) - 如果我们没有 VDOM，TEA 会是什么样子？
- [purescript-specular](https://github.com/restaumatic/purescript-specular) - 受 Reflex-Dom 启发的 PureScript UI 库.
- [purescript-sdom](https://github.com/paf31/purescript-sdom) - 替换虚拟 DOM 和避免 diffing 的实验.
- [purescript-purview](https://github.com/paf31/purescript-purview) - 基于增量 lambda 演算的 UI 库.

## URL Routers

- [purescript-routing](https://github.com/slamdata/purescript-routing) - 一个干净的、类型安全的 PureScript 路由库.
- [purescript-cofree-react-router](https://github.com/coot/purescript-cofree-react-router) - 在 PureScript 中实现的 React-Router 作为 Array 仿函数的 Cofree Comonad.
- [purescript-trout](https://github.com/owickstrom/purescript-trout) - PureScript 的类型级路由.
- [purescript-boomboom](https://github.com/paluh/purescript-boomboom)  - 永远不要再对您的网址进行硬编码. 轰隆隆他们！
- [purescript-routing-duplex](https://github.com/natefaubion/purescript-routing-duplex) - 用于路由数据类型的简单双向解析器/打印机.

## Components

- [purescript-halogen-formless](https://github.com/thomashoneyman/purescript-halogen-formless) - 用于在 Halogen 中构建无痛形式的无渲染组件
- [purescript-halogen-select](https://github.com/citizennet/purescript-halogen-select) - 常见选择用户界面的构建块，如下拉菜单、预输入、图像选择器和日历.
- [purescript-halogen-echarts](https://github.com/slamdata/purescript-halogen-echarts) - 流行的 ECharts 图表库的 Halogen 集成
- [purescript-halogen-day-picker](https://github.com/rnons/purescript-halogen-day-picker) - 卤素日选择器
- [purescript-halogen-menu](https://github.com/slamdata/purescript-halogen-menu) - 卤素交互式菜单

## Asynchronicity and Parallelism

- [purescript-aff](https://github.com/slamdata/purescript-aff) - PureScript 的异步效果 monad.
- [purescript-affjax](https://github.com/slamdata/purescript-aff) - 使用 Aff 构建的异步 AJAX 库.
- [purescript-queue](https://github.com/athanclark/purescript-queue) - PureScript 的异步队列库.
- [purescript-signal](https://github.com/bodil/purescript-signal) - PureScript 的异步信号库，类似于 Elm.
- [purescript-zeta](https://github.com/athanclark/purescript-zeta) - PureScript 中的替代信号实现.

## Effect Management

- [purescript-eff](https://github.com/purescript/purescript-eff) - Eff monad，用于处理本机副作用.
- [purescript-effect](https://github.com/purescript/purescript-effect) - Effect monad，用于处理 PureScript v0.12.x 中的本机副作用.

## Json Serialization

- [purescript-argonaut](https://github.com/purescript-contrib/purescript-argonaut) - Json 编码和解码类型类.
- [purescript-simple-json](https://github.com/justinwoo/purescript-simple-json) - 通过泛型进行 Json 编码和解码.

## Binary Serialization

- [purescript-arraybuffer](https://github.com/jacereda/purescript-arraybuffer) - 绑定到 ArrayBuffer JavaScript 类型.
- [purescript-arraybuffer-class](https://github.com/athanclark/purescript-arraybuffer-class) - ArrayBuffer 编码和解码的类型类.
- [purescript-arraybuffer-builder](https://github.com/jamesdbrock/purescript-arraybuffer-builder) - 用于序列化 ArrayBuffer 的生成器
- [purescript-parsing-dataview](https://github.com/jamesdbrock/purescript-parsing-dataview) - 用于反序列化 ArrayBuffer 的解析器
- [purescript-protobuf](https://github.com/xc-jp/purescript-protobuf) - 谷歌协议缓冲区

## Testing

- [purescript-test-unit](https://github.com/bodil/purescript-test-unit) - PureScript 的异步单元测试运行器.
- [purescript-quickcheck](https://github.com/purescript/purescript-quickcheck) - 在 PureScript 中实现 QuickCheck.
- [purescript-quickcheck-laws](https://github.com/garyb/purescript-quickcheck-laws) - 核心课程的法律测试.
- [purescript-benchotron](https://github.com/hdgarrood/purescript-benchotron) - PureScript/JavaScript 的直接基准测试.

## Learning Resources

- [Video - "PureScript (Maybe This Time We Get JavaScript Right)" by Bodil Stokke](https://www.youtube.com/watch?v=yIlDBPiMb0o)
- [Book - "PureScript by Example" by Phil Freeman](https://leanpub.com/purescript/read)
- [Book (ish) - Jordan's Purescript Reference](https://github.com/JordanMartinez/purescript-jordans-reference)
- [PureScript for Haskellers by Dennis Gosnell](http://www.arow.info/blog/posts/2015-12-17-purescript-intro.html)
- [Podcast - Functional Geekery Episode 22](https://www.functionalgeekery.com/episode-22-lambdaconf-2015-part-1/)
- [Podcast - JSJ 189](https://devchat.tv/js-jabber/189-jsj-purescript-with-john-a-de-goes-and-phil-freeman)
- [Course (egghead.io) - Functional Programming Concepts in Purescript](https://egghead.io/courses/functional-programming-concepts-in-purescript)
- [Guide - Real World Halogen](https://thomashoneyman.com/guides/real-world-halogen)

## Discovery

- [Module Linker](https://fiatjaf.alhur.es/module-linker/#/purescript) - 允许您通过单击 GitHub 上的“导入”声明来浏览文档的扩展.
- [Pursuit](https://pursuit.purescript.org/)

## Editor and IDE Plugins

See [Editor and tool support](https://github.com/purescript/purescript/wiki/Editor-and-tool-support)

## Community

- [`/r/purescript` subreddit](http://www.reddit.com/r/purescript)
- [`#purescript` on Freenode](http://webchat.freenode.net/?channels=purescript)
- [Stack Overflow `purescript` tag](http://stackoverflow.com/questions/tagged/purescript)
- [Google Group](https://groups.google.com/forum/#!forum/purescript)

## More Resources

- [Purescript Ecosystem](https://github.com/xgrommx/purescript-ecosystem) - 热门图书馆排行榜.

## Contribute

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/passy/awesome-purescript/blob/master/contributing.md) 第一的.


## License

[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Pascal Hartig](https://passy.me/) 已放弃该作品的所有版权和相关或邻接权.
