<div class="github-widget" data-repo="HollyAdele/awesome-programming-for-kids"></div>
## Awesome Programming for Kids [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
A curated list of awesome resources for teaching kids programming. 


## Pre-Literate
* [Scratch Jr.](https://www.scratchjr.org/) - An app that teaches young kids how to visually code interactive stories and games. A simplified version of the Scratch website, for a tablet. 
* [The Foos](https://itunes.apple.com/app/id923441570) - A funny, pre-literate iPad game that teaches concepts for commands, parameters, loops, and conditionals. 
* [Code-a-pillar](https://www.fisher-price.com/en-us/product/think-learn-code-a-pillar-twist-gfp25) - A walking and singing catapiller toy that can be programmed by connecting a series of segments that give instructions.

## Lower Elementary 
* [Scratch](https://scratch.mit.edu/) - Scratch is a popular visual programming language for beginners, created by MIT. The Scratch website is a platform for kids to make interactive stories and share them with each other.
* [Hopscotch](https://www.gethopscotch.com/) - Hopscotch is a code block editor like Scratch, but in an iOS app. Can program code to react to tipping and shaking the device. 
* [Evo from Ozobot](https://ozoblockly.com/editor?lang=en&robot=evo&mode=2) - Evo is a tiny robot that can move, light up, and make sounds. Also it detects what color it is driving on. It can follow commands based on the color of the line it is following. Or, it can be programmed using a code block editor like Scratch. Hold the robot up to a flashing dot on the screen, and the website will load the program onto the robot with light flashes. 
* [Lightbot](https://lightbot.com/) - Solve puzzles with commands, loops, and conditionals. Comes in Lightbot and lightbot Jr, and a mobile app or a desktop website.   
* [Code.org](https://studio.code.org/) - A website with interactive coding games and courses for kids. Covers a large range of ages and skill levels.
* [Code Master](https://www.thinkfun.com/products/code-master/) - An addictive board game that builds problem solving skills and understanding of programming logic. Starts basic and moves to very advanced. 
* [Cargo Bot](https://itunes.apple.com/us/app/cargo-bot/id519690804?mt=8) - iPad app to solve problems with constraints using commands, loops, conditional statements. More difficult puzzles than Lightbot.
* [Python Turtle](https://github.com/PythonTurtle/PythonTurtle) original (1986-2021) simple 'Python-Turtle' model.
* [Code Monkey](https://app.codemonkey.com/users/sign_up/student/age) - more graphics to learn Python type of code. ( Not-free for advanced levels )


## Upper Elementary
* [tinkercad.com](https://www.tinkercad.com/things?type=codeblocks&view_mode=default) - TinkerCAD is a free, 3D CAD modeling software program for children. Users can also manipulate the shapes using code blocks like Scratch.
* [DIY.org](https://diy.org/skills) - An online community for kids to learn anything.  Programming skills listed are App Dev, Backend Dev, Frontend Dev, Game Dev, Graphic Designer, Open Sourcerer, Scratcher, Sys Admin, and Web Designer. 
* [Code Combat](https://codecombat.com/) - Code a hero to compete heroic tasks using Javascript or Python. The hero gets new weapons or skills whenever the user learns a new method. 
* [Web Design for Kids](https://webdesign.tutsplus.com/series/web-design-for-kids--cms-823) - A series of tutorials teaching children the basics of designing and building a website with HTML and CSS.
* [Finch Robot](https://www.birdbraintechnologies.com/finch2/) - A small robot designed for computer science education with support for multiple programming languages.
* [Secret Coders](http://www.secret-coders.com/buy-the-books/) - A engaging book series that teaches programming concepts through Logo. 
* [Khan Academy - Computer Programming](https://www.khanacademy.org/computing/computer-programming) - A series of web-based programming lessons with interactive challenges, by Khan Academy. Teaches topics like animation, game development, and web programming.  Users can post questions, which get answered quickly by the community.  
* [Bitsbox](https://bitsbox.com/) - A monthly box subscription that teaches kids how to code.
* [CS Unplugged](http://csunplugged.org/) - A collection of free learning activities that teach Computer Science through engaging games and puzzles that use cards, string, crayons and lots of running around.
* [Lauren Ipsum](http://laurenipsum.org/) - A book that teaches problem-solving concepts in the context of programming.  Sample chapters available online.
* [Lego Mindstorms](http://www.lego.com/en-us/mindstorms/?domainredir=mindstorms.lego.com) - A robotics kit by Lego.
* [Ruby Warrior](https://www.bloc.io/ruby-warrior#/) - An online tutorial-game with cool music that teaches Ruby programming.
* [Swift Playgrounds](http://www.apple.com/swift/playgrounds/) - Apple's fun iPad app for learning Swift.
* [Microsoft MakeCode](https://www.microsoft.com/en-us/makecode) - A suite of educational tools for kids, including online environments for game development, minecraft modding, hardware hacking, and more.
* [Sphereo](https://sphero.com/products/mini-at-home-learning-kit) - A spherical robot that can be programmed with a block-programming language in a companion app.
* [KODU Game Lab](https://www.kodugamelab.com/) - Kodu lets kids create 3D games on the PC and Xbox via a simple visual programming language.
