<div class="github-widget" data-repo="catalinmiron/awesome-prisma"></div>
![Awesome Prisma](https://i.imgur.com/MQdCTuN.png)

## Awesome Prisma

[![Awesome](https://awesome.re/badge.svg)](https://awesome.re)



## :tipping_hand_woman: About this List

This is a collection of **awesome resources** about [Prisma](https://www.prisma.io/ 'Modern Database Access for TypeScript & Node.js') :heart_eyes:

**Prisma is an open-source ORM**. It makes database access easy with type safety and an auto-generated query builder for TypeScript & Node.js.

## :books: Docs

- [Prisma Docs](https://www.prisma.io/docs/)
- [Prisma Examples](https://github.com/prisma/prisma-examples)

## :studio_microphone: Events

- [Prisma Day (remote)](http://prisma.io/day)
- [GraphQL Meetup (remote)](https://www.meetup.com/graphql-berlin/)
- [TypeScript Meetup (remote)](https://www.meetup.com/TypeScript-Berlin/)

## :safety_vest: Community Prisma Tools

- [Prisma Audit Trails](https://github.com/BemiHQ/bemi-prisma)
- [Prisma 2 Scratchpad](https://github.com/ctrlplusb/prisma2-template)
- [nx-nest-graphql](https://github.com/beeman/nx-nest-graphql)
- [Pal.js - CLI to start Prisma and GraphQl projects with just 2 commands](https://paljs.com)
- [CRUD generator for nexus](https://paljs.com/generator/nexus)
- [CRUD generator for graphql-modules](https://paljs.com/generator/graphql-modules)
- [CRUD generator for sdl-first approach](https://paljs.com/generator/sdl)
- [Prisma Select - solution for N + 1 issue](https://paljs.com/plugins/select)
- [Prisma Delete - workaround missing cascade deletes function in prisma migration](https://paljs.com/plugins/delete)
- [Prisma schema - convert schema.prisma file to javascript object or from Snake case to Camel case](https://paljs.com/cli/schema)
- [Prisma admin React component](https://paljs.com/prisma-admin)
- [Prisma plugin for the IntelliJ Platform](https://github.com/gabrielcolson/intellij-prisma)
- [Gatsby with prisma-client](https://github.com/LekoArts/gatsby-with-prisma-client)
- [Testing Prisma with PostgreSQL and Jest](https://github.com/ctrlplusb/prisma-pg-jest)
- [Documentation Generator](https://github.com/pantharshit00/prisma-docs-generator)
- [Schematics to add Prisma support to a NestJS application](https://github.com/marcjulian/nestjs-prisma)
- [Prisma Schema SDL](https://github.com/amplication/prisma-schema-dsl)
- [Multi-tenancy with Prisma](https://github.com/errorname/prisma-multi-tenant)
- [Starter Template for NestJS and Prisma](https://github.com/fivethree-team/nestjs-prisma-starter)
- [prisma-relay-cursor-connection](https://github.com/devoxa/prisma-relay-cursor-connection)
- [Caching Prisma](https://github.com/joellefkowitz/cached-prisma)
- [prettier-plugin-prisma](https://github.com/umidbekk/prettier-plugin-prisma)
- [prisma-sequelize-generator](https://github.com/floydspace/prisma-sequelize-generator)
- [Prisma Schema Sorter - sort schema models, enums, generators and datasources](https://github.com/omar-dulaimi/prisma-schema-sorter)
- [Declarative Authorisation Middleware](https://github.com/joindeed/prisma-auth)
- [NestJS and Prisma Yarn Monorepo Starter Template](https://github.com/alitnk/nest-prisma-monorepo)
- [Prisma Redis Middleware - cache queries in Redis](https://github.com/Asjas/prisma-redis-middleware)
- [Prisma Yup Generator - Prisma 2+ generator to emit Yup schemas from your Prisma schema](https://github.com/omar-dulaimi/prisma-yup-generator)
- [Schemix - Generate Prisma Schemas with TypeScript](https://github.com/ridafkih/schemix)
- [Prismock - Run tests in isolation with an in-memory implementation of Prisma](https://github.com/morintd/prismock)
- [prisma-ast - A Builder object to programmatically query and edit your schema.prisma files](https://github.com/MrLeebo/prisma-ast)
- [prisma-query-formatter - Substitute params and format queries for logging](https://github.com/s1owjke/prisma-query-formatter)

### :man_technologist: Prisma Clients

- [Prisma Client Python](https://github.com/RobertCraigie/prisma-client-py)


### :gear: Schema Visualization Tools

- [Prisma ERD Visualizer](https://github.com/skn0tt/prisma-erd)
- [prisma-uml](https://github.com/emyann/prisma-uml)
- [DBML Generator](https://github.com/notiz-dev/prisma-dbml-generator)
- [Prisma ERD Generator](https://github.com/keonik/prisma-erd-generator)
- [Prismaliser - Visualise your Prisma schema models and relations](https://prismaliser.app/)
- [Archibase - Collaborative schema editor based on Prisma SDL](https://archibase.dev/)
- [Prisma Editor - A powerful tool to visualize and edit Prisma Schema](https://github.com/mohammed-bahumaish/prisma-editor)
- [`prisma-markdown` - Markdown generator, including ERD and descriptions](https://github.com/samchon/prisma-markdown)
- [Hubql - Visualization platform with Prisma schema support](https://www.hubql.com/prisma)


## :thinking: How Tos

- [How to GraphQL](https://www.howtographql.com/)
- [PostgresQL Tutorials](https://www.prisma.io/tutorials/?tag=postgresql)

## :bird: Twitter

- [Prisma](http://twitter.com/prisma)
- [Nexus](http://twitter.com/nexusgql)

## :trophy: Tutorials

- [Get started with Prisma v2. Prisma Client](https://egghead.io/playlists/get-started-with-prisma-v2-prisma-client-8bae)
- [An Introduction to Prisma 2](https://blog.logrocket.com/an-introduction-to-prisma-2/)
- [Static Sites with Next.js 9.3 and Prisma](https://leerob.io/blog/next-prisma)
- [Using Prisma with GraphQL Codegen](https://medium.com/tomorrowapp/using-prisma-with-graphql-codegen-eed022c13749)
- [Using Prisma in Azure Functions](https://swacblooms.com/using-prisma-in-azure-functions/)
- [Building a sane Docker image for Typescript, Yarn Workspaces and Prisma 2](https://medium.com/@emilefugulin/building-a-sane-docker-image-for-typescript-lerna-and-prisma-2-76d8ff9926e4)
- [Building a Backend for React with Next.js, Prisma 2, and PostgreSQL](https://www.youtube.com/watch?v=Bqacj0iOL68)
- [Build A Pet Management System With Remix, Prisma, and Postgres](https://www.youtube.com/watch?v=wqyHGQlZcws&list=PLTnRtjQN5ieYu9SdwLvzKYFVtfqySY7FT)
- [How To Write Efficient Unit Tests with Prisma ORM](https://medium.com/javascript-in-plain-english/how-to-write-efficient-unit-tests-with-prisma-orm-e9d8fdf43f5f)

### Tutorials with [Nexus](https://www.nexusjs.org/#/)
- [Complete Introduction to Fullstack, Type-Safe GraphQL (feat. Next.js, Nexus, Prisma)](https://dev.to/prisma/complete-introduction-to-fullstack-type-safe-graphql-feat-next-js-nexus-prisma-c5)
- [Improve Your GraphQL performance with Prisma](https://dev.to/ahmedelywa/improve-your-graphql-performance-with-prisma-2jia)
- [Let's take Prisma 2 for a test drive on AWS Lambda with GraphQL](https://itnext.io/lets-take-prisma-2-for-a-test-drive-on-aws-lambda-with-graphql-%EF%B8%8F-f4be711e93cc)

### Tutorials with [NestJS](https://nestjs.com/)
- [How to query your database using Prisma with NestJS](https://notiz.dev/blog/how-to-connect-nestjs-with-prisma)

## :family_man_woman_girl_boy: Community

- [GitHub](https://github.com/prisma/prisma/)
- [Website](https://prisma.io)
- [Docs](https://prisma.io/docs/)
- [Blog](https://prisma.io/blog)
- [Slack](https://slack.prisma.io/)
- [Twitter](https://twitter.com/prisma)

## :space_invader: Projects Using Prisma

- [Calendso](https://github.com/calendso/calendso)
- [Tottem](https://github.com/poulainv/tottem)
- [Tomorrow](https://www.tomorrowapp.io/)
- [Predict Covid](https://predictcovid.com/)
- [NestJS Crud Prisma](https://github.com/silicon-hills/nestjs-crud-prisma) - Crud for restful api's built with NestJS and Prisma (uses [NestJSX CRUD](https://github.com/nestjsx/crud))
- [tRPC Prisma Starter](https://github.com/trpc/examples-next-prisma-starter) - Starter project with Prisma + Next.js + CI + testing + E2E type-safety using [tRPC](https://trpc.io)
- [prisma-next-auth-graphql-starter](https://github.com/wangel13/prisma-next-auth-graphql-starter) - Fullstack starter with Prisma, next-auth, next.js, tailwindcss and graphql-shield
- [Wasp](https://github.com/wasp-lang/wasp) Wasp is a declarative domain-specific language for developing, building, and deploying modern Javascript full-stack web apps with less code.
- [Neighborhood Pet Manager](https://github.com/AustinGil/npm)
- [Dotfyle](https://dotfyle.com) - Discover and share Neovim plugins

## Prisma 1

This is the second iteration of the awesome Prisma and focuses on Prisma 2.
Check out the [Awesome Prisma 1 list](https://github.com/catalinmiron/awesome-prisma/blob/master/awesome-prisma1.md)

## Contribute

Contributions welcome! Read the [contribution guidelines](https://github.com/catalinmiron/awesome-prisma/blob/master/contributing.md) first.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](http://creativecommons.org/publicdomain/zero/1.0)

To the extent possible under law, Catalin Miron has waived all copyright and
related or neighboring rights to this work.
