<div class="github-widget" data-repo="preactjs/awesome-preact"></div>
## Awesome Preact [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

[<img src="https://rawgit.com/ooade/awesome-preact/master/preact-logo.svg" align="right" width="100">](https://preactjs.com)

> A curated list of amazingly awesome things regarding [Preact](https://github.com/developit/preact) ecosystem :star2:

[Preact](https://github.com/developit/preact) is a fast 3kb React alternative with the same ES6 API. Components & Virtual DOM.

- [Real Apps](https://preactjs.com/about/we-are-using)

### Community
- [Slack](https://chat.preactjs.com/) (Discussion Forum)
- [Stack Overflow](https://stackoverflow.com/questions/tagged/preact)
- [Github](https://github.com/developit/preact)
- [Twitter](https://twitter.com/preactjs)

### Toolkits
- [Preact CLI](https://github.com/developit/preact-cli) - Build a Preact Progressive Web App in seconds.
- [Vite](https://github.com/vitejs/vite) - Fast native-ESM powered web dev build tool for Preact, Vue or React.
- [nwb](https://github.com/insin/nwb) - Quick Development with React, Inferno or Preact.
- [React App Rewire Preact](https://github.com/timarney/react-app-rewired) - Use Preact with create-react-app without ejecting.
- [Preact CLI PostCSS](https://github.com/SaraVieira/preact-cli-postcss) - It removes the default postcss config on Preact CLI, so you can use postcss.config.js.
- [Create Preact App](https://github.com/just-boris/create-preact-app) - Create Preact apps with no build configuration.
- [Storybook Preact](https://github.com/storybooks/storybook/tree/next/app/preact) - Storybook for Preact is a UI development environment for your Preact components.

### Boilerplates
- [Official Boilerplate](https://github.com/developit/preact-boilerplate) - Ready-to-rock Preact starter project, powered by Webpack.
- [Preact Simple Starter](https://github.com/ooade/PreactSimpleStarter) - PWA Simple Starter with Preact, Preact-mdl and Webpack2.
- [Preact Offline Starter](https://github.com/lukeed/preact-starter) - Webpack2 boilerplate for building SPA / PWA / offline front-end apps with Preact.
- [TypeScript Preact Starter](https://github.com/nickytonline/ts-preact-starter) - Barebones starter project for Preact with TypeScript.
- [TypeScript PWA Preact Starter](https://github.com/bmitchinson/preact-typescript-pwa-starter) - PWA Starter with TypeScript and SASS (131kb)
- [Electron TypeScript Preact Boilerplate](https://github.com/yoctopuce-examples/electron-typescript-preact-boilerplate) - Electron starter project with TypeScript and Preact support, powered by esbuild.
- [Preact Modern Startupper](https://github.com/kolodziejczakM/preact-modern-startupper) - PWA boilerplate with support for TypeScript, Goober, Unistore and Plop.
- [Preact Redux SSR Example](https://github.com/csbun/preact-redux-ssr-example) - Server-side Rendering with Redux Example.
- [Preact PWA](https://github.com/ezekielchentnik/preact-pwa) - PWA focused on raw performance, server side rendering, prerendering, redux, express, rollup.
- [Preact Chrome Extension](https://github.com/debdut/preact-chrome-extension) - A Full Feature Preact Chrome Extension Starter Kit.
- [Preact Web Extension](https://github.com/PiyushSuthar/preact-webext) - ⚡️ WebExtension Vite Starter Template with Preact.
- [Preact Neutralino TypeScript Starter](https://github.com/ernest-rudnicki/preact-neutralino-typescript-starter) - Starter project for building lightweight desktop applications with Preact and neutralino.js.
- [Simple Deno Starter](https://github.com/nesterow/minizavr) - Tiny starter template with Preact and Deno for building single page applications.

### Routing
- [Preact Router](https://github.com/developit/preact-router) - URL router for Preact.
- [Preact Route Async](https://github.com/mjanssen/preact-route-async) - A (440b gzip) route component that enables async loading of page-components.
- [Wouter](https://github.com/molefrog/wouter) - A tiny (1KB gzip) router for Preact/React with React Router-like API.

### Components
- [Preact Material Components](https://github.com/prateekbh/preact-material-components) - Preact wrapper for "Material Components for the web".
- [Preact Scroll Header](https://github.com/lukeed/preact-scroll-header) - A (800b gzip) header that will show/hide while scrolling for Preact.
- [Preact Progress](https://github.com/lukeed/preact-progress) - Simple and lightweight (~590 bytes gzip) progress bar component for Preact.
- [Preact Compat](https://github.com/preactjs/preact-compat) - Use any React library with Preact *([full example](https://github.com/developit/preact-compat-example))*.
- [Preact Render To String](https://github.com/preactjs/preact-render-to-string) - Universal rendering.
- [Preact Markup](https://github.com/developit/preact-markup) - Render HTML & Custom Elements as JSX & Components.
- [Preact Portal](https://github.com/developit/preact-portal) - Render Preact components into (a) SPACE.
- [Preact Richtextarea](https://github.com/developit/preact-richtextarea) - Simple HTML editor component.
- [Preact Token Input](https://github.com/developit/preact-token-input) - Text field that tokenizes input, for things like tags.
- [Preact Virtual List](https://github.com/developit/preact-virtual-list) - Easily render lists with millions of rows ([demo](https://jsfiddle.net/developit/qqan9pdo/)).
- [Preact Cycle](https://github.com/developit/preact-cycle) - Functional-reactive paradigm for Preact.
- [Preact Layout](https://download.github.io/preact-layout/) - Small and simple layout library.
- [Preact Socrates](https://github.com/matthewmueller/preact-socrates) - Preact plugin for [Socrates](http://github.com/matthewmueller/socrates).
- [Preact Flyd](https://github.com/xialvjun/preact-flyd) - Use [flyd](https://github.com/paldepind/flyd) FRP streams in Preact + JSX.
- [Preact I18nline](https://github.com/download/preact-i18nline) - Integrates the ecosystem around [i18n-js](https://github.com/everydayhero/i18n-js) with Preact via [i18nline](https://github.com/download/i18nline).
- [Preact MUI](https://github.com/luisvinicius167/preact-mui) - The MUI CSS Preact library.
- [Preact MDL](https://github.com/developit/preact-mdl) - Use [MDL](https://getmdl.io) as Preact components.
- [Preact Photon](https://github.com/developit/preact-photon) - Build beautiful desktop UI with [photon](http://photonkit.com).
- [Preact Classless Component](https://github.com/ld0rman/preact-classless-component) - Create preact components without the class keyword.
- [Preact Hyperscript](https://github.com/queckezz/preact-hyperscript) - Hyperscript-like syntax for creating elements.
- [Shallow Compare](https://github.com/tkh44/shallow-compare) - Simplified `shouldComponentUpdate` helper.
- [Preact Codemod](https://github.com/vutran/preact-codemod) - Transform your React code to Preact.
- [Preact Helmet](https://github.com/download/preact-helmet) - A document head manager for Preact.
- [Preact Delegate](https://github.com/NekR/preact-delegate) - Delegate DOM events.
- [Preact No SSR](https://github.com/gufsky/preact-no-ssr) - Skip Server Side Rendering of Components.
- [Preact Head](https://github.com/matthewmueller/preact-head) - Standalone, declarative \<Head /\> for Preact.
- [Preact Side Effect](https://github.com/ooade/preact-side-effect) - Create components whose nested prop changes map to a global side effect.
- [Preact Tiny Atom](https://github.com/KwanMan/preact-tiny-atom) - Preact Integration with [Tiny Atom](https://github.com/qubitproducts/tiny-atom).
- [Preact Level List](https://github.com/juliangruber/preact-level-list) - Live updating leveldb list component for Preact.
- [Preact Country Picker](https://github.com/bboydflo/flagstrap-preact) - Country picker based on bootstrap 3 made for Preact.
- [Preact Fluid](https://github.com/ajainvivek/preact-fluid) - A minimal UI kit for Preact.
- [Preact Feather Icons](https://github.com/ForsakenHarmony/preact-feather) - Feather icons for Preact.
- [Preact Animate On Change](https://github.com/Sobesednik/preact-animate-on-change) - Add CSS3 animation when properties change.
- [Preact Async Route](https://github.com/prateekbh/preact-async-route) - Async route component for preact-router.
- [MU Forms](https://github.com/mobiushorizons/mu-forms) - Dead simple form library for (P)React.
- [Pimg](https://github.com/ooade/pimg) - Progressive Image Component; Used for lazy loading images.
- [Preact Component Console](https://github.com/haensl/preact-component-console) - Console Emulator. Simulates typing via dynamic delays.
- [Preact Translate](https://github.com/DenysVuika/preact-translate) - Minimalistic translate (i18n) library for Preact.
- [Preact Dock](https://github.com/TimDaub/preact-touchable-dock) - Simple DnD and touch-enabled Dock for Preact apps.
- [Preact Particles](https://github.com/matteobruni/tsparticles#preact) - Lightweight component to easily add cool particles animations to websites.
- [Pant](https://github.com/webyom/pant) - Mobile UI Components built on Preact *([docs and demos](https://webyom.github.io/pant))*. Ported from awesome Vue components of [Vant](https://github.com/youzan/vant).
- [Preact Transitioning](https://github.com/fakundo/preact-transitioning) - Exposes Preact components for easily implementing basic CSS animations and transitions.
- [Preact Nominal Allocator](https://github.com/TimDaub/preact-nominal-allocator) - A numerical input element that can also manipulated with two buttons (-/+).
- [Tailored Components](https://github.com/nesterow/tailored) - Unstyled components and hooks for Preact & Deno.
- [Plotery](https://shelacek.bitbucket.io/plotery) - Fast and lightweight charting library.
- [Formica](https://shelacek.bitbucket.io/formica) - Simple declarative forms for Preact.

### Libraries
- [Redux Zero](https://github.com/concretesolutions/redux-zero) - A lightweight state container based on Redux with a single store and no reducers.
- [Unistore](https://github.com/developit/unistore) - 350b / 650b state container with component actions for Preact & React.
- [FPreact](https://github.com/UnwrittenFun/fpreact) - Provides an alternative api for creating preact components, heavily inspired by elm.
- [ProppyJS - A tiny library for functional props composition](https://proppyjs.com)
- [ClearX](https://github.com/Autodesk/clearx) - Fast & Effortless state management for React, Preact and Inferno with zero learning curve.
- [Preact-urql](https://github.com/FormidableLabs/urql/tree/master/packages/preact-urql) - Use [urql](https://github.com/FormidableLabs/urql) with Preact core + hooks.
- [hooked-head](https://github.com/JoviDeCroock/hooked-head) - Hooks to manipulate the `<head>` section of the DOM. This has a subpackage with core preact support (using `preact/hooks`).
- [Teaful](https://github.com/teafuljs/teaful) - Tiny (800B), easy and powerful (P)React state management.
- [Nano Stores](https://github.com/nanostores/nanostores) - A tiny (199 bytes) state manager with many atomic tree-shakable stores.
- [Modular Forms](https://github.com/fabian-hiller/modular-forms) - Modular, type-safe and signal based form library for Preact.
- [exome](https://github.com/Marcisbee/exome) - Simple proxy based state manager for deeply nested states.
- [Fastro](https://fastro.deno.dev) - Fast & Modular SSR Web Framework for Deno, TypeScript, Preact & Tailwind.


### Testing Utils
- [Preact JSX Chai](https://github.com/developit/preact-jsx-chai) - JSX assertion testing _(no DOM, right in Node)_.
- [Preact Render Spy](https://github.com/mzgoddard/preact-render-spy) - Render Preact components with access to the produced virtual dom for testing.
- [Preact Test Utils](https://github.com/windyGex/preact-test-utils) - Mock react-test-utils enzyme in preact.
- [Preact Testing Library](https://github.com/antoaravinth/preact-testing-library) - Simple and complete Preact DOM testing utilities that encourage good testing practices.
- [Preact Island](https://github.com/mwood23/preact-island) - Render your Preact component as a widget on any web page with ease.

### Articles
- [WTF is JSX](https://jasonformat.com/wtf-is-jsx/)
- [The Inner Workings of Virtual DOM](https://medium.com/@rajaraodv/the-inner-workings-of-virtual-dom-666ee7ad47cf)
- [Using Preact Instead of React](https://medium.com/@rajaraodv/using-preact-instead-of-react-70f40f53107c)
- [Preact Internals #1: The Easy Parts](https://medium.com/@asolove/preact-internals-1-the-easy-parts-3a081fa36205#.twnc3doig)
- [Preact Internals #2: The Component Model](https://medium.com/@asolove/preact-internals-2-the-component-model-36a05e32957b#.8zyec2y9v)
- [Building a Small PWA with Preact and Firebase](https://dandenney.com/posts/front-end-dev/building-a-small-pwa-with-preact-and-firebase)
- [Authentication with Auth0](https://auth0.com/blog/preact-authentication-tutorial)

### Example Apps
- [Preact HN](https://github.com/kristoferbaxter/preact-hn) - Demonstration of Preact used to build Hacker News as a PWA.
- [TodoMVC](https://github.com/developit/preact-todomvc) - TodoMVC done in Preact. Under 6kb and fast.
- [Colors App](https://github.com/lukeed/colors-app) - PWA for copying values from popular color palettes. Supports HEX, RGB, and HSL formats.
- [Tracks](https://github.com/jordic/tracks_preact/) - PWA for tracking things in general. Gdrive Sync.
- [Hueify](https://github.com/kvartborg/hueify) - Simple controller for your Philips Hue lights.
- [Golazon](https://github.com/sobstel/golazon) - Football data mnmlist way.
- [Shopping List](https://github.com/ibm-watson-data-lab/shopping-list-preact-pouchdb) - Progressive Web App Built Using Preact and PouchDB.
- [Code and Comment](https://github.com/code-and-comment/code-and-comment) - The application to add the comments to a file in Github ([demo](https://code-and-comment.github.io/code-and-comment/)).
- [Play.cash](https://play.cash) :notes: _([GitHub Project](https://github.com/feross/play.cash))_
- [Songsterr](https://www.songsterr.com) 🎼 Using Preact X in production since 10.0 alpha
- [BitMidi](https://bitmidi.com/) 🎹 Wayback machine for free MIDI files _([GitHub Project](https://github.com/feross/bitmidi.com))_
- [Ultimate Guitar](https://www.ultimate-guitar.com) 🎸speed boosted by Preact.
- [ESBench](http://esbench.com) is built using Preact.
- [BigWebQuiz](https://bigwebquiz.com) _([GitHub Project](https://github.com/jakearchibald/big-web-quiz))_
- [Nectarine.rocks](http://nectarine.rocks) _([GitHub Project](https://github.com/developit/nectarine))_ :peach:
- [OSS.Ninja](https://oss.ninja) _([GitHub Project](https://github.com/developit/oss.ninja))_
- [GuriVR](https://gurivr.com) _([GitHub Project](https://github.com/opennewslabs/guri-vr))_
- [Offline Gallery](https://use-the-platform.com/offline-gallery/) _([GitHub Project](https://github.com/vaneenige/offline-gallery/))_ :balloon:
- [Periodic Weather](https://use-the-platform.com/periodic-weather/) _([GitHub Project](https://github.com/vaneenige/periodic-weather/))_ :sunny:
- [Rugby News Board](http://nbrugby.com) _[(GitHub Project)](https://github.com/rugby-board/rugby-board-node)_
- [Preact Gallery](https://preact.gallery/) an 8KB photo gallery PWA built using Preact.
- [Rainbow Explorer](https://use-the-platform.com/rainbow-explorer/) Preact app to translate real life color to digital color _([Github project](https://github.com/vaneenige/rainbow-explorer))_.
- [YASCC](https://carlosqsilva.github.io/YASCC/#/) Yet Another SoundCloud Client _([Github project](https://github.com/carlosqsilva/YASCC))_.
- [Journalize](https://preact-journal.herokuapp.com/) 14k offline-capable journaling PWA using preact. _([Github project](https://github.com/jpodwys/preact-journal))_.
- [Proxx](https://proxx.app) A game of proximity by GoogleChromeLabs using preact. _([Github project](https://github.com/GoogleChromeLabs/proxx))_.
- [Web Maker](https://webmaker.app) An offline and blazing fast frontend playground built using Preact. _([Github project](https://github.com/chinchang/web-maker))_.
- [Intergram](https://www.intergram.xyz) A live chat widget linked to your Telegram messenger built using Preact. _([Github project](https://github.com/idoco/intergram))_.
- [Preact App in ES6 without Babel or JSX](https://vanilla-preact.surge.sh) _([GitHub Project](https://github.com/safdarjamal/vanilla-preact/))_.
- [GHFresh](https://code2k.github.io/ghfresh/) Monitor GitHub repository releases – Prerendering with Preact. Built with Preact Compat, TypeScript, Material-UI and Redux Toolkit. _([GitHub Project](https://github.com/code2k/ghfresh))_.
- [Passwords Fountain](https://passwords-fountain.com/) - modern & performant password manager interface which works everywhere _([Github project](https://github.com/kolodziejczakM/passwords-fountain))_.
- [macOS Web](https://macos-preact.now.sh) - macOS Big Sur Desktop experience for Web, built with Preact and Vite _([Github project](https://github.com/PuruVJ/macos-preact))_.
- [Cinemate](https://cinemate.me) - Movie Recommender System built with Preact and TypeScript. Backend written in Rust.
- [Windows 11 Web](https://win11.vercel.app) - Awe-amazing Windows 11 clone for the web! ⚡ _([Github project](https://github.com/PiyushSuthar/Windows-11-Web))_.
- [Idea Keeper](https://miftikcz.github.io/idea-keeper-2) :brain: Highly extensible and minimalistic idea keeping app _([GitHub Project](https://github.com/MiftikCZ/idea-keeper-2))_.
- [Trellith](https://trellith.sakih.net/) - Tiny Trello Clone PWA ([GitHub Project](https://github.com/sakihet/trellith)).
- [Gladys Assistant](https://gladysassistant.com/) - A privacy-first, open-source home assistant _([GitHub Project](https://github.com/GladysAssistant/Gladys))_.

### Related Libraries
- [React](https://github.com/facebook/react) - A declarative, efficient, and flexible JavaScript library for building user interfaces.
- [Inferno](https://github.com/infernojs/inferno) - An extremely fast, React-like JavaScript library for building modern user interfaces.
- [Rax](https://github.com/alibaba/rax) - A universal React-compatible render engine.

### Tips
Contribute some ;)

---
### Contribution
Your contributions and suggestions are welcome anytime. Build great stuffs with Preact, share with us ;) <br/>
Make sure you follow the [guidelines](https://github.com/preactjs/awesome-preact/blob/master//contributing.md). Thank you!

---
### License
[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](http://creativecommons.org/publicdomain/zero/1.0/)
