<div class="github-widget" data-repo="janikvonrotz/awesome-powershell"></div>
## Awesome PowerShell [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Quality Assurance](https://github.com/janikvonrotz/awesome-powershell/workflows/Quality%20Assurance/badge.svg?event=schedule)](https://github.com/janikvonrotz/awesome-powershell/actions?query=workflow%3A%22Quality+Assurance%22)

[<img src="https://raw.githubusercontent.com/PowerShell/PowerShell/raw/master/assets/Powershell_256.png" align="right" width="80">](https://msdn.microsoft.com/en-us/powershell/)

令人愉快的精选清单 [PowerShell](https://en.wikipedia.org/wiki/PowerShell) 包和资源.

PowerShell 是一种跨平台（Windows、Linux 和 macOS）自动化和配置工具，针对处理结构化数据（例如 JSON、CSV、XML 等）、REST API 和对象模型进行了优化.
它包括命令行 shell 和关联的脚本语言.



## API Wrapper

* [HipChatAdmin](https://github.com/cofonseca/HipChatAdmin) - 通过 HipChat API 与 Atlassian HipChat 简单集成的模块.
* [PSGitHub](https://github.com/pcgeek86/PSGitHub) - 模块包含通过其 REST API 管理 GitHub 的命令.
* [Posh-GitHub](https://github.com/Iristyle/Posh-GitHub) - 公开 GitHub API 的 Cmdlet.
* [Posh-Gist](https://github.com/dfinke/Posh-Gist) - 用于与 GitHub Gist 交互的 Cmdlet.
* [PSGist](https://github.com/dotps1/PSGist) - 与 GitHub Gists 一起工作的模块.
* [PSAppVeyor](https://github.com/dotps1/PSAppVeyor) - 与 AppVeyor REST API 交互的模块.
* [PSSlack](https://github.com/RamblingCookieMonster/PSSlack) - 用于简单 Slack 集成的模块.
* [ConfluencePS](https://atlassianps.org/module/ConfluencePS/) - 用于在 powershell 中与 Atlassian 的 Confluence 交互的模块（通过使用 API）.
* [JiraPS](https://atlassianps.org/module/JiraPS/) - 用于在 powershell 中与 Atlassian 的 Jira 交互的模块（通过使用 API）.
* [PSTelegramAPI](https://github.com/mkellerman/PSTelegramAPI) - 电报 API 模块
* [PSTeams](https://github.com/EvotecIT/PSTeams) - 用于将格式化消息发送到 Microsoft Teams 频道的模块.
* [PSURLScanio](https://github.com/sysgoblin/PSURLScanio) - 一个模块 [urlscan.io](https://urlscan.io/) 这是一种扫描和分析网站的服务.

## Blogs

* [Windows PowerShell Blog](https://devblogs.microsoft.com/powershell/) - 官方 PowerShell 团队博客.
* [Learn PowerShell | Achieve More](http://learn-powershell.net/) - 为脚本专家主持的 Boe Prox 的个人博客.
* [PowerShellMagazine](http://www.powershellmagazine.com/) - 很棒的杂志.
* [PowerShellExplained](https://powershellexplained.com) - Kevin Marquette 的个人博客
* [Doug Finke](https://dfinke.github.io/#blog) - 的作者 [PowerShell for Developers](http://shop.oreilly.com/product/0636920024491.do).
* [Mike F. Robbins](http://mikefrobbins.com/)  - 微软 MVP.  SAPIEN 技术 MVP.  Windows PowerShell TFM 第 4 版的合著者.
* [Clear-Script](https://vexx32.github.io/) - Joel (Sallow) Francis 的个人博客.

## Books

* [Exploring PowerShell Automation](https://www.manning.com/books/exploring-powershell-automation) - 一个免费的电子书样本，让您大致了解如何管理您的环境.
* [PowerShell in Depth](https://www.manning.com/books/powershell-in-depth)  - 管理员的首选参考. 每一种主要的 shell 技术、技术和策略都得到了解释和演示，为管理员在 shell 中所做的几乎所有事情提供了全面的参考.
* [Windows PowerShell in Action, Third Edition](https://www.manning.com/books/windows-powershell-in-action-third-edition) - 最新修订的综合参考指南.
* [Learn Windows PowerShell in a Month of Lunches, Third Edition](https://www.manning.com/books/learn-windows-powershell-in-a-month-of-lunches-third-edition)  - 专为忙碌的 IT 专业人员设计的创新教程. 只需每天留出一小时 - 午餐时间再合适不过了 - 一个月，你将以超乎想象的速度自动执行 Windows 任务.
* [Learn PowerShell in a Month of Lunches, Linux and macOS Edition](https://www.manning.com/books/learn-powershell-in-a-month-of-lunches-linux-and-macos-edition) - 以任务为中心的教程，用于使用 Microsoft PowerShell 管理 Linux 和 macOS 系统.
* [Learn PowerShell Scripting in a Month of Lunches](https://www.manning.com/books/learn-powershell-scripting-in-a-month-of-lunches) - 开发、测试和部署脚本的过程以及工具制作的指南.
* [The Monad Manifesto, Annotated - Jeffrey Snover](https://leanpub.com/s/4W-ob-YDw2LE2aSMyosCtA.pdf) - 语言背后的设计和理论来自其创造者.
* [Windows PowerShell Networking Guide](https://leanpub.com/windowspowershellnetworkingguide/read) - Windows 网络的特定语言指南.
* [Why PowerShell? - Warren Frame & Don Jones](https://leanpub.com/s/aQDRwmoOi940mX_EB6N7Yg.pdf) - 语言的用例.
* [The Big Book of PowerShell Gotchas - Don Jones](https://leanpub.com/s/lDl9ZV0QW7zaE4BpitXVig.pdf) - 避免常见陷阱的优秀指南.
* [The Big Book of PowerShell Error Handling - Dave Wyatt](https://leanpub.com/s/znHIFrvBAYRST5nFBiQU5g.pdf) - 错误处理技术的重要参考.
* [Secrets of PowerShell Remoting](https://leanpub.com/s/DQLESXQ69TlVFQ9ogjrFLw.pdf)  - 关于所有远程处理. 工作流、扇出等
* [PowerShell Notes for Professionals](https://goalkicker.com/PowerShellBook/PowerShellNotesForProfessionals.pdf) - 笔记和片段的汇编.
* [PowerShell for SysAdmins: Workflow Automation Made Easy](https://nostarch.com/powershellsysadmins) - 了解如何管理和自动化您的桌面和服务器环境.
* [Practical Automation with PowerShell](https://www.manning.com/books/practical-automation-with-powershell) - 了解如何使用 PowerShell 构建、组织和共享有用的自动化.
* [Learn dbatools in a Month of Lunches](https://www.manning.com/books/learn-dbatools-in-a-month-of-lunches) - 了解如何使用 PowerShell 和出色的 dbatools 模块自动化 SQL Server.
* [Tiny PowerShell Projects](https://www.manning.com/books/tiny-powershell-projects) - 使用 PowerShell 进行系统管理的实践教程.

## Build Tools

* [psake](https://github.com/psake/psake) - 构建受 rake（又名 Ruby 中的 make）和 bake（又名 Boo 中的 make）启发的自动化工具.
* [Invoke-Build](https://github.com/nightroman/Invoke-Build) - 构建和测试受 psake 启发的自动化工具.
* [PSDeploy](https://github.com/RamblingCookieMonster/PSDeploy) - 为简化多种类型的部署而构建的模块.
* [BuildHelpers](https://github.com/RamblingCookieMonster/BuildHelpers) - CI/CD 场景的各种辅助函数.
* [YDeliver](https://github.com/manojlds/YDeliver) - 构建和部署针对.NET 项目的框架.

## Code and Package Repositories

* [GitHub](https://github.com/search?l=powershell&q=stars%3A%3E1&s=stars&type=Repositories)  - 寻找开源 PowerShell 项目？ 大概就在这里吧.
* [PowerShell Gallery](https://www.powershellgallery.com/) - PowerShellGet 使用的官方 PowerShell 包存储库.
* [PowerShell Test Gallery](https://www.poshtestgallery.com/)  - PowerShell Gallery 的测试版本. 在开发新模块时很有用.

## Commandline Productivity

* [Dotenv](https://github.com/insomnimus/ps-dotenv) - 通过 .env 文件提供目录特定环境，类似于 direnv.
* [posh-git](https://github.com/dahlbyk/posh-git) - 提供 Git/PowerShell 集成的 PowerShell 脚本集.
* [PSReadLine](https://github.com/lzybkr/PSReadLine)  - Bash 启发了 PowerShell 的 readline 实现. 在会话之间保留历史记录，添加反向历史搜索并使命令行体验总体上更好.
* [TabExpansionPlusPlus](https://github.com/lzybkr/TabExpansionPlusPlus) - PowerShell 模块使自定义制表符补全更容易，并添加自定义参数补全库.
* [Jump-Location](https://github.com/tkellogg/Jump-Location) - PowerShell `cd` 读懂您的想法. [Autojump](https://github.com/wting/autojump)  PowerShell 的实现.  **`未维护`**
* [Zlocation](https://github.com/vors/ZLocation) * [z.sh](https://github.com/rupa/z)  PowerShell 的实现. 类似于跳转位置.
* [thefuck](https://github.com/nvbn/thefuck) - 纠正您之前的控制台命令的宏伟应用程序（通过键入 `fuck`）.
* [PSFzf](https://github.com/kelleyma49/PSFzf) - 包装的 PowerShell 模块 [fzf](https://github.com/junegunn/fzf)，命令行的模糊文件查找器.
* [pslinq](https://github.com/manojlds/pslinq) - 用于 PowerShell 的 LINQ (LINQ2Objects).
* [posh-with](https://github.com/JanJoris/posh-with) - 使用单个工具为连续工作流程添加命令前缀.
* [poco](https://gist.github.com/yumura/8df37c22ae1b7942dec7)* [peco](https://github.com/peco/peco) 执行. 交互式过滤工具.
* [PSDirTag](https://github.com/wtjones/PSDirTag)  - DirTag 是在 PowerShell 提示符中显示为变量的相对路径，会随着您的导航而更新. 导航文件夹结构时保存击键.
* [PSUtil](https://github.com/PowershellFrameworkCollective/PSUtil)  - 旨在让用户的控制台生活更加方便. 它包括快捷方式、别名、键绑定和便利功能，旨在提高效率和减少打字.
* [Microsoft.PowerShell.UnixCompleters](https://github.com/PowerShell/Modules/tree/master/Modules/Microsoft.PowerShell.UnixCompleters)  - 获取本机 Unix 实用程序的参数完成. 需要 zsh 或 bash.
* [PSDepend](https://github.com/RamblingCookieMonster/PSDepend/) - PowerShell 依赖处理程序
* [PSScriptTools](https://github.com/jdhitsolutions/PSScriptTools) - 一组 PowerShell 函数，您可以使用这些函数来增强您自己的函数和脚本或促进在控制台中的工作.
* [zoxide](https://github.com/ajeetdsouza/zoxide)  - 一种更好的浏览文件系统的方法. 用 Rust 编写，跨 shell，比其他自动跳转器快得多.

## Communities

* [PowerShell.org](http://powershell.org/) - 论坛、峰会、社区博客文章等.
* [/r/PowerShell](http://www.reddit.com/r/powershell) - Reddit PowerShell 社区.
* [Slack PowerShell team](https://poshcode.org/slack) - Large chat room dedicated to PowerShell. Bridged with `#PowerShell` on irc.freenode.net.
* [Research Triangle PowerShell User Group](https://www.meetup.com/Research-Triangle-PowerShell-Users-Group/)  - 非常活跃的 PowerShell 和自动化用户组. 在第一个和第三个星期三开会. 欢迎所有技能水平.

## Data

* [hjson-powershell](https://github.com/TomasBouda/hjson-powershell) - Simple powershell module for conversion between [HJSON](https://hjson.github.io/) 和 JSON.
* [ImportExcel](https://github.com/dfinke/ImportExcel) - 无需 Excel 即可导入/导出 Excel 电子表格的模块.
* [powershell-yaml](https://github.com/cloudbase/powershell-yaml) - 用于 YAML 格式操作的 PowerShell CmdLets.
* [PSWriteHTML](https://github.com/EvotecIT/PSWriteHTML) - PSWriteHTML 是一个 PowerShell 模块，可让您轻松创建 HTML.
* [PSWritePDF](https://github.com/EvotecIT/PSWritePDF) - 在 Windows / Linux 和 MacOS 上创建、编辑、拆分、合并 PDF 文件的模块.
* [PSWriteWord](https://github.com/EvotecIT/PSWriteWord) - 无需安装 Microsoft Word 即可创建 Microsoft Word 文档的模块.

## Documentation Helper

* [platyPS](https://github.com/PowerShell/platyPS) - 在 Markdown 中编写 PowerShell 外部帮助.
* [Invoke-CreateModuleHelpFile](https://github.com/gravejester/Invoke-CreateModuleHelpFile) - 用于为模块及其所有命令创建 HTML 帮助文件的 PowerShell 函数.
* [PScribo](https://github.com/iainbrighton/PScribo) - PowerShell 文档框架，可以基于基于 PowerShell 的 DSL（领域特定语言）创建 HTML、Word、文本文件.

## Editors and IDEs

* [PowerShell Studio](https://www.sapien.com/software/powershell_studio) - 强大的 PowerShell IDE，带有模块、帮助和用户界面开发工具、高 DPI 支持和定期更新.
* [PowerShell for Visual Studio Code](https://marketplace.visualstudio.com/items?itemName=ms-vscode.PowerShell) - 提供智能感知、代码导航、脚本分析、脚本调试等功能 [Visual Studio Code](https://code.visualstudio.com) 编辑.
* [PoshTools for Visual Studio](https://ironmansoftware.com/powershell-tools-for-visual-studio/) - 为 Visual Studio 的 PowerShell 提供 IntelliSense、脚本调试和 Pester 测试支持.
* [PowerShell ISE](https://docs.microsoft.com/en-us/powershell/scripting/components/ise/introducing-the-windows-powershell-ise) - Microsoft Windows 附带的官方 PowerShell 开发环境.
* [ISE Steroids](http://www.powertheshell.com/isesteroids/) - PowerShell ISE 的附加组件，提供一组丰富的附加功能来完善 ISE 开发体验.
* [PowerShell Plus](https://www.idera.com/productssolutions/freetools/powershellplus) - 多合一 IDE.
* [SublimeText package](https://github.com/SublimeText/PowerShell) - 对 Sublime Text 的 PowerShell 语言支持.
* [Atom package](https://github.com/jugglingnutcase/language-powershell) - 对 Atom 的 PowerShell 语言支持.

## Frameworks

* [Carbon](http://get-carbon.org/) - 用于自动配置 Windows 计算机的 DevOps.
* [PowerShell PowerUp](https://github.com/janikvonrotz/PowerShell-PowerUp) - 强大的服务器管理框架.
* [PSCX](https://github.com/Pscx/Pscx) - PowerShell 社区扩展 - 有用的附加 cmdlet 集.
* [PSFramework](https://github.com/PowershellFrameworkCollective/psframework) - 轻松将配置、日志记录等添加到您自己的 PowerShell 模块中.
* [Kansa](https://github.com/davehull/Kansa) - 事件响应框架.

## Interactive Learning

* [PSKoans](https://github.com/vexx32/PSKoans) - 通过 Pester 单元测试学习 PowerShell 语言的一种简单、有趣和交互式的方式.
* [Jupyter-PowerShell](https://github.com/Jaykul/Jupyter-PowerShell) - PowerShell 的 Jupyter 内核.

## Logging

* [PoShLog](https://github.com/PoShLog/PoShLog) - 跨平台、可扩展的日志记录模块建立在 [Serilog](https://serilog.net).

## Module Development Templates

* [Plaster](https://github.com/PowerShell/Plaster) - Plaster 是一个基于模板的文件和项目生成器，用 PowerShell 编写.
* [PSModuleDevelopment](https://github.com/PowershellFrameworkCollective/PSModuleDevelopment) - 2分钟上手使用模块模板，入门门槛低，随性方便.
* [Catesta](https://github.com/techthoughts2/Catesta)  - Catesta 是一个 PowerShell 模块项目生成器. 它使用模板为各种 CI/CD 平台快速构建测试和构建集成.

## Package Managers

* [PowerShellGet](https://github.com/powershell/powershellget)  - PowerShellGet 是 PowerShell 的包管理器. 套餐可在 [PowerShellGallery](https://www.PowerShellGallery.com).
* [Chocolatey](https://chocolatey.org/)  - Windows 的包管理器. 在 Windows 上管理软件的明智方式.
* [GitLab](https://github.com/akamac/GitLabProvider) - 使用 GitLab 服务器作为包提供者.
* [Scoop](https://scoop.sh) - 适用于 Windows 的命令行安装程序.
* [PowerShell App Deployment Toolkit](https://psappdeploytoolkit.com/) - 提供一组功能来执行常见的应用程序部署任务并在部署期间与用户交互.

## Parallel Processing

* [PoshRSJob](https://github.com/proxb/PoshRSJob) - 提供 PSJobs 的替代方案，具有更高的性能和更少的开销以在后台运行命令.
* [Invoke-Parallel](https://github.com/RamblingCookieMonster/Invoke-Parallel) - 此函数将接收脚本或脚本块，并针对指定对象并行运行.
* [PSThreadJob](https://github.com/PaulHigin/PSThreadJob) - 基于线程而不是进程运行并发作业的模块.

## Podcasts

* [PowerScripting](https://powershell.org/category/podcast/) - 由 Jon Walz 和 Hal Rottenberg 主持的每周节目.
* [The PowerShell News Podcast](https://powershellnews.podbean.com/) - 此播客是有关 PowerShell 的最新消息.

## Security

* [File System Security](https://gallery.technet.microsoft.com/scriptcenter/1abd77a5-9c0b-4a2b-acef-90dbb2b84e85) - 允许更轻松地管理文件和文件夹的权限.
* [PowerShellArsenal](https://github.com/mattifestation/PowerShellArsenal) - 用于帮助逆向工程的模块.
* [PowerTools](https://github.com/Veil-Framework/PowerTools) - 以进攻行动为重点的项目集合.
* [PowerForensics](https://github.com/Invoke-IR/PowerForensics) - 适用于 Windows 的流行实时磁盘取证平台.
* [PowerSploit](https://github.com/PowerShellMafia/PowerSploit) - 开发后框架.
* [PowerShellEmpire](https://github.com/PowerShellEmpire/Empire) - 后期开发代理.
* [PSReflect](https://github.com/mattifestation/PSReflect)  - 在 PowerShell 中轻松定义内存中的枚举、结构和 Win32 函数. 对攻击很有用， [example](https://github.com/FuzzySecurity/PowerShell-Suite/tree/master/Bypass-UAC).
* [BloodHound](https://github.com/BloodHoundAD/BloodHound) - 轻松识别原本无法快速识别的高度复杂的攻击路径.
* [Nishang](https://github.com/samratashok/nishang) - 为红队、渗透测试和攻击性安全启用脚本.
* [Harness](https://github.com/Rich5/Harness) - 交互式远程 PowerShell 负载.
* [Invoke-Obfuscation](https://github.com/danielbohannon/Invoke-Obfuscation) - PowerShell 混淆器.
* [p0wnedShell](https://github.com/Cn33liz/p0wnedShell) - PowerShell Runspace 后开发工具包.
* [PESecurity](https://github.com/NetSPI/PESecurity) - 用于检查 Windows 二进制文件 (EXE/DLL) 是否已使用 ASLR、DEP、SafeSEH、StrongNaming 和 Authenticode 编译的模块.
* [Powershellery](https://github.com/nullbind/Powershellery) - 用于一般 hackery 的 Powershell 脚本.
* [PowerUpSQL](https://github.com/NetSPI/PowerUpSQL) - 攻击 SQL Server 的工具包.

## SharePoint

* [AutoSPInstaller](https://autospinstaller.com/) - 自动化 SharePoint 2010-2019 安装脚本.
* [Client-side SharePoint](https://sharepointpowershell.codeplex.com/) - 适用于 SharePoint 2010、2013 和在线的 API.
* [SPReplicator](https://github.com/potatoqualitee/SPReplicator) - SPReplicator 有助于将 SharePoint 列表数据复制到 CSV、SQL Server、SharePoint 本身等或从中复制.
* [SharePoint2019Commands](https://github.com/sassdawe/SharePoint2019Commands) - PowerShell 模块可帮助您自动加载所有 SharePoint 2019 cmdlet.

## SQL Server

* [dbatools](https://dbachecks.io) - 帮助 SQL Server Pros 通过实例迁移等提高工作效率.
* [SimplySql](https://github.com/mithrandyr/SimplySql)  - SimplySql 是一个模块，它提供了一组直观的 cmdlet，用于与抽象供应商细节的数据库进行对话. 基本模式是连接数据库，执行一条或多条sql.

## Testing

* [Pester](https://github.com/pester/Pester) - PowerShell BDD 风格的测试框架.
* [Format-Pester](https://github.com/equelin/format-pester) - 用于记录 Pester 结果的 PowerShell 模块 - 将 Pester 结果导出到 HTML、Word、文本文件，使用 [PScribo](https://github.com/iainbrighton/PScribo).
* [Selenium](https://github.com/adamdriscoll/selenium-powershell) - 用于运行 Selenium WebDriver 的 PowerShell 模块.
* [PSScriptAnalyzer](https://github.com/PowerShell/PSScriptAnalyzer) - PSScriptAnalyzer 通过对正在分析的脚本应用一组内置或自定义规则，提供脚本分析并检查脚本中潜在的代码缺陷.

## Themes

* [Oh-My-Posh](https://github.com/jandedobbeleer/oh-my-posh) - 可以通过一个命令启用大量美丽的主题（包括许多很棒的电力线主题）.
* [PoshColor](https://github.com/JustABearOz/PoshColor) - 支持自定义主题的常用命令的颜色输出.
* [Powerline](https://github.com/Jaykul/PowerLine) - 用于更丰富的输出和提示的 PowerShell 类.
* [Starship](https://github.com/starship/starship) - 适用于任何 shell 的最小、极快且可高度自定义的提示符.

## UI

* [AnyBox](https://github.com/dm3ll3n/AnyBox) - 旨在通过易于定制的 WPF 窗口促进脚本输入/输出.
* [BurntToast](https://github.com/Windos/BurntToast) - 用于在 Microsoft Windows 10 上创建和显示 Toast 通知的模块.
* [Graphical](https://github.com/PrateekKumarSingh/graphical) - 绘制彩色控制台 2D 图形（散点图、条形图、线图）的模块.
* [GraphicalTools](https://github.com/PowerShell/GraphicalTools)  - 混合了 PowerShell 和 GUI 的模块！  - 建立在 Avalonia 和 gui.cs 之上.
* [PS-Menu](https://github.com/chrisseroka/ps-menu) - 呈现交互式控制台菜单的简单模块.
* [PSWriteColor](https://github.com/EvotecIT/PSWriteColor) - Write-Color 是 Write-Host 的包装器，允许您创建漂亮的脚本，并带有彩色输出.
* [Terminal-Icons](https://github.com/devblackops/Terminal-Icons) - 在终端中显示文件和文件夹图标的模块.
* [psInlineProgress](https://github.com/gravejester/psInlineProgress) - 在 PowerShell 中编写内联进度条.

## Videos

* [PowerShell Unplugged with Jeffrey Snover and Don Jones Ignite 2017](https://www.youtube.com/watch?v=D15vh-ryJGk)  - PowerShell 的发明者谈论“最新最酷的 PowerShell 功能可帮助您自动化和管理混合云”. 专注于 PowerShell 社区.
* [Getting Started With PowerShell 3.0 Jump Start](https://mva.microsoft.com/en-US/training-courses/getting-started-with-powershell-30-jump-start-8276) - Jump starts 系列适用于以前没有 PowerShell 经验并希望快速学习的 IT 专业人员.
* [Advanced Tools & Scripting with PowerShell 3.0](https://channel9.msdn.com/Series/advpowershell3) - IT 专业人员，参加这个高级 PowerShell 课程，了解如何将您的实时管理和自动化脚本变成有用的可重用工具和 cmdlet.
* [What's New in PowerShell v5](https://mva.microsoft.com/en-US/training-courses/whats-new-in-powershell-v5-16434) - 通过对 PowerShell 5.0 版中一些激动人心的新功能的描述.
* [PowerShell Open Source Project](https://channel9.msdn.com/series/PowerShell-Open-Source-Project) - 视频集合彻底展示了​​ PowerShell 开源项目如何在 Linux 上运行.
* [PowerShell on Linux and Open Source](https://channel9.msdn.com/Blogs/hybrid-it-management/PowerShell-on-Linux-and-Open-Source) - 简要介绍PowerShell 开源项目及其在Linux 上的运行方式.
* [PowerShell](https://channel9.msdn.com/Shows/MsftPowerShell)  - 该节目将包括讨论 PowerShell 自动化平台、所需状态配置 (DSC)、基础架构即代码和相关概念的视频！！ 这些视频由 Windows PowerShell 的 Microsoft MVP Trevor Sullivan 创建.
* [Learn Windows PowerShell in a Month of Lunches - Don Jones](https://www.youtube.com/watch?v=6CRTahGYnws&list=PL6D474E721138865A) - 同名书籍的视频伴侣.
* [Best Practices for Script Design - Don Jones](https://www.youtube.com/watch?v=Lni4KjGMgu4) - Don Jones 讨论脚本设计原则和最佳实践.
* [PowerShell Toolmaking (1 of 3) - Don Jones](https://www.youtube.com/watch?v=KprrLkjPq_c) - 工具制造（3 个中的 1 个）- Don Jones.
* [PowerShell Toolmaking (2 of 3) - Don Jones](https://www.youtube.com/watch?v=U849a17G7Ro) - 工具制作（3 个中的 2 个）- Don Jones.
* [PowerShell Toolmaking (3 of 3) - Don Jones](https://www.youtube.com/watch?v=GXdmjCPYYNM) - 工具制造（3 个中的 3 个）- Don Jones.
* [Sophisticated Techniques of Plain Text Parsing - Tobias Weltner](https://www.youtube.com/watch?v=Hkzd8spCfCU) - 文本解析的重要参考.
* [Monad Manifesto Revisited - Jeffrey Snover](https://www.youtube.com/watch?v=j0EX5R2nnRI) - Jeffrey Snover 回顾了该语言的起源及其发展方向.
* [AD Forensics with PowerShell - Ashley McGlone](https://www.youtube.com/watch?v=VrDjiVbZZE8) - 许多 AD 相关的脚本和分析技术.
* [Windows PowerShell What's New in V2 - SAPIEN](https://www.youtube.com/watch?v=85Yrs5ezxHE&list=PL6ue9e1DXqDv74YTX91gYonfFsweNmrDK) - Old but gold. Most of this is still very relevant.
* [All Things Microsoft PowerShell](https://www.youtube.com/watch?v=IHrGresKu2w&list=PLCGGtLsUjhm2k22nFHHdupAK0hSNZVfXi) - 另一个通用语言参考.
* [The anatomy of the Get-Help command in PowerShell](https://www.youtube.com/watch?v=cEswNaXxJ9g) - 软件工程师 Tyler Leonhardt 介绍了 Powershell 帮助系统.

## Webserver

* [Flancy](https://github.com/toenuff/flancy) - Windows PowerShell 的 Web 微框架.
* [Pode](https://github.com/Badgerati/Pode) - Pode 是一个跨平台 PowerShell 框架，用于创建 Web 服务器以托管 REST API、网站和 TCP/SMTP 服务器.
* [Polaris](https://github.com/PowerShell/Polaris) - 适用于 PowerShell 的跨平台、极简主义 Web 框架.
* [WebCommander](https://github.com/vmware/webcommander) - 在友好的 Web GUI 中或通过 Web 服务运行脚本并查看结果.
* [Universal Dashboard](https://ironmansoftware.com/powershell-universal-dashboard) - 用于开发网站和 REST API 的跨平台模块.

## Misc

* [DbgShell](https://github.com/Microsoft/DbgShell) - Windows 调试器引擎的 PowerShell 前端.
* [m2cgen](https://github.com/BayesWitnesses/m2cgen) - 一个 CLI 工具，用于将训练有素的经典 ML 模型转换为零依赖的本机 PowerShell 代码.
* [poke](https://github.com/oising/poke) - 适用于 PowerShell 的超酷反射模块.
  以无人关注的方式探索和调用私有 API.
  可用于安全研究、测试和快速破解.
* [WSLab](https://github.com/microsoft/WSLab) - Windows Server 快速实验室部署脚本.
* [PoshBot](https://github.com/poshbotio/PoshBot) - 基于 Powershell 的机器人框架.
* [PoShKeePass](https://github.com/PSKeePass/PoShKeePass) - 用于工作的模块 [KeePass](https://keepass.info) 数据库.
