<div class="github-widget" data-repo="Richienb/awesome-ponyfills"></div>
<div align="center">
  <img src="https://raw.githubusercontent.com/Richienb/awesome-ponyfills/master/media/Title.svg?sanitize=true"/>
  <br>
  <a href="https://awesome.re">
	  <img src="https://awesome.re/badge-flat.svg" alt="Awesome">
  </a>
    <p> <a href="https://ponyfill.com">Ponyfills</a>类似于 polyfills 但没有覆盖原生 API.  Polyfills 修补了一部分功能，以便旧环境可以支持更新的功能，而另一方面，Ponyfills 提供作为独立模块的功能.</p>
</div>



## Articles

- [Polyfills or Ponyfills?](https://ponyfoo.com/articles/polyfills-or-ponyfills)

## Main

- ⭐️ [core-js-pure](https://github.com/zloirock/core-js) - 整个标准库.

## Uncategorised

- [es6-promise](https://github.com/stefanpenner/es6-promise) - [`Promise`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)
- [es6-map](https://github.com/medikoo/es6-map) - [`Map`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Map)
- [es6-weak-map](https://github.com/medikoo/es6-weak-map) - [`WeakMap`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/WeakMap)
- [es6-set](https://github.com/medikoo/es6-set) - [`Set`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Set)
- [es6-symbol](https://github.com/medikoo/es6-symbol) - [`Symbol`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol)
- [named-regexp-groups](https://github.com/commenthol/named-regexp-groups) - [`RegExp`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp)
- [globalthis](https://github.com/ljharb/System.global) - [`globalThis`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/globalThis)

## Numbers

- [bignumber.js](https://github.com/MikeMcl/bignumber.js) - [`BigInt`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/BigInt)
- [number-is-nan](https://github.com/sindresorhus/number-is-nan) - [`Number.isNaN`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isNaN)
- [is-finite](https://github.com/sindresorhus/is-finite) - [`Number.isFinite`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isFinite)
- [is-integer](https://github.com/parshap/js-is-integer) - [`Number.isInteger`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number/isInteger)

## Strings

- [indexof](https://github.com/component/indexof) - [`String.prototype.indexOf`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/indexOf)
- [string.prototype.trim](https://github.com/es-shims/String.prototype.trim) - [`String.prototype.trim`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/Trim)
- [string.prototype.trimleft](https://github.com/es-shims/String.prototype.trimleft) - [`String.prototype.trimStart`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/TrimStart)
- [string.prototype.trimright](https://github.com/es-shims/String.prototype.trimright) - [`String.prototype.trimEnd`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/TrimEnd)
- [string.prototype.replaceall](https://github.com/es-shims/String.prototype.replaceAll) - [`String.prototype.replaceAll`](https://github.com/tc39/proposal-string-replaceall)

## Objects

- [object.fromentries](https://github.com/es-shims/Object.fromEntries) - [`Object.fromEntries`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/fromEntries)
- [object.entries](https://github.com/es-shims/Object.entries) - [`Object.entries`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/entries)
- [object-keys](https://github.com/ljharb/object-keys) - [`Object.keys`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/keys)
- [object.values](https://github.com/es-shims/Object.values) - [`Object.values`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/values)
- [object-assign](https://github.com/sindresorhus/object-assign) - [`Object.assign`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/assign)
- [object-is](https://github.com/es-shims/object-is) - [`Object.is`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is)
- [json3](https://github.com/bestiejs/json3) - [`JSON`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/JSON)

## Arrays

- [array-from](https://github.com/studio-b12/array-from) - [`Array.from`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/from)
- [array.prototype.every](https://github.com/es-shims/Array.prototype.every) - [`Array.prototype.every`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/every)
- [array.prototype.find](https://github.com/paulmillr/Array.prototype.find) - [`Array.prototype.find`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/find)
- [array.prototype.some](https://github.com/es-shims/Array.prototype.some) - [`Array.prototype.some`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/some)
- [array.prototype.flatmap](https://github.com/es-shims/Array.prototype.flatMap) - [`Array.prototype.flatMap`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/flatMap)
- [array-map](https://github.com/substack/array-map) - [`Array.prototype.map`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/map)
- [array-foreach](https://github.com/twada/array-foreach) - [`Array.prototype.forEach`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/forEach)
- [array-includes](https://github.com/es-shims/array-includes) - [`Array.prototype.includes`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/includes)
- [indexof](https://github.com/component/indexof) - [`Array.prototype.indexOf`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf).
- [isarray](https://github.com/juliangruber/isarray) - [`Array.isArray`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/isArray)

## Browser Features

- [cross-fetch](https://github.com/lquixada/cross-fetch) - [`fetch`](https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)
- [cross-blob](https://github.com/Richienb/cross-blob) - [`Blob`](https://developer.mozilla.org/en-US/docs/Web/API/Blob)
- [cross-formdata](https://github.com/Richienb/cross-formdata) - [`FormData`](https://developer.mozilla.org/en-US/docs/Web/API/FormData)
- [abortcontroller-polyfill](https://github.com/mo/abortcontroller-polyfill) - [`AbortController`](https://developer.mozilla.org/en-US/docs/Web/API/AbortController)
- [@fastly/performance-observer-polyfill](https://github.com/fastly/performance-observer-polyfill) - [`PerformanceObserver`](https://developer.mozilla.org/en-US/docs/Web/API/PerformanceObserver)
- [performance-now](https://github.com/braveg1rl/performance-now) - [`performance.now`](https://developer.mozilla.org/en-US/docs/Web/API/Performance/now)
- [console.table](https://github.com/bahmutov/console.table) - [`console.table`](https://developer.mozilla.org/en-US/docs/Web/API/Console/table)
- [webbluetooth](https://github.com/thegecko/webbluetooth) - [`Bluetooth`](https://developer.mozilla.org/en-US/docs/Web/API/Web_Bluetooth_API)
- [resize-observer-polyfill](https://github.com/que-etc/resize-observer-polyfill) - [`ResizeObserver`](https://developer.mozilla.org/en-US/docs/Web/API/ResizeObserver)
- [webcrypto-shim](https://github.com/vibornoff/webcrypto-shim) - [`crypto`](https://developer.mozilla.org/en-US/docs/Web/API/Web_Crypto_API)
- [css-vars-ponyfill](https://github.com/jhildenbiddle/css-vars-ponyfill/) - [CSS variables/custom properties](https://developer.mozilla.org/en-US/docs/Web/CSS/Using_CSS_custom_properties)
- [raf](https://github.com/chrisdickinson/raf) - [`requestAnimationFrame`](https://developer.mozilla.org/en-US/docs/Web/API/window/requestAnimationFrame)
- [xhr2](https://github.com/pwnall/node-xhr2) - [`XMLHttpRequest`](https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest)

## Node.js Features

- [events](https://github.com/Gozala/events) - [`EventEmitter`](https://nodejs.org/api/events.html#events_class_eventemitter)
- [tickedoff](https://github.com/jamiebuilds/tickedoff) - [`setImmediate`](https://nodejs.org/api/timers.html#timers_setimmediate_callback_args)
- [buffer-from](https://github.com/LinusU/buffer-from) - [`Buffer.from`](https://nodejs.org/api/buffer.html#buffer_class_method_buffer_from_array)
- [cross-exit](https://github.com/Richienb/cross-exit) - [`process.exit`](https://nodejs.org/api/process.html#process_process_exit_code)
- [next-tick](https://github.com/medikoo/next-tick) - [`process.nextTick`](https://nodejs.org/api/process.html#process_process_nexttick_callback_args)
