<div class="github-widget" data-repo="Granze/awesome-polymer"></div>
## Awesome Polymer [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
<a href="https://www.polymer-project.org"><img src="https://www.polymer-project.org/images/logos/p-logo.png" align="left" height="64" width="92"></a>
&gt; 很棒的 Polymer 资源集合

## General resources
* [Official Site](https://www.polymer-project.org)
* [Blog](https://blog.polymer-project.org/)
* [Google+ Profile](https://plus.google.com/+PolymerProject/)
* [Github](https://github.com/polymer)
* [Project](https://github.com/polymer/project) 所有与 Polymer 项目相关的事情——路线图、行为准则、如何贡​​献等等.

## Polymer Communities
* [StackOverflow](http://stackoverflow.com/questions/tagged/polymer)
* [GoogleGroup](https://groups.google.com/forum/#!forum/polymer-dev)
* [Twitter](https://twitter.com/polymer)
* [Google+ Community](https://plus.google.com/u/1/communities/115626364525706131031)
* [Slack channel](http://polymer-slack.herokuapp.com/)

## Tutorials/Guides
* [Official Codelabs](https://codelabs.developers.google.com/polymer-summit)
* [Test your elements](https://www.polymer-project.org/2.0/docs/tools/tests)
* [Testing Tips](https://medium.com/google-developer-experts/polymer-testing-tips-f217ba94a64)
* [Unit Testing](https://medium.com/@granze/polymer-unit-testing-d6a69910dc31)
* [Deploy with Firebase](https://www.polymer-project.org/2.0/start/toolbox/deploy)
* [Migration guide](https://www.polymer-project.org/1.0/docs/migration.html)
* [Using elements](https://elements.polymer-project.org/guides/using-elements)
* [Flexbox layout with iron-flex-layout](https://elements.polymer-project.org/guides/flex-layout)
* [Using Neon Animations](https://elements.polymer-project.org/guides/using-neon-animations)
* [Build a real-time to-do app](https://scotch.io/tutorials/build-a-real-time-polymer-to-do-app)
* [Taming Polymer with SystemJS and TypeScript](http://blog.charto.net/typescript/Taming-Polymer-with-SystemJS-and-TypeScript-part-1/) 第1部分
* [Polymer 3.0 Preview — Building a mini card game](https://medium.com/@jecelynyeen/polymer-3-0-preview-building-a-mini-card-game-ce8948265fd6)

## Articles
* [Encapsulated Routing with Elements](https://www.polymer-project.org/1.0/articles/routing.html)
* [Building web components using ES6 classes](https://www.polymer-project.org/1.0/articles/es6.html)
* [Write web components with ES2015 (ES6)](http://www.revillweb.com/tutorials/web-components-with-es2015-es6/)
* [Live-reload for Polymer Chrome Apps](http://codingwithgerwin.blogspot.it/2015/07/live-reload-for-polymer-chrome-apps.html)
* [Using Polymer with Flux and a global app state](http://paulusschoutsen.nl/blog/2015/07/using-polymer-with-flux-and-a-global-app-state/)
* [Guitar Tuner with Web audio API](https://aerotwist.com/blog/guitar-tuner/)
* [Polymer for the Performance-obsessed](https://aerotwist.com/blog/polymer-for-the-performance-obsessed/)
* [What is shady DOM](https://www.polymer-project.org/1.0/articles/shadydom.html)
* [Using Polymer webcomponents with Angular JS](http://jcrowther.io/2015/05/26/using-polymer-webcomponents-with-angular-js/)
* [Upgrading to 1.0](https://www.bithound.io/blog/post/upgrading-to-polymer-10) 比特猎犬博客
* [Dynamically Loading Elements & ES6 Modules](http://addyosmani.github.io/webcomponent-samples/polymer/modules/)
* [NET-A-PORTER case study](https://developers.google.com/web/showcase/case-study/net-a-porter)
* [Polymer loves Redux](https://medium.com/collaborne-engineering/polymer-loves-redux-f89a863394d9#.7f4z92ppy)
* [How to use Polymer with Webpack](https://medium.com/dev-channel/how-to-use-polymer-with-webpack-b41812d78b15)

## Videos
* [Polycasts](https://www.youtube.com/playlist?list=PLOU2XLYxmsII5c3Mgw6fNYCzaWrsM3sMN)
* [Summit 2017](https://www.youtube.com/watch?v=TDpiyrcOO30&list=PLNYkxOF6rcIDP0PqVaJxqNWwIgvoEPzJi)
* [Summit 2016](https://www.youtube.com/watch?v=0iM0DZjYGqg&list=PLNYkxOF6rcICc687SxHQRuo9TVNOJelSZ)
* [Summit 2015](https://www.youtube.com/playlist?list=PLNYkxOF6rcICdISJclfQhj2S8QZGjXV8J)
* [The Web Platform Podcast 46: Polymer 1.0](https://www.youtube.com/watch?v=d9tNO3n0RlM)
* [Google I/O 2017 - Future, Faster: Unlock the Power of Web Components with Polymer](https://www.youtube.com/watch?v=cuoZenpQveQ)
* [Google I/O 2015 - Polymer and modern web APIs: In production at Google scale](https://www.youtube.com/watch?v=fD2As5RmM8Q)
* [Componentize your app with Polymer Elements](https://youtu.be/7WgEuNZCCHk)
* [Learn Polymer 1.0](https://www.youtube.com/playlist?list=PLPaj_o9gjMYll0sSb47TrzQCjIo5iqQZm) 通过 Stretch Projects
* [Level up Tutorials](https://www.youtube.com/playlist?list=PLLnpHn493BHGhoGAb2PRKzv4Zw3QoatK-)

## Boilerplates
* [Polymer boilerplate](https://github.com/webcomponents/polymer-boilerplate)
* [Starter kit](https://developers.google.com/web/tools/polymer-starter-kit/) 构建用于创建生产质量 W​​eb 应用程序的工具和样板.
* [Seed element](https://github.com/polymerlabs/seed-element)
* [Polymer Admin](https://github.com/akveo/polymer-admin) 使用 Polymer 1.0 和 Polymer Starter Kit 创建的响应式管理仪表板
* [Meteor-Polymer Starter Kit](https://github.com/aruntk/kickstart-meteor-polymer) 使用 MWC 包启动 Meteor - Polymer 项目
* [Meteor-Polymer Starter Kit Including Auth](https://github.com/aruntk/kickstart-meteor-polymer-with-auth)

## Generators
* [Generator Polymer](https://github.com/yeoman/generator-polymer) Polymer 项目的 Yeoman 生成器，基于官方 [Starter kit](https://developers.google.com/web/tools/polymer-starter-kit/).
* [Generator element](https://www.npmjs.com/package/generator-element) 使用 Polymer、X-Tag 或 VanillaJS 创建自定义元素的 Yeoman 生成器.

## Official Elements
* [Elements Catalog](https://www.webcomponents.org/collection/Polymer/elements)
 * [Iron](https://www.webcomponents.org/collection/PolymerElements/iron-elements) 铁元素是一组视觉和非视觉实用元素.
 * [Paper](https://www.webcomponents.org/collection/PolymerElements/paper-elements) Paper 元素是一组实现 Google Material Design 的视觉元素.
 * [Google web components](https://www.webcomponents.org/collection/GoogleWebComponents/google-web-components)
 * [Gold](https://www.webcomponents.org/collection/PolymerElements/gold-elements) 黄金元素是为结账流程等电子商务用例构建的.
 * [Platinum](https://www.webcomponents.org/collection/PolymerElements/platinum-elements) 将您的网页变成真正的网络应用程序的元素，具有推送、离线等功能.
 * [Molecules](https://www.webcomponents.org/collection/PolymerElements/molecules) 包装其他 javascript 库的元素.
 * [App](https://www.webcomponents.org/collection/PolymerElements/app-elements) 允许使用模块化自定义元素构建完整 Web 应用程序的元素.
 * [Data](https://www.webcomponents.org/collection/PolymerElements/data-elements) 数据/存储相关元素的集合.
 * [Layout](https://www.webcomponents.org/collection/PolymerElements/layout-elements) 布局相关元素的集合.
 * [[过时] 霓虹灯](https://elements.polymer-project.org/browse?package=neon-elements) 霓虹灯元素实现特殊效果.

## Directories
* [Built with Polymer](http://builtwithpolymer.org/)
* [Webcomponents.org](https://webcomponents.org/)
* [Components Kitchen](http://component.kitchen/)
* [open-elements](http://open-elements.org) 对所有使用聚合物的元素开放 ^1.1

## Tools
* [App Toolbox](https://www.polymer-project.org/2.0/toolbox/) 应用工具箱.
* [Polyserve](https://github.com/polymerlabs/polyserve) 一个简单的 Web 服务器，用于在本地使用 Bower 组件.
* [Polybuild](https://github.com/PolymerLabs/polybuild) 用于 Polymer 应用程序的一体化构建工具.
* [Polyup](https://github.com/PolymerLabs/polyup) 从 Polymer v0.5 迁移到 1.0 的有用助手.
* [Polylint](https://github.com/PolymerLabs/polylint) 检测代码中的错误.
* [Polygit](http://polygit.org/) Magic Server 以与 HTML Imports 自然重复数据删除功能兼容的方式直接从 github（通过 ```cdn.rawgit.com```）提供文件.
* [Polydev](https://github.com/PolymerLabs/polydev) 开发工具扩展.
* [Polymer Ready](https://chrome.google.com/webstore/detail/polymer-ready/aaifiopbmiecbpladpjaoemohhfjcbdk) 当检测到某些 Polymer 和自定义组件时，在地址栏中显示一个图标.
* [Vulcanize](https://github.com/Polymer/vulcanize) 用于 HTML 导入和 Web 组件的构建工具.
* [Crisper](https://github.com/PolymerLabs/crisper) 从 HTML 文件中拆分内联脚本以实现 CSP 合规性.
* [Snippets for Atom editor](https://atom.io/packages/polymer-snippets)
* [Snippets for Sublime Text editor](https://packagecontrol.io/packages/Polymer%20%26%20Web%20Component%20Snippets)
* [Synthesis](https://github.com/meteorwebcomponents/synthesis) 使用 Polymer 作为 Meteor.js 的视图层
* [MWC-Layout](https://github.com/meteorwebcomponents/layout) 控制聚合物组件的渲染.
* [WC-Loader](https://github.com/aruntk/wc-loader) .  Webcomponents webpack 加载器
* [Polymer Webpack Loader](https://github.com/webpack-contrib/polymer-webpack-loader) . 聚合物 webpack 加载器.
* [Polymer CDN](https://github.com/download/polymer-cdn) . 聚合物组件的非官方 CDN.
* [lit-html](https://github.com/Polymer/lit-html) HTML 模板，通过 JavaScript 模板文字.

## Testing
* [Web components tester](https://github.com/Polymer/web-component-tester) 使测试您的 Web 组件变得轻而易举！
* [Web components tester istambul](https://github.com/thedeeno/web-component-tester-istanbul) 用于 web-component-tester 的伊斯坦布尔覆盖插件.
* [test-fixture](https://github.com/PolymerElements/test-fixture) 可以简化持续重置测试套件 DOM 的练习的元素.
* [iron-test-helpers](https://github.com/PolymerElements/iron-test-helpers) 使测试更容易的实用程序类.

## Behaviors
* [Polymer-Apollo](https://github.com/aruntk/polymer-apollo) Polymer Apollo GraphQL 集成.
* [MWC-Mixin](https://github.com/meteorwebcomponents/mixin) 聚合物元素的反应性流星数据源
* [MWC-Router](https://github.com/meteorwebcomponents/router) 两种方式将聚合物与 Meteor Flowrouter 结合.
* [Polymer-Redux](https://github.com/tur-nr/polymer-redux) Redux 的聚合物绑定.

## Theming/Styling
* [Polymer Themes](https://polymerthemes.com/) 免费的 Polymer 主题和模板
* [Material Palette](https://www.materialpalette.com/) 基于 Material Design 的调色板生成器
* [Polystyle](https://poly-style.appspot.com/demo/) 使用 Polymer 的样式模块系统包装现有样式表.

## Notable projects
[Polymer Projects](https://github.com/abdonrd/PolymerProjects) 使用 Polymer 构建的网站和应用程序列表


## Other awesome resources
**如果你想要更多精彩资源，请查看 [awesome](https://github.com/sindresorhus/awesome) 列表！**

---

### License

[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)
