<div class="github-widget" data-repo="playcanvas/awesome-playcanvas"></div>
## Awesome PlayCanvas [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> <img src="https://raw.githubusercontent.com/playcanvas/awesome-playcanvas/master/playcanvas-logo.png" align="right" width="100">
>
> PlayCanvas is an open source platform for building interactive web content. It's written in JavaScript, HTML5, CSS3 and WebGL.
>
> This list is a curated collection of awesome resources, tools, tutorials and projects using the PlayCanvas engine to help developers make _awesome_ games and visualizations.
>
> Contributions _very welcome_ but first see [Contributing](#contributing).



## PlayCanvas

- [Editor](https://playcanvas.com/) - Browser-based, real-time collaborative WebGL Editor.
- [Engine](https://github.com/playcanvas/engine) - Full source to the PlayCanvas run-time licensed under MIT.
- [glTF Viewer](https://playcanvas.com/viewer) - glTF 2.0 compliant model viewer.
- [NPM Package](https://www.npmjs.com/package/playcanvas) - Node.js packages of the PlayCanvas engine run-time.
- [PCUI](http://playcanvas.github.io/pcui/) - Open source front-end framework used by the PlayCanvas toolset.
- [Reference](https://api.playcanvas.com/) - API reference manual for the engine run-time.
- [SuperSplat](https://playcanvas.com/supersplat/editor) - 3D Gassuian Splat Editor.
- [Texture Tool](https://playcanvas.com/texture-tool) - Tool for reprojecting textures.
- [User Manual](https://developer.playcanvas.com/user-manual/) - PlayCanvas user guide.

## Community

- [Forum](https://forum.playcanvas.com/)
- [Twitter](https://twitter.com/playcanvas)
- [Discord Server](https://discord.gg/RSaMRzg)
- [Facebook](https://www.facebook.com/playcanvas/)
- [HTML5GameDevs Forum](https://www.html5gamedevs.com/tags/playcanvas/)
- [Openbase](https://openbase.com/js/playcanvas)
- [Reddit](https://www.reddit.com/r/PlayCanvas/)
- [Stack Overflow](https://stackoverflow.com/questions/tagged/playcanvas)

## Tutorials

- [Vehicle and Interior Tutorials](https://3dground.net/en/articles/playcanvas-webgl/1) - Detailed write ups of 2 PlayCanvas visualization applications.
- [Create a Bowling Game](https://www.gamefromscratch.com/post/2017/05/25/PlayCanvas-Engine-Revisited.aspx) - Create a physics-based bowling game.
- [Create a Space Shooter](https://gamedevelopment.tutsplus.com/tutorials/create-a-space-shooter-with-playcanvas-part-1--cms-28066) - Recreate Asteroids in this Tutsplus tutorial.
- [MDN tutorial](https://developer.mozilla.org/en-US/docs/Games/Techniques/3D_on_the_web/Building_up_a_basic_demo_with_PlayCanvas) - Build up a basic demo with PlayCanvas.
- [Official Tutorials](https://developer.playcanvas.com/en/tutorials/) - Large collection of official PlayCanvas tutorials.
- [PlayCanvas and Substance](https://magazine.substance3d.com/high-end-renders-online-bike-configurator-substance/) - Creating high-end artwork for vehicle configurators with PlayCanvas and Substance.
- [Rescue the Lunar Lander](https://medium.com/@omar4ur/rescue-the-lunar-lander-a-coderdojo-tutorial-5217d463e26a) - Tutorial to make a simple physics based game.
- [Solar Games Mentorship](https://solargames.io/mentorship/) - Premium PlayCanvas training and mentorship services.
- [Video Tutorials](https://www.youtube.com/playlist?list=PLy57qL2R3Z6NlBQBEMnjVPT0iz320i4Ko) - YouTube playlist for short PlayCanvas tutorials.

## Extensions and Utilities

- [8th Wall](https://www.8thwall.com/docs/api/playcanvas/getting-started/) - Markerless AR runtime.
- [playcanvas-ar](https://github.com/playcanvas/playcanvas-ar) - Marker-based AR solution built on ARTollkit.
- [playcanvas-node](https://github.com/yushimatenjin/playcanvas-node) - REST API wrapper for Node.js.
- [playcanvas-p2.js](https://github.com/playcanvas/playcanvas-p2.js) - An integration with the p2.js 2D physics engine.
- [playcanvas-rest-api-tools](https://github.com/playcanvas/playcanvas-rest-api-tools) - CLI tools built on the PlayCanvas REST API.
- [playcanvas-spine](https://github.com/playcanvas/playcanvas-spine) - Spine plugin for PlayCanvas for 2D animations.
- [playcanvas-tween](https://github.com/playcanvas/playcanvas-tween) - Officially supported tween animation plugin.
- [playcanvas-vue](https://github.com/isobolewski/playcanvas-vue) - A PlayCanvas integration with Vue.js.
- [@recast-navigation/playcanvas](https://www.npmjs.com/package/@recast-navigation/playcanvas) - NavMesh and Pathfinding using [Recast](https://github.com/recastnavigation/recastnavigation) for PlayCanvas
- [tween.js](https://github.com/tweenjs/tween.js/) - Popular JavaScript tweening library that integrates easily with PlayCanvas.
- [Solar Tools](https://solargames.io/tools/) - A commercial toolkit for PlayCanvas that includes a GPU instancer, terrain and effects scripts, multiplayer etc.
- [Sublime Completions](https://github.com/playcanvas/sublime-completions) - Sublime Text Autocompletion for the PlayCanvas API.
- [VS Code Extension](https://marketplace.visualstudio.com/items?itemName=playcanvas.playcanvas) - VS Code Extension that can be used instead of the built-in Code Editor.

## Technical Demos

- [After the Flood](https://playcanv.as/p/44MRmJRU/) - Collaboration with Mozilla to promote WebGL 2.
- [Casino](https://playcanv.as/p/LpmXGUe6/) - Physically rendered 3D casino environment.
- [Global Illumination](https://playcanv.as/p/ZV4PW6wr/) - GI approximation using interpolated lightmaps.
- [Seemore](https://playcanv.as/p/MflWvdTW/) - Collaboration with ARM to promote mobile WebGL.
- [Sponza](https://playcanv.as/p/txPePQvy/) - Run-time lightmapped Sponza environment.
- [Star-Lord](https://playcanv.as/p/SA7hVBLt/) - First ever PBR demo from PlayCanvas.
- [Steampunk Slots](https://playcanv.as/p/nL1dYbMv) - Physically rendered slots machine.

## Interactive Experiences

- [Call of Duty: Gunsmith](https://playcanv.as/p/XPWoTZ4F/) - Promotional 3D experience themed on Call of Duty.
- [Childhood on the Move](https://gallery.familyforeverychild.org/Childhood-on-The-Move/) - Virtual art exhibition from charity Family for Every Child.
- [Cyber City](https://vz777.com/cybercity/index.html) - Promotional site for Visionaries777.
- [Da Viking Code's Metaverse](https://metavers.davikingcode.com/) - Explorable 3D project portfolio of a digital agency.
- [DOOH Invaders](https://vimeo.com/136313614) - World's largest Space Invaders clone unveiled at Cannes Lions.
- [Fatal System Error](https://playcanv.as/p/A5qC9ftM/?overlay=false) - Interactive opera experience created by Dumbworld from the Royal Opera House.
- [How Not To Suck At Money](https://hntsam.com/) - Educational game from Invesco about personal finance.
- [Life During COVID-19](https://gallery.familyforeverychild.org/) - Virtual art exhibition from charity Family for Every Child.
- [MMX Racing](https://playcanv.as/p/ika9sdKu/?truck=johncena) - Interactive 3D ad for a popular mobile game.
- [Party Space](https://www.party.space/) - Virtual events platform.
- [Pocketverse](https://pocketverse.net/) - Procedurally generated star systems.
- [Realise](https://gaffen.itch.io/realise) - A video game to accompany the new EP from Hearse Pileup.
- [Ride Along 2](https://vimeo.com/152996271) - Using WebGL to promote a Hollywood movie release.
- [Rugby World Cup](https://www.youtube.com/watch?v=onOJBCC8R7A) - Promoting the Rugby World Cup in London's Piccadilly Circus.
- [Virtual Statues](https://playcanv.as/e/p/cLkf99ZV/) - A digital museum built with 3D Gaussian Splatting.
- [Wild Rift](https://unlock.wildrift.leagueoflegends.com/) - Solve the puzzle to unlock a League of Legends: Wild Rift character.

## Browser Games

- [Beyond Bionic: Extreme Encounters](https://www.bbc.co.uk/cbbc/games/beyond-bionic-extreme-encounters) - Outdoor adventures in this game from the BBC.
- [Bubble Tower 3D](https://play.famobi.com/bubble-tower-3d) - Old school bubbleshooter game.
- [Build Land](https://poki.com/en/g/build-land) - Grow your island by collecting resources.
- [Bus Parking 3D](https://play.famobi.com/bus-parking-3d) - Park the bus in the designated space before the timer runs out.
- [Cannon Balls 3D](https://play.famobi.com/cannon-balls-3d) - Use the cannon to destroy the various structures in this physics-based game.
- [Color Burst 3D](https://gamesnacks.com/games/colorburst3d) - Hit the colored wall matching the ball color.
- [Continental Marble Adventure](https://portfolio.redox-interactive.com/en/projects/continental-marble-adventure) - Marble game for Continental's 150 year anniversary.
- [Conundrum](https://conundrum.fun) - A word game where you solve anagrams. Fast!
- [Curve Ball 3D](https://play.famobi.com/curve-ball-3d) - 3D pong game.
- [Disney's Hour of Code - Moana](http://partners.disney.com/hour-of-code) - Learn programming fundamentals with Disney's Moana.
- [Euro Penalty Cup 2021](https://play.famobi.com/euro-penalty-cup-2021) - Try to hit the goal and outsmart the goalkeeper.
- [Flappy Bird](https://playcanv.as/p/2OlkUaxF/) - Guide the bird through as many pipes as possible.
- [Free Kick Football](https://gamesnacks.com/games/freekickfootball) - Curve the ball to score goals.
- [Full Speed Racing](https://gamesnacks.com/games/fullspeedracing) - Drive as far as you can before the time runs out.
- [Galaxies: Combat](https://playcanv.as/p/Ikq6Uk6A/) - Carefully select power ups to defeat waves of hostile ships.
- [Garden Bloom](https://play.famobi.com/garden-bloom) - Garden themed 2D match 3 game.
- [Garden Match 3D](https://play.famobi.com/garden-match-3d) - 3D match 3 game.
- [Geometry Run](https://www.gamee.com/game/geometryrun) - Stylized endless runner built from geometric shapes.
- [Hoop Royale](https://play.famobi.com/hoop-royale) - Maneuver the ring around the ball.
- [Jungle Friends](https://poki.com/en/g/jungle-friends) - Earn coins by helping your animal friends.
- [Lego Jurassic World: Off-road Race](https://www.toggo.de/spiele/jurassic-world/jurassic-world-das-gelaenderennen-6727.htm) - Dinosaurs, LEGO and vehicle stunts.
- [Mahjong World](https://play.famobi.com/mahjong-world) - 3D Mahjong puzzle game.
- [Mancala Classic](https://www.crazygames.com/game/mancala-classic) - Strategic board game.
- [Master Archer](https://playcanv.as/p/JERg21J8/) - Shoot the fruit from the top of Bob's head.
- [Megopoly](https://playmegopoly.com/) - Free to play casual strategy board game where you invest in virtual property.
- [Monopoly](https://benbean.tech/monopoly-io/) - The classic boardgame recreated in a 3D video game.
- [Nitro Knights](https://gamedistribution.com/games/nitro-knights) - Futuristic jousting game.
- [Om Nom Run](https://play.famobi.com/om-nom-run) - Endless runner.
- [Orbital Survival](https://playcanv.as/p/3G3RnfUz/) - Destroy wave after wave of enemies on a tiny world.
- [Scooter Xtreme](https://gamesnacks.com/games/scooterxtreme) - Casual scooter riding game.
- [Slice Rush](https://play.famobi.com/slice-rush) - Take the knife and chop your way through the kitchen.
- [Stack Smash](https://play.famobi.com/stack-smash) - Destroy all platforms to get to the ground and win.
- [Star Stable](https://www.starstable.com/en/register) - Character registration portal for popular horse game.
- [Stickman Climb](https://poki.com/en/g/stickman-climb) - Physics based puzzle game.
- [TNT Bomb](https://play.famobi.com/tnt-bomb) - Destroy buildings and structures with explosive power ups.
- [SWOOOP](https://playcanv.as/p/JtL2iqIH/) - Pick up gems in a bi-plane above a magical island.
- [Town Star](https://gala.games) - Online farming game built by the Creative Director of Farmville 2.
- [Virtual Voodoo](https://playcanv.as/p/tRUfwVg1/) - Voodoo doll simulator.

## IO Games

- [Bullet Bonanza](https://www.bulletbonanza.io/) - Fast paced, high fidelity, 3D Multiplayer FPS game from Kiloo.
- [Fields of Fury](https://www.fieldsoffury.io/) - Capture the flag set during WW2.
- [GUMMYZ](https://gummyz.fitfuns.com) - Sword-swinging multiplayer combat game.
- [Ink Wars](https://playcanv.as/p/YvyiZeqL/) - Paint faster than your opponents to win the round.
- [Mini Royale: Nations](https://miniroyale.io/) - Battle Royale first person shooter.
- [Robostorm](https://robostorm.io/) - Frenetic online multiplayer mech battle game.
- [Rollem](https://rollem.io/) - Guide your hamster to the end of the obstacle course in the fastest time.
- [Simply Up](https://simplyup.io) - Climb to the top of the tower in the shortest time. 
- [Tank Royale](https://tankroyale.io/) - Cartoony fast-paced top-down multiplayer shooter.
- [TANX](https://tanx.io) - Online multiplayer tank battle game.
- [Tribals](https://tribals.io/) - First-person multiplayer survival game.
- [Venge](https://venge.io/) - 3D Multiplayer FPS shooter.
- [Vortelli's Pizza](https://poki.com/en/g/vortellis-pizza-delivery) - Multiplayer restaurant game.
- [Warbands](https://www.warbands.io/) - 3D Multiplayer FPS shooter.
- [Wheat Farming](https://poki.com/en/g/wheat-farming) - Multiplayer farming game.

## Messenger Games

- [GameWave](https://apps.apple.com/us/app/gamewave-games-for-imessage/id1506797690) - Multiplayer games for iMessage.

## YouTube Playables

- [Cannon Balls 3D](https://www.youtube.com/playables/UgkxtJBl0ZoeInS-4l5yzLRPqToF7zHv4dhr) - Use the cannon to destroy the various structures in this physics-based game.
- [Color Burst 3D](https://www.youtube.com/playables/UgkxcobZM_stIxOBW-bQwKcrUiYbg11g4x55) - Hit the colored wall matching the ball color.
- [Farm Land](https://www.youtube.com/playables/Ugkxsk_eNi3xerLPa1SuoUIftBIWxzlTCbAN) - Grow produce to expand your land.
- [Free Kick Football](https://www.youtube.com/playables/UgkxjX3-84ZFPZHSm99ZIsn9eqPQQSoWJPxS) - Curve the ball to score goals.
- [Full Speed Racing](https://www.youtube.com/playables/UgkxbgLQk7KP4zQKHctwKY-XKtpJ_OBWL4aO) - Drive as far as you can before the time runs out.
- [Om Nom Run](https://www.youtube.com/playables/UgkxiSWh_UPnG4BImBX7gI3KVDLxT2Wm1PiJ) - Endless runner.
- [Scooter Xtreme](https://www.youtube.com/playables/UgkxeIG5erzthQsBVVs1sCMhJTrLdLAb7v5c) - Casual scooter riding game.
- [Stack Bounce](https://www.youtube.com/playables/UgkxHHtsak1SC8mRGHMZewc4HzeAY3yhPPmJ) - Destroy all platforms to get to the ground and win.

## Automotive

- [Airstream Basecamp](https://www.airstream.com/travel-trailers/airstream-basecamp-3d-experience/) - Travel trailer visualizer.
- [Bennington Pontoon Boats](https://www.benningtonmarine.com/en-us/build-model/) - Boat configurator.
- [BMW Car Design](https://www.bmw.com/en/design/car-design-the-keys-to-bmw-design.html) - Interactive exploration of BMW design.
- [BMW i4 M50 Showcase](https://www.bmw.com/en/performance/electric-sports-car-BMWi4-M50-driving-dynamic-test.html) - Blog article that embeds a technical overview of the new i4.
- [BMW i8](http://car.playcanvas.com) - Car visualizer.
- [DAB Motors](https://dabmotors.com/configurator/) - Motorcycle configurator.
- [Honda Civic Type R](https://www.honda.co.jp/CIVICTYPE-R/configurator/) - Configurator (Japanese).
- [Indian Motorcycles](https://www.indianmotorcycle.com/en-us/scout-bobber/build-color/) - Motorcycle configurator.
- [Infiniti Experience](https://beijing.infiniti-experience.com/) - Explore the 2020 Infiniti range (Chinese).
- [Kia Niro Hybrid](https://www.kia.com/kr/buy/build-your-car/build/trim?rcCode=KRSG078) - Kia configurator (Korean).
- [Kia Virtual Experience](https://www.kiavirtualexperience.com/) - Explore Kia's latest line of cars.
- [Mercedes AMG GT C](https://playcanv.as/p/4e391c28/) - Car visualizer.
- [Nissan Ariya](https://saas.nissan.co.jp/clubariya/login/) - Explore Nissan's Arriya in 3D (Japanese - requires sign in).
- [Polaris RZR](https://rzr.polaris.com/en-us/build-model/) - Off-road vehicle configurator.

## Product Configurators

- [3D Plans](https://3dplans.com) - Virtual tours and interactive maps for the property market.
- [Amisco Furniture](https://www.amisco.com/en_us/uprightstool) - Interactive 3D furniture configurator.
- [Cibes Lifts](https://www.cibeslift.com/lift-configurator/) - Elevator configurator.
- [Elfa Closets](http://elfa.com/sv-se/planner) - Closet configurator.
- [Fjällräven Kånken](https://www.fjallraven.com/uk/en-gb/bags-gear/kanken/kanken-bags/kanken-me) - Backpack configurator.
- [Iconic Nordic Rooms](https://www.inr.se/planera-badrum/planera-badrum-verktyg-3d/) - Shower and sink configurators.
- [iPhone 6](http://phone.playcanvas.com) - iPhone visualizer.
- [Montblanc](https://www.montblanc.com/en-us/headphones_cod19971654706731691.html) - Product visualizer for Montblanc pens, watches, wallets and headphones.
- [Norqain](https://norqain.com/pages/watch-configurator) - Watch configurator.
- [My Sliding Wardrobe](https://www.myslidingwardrobe.co.uk/design-your-wardrobe/) - Closet configurator.
- [Renewal by Andersen Windows](https://www.renewalbyandersen.com/windows-doors/replacement-windows/double-hung) - Window configurator.
- [WFI](https://configurator.wfi.se/#/?lang=en) - Workstation configurator.
- [Willab Gardens Greenhouses](http://www.vaxthusguiden.se/) - Greenhouse configurator.

## AR/VR/XR

- [Orange Room](https://playcanv.as/p/1ha5glKf/) - A highly realistic interior environment demonstrating room-scale VR.
- [Neon Bubblegum](https://www.rtz23.de/) - Demo scene style WebXR-based homepage from Karsten Weil.
- [Raw: Paralympics XR](https://www.phoria.com.au/projects/paralympics-xr/) - Webby 2022 nominated WebXR 360 video experience.
- [Storage Space 13](https://js13kgames.com/entries/storage-space-13) - Fun VR game and winner of js13k WebXR category.
- [Viverse](https://www.viverse.com/) - Open platform for virtual worlds and environments developed by HTC.
- [WebXR Lab](https://playcanvas.com/project/446331/overview/webxr-vr-lab) - Sandbox for VR interaction experiments.

## Blockchain/Crypto/NFT

- [Aritelia](https://aritelia.io/) - Open world social MMO with sandbox building and collectable NFTs.
- [Doge Temple](https://www.dogetemple.io/) - Online microverse devoted to Dogecoin.
- [The Crypt](https://www.crypt.art/) - Gallery for rare art and collectibles.
- [RareRooms](https://www.rarerooms.io/) - 3D virtual rooms for NFT collections.
- [Somnium Space](https://somniumspace.com/parcel/) - Virtual Reality world built on the Ethereum blockchain.

## Contributing

Please see [CONTRIBUTING](https://github.com/playcanvas/awesome-playcanvas/blob/master/CONTRIBUTING.md) for details.
