<div class="github-widget" data-repo="PerfectCarl/awesome-play1"></div>
## Awesome Play1 [![play-isthe1!](http://img.shields.io/badge/play-isthe1-red.svg?style=flat)](https://github.com/markets/awesome-ruby) [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

很棒的 Play 1.x 的集合 [modules](#modules), [tools](#tools)， 和 [resources](#resources).

&gt;灵感来自 [awesome-php](https://github.com/ziadoz/awesome-php), [awesome-python](https://github.com/vinta/awesome-python), [frontend-dev-bookmarks](https://github.com/dypsilon/frontend-dev-bookmarks) 和 [awesome-ruby](https://github.com/markets/awesome-ruby).

[Contributions](https://github.com/PerfectCarl/awesome-play1/blob/master/CONTRIBUTING.md) 随时欢迎！ 

## Modules
列出具有以下“徽章”的所有可用模块： 

 | 徽章 | 含义 |  
|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/carbonate)                         | the module is registered in [playframework.com/modules](http://www.playframework.com/modules) . 徽章指向注册页面.  |
| [![registered on playframework.com/modules](http://img.shields.io/badge/registered-no-red.svg?style=flat) ](https://github.com/PerfectCarl/play-profiler) | 该模块**未**注册于 [playframework.com/modules](http://www.playframework.com/modules) . 您必须在“dependencies.yml”文件中添加一个外部存储库. 徽章指向官方模块页面.  |
| [![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat) ](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.db/play-db) | 该模块在 MavenCentral 中可用，感谢 [maven-play-plugin](https://code.google.com/p/maven-play-plugin) . 徽章指向模块的 Maven 存储库.  |
| [![Updated since the play module registry was frozen](http://img.shields.io/badge/ -updated-ff69b4.svg?style=flat) ](https://github.com/PerfectCarl/play-profiler) | 该模块已经更新，因为 [playframework.com/modules](http://www.playframework.com/modules) 已被冻结. 徽章指向官方模块页面.  |


这些模块分为以下几类： 
 * [Database](#database) 
 * [Deployment](#deployment) 
 * [Injection/dependencies](#injectiondependencies) 
 * [Language](#language) 
 * [Messaging/events](#messagingevents) 
 * [Monitoring](#monitoring) 
 * [Persistence](#persistence) 
 * [Presentation](#presentation) 
 * [Rest](#rest) 
 * [Scaffolding](#scaffolding) 
 * [Security](#security) 
 * [Template](#template) 
 * [Translation](#translation) 
 * [Misc](#misc) 

如果您想提供有关模块的信息，请参阅 [guide](https://github.com/PerfectCarl/awesome-play1/blob/master/CONTRIBUTING.md#module).

### Database 

* **[[碳酸盐]](http://www.playframework.com/modules/carbonate) [Carbonate](https://github.com/huljas/play-carbonate)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/carbonate) 使用 Hibernate 架构更新创建和运行数据库迁移，以自动生成迁移的 SQL. 看到这个博客 [post](http://huljas.github.com/code/2011/04/04/managing-database-with-playcarbonate.html) 
* **[[时间戳]](http://www.playframework.com/modules/chronostamp) [Chronostamp](https://github.com/omaroman/chronostamp)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/chronostamp) 通过添加和更新时间戳字段（created_at 和 updated_at）增强模型. 
* **[[db] ](http://www.playframework.com/modules/db) [Database module](http://github.com/pepite/play--database)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/db)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat) ](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.db/play-db) 导出你的游戏！ 域模型到 DDL 文件并将数据库导入您的 Play！ 域模型. 
* **[[jpagen] ](http://www.playframework.com/modules/jpagen) [JpaGen](http://github.com/marcuspocus/jpagen)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/jpagen) 从元数据或包含表列表的文件生成 JPA 实体和复合键（需要时）. 
* **[[liquibase]](http://www.playframework.com/modules/liquibase) [Liquibase](https://github.com/7uc0/play-liquibase)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/liquibase) [Liquibase](http://www.liquibase.org) 是一个简单、可靠、优雅的数据库重构管理解决方案 
* **[[logisimayml] ](http://www.playframework.com/modules/logisimayml) [logisima-yml](http://github.com/sim51/logisima-play-yml)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/logisimayml) 将您的数据库导出到 yml 文件 
* **[[迁移]](http://www.playframework.com/modules/migrate) [Database migration](http://github.com/dcardon/play-migrate)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/migrate) 维护项目的数据库版本. 
* **[[multidb] ](http://www.playframework.com/modules/multidb) [Multiple Databases](http://github.com/dcardon/play-multidb)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/multidb) 使用通用模式将您的应用程序扩展到多个数据库. 

### Deployment 

* **[[capistrano]](http://www.playframework.com/modules/capistrano) [Capistrano](https://github.com/mandubian/play-capistrano)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/capistrano) 使用 Capistrano + SSH + VCS 部署远程应用程序并以 nohup/background 模式运行它. 
* **[[货物]](http://www.playframework.com/modules/cargo) [Cargo](https://github.com/dgouyette/play-cargo)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/cargo) 远程部署您的应用程序. 
* **[[cloudbees] ](http://www.playframework.com/modules/cloudbees) [CloudBees](https://github.com/hadashi/play-cloudbees)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/cloudbees) 提供与 CloudBees 的集成. 
* **[[cloudfoundry] ](http://www.playframework.com/modules/cloudfoundry) [CloudFoundry](https://github.com/bcourtine/play--cloudfondry)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/cloudfoundry) 自动配置您的应用程序部署在 CloudFoundry 中的数据库. 
* **[[点云]](http://www.playframework.com/modules/dotcloud) [Dotcloud](https://github.com/lsinger/play-dotcloud)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/dotcloud) 将您的应用程序部署到 dotcloud 
* **[[gae] ](http://www.playframework.com/modules/gae) [Google App Engine](http://github.com/guillaumebort/play-gae)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/gae)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.gae/play-gae) 为 Google App Engine 平台创建应用程序. 
* **[[heroku] ](http://www.playframework.com/modules/heroku) [Heroku](https://github.com/jamesward/play-heroku)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/heroku) 在 Heroku 上部署您的应用程序. 
* **[[jelastic] ](http://www.playframework.com/modules/jelastic) [Jelastic Deployment Support](https://github.com/Fameing/play-jelastic)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/jelastic) 在 Jelastic 平台中部署您的应用程序. 
* **[[openebay] ](http://www.playframework.com/modules/openebay) [Open eBay](https://bitbucket.org/kumaresan/openebay)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/openebay) 提供基本的管道来创建一个 [Open eBay Application](http://apps.ebay.com/) 
* **[[openshift] ](http://www.playframework.com/modules/openshift) [Openshift](https://github.com/opensas/openshift)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/openshift) Openshift 是 Red Hat 的免费、自动扩展、基于云的平台即服务，适用于 Java、Perl、PHP、Python 和 Ruby 应用程序. 
* **[play-gae-q42]  [Q42's Google App Engine](https://github.com/Q42/play-gae)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-no-red.svg?style=flat) ](https://github.com/Q42/play-gae) 用于 Google App Engine 集成的维护模块. 应该使用而不是 [gae] 
* **[[playapps] ](http://www.playframework.com/modules/playapps) [playapps.net](http://github.com/zenexity/play-playapps)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/playapps) playapps.net 是一个简化的部署环境，旨在让您的 Play 应用程序快速高效地启动和运行 
* **[[反向代理]](http://www.playframework.com/modules/reverseproxy) [ReverseProxy](https://github.com/omaroman/reverseproxy)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/reverseproxy) 将您的应用程序配置为在前端后面使用时自动在每页的 HTTP 和 HTTPS 协议之间切换. 
* **[[路由器]](http://www.playframework.com/modules/router) [Play Router Annotations](https://github.com/digiPlant/play-router-annotations)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/router)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.router/play-router) 通过注释添加路由，允许您在控制器中声明您的路由. 
* **[[stax] ](http://www.playframework.com/modules/stax) [Stax](http://github.com/erwan/playstax)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/stax) 轻松部署到 Stax 云托管平台 (http://www.stax.net). 
* **[[vhost] ](http://www.playframework.com/modules/vhost) [VHost](https://github.com/lyubo/play-vhost)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/vhost) 添加一些虚拟主机功能，为每个虚拟主机提供单独的数据源和可自定义的应用程序设置. 

### Injection/dependencies 

* **[[constretto]](http://www.playframework.com/modules/constretto) [Constretto](https://github.com/zapodot/constretto-play)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/constretto)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.constretto/play-constretto) 使与 Constretto 配置框架的集成变得容易 
* **[[guice] ](http://www.playframework.com/modules/guice) [Guice](http://github.com/pk11/play-guice-module)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/guice)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.guice/play-guice) 将 Guice 管理的组件注入您的应用程序. 
* **[[ivy] ](http://www.playframework.com/modules/ivy) [Ivy dependency management](http://github.com/pk11/play-ivy)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/ivy) 使用 apache ivy 管理您的依赖项. 
* **[[maven] ](http://www.playframework.com/modules/maven) [Maven dependency management](http://github.com/wangyizhuo/play-maven)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/maven) 使用 apache maven 管理你的依赖 
* **[[弹簧]](http://www.playframework.com/modules/spring) [Spring](http://github.com/pepite/Play--framework-Spring-module)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/spring)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat) ](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.spring/play-spring) 允许在你的游戏中使用 Spring 管理的 bean！  1.x 应用程序. 

### Language 

* **[[googleclosure] ](http://www.playframework.com/modules/googleclosure) [Google Closure](http://code.google.com/p/mandubian-play-google-closure/)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/googleclosure) 该模块旨在将 Google Closure 工具与 play! 集成. 
* **[[gwt] ](http://www.playframework.com/modules/gwt) [Google Web Toolkit](http://code.google.com/p/play-framework-gwt/)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/gwt) 该模块提供了一个帮助程序来简化 GWT UI 与作为应用程序服务器的 Play 的集成. 
* **[[gwt2] ](http://www.playframework.com/modules/gwt2) [GWT2](http://github.com/vbuzzano/play-gwt2)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/gwt2) 将 Play 与 GWT 集成 
* **[[scala] ](http://www.playframework.com/modules/scala) [Scala](http://www.playframework.com/modules/scala)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/scala)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.scala/play-scala) Play Scala 使您能够使用 Scala 语言为您的应用程序保持密钥Play 框架的属性 
* **[[scalagen] ](http://www.playframework.com/modules/scalagen) [Scala Gen](https://github.com/asinghal/Play-ScalaGen)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/scalagen) Play 的 Scala 代码生成器！ 框架 
* **[[scalasecure]](http://www.playframework.com/modules/scalasecure) [Scala secure](https://github.com/asinghal/Play-ScalaSecure)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/scalasecure) 该模块为用 Scala 编写的 Play 应用程序提供基本的安全性（身份验证/授权）. 

### Messaging/events 

* **[[喜欢]](http://www.playframework.com/modules/like) [Akka support](http://github.com/dwhitney/akka)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/akka) 允许您配置 [akka](http://akkasource.org) 通过玩！ 框架的 conf/application.conf 文件. 
* **[[骆驼]](http://www.playframework.com/modules/camel) [Camel](https://github.com/marcuspocus/play-camel)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/camel) Play 的 EIP + 消息模块！ 框架 
* **[[推杆]](http://www.playframework.com/modules/pusher) [Pusher](https://github.com/regisbamba/Play-Pusher)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/pusher) 这个模块可以让你轻松地为你的 Play 应用程序添加实时功能 [Pusher](http://www.pusher.com) 使用网络套接字. 
* **[[rabbitmq] ](http://www.playframework.com/modules/rabbitmq) [RabbitMQ](http://geeks.aretotally.in/rabbitmq-module-for-play-framework)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/rabbitmq) RabbitMQ 提供了一个高度可用、可扩展且轻量级的消息传递系统. 

### Monitoring 

* **[[访问日志]](http://www.playframework.com/modules/accesslog) [Accesslog](https://github.com/briannesbitt/play-accesslog)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/accesslog)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.accesslog/play-accesslog) 一个 Play 框架模块，它执行类似于访问日志文件的请求日志记录在 nginx 或 apache 中. 
* **[[betterlogs] ](http://www.playframework.com/modules/betterlogs) [BetterLogs](https://github.com/sgodbillon/BetterLogs)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/betterlogs) 增强默认日志，添加类和方法名称、调用日志的位置、签名、文件名和行. 
* **[[信息播放]](http://www.playframework.com/modules/infoplay) [InfoPlay](http://code.google.com/p/infoplay/)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/infoplay) InfoPlay 是一个提供许多信息的模块，例如PHP 语言的infophp. 
* **[[jpastats] ](http://www.playframework.com/modules/jpastats) [Jpastats](https://github.com/eamelink/play-jpastats/)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/jpastats) 记录一次请求中执行了多少数据库查询 
* **[[log4play] ](http://www.playframework.com/modules/log4play) [Log4Play](https://github.com/feliperazeek/log4play)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/log4play) 提供一个 log4j appender，它将日志条目发布到 EventStream 
* **[播放休眠统计]  [Hibernate statistics](https://github.com/francisdb/play-hibernate-statistics)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-no-red.svg?style=flat)](https://github.com/francisdb/play-hibernate-statistics) 显示 MBean Hibernate 统计信息 
* **[[播放错误]](http://www.playframework.com/modules/playerrors) [Playerrors](https://github.com/marius0/playerrors)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/playerrors) Playerrors 收集并通知您有关生产网络应用程序中的错误，因此您可以在访问者有机会抱怨之前修复它们 
* **[分析器]  [Mini-profiler](https://github.com/PerfectCarl/play-profiler)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-no-red.svg?style=flat)](https://github.com/PerfectCarl/play-profiler) 在您的应用程序中显示一个迷你分析器 
* **[[记录跟踪]](http://www.playframework.com/modules/recordtracking) [RecordTracking](https://github.com/omaroman/recordtracking)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/recordtracking) RecordTracking unobtrusively tracks the creation, updating and elimination events regarding to records. 
* **[[statsd] ](http://www.playframework.com/modules/statsd) [Statsd](https://github.com/rkroll/play-statsd/)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/statsd) 该模块是对 [StatsD](https://github.com/etsy/statsd) 这允许从游戏中进行死的简单统计聚合. 

### Persistence 

* **[[协会]](http://www.playframework.com/modules/associations) [Associations](https://github.com/pareis/play-associations)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/associations)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.associations/play-associations) 该模块减少了管理双向关联的代码. 
* **[[奶油]](http://www.playframework.com/modules/cream) [JCR for Play!](https://github.com/mfornos/Cream)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/cream) Apache Jackrabbit(JCR 2.0) 与 Play 框架无缝集成的模块 
* **[[ebean] ](http://www.playframework.com/modules/ebean) [EBean ORM support](https://github.com/lyubo/play-ebean)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/ebean)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat) ](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.ebean/play-ebean) 添加 Ebean ORM 播放！. 仍处于非常实验阶段. 
* **[[mongo] ](http://www.playframework.com/modules/mongo) [MongoDB](http://github.com/louth/play-mongo)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/mongo) 为使用存储在 mongodb 中的模型提供了一个简单、优雅的解决方案. 对于更复杂的用例，请查看吗啡模块. 
* **[[吗啡]](http://www.playframework.com/modules/morphia) [MongoDB Integration](http://github.com/greenlaw110/play-morphia)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/morphia)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.morphia/play-morphia)[![Updated since the play module registry was frozen](http://img.shields.io/badge/ -updated-ff69b4.svg?style=flat)](http://github.com/greenlaw110/play-morphia) Seamlessly MongoDB access integration with Play’s Model interface. 
* **[[mybatisplay] ](http://www.playframework.com/modules/mybatisplay) [MyBatisPlay](https://github.com/eamelink/play-navigation/wiki)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/mybatisplay) 提供对MyBatis持久化框架的支持. 
* **[[neo4j] ](http://www.playframework.com/modules/neo4j) [logisima-neo4j](https://github.com/sim51/logisima-play-neo4j)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/neo4j) 将neo4j数据库集成到你的游戏中！ 项目. 
* **[[对象化]](http://www.playframework.com/modules/objectify) [Objectify](http://code.google.com/p/play-framework-objectify/)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/objectify) Objectify 是 Google App Engine/J 上的灵活抽象，它使数据访问变得简单而优雅 
* **[[orientdb] ](http://www.playframework.com/modules/orientdb) [OrientDB](https://github.com/mfornos/orientdb)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/orientdb) OrientDB for Play！ 框架 
* **[[redis] ](http://www.playframework.com/modules/redis) [Redis](https://github.com/tkral/play-redis)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/redis)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat) ](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.redis/play-redis) Redis 游戏！ 模块可帮助您轻松地在 Play 中使用 Redis！ 应用程序 
* **[[riak] ](http://www.playframework.com/modules/riak) [Riak](https://github.com/julienba/play-riak/)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/riak) 允许在游戏中使用 riak-java-client！ 方式. 
* **[[s3blobs] ](http://www.playframework.com/modules/s3blobs) [S3Blobs](https://github.com/jamesward/S3-Blobs-module-for-Play)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/s3blobs) S3Blobs Play 框架模块提供了一种从 JPA 实体中从 Amazon S3 读取和写入文件的简单方法. 
* **[[锡耶纳]](http://www.playframework.com/modules/siena) [Siena](http://github.com/mandubian/play-siena)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/siena)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.siena/play-siena)[![Updated since the play module registry was frozen](http://img.shields.io/badge/ -updated-ff69b4.svg?style=flat)](http://github.com/mandubian/play-siena) 使 Siena 支持能够将您的 Java 实体从您的游戏应用程序映射到 GAE/MySQL/PostgreSQL/H2 
* **[[树枝]](http://www.playframework.com/modules/twig) [Twig](https://github.com/netmau5/Play-Twig)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/twig) Twig 为 Google App Engine 的 Play 应用程序数据存储提供超级支持. 立即获得流畅的 API、内存中连接和异步查询. 

### Presentation 

* **[[咖啡]](http://www.playframework.com/modules/coffee) [CoffeeScript](https://github.com/robfig/play-coffee)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/coffee)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat) ](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.coffee/play-coffee) CoffeeScript 是生成 javascript 的好方法. 该模块为其提供支持（Java 和 Scala）. 
* **[[excel] ](http://www.playframework.com/modules/excel) [Excel](http://github.com/greenlaw110/play-excel)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/excel)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.excel/play-excel) 基于模板的 Excel 报告生成器 
* **[[formee] ](http://www.playframework.com/modules/formee) [Formee](https://github.com/omaroman/formee)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/formee) 帮助编写表单并添加客户端和服务器端验证. 
* **[[greenscript] ](http://www.playframework.com/modules/greenscript) [Minimize javascript/css files](http://github.com/greenlaw110/greenscript)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/greenscript) 玩你的 javascript/css 文件！ 
* **[[html5validation] ](http://www.playframework.com/modules/html5validation) [HTML5 Validation](https://github.com/oasits/play-html5-validation)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/html5validation) 基于使用 HTML5 属性的 Play 框架模型注释的客户端表单验证. 
* **[[jqueryui] ](http://www.playframework.com/modules/jqueryui) [Jqueryui](https://github.com/lunatech-labs/play-module-jqueryui)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/jqueryui) jQuery UI 模块提供了 jQuery UI 小部件的工作示例，与 Play 应用程序集成. 
* **[[jqvalidate] ](http://www.playframework.com/modules/jqvalidate) [JQuery Validation](https://github.com/murz/play-jqvalidate)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/jqvalidate) 基于您的模型注释，通过 jQuery 进行客户端表单验证 
* **[[jqvalidation] ](http://www.playframework.com/modules/jqvalidation) [Jqvalidation](http://code.google.com/p/jqvalidate-play-framework/)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/jqvalidation) 用于验证的 jquery 库 API，支持 Ajax 验证（每个字段或每个表单） 
* **[[less] ](http://www.playframework.com/modules/less) [Less module](https://github.com/lunatech-labs/play-module-less)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/less)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.less/play-less) 转换 [less](http://lesscss.org/) to CSS, and handles error reporting in your Play application 
* **[[菜单]](http://www.playframework.com/modules/menu) [Menu](http://github.com/greenlaw110/play-menu)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/menu) 简化导航菜单的实施. 
* **[[导航]](http://www.playframework.com/modules/navigation) [Navigation](https://bitbucket.org/hlassiege/play-nemrod)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/navigation) 在您的 Play 应用程序中定义和显示导航菜单.  
* **[[分页]](http://www.playframework.com/modules/paginated) [Paginate](http://github.com/lmcalpin/Play--Paginate)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/paginate)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.paginate/play-paginate) A replacement for #{list} tags that allows for easy pagination. 
* **[[pdf] ](http://www.playframework.com/modules/pdf) [PDF module](http://github.com/pepite/play--pdf)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/pdf)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat) ](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.pdf/play-pdf) 从您的 HTML 模板呈现 PDF 文档. 此模块基于 YaHP 转换器库. 
* **[[pegdown] ](http://www.playframework.com/modules/pegdown) [PegDown Markdown](https://github.com/jagregory/play-pegdown)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/pegdown) 集成挂钩 [Markdown](https://github.com/sirthias/pegdown) 处理器与您的 Play 应用程序 
* **[[新闻]](http://www.playframework.com/modules/press) [Minimize javascript/css files](http://github.com/dirkmc/press)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/press) 一种 JavaScript、CSS 和 Less 最小化器，旨在对应用程序开发人员透明. 
* **[[sass] ](http://www.playframework.com/modules/sass) [Syntactically Awesome Stylesheets](http://github.com/guillaumebort/play-sass)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/sass)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat) ](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.sass/play-sass) Sass 让 CSS 再次变得有趣.  Sass 是 CSS，加上嵌套规则、变量、mixin 等等，所有这些都在一个简洁、可读的语法中.  
* **[[表格]](http://www.playframework.com/modules/table) [Table](https://github.com/julienrf/play-table)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/table)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.table/play-table) 简化在 HTML 表格中显示数据所需的代码. 
* **[[tabularasa]](http://www.playframework.com/modules/tabularasa) [Tabula Rasa](https://github.com/schaloner/tabula-rasa)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/tabularasa) Tabula Rasa 为视图中的用户自定义表格提供支持 
* **[[twitterbootstrap]](http://www.playframework.com/modules/twitterbootstrap) [Twitterbootstrap](http://www.playframework.com/modules/twitterbootstrap)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/twitterbootstrap) 捆绑了 twitter-bootstrap 样式包和 play less 插件，简化了 .less 文件版本（动态考虑更改）. 

### Rest 

* **[[球衣]](http://www.playframework.com/modules/jersey) [Jersey](https://bitbucket.org/psartini/play-jersey)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/jersey) 将 Jersey 集成到 Play 中！ 框架. 
* **[[resteasy] ](http://www.playframework.com/modules/resteasy) [RESTEasy Play! module](http://www.lunatech-labs.com/open-source/resteasy-play-module)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/resteasy) RESTEasy 游戏！ 模块允许您在 Play 中定义 JAX-RS RESTful Web 服务！ 使用 RESTEasy 的框架. 
* **[[resteasycrud] ](http://www.playframework.com/modules/resteasycrud) [RESTEasy CRUD module](http://www.lunatech-labs.com/open-source/resteasy-crud-play-module)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/resteasycrud) 游戏！  RESTEasy CRUD 模块，它允许您为给定模型自动生成 RESTful CRUD 资源 
* **[[招摇]](http://www.playframework.com/modules/swagger) [Swagger](https://github.com/wordnik/swagger-play)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/swagger) 为 REST API 创建一个自我记录的元描述，它允许代码生成、UI 沙箱和测试框架. 

### Scaffolding 

* **[[crudsiena]](http://www.playframework.com/modules/crudsiena) [CRUD for Siena](https://github.com/mandubian/play-crud-siena)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/crudsiena) 为您的 Siena 模型对象提供一个完全可用的 Web 界面，比默认 [crud] 模块具有更多功能.  
* **[[摩卡]](http://www.playframework.com/modules/mocha) [Mocha](https://bitbucket.org/blobsmith/mocha/overview)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/mocha) Play 的 mocha UI javascript 接口的实现！ 
* **[播放引导程序]  [Basic bootstrap scaffolding](https://github.com/phaus/play-bootstrap)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-no-red.svg?style=flat)](https://github.com/phaus/play-bootstrap) 创建基于 Bootstrap 的应用程序（源自默认 [scaffold] 模块）.  
* **[[脚手架]](http://www.playframework.com/modules/scaffold) [Scaffold](http://github.com/lmcalpin/Play--Scaffold)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/scaffold) 脚手架将生成基本脚手架，用于从您的 JPA 或 Senia 实体引导项目 

### Search 

* **[[弹性搜索]](http://www.playframework.com/modules/elasticsearch) [ElasticSearch](http://geeks.aretotally.in/play-framework-module-elastic-search-distributed-searching-with-json-http-rest-or-java)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/elasticsearch) Elastic Search 是一个基于 Apache Lucene 的分布式搜索解决方案. 该模块为快速开发提供了一个嵌入式弹性服务器实例. 
* **[[搜索]](http://www.playframework.com/modules/search) [Search](http://github.com/jfp/play-search/)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/search)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat) ](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.search/play-search) 搜索允许您对 JPA 模型具有基本的全文搜索功能. 它基于 Lucene. 

### Security 

* **[[浏览器]](http://www.playframework.com/modules/browsers) [BrowserID](https://github.com/orefalo/play-browserid)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/browserid) BrowserID 是一种实验性的新网站登录方式.  BrowserID 的目标是为用户和开发人员设计一些安全且简单的东西. 
* **[[cas]](http://www.playframework.com/modules/cas) [logisima-cas](http://github.com/sim51/logisima-play-cas)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/cas) 这个模块是 Play 的 CAS 客户端！ 应用. 
* **[[赌场]](http://www.playframework.com/modules/casino) [Casino](https://github.com/reyez/casino-play)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/casino) 该项目提供了一种将注册和密码恢复集成到您的项目中的简单方法 
* **[[锁舌] ](http://www.playframework.com/modules/deadbolt) [Deadbolt](https://github.com/schaloner/deadbolt)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/deadbolt)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.deadbolt/play-deadbolt) Deadbolt 是一种授权机制，用于定义对某些控制器方法或视图的一部分 
* **[[fbconnect] ](http://www.playframework.com/modules/fbconnect) [Facebook connect](https://github.com/murz/play-fbconnect)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/fbconnect) 轻松将基于 Facebook 的身份验证集成到任何 Play 框架应用程序中. 
* **[[力]](http://www.playframework.com/modules/force) [Force.com](https://github.com/jesperfj/play-force)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/force) 构建游戏！ 集成到 Force.com 的应用程序. 提供 OAuth 身份验证和 REST API 适配器. 
* **[[linkedin] ](http://www.playframework.com/modules/linkedin) [LinkedIn OAuth Authentication](http://geeks.aretotally.in/projects/play-framework-linkedin-module)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/linkedin) 轻松将 LinkedIn 的 OAuth 身份验证集成到您的 Play Framework 应用程序中 
* **[[oauth] ](http://www.playframework.com/modules/oauth) [OAuth Client](http://github.com/erwan/playoauthclient)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/oauth) 此模块提供连接到 OAuth 提供程序（例如 Twitter 或 Google）的工具. 
* **[[验证码]](http://www.playframework.com/modules/recaptcha) [Recaptcha](https://github.com/orefalo/play-recaptcha)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/recaptcha)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.recaptcha/play-recaptcha) 在您的应用程序中快速集成 reCaptcha.com 挑战-响应测试. 
* **[[securepermissions]](http://www.playframework.com/modules/securepermissions) [Secure Permissions](http://www.lunatech-labs.com/open-source/secure-permissions-play-module)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/securepermissions) 扩展默认安全模块以添加基于 Seam Framework 中的规则（基于 Drools 规则）的权限检查. 
* **[[securesocial] ](http://www.playframework.com/modules/securesocial) [SecureSocial](http://jaliss.github.com/securesocial/)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/securesocial)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.securesocial/play-securesocial) SecureSocial 允许您向与基于 OAuth1、OAuth2、OpenID 和 OpenID+OAuth 混合协议的服务 
* **[[shibboleth] ](http://www.playframework.com/modules/shibboleth) [Shibboleth](https://github.com/TAMULib/Shibboleth-play)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/shibboleth) 允许用户登录您的游戏！ 通过 Shibboleth 申请. 

### Template 

* **[[fastergt]](http://www.playframework.com/modules/fastergt) [Faster Groovy Templates](https://github.com/mbknor/faster-groovy-templates)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/fastergt)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.fastergt/play-fastergt) 用 GT-Engine 替换默认的 groovy 模板实现，它更快，使用更少的内存. 
* **[[japid] ](http://www.playframework.com/modules/japid) [Japid Template Engine](http://github.com/branaway/Japid)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/japid)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat) ](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.japid/play-japid) 一个基于纯 Java 的快速静态类型模板引擎，适用于 Play！ 框架版本 1.2.x. 
* **[[小胡子]](http://www.playframework.com/modules/mustache) [Mustache](https://github.com/murz/play-mustache)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/mustache) 允许您定义无逻辑的模板片段，可以在您的 Play 中使用服务器端！  JavaScript 中的视图和客户端. 
* **[[节奏]](http://www.playframework.com/modules/rhythm) [Rythm Template Engine](https://github.com/greenlaw110/play-rythm)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/rythm)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.rythm/play-rythm)[![Updated since the play module registry was frozen](http://img.shields.io/badge/ -updated-ff69b4.svg?style=flat)](https://github.com/greenlaw110/play-rythm) PlayRythm 是一个类似于 Razor 的模板引擎. 
* **[[升级]](http://www.playframework.com/modules/scalate) [Scalate](http://github.com/pk11/play-scalate)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/scalate) [Scalate](http://scalate.fusesource.org) 模板引擎支持.  
* **[[thymeleaf] ](http://www.playframework.com/modules/thymeleaf) [Thymeleaf](https://github.com/choreo/play-thymeleaf)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/thymeleaf) 播放框架模块使用 [Thymeleaf 2.0](http://www.thymeleaf.org/)  作为模板引擎. 

### Testing 

* **[[cobertura]](http://www.playframework.com/modules/cobertura) [Cobertura](http://github.com/julienba/play-cobertura)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/cobertura)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.cobertura/play-cobertura) 与 Cobertura 集成以计算测试访问代码的百分比（测试覆盖率）. 
* **[[httpmock] ](http://www.playframework.com/modules/httpmock) [HttpMock](http://github.com/zenexity/play--httpmock)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/httpmock) 缓存 WebService 请求以模拟它们，以克服连接问题（滞后、拒绝服务、HTTP 错误）以实现快速开发. 
* **[[mockito]](http://www.playframework.com/modules/mockito) [Mockito](https://github.com/eamelink/play-mockito)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/mockito)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.mockito/play-mockito) Mockito是一个mocking框架，味道真的不错 
* **[[qunit] ](http://www.playframework.com/modules/qunit) [QUnit](https://github.com/irregular-at/play-qunit)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/qunit)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat) ](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.qunit/play-qunit) QUnit 模块提供 JUnit Javascript 测试与 Play 的集成！ 框架. 
* **[[spocktests]](http://www.playframework.com/modules/spocktests) [Spock tests](http://github.com/peterlundberg/play-spock-tests)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/spocktests) 运行 [Spock](https://code.google.com/p/spock/) 规范并使用 groovy 的表现力编写 BDD 风格的测试（仍然包装为 junit）. 
* **[[springtester] ](http://www.playframework.com/modules/springtester) [spring tester](https://github.com/digiarnie/springtester)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/springtester)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.springtester/play-springtester) 编写可以自动神奇地注入模拟（使用 Mockito）到播放使用 spring 模块连接的应用程序. 
* **[[测试]](http://www.playframework.com/modules/tests) [Alternative Test module](https://github.com/GuyMograbi/play_test_module)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/tests) Play!Framework 的测试模块可帮助您更快地编写测试，是一种更简洁且可重用的方式. 
* **[[网络驱动]](http://www.playframework.com/modules/webdrive) [Webdrive](https://github.com/rkaippully/play-webdrive)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/webdrive)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.webdrive/play-webdrive) WebDrive 模块为 Play 框架提供 Selenium 2 测试支持 

### Translation 

* **[[i18ntools] ](http://www.playframework.com/modules/i18ntools) [I18ntools](http://github.com/naholyr/i18ntools)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/i18ntools) 该模块将添加一些工具，以便在您的 Play 中轻松使用 i18n！ 项目. 
* **[[消息]](http://www.playframework.com/modules/messages) [@messages](https://github.com/huljas/play-messages)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/messages)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.messages/play-messages) 模块消息提供了一个基于 Web 的工具来管理应用程序的本地化. 
* **[[nemrod] ](http://www.playframework.com/modules/nemrod) [Nemrod](https://github.com/sim51/logisima-play-neo4j)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/nemrod) 此模块有助于将翻译从您的应用程序自动导入和导出到 Nemrod 实例. 
* **[play-i18ned]  [Play-i18ned](https://github.com/phaus/play-i18ned)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-no-red.svg?style=flat)](https://github.com/phaus/play-i18ned) 从 Excel 工作表转换默认的 i18n 文件，反之亦然. 

### Misc 

* **[[bespin] ](http://www.playframework.com/modules/bespin) [Bespin online editor](http://github.com/erwan/playbespin)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/bespin) 允许您使用网络代码编辑器 bespin 直接在浏览器中编辑所有应用程序源. 
* **[[bhave] ](http://www.playframework.com/modules/bhave) [Bhave](http://bhave.org/)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/bhave) 集成 [bhave](http://bhave.org/)，一个基于 Web 的行为驱动开发 (BDD) 框架，用于 Web 应用程序，以一种时髦的方式完成！ 
* **[[奶酪]](http://www.playframework.com/modules/cheese) [Cheese](https://github.com/lmcalpin/Play--Cheese)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/cheese) 用于将您的应用程序与 CheddarGetter 订阅管理服务集成的简化 API. 
* **[[cms] ](http://www.playframework.com/modules/cms) [Cms](http://code.google.com/p/play-cms/)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/cms) 一个非常简单的嵌入式CMS 
* **[[外部配置]](http://www.playframework.com/modules/externalconfig) [External Config](https://github.com/rugbyhead/externalconfig)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat) ](http://www.playframework.com/modules/externalconfig) 允许轻松加载外部配置/属性文件. 这允许轻松配置在战争中部署的应用程序. 
* **[[featureflags] ](http://www.playframework.com/modules/featureflags) [Feature Flags](http://code.google.com/p/play-featureflags)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/featureflags) 使您能够在应用程序中轻松使用标志，您可以使用管理屏幕在运行时打开和关闭这些标志. 
* **[[googlecheckout] ](http://www.playframework.com/modules/googlecheckout) [Google Checkout](https://github.com/jagregory/play-google-checkout)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/googlecheckout) 使您的 Play 应用程序能够作为商家与 Google Checkout 集成. 
* **[[gravatar]](http://www.playframework.com/modules/gravatar) [Gravatar](https://github.com/mbarbieri/play-gravatar)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/gravatar)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.gravatar/play-gravatar) 将 Gravatar 集成到您的 Play 应用程序中 
* **[[hazelcast] ](http://www.playframework.com/modules/hazelcast) [Hazelcast](https://github.com/marcuspocus/hazelcast)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/hazelcast)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.hazelcast/play-hazelcast) 从 Play 中替换 EhCacheImpl 或 MemcachedImpl 
* **[[邮戳]](http://www.playframework.com/modules/postmark) [Postmark](https://github.com/FrostDigital/play-postmark)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/postmark)[![mavenized](http://img.shields.io/badge/ -mavenized-blue.svg?style=flat)](http://mvnrepository.com/artifact/com.google.code.maven-play-plugin.org.playframework.modules.postmark/play-postmark) Postmark 模块提供与 postmarkapp.com 的轻松集成，用于处理外发电子邮件 
* **[[useragentcheck]](http://www.playframework.com/modules/useragentcheck) [UserAgentCheck](https://github.com/orefalo/play-useragentcheck)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-yes-green.svg?style=flat)](http://www.playframework.com/modules/useragentcheck) UserAgentCheck 会在用户的浏览器过时时显示横幅通知用户. 
* **[[play1-chart] ](http://sant0s.github.io/play1-chart/) [Play1-Chart](https://github.com/sant0s/play1-chart)** [![registered on playframework.com/modules](http://img.shields.io/badge/registered-no-red.svg?style=flat)](https://github.com/sant0s/play1-chart) 图表模块可以轻松生成图表图像. 

## Tools
*你知道每个玩家都应该使用的工具吗？ [Tell us!](https://github.com/PerfectCarl/awesome-play1/edit/master/README.md)*

## Resources

- [Mavenized modules](https://code.google.com/p/maven-play-plugin/wiki/MavenizedModules) 和 [how to use them](https://code.google.com/p/maven-play-plugin/wiki/Usage)
- [Using Play's controller](http://www.javabeat.net/using-controllers-in-play-framework/) 关于缓存、过期和 eTags 的精彩综述
- 使用 [Luo](https://github.com/greenlaw110)的`cache4` [annotation](http://www.playframework.com/modules/rythm-1.0.0-20121210/integration#cache4)

## License

[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [PerfectCarl](https://github.com/PerfectCarl) 已放弃该作品的所有版权和相关或邻接权.
